<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'gallery_managecats');
define('PP_SCRIPT', 'vBGallery');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_CATMANAGER',
	'ADV_GALLERY_CATMANAGER_ADDEDIT_CAT',
	'adv_gallery_catmanager_categorybits',
	'ADV_GALLERY_MODOPTS',
	'adv_gallery_conformation'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

$actiontemplates['none'] = &$actiontemplates['manage'];


// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!$galleryperms['cancreatecategories'] OR !$vbulletin->userinfo['userid'])
{
	print_no_permission();
}

if (empty($_REQUEST['do']))
{
  $_REQUEST['do'] = 'manage';
}

// ######################### Main Manage Cats Page ###########################
if ($_REQUEST['do'] == 'manage')
{
	$allowedparents = fetch_allowed_parents();

	$catcount = $db->query_first("SELECT COUNT(catid) AS count FROM " . TABLE_PREFIX . "ppgal_categories WHERE catuserid = '" . $vbulletin->userinfo['userid'] . "'");

	$categorybits = construct_phrase($vbphrase['you_have_used_x_out_of_y_categories_allowed'], $catcount['count'], iif($galleryperms['gallery_maxcats'], $galleryperms['gallery_maxcats'], $vbphrase['unlimited']));

	// Now print out the categories
	if ($catinfo = construct_categories($categorycache, 0, -1))
	{
		foreach ($catinfo AS $category)
		{
			if ($category['catuserid'] == $vbulletin->userinfo['userid'] OR in_array($category['catid'], $allowedparents))
			{
		    $dashes = str_repeat('--', $category['level']);
				$category['title'] = stripslashes($category['title']);
				eval('$categorybits .= "' . fetch_template('adv_gallery_catmanager_categorybits') . '";');
			}
		}
	}
	else
	{
		$categorybits .= $vbphrase['you_do_not_have_any_categories'];
	}

	$navbits[''] = $vbphrase['category_manager'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_CATMANAGER') . '");');
}
// ############################# Add / Edit Category #########################
if (in_array($_REQUEST['do'], array('addcat', 'editcat')))
{
	$defcatopts = unserialize($ppg_options['gallery_usercats_defaultopts']);
	$show['catopts'] = iif(in_array(2, array_values($defcatopts)), true);

	foreach ($defcatopts AS $varname => $value)
	{
		if ($value != 2)
		{
			$hiddenbits .= '<input type="hidden" name="useropts[' . $varname . ']" value="' . $defcatopts["$varname"] . '" />';
		}
	}

	if ($_REQUEST['do'] == 'editcat')
	{
		if (!$ppg_options['gallery_usercat_edit'])
		{
			print_no_permission();
		}
		$category = $db->query_first("SELECT catid, title, description, catuserid, parent, password, useroptions FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid'");

		if ($category['catuserid'] != $vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}

		$useropts = convert_bits_to_array($category['useroptions'], $catuseropts);

		foreach ($useropts AS $option => $value)
		{
			if ($value == 1)
			{
				$checked["$option"] = 'checked="checked"';
			}
		}
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$category[catid]"] = stripslashes($category['title']);
		$navbits[''] = $vbphrase['edit_category'];
	}
	else
	{
		// Check to see how many categories they've created
		if ($galleryperms['gallery_maxcats'])
		{
			$catcount = $db->query_first("SELECT COUNT(catid) AS count FROM " . TABLE_PREFIX . "ppgal_categories WHERE catuserid = '" . $vbulletin->userinfo['userid'] . "'");
			if ($catcount['count'] >= $galleryperms['gallery_maxcats'])
			{
				eval(standard_error(fetch_error('adv_gallery_too_many_categories', $galleryperms['gallery_maxcats'])));
			}
		}

		foreach ($catuseropts AS $option => $value)
		{
			$checked["$option"] = 'checked="checked"';
		}

		$navbits[''] = $vbphrase['add_category'];
	}

	$allowedparents = fetch_allowed_parents();

	$catoptions = print_cat_select($category['parent'], 'managecats');

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_CATMANAGER_ADDEDIT_CAT') . '");');
}

// ########################### Do Add / Edit Category #########################
if (in_array($_POST['do'], array('doaddcat', 'doeditcat')))
{
	$useropts = $vbulletin->input->clean_gpc('p', 'useropts', TYPE_ARRAY_STR);
	$category = $vbulletin->input->clean_gpc('p', 'category', TYPE_ARRAY_STR);

	$category['parent'] = intval($category['parent']);
	$category['catid'] = intval($category['catid']);
	$category['thisparent'] = intval($category['thisparent']);
	if (!$ppg_options['gallery_usercats_password'])
	{
		$category['password'] = '';
		$category['confirmpassword'] = '';
	}

	foreach (unserialize($ppg_options['gallery_usercats_defaultopts']) AS $varname => $value)
	{
		$useropts["$varname"] = iif($value == 2, $useropts["$varname"], $value);
	}

	if ($category['password'] != $category['confirmpassword'])
	{
		eval(standard_error(fetch_error('passwordmismatch')));
	}

	if (empty($category['title']))
	{
		eval(standard_error(fetch_error('adv_gallery_cant_have_category_without_title')));
	}

	if (empty($category['parent']))
	{
		eval(standard_error(fetch_error('adv_gallery_must_choose_parent_for_category')));
	}

	if (strlen($category['title']) > $ppg_options['gallery_usercat_titlemax'])
	{
		eval(standard_error(fetch_error('adv_gallery_title_too_long', vb_number_format(strlen($category['title'])), $ppg_options['gallery_usercat_titlemax'])));
	}

	if (strlen($category['description']) > $ppg_options['gallery_usercat_descmax'])
	{
		eval(standard_error(fetch_error('adv_gallery_description_too_long', vb_number_format(strlen($category['description'])), $ppg_options['gallery_usercat_descmax'])));
	}

	if ($category['parent'] == $category['catid'])
	{
		eval(standard_error(fetch_error('adv_gallery_cant_parent_category_self')));
	}

	require_once(DIR . '/includes/functions_misc.php');
	$useroptions = convert_array_to_bits($useropts, $catuseropts);

	// Editing the category
	if ($_POST['do'] == 'doeditcat')
	{
		$checkuser = $db->query_first("SELECT password, catuserid FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$category[catid]'");
		if ($checkuser['catuserid'] != $vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}

		if ($checkuser['password'] != $category['currentpass'] AND $category['password'])
		{
			eval(standard_error(fetch_error('adv_gallery_wrongpassword', $vbulletin->session->vars['sessionurl'], $category['catid'])));
		}
        $category['title_clean'] = htmlspecialchars_uni(str_replace('&amp;', '&', strip_tags($category['title'])));
        $category['description_clean'] = htmlspecialchars_uni(str_replace('&amp;', '&', strip_tags($category['description'])));

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET title = '" . addslashes(htmlspecialchars($category['title'])) . "', title_clean = '" . addslashes(htmlspecialchars($category['title_clean'])) . "', description = '" . addslashes(htmlspecialchars($category['description'])) . "', description_clean = '" . addslashes(htmlspecialchars($category['description_clean'])) . "', parent = '$category[parent]', " . iif($category['currentpass'], "password = '" . addslashes(htmlspecialchars($category['password'])) . "',") . " useroptions = '$useroptions' WHERE catid = '$category[catid]'");

		if ($category['parent'] != $category['thisparent'])
		{
			reconstruct_parents($category['catid']);
		}
	}
	else
	{
		// Else we're adding a category
		if ($galleryperms['gallery_maxcats'])
		{
			$catcount = $db->query_first("SELECT COUNT(catid) AS count FROM " . TABLE_PREFIX . "ppgal_categories WHERE catuserid = '" . $vbulletin->userinfo['userid'] . "'");
			if ($catcount['count'] >= $galleryperms['gallery_maxcats'])
			{
				eval(standard_error(fetch_error('adv_gallery_too_many_categories', $galleryperms['gallery_maxcats'])));
			}
		}

		if ($ppg_options['gallery_newcatsattop'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET displayorder = displayorder+1 WHERE parent = '$category[parent]'");
			$category['displayorder'] = 1;
		}
		else
		{
			$order = $db->query_first("SELECT MAX(displayorder) AS displayorder FROM " . TABLE_PREFIX . "ppgal_categories WHERE parent = '$category[parent]'");

			$category['displayorder'] = $order['displayorder'] + 1;
		}

		$parentcat = $db->query_first("SELECT catid, options, disext FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$category[parent]'");

		$catopts = construct_cat_opts($parentcat['catid'], $parentcat['options']);

		$catopts['open_for_images'] = 1;

		require_once(DIR . '/includes/functions_misc.php');
		$catoptions = convert_array_to_bits($catopts, $categoryopts);

	  $db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_categories (title, title_clean, description, description_clean, catuserid, parent, displayorder, hasimages, active, password, options, useroptions, disext) VALUES ('" . addslashes(htmlspecialchars($category['title'])) . "', '" . addslashes(htmlspecialchars($category['title_clean'])) . "','" . addslashes(htmlspecialchars($category['description'])) . "', '" . addslashes(htmlspecialchars($category['description_clean'])) . "','" . $vbulletin->userinfo['userid'] . "', '$category[parent]', '$category[displayorder]', 1, 1, '" . addslashes(htmlspecialchars($category['password'])) . "', '$catoptions', '$useroptions', '$parentcat[disext]')");

		$newcatid = $db->insert_id();

		insert_category_parentlist($category['parent']);

	}

	update_category_cache();

	$vbulletin->url = 'managecats.php?' . $vbulletin->session->vars['sessionurl'];
	eval(print_standard_redirect('adv_gallery_addednewcat'));
}

// ####################### Delete / Empty Category ############################
if (in_array($_REQUEST['do'], array('deletecat', 'emptycat')))
{
	$catid = intval($catid);

	$cat = $db->query_first("SELECT catid, title, catuserid, parentlist FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid'");

	if (!$cat['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'])));
	}

	$cat['title'] = stripslashes($cat['title']);

	if ($cat['catuserid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$itemname = 'catid';
	$itemid = $cat['catid'];
	$formaction = 'managecats';
	$dovalue = 'do' . $_REQUEST['do'];
	$itemtitle = $cat['title'];

	$navbits = construct_dir_navbits($cat['parentlist']);

	if ($_REQUEST['do'] == 'emptycat')
	{
		if (!$ppg_options['gallery_usercats_empty'])
		{
			print_no_permission();
		}
		$titlephrase = $vbphrase['empty_category'];
		$buttonphrase = $vbphrase['empty'];
		$confirmphrase = $vbphrase['are_you_sure_empty_category'];
		$navbits[''] = $vbphrase['empty_category'];
		$navname = $vbphrase['empty_category'];
	}
	else
	{
		if (!$ppg_options['gallery_usercats_delete'])
		{
			print_no_permission();
		}
		$titlephrase = $vbphrase['remove_category'];
		$buttonphrase = $vbphrase['delete'];
		$confirmphrase = $vbphrase['are_you_sure_delete_category'];
		$navbits[''] = $vbphrase['remove_category'];
		$navname = $vbphrase['remove_category'];
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('$content = "' . fetch_template('adv_gallery_conformation') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_MODOPTS') . '");');
}

// ####################### Do Delete / Empty Category #########################
if (in_array($_POST['do'], array('dodeletecat', 'doemptycat')))
{
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);
	$doaction = $vbulletin->input->clean_gpc('p', 'doaction', TYPE_INT);

	if (!$_POST['doaction'])
	{
		eval(standard_error(fetch_error('adv_gallery_nodelete')));
	}

	$cat = $db->query_first("SELECT catid, title, catuserid, parentlist FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid'");

	$cat['title'] = stripslashes($cat['title']);

	if (!$cat['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'])));
	}

	if ($cat['catuserid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->url = 'managecats.php?' . $vbulletin->session->vars['sessionurl'];

	if ($_POST['do'] == 'doemptycat')
	{
		if (!$ppg_options['gallery_usercats_empty'])
		{
			print_no_permission();
		}
		empty_category($catid);
		eval(print_standard_redirect('adv_gallery_category_emptied'));
	}
	else
	{
		if (!$ppg_options['gallery_usercats_delete'])
		{
			print_no_permission();
		}
		delete_category($catid);
		eval(print_standard_redirect('adv_gallery_category_deleted'));
	}
}

?>