<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'gallery_misc');
define('PP_SCRIPT', 'vBGallery');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('messaging');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
    'ADV_GALLERY_MYSTUFF',
    'ADV_GALLERY_REPORT',
	'ADV_GALLERY_EMAILIMAGE',
	'ADV_GALLERY_PRINTIMAGE',
    'newpost_usernamecode',
	'ADV_GALLERY_SHOWIMAGE_RATINGS',
	'adv_gallery_showimage_ratingbits',
	'ADV_GALLERY_SLIDESHOW',
	'ADV_GALLERY_SLIDESHOW_START',
	'smiliepopup',
	'smiliepopup_category',
	'smiliepopup_row',
	'smiliepopup_smilie',
	'smiliepopup_straggler'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

($hook = vBulletinHook::fetch_hook('ppgal_misc_start')) ? eval($hook) : false;

if (empty($_REQUEST['do']))
{
	eval(standard_error(fetch_error('invalid_action')));
}

// Add / Remove Favorite
if (in_array($_REQUEST['do'], array('addfav', 'removefav')))
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_fav')) ? eval($hook) : false;

	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$return = $vbulletin->input->clean_gpc('r', 'return', TYPE_NOHTML);

	if (!$vbulletin->userinfo['userid'] OR !$ppg_options['gallery_allowfav'])
	{
		print_no_permission();
	}

	$adv_sort_url = construct_adv_sort_url();

	$vbulletin->url = iif($return == 'favorites', 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'do=favorites', 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid . $adv_sort_url);

	$image = $db->query_first("SELECT imageid, catid, title FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");

	check_image_id($image['imageid']);

	check_image_view($image, 'showimage');

	$image['title'] = stripslashes($image['title']);

	if ($_REQUEST['do'] == 'removefav')
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_favorites WHERE userid = '" . $vbulletin->userinfo['userid'] . "' AND imageid = '$imageid'");

		eval(print_standard_redirect('adv_gallery_removedfav'));
	}
	else
	{
		$checkfav = $db->query_first("SELECT imageid FROM " . TABLE_PREFIX . "ppgal_favorites WHERE userid = '" . $vbulletin->userinfo['userid'] . "' AND imageid = '$imageid'");

		if (!$checkfav['imageid'])
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_favorites (userid, imageid) VALUES ('" . $vbulletin->userinfo['userid'] . "', '$imageid')");
		}
		eval(print_standard_redirect('adv_gallery_addedfav'));
	}
}

// #################### Subscriptions #############################
if (in_array($_REQUEST['do'], array('subscribe', 'unsubscribe')))
{
	
($hook = vBulletinHook::fetch_hook('ppgal_misc_subscribe')) ? eval($hook) : false;

	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);
	$return = $vbulletin->input->clean_gpc('r', 'return', TYPE_NOHTML);
	$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_INT);

	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	if ($type == 'cat')
	{
		$type = 'cat';
		$subid = intval($catid);
		$subfield = 'catid';
		$cat = $db->query_first("SELECT catid, title FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$subid'");

		$catperms = fetch_category_perms($cat['catid']);

		if (!$catperms['canviewgallery'])
		{
			print_no_permission();
		}

		check_category_password($cat['catid'], true);

		$subname = stripslashes($cat['title']);
	}
	else
	{
		$image = $db->query_first("SELECT imageid, title, catid FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");

		check_image_id($image['imageid']);
		check_image_view($image);
		$type = 'image';
		$subfield = 'imageid';
		$subid = $imageid;
		$subname = stripslashes($image['title']);
	}

	$adv_sort_url = construct_adv_sort_url();

	if ($_REQUEST['do'] == 'unsubscribe')
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_subscribe$type WHERE userid = '" . $vbulletin->userinfo['userid'] . "' AND $subfield = '$subid'");

		eval(print_standard_redirect('adv_gallery_removedsubscription'));
	}
	else
	{
		if($type == 'cat')
		{
			$query['anduserid'] = 'AND catuserid = \'' . $userid . '\'';
			$query['fields'] = ', catuserid';
			$query['values'] = ', \'' . $userid . '\'';
		}

		$checksub = $db->query_first("SELECT $subfield FROM " . TABLE_PREFIX . "ppgal_subscribe$type WHERE userid = '" . $vbulletin->userinfo['userid'] . "' AND $subfield = '$subid' $query[anduserid]");

		if (!$checksub["$subfield"])
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_subscribe$type (userid, $subfield $query[fields]) VALUES ('" . $vbulletin->userinfo['userid'] . "', '$subid' $query[values])");
		}
		eval(print_standard_redirect('adv_gallery_addedsubscription'));
	}
}

// ############################## Print Image ##################################
if ($_REQUEST['do'] == 'printimage')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_print_start')) ? eval($hook) : false;

	$posts = $vbulletin->input->clean_gpc('r', 'posts', TYPE_INT);

	$image = $db->query_first("
			SELECT imageid, images.catid, images.title, extension, images.description, filename, userid, width, height, categories.title AS cattitle, options
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (images.catid = categories.catid)
			WHERE imageid = '$imageid'
	");

	check_image_view($image);

	$catopts = construct_cat_opts($image['catid'], $image['options']);

	$image['title'] = stripslashes($image['title']);

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	$image['description'] = $bbcode_parser->do_parse(stripslashes($image['description']), $catopts['allow_desc_html'], $catopts['allow_desc_smilies'], $catopts['allow_desc_bbcode'], $catopts['allow_desc_bbimgcode']);
	$image['url'] = construct_image_url($image, 'filename');
	$image['cattitle'] = stripslashes($image['cattitle']);

	if ($posts AND $catperms['canviewreplies'])
	{
		$getposts = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$imageid' ORDER BY dateline");
		while ($post = $vbulletin->db->fetch_array($getposts))
		{
			$post['postdate'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
			$post['posttime'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
			$post['message'] = $bbcode_parser->parse($post['pagetext'], 'nonforum', true) . $post['signature'];

			eval('$postbits .= "' . fetch_template('printthreadbit') . '";');
		}
	}
($hook = vBulletinHook::fetch_hook('ppgal_misc_print_complete')) ? eval($hook) : false;

	eval('print_output("' . fetch_template('ADV_GALLERY_PRINTIMAGE') . '");');
}

// ###################### Do Send to Friend ########################
if ($_POST['do'] == 'dosendtofriend')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_dosend_friend')) ? eval($hook) : false;

	$sendtoname = $vbulletin->input->clean_gpc('p', 'sendtoname', TYPE_NOHTML);
	$sendtoemail = $vbulletin->input->clean_gpc('p', 'sendtoemail', TYPE_NOHTML);
	$subject = $vbulletin->input->clean_gpc('p', 'subject', TYPE_NOHTML);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_NOHTML);
	$orderby = $vbulletin->input->clean_gpc('p', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('p', 'direction', TYPE_NOHTML);

	if (!$sendtoname OR !$sendtoemail OR !$subject OR !$message OR !$imageid)
	{
		eval(standard_error(fetch_error('requiredfields')));
	}

	vbmail($sendtoemail, $subject, $message);

	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid;
	eval(print_standard_redirect('adv_gallery_emailsent'));
}

// ###################### Email Friend #########################
if ($_REQUEST['do'] == 'emailimage')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_email_image')) ? eval($hook) : false;

	$return = $vbulletin->input->clean_gpc('r', 'return', TYPE_NOHTML);

	$image = $db->query_first("
			SELECT imageid, images.title, images.catid, categories.title AS catttile, parentlist
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			WHERE imageid = '$imageid'
	");

	check_image_view($image);

	$image['title'] = stripslashes($image['title']);
	$unhtml_imagetitle = unhtmlspecialchars(stripslashes($image['title']));

	$unhtml_username = stripslashes($vbulletin->userinfo['username']);

	$navbits = construct_dir_navbits($image['parentlist']);

	$navbits['showimage.php?' . $vbulletin->session->vars['sessionurl'] . "imageid=$imageid"] = $image['title'];
	$navbits[''] = $vbphrase['email_image'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_EMAILIMAGE') . '");');
}

// ########################### Do Report ###########################
if ($_POST['do'] == 'doreport')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_do_report')) ? eval($hook) : false;

	$imageid = $vbulletin->input->clean_gpc('p', 'imageid', TYPE_INT);
	$postid = $vbulletin->input->clean_gpc('p', 'postid', TYPE_INT);
	$reason = $vbulletin->input->clean_gpc('p', 'reason', TYPE_NOHTML);

	if (isset($postid) AND $postid != 0)
	{
		$cat = $db->query_first("
				SELECT images.title, parentlist
				FROM " . TABLE_PREFIX . "ppgal_posts AS posts
				INNER JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
				INNER JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
				WHERE images.imageid = '$imageid'
		");

		$phrasetoget = 'adv_gallery_reportpost';
	}
	else
	{
		$cat = $db->query_first("
				SELECT images.title, parentlist
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				INNER JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
				WHERE imageid = '$imageid'
		");

		$phrasetoget = 'adv_gallery_reportimage';
	}

    if (!$ppg_options['gallery_reportforum']){

	$mailmods = array();

	if ($cat['parentlist'])
	{
		$moderators = $db->query_read("SELECT userid FROM " . TABLE_PREFIX . "ppgal_moderator WHERE catid IN($cat[parentlist])");
		while ($moderator = $vbulletin->db->fetch_array($moderators))
		{
			$mailmods[] = $moderator['userid'];
		}
	}

	if (empty($mailmods))
	{
		$admins = $db->query_read("
			SELECT userid
			FROM " . TABLE_PREFIX . "user AS user
			INNER JOIN " . TABLE_PREFIX . "usergroup USING (usergroupid)
			WHERE adminpermissions != 0
		");

		while ($admin = $vbulletin->db->fetch_array($admins))
		{
			$mailmods[] = $admin['userid'];
		}
	}
	if (!empty($mailmods))
	{
		$mailmods = implode(',', $mailmods);

		$users = $db->query_read("SELECT email FROM " . TABLE_PREFIX . "user WHERE userid IN($mailmods)");
		while ($user = $vbulletin->db->fetch_array($users))
		{
			eval(fetch_email_phrases($phrasetoget));
			vbmail($user['email'], $subject, $message);
		}
	}
    }else{
        $report_foruminfo = fetch_foruminfo($ppg_options['gallery_reportforum']);

      	if (isset($postid) AND $postid != 0){
          $newpost = array(
        	'emailupdate' => 9999,
        	'userid' => $vbulletin->userinfo['userid'],
        	'username' => $vbulletin->userinfo['username'],
        	'title' => $vbphrase['reported_comment_title'] . $cat['title']
          );
          eval('$newpost[message] = "' . fetch_template('adv_gallery_report_post') . '";');
        }else{
          $newpost = array(
        	'emailupdate' => 9999,
        	'userid' => $vbulletin->userinfo['userid'],
        	'username' => $vbulletin->userinfo['username'],
        	'title' => $vbphrase['reported_image_title'] . $cat['title']
          );
           eval('$newpost[message] = "' . fetch_template('adv_gallery_report_image') . '";');
        }

      require_once(DIR . '/includes/functions_newpost.php');
      build_new_post('thread', $report_foruminfo, array(), array(), $newpost, $errors);
    }
	$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid;
	eval(print_standard_redirect('redirect_reportthanks'));
}

// ######################## Report To Moderator ####################
if ($_REQUEST['do'] == 'report')
{

if (!$vbulletin->userinfo['userid'])
{
     print_no_permission();
}

($hook = vBulletinHook::fetch_hook('ppgal_misc_report')) ? eval($hook) : false;

	$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_INT);
	$p = $vbulletin->input->clean_gpc('r', 'p', TYPE_INT);
	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);
	$return = $vbulletin->input->clean_gpc('r', 'imageid', TYPE_NOHTML);

	if (isset($p))
	{
		$postid = intval($p);
	}

	if (empty($type))
	{
		$type = 'image';
	}
	if ($type == 'image')
	{
		$image = $db->query_first("
				SELECT imageid, images.title, images.catid, categories.title AS cattitle, parentlist
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
				WHERE imageid = '$imageid'
		");
	}
	else
	{
		$image = $db->query_first("
				SELECT postid, images.title, images.imageid, images.catid, categories.title AS cattitle
				FROM " . TABLE_PREFIX . "ppgal_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
				LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
				WHERE postid = '$postid'
		");
	}

	check_image_view($image);

	$image['title'] = stripslashes($image['title']);
	$image['cattitle'] = stripslashes($image['cattitle']);

	eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

	$navbits = construct_dir_navbits($image['parentlist']);
	$navbits['showimage.php?' . $vbulletin->session->vars['sessionurl'] . "i=$imageid"] = $image['title'];
	$navbits[''] = $vbphrase['report_image'];
	$navbits = construct_navbits($navbits);

($hook = vBulletinHook::fetch_hook('ppgal_misc_report_complete')) ? eval($hook) : false;

    eval('$navbar = "' . fetch_template('navbar') . '";'); 
	 eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');
    eval('print_output("' . fetch_template('ADV_GALLERY_REPORT') . '");');
}

// ############################ Slideshow Options #############################
if ($_REQUEST['do'] == 'slideshow')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_slideshow_start')) ? eval($hook) : false;

	$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_INT);

	$catinfo = $db->query_first("SELECT catid, title, parentlist, password FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '" . intval($catid) . "'");

	if (!$catinfo['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'])));
	}

	check_category_password($catinfo['catid']);

	$navbits = construct_dir_navbits($catinfo['parentlist']);
	$navbits[''] = $vbphrase['view_slideshow'];
	$navbits = construct_navbits($navbits);

($hook = vBulletinHook::fetch_hook('ppgal_misc_slideshow_complete')) ? eval($hook) : false;

	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_SLIDESHOW_START') . '");');

}

// ############################### Slideshow ##################################
if ($_REQUEST['do'] == 'doslideshow')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_do_slideshow_start')) ? eval($hook) : false;

	$interval = $vbulletin->input->clean_gpc('r', 'interval', TYPE_INT);
	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$stop = $vbulletin->input->clean_gpc('r', 'stop', TYPE_INT);
	$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_INT);

	$catid = intval($catid);

	$catinfo = $db->query_first("SELECT catid, title, password FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid'");

	if (!$catinfo['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'])));
	}

	$categoryperms = fetch_category_perms($catinfo['catid']);

	if (!$categoryperms['canviewgallery'] OR !$categoryperms['canviewlargimage'])
	{
		print_no_permission();
	}

	check_category_password($catinfo['catid']);

	$catinfo['title'] = stripslashes($catinfo['title']);

	if (!$ppg_options['gallery_slideshowheader'])
	{
		$header = '';
	}

	$doorderby = construct_orderby();

	if ($doorderby == 'title' AND !$direction)
	{
		$direction = 'DESC';
	}

	// Direction
	if (in_array($direction, array('DESC', 'ASC')))
	{
		$condition['direction'] = $direction;
	}
	else
	{
		$condition['direction'] = $ppg_options['gallery_defdirection'];
	}

	if ($orderby == 'rating')
	{
		$votequery = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
	}

	if (!$imageid)
	{
		$getimageid = $db->query_first("SELECT $votequery imageid FROM " . TABLE_PREFIX . "ppgal_images AS images WHERE catid = '" . intval($catid) . "' ORDER BY $doorderby $direction");
		$imageid = $getimageid['imageid'];
	}

	$imagequery = 'AND catid = \'' . intval($catid) . '\'' . iif($userid, 'AND userid = \'' . $userid . '\'') . ' ORDER BY ' . $doorderby . ' ' . $direction;

	$counter = 0;
	$imagearray = array();
	$getids = $db->query_read("SELECT $votequery images.imageid FROM " . TABLE_PREFIX . "ppgal_images AS images $favquery WHERE valid = 1 $imagequery");
	while($prevnext = $vbulletin->db->fetch_array($getids))
	{
		$counter ++;
		$imagearray[] = $prevnext['imageid'];
	}

	$key = array_search($imageid, $imagearray);
	$nextimage = $imagearray[$key+1];
	$previmage = $imagearray[$key-1];

	$slideurl = 'misc.php?' . $vbulletin->session->vars['sessionurl'] . 'do=doslideshow&amp;catid=' . $catid . '&amp;orderby=' . $orderby . '&amp;direction=' . $direction . '&amp;interval=' . $interval . '&amp;userid=' . $userid . '&amp;i=';

	$prevurl = $slideurl . $previmage . '&amp;stop=' . $stop;
	$nexturl = $slideurl . $nextimage . '&amp;stop=' . $stop;
	$stopurl = $slideurl . $imageid . '&amp;stop=1';
	$playurl = $slideurl . $nextimage;

	if (isset($nextimage))
	{
		$slideshowurl = $nexturl;
	}
	else
	{
		$slideshowurl = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $catid;
	}

	$image = $db->query_first("SELECT imageid, title, description, userid, catid, filename, height, width, extension FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");

	$image['url'] = construct_image_url($image, 'filename', true);

	if (!$image['title'])
	{
		$image['title'] = $image['filename'];
	}

    $vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET views = views + 1 WHERE imageid = '$image[imageid]'");

($hook = vBulletinHook::fetch_hook('ppgal_misc_do_slideshow_complete')) ? eval($hook) : false;

	eval('print_output("' . fetch_template('ADV_GALLERY_SLIDESHOW') . '");');

}

// ################################# My Stuff #################################
if ($_REQUEST['do'] == 'mystuff')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_mystuff')) ? eval($hook) : false;

	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	$navbits[''] = $vbphrase['my_stuff'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');
	eval('print_output("' . fetch_template('ADV_GALLERY_MYSTUFF') . '");');

}

// ############################### Download File ##############################
if ($_REQUEST['do'] == 'downloadfile')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_download_file')) ? eval($hook) : false;

	$image = $db->query_first("SELECT imageid, userid, catid, filename, dateline FROM " . TABLE_PREFIX . "ppgal_images AS images WHERE imageid = '$imageid'");

	check_image_view($image);

	$filepath = fetch_folder_path($image) . '/' . $image['filename'];

	if ($fp = @fopen($filepath, "rb"))
	{
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s', TIMENOW) . ' GMT');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: no-cache');
		header('Content-Type: application/octet-stream');
		header('Content-Type: application/force-download', false);
		header('Content-Type: application/download', false);
		header('Content-Disposition: ' . iif (!strstr($HTTP_USER_AGENT, 'MSIE 5.5'), 'attachment;') . ' filename="' . $image['filename'] . '"');
		header("Content-transfer-encoding: binary\n");
		header("Content-length: " . filesize($filepath) . "\n");
		fpassthru($fp);
	}
	else
	{
		header('Location: ' . fetch_folder_url($image) . '/' . $image['filename']);
	}
}

// ########################### View Member Ratings ############################
if ($_REQUEST['do'] == 'viewratings')
{

($hook = vBulletinHook::fetch_hook('ppgal_misc_view_ratings')) ? eval($hook) : false;

	if (!$ppg_options['gallery_showuserratings'])
	{
		print_no_permission();
	}

	$getratings = $db->query_read("
			SELECT rate.userid, rate.rating, images.title, user.username
			FROM " . TABLE_PREFIX . "ppgal_rate AS rate
			LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (rate.imageid = images.imageid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (rate.userid = user.userid)
			WHERE rate.imageid = '$imageid'
			ORDER BY rating DESC
	");
	while ($rating = $vbulletin->db->fetch_array($getratings))
	{
		$bgclass = exec_switch_bg();
		$imagetitle = stripslashes($rating['title']);

        ($hook = vBulletinHook::fetch_hook('ppgal_misc_view_ratings_bit')) ? eval($hook) : false;

		eval('$ratingbits .= "' . fetch_template('adv_gallery_showimage_ratingbits') . '";');
	}

($hook = vBulletinHook::fetch_hook('ppgal_misc_view_ratings_complete')) ? eval($hook) : false;

	eval('print_output("' . fetch_template('ADV_GALLERY_SHOWIMAGE_RATINGS') . '");');
}

// ###################### Redirect to vB misc.php Smilies #####################
if ($_REQUEST['do'] == 'getsmilies')
{
	$editorid = $vbulletin->input->clean_gpc('r', 'editorid', TYPE_NOHTML);

    ($hook = vBulletinHook::fetch_hook('ppgal_misc_smiliespopup_start')) ? eval($hook) : false;

	$smilies = $db->query_read("
		SELECT smilietext AS text, smiliepath AS path, smilie.title, smilieid,
			imagecategory.title AS category
		FROM " . TABLE_PREFIX . "smilie AS smilie
		LEFT JOIN " . TABLE_PREFIX . "imagecategory AS imagecategory USING(imagecategoryid)
		ORDER BY imagecategory.displayorder, imagecategory.title, smilie.displayorder
	");

	$smcache = array();
	while ($smilie = $db->fetch_array($smilies))
	{
		$smcache["{$smilie['category']}"][] = $smilie;
	}

	$popup_smiliesbits = '';
	$bits = array();
	exec_switch_bg();
	foreach ($smcache AS $category => $smilies)
	{
		if (sizeof($bits) == 1)
		{
			eval('$smiliecells = "' . fetch_template('smiliepopup_straggler') . '";');
			eval('$smiliebits .= "' . fetch_template('smiliepopup_row') . '";');
		}

        ($hook = vBulletinHook::fetch_hook('ppgal_misc_smiliespopup_category')) ? eval($hook) : false;

		eval('$smiliebits .= "' . fetch_template('smiliepopup_category') . '";');
		$bits = array();
		foreach ($smilies AS $smilie)
		{

            ($hook = vBulletinHook::fetch_hook('ppgal_misc_smiliespopup_smilie')) ? eval($hook) : false;

			$smilie['js'] = addslashes_js($smilie['text']);
			$smiliehtml = "<img src=\"$smilie[path]\" id=\"smilie_$smilie[smilieid]\" alt=\"" . htmlspecialchars_uni($smilie['text']) . "\" title=\"$smilie[title]\" />";
			eval('$bits[] = "' . fetch_template('smiliepopup_smilie') . '";');
			if (sizeof($bits) == 2)
			{
				exec_switch_bg();
				$smiliecells = implode('', $bits);
				eval('$smiliebits .= "' . fetch_template('smiliepopup_row') . '";');
				$bits = array();
			}
		}
	}
	if (sizeof($bits) == 1)
	{
		eval('$smiliecells = "' . fetch_template('smiliepopup_straggler') . '";');
		eval('$smiliebits .= "' . fetch_template('smiliepopup_row') . '";');
	}

    ($hook = vBulletinHook::fetch_hook('ppgal_misc_smiliespopup_complete')) ? eval($hook) : false;

	eval('print_output("' . fetch_template('smiliepopup') . '");');

}

$vbulletin->input->clean_gpc('r', 'template', TYPE_NOHTML);

?>