<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
ini_set("memory_limit", "128M");
ini_set("max_execution_time", 0);
ini_set('post_max_size','30M');
ini_set('upload_max_filesize','30M');

error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'gallery_upload');
define('GET_IMGTYPE_ARRAY', true);
define('PP_SCRIPT', 'vBGallery');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'adv_gallery_upload'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_UPLOAD',
	'ADV_GALLERY_UPLOAD_APPROVE',
	'ADV_GALLERY_UPLOAD_EXTENSIONS',
	'adv_gallery_upload_approvebits',
	'adv_gallery_upload_extensionbits',
	'adv_gallery_nodisplay',
	'adv_gallery_upload_custombits'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_gallery_imageedit.php');
require_once(DIR . '/includes/functions_newpost.php');



// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'upload';
}

// ###### Start Uploading 
if ($_REQUEST['do'] == 'doupload')
{
	$images = $_POST['images'];

	$userfile = $vbulletin->input->clean_gpc('r', 'userfile', TYPE_ARRAY_STR);
	$imageinfo = $vbulletin->input->clean_gpc('r', 'imageinfo', TYPE_ARRAY_STR);
	$imageoptions = $vbulletin->input->clean_gpc('r', 'imageoptions', TYPE_ARRAY_STR);
	$server = $vbulletin->input->clean_gpc('r', 'server', TYPE_ARRAY_STR);
	$processfiles = $vbulletin->input->clean_gpc('r', 'processfiles', TYPE_ARRAY_STR);
	$doprocess = $vbulletin->input->clean_gpc('r', 'doprocess', TYPE_ARRAY_STR);
	$processedcatids = $vbulletin->input->clean_gpc('r', 'processedcatids', TYPE_ARRAY_STR);
	$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_INT);

	$massimageinfo['title'] = str_replace('&amp;', '&', $imageinfo['title']);
	$massimageinfo['catid'] = intval($imageinfo['catid']);
	$massimageinfo['description'] = str_replace('&amp;', '&', $imageinfo['description']);
	$massimageinfo['keywords'] = str_replace('&amp;', '&', $imageinfo['keywords']);
	$massimageinfo['asuser'] = str_replace('&amp;', '&', $imageinfo['asuser']);

	if (!$massimageinfo['catid'])
	{
		eval(standard_error(fetch_error('adv_gallery_must_choose_category')));
	}

	if (strlen($massimageinfo['description']) > $ppg_options['gallery_desclimit'])
	{
		eval(standard_error(fetch_error('adv_gallery_description_toolong', vb_number_format(strlen($massimageinfo['description'])), $ppg_options['gallery_desclimit'])));
	}

	if ($imageinfo['asuser'] AND $imageinfo['asuser'] != $vbulletin->userinfo['username'] AND ($galleryperms['canuploadasuser']))
	{
		$user = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes($imageinfo['asuser']) . "'");
		if (!$user['userid'])
		{
			eval(standard_error(fetch_error('adv_gallery_upload_invaliduser')));
		}
		$userid = $user['userid'];
		$username = $user['username'];
	}
	else
	{
		$userid = $vbulletin->userinfo['userid'];
		$username = $vbulletin->userinfo['username'];
	}
	$massimageinfo['userid'] = $userid;

	$catopts = construct_cat_opts($massimageinfo['catid'], $categorycache["$massimageinfo[catid]"]['options']);

	if ($catopts['allow_desc_links'])
	{
		$massimageinfo['description'] = convert_url_to_bbcode($massimageinfo['description']);
		$imageinfo['description'] = convert_url_to_bbcode($imageinfo['description']);
	}

	$folderstring = construct_folder_path($massimageinfo);

	$categoryperms = fetch_category_perms();

	$userinfo = $db->query_first("SELECT SUM(filesize) AS normal, SUM(originalfilesize) AS original FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = '$userid'");

	$userinfo['usedspace'] = $userinfo['normal'] + $userinfo['original'];

	$imageoptions['subscribe'] = intval($imageoptions['subscribe']);
	$imageoptions['favorite'] = intval($imageoptions['favorite']);

	if ($imageoptions['subscribe'])
	{
		$checked['subscribe'] = 'checked="checked"';
	}

	if ($imageoptions['favorite'])
	{
		$checked['favorite'] = 'checked="checked"';
	}

	$catoptions["$massimageinfo[catid]"] = fetch_adv_category_setting($massimageinfo['catid']);

	if (empty($processedcatids))
	{
		$processedcatids = array();
	}

	$filetypes = fetch_cat_ext_info();

	$nextpage = $page + 1;

	// Grab custom fields to display
	$custominfo = array();
	$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
	while ($field = $vbulletin->db->fetch_array($customfields))
	{
		$custominfo[] = $field;
	}
	$db->free_result($customfields);
	unset($field);

	// ######  Mass uploading from server
	if (!$page)
	{
		if ($server['upload'])
		{
			$processfiles = array();
			$errors = array();

			if (!($galleryperms['canuploadfromserver']))
			{
				print_no_permission();
			}

			$dir = $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'];

			if ($dh = @opendir($dir))
			{
				while (($file = readdir($dh)) !== false)
				{
					if ($file != '.' AND $file != '..')
					{
						$imagecount++;
						$imageinfo = fetch_image_info($dir . '/' . $file, $file, $ppg_options['gallery_insafemode']);
						$imageinfo['catid'] = $massimageinfo['catid'];
						$errors["$imageinfo[saveas]"] = check_upload_errors();
						@chmod($dir . '/' . $file, 0777);
						if (empty($errors["$imageinfo[saveas]"]))
						{
							$processfiles[] = $imageinfo['truename'];
						}
					}
				}
				closedir($dh);
			}
		}
		else
		{
			// ###################### Uploading Single File(s) ######################
			$server['process_number'] = $ppg_options['gallery_uploadinputs'];
			foreach ($_FILES AS $file)
			{
				if ($file['tmp_name'])
				{
					$gotfiles = true;
					$imageinfo = fetch_image_info($file['tmp_name'], $file['name'], $ppg_options['gallery_insafemode']);
					$imageinfo['catid'] = $massimageinfo['catid'];

					$errors["$imageinfo[saveas]"] = check_upload_errors();

					if (!empty($errors["$imageinfo[saveas]"]))
					{
						$show['errors'] = true;
					}
					else
					{
						$imagecount++;
						@move_uploaded_file($file['tmp_name'], $imageinfo['saveto'] . '/' . $imageinfo['saveas']);
						$processfiles[] = $imageinfo['saveas'];
					}
				}
			}

			if (!$gotfiles)
			{
				eval('$errors[\'\'][\'\'] = "' . fetch_error('upload_invalid_file') . '";');
			}
		}
	}

	// Print out any initial errors
	if (!empty($errors))
	{
		foreach ($errors AS $filename => $error)
		{
			if (!empty($error))
			{
				$show['errors'] = true;
				$uploaderrors .= '<tr><td class="thead">' . $filename . '</td></tr>';
				foreach ($error AS $varname => $text)
				{
					$uploaderrors .= '<tr><td class="alt1">' . $text . '</td></tr>';
				}
			}
		}
	}

	// Only got 1 file?
	if (!$page AND sizeof($processfiles) == 1 AND !$show['errors'])
	{
		$singlefile = true;
		$fname = implode('', $processfiles);
		$images["$fname"] = &$imageinfo;
		$doprocess = &$processfiles;

		$imageinfo = fetch_image_info(iif($server['upload'], $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'], $folderstring) . '/' . $filename, $filename);
		resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize']);

		$customfields = array();
		foreach ($custominfo AS $customfield)
		{
			$fieldvalue = $_POST["field$customfield[fieldid]"];
			unset($_POST["field$customfield[fieldid]"]);
			$_POST["field$customfield[fieldid]"]["$fname"] = $fieldvalue;
		}

		unset($processfiles);
	}

	// Process current approved images
	if (!empty($images))
	{
		if (!is_array($doprocess))
		{
			$doprocess = array();
		}
		foreach ($images AS $filename => $imageinfo)
		{
			$filename = stripslashes($filename);
			$imageinfo = fetch_image_info(iif($server['upload'], $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'], $folderstring) . '/' . $filename, $filename);

			$imageinfo['asuser'] = $massimageinfo['asuser'];
			if (in_array($filename, $doprocess))
			{
				$customfields = array();

				foreach ($custominfo AS $customfield)
				{
					$customfields["field$customfield[fieldid]"] = $_POST["field$customfield[fieldid]"]["$filename"];
				}

				$errors["$imageinfo[saveas]"] = check_upload_errors();

				if (!empty($errors["$imageinfo[saveas]"]))
				{
					@unlink($imageinfo['location']);
					@unlink($folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
				}
				else
				{
					if ($server['upload'])
					{
						@copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['saveas']);
						@unlink($imageinfo['location']);
						$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
					}

					if (empty($catoptions["$imageinfo[catid]"]))
					{
						$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
					}

					$newimageid = process_upload(true);
					$imagecount++;

                    $catemails = $db->query_read("
                        SELECT catid, title, newimageemail
                        FROM " . TABLE_PREFIX . "ppgal_categories
                        WHERE catid = '$imageinfo[catid]'
                        ");
                    while ($catemail = $vbulletin->db->fetch_array($catemails))
                    {
                        $catemailid = $catemail['catid'];
                        $catemailtitle = $catemail['title'];
                        $catemailaddy = $catemail['newimageemail'];
                    }

                    if (!in_array($imageinfo['catid'], $processedcatids))
					{
						if ($categoryperms["$imageinfo[catid]"]['moderateimages'] OR $ppg_options['gallery_newimageemail_all'])
						{
							$sendmailto = array();
							$optmailer = array();

							if (!empty($catemailaddy))
							{
								$sendmailto = explode(' ', $catemailaddy);
							}

							if ($ppg_options['gallery_newimageemail'])
							{
								$optmailer = explode(' ', $ppg_options['gallery_newimageemail']);
							}

							$sendmailto = array_merge((array)$optmailer, (array)$sendmailto);

							if (!empty($sendmailto))
							{
								$cattitle = stripslashes($categorycache["$imageinfo[catid]"]['title']);
								foreach ($sendmailto AS $email)
								{
									eval(fetch_email_phrases('adv_gallery_newupload'));
									vbmail(trim($email), $subject, $message);
								}
							}
						}
						$processedcatids[] = $imageinfo['catid'];
					}
				}
			}
			else
			{
				@unlink($imageinfo['location']);
				@unlink($folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
			}
		}
		unset($images, $imageinfo);
	}

	// Process new files
	if (!empty($processfiles))
	{
		$processcount = 0;
		$categoryselect = print_cat_select($massimageinfo['catid'], 'upload');
		$show['tablerows'] = true;

		if (!empty($custominfo))
		{
			foreach ($custominfo AS $customfield)
			{
			if (($page AND is_array($_POST['defaultfields']["field$customfield[fieldid]"])) OR !$page AND is_array($_POST["field$customfield[fieldid]"]))
                {
                    foreach (iif($page, $_POST['defaultfields']["field$customfield[fieldid]"], $_POST["field$customfield[fieldid]"]) AS $field => $value)
                    {
                        $hiddencustomvalues .= '<input type="hidden" name="defaultfields[field' . $customfield['fieldid'] . '][' . $field . ']" value="' . addslashes(htmlspecialchars($value)) . '" />';
                        
                    }
                }
                else
                {
                    $hiddencustomvalues .= '<input type="hidden" name="defaultfields[field' . $customfield['fieldid'] . ']" value="' . addslashes(htmlspecialchars(iif(!$page, $_POST["field$customfield[fieldid]"], $_POST['defaultfields']["field$customfield[fieldid]"]))) . '" />';
                }
			}
			unset($customfield);
		}

		foreach ($processfiles AS $file)
		{
			if ($processcount < $server['process_number'])
			{
				$processcount++;

				$imageinfo['catid'] = $massimageinfo['catid'];

				$imageinfo = fetch_image_info(iif($server['upload'], $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'], $folderstring) . '/' . $file, $file);

				// Do another error check if we have a page specified just to be safe
				if ($page)
				{
					$errors["$imageinfo[saveas]"] = check_upload_errors();

					if (!empty($errors["$imageinfo[saveas]"]))
					{
						@unlink($imageinfo['location']);
						@unlink($folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
					}
				}

				if (!$massimageinfo['title'])
				{
					$massimageinfo['title'] = htmlspecialchars($imageinfo['shortname']);
					$unsettitle = true;
				}

                $massimageinfo['title'] = str_replace("_", " ", $massimageinfo['title']);
                $massimageinfo['title'] = ucwords(strtolower($massimageinfo['title']));

				$_POST['defaultfields']['imageid'] = $file;
				$_POST['imageid'] = $file;
				$custombits = construct_custom_fieldbits(iif($page, $_POST['defaultfields'], $_POST), $custominfo, false, false, true);

				$imageinfo['userid'] = $userid;

				if (empty($catoptions["$imageinfo[catid]"]))
				{
					$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
				}

				$imageinfo = resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize']);

				$image['imageurl'] = construct_image_url($imageinfo, 'thumbname');

				$image['fullimageurl'] = iif($server['upload'], $ppg_options['gallery_userfolderurl'] . '/' . $vbulletin->userinfo['userid'], fetch_folder_url($imageinfo)) . '/' . $file;

				eval('$imagebits .= "' . fetch_template('adv_gallery_upload_approvebits') . '";');
				unset($imageinfo);
				if ($unsettitle)
				{
					$massimageinfo['title'] = '';
				}
			}
			else
			{
				$hiddenbits .= '<input type="hidden" name="processfiles[]" value="' . htmlspecialchars($file) . '" />';
			}
		}
	}
	else
	{
		$colspan = 3;
		eval('$imagebits = "' . fetch_template('adv_gallery_nodisplay') . '";');
	}

	if (!$server['upload'] AND empty($processfiles) AND !$show['errors'])
	{
		if ($categoryperms["$massimageinfo[catid]"]['moderateimages'])
		{
			eval(standard_error(fetch_error('adv_gallery_imageupload_approve', $vbulletin->session->vars['sessionurl'], $ppg_options['gallery_title'])));
		}
		else
		{
			if ($singlefile)
			{
				$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $newimageid . '&amp;c=' . $massimageinfo['catid'];
			}
			else
			{
				$vbulletin->url = 'browseimages.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $massimageinfo['catid'];
			}
			eval(print_standard_redirect('adv_gallery_imageuploaded_noapprove'));
		}
	}
	else
	{
		if ($singlefile)
		{
			$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $newimageid . '&amp;c=' . $imageinfo['catid'];
			eval(print_standard_redirect('adv_gallery_imageuploaded_noapprove'));
		}
		else
		{
			$navbits[''] = $vbphrase['upload_image'];
			$navbits = construct_navbits($navbits);
			eval('$navbar = "' . fetch_template('navbar') . '";'); 
			eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

			if (!empty($processedcatids))
			{
				foreach ($processedcatids AS $pcatid)
				{
					$hiddenbits .= '<input type="hidden" name="processedcatids[]" value="' . intval($pcatid) . '" />';
				}
			}

			eval('print_output("' . fetch_template('ADV_GALLERY_UPLOAD_APPROVE') . '");');
		}
	}
}

// ############################## Main Upload Page ############################
if ($_REQUEST['do'] == 'upload')
{
	$catoptions = print_cat_select($catid, 'upload');

	if (!$catoptions)
	{
		print_no_permission();
	}

	$usedspace = $db->query_first("SELECT SUM(filesize) AS normal, SUM(originalfilesize) AS original FROM " . TABLE_PREFIX ."ppgal_images WHERE userid = '" . $vbulletin->userinfo['userid'] . "'");

	$usedspace['total'] = $usedspace['normal'] + $usedspace['original'];

	if ($galleryperms['gallery_maxdiskspace'] == 0)
	{
		$spacelimit = $vbphrase['unlimited'];
		$spaceremaining = $vbphrase['unlimited'];
		$bar['spaceremaining'] = 100;
		$bar['spaceused'] = 1;
	}
	else
	{
		$spacelimit = vb_number_format($galleryperms['gallery_maxdiskspace'], 1, true);
		$spaceremaining = vb_number_format($galleryperms['gallery_maxdiskspace'] - $usedspace['total'], 1, true);

		$bar['spaceused'] = round(($usedspace['total'] / $galleryperms['gallery_maxdiskspace']) * 100);
		$bar['spaceremaining'] = 100 - $bar['spaceused'];
	}

	if ($bar['spaceused'] >= 75)
	{
		$bar['color'] = 'red';
	}
	else if ($bar['spaceused'] >= 50)
	{
		$bar['color'] = 'yellow';
	}
	else
	{
		$bar['color'] = 'green';
	}

	$spaceused = vb_number_format($usedspace['total'], 1, true);

	if (($galleryperms['canuploadasuser']))
	{
		$show['userupload'] = true;
	}

	if (($galleryperms['canuploadfromserver']))
	{
		$userdirectory = $ppg_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'];
		$show['serverupload'] = true;
	}

	$customfieldbits = construct_custom_fieldbits($_POST);

	for ($i = 0; $i < $ppg_options['gallery_uploadinputs']; $i++)
	{
		$uploadbits .= '<div><input class="bginput" type="file" size="50" name="userfile' . $i . '" /></div>';
	}

	$navbits[''] = $vbphrase['upload_image'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_UPLOAD') . '");');
}

// ########################## View Allowed Extensions #########################
if ($_REQUEST['do'] == 'viewextensions')
{
	require_once(DIR . '/includes/functions_gallery_imageedit.php');
	$categoryperms = fetch_category_perms();

	$filetypes = fetch_cat_ext_info();

	$bgclass = exec_switch_bg();

	foreach ($categorycache AS $cats)
	{
		if ($cats['catuserid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'])
		{
			$useroptions = construct_cat_user_opts($cats['catid'], $categorycache["$cats[catid]"]['useroptions']);
			if (!$useroptions['allow_upload'] OR !$useroptions['allow_view'])
			{
				continue;
			}
		}
		$catopts = construct_cat_opts($cats['catid'], $cats['options']);

		if ($cats['parent'] != 0 AND !$categorycache["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
		{
			$cats['active'] = 0;
			$categorycache["$cats[catid]"]['active'] = 0;
		}

		if ((!is_category_mod($cats['catid']) AND !$cats['active']) OR !$catopts['open_for_images'] OR !$categoryperms["$cats[catid]"]['canuploadimages'])
		{
			continue;
		}

		if ($cats['level'] > 1)
		{
	    $dashes = str_repeat('--', $cats['level'] - 1);
		}

		$cats['extensions'] = '';
		$extcount = 0;
		foreach ($filetypes["$cats[catid]"] AS $extension => $values)
		{
			if ($extcount == 2)
			{
				$bgclass = exec_switch_bg();
				$cats['extensions'] .= '</tr><tr>';
				$extcount = 0;
			}

			$extcount++;

			$cats['extensions'] .= '<td width="50%" class="' . $bgclass . '"><table width="100%" cellpadding="0" cellspacing="0"><td align="$stylevar[left]" class="smallfont" width="20%"><strong>' . $extension . '</strong></td><td class="smallfont" width="35%">' . iif($values['filesize'], vb_number_format($values['filesize'], 1, true), $vbphrase['unlimited']) . '</td><td class="smallfont">' . iif($values['width'] AND $values['height'], $values['width'] . ' x ' . $values['height'], $vbphrase['n_a']) . '</td></tr></table></td>';

		}

		if ($extcount AND $extcount != 2)
		{
			for ($i = $extcount; $i < 2; $i++)
			{
				$cats['extensions'] .= '<td class="' . $bgclass . '">';
			}
		}

		eval('$categorybits .= "' . fetch_template('adv_gallery_upload_extensionbits') . '";');
	}

	eval('print_output("' . fetch_template('ADV_GALLERY_UPLOAD_EXTENSIONS') . '");');
}

?>