<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('FORCE_HOOKS', true);
define('PRODUCT_CODE', 'ppvbgallery');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('plugins');

$specialtemplates = array('adv_gallery_opt');

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/class_hook.php');
require_once(DIR . '/includes/adminfunctions_plugin.php');
require_once(DIR . '/includes/adminfunctions_language.php');
require_once(DIR . '/includes/functions_gallery.php');
require_once(DIR . '/includes/adminfunctions_gallery.php');


// #############################################################################
// ########################### START MAIN SCRIPT ###############################
// #############################################################################

$scriptname = 'Photopost vBGallery';
$version = '2.4.3';
$scriptfile = 'vbgallery_install';

$ppg_options =& $vbulletin->adv_gallery_opt;


if (!$ppg_options){
$ppg_options = unserialize($vbulletin->adv_gallery_opt);
}

print_cp_header('' . $scriptname . ' Install', '', '<style type="text/css">
<!--
.redalert
{
	background: #FF0000;
	color: #000000;
}
-->
</style>');

if ($vbulletin->options['templateversion'] < '3.7')
{
	echo 'It appears that you are trying to install the vBulletin 3.7 version of ' . $scriptname . ' on an older version of vBulletin.';
	exit;
}

if (!is_object($db))
{
	echo 'It appears that you are trying to install the vBulletin 3.7 version of ' . $scriptname . ' on a vBulletin 3.0 forum.';
	exit;
}

if (empty($_REQUEST['do']))
{
  $_REQUEST['do'] = 'install';
}

// ##################### Insert Settings Function ADV #####################
function insert_setting_adv($title, $description, $varname, $value, $defaultvalue, $optioncode, $displayorder, $grouptitle, $phraseonly = 0, $printphrase = 0)
{
	global $db;

	$checksetting = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
	if ($checksetting['varname'])
	{
		return;
	}

	$db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "adv_setting (varname, grouptitle, value, defaultvalue, optioncode, displayorder) VALUES ('$varname', '$grouptitle', '" . addslashes($value) . "', '" . addslashes($defaultvalue) . "', '" . addslashes($optioncode) . "', '$displayorder')");

	if ($printphrase)
	{
		echo '<span class="smallfont">Added Setting - ' . $title . '</span><br />';
	}
}

// ##################### Update Settings Function ADV #####################
function update_setting_adv($varname, $title = '', $description = '', $value = '', $defaultvalue = '', $optioncode = '', $displayorder = '', $printphrase = false)
{
  global $db;

	if ($optioncode OR $displayorder)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET optioncode = '" . addslashes($optioncode) . "', displayorder = '$displayorder' WHERE varname = '$varname'");
	}

	if ($printphrase)
	{
		echo '<font size="1">Updated Setting - ' . $varname . '</font><br />';
	}
}

// ##################### Delete Setting Function  ADV #####################
function kill_setting_adv($title, $printphrase = 0)
{
  global $db;

	if (substr($varname, 0, 6) != 'global')
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$title'");
		if ($printphrase)
		{
			echo '<span class="smallfont">Removed Setting - ' . $title . '</span><br />';
		}
	}
}

// ##################### Insert Settings Function #####################


function insert_setting($title, $description, $varname, $value, $defaultvalue, $optioncode, $displayorder, $grouptitle, $phraseonly = 0, $printphrase = 0)
{
	global $db;

	$checksetting = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "ppgal_setting WHERE varname = '$varname'");
	if ($checksetting['varname'])
	{
		return false;
	}

	$db->query_write("
        INSERT IGNORE INTO " . TABLE_PREFIX . "ppgal_setting
            (varname, grouptitle, value, defaultvalue, optioncode, displayorder)
        VALUES (
            '$varname',
            '$grouptitle',
            '" . addslashes($value) . "',
            '" . addslashes($defaultvalue) . "',
            '" . addslashes($optioncode) . "',
            '$displayorder'
    )");

    $db->query_write("
        INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
            (languageid, varname, text, fieldname, product, username, dateline, version)
        VALUES (
            '-1',
            'setting_" . $varname . "_title',
            '" . addslashes($title) ."',
            'adv_gallery_cp',
            'ppvbgallery',
            'PhotoPost',
            " . TIMENOW . ",
            '$version'
    )");

    $db->query_write("
        INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
            (languageid, varname, text, fieldname, product, username, dateline, version)
        VALUES (
            '-1',
            'setting_" . $varname . "_desc',
            '" . addslashes($description) . "',
            'adv_gallery_cp',
            'ppvbgallery',
            'PhotoPost',
            " . TIMENOW . ",
            '$version'
    )");

}

function update_setting($varname, $title, $description, $value = '', $defaultvalue, $optioncode, $displayorder, $printphrase = false)
{
  global $db;


		$db->query_write("
            DELETE FROM " . TABLE_PREFIX . "phrase
            WHERE varname = 'setting_" . $varname . "_title'
        ");

        $db->query_write("
            INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
                (languageid, varname, text, fieldname, product, username, dateline, version)
            VALUES (
                '-1',
                'setting_" . $varname . "_title',
                '" . addslashes($title) ."',
                'adv_gallery_cp',
                'ppvbgallery',
                'PhotoPost',
                " . TIMENOW . ",
                '$version'
        )");


		$db->query_write("
            DELETE FROM " . TABLE_PREFIX . "phrase
            WHERE varname = 'setting_" . $varname . "_desc'
        ");

        $db->query_write("
            INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
                (languageid, varname, text, fieldname, product, username, dateline, version)
            VALUES (
                '-1',
                'setting_" . $varname . "_desc',
                '" . addslashes($description) . "',
                'adv_gallery_cp',
                'ppvbgallery',
                'PhotoPost',
                " . TIMENOW . ",
                '$version'
        )");

		$db->query_write("
            UPDATE " . TABLE_PREFIX . "ppgal_setting
            SET optioncode = '" . addslashes($optioncode) . "', displayorder = '$displayorder'
            WHERE varname = '$varname'
        ");


	if ($printphrase)
	{
		echo '<font size="1">Updated Setting - ' . $varname . '</font><br />';
	}
}



// ##################### Delete Setting Function #####################
function kill_setting($title, $printphrase = 0)
{
  global $db;

	if (substr($varname, 0, 6) != 'global')
	{
		$db->query_write("
            DELETE FROM " . TABLE_PREFIX . "ppgal_setting
            WHERE varname = '$title'"
        );

        $db->query_write("
            DELETE FROM " . TABLE_PREFIX . "phrase
            WHERE varname = 'setting_" . $varname . "_title'
        ");

	$db->query_write("
            DELETE FROM " . TABLE_PREFIX . "phrase
            WHERE varname = 'setting_" . $varname . "_desc'
        ");

        if ($printphrase)
		{
			echo '<span class="smallfont">Removed Setting - ' . $title . '</span><br />';
		}
	}
}

// ########################### Start Install Table ############################
function print_install_table_start($title = '', $reqdo = '')
{
	global $scriptfile, $scriptname;

	if ($reqdo)
	{
		print_form_header($scriptfile, $reqdo);
	}
	else
	{
		echo '<form action="' . $scriptfile . '.php" method="post">';
		echo '<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';
		print_table_start();
	}

	if (!$title)
	{
		$title = 'PhotoPost vBGallery ' . $scriptname . ' Install';
	}

	print_table_header($title);
}

// ############################ End Install Table #############################
function print_install_table_end()
{
	global $stepphrase, $scriptname, $step, $nextstep, $nextdo, $rebuildtemp;

	print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');

	if (!$step)
	{
		print_radio_row('', 'do', array(
		'install' => 'Begin the installation process.<br />',
		'upgrade' => 'Upgrade.',
		'productupdate' => 'Reinstall the templates, phrases, plugins.',
        'add_settings' => 'This will add setting and update setting cache',
		'doimages' => 'Update your image paths.<br />',
		'uninstall' => 'Uninstall PhotoPost vBGallery ' . $scriptname . '.'), 
		'install');
	}

	construct_hidden_code('step', iif($nextstep, $nextstep, $step + 1));

	if ($nextdo)
	{
		construct_hidden_code('do', $nextdo);
	}

	print_table_break();

	if ($rebuildtemp)
	{
		build_all_styles(0, 0);
	}

	if ($step == 'finished')
	{
		print_table_footer();
	}
	else
	{
		print_submit_row('Continue', '');
	}
}


// ########################## Settings Array ###########################

$mainsettings = array(
'gallery_header_replace' => array('title' => 'Header Replacements', 'description' => 'Here you may enter a list of filenames that may appear in your header that should be prefixed with your Forum\'s URL.', 'value' =>
'index.php', 'optioncode' => 'textarea', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_global'),

'gallery_navbar_replace' => array('title' => 'Navbar Replacements', 'description' => 'Here you may enter a list of filenames that should be prefixed with your Forum\'s URL.', 'value' =>
'memberlist.php
usercp.php
register.php
faq.php
calendar.php
search.php
login.php
forumdisplay.php
profile.php
private.php
subscription.php
member.php
online.php', 'optioncode' => 'textarea', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_global'),

'gallery_footer_replace' => array('title' => 'Footer Replacements', 'description' => 'Here you may enter a list of filenames that may appear in your footer that should be prefixed with your Forum\'s URL.', 'value' =>
'archive
sendmessage.php
private.php', 'optioncode' => 'textarea', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_global'),

'gallery_announcement' => array('title' => 'Global Announcement', 'description' => 'This is a global gallery announcement. It appears below the gallery navbar on each gallery page. Leave blank to disable.', 'value' =>
'Hello $bbuserinfo[username] ! Welcome to $ppg_options[gallery_title]. Please enjoy your stay.  :)', 'optioncode' => 'textarea', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_global'),

'gallery_catsorderby' => array('title' => 'Category Display Order', 'description' => 'Here you may choose to order categories by either the display order specified with each category, or alphabetically.', 'value' =>
'displayorder', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\"> <option " . iif($setting[value] == \'displayorder\', \'selected=\\"selected\\"\'). " value=\\"displayorder\\">Display Order</option> <option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">Alphabetically</option></select>', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_randomhomeimages' => array('title' => 'Random Images on Index', 'description' => 'The number of random images you would like to appear on your gallery\'s main index page. Set this to 0 to disable it.', 'value' =>
'3', 'optioncode' => '', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_index'),

////
'gallery_randomhomepos' => array('title' => 'Random Images Location', 'description' => 'This is the location of Random Images block on your gallery\'s main index page.', 'value' =>
'6', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\" tabindex=\\"1\\" class=\\"bginput\\">
<option value=\\"1\\" " . iif($setting[\'value\']==1,\'selected="selected"\') . ">$vbphrase[above_header]</option>
<option value=\\"2\\" " . iif($setting[\'value\']==2,\'selected="selected"\') . ">$vbphrase[under_header]</option>
<option value=\\"3\\" " . iif($setting[\'value\']==3,\'selected="selected"\') . ">$vbphrase[under_navbar]</option>
<option value=\\"4\\" " . iif($setting[\'value\']==4,\'selected="selected"\') . ">$vbphrase[under_galnavbar]</option>
<option value=\\"5\\" " . iif($setting[\'value\']==5,\'selected="selected"\') . ">$vbphrase[above_stats]</option>
<option value=\\"6\\" " . iif($setting[\'value\']==6,\'selected="selected"\') . ">$vbphrase[under_stats]</option>
<option value=\\"7\\" " . iif($setting[\'value\']==7,\'selected="selected"\') . ">$vbphrase[above_footer]</option>
<option value=\\"8\\" " . iif($setting[\'value\']==8,\'selected="selected"\') . ">$vbphrase[under_footer]</option>
</select>', 'displayorder' => '25', 'grouptitle' => 'adv_gallery_index'),

'gallery_randomhomecutoff' => array('title' => 'Random Images Cutoff', 'description' => 'Choose how far back in days to go back for random images on your gallery\'s main index page. Set this to 0 to disable it.', 'value' =>
'0', 'optioncode' => '', 'displayorder' => '28', 'grouptitle' => 'adv_gallery_index'),

'gallery_lastimage_maxlength' => array('title' => 'Maximum Characters of Last Image', 'description' => 'The maximum number of characters that should be displayed for the title of the last upload and post before being cut off. Set this to 0 to disable it.', 'value' =>
'20', 'optioncode' => '', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_showquickupload' => array('title' => 'Show Quick Upload?', 'description' => 'If enabled, this option will add a \'Quick Upload\' box on your browseimages page to allow users to quickly upload images to that category without having to click on the \'Upload\' link.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_browsecat'),

'gallery_userfolder' => array('title' => 'FTP User Folder Path', 'description' => 'The path (NOT the URL!) to your user\'s upload folder (used for FTP uploads). Ex: /home/yoursite/public_html/gallery/users', 'value' =>
'', 'optioncode' => '', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_paths'),

'gallery_saveoriginal' => array('title' => 'Save Original Files', 'description' => 'Set this option to \'Yes\' if you would like to save original uploaded images, regardless of their size, and have them linked as well.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_upload'),

'gallery_showexif' => array('title' => 'Show EXIF Information?', 'description' => 'This setting will show camera settings (if available) from the image.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '110', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_convertkeywords' => array('title' => 'Convert Keywords to Links', 'description' => 'This setting will convert keywords to links and allow the user to quickly search for that word.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '90', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_newhomeimages' => array('title' => 'New Images on Index', 'description' => 'The number of new images you would like to appear on your gallery\'s main index page. Set this to 0 to disable it.', 'value' =>
'3', 'optioncode' => '', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_index'),
////
'gallery_newhomepos' => array('title' => 'New Images Location', 'description' => 'This is the location of New Images block on your gallery\'s main index page.', 'value' =>
'6', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\" tabindex=\\"1\\" class=\\"bginput\\">
<option value=\\"1\\" " . iif($setting[\'value\']==1,\'selected="selected"\') . ">$vbphrase[above_header]</option>
<option value=\\"2\\" " . iif($setting[\'value\']==2,\'selected="selected"\') . ">$vbphrase[under_header]</option>
<option value=\\"3\\" " . iif($setting[\'value\']==3,\'selected="selected"\') . ">$vbphrase[under_navbar]</option>
<option value=\\"4\\" " . iif($setting[\'value\']==4,\'selected="selected"\') . ">$vbphrase[under_galnavbar]</option>
<option value=\\"5\\" " . iif($setting[\'value\']==5,\'selected="selected"\') . ">$vbphrase[above_stats]</option>
<option value=\\"6\\" " . iif($setting[\'value\']==6,\'selected="selected"\') . ">$vbphrase[under_stats]</option>
<option value=\\"7\\" " . iif($setting[\'value\']==7,\'selected="selected"\') . ">$vbphrase[above_footer]</option>
<option value=\\"8\\" " . iif($setting[\'value\']==8,\'selected="selected"\') . ">$vbphrase[under_footer]</option>
</select>', 'displayorder' => '15', 'grouptitle' => 'adv_gallery_index'),
 /////

'gallery_newhomecutoff' => array('title' => 'New Images Cutoff', 'description' => 'Choose how far back in days to go back for new images on your gallery\'s main index page. Set this to 0 to disable it.', 'value' =>
'0', 'optioncode' => '', 'displayorder' => '18', 'grouptitle' => 'adv_gallery_index'),

'gallery_imageperpage_multiplier' => array('title' => 'Images Per Page Multiplier', 'description' => 'This option will allow your users to choose a higher number of images to display per page than the default setting. It will keep multiplying the number of images by the default setting above up to the number specified here.', 'value' =>
'5', 'optioncode' => '', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_browsecat'),

'gallery_filedirectory' => array('title' => 'Files Path', 'description' => 'The full path (NOT the URL!) to the folder in which your images will be stored. Ex: /home/yoursite/public_html/gallery/files', 'value' =>
'', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_paths'),

'gallery_showquickreply' => array('title' => 'Show Quick Reply?', 'description' => 'Set this option to \'Yes\' to enable the quick reply box.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '80', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_resizemethod' => array('title' => 'Resize Program', 'description' => 'The image tool that you would like to use to resize and manipulate images.', 'value' =>
'GD2', 'optioncode' => '<div class=\\"smallfont\\" style=\\"margin-bottom:4px\\">Likely GD version: " . $gdinfo . "</div> <select name=\\"setting[$setting[varname]]\\"> <option " . iif($setting[value] == \'GD2\', \'selected="selected"\'). " value=\\"GD2\\">GD2</option> <option " . iif($setting[value] == \'GD1\', \'selected="selected"\'). " value=\\"GD1\\">GD1</option> <option " . iif($setting[value] == \'IM\', \'selected="selected"\'). " value=\\"IM\\">ImageMagick</option></select>', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_upload'),

'gallery_exiffields' => array('title' => 'EXIF Fields', 'description' => 'Here you may select which fields from the EXIF data that you wish to display.', 'value' =>
'Make
Model
Orientation
ImageDescription
Model
XResolution
ResolutionUnit
DateTime
ISOSpeedRatings
ExposureBiasValue
MeteringMode
Flash
FlashPixVersion
DigitalZoomRatio
GainControl
Saturation
InterOperabilityIndex
Macro
DigitalZoom
YResolution
Software
YCbCrPositioning
ExposureTime
ExposureProgram
CompressedBitsPerPixel
MaxApertureValue
LightSource
FocalLength', 'optioncode' => 'textarea', 'displayorder' => '120', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_showstats' => array('title' => 'Show Stats', 'description' => 'Set this option to \'Yes\' if you would like to display stats such as the total number of categories, images, posts, views, and space used.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_index'),

'gallery_active' => array('title' => 'Gallery Active', 'description' => 'From time to time, you may wish to turn your gallery off to the public for whatever reason. When you turn your gallery off, visitors (with the exception of administrators and moderators) will see the message you specify in the option below rather than your gallery.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_main'),

'gallery_closedmessage' => array('title' => 'Gallery Closed Message', 'description' => 'This is the message that will be displayed to visitors when the gallery is closed.', 'value' =>
'We\'re sorry, but the gallery is closed for maintenance. Please check back soon.', 'optioncode' => 'textarea', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_main'),

'gallery_showimagecount' => array('title' => 'Show Image / Post Counts in Restricted Categories', 'description' => 'When set to \'Yes\', this option will display the number of images/posts in categories even if the user does not have permission to view these categories. When set to \'No\', the user will see 0 for the number images/posts in categories which they do not have permission to view images.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '120', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_originalwindow' => array('title' => 'Open Original in New Window', 'description' => 'When set to \'Yes\' this will cause the original image to be opened in a new window by itself. Note: This option only applies if you have the \'Save Originals\' option set to \'Yes\'.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '100', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_imagelinkcode' => array('title' => 'Show Link Code', 'description' => 'Set this option to \'Yes\' to display a link directly to the image which your users can easily copy.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_imagetagcode' => array('title' => 'Show &lt;img&gt; Code Tag', 'description' => 'Set this option to \'Yes\' to display an &lt;img&gt; code link which your users can easily copy.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_permwatermark' => array('title' => 'Permanently Watermark Images', 'description' => 'Set this option to \'Yes\' if you would like to permanently watermark your images. If set to \'No\' your uploaded images will not be modified. Please note that this option requires the GD library.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '100', 'grouptitle' => 'adv_gallery_upload'),

'gallery_htaccess' => array('title' => 'Use .htaccess Protection', 'description' => 'Turning this on will add a .htaccess file in your gallery/files folder to help protect your files from hot linking.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '140', 'grouptitle' => 'adv_gallery_main'),

'gallery_allowreplies' => array('title' => 'Allow Replies', 'description' => 'Set this option to \'Yes\' if you wish to allow your members to make comments and reply to images.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_posting'),

'gallery_url' => array('title' => 'Gallery URL', 'description' => 'The full URL to your gallery.', 'value' =>
'', 'optioncode' => '', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_paths'),

'gallery_title' => array('title' => 'Gallery Title', 'description' => 'The title for your gallery.', 'value' =>
'PhotoPost vBGallery', 'optioncode' => '', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_paths'),

'gallery_imagesperpage' => array('title' => 'Images Per Page', 'description' => 'The maximum number of images to display on a page before splitting into multiple pages.', 'value' =>
'15', 'optioncode' => '', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_browsecat'),

'gallery_columns' => array('title' => 'Number of Columns', 'description' => 'The number of columns to display in a single row before splitting down to the next one.', 'value' =>
'3', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_browsecat'),

'gallery_fileurl' => array('title' => 'Files URL', 'description' => 'The URL to the folder in which your images will be stored.', 'value' =>
'', 'optioncode' => '', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_paths'),

'gallery_allowsubscribe' => array('title' => 'Allow Subscriptions', 'description' => 'Set this option to \'Yes\' if you would like to allow users to subscribe to images.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '100', 'grouptitle' => 'adv_gallery_main'),

'gallery_allowfav' => array('title' => 'Allow User Favorites', 'description' => 'Set this option to \'Yes\' if you would like to allow users to have favorites.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '90', 'grouptitle' => 'adv_gallery_main'),

'gallery_newimagelimit' => array('title' => 'New Images Date Limits', 'description' => 'Enter a list of days (separated by commas) that you would like to allow your users to search for new images from.', 'value' =>
'1,2,5,10,25', 'optioncode' => '', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_main'),

'gallery_style' => array('title' => 'Default Style', 'description' => 'Select the default style for your gallery. This style will be used for all guests, and any members who have not expressed a style preference in their options, or are attempting to use a style that does not exist or is forbidden.
this option rely on the option above being set to no', 'value' =>
'-1', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\" tabindex=\\"1\\" class=\\"bginput\\">" . construct_select_options(fetch_style_title_options_array(), $setting[\'value\']) . "</select>', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_main'),

'gallery_allowchangestyles' => array('title' => 'Allow Style to be Changed', 'description' => 'This allows users to set their preferred style set on registration or when editing their options under userCP.
Setting this to \'No\' disables that option and will force them to use whatever style has been specified below.
Setting this to \'Yes\' also allows modifications to alter the style via a variable.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_main'),

'gallery_popimagelimit' => array('title' => 'Popular Images Limit', 'description' => 'The number of images you would like to display in the "What\'s Popular" section of the gallery. Set this to \'0\' to disable it.', 'value' =>
'15', 'optioncode' => '', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_main'),

'gallery_usercat_descmax' => array('title' => 'Maximum Length of Description', 'description' => 'The maximum number of characters allowed in the description for user created categories.', 'value' =>
'250', 'optioncode' => '', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_catdepth' => array('title' => 'Depth of Categories', 'description' => 'The depth of categories to show in the category listings. If you set this option to \'2\', the current category level and any child categories one level below that will be displayed.', 'value' =>
'2', 'optioncode' => '', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_catsperpage' => array('title' => 'Members Categories Per Page', 'description' => 'If you have any categories set as a "Members Category", this option will allow you to choose how many sub-categories will be shown on a single page.', 'value' =>
'15', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_usercat_titlemax' => array('title' => 'Maximum Length of Title', 'description' => 'The maximum number of characters allowed in the title for user created categories.', 'value' =>
'50', 'optioncode' => '', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_version' => array('title' => 'Gallery Version', 'description' => 'Leave this option alone.', 'value' =>
'2.4.3', 'optioncode' => 'hidden', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_main'),

'gallery_desclimit' => array('title' => 'Description Character Limit', 'description' => 'The maximum number of characters that may be entered in the description of an image.', 'value' =>
'250', 'optioncode' => '', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_enableecards' => array('title' => 'Enable e-Cards', 'description' => 'Set this option to \'Yes\' if you would like to allow your users to send e-Cards from your gallery.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_ecard'),

'gallery_userfolderurl' => array('title' => 'FTP User Folder URL', 'description' => 'The URL to your user\'s upload folder (used for FTP uploads).', 'value' =>
'', 'optioncode' => '', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_paths'),

'gallery_quotetitle' => array('title' => 'Quote Titles in Replies', 'description' => 'Setting this option to \'Yes\' will automatically fill the title of new posts with either the image title, or the post title (if replying to a specific post), prefixed by \'Re: \'. The user may still specify their own title if they wish to do so.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_posting'),

'gallery_showonoff' => array('title' => 'Show On/Off Indicators', 'description' => 'Set this option to \'Yes\' if you would like to display the on/off new image indicators in your category listings.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '90', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_newimageemail' => array('title' => 'Email Address to Notify of New Uploads', 'description' => 'Enter a list of email addresses here (separated by spaces) that you would like to have an email sent to when a new upload is made.', 'value' =>
'', 'optioncode' => '', 'displayorder' => '120', 'grouptitle' => 'adv_gallery_upload'),

'gallery_newimageemail_all' => array('title' => 'Notify of All Uploads', 'description' => 'If you would like to only be notified of uploads submitted which are awaiting validation, set this option to \'No\'. Otherwise you will be notified of any uploads submitted whether they are awaiting validation or not. Note: Also affects any email addresses you have set for specific categories.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '130', 'grouptitle' => 'adv_gallery_upload'),

'gallery_allowsignatures' => array('title' => 'Allow Signatures', 'description' => 'Set this option to \'No\' if you would like to disable signatures in posts.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_posting'),

'gallery_showpostbit' => array('title' => 'Postbit Integration', 'description' => 'Set this option to \'No\' if you would like to disable image count of users in posts.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_posting'),

'gallery_imagebitdisplay' => array('title' => 'Imagebit Fields', 'description' => 'Here you may select the different items that you would like to display with your thumbnails.', 'value' =>
'title,user,dateline,filesize,dimensions,views,posts,lastpost,rating', 'optioncode' => '<table width=\\"100%\\"> <tr> <td><span class=\\"smallfont\\"><label for=\\"title\\"><input id=\\"title\\" " . iif(in_array(\'title\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"title\\" />Title</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"user\\"><input id=\\"user\\" " . iif(in_array(\'user\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"user\\" />Username</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"description\\"><input id=\\"description\\" " . iif(in_array(\'description\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"description\\" />Description</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"dateline\\"><input id=\\"dateline\\" " . iif(in_array(\'dateline\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"dateline\\" />Date</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"filesize\\"><input id=\\"filesize\\" " . iif(in_array(\'filesize\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"filesize\\" />Filesize</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"dimensions\\"><input id=\\"dimensions\\" " . iif(in_array(\'dimensions\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"dimensions\\" />Dimensions</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"views\\"><input id=\\"views\\" " . iif(in_array(\'views\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"views\\" />Views</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"posts\\"><input id=\\"posts\\" " . iif(in_array(\'posts\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"posts\\" />Replies</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"lastpost\\"><input id=\\"lastpost\\" " . iif(in_array(\'lastpost\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"lastpost\\" />Last Post</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"rating\\"><input id=\\"rating\\" " . iif(in_array(\'rating\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"rating\\" />Rating</label></span></td> </tr> </table> ', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_browsecat'),

'gallery_catsdirection' => array('title' => 'Category Display Direction', 'description' => 'The default direction that categories should appear in.', 'value' =>
'ASC', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\"> <option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">Ascending</option> <option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">Descending</option></select>', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_showsubcats' => array('title' => 'Show Sub-Categories', 'description' => 'This option will allow you to display links to a category\'s sub-categories in the category listings.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_showslideshow' => array('title' => 'Show Slide Show', 'description' => 'This option will allow you to display slideshow image in the category listings.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '80', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_imagebitdisplay_index' => array('title' => 'Index Imagebit Fields', 'description' => 'Here you may select the different items that you would like to display with thumbnails on your main index page in the new and random image sections.', 'value' =>
'title,user,dateline,filesize,dimensions,views,posts,lastpost,rating,category', 'optioncode' => '<table width=\\"100%\\"> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_title\\"><input id=\\"index_title\\" " . iif(in_array(\'title\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"title\\" />Title</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_user\\"><input id=\\"index_user\\" " . iif(in_array(\'user\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"user\\" />Username</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_description\\"><input id=\\"index_description\\" " . iif(in_array(\'description\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"description\\" />Description</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_dateline\\"><input id=\\"index_dateline\\" " . iif(in_array(\'dateline\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"dateline\\" />Date</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_filesize\\"><input id=\\"index_filesize\\" " . iif(in_array(\'filesize\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"filesize\\" />Filesize</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_dimensions\\"><input id=\\"index_dimensions\\" " . iif(in_array(\'dimensions\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"dimensions\\" />Dimensions</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_views\\"><input id=\\"index_views\\" " . iif(in_array(\'views\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"views\\" />Views</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_posts\\"><input id=\\"index_posts\\" " . iif(in_array(\'posts\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"posts\\" />Replies</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_lastpost\\"><input id=\\"index_lastpost\\" " . iif(in_array(\'lastpost\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"lastpost\\" />Last Post</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_rating\\"><input id=\\"index_rating\\" " . iif(in_array(\'rating\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"rating\\" />Rating</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_category\\"><input id=\\"index_category\\" " . iif(in_array(\'category\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"category\\" />Category</label></span></td> <td></td> </tr> </table> ', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_index'),

'gallery_showcatdesc' => array('title' => 'Show Category Description', 'description' => 'This option displays the category description in the navbar. Helps visitors to know what the topic of a forum is, as well as possibly increasing search engine rankings.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '140', 'grouptitle' => 'adv_gallery_main'),

'gallery_reportforum' => array('title' => 'Reported Forum', 'description' => 'Enter the forum id to create threads in for reported images and comments. This will disable e-mail reports.', 'value' =>
'', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\" tabindex=\\"1\\" class=\\"bginput\\">" . construct_select_options(construct_forum_chooser_options(1), $setting[\'value\']) . "</select>', 'displayorder' => '150', 'grouptitle' => 'adv_gallery_main'),

'gallery_showcatuser' => array('title' => 'Show Category Owner', 'description' => 'If a category belongs to a specific user, this option will allow the username to be shown under that categories title in the category list.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '110', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_imagebbcode' => array('title' => 'Show BBimage Code Tag', 'description' => 'Set this option to \'Yes\' to display a bb image code link which your users can easily copy.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_showmodcolumn' => array('title' => 'Show Moderator Column', 'description' => 'Set this option to \'Yes\' if you would like to display the moderator column on your main gallery index page.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '100', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_thumbsize' => array('title' => 'Thumb Size', 'description' => 'The maximum height or width (in pixels) that thumbnails should be.', 'value' =>
'100', 'optioncode' => '', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_upload'),

'gallery_allowrating' => array('title' => 'Enable Ratings', 'description' => 'Allow your members to rate uploads?', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '80', 'grouptitle' => 'adv_gallery_main'),

'gallery_usercat_edit' => array('title' => 'Allow Users to Edit Their Categories', 'description' => 'Set this option to \'Yes\' if you would like to allow your users to empty categories once they have created them.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_catdepth_index' => array('title' => 'Depth of Categories on Index', 'description' => 'The depth of categories to show in the category listings on your main index page. If you set this option to \'2\', the current category level and any child categories one level below that will be displayed.', 'value' =>
'2', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_index'),

'gallery_catimage_size' => array('title' => 'Maximum Width/Height of Category Images', 'description' => 'Enter the maximum width/height of category images here. If the image is larger than the size entered here then it will be automatically resized to fit the dimensions. Leave this option blank if you do not wish to resize your category images.', 'value' =>
'', 'optioncode' => '', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_categorybit'),

'gallery_insafemode' => array('title' => 'Safemode Bypass', 'description' => 'Don\'t touch this option.', 'value' =>
'', 'optioncode' => 'hidden', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_upload'),

'gallery_showuserratings' => array('title' => 'Show User Ratings?', 'description' => 'When enabled, this option will display a link under the rating pop-up window that will allow your users to see how other members rated the image.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_homeexcats' => array('title' => 'Excluded Categories', 'description' => 'Here you may select any category(ies) that you wish to exclude from being displayed in the new and random images section. To select more than one category, hold down your \'ctrl\' key while selecting the categories with your mouse.', 'value' =>
'', 'optioncode' => 'catselect', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_index'),

'gallery_displayloggedin' => array('title' => 'Display Logged in Users?', 'description' => 'Displays those users that have been active in the last XXX seconds on the home page, where XXX is the value specified by your Cookie Time-Out option (Default is last 15 minutes). Not recommended for sites with hundreds of simultaneous users. The Alphabetical option requires more resources than the random option.', 'value' =>
'1', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\" tabindex=\\"1\\" class=\\"bginput\\">
<option value=\\"0\\" " . iif($setting[\'value\']==0,\'selected="selected"\') . ">$vbphrase[no]</option>
<option value=\\"1\\" " . iif($setting[\'value\']==1,\'selected="selected"\') . ">$vbphrase[yes_alphabetical_all]</option>
<option value=\\"2\\" " . iif($setting[\'value\']==2,\'selected="selected"\') . ">$vbphrase[yes_alphabetical_members]</option>
<option value=\\"3\\" " . iif($setting[\'value\']==3,\'selected="selected"\') . ">$vbphrase[yes_random_all]</option>
<option value=\\"4\\" " . iif($setting[\'value\']==4,\'selected="selected"\') . ">$vbphrase[yes_random_members]</option>
</select>', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_index'),

'gallery_displayloggedin_local' => array('title' => 'Display Logged in Users (gallery only)', 'description' => 'Select \'Yes\' to show only users that are viewing gallery pages vs. every site page.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '80', 'grouptitle' => 'adv_gallery_index'),

'gallery_usercats_modopts' => array('title' => 'Allow Category Owner Moderator Abilities', 'description' => 'This option will give the owner of user created categories the same privileges as moderators (delete images/posts, validate new, stick images, close images, etc) for the categories they create.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '80', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_popimages_votelimit' => array('title' => 'Minimum Votes for Top Rated', 'description' => 'The minimum number of votes that an image must have before being shown as a top rated image in the "What\'s Popular" section.', 'value' =>
'2', 'optioncode' => '', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_main'),

'gallery_deforder' => array('title' => 'Default Order', 'description' => 'The default order that images should appear in. This affects images displayed in categories, favorites section, and search results (if no order is specified).', 'value' =>
'dateline', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\"> <option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">Title</option> <option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">Date Added</option> <option " . iif($setting[value] == \'lastpostdateline\', \'selected=\\"selected\\"\'). " value=\\"lastpostdateline\\">Last Post</option> <option " . iif($setting[value] == \'username\', \'selected=\\"selected\\"\'). " value=\\"username\\">Username</option></select>', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_browsecat'),

'gallery_usercats_password' => array('title' => 'Allow Users to Set Password', 'description' => 'When set to \'Yes\', this option will allow your users to password protect their categories if they wish to.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_ecardperms' => array('title' => 'Apply Permissions When Viewing e-Cards', 'description' => 'When set to \'Yes\', this option will prevent users from being able to view an e-Card if their usergroup does not have permission to view the image included with that card. Otherwise users will be able to view an e-Card without any permission checks.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_ecard'),

'gallery_filmstrip' => array('title' => 'Number of Images in Filmstrip', 'description' => 'This option will allow you to display the thumbnails of a specified number of previous/next images in a "filmstrip". Set this option to \'0\' to disable it.', 'value' =>
'3', 'optioncode' => '', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_usercats_defaultopts' => array('title' => 'Options Settings', 'description' => 'Here you may choose a default for each option with user created categories, or set it to allow the user to choose.', 'value' =>
'a:4:{s:10:"allow_view";s:1:"2";s:12:"allow_upload";s:1:"2";s:11:"allow_reply";s:1:"2";s:12:"allow_rating";s:1:"2";}', 'optioncode' => '<table width=\\"100%\\"> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow View</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_view1\\"><input id=\\"allow_view1\\" " . iif($setting[\'value\'][\'allow_view\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_view]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_view0\\"><input id=\\"allow_view0\\" " . iif($setting[\'value\'][\'allow_view\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_view]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_view2\\"><input id=\\"allow_view2\\" " . iif($setting[\'value\'][\'allow_view\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_view]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow Upload</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_upload1\\"><input id=\\"allow_upload1\\" " . iif($setting[\'value\'][\'allow_upload\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_upload]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_upload0\\"><input id=\\"allow_upload0\\" " . iif($setting[\'value\'][\'allow_upload\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_upload]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_upload2\\"><input id=\\"allow_upload2\\" " . iif($setting[\'value\'][\'allow_upload\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_upload]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow Replies</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_reply1\\"><input id=\\"allow_reply1\\" " . iif($setting[\'value\'][\'allow_reply\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_reply]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_reply0\\"><input id=\\"allow_reply0\\" " . iif($setting[\'value\'][\'allow_reply\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_reply]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_reply2\\"><input id=\\"allow_reply2\\" " . iif($setting[\'value\'][\'allow_reply\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_reply]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow Rating</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_rating1\\"><input id=\\"allow_rating1\\" " . iif($setting[\'value\'][\'allow_rating\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_rating]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_rating0\\"><input id=\\"allow_rating0\\" " . iif($setting[\'value\'][\'allow_rating\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_rating]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_rating2\\"><input id=\\"allow_rating2\\" " . iif($setting[\'value\'][\'allow_rating\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_rating]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> </table> ', 'displayorder' => '90', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_usercats_empty' => array('title' => 'Allow Users to Empty Their Categories', 'description' => 'Set this option to \'Yes\' if you would like to allow your users to empty categories once they have created them.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_usercats_delete' => array('title' => 'Allow Users to Delete Their Categories', 'description' => 'Set this option to \'Yes\' if you would like to allow your users to delete categories once they have created them.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_defdirection' => array('title' => 'Default Direction', 'description' => 'The default direction that images should appear in. This affects images displayed in categories, favorites section, and search results (if no order is specified).', 'value' =>
'DESC', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\"> <option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">Ascending</option> <option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">Descending</option></select>', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_browsecat'),

'gallery_newcatsattop' => array('title' => 'Add New Categories to the Top', 'description' => 'When set to \'Yes\' this option will add newly created user categories to the top of the list. Otherwise the categories will be added at the end.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_usercats'),

'gallery_ecardsexpire' => array('title' => 'Expiration For e-Cards', 'description' => 'The number of days you would like an e-Card to remain in the database before it is deleted. Set this option to 0 if you do not wish to delete e-Cards.', 'value' =>
'0', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_ecard'),

'gallery_ecardssmilies' => array('title' => 'Enable Smilies', 'description' => 'Set this option to \'Yes\' if you would like to allow smilies in e-Cards.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_ecard'),

'gallery_ecardshtml' => array('title' => 'Enable HTML', 'description' => 'Set this option to \'Yes\' if you would like to allow HTML in e-Cards.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_ecard'),

'gallery_ecardsbbcode' => array('title' => 'Enable BB Code', 'description' => 'Set this option to \'Yes\' if you would like to allow BB code in e-Cards.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_ecard'),

'gallery_ecardsimgcode' => array('title' => 'Enable [IMG] Code', 'description' => 'Set this option to \'Yes\' if you would like to allow [img] code in e-Cards.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_ecard'),

'gallery_slideshowheader' => array('title' => 'Show Header in Slide Shows', 'description' => 'This option will allow you to remove your header from slide shows which will take less space on the page and keep the user from having to scroll down to see the image.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '130', 'grouptitle' => 'adv_gallery_main'),

'gallery_thumbquality' => array('title' => 'Thumbnail Quality', 'description' => 'Choose a setting between 0 (worst quality, smaller file) to 100 (best quality, biggest file) for the quality of your thumbnails. Set this to -1 not to change the quality.', 'value' =>
'-1', 'optioncode' => '', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_upload'),

'gallery_origquality' => array('title' => 'Original Image Quality', 'description' => 'Choose a setting between 0 (worst quality, smaller file) to 100 (best quality, biggest file) for the quality of your images. Set this to -1 not to change the quality.', 'value' =>
'-1', 'optioncode' => '', 'displayorder' => '70', 'grouptitle' => 'adv_gallery_upload'),

'gallery_enablecatjump' => array('title' => 'Enable Category Jump', 'description' => 'This will display a \\"Category Jump\\", similar to vBulletin\'s Forum Jump.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '110', 'grouptitle' => 'adv_gallery_main'),

'gallery_navbarlink' => array('title' => 'Galley Link in Navbar', 'description' => 'Set this option to \'Yes\' if you would like the $navbar in the forums to have a link to the gallery.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '115', 'grouptitle' => 'adv_gallery_main'),

'gallery_navbarhomelink' => array('title' => 'Homepage Link in Navbar', 'description' => 'Set this option to \'Yes\' if you would like the breadcrumbs in your navbar to begin with a link back to your homepage. Otherwise it will begin with a link back to your gallery as the first breadcrumb.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '120', 'grouptitle' => 'adv_gallery_main'),

'gallery_uploadinputs' => array('title' => 'Upload Inputs', 'description' => 'This option sets how many input boxes are displayed on the upload page.', 'value' =>
'3', 'optioncode' => '', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_upload'),

'gallery_programpath' => array('title' => 'Resize Program Path', 'description' => 'If you have chosen ImageMagick for your resize program, enter the path to the program here.', 'value' =>
'', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_upload'),

'gallery_allowposticons' => array('title' => 'Allow Icons in Posts', 'description' => 'Set this option to \'Yes\' if you would like to allow your users to select an icon when posting replies.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_posting'),

'gallery_repliesperpage' => array('title' => 'Replies Per Page', 'description' => 'The maximum number of replies to be displayed before splitting into multiple pages. Please note that if a user has changed the value for the "Number of Posts to Show Per Page" setting in their User CP then that value will override this option.', 'value' =>
'10', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_showimage'),

'gallery_watermark' => array('title' => 'Watermark Images', 'description' => 'If you would like to add a watermark to uploaded images enter the full path (NOT the URL) to that image here. Otherwise leave this setting blank.', 'value' =>
'', 'optioncode' => '', 'displayorder' => '90', 'grouptitle' => 'adv_gallery_upload'),

'gallery_watermark_location' => array('title' => 'Watermark Location', 'description' => 'Where you would like your watermark to appear.', 'value' =>
'se', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\"> <option " . iif($setting[\'value\'] == \'nw\', \'selected="selected"\') . " value=\\"nw\\">$vbphrase[northwest]</option> <option " . iif($setting[\'value\'] == \'nc\', \'selected="selected"\') . " value=\\"nc\\">North Center</option> <option " . iif($setting[\'value\'] == \'ne\', \'selected="selected"\') . " value=\\"ne\\">North East</option> <option " . iif($setting[\'value\'] == \'mw\', \'selected="selected"\') . " value=\\"mw\\">Middle West</option> <option " . iif($setting[\'value\'] == \'mc\', \'selected="selected"\') . " value=\\"mc\\">Middle Center</option> <option " . iif($setting[\'value\'] == \'me\', \'selected="selected"\') . " value=\\"me\\">Middle East</option> <option " . iif($setting[\'value\'] == \'sw\', \'selected="selected"\') . " value=\\"sw\\">South West</option> <option " . iif($setting[\'value\'] == \'sc\', \'selected="selected"\') . " value=\\"sc\\">South Center</option> <option " . iif($setting[\'value\'] == \'se\', \'selected="selected"\') . " value=\\"se\\">South East</option> </select>', 'displayorder' => '11', 'grouptitle' => 'adv_gallery_upload'),

// Addons  forumhome

'add_home_active' => array('title' => 'Home Active', 'description' => 'Enable to show images on your FORUMHOME.', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '10', 'grouptitle' => 'add_forumhome'),

'add_home_navbar' => array('title' => 'Enable Navbar', 'description' => 'This setting will allow you to disable and enable the navbar.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '20', 'grouptitle' => 'add_forumhome'),

'add_home_limit' => array('title' => 'Image Count', 'description' => 'How many images would you like to show ?', 'value' =>
'4', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'add_forumhome'),

'add_home_column' => array('title' => 'Column Span', 'description' => 'How many columns of images would you like to show ?', 'value' =>
'4', 'optioncode' => '', 'displayorder' => '40', 'grouptitle' => 'add_forumhome'),

'add_home_orderby' => array('title' => 'Image Order', 'description' => 'Please choose the way your images should be ordered.', 'value' =>
'5', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\" tabindex=\\"1\\" class=\\"bginput\\">
<option value=\\"1\\" " . iif($setting[\'value\']==1,\'selected="selected"\') . ">$vbphrase[newest]</option>
<option value=\\"2\\" " . iif($setting[\'value\']==2,\'selected="selected"\') . ">$vbphrase[most_viewed]</option>
<option value=\\"3\\" " . iif($setting[\'value\']==3,\'selected="selected"\') . ">$vbphrase[most_comments]</option>
<option value=\\"4\\" " . iif($setting[\'value\']==4,\'selected="selected"\') . ">$vbphrase[highest_rated]</option>
<option value=\\"5\\" " . iif($setting[\'value\']==5,\'selected="selected"\') . ">$vbphrase[random]</option>
</select>', 'displayorder' => '50', 'grouptitle' => 'add_forumhome'),

'add_home_place' => array('title' => 'Location', 'description' => 'Please choose the way your images should be displayed.<br /><br />Select Custom and place <b>$vbgallery</b> in FORUMHOME template for custom location.', 'value' =>
'1', 'optioncode' => '<select name=\\"setting[$setting[varname]]\\" tabindex=\\"1\\" class=\\"bginput\\">
<option value=\\"2\\" " . iif($setting[\'value\']==2,\'selected="selected"\') . ">$vbphrase[above_header]</option>
<option value=\\"3\\" " . iif($setting[\'value\']==3,\'selected="selected"\') . ">$vbphrase[under_header]</option>
<option value=\\"1\\" " . iif($setting[\'value\']==1,\'selected="selected"\') . ">$vbphrase[under_navbar]</option>
<option value=\\"4\\" " . iif($setting[\'value\']==4,\'selected="selected"\') . ">$vbphrase[above_whats_going_on]</option>
<option value=\\"6\\" " . iif($setting[\'value\']==6,\'selected="selected"\') . ">$vbphrase[inside_whats_going_on]</option>
<option value=\\"5\\" " . iif($setting[\'value\']==5,\'selected="selected"\') . ">$vbphrase[under_whats_going_on]</option>
<option value=\\"7\\" " . iif($setting[\'value\']==7,\'selected="selected"\') . ">$vbphrase[custom_location]</option>
</select>', 'displayorder' => '60', 'grouptitle' => 'add_forumhome'),

'add_home_exclude' => array('title' => 'Exclude Catagories', 'description' => 'Here you can list catagories you wish to exclude from the image listing.', 'value' =>
'', 'optioncode' => 'catselect', 'displayorder' => '70', 'grouptitle' => 'add_forumhome'),

'add_home_include' => array('title' => 'Limit Catagories', 'description' => 'Here you can list only catagories you wish to show.', 'value' =>
'', 'optioncode' => 'catselect', 'displayorder' => '80', 'grouptitle' => 'add_forumhome'),

'add_home_imagebitdisplay' => array('title' => 'Imagebit Fields', 'description' => 'Here you may select the different items that you would like to display with thumbnails on your main index page in the new and random image sections.', 'value' =>
'title,user,dateline,filesize,dimensions,views,posts,lastpost,rating,category', 'optioncode' => '<table width=\\"100%\\"> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_title\\"><input id=\\"index_title\\" " . iif(in_array(\'title\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"title\\" />Title</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_user\\"><input id=\\"index_user\\" " . iif(in_array(\'user\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"user\\" />Username</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_description\\"><input id=\\"index_description\\" " . iif(in_array(\'description\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"description\\" />Description</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_dateline\\"><input id=\\"index_dateline\\" " . iif(in_array(\'dateline\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"dateline\\" />Date</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_filesize\\"><input id=\\"index_filesize\\" " . iif(in_array(\'filesize\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"filesize\\" />Filesize</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_dimensions\\"><input id=\\"index_dimensions\\" " . iif(in_array(\'dimensions\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"dimensions\\" />Dimensions</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_views\\"><input id=\\"index_views\\" " . iif(in_array(\'views\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"views\\" />Views</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_posts\\"><input id=\\"index_posts\\" " . iif(in_array(\'posts\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"posts\\" />Replies</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_lastpost\\"><input id=\\"index_lastpost\\" " . iif(in_array(\'lastpost\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"lastpost\\" />Last Post</label></span></td> <td><span class=\\"smallfont\\"><label for=\\"index_rating\\"><input id=\\"index_rating\\" " . iif(in_array(\'rating\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"rating\\" />Rating</label></span></td> </tr> <tr> <td><span class=\\"smallfont\\"><label for=\\"index_category\\"><input id=\\"index_category\\" " . iif(in_array(\'category\', explode(\',\', $setting[\'value\'])), \'checked="checked"\'). " name=\\"setting[$setting[varname]][]\\" type=\\"checkbox\\" value=\\"category\\" />Category</label></span></td> <td></td> </tr> </table> ', 'displayorder' => '90', 'grouptitle' => 'add_forumhome'),

'add_home_cutoff' => array('title' => 'History Cutoff', 'description' => 'Choose how far back in days to go back for images. (blank to disable)', 'value' =>
'0', 'optioncode' => '', 'displayorder' => '100', 'grouptitle' => 'add_forumhome'),

// Stats
'gallery_stats_forumhome' => array('title' => 'Enable ForumHome', 'description' => 'Turn on this setting to display gallery statistics on the forumhome inside the "What\'s Going On?" block.', 'value' =>
'1', 'optioncode' => 'yesno', 'displayorder' => '5', 'grouptitle' => 'adv_gallery_stat'),

'gallery_stats_active' => array('title' => 'Extra Statistics', 'description' => 'On (yes) / Off (no)', 'value' =>
'0', 'optioncode' => 'yesno', 'displayorder' => '10', 'grouptitle' => 'adv_gallery_stat'),

'gallery_stats_uploads' => array('title' => 'Most Uploads', 'description' => 'How many members would you like to list ?', 'value' =>
'10', 'optioncode' => '', 'displayorder' => '20', 'grouptitle' => 'adv_gallery_stat'),

'gallery_stats_comments' => array('title' => 'Most Comments', 'description' => 'How many most commented on images would you like to display ?', 'value'=>
'5', 'optioncode' => '', 'displayorder' => '30', 'grouptitle' => 'adv_gallery_stat'),

'gallery_stats_viewed' => array('title' => 'Most Viewed', 'description' => 'How many most viewed images would you like to display ?', 'value' =>
'5', 'optioncode' => '', 'displayorder' => '40', 'grouptitle' => 'adv_gallery_stat'),

'gallery_stats_categories' => array('title' => 'Most Popular Categories', 'description' => 'How many most uploaded categories would you like to list ?', 'value' =>
'5', 'optioncode' => '', 'displayorder' => '50', 'grouptitle' => 'adv_gallery_stat'),

'gallery_stats_days' => array('title' => 'How long ago ?', 'description' => 'How far in the past to look for data. This setting effects bar graph statistics.<br /><br />Default: 30 days.', 'value' =>
'30', 'optioncode' => '', 'displayorder' => '60', 'grouptitle' => 'adv_gallery_stat')

);

$adv_settinggroups = array(
	'adv_gallery_global' => 1,
	'adv_gallery_paths' => 2,
	'adv_gallery_main' => 3,
	'adv_gallery_index' => 4,
	'adv_gallery_categorybit' => 5,
	'adv_gallery_browsecat' => 6,
	'adv_gallery_showimage' => 7,
	'adv_gallery_upload' => 8,
	'adv_gallery_posting' => 9,
	'adv_gallery_ecard' => 10,
	'adv_gallery_usercats' => 11,
    'adv_gallery_stat' => 12,
    'add_forumhome' => 1
);

// add settings
if ($_REQUEST['do'] == 'add_settings')
{
    foreach ($adv_settinggroups AS $grouptitle => $order){
    	$db->query_write("
            INSERT IGNORE INTO " . TABLE_PREFIX . "ppgal_settinggroup
                (grouptitle, displayorder)
            VALUES
                ('$grouptitle', '$order')
        ");
    }

    foreach ($mainsettings AS $varname => $setting){
        insert_setting(
            $setting['title'],
            $setting['description'],
            $varname,
            $setting['value'],
            $setting['value'],
            $setting['optioncode'],
            $setting['displayorder'],
            $setting['grouptitle']
        );
    }
    build_adv_settings();
    print_cp_redirect($scriptfile . '.php?do=update_settings');
}

// update settings
if ($_REQUEST['do'] == 'update_settings')
{
  foreach ($mainsettings AS $varname => $setting){
      update_setting(
          $varname,
          $setting['title'],
          $setting['description'],
          '',
          '',
          $setting['optioncode'],
          $setting['displayorder']
      );
  }
build_adv_settings();
build_language();
print_cp_redirect($scriptfile .'.php');
}

// ################################## Upgrading ###############################
if ($_REQUEST['do'] == 'upgrade')
{
	print_install_table_start('' . $scriptname . ' Upgrade', 'upgrade');

    // Checking for version
    $version = $db->query_first("SHOW TABLES LIKE '" . TABLE_PREFIX . "ppgal_setting'");

    if (!$version){
     $version = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'gallery_version'");
    }else{
        $version = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "ppgal_setting WHERE varname = 'gallery_version'");
		}

    $step = 1;
    switch ($version['value']){
		case '1.0 RC1':

			// Adding New & Updating Settings
			foreach ($mainsettings AS $varname => $setting)
			{
				if (in_array($varname, array('gallery_origquality', 'gallery_thumbquality')))
				{
					update_setting($varname, $setting['title'], $setting['description'], '', '', $setting['optioncode'], $setting['displayorder']);
				}
				if (in_array($varname, array('gallery_showcatuser')))
				{
					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
				}
			}


		case '1.0 RC2':

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_categories CHANGE description description TEXT DEFAULT NULL");
			$stepphrase .= 'Changed category description to remove 250 character limit.<br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_images ADD ipaddress VARCHAR( 15 ) NOT NULL AFTER notes");
			$stepphrase .= 'Altered images table to include a field for the IP address.<br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_images ADD INDEX (dateline, valid)");
			$stepphrase .= 'Added index on dateline and valid columns in images table.<br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_categories ADD membercat SMALLINT( 3 ) UNSIGNED DEFAULT '0' NOT NULL AFTER catimage");
			$stepphrase .= 'Added membercat column to categories table.<br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_categories ADD adv_setting TEXT NOT NULL AFTER useroptions");
			$stepphrase .= 'Added adv_setting column to categories table.<br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_subscribeimage CHANGE imageid imageid INT( 10 ) DEFAULT '0' NOT NULL , CHANGE userid userid INT( 10 ) DEFAULT '0' NOT NULL");
			$stepphrase .= 'Altered subscribeimage table.<br />';

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_gallery_settinggroup SET displayorder = displayorder+2 WHERE grouptitle LIKE 'adv_gallery%'");
			$stepphrase .= 'Updated adv_settinggroup entries to make room for vBa Global settinggroup.<br />';

			$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup (grouptitle, displayorder) VALUES ('adv_gallery_paths', 2), ('adv_gallery_usercats', 10), ('adv_gallery_categorybit', 5)");

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "adv_gallery_exif (
			  imageid int(10) unsigned NOT NULL default '0',
			  exifinfo text NOT NULL,
			  UNIQUE KEY imageid (imageid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table <b>adv_gallery_exif</b>.<br />';


			// Update blank custom field entries
			$getimages = $db->query_read("
					SELECT imageid, imgid
					FROM " . TABLE_PREFIX . "adv_gallery_images AS images
					LEFT JOIN " . TABLE_PREFIX . "adv_gallery_customfields_entries AS custom ON (images.imageid = custom.imgid)
			");
			while ($image = $vbulletin->db->fetch_array($getimages))
			{
				if (!$image['imgid'])
				{
					$imgidinsert[] = $image['imageid'];
				}
			}

			if (!empty($imgidinsert))
			{
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_gallery_customfields_entries (imgid) VALUES (" . implode('), (', $imgidinsert) . ")");
			}
			$stepphrase .= 'Created entries for blank custom fields entries.<br /><br /><br />';

			require_once(DIR . '/includes/functions_misc.php');

			$usergroups = $db->query_read("SELECT usergroupid, gallerypermissions FROM " . TABLE_PREFIX . "usergroup");
			while ($usergroup = $vbulletin->db->fetch_array($usergroups))
			{
				$perms = convert_bits_to_array($usergroup['gallerypermissions'], $gallerypermissionsbit);

				$perms['canviewlargimage'] = 1;
				$perms['cansendecard'] = 1;

				$galleryperms = convert_array_to_bits($perms, $gallerypermissionsbit, 1);

				$db->query_write("UPDATE " . TABLE_PREFIX . "usergroup SET gallerypermissions = '$galleryperms' WHERE usergroupid = '$usergroup[usergroupid]'");

			}
			require_once(DIR . '/includes/functions_databuild.php');
			build_forum_permissions();
			$stepphrase .= 'Update usergroup permissions to include new permission settings.<br />';

			$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET grouptitle = 'adv_gallery_paths' WHERE varname IN('gallery_url', 'gallery_title', 'gallery_fileurl', 'gallery_userfolder', 'gallery_userfolderurl', 'gallery_filedirectory')");
			// Update / Add New Settings
			foreach ($mainsettings AS $varname => $setting)
			{
				if (in_array($varname, array('gallery_programpath', 'gallery_enablecatjump', 'gallery_slideshowheader', 'gallery_showquickreply', 'gallery_updatepostcount', 'gallery_filedirectory', 'gallery_userfolder')))
				{
					update_setting_adv($varname, $setting['title'], $setting['description'], '', '', $setting['optioncode'], $setting['displayorder']);
				}
				else
				{
					insert_setting_adv($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
				}

				update_setting_adv($varname, '', '', '', '', $setting['optioncode'], $setting['displayorder']);
			}

			$imbitdis = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'gallery_imagebitdisplay'");

			$imdis = iif($imbitdis['value'], 'title,' . $imbitdis['value'], 'title');

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '$imdis' WHERE varname IN('gallery_imagebitdisplay', 'gallery_imagebitdisplay_index')");

			$resizeprogram = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'gallery_resizemethod'");

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . iif($resizeprogram['value'] == 2, 'IM', 'GD2') . "' WHERE varname = 'gallery_resizemethod'");

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_gallery_browsecat' WHERE varname = 'gallery_imagebitdisplay'");

			$ppg_options['gallery_catsorderby'] = 'displayorder';

			// Update Cache
			update_category_cache();

		case '1.0 RC3 Pre':
			// Update Version Number

			$db->reporterror = 0;
			$db->query_write("ALTER TABLE adv_gallery_images DROP INDEX dateline");
			$db->query_write("ALTER TABLE adv_gallery_images ADD INDEX dateline (dateline)");
			$db->reporterror = 1;

			$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_gallery_global'");

			if (!$checkglobal['grouptitle'])
			{
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_gallery_global', 1)");

				foreach ($mainsettings AS $varname => $setting)
				{
					if (in_array($varname, array('gallery_footer_replace', 'gallery_header_replace', 'gallery_navbar_replace', 'portal_outputglobals')))
					{
						insert_setting_adv($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
					}
				}
			}
            unset($checkglobal);
		case '1.0 RC3':

			$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('gallery_ugroups')");

			require_once(DIR . '/includes/functions_misc.php');
			$usergroups = $db->query_read("SELECT usergroupid, gallerypermissions FROM " . TABLE_PREFIX . "usergroup");
			while ($usergroup = $vbulletin->db->fetch_array($usergroups))
			{
				$perms = convert_bits_to_array($usergroup['gallerypermissions'], $gallerypermissionsbit);

				$perms['canvieworiginal'] = 1;

				$galleryperms = convert_array_to_bits($perms, $gallerypermissionsbit, 1);

				$db->query_write("UPDATE " . TABLE_PREFIX . "usergroup SET gallerypermissions = '$galleryperms' WHERE usergroupid = '$usergroup[usergroupid]'");
			}
            unset($usergroups);

			$galleryperms = array();
			$ugroups = $db->query_read("SELECT usergroupid, gallerypermissions, gallery_maxdiskspace, gallery_maxcats FROM " . TABLE_PREFIX . "usergroup");
				while ($ugroup = $vbulletin->db->fetch_array($ugroups))
				{
					$galleryperms["$ugroup[usergroupid]"]['gallery_perms'] = $ugroup['gallerypermissions'];
					$galleryperms["$ugroup[usergroupid]"]['gallery_maxdiskspace'] = $ugroup['gallery_maxdiskspace'];
					$galleryperms["$ugroup[usergroupid]"]['gallery_maxcats'] = $ugroup['gallery_maxcats'];
				}

			build_datastore('gallery_ugroups',serialize($galleryperms),1);
            unset($ugroups);

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP gallerypermissions");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP gallery_maxdiskspace");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP gallery_maxcats");

			$stepphrase .= 'Updated gallery permissions for new permissions system.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_subscribecat ADD catuserid INT(10) UNSIGNED DEFAULT '0' NOT NULL");
			$stepphrase .= 'Altered adv_gallery_subscribecat table to support subscriptions to members\' categories.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_categories CHANGE description description TEXT DEFAULT NULL");
			$stepphrase .= 'Altered adv_gallery_categories table to remove description limit.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_subscribeimage CHANGE imageid imageid INT(10) DEFAULT '0' NOT NULL, CHANGE userid userid INT(10) DEFAULT '0' NOT NULL");


			// Category Images
			$getcats = $db->query_read("SELECT catid, catimage FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE catimage != ''");
			while ($cat = $vbulletin->db->fetch_array($getcats))
			{
				$catimage['url'] = $cat['catimage'];
				$thumbinfo = @getimagesize($ppg_options['gallery_filedirectory'] . '/' . $cat['catimage']);
				$catimage['w'] = $thumbinfo[0];
				$catimage['h'] = $thumbinfo[1];

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET catimage = '" . addslashes(serialize($catimage)) . "' WHERE catid = '$cat[catid]'");
			}
            unset($getcats);
			$stepphrase .= 'Updated category images.<br /><br />';


        case '1.0 RC4':

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '1,2,5,10,25' WHERE varname = 'gallery_newimagelimit'");


        case '1.0.0':
        case '1.0.1':
        case '1.0.1 (vB 3.5)':
        case '1.0.2':
        case '1.0.3':
        case '2.0B2':
		    $checkplug = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'vp_wol4vbagallery'");
			if ($checkplug){
                    delete_product('vp_wol4vbagallery', true);
							}
			$checkplug2 = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'ppvbgallery_admincp'");
			if ($checkplug2){
                    delete_product('ppvbgallery_admincp', true);
							}
             unset($checkplug,$checkplug2);

                        $db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '0' WHERE title = 'gallery_c_cache'");
						$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '0' WHERE title = 'adv_gallery_opt'");
						$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '0' WHERE title = 'gal_mod_cache'");
						$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '0' WHERE title = 'gallery_ugroups'");

						$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE devkey = 'vba_error'");
						$db->query_write("UPDATE " . TABLE_PREFIX . "template SET product = 'ppvbgallery' WHERE username = 'PhotoPost vBGallery'");
			  		    $db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET product = 'ppvbgallery' WHERE varname LIKE 'setting_gallery_%'");
						$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET product = 'ppvbgallery' WHERE varname LIKE 'setting_global_%replace_%'");
						$db->query_write("UPDATE " . TABLE_PREFIX . "phrasetype SET product = 'ppvbgallery' WHERE fieldname LIKE 'adv_gallery%'");
	        	        $db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '2.0' WHERE varname = 'gallery_version'");

   
        case '2.0.0':

	        $db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_setting SELECT * FROM " . TABLE_PREFIX . "adv_setting");
   			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_gallery%'");
   			$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_setting WHERE grouptitle LIKE 'adv_link%'");
   			$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_setting WHERE grouptitle LIKE 'adv_portal%'");
   			$stepphrase = 'Created table adv_setting.<br />';

   			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_settinggroup SELECT * FROM " . TABLE_PREFIX . "adv_settinggroup");
   			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle LIKE 'adv_gallery%'");
   			$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_settinggroup WHERE grouptitle LIKE 'adv_link%'");
   			$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_settinggroup WHERE grouptitle LIKE 'adv_portal%'");
   			$stepphrase .= 'Created table adv_settinggroup.<br />';

   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_categories RENAME TO " . TABLE_PREFIX . "ppgal_categories");
               $db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_customfields RENAME TO " . TABLE_PREFIX . "ppgal_customfields");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_customfields_entries RENAME TO " . TABLE_PREFIX . "ppgal_customfields_entries");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_ecards RENAME TO " . TABLE_PREFIX . "ppgal_ecards");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_exif RENAME TO " . TABLE_PREFIX . "ppgal_exif");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_favorites RENAME TO " . TABLE_PREFIX . "ppgal_favorites");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_filetypes RENAME TO " . TABLE_PREFIX . "ppgal_filetypes");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_images RENAME TO " . TABLE_PREFIX . "ppgal_images");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_moderator RENAME TO " . TABLE_PREFIX . "ppgal_moderator");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_permissions RENAME TO " . TABLE_PREFIX . "ppgal_permissions");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_posts RENAME TO " . TABLE_PREFIX . "ppgal_posts");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_rate RENAME TO " . TABLE_PREFIX . "ppgal_rate");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_search RENAME TO " . TABLE_PREFIX . "ppgal_search");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_subscribecat RENAME TO " . TABLE_PREFIX . "ppgal_subscribecat");
   			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_subscribeimage RENAME TO " . TABLE_PREFIX . "ppgal_subscribeimage");
   			$stepphrase .= 'Renamed gallery tables ppgal_ vs. adv_.<br />';

            case '2.0':
            $checkplug = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'gallery_home'");
    		if ($checkplug){delete_product('gallery_home', true); }
            unset($checkplug);

            $checkplug2 = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'pp_vbgallery'");
    		if ($checkplug2){delete_product('pp_vbgallery', true);	}
            unset($checkplug2);

            $checkplug3 = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "plugin WHERE title = 'vBGallery Uploads in Profile'");
    					if ($checkplug3){
            		$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE title = 'vBGallery Uploads in Profile'");
    					}
            unset($checkplug3);

            $db->query_write("DELETE FROM " . TABLE_PREFIX . "cron WHERE varname LIKE 'gallery_%' AND volatile ='0'");
            $stepphrase = 'Cron table cleanup.<br />';

            $db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE fieldname LIKE 'adv_gallery%' AND languageid = '0' AND dateline = '0'");
            $db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE languageid = '0' AND varname LIKE '%gallery%' AND dateline = '0'");
            $db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_settinggroup WHERE grouptitle = 'adv_global'");
            $stepphrase = 'Settinggroup table cleanup.<br />';

            // Adding style category fields
            $indexfound = false;
    				$indexdata = $vbulletin->db->query_read("SHOW COLUMNS FROM " . TABLE_PREFIX . "ppgal_categories");
            while ($indexlist = $vbulletin->db->fetch_array($indexdata)){
    					if ($indexlist['Field'] == 'styleid'){
    						$indexfound = true;
    					}
    				}
    				if (!$indexfound){
    				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_categories ADD styleid SMALLINT( 5 ) UNSIGNED NOT NULL AFTER catid");
            		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_categories ADD styleoverride SMALLINT( 5 ) UNSIGNED NOT NULL");
          			$ppg_options['gallery_catsorderby'] = 'displayorder';
    				update_category_cache();
    				}
            unset($indexfound,$indexdata);
            $stepphrase = 'Adding style category fields.<br />';

            // Removed post and image count settings
            $db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname LIKE ('setting_gallery_uploadpostcount_%')");
    	    $db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_setting WHERE varname = 'gallery_uploadpostcount'");
            $db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname LIKE ('setting_gallery_updatepostcount_%')");
    		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_setting WHERE varname = 'gallery_updatepostcount'");
            $stepphrase = 'Removed post and image count settings.<br />';

            // Added fields for user image count
            $indexfound = false;
    				$indexdata = $vbulletin->db->query_read("SHOW COLUMNS FROM " . TABLE_PREFIX . "user");
            while ($indexlist = $vbulletin->db->fetch_array($indexdata)){
    					if ($indexlist['Field'] == 'ppicount'){
    						$indexfound = true;
    					}
    				}
    				if (!$indexfound){
            		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD ppicount int(10) NOT NULL");
    						$db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD pppcount int(10) NOT NULL");
    						$users = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid >= 1 ORDER BY userid");
    				    while ($user = $db->fetch_array($users)){
    					  	$totalposts = $db->query_first("SELECT COUNT(*) AS posts FROM " . TABLE_PREFIX . "ppgal_posts AS post WHERE post.userid = $user[userid] AND	visible = 1");
    							$db->query_write("UPDATE " . TABLE_PREFIX . "user SET pppcount = '$totalposts[posts]' WHERE userid = '$user[userid]'");
    		         	$totalimages = $db->query_first("SELECT COUNT(*) AS images FROM " . TABLE_PREFIX . "ppgal_images AS image WHERE image.userid = $user[userid] AND valid = 1");
    							$db->query_write("UPDATE " . TABLE_PREFIX . "user SET ppicount = '$totalimages[images]' WHERE userid = '$user[userid]'");
    						}
    					}
            unset($indexfound, $indexdata, $user, $totalposts, $totalimages);
            $stepphrase = 'Added user post count totals.<br />';
            $stepphrase = 'Added fields for user image count.<br />';
            $stepphrase = 'Added user image count totals.<br />';

    				// Added new gallery settings
            foreach ($adv_settinggroups AS $grouptitle => $order){
                $db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "ppgal_settinggroup (grouptitle, displayorder) VALUES ('$grouptitle', '$order')");
    				}

            foreach ($mainsettings AS $varname => $setting){
    		    insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
    				}

        case '2.1':

            kill_setting('gallery_replaceadmin');

            $db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_stats (
              dateline int(10) unsigned NOT NULL default '0',
              necard mediumint(8) unsigned NOT NULL default '0',
              nimage mediumint(8) unsigned NOT NULL default '0',
              npost mediumint(8) unsigned NOT NULL default '0',
              PRIMARY KEY  (dateline)
            ) TYPE=MyISAM
            ");

            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "administrator ADD vbgadminperms INT( 10 ) UNSIGNED NOT NULL DEFAULT 0");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_filetypes ADD min_width INT( 10 ) UNSIGNED DEFAULT 0 NOT NULL AFTER height , ADD min_height INT( 10 ) UNSIGNED DEFAULT 0 NOT NULL AFTER min_width");
            $db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "datastore VALUES ('ppg_stats', '', 1)");
            $db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '1' WHERE title = 'gallery_c_cache'");
		    $db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '1' WHERE title = 'adv_gallery_opt'");
			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '1' WHERE title = 'gal_mod_cache'");
			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = '1' WHERE title = 'gallery_ugroups'");

            // Adding New & Updating Settings
			foreach ($mainsettings AS $varname => $setting)
			{

				if (in_array($varname, array('gallery_showslideshow', 'gallery_showsubcats', 'gallery_showcatdesc', 'gallery_reportforum', 'gallery_stats_active', 'gallery_stats_uploads', 'gallery_stats_comments', 'gallery_stats_viewed', 'gallery_stats_categories', 'gallery_stats_days', 'gallery_newhomepos','gallery_randomhomepos')))
				{
					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
				}

			update_setting($varname, $setting['title'], $setting['description'], '', '', $setting['optioncode'], $setting['displayorder']);

            }

    		// Added new gallery settings groups
            foreach ($adv_settinggroups AS $grouptitle => $order){
                $db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "ppgal_settinggroup (grouptitle, displayorder) VALUES ('$grouptitle', '$order')");
    		}

              $db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET value = '2.2' WHERE varname = 'gallery_version'");
              $stepphrase = 'Added new gallery settings.<br />';

              build_adv_settings();
              build_language();
              build_gallery_stats();

        case '2.2':

            foreach ($mainsettings AS $varname => $setting)
			{
            	if (in_array($varname, array('gallery_announcement')))
				{
					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
				}

            update_setting($varname, $setting['title'], $setting['description'], '', '', $setting['optioncode'], $setting['displayorder']);
            }

            $columnfound = false;
    		$columndata = $vbulletin->db->query_read("SHOW COLUMNS FROM " . TABLE_PREFIX . "administrator");
            while ($columnlist = $vbulletin->db->fetch_array($columndata)){
        		    if ($columnlist['Field'] == 'vbgadminperms'){
        				$columnfound = true;
        			}
    			}
    			if (!$columnfound){
                    $db->query_write("ALTER TABLE " . TABLE_PREFIX . "administrator ADD vbgadminperms INT( 10 ) UNSIGNED NOT NULL DEFAULT 0");
    			}
            unset($columnfound,$columndata);

            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_categories CHANGE `styleoverride` `styleoverride` SMALLINT( 5 ) UNSIGNED NOT NULL DEFAULT '0'");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_favorites ADD INDEX (imageid)");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_images DROP INDEX dateline");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_images DROP INDEX title , ADD INDEX title (title)");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_images DROP INDEX keywords , ADD INDEX keywords (keywords)");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_posts CHANGE `title` `title` VARCHAR( 250 ) NOT NULL");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_posts CHANGE `pagetext` `pagetext` MEDIUMTEXT NOT NULL");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_posts DROP INDEX iconid");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_posts ADD FULLTEXT (title)");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_rate ADD INDEX (imageid)");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_subscribeimage ADD INDEX (imageid)");


        case '2.3':

            foreach ($mainsettings AS $varname => $setting){
            	if (in_array($varname, array('gallery_showpostbit', 'gallery_navbarlink', 'gallery_stats_forumhome', 'gallery_displayloggedin', 'gallery_displayloggedin_local', 'gallery_randomhomecutoff', 'gallery_newhomecutoff'))){
					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
				}
            update_setting($varname, $setting['title'], $setting['description'], '', '', $setting['optioncode'], $setting['displayorder']);
            }

            flush();
  			add_table_index('ppgal_images', 'dateline');
            add_table_index('ppgal_posts', 'dateline');

            $db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET value = '2.4' WHERE varname = 'gallery_version'");

         case '2.4':
         case '2.4.1':
         case '2.4.2':

            kill_setting('add_profile_active', 'add_profile_column', 'add_profile_exclude', 'add_profile_imagebitdisplay', 'add_profile_include', 'add_profile_limit', 'add_profile_navbar', 'add_profile_orderby', 'add_profile_place');

            foreach ($mainsettings AS $varname => $setting){
            if (in_array($varname, array('add_home_cutoff'))){
					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
				}
            update_setting($varname, $setting['title'], $setting['description'], '', '', $setting['optioncode'], $setting['displayorder']);
            }
            flush();

            $db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_settinggroup WHERE grouptitle = 'add_profile'");
            $db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_user (
              userid int(10) NOT NULL default '0',
              ppicount int(10) NOT NULL default '0',
              pppcount int(10) NOT NULL default '0',
              lastimageid int(10) NOT NULL default '0',
              lastimagetitle varchar(255) NOT NULL default '',
              lastimagedate int(10) NOT NULL default '0',
              lastpostid int(10) NOT NULL default '0',
              lastposttitle varchar(255) NOT NULL default '',
              lastpostdate int(10) NOT NULL default '0',
              profile_active smallint(3) NOT NULL default '1',
              profile_showimg varchar(20) NOT NULL default 'thumbname',
              profile_column smallint(3) NOT NULL default '1',
              profile_exclude varchar(255) NOT NULL default '0',
              profile_include varchar(255) NOT NULL default '0',
              profile_limit smallint(3) NOT NULL default '1',
              profile_orderby smallint(3) NOT NULL default '5',
              profile_place smallint(3) NOT NULL default '4',
              profile_imagebitdisplay varchar(255) NOT NULL default 'title,dateline,filesize,dimensions,views,posts,lastpost,rating,category',
              profile_cutoff smallint(3) NOT NULL default '0',
              PRIMARY KEY  (userid),
              KEY ppicount (ppicount),
              KEY pppcount (pppcount)
            ) ENGINE=MyISAM
            ");

            $users = $db->query_read("SELECT userid, ppicount, pppcount FROM " . TABLE_PREFIX . "user AS user");
            while ($user = $vbulletin->db->fetch_array($users))
            {
                $db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_user (userid, ppicount, pppcount) VALUES ($user[userid], $user[ppicount], $user[pppcount])");
            }
            unset($users);

        	$lastuploads = $db->query_read("SELECT userid FROM " . TABLE_PREFIX . "ppgal_user");
        	while ($last = $vbulletin->db->fetch_array($lastuploads))
        	{
                $lastimage = $db->query_first("SELECT imageid, title, dateline, valid FROM " . TABLE_PREFIX . "ppgal_images WHERE userid = '$last[userid]' AND valid = 1 ORDER BY dateline DESC limit 1");
                $lastpost = $db->query_first("SELECT postid, title, dateline, visible FROM " . TABLE_PREFIX . "ppgal_posts WHERE userid = '$last[userid]' AND visible = 1 ORDER BY dateline DESC limit 1");

        		$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user
                    SET
                    lastimageid = '$lastimage[imageid]',
                    lastimagedate = '$lastimage[dateline]',
                    lastimagetitle = '" . $db->escape_string($lastimage['title']) . "',
                    lastpostdate = '$lastpost[dateline]',
                    lastpostid = '$lastpost[postid]',
                    lastposttitle = '" . $db->escape_string($lastpost['title']) . "'
                    WHERE userid = '$last[userid]'");
            }
            unset($lastuploads,$lastimage,$lastpost);

            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "user DROP ppicount, DROP pppcount");
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_categories ADD title_clean VARCHAR( 100 ) NOT NULL AFTER title") ;
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "ppgal_categories ADD description_clean TEXT NOT NULL AFTER description") ;

            $cats_info = $db->query_read("
		    SELECT title, description, catid
		    FROM " . TABLE_PREFIX . "ppgal_categories
	        ");
            	while ($cat_info = $db->fetch_array($cats_info))
            	{
            		$title_clean = htmlspecialchars_uni(str_replace('&amp;', '&', strip_tags($cat_info['title'])));
            		$description_clean = htmlspecialchars_uni(str_replace('&amp;', '&', strip_tags($cat_info['description'])));
            		$db->query_write("
            			UPDATE " . TABLE_PREFIX . "ppgal_categories
            			SET title_clean = '" . $db->escape_string($title_clean) . "',
            			description_clean = '" . $db->escape_string($description_clean) . "'
            			WHERE catid = $cat_info[catid]
            		");
            	}
           $db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET value = '2.4.3' WHERE varname = 'gallery_version'");

            build_adv_settings();
            build_language();
            build_gallery_stats();

         $stepphrase = 'Added new gallery settings.<br />';

         print_cp_redirect($scriptfile . '.php?do=productug');

    default:
		    $stepphrase = 'You are already running the current version of PhotoPost vBGallery ' . $scriptname . '.';
	}

	print_install_table_end();
}

// ############################### Install ####################################
if (substr($_REQUEST['do'], '', 7) == 'install')
{
	$step = htmlspecialchars($_REQUEST['step']);

	print_install_table_start();

	$only = substr($_REQUEST['do'], 8);

	if ($only)
	{
		$step = $only;
	}

	switch ($step)
	{
		case 1:

		  $db->reporterror = 0;
			$check = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "ppgal_setting WHERE varname = 'gallery_version'");
			
			if ($check['varname'])
			{
				$stepphrase = 'PhotoPost vBGallery ' . $scriptname . ' is already installed!';
				print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
				print_table_footer();
				exit;
			}
			
		// Disable the forums
		if ($vbulletin->options['bbactive'] == '1'){
			$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 0 WHERE varname = 'bbactive'");
			build_options();
		}
			
		  $db->reporterror = 1;

			$db->query_write("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "ppgal_setting (
				varname varchar(100) NOT NULL default '',
				grouptitle varchar(50) NOT NULL default '',
				value mediumtext NOT NULL default '',
				defaultvalue varchar(250) NOT NULL default '',
				optioncode mediumtext NOT NULL,
				displayorder smallint(3) unsigned NOT NULL default '0',
                PRIMARY KEY  (varname)
                ) TYPE=MyISAM
			");

			$stepphrase = 'Created table ppgal_setting.<br />';

			$db->query_write("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "ppgal_settinggroup (
				grouptitle varchar(50) NOT NULL default '',
				displayorder smallint(3) unsigned NOT NULL default '0',
				PRIMARY KEY (grouptitle)
				) TYPE=MyISAM
			");

			$stepphrase .= 'Created table ppgal_settinggroup.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_categories (
			  catid smallint(5) NOT NULL auto_increment,
              styleid smallint(5) unsigned NOT NULL default '0',
			  title varchar(255) NOT NULL default '',
              title_clean varchar(100) NOT NULL default '',
              description text,
              description_clean text,
			  displayorder smallint(4) NOT NULL default '0',
			  hasimages smallint(3) unsigned NOT NULL default '0',
			  active smallint(3) unsigned NOT NULL default '0',
			  catuserid int(10) unsigned NOT NULL default '0',
			  allowusercats smallint(3) unsigned NOT NULL default '0',
			  parent smallint(5) unsigned NOT NULL default '0',
			  parentlist varchar(255) NOT NULL default '',
			  password varchar(100) NOT NULL default '',
			  catimage varchar(255) NOT NULL default '',
			  membercat smallint(3) unsigned NOT NULL default '0',
			  imagecount int(10) NOT NULL default '0',
			  postcount int(10) NOT NULL default '0',
			  lastimageid int(10) NOT NULL default '0',
			  lastimagetitle varchar(255) NOT NULL default '',
			  lastimageuserid int(10) unsigned NOT NULL default '0',
			  lastimageusername varchar(100) NOT NULL default '',
			  lastimagedateline int(10) unsigned NOT NULL default '0',
			  lastpostid int(10) unsigned NOT NULL default '0',
			  lastpostimagetitle varchar(255) NOT NULL default '',
			  lastpostuserid int(10) unsigned NOT NULL default '0',
			  lastpostusername varchar(100) NOT NULL default '',
			  lastpostdateline int(10) unsigned NOT NULL default '0',
			  options int(10) unsigned NOT NULL default '0',
			  useroptions int(10) unsigned NOT NULL default '0',
			  adv_setting text NOT NULL,
			  disext MEDIUMTEXT NOT NULL default '',
			  newimageemail varchar(255) NOT NULL default '',
			  newpostemail varchar(255) NOT NULL default '',
              styleoverride smallint(5) unsigned NOT NULL default '0',
			  PRIMARY KEY (catid),
			  KEY parent (parent)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_categories.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_customfields (
			  fieldid smallint(3) unsigned NOT NULL auto_increment,
			  title varchar(250) NOT NULL default '',
			  description varchar(250) NOT NULL default '',
			  type varchar(20) NOT NULL default '',
			  required smallint(3) unsigned NOT NULL default '0',
			  displayorder smallint(3) unsigned NOT NULL default '0',
			  searchable smallint(3) unsigned NOT NULL default '0',
			  maxlength smallint(3) unsigned NOT NULL default '0',
			  options mediumtext NOT NULL,
			  PRIMARY KEY  (fieldid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_customfields.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_customfields_entries (
			  imgid int(10) unsigned NOT NULL default '0',
			  PRIMARY KEY  (imgid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_customfields_entries.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_ecards (
			  cardid int(10) unsigned NOT NULL auto_increment,
			  userid int(10) unsigned NOT NULL default '0',
			  tousername varchar(100) NOT NULL default '',
			  imageid int(10) unsigned NOT NULL default '0',
			  fromuserid int(10) unsigned NOT NULL default '0',
			  fromusername varchar(100) NOT NULL default '',
			  fromemail varchar(100) NOT NULL default '',
			  title varchar(100) NOT NULL default '',
			  message text NOT NULL,
			  dateline int(10) unsigned NOT NULL default '0',
			  passcode varchar(50) NOT NULL default '',
			  layout smallint(3) unsigned NOT NULL default '0',
			  bgcolors varchar(255) NOT NULL default '',
			  receipt smallint(3) unsigned NOT NULL default '0',
			  showsignature smallint(3) unsigned NOT NULL default '0',
			  allowsmilies smallint(3) unsigned NOT NULL default '0',
			  viewed smallint(3) unsigned NOT NULL default '0',
			  PRIMARY KEY  (cardid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_ecards.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_exif (
			  imageid int(10) unsigned NOT NULL default '0',
			  exifinfo text NOT NULL,
			  UNIQUE KEY imageid (imageid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_exif.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_favorites (
			  userid int(10) NOT NULL default '0',
			  imageid int(10) NOT NULL default '0',
              KEY imageid (imageid)
            ) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_favorites.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_filetypes (
			  extensionid int(10) unsigned NOT NULL auto_increment,
			  extension varchar(100) NOT NULL default '',
			  type varchar(255) NOT NULL default '',
			  filesize int(10) unsigned NOT NULL default '0',
			  width int(10) unsigned NOT NULL default '0',
			  height int(10) unsigned NOT NULL default '0',
              min_width int(10) unsigned NOT NULL default '0',
              min_height int(10) unsigned NOT NULL default '0',
              enabled smallint(3) unsigned NOT NULL default '0',
			  PRIMARY KEY  (extensionid),
			  UNIQUE KEY extension (extension)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_filetypes.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_images (
			  imageid int(10) NOT NULL auto_increment,
			  title varchar(100) NOT NULL default '',
			  description text NOT NULL,
			  keywords varchar(255) NOT NULL default '',
			  catid smallint(5) unsigned NOT NULL default '0',
			  dateline int(10) unsigned NOT NULL default '0',
			  userid int(10) unsigned NOT NULL default '0',
			  username varchar(50) NOT NULL default '',
			  extension tinytext NOT NULL,
			  filename varchar(100) NOT NULL default '',
			  filesize int(10) unsigned NOT NULL default '0',
			  width smallint(5) unsigned NOT NULL default '0',
			  height smallint(5) unsigned NOT NULL default '0',
			  thumbname varchar(100) NOT NULL default '',
			  originalname varchar(255) NOT NULL default '',
			  originalfilesize int(10) unsigned NOT NULL default '0',
			  originalwidth smallint(5) NOT NULL default '0',
			  originalheight smallint(5) NOT NULL default '0',
			  views int(10) unsigned NOT NULL default '0',
			  posts int(10) unsigned NOT NULL default '0',
			  valid smallint(3) unsigned NOT NULL default '0',
			  open smallint(3) unsigned NOT NULL default '0',
			  sticky smallint(3) unsigned NOT NULL default '0',
			  notes varchar(255) NOT NULL default '',
			  ipaddress varchar(15) NOT NULL default '',
			  lastpostusername varchar(100) NOT NULL default '',
			  lastpostuserid int(10) unsigned NOT NULL default '0',
			  lastpostdateline int(10) unsigned NOT NULL default '0',
			  votenum smallint(5) unsigned NOT NULL default '0',
			  votetotal smallint(5) unsigned NOT NULL default '0',
			  PRIMARY KEY  (imageid),
			  KEY userid (userid),
			  KEY cat (catid),
			  KEY keywords (keywords),
			  KEY title (title),
              KEY dateline (dateline),
              FULLTEXT KEY description (description)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_images.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_moderator (
			  userid int(10) unsigned NOT NULL default '0',
			  username varchar(255) NOT NULL default '',
			  catid smallint(5) unsigned NOT NULL default '0'
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_moderator.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_permissions (
			  permissionid int(10) unsigned NOT NULL auto_increment,
			  catid int(10) unsigned NOT NULL default '0',
			  usergroupid int(10) unsigned NOT NULL default '0',
			  permissions int(10) unsigned NOT NULL default '0',
			  PRIMARY KEY  (permissionid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_permissions.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_posts (
			  postid int(10) NOT NULL auto_increment,
			  title varchar(250) NOT NULL default '',
			  userid int(10) NOT NULL default '0',
			  username varchar(50) NOT NULL default '',
			  dateline int(10) NOT NULL default '0',
			  pagetext mediumtext,
			  imageid int(10) NOT NULL default '0',
			  visible smallint(3) unsigned NOT NULL default '0',
			  allowsmilie smallint(3) NOT NULL default '0',
			  iconid smallint(3) unsigned NOT NULL default '0',
			  showsignature smallint(3) NOT NULL default '0',
			  ipaddress varchar(15) NOT NULL default '',
			  PRIMARY KEY  (postid),
			  KEY userid (userid),
              KEY imageid (imageid),
              KEY dateline (dateline),
              FULLTEXT KEY title (title)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_posts.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_rate (
			  rateid int(10) unsigned NOT NULL auto_increment,
			  imageid int(10) unsigned NOT NULL default '0',
			  userid int(10) unsigned NOT NULL default '0',
			  rating smallint(3) unsigned NOT NULL default '0',
			  ipaddress varchar(15) NOT NULL default '',
			  PRIMARY KEY  (rateid),
              KEY imageid (imageid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_rate.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_search (
			  searchid int(10) unsigned NOT NULL auto_increment,
			  string varchar(100) NOT NULL default '',
			  username text NOT NULL default '',
			  sfields varchar(50) NOT NULL default '',
			  catids mediumtext NOT NULL,
			  dateline int(10) unsigned NOT NULL default '0',
			  userid int(10) unsigned NOT NULL default '0',
			  imageids mediumtext NOT NULL,
			  orderby varchar(20) NOT NULL default '',
			  direction varchar(4) NOT NULL default '',
			  numresults smallint(5) unsigned NOT NULL default '0',
			  wholeword smallint(3) unsigned NOT NULL default '0',
			  searchtime float NOT NULL,
			  PRIMARY KEY  (searchid)
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_search.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_subscribecat (
			  userid int(10) unsigned NOT NULL default '0',
			  catid int(10) unsigned NOT NULL default '0',
			  catuserid int(10) unsigned NOT NULL default '0'
			) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_subscribecat.<br />';

			$db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_subscribeimage (
			  imageid int(10) NOT NULL default '0',
			  userid int(10) NOT NULL default '0',
              KEY imageid (imageid)
            ) TYPE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_subscribeimage.<br />';

            $db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_stats (
              dateline int(10) unsigned NOT NULL default '0',
              necard mediumint(8) unsigned NOT NULL default '0',
              nimage mediumint(8) unsigned NOT NULL default '0',
              npost mediumint(8) unsigned NOT NULL default '0',
              PRIMARY KEY (dateline)
            ) TYPE=MyISAM
            ");

            $stepphrase .= '<br />Created table ppgal_stats.<br /><br />';

			$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('gallery_c_cache', '', 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('adv_gallery_opt', '', 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('gal_mod_cache', '', 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('gallery_ugroups', '', 1)");
            $db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('ppg_stats', '', 1)");

            $stepphrase .= '<br />Added fields into the datastore table.<br />';


            $db->query_write("CREATE TABLE " . TABLE_PREFIX . "ppgal_user (
              userid int(10) NOT NULL default '0',
              ppicount int(10) NOT NULL default '0',
              pppcount int(10) NOT NULL default '0',
              lastimageid int(10) NOT NULL default '0',
              lastimagetitle varchar(255) NOT NULL default '',
              lastimagedate int(10) NOT NULL default '0',
              lastpostid int(10) NOT NULL default '0',
              lastposttitle varchar(255) NOT NULL default '',
              lastpostdate int(10) NOT NULL default '0',
              profile_active smallint(3) NOT NULL default '1',
              profile_showimg varchar(20) NOT NULL default 'thumbname',
              profile_column smallint(3) NOT NULL default '1',
              profile_exclude varchar(255) NOT NULL default '0',
              profile_include varchar(255) NOT NULL default '0',
              profile_limit smallint(3) NOT NULL default '1',
              profile_orderby smallint(3) NOT NULL default '5',
              profile_place smallint(3) NOT NULL default '4',
              profile_imagebitdisplay varchar(255) NOT NULL default 'title,dateline,filesize,dimensions,views,posts,lastpost,rating,category',
              profile_cutoff smallint(3) NOT NULL default '0',
              PRIMARY KEY  (userid),
              KEY ppicount (ppicount),
              KEY pppcount (pppcount)
            ) ENGINE=MyISAM
            ");

			$stepphrase .= 'Created table ppgal_subscribeimage.<br /><br />';

            $users = $db->query_read("SELECT userid FROM " . TABLE_PREFIX . "user AS user");
            while ($user = $vbulletin->db->fetch_array($users))
            {
                $db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_user (userid) VALUES ($user[userid])");
            }

            $galleryperms = array();
			$ugroups = $db->query_read("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
			while ($ugroup = $vbulletin->db->fetch_array($ugroups))
			{
				$galleryperms["$ugroup[usergroupid]"]['gallery_perms'] = iif($ugroup['usergroupid'] == 6, 16777203, 15424639);
				$galleryperms["$ugroup[usergroupid]"]['gallery_maxdiskspace'] = 0;
				$galleryperms["$ugroup[usergroupid]"]['gallery_maxcats'] = 0;
			}

			build_datastore('gallery_ugroups',serialize($galleryperms),1);

			$stepphrase .= 'Inserted gallery permissions.<br /><br />';


			// Insert settings
			$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "ppgal_settinggroup WHERE grouptitle = 'adv_gallery_global'");

			if ($checkglobal['grouptitle'])
			{
				unset($adv_settinggroups['adv_gallery_global']);
			}

			foreach ($adv_settinggroups AS $grouptitle => $order)
			{
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_settinggroup (grouptitle, displayorder) VALUES ('$grouptitle', '$order')");
			}

			foreach ($mainsettings AS $varname => $setting)
			{
				insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
			}
			build_adv_settings();

			$stepphrase .= 'Added settings.<br /><br />';

			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_categories (catid, title, title_clean, description, description_clean, displayorder, hasimages, active, parent, parentlist, options) VALUES (1, 'Main Category', 'Main Category', 'Main Category Description', 'Main Category Description', 1, 0, 1, 0, '1', 1666779)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_categories (catid, title, title_clean, description, description_clean, displayorder, hasimages, active, parent, parentlist, options) VALUES (2, 'Main Album', 'Main Album', 'Main Album Description', 'Main Album Description', 1, 1, 1, 1, '2,1', 1666779)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_categories (catid, title, title_clean, description, description_clean, displayorder, hasimages, active, allowusercats, membercat, parent, parentlist, options) VALUES (3, 'Member\'s Categories', 'Member\'s Categories', 'This is an example on how to set up a member\'s category where other user\'s may create and manage their own categories.', 'This is an example on how to set up a member\'s category where other user\'s may create and manage their own categories.', 1, 1, 1, 1, 1, 1, '3,1', 1666779)");

			$ppg_options['gallery_catsorderby'] = 'displayorder';
			update_category_cache();
            build_gallery_stats();
			$stepphrase .= 'Inserted Main Category &amp; Main Album.<br /><br />';

			// Insert filetypes
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (1, 'jpg', 2097152, 600, 600, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (2, 'gif', 2097152, 400, 600, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (3, 'png', 2097152, 400, 600, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (4, 'jpeg', 2097152, 400, 600, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (5, 'bmp', 2097152, 400, 600, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (6, 'mp3', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (7, 'wma', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (8, 'mpeg', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (9, 'wav', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (10, 'avi', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (11, 'midi', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (12, 'mpg', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (13, 'ram', 2097152, 0, 0, 1)");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_filetypes (extensionid, extension, filesize, width, height, enabled) VALUES (14, 'wmv', 2097152, 0, 0, 1)");

			$stepphrase .= 'Inserted filetypes.<br /><br />';

            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "administrator ADD vbgadminperms INT( 10 ) UNSIGNED NOT NULL DEFAULT 0");

            $stepphrase .= 'Inserted Administrator fields.<br /><br />';

			$nextdo = 'productadd';
			$rebuildtemp = true;

		break;


		default:

			$stepphrase = '<b>Welcome to ' . $scriptname . ' version ' . $version . '.</b><br />Please select an action and click the \'Continue\' button.';
	}

	print_install_table_end();
}


// ################################ Edit Paths ################################
if ($_REQUEST['do'] == 'editsettings')
{

	$getphrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE product = 'ppvbgallery' ORDER BY languageid ASC");
	while($phrases = $vbulletin->db->fetch_array($getphrases))
	{
		$settingphrase["$phrases[varname]"] = stripslashes($phrases['text']);
	}

	require_once(DIR . '/includes/adminfunctions_options.php');

	$settings = $db->query_read("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "ppgal_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "ppgal_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE varname IN('gallery_url', 'gallery_title', 'gallery_filedirectory', 'gallery_fileurl', 'gallery_userfolder', 'gallery_userfolderurl')
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $vbulletin->db->fetch_array($settings))
	{
		$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
	}

	if (is_dir($_SERVER['DOCUMENT_ROOT'] . '/gallery/files'))
	{
		$settingscache['adv_gallery_paths']['gallery_filedirectory']['value'] = $_SERVER['DOCUMENT_ROOT'] . '/gallery/files';
		$settingscache['adv_gallery_paths']['gallery_fileurl']['value'] = $vbulletin->options['homeurl'] . '/gallery/files';
		$settingscache['adv_gallery_paths']['gallery_url']['value'] = $vbulletin->options['homeurl'] . '/gallery';
	}
	else if (is_dir($_SERVER['DOCUMENT_ROOT'] . '/' . substr($vbulletin->options['bburl'], strrpos($vbulletin->options['bburl'], '/') + 1) . '/gallery/files'))
	{
		$settingscache['adv_gallery_paths']['gallery_filedirectory']['value'] = $_SERVER['DOCUMENT_ROOT'] . '/' . substr($vbulletin->options['bburl'], strrpos($vbulletin->options['bburl'], '/') + 1) . '/gallery/files';
		$settingscache['adv_gallery_paths']['gallery_fileurl']['value'] = $vbulletin->options['bburl'] . '/gallery/files';
		$settingscache['adv_gallery_paths']['gallery_url']['value'] = $vbulletin->options['bburl'] . '/gallery';
	}

	if (is_dir($_SERVER['DOCUMENT_ROOT'] . '/gallery/users'))
	{
		$settingscache['adv_gallery_paths']['gallery_userfolder']['value'] = $_SERVER['DOCUMENT_ROOT'] . '/gallery/users';
		$settingscache['adv_gallery_paths']['gallery_userfolderurl']['value'] = $vbulletin->options['homeurl'] . '/gallery/users';
	}
	else if (is_dir($_SERVER['DOCUMENT_ROOT'] . '/' . substr($vbulletin->options['bburl'], strrpos($vbulletin->options['bburl'], '/') + 1) . '/gallery/users'))
	{
		$settingscache['adv_gallery_paths']['gallery_userfolder']['value'] = $_SERVER['DOCUMENT_ROOT'] . '/' . substr($vbulletin->options['bburl'], strrpos($vbulletin->options['bburl'], '/') + 1) . '/gallery/users';
		$settingscache['adv_gallery_paths']['gallery_userfolderurl']['value'] = $vbulletin->options['bburl'] . '/gallery/users';
	}


	$db->free_result($settings);
	unset($setting);
	print_form_header('vbgallery_install', 'saveopts');

	print_table_header('Path &amp; URL Settings');
	print_description_row('Here you may go ahead and set your main path &amp; URL settings. This script will attempt to figure out these settings for you, but if the script is unable to and any are left blank then you will need to edit these settings manually.');
	print_table_break();

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_setting_group($grouptitle);
		print_table_break();
	}
	print_submit_row();
}

// ############################# Save Path Settings ###########################
if ($_REQUEST['do'] == 'saveopts')
{
	foreach ($_POST['setting'] AS $varname => $value)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_setting SET value = '" . addslashes($value) . "' WHERE varname = '$varname'");
	}

	build_adv_settings();

	print_cp_redirect($scriptfile . '.php?do=doimages');
}

// ######################### Update Image Paths #######################
if ($_REQUEST['do'] == 'doimages')
{
	$perpage = 50;

	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber');
	$type = $vbulletin->input->clean_gpc('r', 'type');

	if (!$type)
	{
		$type = 'icons';
	}

    function do_path_check($imageurl)
	{
		global $vbulletin;

		$paths = array();

		if (is_file('./' . $imageurl))
		{
			$paths['checked'] = 'checked="checked"';
			$paths['class'] = fetch_row_bgclass();
			$paths['newpath'] = $vbulletin->options['bburl'] . '/' . $imageurl;
		}
		else if (@getimagesize($vbulletin->options['bburl'] . '/' . $imageurl))
		{
			$paths['checked'] = 'checked="checked"';
			$paths['class'] = fetch_row_bgclass();
			$paths['newpath'] = $vbulletin->options['bburl'] . '/' . $imageurl;
		}
		else if (@getimagesize('../' . $imageurl))
		{
			$paths['checked'] = '';
			$paths['class'] = fetch_row_bgclass();
			$paths['newpath'] = $imageurl;
		}
		else if (@fopen($imageurl, "r"))
		{
			$paths['checked'] = '';
			$paths['class'] = fetch_row_bgclass();
			$paths['newpath'] = $imageurl;
		}
		else
		{
			$paths['checked'] = '';
			$paths['class'] = 'redalert';
			$paths['newpath'] = $imageurl;
		}

		return $paths;
	}

	print_form_header($scriptfile, 'updateimages');
	print_table_header('Image Paths', 5);
	print_description_row('For this part of the installation process, we will attempt to update all of your images for use with PhotoPost vBGallery. Please check each image here to make sure that it is displayed properly!<br /><br />
	In most cases, it should not be necessary to make any changes here. If the current image already has the correct path then the "Update" box beside it will not be checked since no changes are necessary. If the current image does not have the correct path, but this script is able to determine the correct path, then the "Update" box will be checked and the correct URL entered into the text box. If neither of the above applies, then you will see the entire box outlined in <font color="red">red</font> and it will be necessary to modify the path yourself.', 0, 5);
	print_table_break();

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	switch ($type)
	{
		case 'icons':
			if ($vbulletin->options['cleargifurl'] != 'clear.gif' AND $pagenumber == 1)
			{
				print_table_break();
				print_table_header('Clear Gif URL', 5);
				print_yes_no_row('It has been determined that your "cleargifurl" option has been changed from the default to "' . $vbulletin->options['cleargifurl'] . '". This is <i>most likely</i> from a previous installation of PhotoPost vBGallery. Since then a problem has been discovered with using full URL to this image. If you would like to change this option back to it\'s original value of "clear.gif", simply make sure that \'Yes\' is checked on the box to the right. If you do not wish to update this image, simply check \'No\' on the box to the right.', 'updateclear', 1);
				print_table_break();
			}

			if ($vbulletin->options['showdeficon'] AND $pagenumber == 1)
			{
				print_table_break();

				print_table_header('Default Post Icon', 5);

				print_cell_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$paths = do_path_check($vbulletin->options['showdeficon']);

				echo '<tr class="' . $paths['class'] . '"><td align="center"><input type="checkbox" name="updatedicon" ' . $paths['checked'] . ' value="1" /></td><td>deficon</td><td align="center"><input name="deficon" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $vbulletin->options['showdeficon'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				print_table_break();
			}

			print_table_header('Update Icon Paths', 5);
			$counticons = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "icon WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'");

            if (!$counticons['count'])
			{
				$nextpage = 1;
				$type = 'smilies';
				print_description_row('No icons need updating. Please click &quot;Save&quot; to continue', '', 5);
			}
			else
			{

            print_cell_row(array('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

            $nextpage = $pagenumber + 1;

			if ($maxlimit > $counticons['count'] OR !$counticons['count'])
			{
				$maxlimit = $counticons['count'];
				$nextpage = 1;
				$type = 'smilies';
			}
			if ($minlimit > $counticons['count'])
			{
			  $minlimit = $counticons['count'] - $perpage;
			}

			if ($minlimit < 0)
			{
			  $minlimit = 1;
			}

			$icons = $db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "icon
                    WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
                    ORDER BY iconid
					LIMIT " . ($minlimit - 1) . ", $perpage
			");
            while ($icon = $db->fetch_array($icons))
				{
					construct_hidden_code('title[' . $icon['iconid'] . ']', $icon['title']);

					$paths = do_path_check($icon['iconpath']);

					echo '<tr class="' . $paths['class'] . '"><td align="$stylevar[left]"><input type="checkbox" name="updateicon[' . $icon['iconid'] . ']" ' . $paths['checked'] . ' value="1" /></td><td>' . $icon['title'] . '</td><td align="center"><input name="iconpath[' . $icon['iconid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $icon['iconpath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';

				}
            }
			print_table_break();

	   	break;

		case 'smilies':

			print_table_header('Update Smilie Paths', 5);


			$countsmilies = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "smilie WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'");

			$nextpage = $pagenumber + 1;

            if (!$countsmilies['count'])
			{
				$nextpage = 1;
				$type = 'styleimages';
				print_description_row('No smilies need updating. Please click &quot;Save&quot; to continue', '', 5);
			}
			else
			{

if ($maxlimit > $countsmilies['count'])
				{
					$maxlimit = $countsmilies['count'];
					$nextpage = 1;
					$type = 'styleimages';
				}
				if ($minlimit > $countsmilies['count'])
				{
					$minlimit = $countsmilies['count'] - $perpage;
				}

				if ($minlimit < 0)
				{
					$minlimit = 1;
				}

				print_cell_row(array('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$smilies = $db->query("
						SELECT * FROM " . TABLE_PREFIX . "smilie
						WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
						ORDER BY smilieid
						LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($smilie = $db->fetch_array($smilies))
				{
					construct_hidden_code('title[' . $smilie['smilieid'] . ']', $smilie['title']);

					$paths = do_path_check($smilie['smiliepath']);

					echo '<tr class="' . $paths['class'] . '"><td align="$stylevar[left]"><input type="checkbox" name="updatesmilie[' . $smilie['smilieid'] . ']" ' . $paths['checked'] . 'value="1" /></td><td>' . $smilie['title'] . '</td><td align="center"><input name="smiliepath[' . $smilie['smilieid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $smilie['smiliepath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				}
			}

		break;

    // ##### Style Images
		case 'styleimages':

			print_table_header('Update Style Paths', 5);
			print_cell_row(array('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Style Var', 'New URL', 'Image Check'), 'thead');

			// Get image titles & paths
			$scache = array();
			$styleimages = $db->query("
				SELECT * FROM " . TABLE_PREFIX . "template
				WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%' AND title != 'EXTRA')
			");
			while ($simage = $db->fetch_array($styleimages))
			{
				$scache["$simage[styleid]"]["$simage[title]"] = $simage['template'];
			}

			// Images to check for
			$stylechecks['imgdir_attach'] = '/attach.gif';
			$stylechecks['imgdir_button'] = '/reply_small.gif';
			$stylechecks['imgdir_editor'] = '/quote.gif';
			$stylechecks['imgdir_misc'] = '/stats.gif';
			$stylechecks['imgdir_poll'] = '/bar6-l.gif';
			$stylechecks['imgdir_rating'] = '/rating_5.gif';
			$stylechecks['imgdir_reputation'] = '/reputation_pos.gif';
			$stylechecks['imgdir_statusicon'] = '/forum_new.gif';

			// Get styles
			$styles = $db->query("SELECT styleid, title FROM " . TABLE_PREFIX . "style WHERE styleid != '-1' ORDER BY styleid, title");
			while ($style = $db->fetch_array($styles))
			{
				print_table_header($style['title'], 4, 0, '', $stylevar['left']);

				if (empty($scache["$style[styleid]"]))
				{
					$scache["$style[styleid]"] = $scache['-1'];
				}

				$defstyle = array_diff(array_keys($stylechecks), array_keys($scache["$style[styleid]"]));

				if (!empty($defstyle))
				{
					foreach ($defstyle AS $varname)
					{
						$scache["$style[styleid]"][$varname] = $scache['-1'][$varname];
					}
				}

				foreach ($scache["$style[styleid]"] AS $varname => $imgpath)
				{
					if (substr($varname, 0, 1) == '.')
					{
						$classarray = unserialize($imgpath);
						$imgpath = $classarray['background'];
						$urlpos = strpos($imgpath, 'url(') + 4;
				    $imgpath = substr($imgpath, $urlpos, (strpos($imgpath, ')', $urlpos) - $urlpos));

						$namepos = strrpos($imgpath, '/');

						$imgcheck = substr($imgpath, $namepos, strlen($imgpath) - $namepos);
						$imgpath = substr($imgpath, 0, $namepos);

					}
					else
					{
						$imgcheck = $stylechecks["$varname"];
					}

					$paths = do_path_check($imgpath . $imgcheck);

					if (substr($varname, 0, 1) == '.')
					{
						$newpath = $paths['newpath'];
					}
					else
					{
						$newpath = substr($paths['newpath'], 0, intval(strlen($paths['newpath']) - strlen($imgcheck)));
					}

					echo '<tr class="' . $paths['class'] . '">
						<td align="$stylevar[left]"><input type="checkbox" name="updatepath[' . $style['styleid'] . '][' . $varname . ']" ' . $paths['checked'] . ' value="1" /></td>
						<td>' . $varname . '</td>
						<td align="center"><input name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $newpath . '" size="50" /></td>
						<td align="center"><div style="overflow: auto; width: 250px; height: 50px;"><img src="' . $paths['newpath'] . '" /></div></td></tr>';
				}

			}
		break;

		print_table_break();
		break;
	}

	construct_hidden_code('type', $type);
	construct_hidden_code('nextpage', $nextpage);
	print_submit_row('Save', 'Reset', 5);
}

// ########################## Do Update Image Paths ####################
if ($_POST['do'] == 'updateimages')
{
	$vbulletin->input->clean_array_gpc('p', array('updateicon', 'iconpath', 'updatesmilie', 'smiliepath', 'updatepath', 'stylepath', 'type' => TYPE_STR, 'nextpage' => TYPE_INT));

	$updateicon = $vbulletin->input->clean_gpc('p', 'updateicon');
	$iconpath = $vbulletin->input->clean_gpc('p', 'iconpath');
	$updatesmilie = $vbulletin->input->clean_gpc('p', 'updatesmilie');
	$smiliepath = $vbulletin->input->clean_gpc('p', 'smiliepath');
	$updatepath = $vbulletin->input->clean_gpc('p', 'updatepath');
	$stylepath = $vbulletin->input->clean_gpc('p', 'stylepath');
	$type = $vbulletin->input->clean_gpc('p', 'type');
	$nextpage = $vbulletin->input->clean_gpc('p', 'nextpage');

	if (is_array($updatepath))
	{
		// Get image titles & paths
		$defstyle = array();
		$styleimages = $db->query("
			SELECT title, template FROM " . TABLE_PREFIX . "template
			WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%') AND styleid = '-1'
		");
		while ($simage = $db->fetch_array($styleimages))
		{
			$defstyle["$simage[title]"] = $simage['template'];
		}

		foreach ($updatepath AS $sid => $values)
		{
			foreach ($values AS $var => $update)
			{
				if ($update)
				{
					$newtemp = $stylepath[$sid][$var];

					$checkit = $db->query_first("SELECT title, template FROM " . TABLE_PREFIX . "template WHERE title = '$var' AND styleid = '$sid'");

					if (substr($var, 0, 1) == '.')
					{
						if (!$checkit['title'])
						{
							$checkit['template'] = $defstyle[$var];
						}

						$template = unserialize($checkit['template']);

						$posone = strpos($template['background'], 'url(') + 4;
						$postwo = strpos($template['background'], ')', $posone);

						$partone = substr($template['background'], 0, $posone);
						$parttwo = substr($template['background'], $postwo, strlen($template['background']));

						$template['background'] = $partone . $newtemp . $parttwo;

						$newtemp = serialize($template);
					}

					if ($checkit['title'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "template SET template = '" . $db->escape_string($newtemp) . "' WHERE title = '$var' AND styleid = '$sid'");
					}
					else
					{
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "template
								(styleid, title, template, template_un, templatetype, dateline, username, product)
							VALUES (
								'$sid',
								'$var',
								'" . $db->escape_string($newtemp) . "',
								'',
								'" . iif(substr($var, 0, 1) == '.', 'css', 'stylevar') . "',
								" . TIMENOW . ",
								'" . $db->escape_string($vbulletin->userinfo['username']) . "',
								'vbulletin'
						)");
					}
				}
			}
		}
		build_all_styles(0, 0, $scriptfile . '.php?do=install&step=finished');
	}

	// Update Icons
	if (is_array($updateicon))
	{
		echo '<b>Updating Icons...</b><br />';
		foreach ($iconpath AS $key => $val)
		{
			if ($updateicon["$key"])
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "icon SET iconpath = '$val' WHERE iconid = '$key'");
				echo '<span class="smallfont">Updated Image: ' . $title[$key] . ' (' . $val . ')</span><br />';
			}
		}
		build_image_cache('icon');
	}

	// Update Smilies
	if (is_array($updatesmilie))
	{
		echo '<br /><br /><b>Updating Smilies...</b><br />';
		foreach ($smiliepath AS $key => $val)
		{
			if ($updatesmilie["$key"])
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "smilie SET smiliepath = '$val' WHERE smilieid = '$key'");
				echo '<span class="smallfont">Updated Image: ' . $title[$key] . ' (' . $val . ')</span><br />';
			}
		}
		build_image_cache('smilie');
	}

	if ($_POST['updateclear'])
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 'clear.gif' WHERE varname = 'cleargifurl'");
		echo '<br />clear.gif updated.<br />';
		build_options();
	}

	if ($_POST['updatedicon'])
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '$deficon' WHERE varname = 'showdeficon'");
		echo '<br />showdeficon updated.<br />';
		build_options();
	}

	if ($nextpage)
	{
		print_cp_redirect($scriptfile . '.php?do=doimages&type=' . $type . '&pagenumber=' . $nextpage);
	}
	else
	{
		// Turn on the forums
		$db->query("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
		build_options();
		print_cp_redirect('index.php');
	}
}

// ############################ Update Image Paths ############################
if ($_REQUEST['do'] == 'updateexif')
{

	$perpage = 1000;

	require_once(DIR . '/includes/functions_gallery_imageedit.php');

	$pagenumber = $_REQUEST['pagenumber'];

	if (!intval($pagenumber))
	{
		echo 'This part of the upgrade will move all of you EXIF info for images into a new table.</b><br /><br /><a href="vbgallery_install.php?do=updateexif&pagenumber=1">Click here</a> to continue';
		exit;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	$countimages = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "ppgal_images");

	$pagecount = ceil($countimages['count'] / $perpage);

	if (!$pagecount)
	{
		$pagecount = 1;
	}

	$lastpage = ceil($countimages['count'] / $perpage);

	echo 'Page ' . $pagenumber . ' of ' . $lastpage . '<br /><br />';

	if ($maxlimit > $countimages['count'])
	{
		$maxlimit = $countimages['count'];
		if ($minlimit > $countimages['count'])
		{
		  $minlimit = $countimages['count'] - $perpage;
		}
	}
	if ($minlimit <= 0)
	{
	  $minlimit = 1;
	}
	$limit = ($minlimit - 1) . ',' . $perpage;

	$images = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_images LIMIT $limit");
	while ($image = $vbulletin->db->fetch_array($images))
	{
		if (function_exists('exif_read_data'))
		{
			$exif['info'] = @exif_read_data($ppg_options['gallery_filedirectory'] . '/' . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY)) . '/' . $image['filename'], 'EXIF');

			$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_exif (imageid, exifinfo) VALUES ('$image[imageid]', '" . addslashes(serialize($exif['info'])) . "')");
		}

		unset($image);
	}

	if ($pagenumber == $pagecount)
	{
		echo 'Upgrade complete! <a href="index.php">Click here</a> to log into your Admin CP.';
	}
	else
	{
		$nextpage = $pagenumber + 1;

		print_cp_redirect('vbgallery_install.php?do=updateexif&pagenumber=' . $nextpage);
	}
}

if ($_REQUEST['do'] == 'globalsettings')
{
	foreach ($mainsettings AS $varname => $setting)
	{
		if (in_array($varname, array('gallery_navbar_replace', 'gallery_header_replace', 'gallery_footer_replace')))
		{
			insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
		}
	}
	build_adv_settings();

}

////////////////////////////////////////////////////////////////////////
 if ($_REQUEST['do'] == 'productadd')
{
$stepphrase = '<center><b>We are about to Import the product.</b><br />Please click the \'Continue\' button.</center>';
print_form_header($scriptfile , 'productimport', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.productfile);');
print_table_header('Import Product');
print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
print_submit_row($vbphrase['import'],0);
}


if ($_REQUEST['do'] == 'productimport' OR $_REQUEST['do'] == 'productupdate' OR $_REQUEST['do'] == 'productug')
	{
		print_dots_start('<b>' . $vbphrase['importing_product'] . "</b>, $vbphrase[please_wait]", ':', 'dspan');


    	  $xml = file_read($vbulletin->config['Misc']['admincpdir'] . '/product-ppvbgallery.xml');
				
		  $vbulletin->GPC['allowoverwrite'] = 1;
    	  
    	  require_once(DIR . '/includes/class_xml.php');
    	
				$xmlobj = new vB_XML_Parser($xml);
				if ($xmlobj->error_no == 1)
				{
						print_dots_stop();
						print_stop_message('no_xml_and_no_path');
				}
			
				if(!$arr = $xmlobj->parse())
				{
					print_dots_stop();
					print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
				}
			
				// ############## general product information
				$info = array(
					'productid'       => substr($arr['productid'], 0, 25),
					'title'           => $arr['title'],
					'description'     => $arr['description'],
					'version'         => $arr['version'],
					'active'          => $arr['active'],
					'url'             => $arr['url'],
					'versioncheckurl' => $arr['versioncheckurl']
				);
    	
			
				// get system version info
				$system_versions = array(
					'php' => phpversion(),
					'vbulletin' => $vbulletin->options['templateversion'],
					'products' => fetch_product_list(true)
				);
				$mysql_version = $db->query_first("SELECT VERSION() AS version");
				$system_versions['mysql'] = $mysql_version['version'];

				// ############## import dependencies
				if (is_array($arr['dependencies']['dependency']))
				{
					$dependencies =& $arr['dependencies']['dependency'];
					if (!isset($dependencies[0]))
					{
						$dependencies = array($dependencies);
					}
			
					$dependency_errors = array();
					$ignore_dependency_errors = array();
			
					// let's check the dependencies
					foreach ($dependencies AS $dependency)
					{
						// if we get an error, we haven't met this dependency
						// if we go through without a problem, we have automatically met
						// all dependencies for this "class" (mysql, php, vb, a specific product, etc)
						$this_dependency_met = true;
			
						// build a phrase for the version compats -- will look like (minver / maxver)
						if ($dependency['minversion'])
						{
							$compatible_phrase = construct_phrase(
								$vbphrase['compatible_starting_with_x'],
								htmlspecialchars_uni($dependency['minversion'])
							);
						}
						else
						{
							$compatible_phrase = '';
						}
			
						if ($dependency['maxversion'])
						{
							$incompatible_phrase = construct_phrase(
								$vbphrase['incompatible_with_x_and_greater'],
								htmlspecialchars_uni($dependency['maxversion'])
							);
						}
						else
						{
							$incompatible_phrase = '';
						}

						if ($compatible_phrase OR $incompatible_phrase)
						{
							$required_version_info = "($compatible_phrase";
							if ($compatible_phrase AND $incompatible_phrase)
							{
								$required_version_info .= ' / ';
							}
							$required_version_info .= "$incompatible_phrase)";
						}
			
						// grab the appropriate installed version string
						if ($dependency['dependencytype'] == 'product')
						{
							// group dependencies into types -- individual products get their own group
							$dependency_type_key = "product-$dependency[parentproductid]";
			
							// undocumented feature -- you can put a producttitle attribute in a dependency so the id isn't displayed
							$parent_product_title = (!empty($dependency['producttitle']) ? $dependency['producttitle'] : $dependency['parentproductid']);
			
							$parent_product = $system_versions['products']["$dependency[parentproductid]"];
							if (!$parent_product)
							{
								// required product is not installed
								$dependency_errors["$dependency_type_key"] = construct_phrase(
									$vbphrase['product_x_must_be_installed'],
									htmlspecialchars_uni($parent_product_title),
									$required_version_info
								);
								continue; // can't do version checks if the product isn't installed
							}
							else if ($parent_product['active'] == 0)
							{
								// product is installed, but inactive
								$dependency_errors["{$dependency_type_key}-inactive"] = construct_phrase(
									$vbphrase['product_x_must_be_activated'],
									htmlspecialchars_uni($parent_product_title)
								);
								$this_dependency_met = false;
								// allow version checks to continue
							}
			
							$sys_version_str = $parent_product['version'];
							$version_incompatible_phrase = 'product_incompatible_version_x_product_y';
						}
						else
						{
							$dependency_type_key = $dependency['dependencytype'];
							$parent_product_title = '';
							$sys_version_str = $system_versions["$dependency[dependencytype]"];
							$version_incompatible_phrase = 'product_incompatible_version_x_' . $dependency['dependencytype'];
						}
			
						// if no version string, we are trying to do an unsupported dep check
						if ($sys_version_str == '')
						{
							continue;
						}
			
						$sys_version = fetch_version_array($sys_version_str);

			
						// error if installed version < minversion
						if ($dependency['minversion'])
						{
							$dep_version = fetch_version_array($dependency['minversion']);
			
							for ($i = 0; $i <= 5; $i++)
							{
								if ($sys_version["$i"] < $dep_version["$i"])
								{
									// installed version is too old
									$dependency_errors["$dependency_type_key"] = construct_phrase(
										$vbphrase["$version_incompatible_phrase"],
										htmlspecialchars_uni($sys_version_str),
										$required_version_info,
										$parent_product_title
									);
									$this_dependency_met = false;
									break;
								}
							}
						}
			
						// error if installed version >= maxversion
						if ($dependency['maxversion'])
						{
							$dep_version = fetch_version_array($dependency['maxversion']);
			
							$all_equal = true;

							for ($i = 0; $i <= 5; $i++)
							{
								if ($sys_version["$i"] > $dep_version["$i"])
								{
									// installed version is newer than the maxversion
									$dependency_errors["$dependency_type_key"] = construct_phrase(
										$vbphrase["$version_incompatible_phrase"],
										htmlspecialchars_uni($sys_version_str),
										$required_version_info,
										$parent_product_title
									);
									$this_dependency_met = false;
									break;
								}
								else if ($sys_version["$i"] != $dep_version["$i"])
								{
									// not ever part is the same
									$all_equal = false;
								}
							}
			
							if ($all_equal == true)
							{
								// installed version is same as the max version, which is the first incompat version
								$dependency_errors["$dependency_type_key"] = construct_phrase(
									$vbphrase["$version_incompatible_phrase"],
									htmlspecialchars_uni($sys_version_str),
									$required_version_info,
									$parent_product_title
								);
								$this_dependency_met = false;
							}
						}
			
						if ($this_dependency_met)
						{
							// we met 1 dependency for this type -- this emulates or'ing together groups
							$ignore_dependency_errors["$dependency_type_key"] = true;
						}
					}
			
					// for any group we met a dependency for, ignore any errors we might
					// have gotten for the group
					foreach ($ignore_dependency_errors AS $dependency_type_key => $devnull)
					{
						unset($dependency_errors["$dependency_type_key"]);
					}
			
					if ($dependency_errors)
					{
						$dependency_errors = array_unique($dependency_errors);
						$dependency_errors = '<ol><li>' . implode('</li><li>', $dependency_errors) . '</li></ol>';
			
						print_dots_stop();
						print_stop_message('dependencies_not_met_x', $dependency_errors);
					}
				}
			
				// look to see if we already have this product installed
				if ($existingprod = $db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "product
					WHERE productid = '" . $db->escape_string($info['productid']) . "'"
				))
				{
					if (!$vbulletin->GPC['allowoverwrite'])
					{
						print_dots_stop();
						print_stop_message('product_x_installed_no_overwrite', $info['title']);
					}

					$active = $existingprod['active'];
			
					// not sure what we're deleting, so rebuild everything
					$rebuild = array(
						'templates' => true,
						'plugins'   => true,
						'phrases'   => true,
						'options'   => true,
						'cron'      => true
					);
			
					$installed_version = $existingprod['version'];
				}
				else
				{
					$active = 1;
			
					$rebuild = array(
						'templates' => false,
						'plugins'   => false,
						'phrases'   => false,
						'options'   => false,
						'cron'      => false
					);
			
					$installed_version = null;
				}
			
				// ############## import install/uninstall code
				if (is_array($arr['codes']['code']))
				{
					$codes =& $arr['codes']['code'];
					if (!isset($codes[0]))
					{
						$codes = array($codes);
					}
			
					// run each of the codes
					foreach ($codes AS $code)
					{
						// Run if: code version is * (meaning always run), no version
						//		previously installed, or if the code is for a newer version
						//		than is currently installed
						if ($code['version'] == '*' OR $installed_version === null OR is_newer_version($code['version'], $installed_version))
						{
							eval($code['installcode']);
						}
					}
				}
			
				// dependencies checked, install code run. Now clear out the old product info;
				// settings should be retained in memory already
				delete_product($info['productid']);
			
				if (is_array($codes))
				{
					// we've now run all the codes, if execution is still going
					// then it's going to complete fully, so insert the codes
					foreach ($codes AS $code)
					{
						/* insert query */
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "productcode
								(productid, version, installcode, uninstallcode)
							VALUES
								('" . $db->escape_string($info['productid']) . "',
								'" . $db->escape_string($code['version']) . "',
								'" . $db->escape_string($code['installcode']) . "',
								'" . $db->escape_string($code['uninstallcode']) . "')
						");
					}
				}
			
				if (is_array($dependencies))
				{
					// dependencies met, codes run -- now we can insert the dependencies into the DB
					foreach ($dependencies AS $dependency)
					{
						/* insert query */
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "productdependency
								(productid, dependencytype, parentproductid, minversion, maxversion)
							VALUES
								('" . $db->escape_string($info['productid']) . "',
								'" . $db->escape_string($dependency['dependencytype']) . "',
								'" . $db->escape_string($dependency['parentproductid']) . "',
								'" . $db->escape_string($dependency['minversion']) . "',
								'" . $db->escape_string($dependency['maxversion']) . "')
						");
					}
				}
			
				/* insert query */
				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "product
						(productid, title, description, version, active, url, versioncheckurl)
					VALUES
						('" . $db->escape_string($info['productid']) . "',
						'" . $db->escape_string($info['title']) . "',
						'" . $db->escape_string($info['description']) . "',
						'" . $db->escape_string($info['version']) . "',
						" . intval($active) . ",
						'" . $db->escape_string($info['url']) . "',
						'" . $db->escape_string($info['versioncheckurl']) . "')
				");

				// ############## import templates
				if (is_array($arr['templates']['template']))
				{
					$querybits = array();
					$querytemplates = 0;
			
					$templates =& $arr['templates']['template'];
					if (!isset($templates[0]))
					{
						$templates = array($templates);
					}
			
					foreach ($templates AS $template)
					{
						$title = $db->escape_string($template['name']);
						$template['template'] = $db->escape_string($template['value']);
						$template['username'] = $db->escape_string($template['username']);
						$template['templatetype'] = $db->escape_string($template['templatetype']);
						$template['date'] = intval($template['date']);
			
						if ($template['templatetype'] != 'template')
						{
							// template is a special template
							$querybits[] = "(-1, '$template[templatetype]', '$title', '$template[template]', '', $template[date], '$template[username]', '" . $db->escape_string($template['version']) . "', '" . $db->escape_string($info['productid']) . "')";
						}
						else
						{
							// template is a standard template
							$querybits[] = "(-1, '$template[templatetype]', '$title', '" . $db->escape_string(compile_template($template['value'])) . "', '$template[template]', $template[date], '$template[username]', '" . $db->escape_string($template['version']) . "', '" . $db->escape_string($info['productid']) . "')";
						}
						if (++$querytemplates % 20 == 0)
						{
							/*insert query*/
							$db->query_write("
								REPLACE INTO " . TABLE_PREFIX . "template
									(styleid, templatetype, title, template, template_un, dateline, username, version, product)
								VALUES
									" . implode(',', $querybits) . "
							");
							$querybits = array();
						}
					}
			
					// insert any remaining templates
					if (!empty($querybits))
					{
						/*insert query*/
						$db->query_write("
							REPLACE INTO " . TABLE_PREFIX . "template
								(styleid, templatetype, title, template, template_un, dateline, username, version, product)
							VALUES
								" . implode(',', $querybits) . "
						");
					}
					unset($querybits);
			
					$rebuild['templates'] = true;
				}
			
				// ############## import hooks/plugins
				if (is_array($arr['plugins']['plugin']))
				{
					$plugins =& $arr['plugins']['plugin'];
					if (!isset($plugins[0]))
					{
						$plugins = array($plugins);
					}
			
					foreach ($plugins AS $plugin)
					{
						$plugin['product'] = $info['productid'];
						unset($plugin['devkey']);
			
						$db->query_write(fetch_query_sql($plugin, 'plugin'));
					}
			
					$rebuild['plugins'] = true;
				}
			
				// ############## import phrases
				if (is_array($arr['phrases']['phrasetype']))
				{
					require_once(DIR . '/includes/adminfunctions_language.php');
			
					$master_phrasetypes = array();
					$master_phrasefields = array();
					foreach(fetch_phrasetypes_array(false) as $phrasetype)
					{
						$master_phrasefields["$phrasetype[fieldname]"] = true;
					}
			
					$phrasetypes =& $arr['phrases']['phrasetype'];
					if (!isset($phrasetypes[0]))
					{
						$phrasetypes = array($phrasetypes);
					}

					foreach ($phrasetypes AS $phrasetype)
					{
						if (empty($phrasetype['phrase']))
						{
							continue;
						}
			
						if ($phrasetype['fieldname'] == '' OR !preg_match('#^[a-z0-9_]+$#i', $phrasetype['fieldname'])) // match a-z, A-Z, 0-9,_ only
						{
							continue;
						}

						$fieldname = $master_phrasefields["$phrasetype[fieldname]"];
			
						if (!$fieldname)
						{
							$db->query_write("
								INSERT IGNORE INTO " . TABLE_PREFIX . "phrasetype
									(fieldname, title, editrows, product)
								VALUES
									('" . $db->escape_string($phrasetype['fieldname']) . "',
									'" . $db->escape_string($phrasetype['name']) . "',
									3,
									'" . $db->escape_string($info['productid']) . "')
							");

							// need to add the column to the language table as well
							require_once(DIR . '/includes/class_dbalter.php');
			
							$db_alter =& new vB_Database_Alter_MySQL($db);
							if ($db_alter->fetch_table_info('language'))
							{
								$db_alter->add_field(array(
									'name' => "phrasegroup_$phrasetype[fieldname]",
									'type' => 'mediumtext'
								));
							}
						}
			
						$phrases =& $phrasetype['phrase'];
						if (!isset($phrases[0]))
						{
							$phrases = array($phrases);
						}

						$sql = array();
			
						foreach ($phrases AS $phrase)
						{
							$sql[] = "
								(-1,
								'" . $db->escape_string($phrasetype['fieldname']) . "',
								'" . $db->escape_string($phrase['name']) . "',
								'" . $db->escape_string($phrase['value']) . "',
								'" . $db->escape_string($info['productid']) . "',
								'" . $db->escape_string($phrase['username']) . "',
								" . intval($phrase['date']) . ",
								'" . $db->escape_string($phrase['version']) . "')
							";
						}
			
						/*insert query*/
						$db->query_write("
							REPLACE INTO " . TABLE_PREFIX . "phrase
								(languageid, fieldname, varname, text, product, username, dateline, version)
							VALUES
								" . implode(',', $sql)
						);
					}

					$rebuild['phrases'] = true;
				}
			
				// ############## import settings
				if (is_array($arr['options']['settinggroup']))
				{
					$settinggroups =& $arr['options']['settinggroup'];
					if (!isset($settinggroups[0]))
					{
						$settinggroups = array($settinggroups);
					}
			
					foreach ($settinggroups AS $group)
					{
						if (empty($group['setting']))
						{
							continue;
						}
			
						// create the setting group if it doesn't already exist
						/*insert query*/
						$db->query_write("
							INSERT IGNORE INTO " . TABLE_PREFIX . "settinggroup
								(grouptitle, displayorder, volatile, product)
							VALUES
								('" . $db->escape_string($group['name']) . "',
								" . intval($group['displayorder']) . ",
								1,
								'" . $db->escape_string($info['productid']) . "')
						");

						$settings =& $group['setting'];
						if (!isset($settings[0]))
						{
							$settings = array($settings);
						}
			
						$setting_bits = array();

						foreach ($settings AS $setting)
						{
							if (isset($vbulletin->options["$setting[varname]"]))
							{
								$newvalue = $vbulletin->options["$setting[varname]"];
							}
							else
							{
								$newvalue = $setting['defaultvalue'];
							}
			
							$setting_bits[] = "(
								'" . $db->escape_string($setting['varname']) . "',
								'" . $db->escape_string($group['name']) . "',
								'" . $db->escape_string(trim($newvalue)) . "',
								'" . $db->escape_string(trim($setting['defaultvalue'])) . "',
								'" . $db->escape_string(trim($setting['datatype'])) . "',
								'" . $db->escape_string($setting['optioncode']) . "',
								" . intval($setting['displayorder']) . ",
								" . intval($setting['advanced']) . ",
								1,
								'" . $db->escape_string($setting['validationcode']) . "',
								" . intval($setting['blacklist']) . ",
								'" . $db->escape_string($info['productid']) . "'\n\t)";
						}

						/*insert query*/
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "setting
								(varname, grouptitle, value, defaultvalue, datatype, optioncode, displayorder, advanced, volatile, validationcode, blacklist, product)
							VALUES
								" . implode(",\n\t", $setting_bits)
						);
					}
			
					$rebuild['options'] = true;
				}
			
				// ############## import admin help
				if (is_array($arr['helptopics']['helpscript']))
				{
					$help_scripts =& $arr['helptopics']['helpscript'];
					if (!isset($help_scripts[0]))
					{
						$help_scripts = array($help_scripts);
					}
			
					foreach ($help_scripts AS $help_script)
					{
						// Deal with single entry
						if (!is_array($help_script['helptopic'][0]))
						{
							$help_script['helptopic'] = array($help_script['helptopic']);
						}
			
						$help_sql = array();
						foreach ($help_script['helptopic'] AS $topic)
						{
							$helpsql[] = "
								('" . $db->escape_string($help_script['name']) . "',
								'" . $db->escape_string($topic['act']) . "',
								'" . $db->escape_string($topic['opt']) . "',
								" . intval($topic['disp']) . ",
								1,
								'" . $db->escape_string($info['productid']) . "')
							";
						}

						if (!empty($helpsql))
						{
							/*insert query*/
							$db->query_write("
								REPLACE INTO " . TABLE_PREFIX . "adminhelp
									(script, action, optionname, displayorder, volatile, product)
								VALUES
									" . implode(",\n\t", $helpsql)
							);
						}
					}
				}
			
				// ############## import cron
				if (is_array($arr['cronentries']['cron']))
				{
					require_once(DIR . '/includes/functions_cron.php');
			
					$cron_entries =& $arr['cronentries']['cron'];
					if (!isset($cron_entries[0]))
					{
						$cron_entries = array($cron_entries);
					}
			
					foreach ($cron_entries AS $cron)
					{
						$cron['varname'] = preg_replace('#[^a-z0-9_]#i', '', $cron['varname']);
						if (!$cron['varname'])
						{
							continue;
						}
			
						$cron['active'] = ($cron['active'] ? 1 : 0);
						$cron['loglevel'] = ($cron['loglevel'] ? 1 : 0);
			
						$scheduling = $cron['scheduling'];
						$scheduling['weekday'] = intval($scheduling['weekday']);
						$scheduling['day'] = intval($scheduling['day']);
						$scheduling['hour'] = intval($scheduling['hour']);
						$scheduling['minute'] = explode(',', preg_replace('#[^0-9,-]#i', '', $scheduling['minute']));
						if (count($scheduling['minute']) == 0)
						{
							$scheduling['minute'] = array(0);
						}
						else
						{
							$scheduling['minute'] = array_map('intval', $scheduling['minute']);
						}
			
						/*insert query*/
						$db->query_write("
							REPLACE INTO " . TABLE_PREFIX . "cron
								(weekday, day, hour, minute, filename, loglevel, active, varname, volatile, product)
							VALUES
								($scheduling[weekday],
								$scheduling[day],
								$scheduling[hour],
								'" . $db->escape_string(serialize($scheduling['minute'])) . "',
								'" . $db->escape_string($cron['filename']) . "',
								$cron[loglevel],
								$cron[active],
								'" . $db->escape_string($cron['varname']) . "',
								1,
								'" . $db->escape_string($info['productid']) . "')
						");
						$cronid = $db->insert_id(); // replace either inserts, or deletes+inserts
						if ($cronid)
						{
							build_cron_item($cronid);
						}
			
						$rebuild['cron'] = true;
					}
				}
			
				// ############## import cron
				if (is_array($arr['faqentries']['faq']))
				{
					$faq_entries =& $arr['faqentries']['faq'];
					if (!isset($faq_entries[0]))
					{
						$faq_entries = array($faq_entries);
					}
			
					$sql = array();
					foreach ($faq_entries AS $faq)
					{
						$sql[] = "
							('" . $db->escape_string($faq['faqname']) . "',
							'" . $db->escape_string($faq['faqparent']) . "',
							" . intval($faq['displayorder']) . ",
							1,
							'" . $db->escape_string($info['productid']) . "')
						";
					}

					if ($sql)
					{
						/*insert query*/
						$db->query_write("
							REPLACE INTO " . TABLE_PREFIX . "faq
								(faqname, faqparent, displayorder, volatile, product)
							VALUES
								" . implode(',', $sql) . "
						");
					}
				}
			
				// Check if the plugin system is disabled. If it is, enable it.
				if (!$vbulletin->options['enablehooks'])
				{
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "setting
						SET value = '1'
						WHERE varname = 'enablehooks'
					");
			
					$rebuild['options'] = true;
				}
  
        build_all_styles();
        vBulletinHook::build_datastore($db);

        require_once(DIR . '/includes/adminfunctions_language.php');
        build_language();
        build_adv_settings();
        build_options();
	   	build_product_datastore();

			
        // build bitfields to remove/add this products bitfields
        require_once(DIR . '/includes/class_bitfield_builder.php');
        vB_Bitfield_Builder::save($db);

        print_dots_stop();

        if (!defined('DISABLE_PRODUCT_REDIRECT')){
           define('CP_REDIRECT', 'plugin.php?do=product');
        }
				if ($_REQUEST['do'] == 'productug'){
                       	// Turn on the forums
	                $db->query("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
                    	build_options();
                        print_cp_redirect('index.php');
					}
				if ($_REQUEST['do'] == 'productimport'){
						print_cp_redirect($scriptfile .'.php?do=editsettings');
					}else{
						print_cp_redirect($scriptfile .'.php');
					}
		}

// ############################ Last Step #############################
if ($_REQUEST['do'] == 'finished')
{
	// Turn on the forums
	$db->query("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
	build_options();
	
	print_install_table_start();

	$stepphrase = 'PhotoPost vBGallery ' . $scriptname . ' installation complete!<br /><br /><span style="color:red"><b>You should now delete this file from your admincp directory.<br />Leaving this file here could be a security risk!</b></span><br /><br /><a href="index.php"><b>Log Into Admin CP --&gt;</b></a>';
	$step = 'finished';

	print_install_table_end();
}

// ######################### Uninstall #########################
if ($_REQUEST['do'] == 'uninstall')
{
	$step = $_POST['step'];

	print_form_header($scriptfile, 'uninstall');
	print_table_header('Uninstall PhotoPost vBGallery ' . $scriptname);

	$db->reporterror = 0;

	switch ($step)
	{
		case 1:
			$stepphrase = 'We\'re sorry you didn\'t like PhotoPost vBGallery ' . $scriptname . '. Running this script will remove all changes that were made for PhotoPost vBGallery ' . $scriptname . '.</div>';
			
		break;

		case 2:
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_categories");
			$stepphrase = 'Removed table ppgal_categories.<br />';

			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_customfields");
			$stepphrase = 'Removed table ppgal_customfields.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_customfields_entries");
			$stepphrase = 'Removed table ppgal_customfields_entries.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_ecards");
			$stepphrase = 'Removed table ppgal_ecards.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_exif");
			$stepphrase = 'Removed table ppgal_exif.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_favorites");
			$stepphrase = 'Removed table ppgal_favorites.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_filetypes");
			$stepphrase = 'Removed table ppgal_filetypes.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_images");
			$stepphrase = 'Removed tables ppgal_images.<br />';

			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_moderator");
			$stepphrase = 'Removed tables ppgal_moderator.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_permissions");
			$stepphrase = 'Removed tables ppgal_permissions.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_posts");
			$stepphrase = 'Removed tables ppgal_posts.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_rate");
			$stepphrase = 'Removed tables ppgal_rate.<br />';
			
			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_search");
			$stepphrase = 'Removed tables ppgal_search.<br />';

			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_setting");
			$stepphrase = 'Removed tables ppgal_setting.<br />';

			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_settinggroup");
			$stepphrase = 'Removed tables ppgal_settinggroup.<br />';

   			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_stats");
			$stepphrase = 'Removed tables ppgal_stats.<br />';

			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_subscribecat");
			$stepphrase = 'Removed tables ppgal_subscribecat.<br />';

			$db->query_read("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_subscribeimage");
			$stepphrase = 'Removed tables ppgal_subscribeimage.<br />';
	
			$stepphrase = 'Removed tables.<br /><br />';

			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "ppgal_user");
			$stepphrase .= 'Removed ppgal_user table.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "datastore WHERE title IN('gallery_c_cache', 'adv_gallery_opt', 'gal_mod_cache', 'gallery_ugroups', 'ppg_stats')");
			$stepphrase .= 'Removed fields from the datastore table.<br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = 'ppvbgallery'");
			$stepphrase .= 'Removed Product.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "productcode WHERE productid = 'ppvbgallery'");
			$stepphrase .= 'Removed Productcode.<br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "productdependency WHERE productid = 'ppvbgallery'");
			$stepphrase .= 'Removed Product Dependency.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE product = 'ppvbgallery'");
			$stepphrase .= 'Removed Plugins.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = 'ppvbgallery' AND languageid IN (-1, 0)");
			$stepphrase .= 'Removed Phrases.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE product = 'ppvbgallery'");
			$stepphrase .= 'Removed Phrasetypes.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = 'ppvbgallery' AND styleid = -1");
			$stepphrase .= 'Removed Templates.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "setting WHERE product = 'ppvbgallery' AND volatile = 1");
			$stepphrase .= 'Removed Setting.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "settinggroup WHERE product = 'ppvbgallery' AND volatile = 1");
			$stepphrase .= 'Removed Settinggroups.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adminhelp WHERE product = 'ppvbgallery' AND volatile = 1");
			$stepphrase .= 'Removed Adminhelp.<br />';
			
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "cron WHERE product = 'ppvbgallery' AND volatile = 1");
			$stepphrase .= 'Removed Crons.<br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "faq WHERE product = 'ppvbgallery' AND volatile = 1");
			$stepphrase .= 'Removed Faqs.<br />';
			
            $db->query_write("ALTER TABLE " . TABLE_PREFIX . "administrator DROP vbgadminperms");
            $stepphrase .= 'Removed Admin Perms.<br />';


			vBulletinHook::build_datastore($db);

			require_once(DIR . '/includes/adminfunctions_language.php');
			build_language();

			build_options();

			require_once(DIR . '/includes/functions_cron.php');
			build_cron_next_run();

			build_product_datastore();

			// build bitfields to remove/add this products bitfields
			require_once(DIR . '/includes/class_bitfield_builder.php');
			vB_Bitfield_Builder::save($db);

			$stepphrase .= 'Removed Product.<br />';
			
			$nextstep = 'finished';

		break;

		case 'finished':

		  $stepphrase = 'PhotoPost vBGallery ' . $scriptname . ' Sucessfully Uninstalled.<br /> <br /><a href="index.php"><b>Log Into Admin CP --&gt;</b></a><br /><br /><a href="' . $scriptfile . '.php"><b>Click here to re-install --&gt;</b></a>';

		break;
	}

	print_install_table_end();
}
print_cp_footer();

?>