<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('LOCATION_BYPASS', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ###################### Global Stuff #########################
($hook = vBulletinHook::fetch_hook('ppgal_func_start')) ? eval($hook) : false;

// Category Options
$categoryopts = array(
'open_for_images'        => 1,
'open_for_posts'         => 2,
'allow_post_html'        => 4,
'allow_post_bbcode'      => 8,
'allow_post_smilies'     => 16,
'allow_post_icons'       => 32,
'allow_post_bbimgcode'   => 64,
'allow_post_icons'       => 128,
'allow_custom_html'      => 256,
'allow_custom_bbcode'    => 512,
'allow_custom_smilies'   => 1024,
'allow_custom_bbimgcode' => 2048,
'allow_desc_html'        => 4096,
'allow_desc_bbcode'      => 8192,
'allow_desc_smilies'     => 16384,
'allow_desc_icons'       => 32768,
'allow_desc_bbimgcode'   => 65536,
'canhavepassword'        => 131072,
'childpass'              => 262144,
'allow_ratings'          => 524288,
'allow_replies'          => 1048576,
'allow_desc_links'       => 2097152,
'allow_custom_links'     => 4194304
);

// User Category Options
$catuseropts = array(
'allow_view'   => 1,
'allow_upload' => 2,
'allow_reply'  => 4,
'allow_rating' => 8
);

// Image Type Array
$imgtypearray = array(
'gif'	=> 1,
'jpg'	=> 2,
'png'	=> 3,
'swf'	=> 4,
'psd'	=> 5,
'bmp'	=> 6,
'tiff'  => 7,
'tiff'  => 8,
'jpc'   => 9,
'jp2'   => 10,
'jpx'   => 11,
'jb2'   => 12,
'swc'   => 13,
'iff'   => 14,
'wbmp'  => 15,
'xbm'   => 16
);

$adv_category_options = array(
'gallery_watermark',
'gallery_watermark_location',
'gallery_thumbsize',
'gallery_saveoriginal',
'gallery_thumbquality',
'gallery_origquality',
'gallery_uploadpostcount'
);

$gallerypermissionsbit = array(
'canviewgallery'	 			=> 1,
'canviewimages' 				=> 2,
'moderateimages' 				=> 4,
'moderateposts' 				=> 8,
'cansearchimages' 			    => 16,
'cansendimagetofriend' 	        => 32,
'caneditimages' 				=> 64,
'caneditothersimages' 	        => 128,
'candelete' 					=> 256,
'candeleteothers' 			    => 512,
'canviewreplies' 				=> 1024,
'canreplytoimages' 			    => 4096,
'caneditposts' 					=> 2048,
'caneditothersposts' 		    => 8192,
'candeleteposts' 				=> 16384,
'candeleteothersposts' 	        => 32768,
'canrateimages' 				=> 65536,
'canuploadimages'				=> 131072,
'canuploadfromserver'		    => 262144,
'cancreatecategories'		    => 524288,
'canuploadasuser'				=> 1048576,
'canviewlargimage'			    => 2097152,
'cansendecard'					=> 4194304,
'canvieworiginal'				=> 8388608,
'canchangprofile'               => 16777216,
'canviewprofiletab'             => 33554432,
'canviewprofileblock'           => 67108864,
'canviewforumhomeblock'         => 134217728
);

// ################ Gallery Announcement ##################
function construct_announcement()
{
	global $ppgal_announcement, $bbcode_parser, $vbulletin;

    require_once(DIR . '/includes/class_bbcode.php');
    require_once(DIR . '/includes/functions_wysiwyg.php');
    $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
    $ppgal_announcement = $ppg_options['gallery_announcement'];

    $ppgal_announcement = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($ppgal_announcement));

	trim($ppgal_announcement);

	return $ppgal_announcement;
}

// ########################## Construct Categories ############################
function construct_categories($catinfo, $cat = 0)
{
	global $counter;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$catarray[] = $cats;

				if ($subcat = construct_categories($catinfo, $cats['catid']))
				{
					$catarray = array_merge((array)$catarray, (array)$subcat);
				}
				$counter--;
			}
		}
	}
	return $catarray;
}

// ########################## Construct Categories ############################
function construct_category_counters($catinfo, $cat = 0)
{
	global $catscounter, $categoryperms, $ppg_options;

	if (!empty($catinfo))
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat AND $categoryperms["$cats[catid]"]['canviewgallery'] AND $cats['active'])
			{
				$catscounter++;
				$cats['level'] = $catscounter;

				unset($catinfo["$cats[catid]"]);

				if ($subcat = construct_category_counters($catinfo, $cats['catid']))
				{
					foreach ($subcat AS $subs)
					{
						$cats['imagecount'] += $subs['imagecount'];
						$cats['postcount'] += $subs['postcount'];
						if ($subs['lastimagedateline'] > $cats['lastimagedateline'])
						{
							$cats['lastimagedateline'] = $subs['lastimagedateline'];
							$cats['lastimageid'] = $subs['lastimageid'];
							$cats['lastimageusername'] = $subs['lastimageusername'];
							$cats['lastimageuserid'] = $subs['lastimageuserid'];
							$cats['lastimagetitle'] = $subs['lastimagetitle'];
						}
						if ($subs['lastpostdateline'] > $cats['lastpostdateline'])
						{
							$cats['lastpostid'] = $subs['lastpostid'];
							$cats['lastpostuserid'] = $subs['lastpostuserid'];
							$cats['lastpostusername'] = $subs['lastpostusername'];
							$cats['lastpostimagetitle'] = $subs['lastpostimagetitle'];
							$cats['lastpostdateline'] = $subs['lastpostdateline'];
						}

						if ($catscounter < $ppg_options['gallery_catdepth'] AND !$cats['membercat'])
						{
							$subcatarray["$subs[catid]"] = $subs;
						}
						else if ($catscounter <= $ppg_options['gallery_catdepth'] AND $ppg_options['gallery_showsubcats'])
						{
							$cats['subcats']["$subs[catid]"]['title'] = $subs['title'];
							$cats['subcats']["$subs[catid]"]['lastimagedateline'] = $subs['lastimagedateline'];
							$cats['subcats']["$subs[catid]"]['lastpostdateline'] = $subs['lastpostdateline'];
						}
					}
				}

				$catarray["$cats[catid]"] = $cats;

				if (!empty($subcatarray))
				{
					foreach ($subcatarray AS $subcatid => $subcatinfo)
					{
						$catarray["$subcatid"] = $subcatinfo;
					}
				}

				$catscounter--;
			}
		}
	}
	return $catarray;
}

// ################### Function to Print Categories ########################
function print_categories($cat = 0, $catinfo = '', $type = 'normal')
{

    global $db, $vbulletin, $permissions, $categorycache, $ppg_options, $vbcollapse, $stylevar, $vbphrase, $show, $categoryperms;

    require_once(DIR . '/includes/class_bbcode.php');
    require_once(DIR . '/includes/functions_wysiwyg.php');
    $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	if (empty($catinfo))
	{
		$getcats = $db->query_read("
				SELECT catid, styleid, title, title_clean, description, description_clean, parent, hasimages, active, membercat, parentlist, catimage, imagecount, postcount, catuserid, useroptions, lastimageid, lastimagetitle, lastimageuserid, lastimageusername, lastimagedateline, lastpostid, lastpostuserid, lastpostusername, lastpostimagetitle, lastpostdateline, styleoverride
				FROM " . TABLE_PREFIX ."ppgal_categories
				ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection]
		");
		while ($categories = $vbulletin->db->fetch_array($getcats))
		{
			$catinfo[] = $categories;
		}

		$db->free_result($getcats);
		unset($categories);

		$catinfo = construct_category_counters($catinfo, $cat);
		if (empty($catinfo))
		{
			return;
		}
	}

	$gallery_modcache = cache_gallery_mods();

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	foreach ($catinfo AS $catid => $cats)
	{
		if (!$categoryperms["$cats[catid]"]['canviewgallery'] OR !$cats['active'] OR $cats['level'] > 2 OR $cats['level'] > $ppg_options['gallery_catdepth'])
		{
			continue;
		}

		if ($cats['catuserid'])
		{
			if ($cats['catuserid'] != $vbulletin->userinfo['userid'] AND !is_category_mod($cats['catid']))
			{
				$catuseropts = construct_cat_user_opts($catid, $cats['useroptions']);
				if (!$catuseropts['allow_view'])
				{
					continue;
				}
			}
			if (!$cats['catusername'])
			{
				$cats['catusername'] = $categorycache["$cats[catid]"]['username'];
			}
		}

		$cats['title'] = stripslashes($cats['title']);
        $cats['description'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($cats['description']));

		$cats['catimage'] = unserialize($cats['catimage']);
		$cats['catimageurl'] = $cats['catimage']['url'];
		$cats['catimagewidth'] = $cats['catimage']['w'];
		$cats['catimageheight'] = $cats['catimage']['h'];

		if (($cats['catimagewidth'] > $ppg_options['gallery_catimage_size'] OR $cats['catimageheight'] > $ppg_options['gallery_catimage_size']) AND $ppg_options['gallery_catimage_size'])
		{
			$heightpercent = $cats['catimageheight'] / $ppg_options['gallery_catimage_size'];
			$widthpercent = $cats['catimagewidth'] / $ppg_options['gallery_catimage_size'];

			if ($widthpercent > $heightpercent)
			{
				$shrinkage = $ppg_options['gallery_catimage_size'] / $cats['catimagewidth'];
			}
			else
			{
				$shrinkage = $ppg_options['gallery_catimage_size'] / $cats['catimageheight'];
			}

			$cats['catimageheight'] = round($shrinkage * $cats['catimageheight']);
			$cats['catimagewidth'] = round($shrinkage * $cats['catimagewidth']);
		}

		if ($cats['hasimages'] == 1)
		{
			// Sub categories
			$subcatbits = '';
			if (!empty($cats['subcats']))
			{
				foreach ($cats['subcats'] AS $subcatid => $subcats)
				{
					if ($categoryperms["$subcatid"]['canviewgallery'])
					{
						if ($categorycache["$subcatid"]['catuserid'] AND !is_category_mod($subcatid) AND $categorycache["$subcatid"]['catuserid'] != $vbulletin->userinfo['userid'])
						{
							$useroptions = construct_cat_user_opts($subcatid, $categorycache["$subcatid"]['useroptions']);
							if (!$useroptions['allow_view'])
							{
								continue;
							}
						}

						$subcats['title'] = stripslashes($subcats['title']);
						$subonoff = iif($subcats['lastimagedateline'] > $vbulletin->userinfo['lastvisit'] OR $subcats['lastpostdateline'] > $vbulletin->userinfo['lastvisit'], 'new', 'old');
						eval('$subcatbits[] = "' . fetch_template('adv_gallery_categorybit_subcat') . '";');
					}
				}
				if (!empty($subcatbits))
				{
					$subcatbits = implode(', ', $subcatbits);
				}
			}
			// Moderators
			if ($show['modcolumn'])
			{
				foreach (explode(',', $cats['parentlist']) AS $parentid)
				{
					if ($gallery_modcache["$parentid"])
					{
						foreach ($gallery_modcache["$parentid"] AS $moderator)
						{
							if (!$donemods["$cats[catid]"]["$moderator[userid]"])
							{
								$donemods["$cats[catid]"]["$moderator[userid]"] = true;

								$comma = '';
								if (!empty($cats['moderator']))
								{
									$comma = ', ';
								}
								eval('$cats[\'moderator\'] .= "$comma' . fetch_template('forumhome_moderator') . '";');
							}
						}
					}
				}
				$cats['moderator'] = str_replace('"member.php', '"' . $vbulletin->options['bburl'] . '/member.php', $cats['moderator']);
			}

			$show['dateonly'] = false;

	 		if (!check_category_password($cats['catid'], false))
	 		{
	 			$show['dateonly'] = true;
	 		}

			if ($categoryperms["$cats[catid]"]['canviewimages'] OR $ppg_options['gallery_showimagecount'])
			{
				$cats['imagecount'] = vb_number_format($cats['imagecount']);

				if ($cats['lastimagedateline'])
				{
					$cats['lastimagetitle'] = fetch_trimmed_title(stripslashes($cats['lastimagetitle']), $ppg_options['gallery_lastimage_maxlength']);
					$cats['lastupdateddate'] = vbdate($vbulletin->options['dateformat'], $cats['lastimagedateline']);
					$cats['lastupdatedtime'] = vbdate($vbulletin->options['timeformat'], $cats['lastimagedateline']);
					$cats['lastimageusername'] = stripslashes($cats['lastimageusername']);
					$cats['lastimagetitle'] = stripslashes($cats['lastimagetitle']);
				}
			}
			else
			{
				$cats['imagecount'] = 0;
				$cats['lastimageid'] = '';
			}

			if ($categoryperms["$cats[catid]"]['canviewreplies'] OR $ppg_options['gallery_showimagecount'])
			{
				$cats['postcount'] = vb_number_format($cats['postcount']);

				if ($cats['lastpostdateline'])
				{
					$cats['lastpostimagetitle'] = fetch_trimmed_title(stripslashes($cats['lastpostimagetitle']), $ppg_options['gallery_lastimage_maxlength']);
					$cats['lastpostusername'] = stripslashes($cats['lastpostusername']);
					$cats['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $cats['lastpostdateline']);
					$cats['lastposttime'] = vbdate($vbulletin->options['timeformat'], $cats['lastpostdateline']);
				}
			}
			else
			{
				$cats['postcount'] = 0;
				$cats['lastpostid'] = '';
			}

			$onoff = 'old';
			if ($vbulletin->userinfo['lastvisit'] < $cats['lastimagedateline'])
			{
				$onoff = 'new';
			}
			$catcount++;
			eval('$categorybits .= "' . fetch_template('adv_gallery_categorybit_level' . $cats['level']) . '";');
		}
		else
		{
			$catcollapse = $vbcollapse["collapseobj_catbit_" . $cats['catid'] . ""];
			$catimgcollapse = $vbcollapse["collapseimg_catbit_" . $cats['catid'] . ""];

			$catcount++;

			eval('$categorybits .= "' . fetch_template('adv_gallery_categorybit_main') . '";');
		}
	}
	unset($catinfo);

	return $categorybits;
}
//////////////// Stats to print Polls ///////////////
function print_statistic_result($date, $bar, $value, $width)
{
	global $stylevars, $vbulletin;
	$bgclass = fetch_row_bgclass();

	if (preg_match('#^(https?://|/)#i', $stylevars['imgdir_poll']))
	{
		$imgpath = $stylevars['imgdir_poll'];
	}
	else
	{
		$imgpath = $stylevars['imgdir_poll'];
	}

	if ($vbulletin->userinfo['lang_options'] & $vbulletin->bf_misc_languageoptions['direction'])
	{
		// ltr
		$l_img = 'l';
		$r_img = 'r';
	}
	else
	{
		// rtl
		$l_img = 'r';
		$r_img = 'l';
	}

eval('$sonuc .= "' . fetch_template('adv_gallery_stats_stat2') . '";');
	return $sonuc;
}
// ######################### Fetch Category Permissions #######################
function fetch_category_perms($catid = 0, $ugid = '')
{
	global $vbulletin, $gallerypermissionsbit, $gallery_permissions, $galleryperms, $categorycache;

	if ($ugid)
	{
		$usergroupids = $ugid;
	}
	else
	{
		$usergroupids = fetch_membergroupids_array($vbulletin->userinfo);
	}

	$catperms = array();
	$categoryperms = array();

	if ($catid == 0)
	{
		foreach (array_keys($categorycache) AS $catid)
		{
			$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

			if (empty($thiscatperms))
			{
				$catperms["$catid"] = $galleryperms;
				continue;
			}

			foreach ($usergroupids AS $usergroupid)
			{
				if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
				{
					if (empty($gallery_permissions["$usergroupid"]))
					{
						$usergroupid = 1;
					}

					$categoryperms["$catid"] = $gallery_permissions["$usergroupid"]['gallery_perms'];
				}
				else
				{
					$categoryperms["$catid"] = $thiscatperms["$usergroupid"];
				}

				foreach ($gallerypermissionsbit AS $option => $value)
				{
					if (in_array($option, array('moderateimages', 'moderateposts')) AND $catperms["$catid"]["$option"] == 0 AND isset($catperms["$catid"]["$option"]))
					{
						continue;
					}
					if (!$catperms["$catid"]["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
					{
						$catperms["$catid"]["$option"] = 0;
						if ($categoryperms["$catid"] & $value)
						{
							$catperms["$catid"]["$option"] = 1;
						}
					}
				}
			}
		}
	}
	else
	{
		$thiscatperms = unserialize($categorycache["$catid"]['permissions']);

		foreach ($usergroupids AS $usergroupid)
		{
			if (empty($thiscatperms["$usergroupid"]) AND $thiscatperms["$usergroupid"] != '0')
			{
				$categoryperms = $gallery_permissions["$usergroupid"]['gallery_perms'];
			}
			else
			{
				$categoryperms |= $thiscatperms["$usergroupid"];
			}
			foreach ($gallerypermissionsbit AS $option => $value)
			{
				if (!$catperms["$option"] OR (in_array($option, array('moderateimages', 'moderateposts')) AND $catperms["$option"] == 0))
				{
					$catperms["$option"] = 0;
					if ($categoryperms & $value)
					{
						$catperms["$option"] = 1;
					}
				}
			}
		}
	}

	return $catperms;
}

// ######################## Fetch Private Categories ##########################
function fetch_private_categories()
{
	global $categorycache, $categoryperms, $vbulletin;

	$privatecats = array();

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	if (!empty($categoryperms))
	{
		foreach ($categoryperms AS $catid => $cperms)
		{
			if (is_category_mod($catid))
			{
				continue;
			}

			if ($categorycache["$catid"]['catuserid'])
			{
				$useroptions = construct_cat_user_opts($catid, $categorycache["$catid"]['useroptions']);
				if (!$useroptions['allow_view'])
				{
					$privatecats[] = $catid;
				}
			}
			else
			{
				$catopts = construct_cat_opts($catid, $categorycache["$catid"]['options']);

				if ($catopts['canhavepassword'] AND !$categorycache["$catid"]['password'])
				{
					$parentlist = explode(',', $categorycache["$catid"]['parentlist']);

					if (!empty($parentlist))
					{
						foreach ($parentlist AS $pcatid)
						{
							$catopts = construct_cat_opts($pcatid, $categorycache["$pcatid"]['options']);
							if ($categorycache["$pcatid"]['password'] AND $catopts['childpass'])
							{
								if (fetch_bbarray_cookie('catpassword', $pcatid) != md5($vbulletin->userinfo['userid'] . $categorycache["$pcatid"]['password']))
								{
									$privatecats[] = $catid;
								}
							}
						}
					}
				}
			}

			if (($categorycache["$catid"]['password'] AND fetch_bbarray_cookie('catpassword', $catid) != md5($vbulletin->userinfo['userid'] . $categorycache["$catid"]['password'])) OR ((!$cperms['canviewimages'] OR !$cperms['canviewgallery'] OR !$categorycache["$catid"]['active']) AND !is_category_mod($catid)))
			{
				$privatecats[] = $catid;
			}
		}
	}
	return implode(',', $privatecats);
}

// ###################### Function to Construct Categories #####################
function construct_category_perms($catinfo, $cat = 0, $catpermissions)
{
	global $catperms;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$catperms["$cats[catid]"] = $catpermissions["$cats[catid]"];

				if (!empty($catperms["$cats[parent]"]) AND empty($catperms["$cats[catid]"]))
				{
					$catperms["$cats[catid]"] = $catperms["$cats[parent]"];
				}

				construct_category_perms($catinfo, $cats['catid'], $catpermissions);
			}
		}
	}
	return $catperms;
}

// ############################## Update Category Cache ######################
function update_category_cache()
{
	global $db, $ppg_options, $vbulletin;

	$catsinfo = array();
	$catpermissions = array();

	$permissions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_permissions");
	while ($permission = $vbulletin->db->fetch_array($permissions))
	{
		$catpermissions["$permission[catid]"]["$permission[usergroupid]"] = $permission['permissions'];
	}

	$db->free_result($permissions);
	unset($permission);

	$users = array();

	$getcats = $db->query_read("SELECT catid, styleid, title, title_clean, allowusercats, catuserid, membercat, parent, parentlist, hasimages, password, active, options, useroptions, styleoverride FROM " . TABLE_PREFIX ."ppgal_categories ORDER BY $ppg_options[gallery_catsorderby] $ppg_options[gallery_catsdirection], hasimages");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		if ($categories['catuserid'])
		{
			$users[] = $categories['catuserid'];
		}
		$catsinfo[] = $categories;
	}

	if (!empty($catpermissions))
	{
		$catperms = construct_category_perms($catsinfo, 0, $catpermissions);
	}

	if (!empty($users))
	{
		$usernamecache = array();
		$getusers = $db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid IN(" . implode(',', $users) . ")");
		while ($user = $vbulletin->db->fetch_array($getusers))
		{
			$usernamecache["$user[userid]"] = $user['username'];
		}
		$db->free_result($getusers);
		unset($user);
	}

	$categoryinfo = array();

	if ($catinfo = construct_categories($catsinfo, 0, -1))
	{
		foreach ($catinfo AS $cats)
		{
			$categoryinfo["$cats[catid]"] = $cats;
			if ($catperms["$cats[catid]"])
			{
				$categoryinfo["$cats[catid]"]['permissions'] = serialize($catperms["$cats[catid]"]);
			}
			if ($cats['catuserid'])
			{
				$categoryinfo["$cats[catid]"]['username'] = $usernamecache["$cats[catuserid]"];
			}
		}
	}

	$db->free_result($getcats);
	build_datastore('gallery_c_cache',serialize($categoryinfo),1);
	unset($categories, $catinfo);
}

// ########################### Make Cat Select Field ##########################
function print_cat_select($selectedid = 0, $type)
{
	global $categorycache, $allowedparents, $vbulletin, $categoryperms, $category;

	switch ($type)
	{
		case 'catjump':
			$permissions = 'canviewgallery';
			break;

		case 'upload':
			$permissions = 'canuploadimages';
			break;

		case 'search':
			$permissions = 'cansearchimages';
			break;

		case 'managecats':
			$permissions = 'cancreatecategories';
			break;

		case 'admin':
			break;
	}

	if (!is_array($allowedparents))
	{
		$allowedparents = array();
	}

	if (!empty($categorycache))
	{
		if (empty($categoryperms))
		{
			$categoryperms = fetch_category_perms();
		}

		foreach ($categorycache AS $cats)
		{
			$iscatmod = is_category_mod($cats['catid']);
			if ($type != 'admin' AND $cats['catuserid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'] AND !$iscatmod)
			{
				$useroptions = construct_cat_user_opts($cats['catid'], $categorycache["$cats[catid]"]['useroptions']);
				if (!$useroptions['allow_upload'] OR !$useroptions['allow_view'])
				{
					continue;
				}
			}

			$catopts = construct_cat_opts($cats['catid'], $cats['options']);

			if ($cats['parent'] != 0 AND !$categorycache["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
			{
				$cats['active'] = 0;
				$categorycache["$cats[catid]"]['active'] = 0;
			}

			if ((($type == 'managecats' AND (!$cats['allowusercats'] AND !in_array($cats['catid'], $allowedparents)) OR $cats['catid'] == $category['catid'])) OR !$categoryperms["$cats[catid]"]["$permissions"] OR (!$iscatmod AND !$cats['active'] AND $type != 'admin' AND $cats['catid'] != $selectedid) OR (!$catopts['open_for_images'] AND $type == 'upload' AND $cats['hasimages']) OR !check_category_password($cats['catid'], false))
			{
				continue;
			}

	    $dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
			$selected = '';
			if ($selectedid == $cats['catid'])
			{
				$selected = 'selected="selected"';
				$class = 'fjsel';
			}
			elseif ($cats['level'] <= 4)
			{
				$class = 'fjdpth' . $cats['level'];
			}
			else
			{
				$class = 'fjdpth';
			}
			if ((!$cats['hasimages'] AND $type == 'upload') OR (!$cats['allowusercats'] AND $cats['catuserid'] != $vbulletin->userinfo['userid'] AND $type == 'managecats'))
			{
				if ($options)
				{
					$endgroup = true;
					$options .= '</optgroup>';
				}
				$options .= '<optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $dashes . '' . stripslashes($cats['title']) . '">';
			}
			else
			{
				$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . stripslashes($cats['title']) . '</option>';
			}
		}
		if ($endgroup)
		{
			$options .= '</optgroup>';
		}
		unset($cats, $catinfo);
	}
	return $options;
}

// ######################### Check Password ############################
function check_category_password($catid, $printerror = true, $scriptname = 'browseimages')
{
	global $vbulletin, $categorycache;

	$catinfo = $categorycache["$catid"];

	$parentlist = explode(',', $catinfo['parentlist']);

	$catopts = construct_cat_opts($catinfo['catid'], $catinfo['options']);

	if ($catopts['canhavepassword'])
	{
		if (!empty($parentlist))
		{
			foreach ($parentlist AS $pcatid)
			{
				$catopts = construct_cat_opts($pcatid, $categorycache["$pcatid"]['options']);
				if ($categorycache["$pcatid"]['password'] AND $catopts['childpass'])
				{
					$parpass = true;
					$parcookiepass = fetch_bbarray_cookie('catpassword', $pcatid);
				}
				$cookiepass = fetch_bbarray_cookie('catpassword', $catid);
				$passcheck = md5($vbulletin->userinfo['userid'] . $categorycache["$catid"]['password']);

				if ($cookiepass == $passcheck OR $parcookiepass == $passcheck)
				{
					return true;
				}
			}
		}
		if (!$parpass AND !$catinfo['password'])
		{
			return true;
		}
		if ($printerror)
		{
			eval(standard_error(fetch_error('adv_gallery_categorypassword', $vbulletin->session->vars['sessionurl'], $scriptpath, $catinfo['catid'])));
		}
	}
	else if ($catinfo['password'])
	{
		if (fetch_bbarray_cookie('catpassword', $catinfo['catid']) == md5($vbulletin->userinfo['userid'] . $catinfo['password']))
		{
			return true;
		}
		else
		{
			if ($printerror)
			{
				eval(standard_error(fetch_error('adv_gallery_categorypassword', $vbulletin->session->vars['sessionurl'], $scriptpath, $catinfo['catid'])));
			}
			else
			{
				return false;
			}
		}
	}
	else
	{
		return true;
	}
}

// ########################## Fetch Allowed Parents ###########################
function fetch_allowed_parents()
{
	global $vbulletin, $categorycache;

	$allowedparents = array();
	if (!empty($categorycache))
	{
		foreach ($categorycache AS $cats)
		{
			if ($cats['catuserid'] == $vbulletin->userinfo['userid'])
			{
				foreach (explode(',', $cats['parentlist']) AS $parentid)
				{
					$allowedparents[] = $parentid;
				}
			}
		}
	}
	return $allowedparents;
}

// ####################### Insert Parentlist ###########################
function insert_category_parentlist($parentid)
{
	global $db, $newcatid, $vbulletin;

	if ($parentid)
	{
		$cat = $db->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$parentid'");
	}

	if ($cat['parentlist'])
	{
		$plist = $newcatid . ',' . $cat['parentlist'];
	}
	elseif ($parentid)
	{
		$plist = $newcatid . ',' . $parentid;
	}
	else
	{
		$plist = $newcatid;
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET parentlist = '$plist' WHERE catid = '$newcatid'");
}

// ##################### Reconstruct Parents ######################
function reconstruct_parents($catid)
{
	rebuild_parents($catid);

	global $db, $vbulletin;

	$catarray = array();
	$getcats = $db->query_read("SELECT catid, parent FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY displayorder ASC, hasimages");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		$catarray[] = $categories;
	}

	$db->free_result($getcats);
	unset($categories);

	$catinfo = construct_categories($catarray, $catid, -1);
	if (!empty($catinfo))
	{
		foreach ($catinfo as $cats)
		{
			rebuild_parents($cats['catid']);
		}
	}
}

// ############################## Rebuild Parents #############################
function rebuild_parents($catid = 0)
{
	global $db, $vbulletin, $parentlist;

	$cats = array();

	$getcats = $db->query_read("SELECT catid, title, parent FROM " . TABLE_PREFIX . "ppgal_categories ORDER BY parent");
	while ($catinfo = $vbulletin->db->fetch_array($getcats))
	{
		$cats[] = $catinfo;
	}

	$db->free_result($getcats);
	unset($catinfo);

	foreach($cats AS $cat)
	{
		if ($catid != 0 AND $cat['catid'] != $catid)
		{
			continue;
		}
		$parentlist = array();
		$parentlist[] = $cat['catid'];
		construct_parents($cats, $cat['parent']);
		$plist = implode(',', $parentlist);

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET parentlist = '$plist' WHERE catid = '$cat[catid]'");

	}
}

// ################ Find Parent Directories ##################
function construct_parents($catinfo, $catid)
{
	global $parentlist;

	foreach ($catinfo AS $subs)
	{
		if ($subs['catid'] == $catid)
		{
			$parentlist[] = $subs['catid'];
			construct_parents($catinfo, $subs['parent']);
		}
	}
	return $parentlist;
}

// ####################### Construct Category Options ########################
function construct_cat_opts($catid, $catint)
{
	global $categoryopts;

	foreach ($categoryopts AS $option => $value)
	{
		$catopts["$option"] = 0;
		if ($catint & $value)
		{
			$catopts["$option"] = 1;
		}
	}
	return $catopts;
}

// ####################### Construct Category User Options ############################
function construct_cat_user_opts($catid, $catint)
{
	global $catuseropts;

	foreach ($catuseropts AS $option => $value)
	{
		$useropts["$option"] = 0;
		if ($catint & $value)
		{
			$useropts["$option"] = 1;
		}
	}
	return $useropts;
}

// ############################ Cache Moderators ############################
function cache_gallery_mods()
{
	global $vbulletin;

	if ($gallerymods =& $vbulletin->gal_mod_cache)
	{
		foreach ($gallerymods AS $moderator)
		{
			$moderator['musername'] = fetch_musername($moderator);
			$gallery_modcache["$moderator[catid]"]["$moderator[userid]"] = $moderator;
		}
	}
	return $gallery_modcache;
}

// ######################### Find Category Mods #########################
function is_category_mod($catid)
{
	global $vbulletin, $permissions, $categorycache, $ppg_options;

	if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
	{
		return true;
	}
	else if ($categorycache["$catid"]['catuserid'] AND $vbulletin->userinfo['userid'] == $categorycache["$catid"]['catuserid'] AND $ppg_options['gallery_usercats_modopts'])
	{
		return true;
	}
	else
	{
		$gallery_modcache = cache_gallery_mods();

		foreach (explode(',', $categorycache["$catid"]['parentlist']) AS $parentid)
		{
			if ($gallery_modcache["$parentid"])
			{
				foreach($gallery_modcache["$parentid"] AS $moderator)
				{
					if ($vbulletin->userinfo['userid'] == $moderator['userid'])
					{
						return true;
					}
				}
			}
		}
	}
}

// #################### Construct Imagebits ######################
function construct_imagebits(&$images, $highlight = '')
{
	global $ppg_options, $stylevar, $vbulletin, $vbphrase, $show, $adv_sorturl, $catinfo, $counter, $cellwidth, $categoryperms, $showfields, $categorycache, $catopts, $bbcode_parser;

	if ($counter > $ppg_options['gallery_columns'])
	{
		$imagebits .= '</tr><tr>';
		$counter = 1;
	}

	$images['title'] = stripslashes($images['title']);

	if (!$images['title'])
	{
		$images['title'] = $images['filename'];
	}

	if (!$showfields['title'])
	{
		$images['title'] = '';
	}

	if (!$catopts["$images[catid]"])
	{
		$catopts["$images[catid]"] = construct_cat_opts($images['catid'], $categorycache["$images[catid]"]['options']);
	}

	if ($images['originalname'])
	{
		if ($ppg_options['gallery_watermark'] AND $ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = 'displayimage.php?imageid=' . $images['imageid'] . '&original=1';
		}
		else if ($ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = construct_image_url($images, 'originalname');
		}
		else
		{
			$images['originalurl'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $images['imageid'] . '&amp;original=1';
		}
	}

	$images['username'] = stripslashes($images['username']);
	$images['cattitle'] = stripslashes($images['cattitle']);
	$images['views'] = vb_number_format($images['views']);
	$images['filesize'] = vb_number_format($images['filesize'], 1, true);
	$images['dateadded'] = vbdate($vbulletin->options['dateformat'], $images['dateline']);
	$images['timeadded'] = vbdate($vbulletin->options['timeformat'], $images['dateline']);
    $images['description'] = stripslashes($images['description']);


	if ($images['originalfilesize'])
	{
		$images['originalfilesize'] = vb_number_format($images['originalfilesize'], 1, true);
	}

	if ($categoryperms["$images[catid]"]['canviewreplies'])
	{
		$images['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $images['lastpostdateline']);
		$images['lastposttime'] = vbdate($vbulletin->options['timeformat'], $images['lastpostdateline']);
		$images['lastpostusername'] = stripslashes($images['lastpostusername']);
		$images['replies'] = vb_number_format($images['posts']);
	}
	else
	{
		$images['replies'] = 0;
		$images['lastpostdateline'] = 0;
	}

	$images['url'] = construct_image_url($images, 'thumbname');

	$show['sticky'] = false;
	if ($images['sticky'])
	{
		$show['sticky'] = true;
	}

	$show['subscribed'] = false;
	if ($images['subid'])
	{
		$show['subscribed'] = true;
	}

	$images['rating'] = '';
	if ($images['votetotal'] AND $images['votenum'])
	{
		$images['truerating'] = vb_number_format($images['votetotal'] / $images['votenum'], 2);
		$images['rating'] = round($images['truerating']);
	}

	eval('$imagebits .= "' . fetch_template('adv_gallery_imagebit') . '";');

	return $imagebits;
}

// ######################## Construct Empty Imagebits #########################
function construct_empty_cellbits($cells, $colspan = 0)
{
	global $counter, $ppg_options;

	$cellwidth = round(100 / $cells) . '%';

	if ($counter AND $counter != $cells)
	{
		for ($i = $counter; $i < $cells; $i++)
		{
			$emptycells .= '<td class="alt1" ' . iif($colspan, 'colspan="' . $colspan . '"') . ' width="' . $cellwidth . '"></td>';
		}
	}
	return $emptycells;
}

// ############################ Construct Image URL ###########################
function construct_image_url($image, $filename = 'filename', $fulllink = false)
{
	global $ppg_options, $server, $userid;

    ($hook = vBulletinHook::fetch_hook('ppgal_construct_image_url')) ? eval($hook) : false;

	if (!in_array($image['extension'], array('gif', 'jpg', 'jpeg', 'png', 'psd', 'bmp')) OR ($filename == 'thumbname' AND !$image['thumbname']))
	{
		if ($fulllink){
			return '<a href="misc.php?' . $vbulletin->session->vars['sessionurl'] . 'do=downloadfile&amp;i=' . $image['imageid'] . '"><img alt="" border="0" src="' . $ppg_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif" /></a>';
		}else{
			return iif($filename == 'filename', $ppg_options['gallery_url'] . '/misc.php?do=downloadfile&amp;i=' . $image['imageid'], $ppg_options['gallery_url'] . '/images/file_' . $image['extension'] . '.gif');
		}
	}else{
		if ($fulllink){
			if ($filename == 'originalname'){
				$image['width'] = $image['originalwidth'];
				$image['height'] = $image['originalheight'];
			}

			return '<img alt="' . $image['title'] . '" border="0" height="' . $image['height'] . '" src="' . iif($ppg_options['gallery_echoimage'], 'displayimage.php?' . $vbulletin->session->vars['sessionurl'] . 'imageid=' . $image['imageid'] . iif($filename == 'originalname', '&amp;original=1'), fetch_folder_url($image) . '/' . $image["$filename"]) . '" width="' . $image['width'] . '" rel="nofollow" />';

        }else{

            if ($server['upload'] AND $image['thumbname'] == $image['filename']){

            return $ppg_options['gallery_userfolderurl'] . '/' . $userid . '/' . $image["$filename"];

    			}
    			else if ($ppg_options['gallery_echoimage'] AND ($filename == 'filename' OR $filename == 'originalname'))
    			{
    				return $ppg_options['gallery_url'] . '/displayimage.php?imageid=' . $image['imageid'] . iif($filename == 'originalname', '&amp;original=1');
    			}else{

            return fetch_folder_url($image) . '/' . $image["$filename"];
			}
		}
	}
}

// ############################ Fetch Folder URL ################################
function fetch_folder_url($image, $foldersonly = '')
{
	global $ppg_options;

	if ($ppg_options['gallery_insafemode'])
	{
		return iif(!$foldersonly, $ppg_options['gallery_fileurl'], '');
	}

	return iif(!$foldersonly, $ppg_options['gallery_fileurl'] . '/') . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY));
}

// ############################ Fetch Folder URL ################################
function fetch_folder_path($image, $foldersonly = '')
{
	global $ppg_options;

	if ($foldersonly OR $ppg_options['gallery_insafemode'])
	{
		return $ppg_options['gallery_filedirectory'] . iif($foldersonly, '/');
	}
	else
	{
		return $ppg_options['gallery_filedirectory'] . '/' . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY));
	}
}

// #################### Check Image ID ##########################
function check_image_id($imageid)
{
	global $vbphrase, $vbulletin;

	if (!$imageid)
	{
		eval(standard_error(fetch_error('noid', $vbphrase['image'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'])));
	}
}

// ############################## Delete Images ###############################
function delete_images($imageid, $imagearray = '')
{
	global $db, $vbulletin, $ppg_options;

	if (!empty($imagearray))
	{
		$imageids = array_keys($imagearray);
		$delimages = implode(',', $imageids);
	}
	else
	{
		$delimages = $imageid;

		$imagearray = array();
		$getimages = $db->query_first("SELECT catid, userid, filename, originalname, thumbname, posts FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");
		$imagearray["$imageid"]['catid'] = $getimages['catid'];
		$imagearray["$imageid"]['userid'] = $getimages['userid'];
		$imagearray["$imageid"]['filename'] = $getimages['filename'];
		$imagearray["$imageid"]['originalname'] = $getimages['originalname'];
		$imagearray["$imageid"]['thumbname'] = $getimages['thumbname'];
		$imagearray["$imageid"]['posts'] = $getimages['posts'];

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET imagecount = imagecount-1, postcount = postcount-" . intval($imagearray['posts']) . " WHERE catid = '$imagearray[catid]'");
	}

	if ($delimages)
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_rate WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_favorites WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_subscribeimage WHERE imageid IN ($delimages)");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_exif WHERE imageid IN ($delimages)");

		$usercounts = array();

		foreach ($imagearray AS $imageid => $image)
		{
			$folderstring = fetch_folder_path($image);

			$usercounts["$image[userid]"]++;

			@unlink($folderstring . '/' . $image['filename']);

			if ($image['thumbname'])
			{
		  	@unlink($folderstring . '/' . $image['thumbname']);
			}
			if ($image['originalname'])
			{
		  	@unlink($folderstring . '/' . $image['originalname']);
			}
		}
		foreach ($usercounts AS $userid => $postremove)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user SET ppicount = ppicount-$postremove WHERE userid = '$userid'");
		}
    }

($hook = vBulletinHook::fetch_hook('ppgal_delete_image')) ? eval($hook) : false;

build_gallery_stats();
}

// ############################ Fetch Image Fields ############################
function fetch_image_fields()
{
	global $showfield, $show;

	$query['fields'] = ' ,images.userid, images.username';

	if (!empty($showfield))
	{
		foreach ($showfield AS $fields)
		{
			switch ($fields)
			{
				case 'category':
					break;
				case 'dimensions':
					$query['fields'] .= ' ,width, height, originalwidth, originalheight';
					break;
				case 'user':
					break;
				case 'filesize':
					$query['fields'] .= ' ,filesize, originalfilesize';
					break;
				case 'lastpost':
					$query['fields'] .= ', images.lastpostdateline, images.lastpostuserid, images.lastpostusername';
					break;
				case 'rating':
					$query['fields'] .= ', votenum, votetotal';
					break;
				default:
					$query['fields'] .= iif($fields, ', images.' . $fields);
			}
		}
	}

	if ($show['category'])
	{
		$query['fields'] .= ', categories.title AS cattitle';
		$query['tables'] .= 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_categories AS categories USING (catid)';
	}

	return $query;
}

// ############################ Construct Orderby #############################
function construct_orderby()
{
	global $orderby, $ppg_options, $direction;

	switch ($orderby)
	{
		case 'title':
		case 'dateline':
		case 'lastpostdateline':
		case 'imageid':
		case 'posts':
		case 'views':
		case 'username':
			return 'images.' . $orderby;
			break;
		case 'rating':
			return 'voteavg ' . $direction . ', votenum';
			break;
		default:
			return 'images.' . $ppg_options['gallery_deforder'];
	}
}

// ########################## Highlight Keywords #########################
function highlight_keywords($string, $keywords, $wholeword)
{
	if ($keywords)
	{
		$words = explode(' ', $keywords);

		foreach ($words as $word)
		{
			if ($wholeword)
			{
				$word = ' ' . $word . ' ';
			}
			$position = 0;

			while ($position !== false)
			{
				$position = strpos(strtolower($string), strtolower($word), $position);

				if ($position !== false)
				{
					$replace_string = '<span class="highlight">' . substr($string, $position, strlen($word)) . '</span>';

					$string = substr_replace($string, $replace_string, $position, strlen($word));

					$position += strlen($replace_string);
				}
			}
		}
	}
	return $string;
}

// ######################### Create Custom Fields #######################
function construct_custom_fieldbits($imageinfo = '', $custominfo = '', $editing = false, $admin = false, $makearray = false)
{
	global $db, $vbulletin, $vbphrase, $show, $stylevar;

	if (empty($custominfo))
	{
		$custominfo = array();
		$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
		while ($field = $vbulletin->db->fetch_array($customfields))
		{
			$custominfo[] = $field;
		}
		$db->free_result($customfields);
		unset($field);
	}

	if (!empty($custominfo))
	{
		foreach ($custominfo AS $field)
		{

			if (!$field['required'] AND $show['quickupload'])
			{
				continue;
			}

			$fieldname = 'field' . $field['fieldid'];
			$fieldid = 'field' . $field['fieldid'] . iif($makearray, '[' . $imageinfo['imageid'] . ']');

			if ($field['options'])
			{
				$field['options'] = explode("\n", $field['options']);
			}

			switch($field['type'])
			{
				case 'textarea':
					$inputbox = '<textarea class="bginput" cols="40" name="' . $fieldid . '" rows="6">' . htmlspecialchars($imageinfo["$fieldname"]) . '</textarea>';
					break;

				case 'select':
					$imageinfo["$fieldname"] = htmlspecialchars($imageinfo["$fieldname"]);
					$inputbox = '<select name="' . $fieldid . '">';
					$inputbox .= '<option value="">' . $vbphrase['please_select_one'] . '</option>';
					foreach ($field['options'] AS $option)
					{
						$option = trim($option);
						$inputbox .= '<option ' . iif($imageinfo["$fieldname"] == $option, 'selected="selected"') . ' value="' . $option . '">' . $option . '</option>';
					}
					$inputbox .= '</select>';
					break;

				case 'radio':

					$imageinfo["$fieldname"] = htmlspecialchars($imageinfo["$fieldname"]);

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '"><input id="' . $fieldid . '_' . $key . '" name="' . $fieldid . '" ' . iif($imageinfo["$fieldname"] == $option, 'checked="checked"') . ' type="radio" value="' . $option . '">' . $option . '</label>';
					}
					break;

				case 'checkbox':

					if (!is_array($imageinfo["$fieldname"]) AND !$editing)
					{
						$imageinfo["$fieldname"] = array();
					}
					if ($editing)
					{
						$imageinfo["$fieldname"] = explode(', ', $imageinfo["$fieldname"]);
					}

					$optarray = array();
					foreach ($imageinfo["$fieldname"] AS $okey => $ovalue)
					{
						$optarray[] = htmlspecialchars($ovalue);
					}

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '"><input id="' . $fieldid . '_' . $key . '" name="' . $fieldid . '[]" ' . iif(in_array($option, $optarray), 'checked="checked"') . ' type="checkbox" value="' . $option . '">' . $option . '</label><br />';
					}
					break;

				default:

					$inputbox = '<input class="bginput" name="' . $fieldid . '" size="40" value="' . htmlspecialchars($imageinfo["$fieldname"]) . '" />';

			}

			if ($admin)
			{
				print_label_row($field['title'], $inputbox);
			}
			else
			{
				eval('$cfbits .= "' . fetch_template('adv_gallery_upload_custombits') . '";');
			}
			unset($inputbox);
		}
	}
	return $cfbits;
}

// ######################## Sort custom fields to insert into the db ####################
function construct_customfields_sql($postfields = '', $imageid, $add = true, $makearray = false)
{
	global $db, $vbulletin, $imageinfo, $catopts, $categorycache;

	if (!empty($catopts))
	{
		$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);

		if ($catopts['allow_custom_links'])
		{
			require_once(DIR . '/includes/functions_newpost.php');
		}
	}

	$cfields = array();
	$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields");
	while ($custom = $vbulletin->db->fetch_array($customfields))
	{
		$cfields["$custom[fieldid]"] = $custom;
	}

	$db->free_result($customfields);
	unset($custom);

	if ($cfields)
	{
		foreach ($cfields AS $field => $values)
		{
			$thisfield = 'field' . $field;

			if ($makearray)
			{
				$fieldname = $postfields["$thisfield"]["$imageid"];
			}
			else
			{
				$fieldname = $postfields["$thisfield"];
			}
			if (strlen($fieldname) > $values['maxlength'] AND $values['maxlength'])
			{
				$fieldname = substr($fieldname, 0, $values['maxlength']);
			}

			if ($catopts['allow_custom_links'])
			{
				$fieldname = convert_url_to_bbcode($fieldname);
			}
			if (is_array($fieldname))
			{
				$fieldname = implode(', ', $fieldname);
			}

			if ($add)
			{
				$insert['fields'] .= ',' . $thisfield;
				$insert['values'] .= ', \'' . addslashes($fieldname) . '\'';
			}
			else
			{
				$insert['fields'] .= ', ' . $thisfield . ' = \'' . addslashes($fieldname) . '\'';
			}
		}
	}

	if ($add)
	{
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_customfields_entries (imgid $insert[fields]) VALUES ($imageid $insert[values])");
	}
	else if ($insert['fields'])
	{
		$insert['fields'] = substr($insert['fields'], 1);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_customfields_entries SET $insert[fields] WHERE imgid = '$imageid'");
	}
}

// ############################ Category Jump #################################
function print_category_jump($dcatid = 0)
{
	global $catid, $ppg_options, $_REQUEST, $vbphrase, $stylevar, $gobutton;

	if (!$ppg_options['gallery_enablecatjump'])
	{
		return;
	}
	switch ($_REQUEST['do'])
	{
		case 'favorites':
			break;
		case 'subscriptions':
			break;
		case 'newimages':
			break;
		case 'popimages':
			break;
		case 'search':
			break;
	}

	$action = $_REQUEST['do'];

	if ($_REQUEST['do'] == 'searchresults')
	{
		$action = 'search';
	}

	$doselect["$action"] = 'class="fjsel" selected="selected"';

	$options = print_cat_select($dcatid, 'catjump');

	eval('$categoryjump = "' . fetch_template('adv_gallery_categoryjump') . '";');

	return $categoryjump;
}

// ################# Construct the navbits for browseimages ######################
function construct_dir_navbits($parentlist)
{
	global $categorycache, $vbulletin, $cnavbits, $navbits, $vbphrase;

	foreach (array_reverse(explode(',', $parentlist)) AS $key => $parent)
	{
		$catid = $categorycache["$parent"]['catid'];
		if ($getusername)
		{
			if ($categorycache["$catid"]['username'])
			{
				$catusername = $categorycache["$catid"]['username'];
				$catuserid = $categorycache["$catid"]['catuserid'];
				$cnavbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$getusername&amp;u=$catuserid"] = construct_phrase($vbphrase['usernames_images'], $catusername, iif(substr($catusername, -1) != 's', $vbphrase['plural_s']));
			}
			$getusername = '';
		}

		$cnavbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$catid"] = stripslashes($categorycache["$parent"]['title']);

		if ($categorycache["$catid"]['membercat'])
		{
			$getusername = $catid;
		}
	}

	if (!empty($cnavbits))
	{
		return array_merge(iif(!empty($navbits), $navbits, array()), $cnavbits);
	}
}

// ############################# Adv Sorting URL ##############################
function construct_adv_sort_url($extra = '')
{
	global $_REQUEST;

	if ($_REQUEST['c'])
	{
		$_REQUEST['catid'] = $_REQUEST['c'];
	}

	if (in_array($_REQUEST['do'], array('favorites', 'popimages', 'newimages', 'newposts', 'member')))
	{
		$adv_sorturl = '&amp;catid=' . $_REQUEST['do'];
	}
	elseif ($_REQUEST['do'] == 'searchresults')
	{
		if ($extra)
		{
			$_REQUEST['searchid'] = $extra;
		}
		$adv_sorturl = '&amp;catid=searchresults';
	}
	else
	{
		$adv_sorturl = '&amp;c=' . htmlspecialchars($_REQUEST['catid']);
	}

	if ($_REQUEST['orderby'])
	{
		$adv_sorturl .= '&amp;orderby=' . htmlspecialchars($_REQUEST['orderby']);
	}
	if (in_array($_REQUEST['direction'], array('DESC', 'ASC')))
	{
		$adv_sorturl .= '&amp;direction=' . $_REQUEST['direction'];
	}
	if (intval($_REQUEST['searchid']))
	{
		$adv_sorturl .= '&amp;searchid=' . $_REQUEST['searchid'];
	}
	if (intval($_REQUEST['imageuser']))
	{
		$adv_sorturl .= '&amp;imageuser=' . $_REQUEST['imageuser'];
	}
	if ($_REQUEST['cutoffdate'])
	{
		$adv_sorturl .= '&amp;cutoffdate=' . htmlspecialchars($_REQUEST['cutoffdate']);
	}
	if (intval($_REQUEST['userid']))
	{
		$adv_sorturl .= '&amp;userid=' . $_REQUEST['userid'];
	}
	if ($_REQUEST['ltr'])
	{
		$adv_sorturl .= '&amp;ltr=' . htmlspecialchars($_REQUEST['ltr']);
	}

	return $adv_sorturl;
}

// ###################### Initial Update Counters Function ##################
function update_count($catid = 0, $imagecounters = true, $postcounters = true, $licounters = true)
{
	global $db, $vbulletin;

	if ($catid)
	{
		$catquery = "WHERE catid = '$catid'";
	}

	$getcats = $db->query_read("SELECT catid FROM " . TABLE_PREFIX . "ppgal_categories $catquery");
	while ($cats = $vbulletin->db->fetch_array($getcats))
	{
		if ($licounters)
		{
			$llfields = ', title, dateline, username, userid';
		}
		$imageids = array();
		$getimages = $db->query_read("SELECT imageid $llfields FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$cats[catid]' AND valid = 1 ORDER BY dateline DESC");
		$imagecount = $db->num_rows($getimages);
		$counter = 0;
		while ($images = $vbulletin->db->fetch_array($getimages))
		{
			$counter++;
			if ($counter == 1 AND $licounters)
			{
				$cats['lastimageid'] = $images['imageid'];
				$cats['lastimagedate'] = $images['dateline'];
				$cats['lastimageuser'] = $images['username'];
				$cats['lastimagetitle'] = $images['title'];
				$cats['lastimageuserid'] = $images['userid'];
			}
			$imageids[] = $images['imageid'];
		}
		$db->free_result($getimages);
		unset($images);

		$cats['imagecount'] = $imagecount;

		if (!empty($imageids) AND $postcounters)
		{
			$imageids = implode(',', $imageids);

			$pcounter = 0;
			$getposts = $db->query_read("
					SELECT postid, posts.userid, posts.username, posts.dateline, images.title
					FROM " . TABLE_PREFIX . "ppgal_posts AS posts
					LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (posts.imageid = images.imageid)
					WHERE posts.imageid IN ($imageids) AND visible = 1
					ORDER BY dateline DESC
			");
			$postcount = $db->num_rows($getposts);
			while ($posts = $vbulletin->db->fetch_array($getposts))
			{
				$pcounter++;
				if ($pcounter == 1)
				{
					$cats['lastpostid'] = $posts['postid'];
					$cats['lastpostuserid'] = $posts['userid'];
					$cats['lastpostusername'] = $posts['username'];
					$cats['lastpostdateline'] = $posts['dateline'];
					$cats['lastpostimagetitle'] = $posts['title'];
				}

				$postids[] = $posts['postid'];
			}
			$cats['pcount'] = $postcount;
			unset($imageids);
		}
		else
		{
			$cats['pcount'] = 0;
		}

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET " . iif($imagecounters, "imagecount = '$cats[imagecount]'") . "" . iif($postcounters, "" . iif($imagecounters, ',') . "postcount = '$cats[pcount]' ") . " " . iif($licounters, "" . iif($postcounters OR $imagecounters, ',') . "lastimageid = '$cats[lastimageid]', lastimagedateline = '$cats[lastimagedate]', lastimagetitle = '" . addslashes($cats['lastimagetitle']) . "', lastimageusername = '" . addslashes($cats['lastimageuser']) . "', lastimageuserid = '$cats[lastimageuserid]'") . " ,lastpostid = '$cats[lastpostid]', lastpostuserid = '$cats[lastpostuserid]', lastpostusername = '" . addslashes($cats['lastpostusername']) . "', lastpostdateline = '$cats[lastpostdateline]', lastpostimagetitle = '" . addslashes($cats['lastpostimagetitle']) . "'
 		WHERE catid = '$cats[catid]' AND hasimages = 1");
	}
 ($hook = vBulletinHook::fetch_hook('ppgal_update_count')) ? eval($hook) : false;
}


// ########################## Validate New Images #############################
function validate_new_images($validateimage)
{
	global $db, $vbulletin, $ppg_options, $email, $dateline, $username, $userid, $title, $desc, $catid, $keywords, $views, $sendmail, $validateimage, $notes, $imagecat, $thumbname, $filename;

	if (is_array($validateimage))
	{
		$deletearray = array();
		foreach ($validateimage AS $key => $val)
		{
			if ($validateimage["$key"] == 2)
			{
				$deletearray["$key"]['catid'] = $catid["$key"];
				$deletearray["$key"]['filename'] = $filename["$key"];
				$deletearray["$key"]['thumbname'] = $thumbname["$key"];
				$deletearray["$key"]['userid'] = $userid["$key"];

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$mailusername = $username["$key"];
					$imagetitle = $title["$key"];
					$imageid = $key;

					eval(fetch_email_phrases('adv_gallery_deletion'));

					vbmail($email["$key"], $subject, $message);
				}
			}
			if ($validateimage["$key"] == 1)
			{

				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET title = '" . addslashes(htmlspecialchars($title["$key"])) . "', description = '" . addslashes(htmlspecialchars($desc["$key"])) . "', keywords = '" . addslashes(htmlspecialchars($keywords["$key"])) . "', views = '$views[$key]', catid = '$catid[$key]', notes = '" . addslashes($notes["$key"]) . "', valid = 1 WHERE imageid = '$key'");

				construct_customfields_sql($_POST, $key, false, true);

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$mailusername = $username["$key"];
					$imagetitle = $title["$key"];
					$imageid = $key;

					eval(fetch_email_phrases('adv_gallery_validation'));

					vbmail($email["$key"], $subject, $message);
				}

				$cat = $db->query_first("SELECT lastimagedateline FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid[$key]'");

				if ($dateline["$key"] > $cat['lastimagedateline'])
				{
					$extrafields = ", lastimageid = '$key', lastimageusername = '" . addslashes($username["$key"]) . "', lastimagetitle = '" . addslashes(htmlspecialchars($title["$key"])) . "', lastimageuserid = '$userid[$key]', lastimagedateline = '$dateline[$key]'";
				}

				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET imagecount = imagecount+1 $extrafields WHERE catid = '$catid[$key]'");

                // Update user post counts
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_user SET ppicount = ppicount+1 WHERE userid = '$userid[$key]'");
			}
		}
		if (!empty($deletearray))
		{
			delete_images('', $deletearray);
		}
	}
($hook = vBulletinHook::fetch_hook('ppgal_validate_image')) ? eval($hook) : false;
}

// ####################### Validate New Posts ######################
function validate_new_posts()
{
	global $db, $vbulletin, $ppg_options, $title, $message, $validatepost, $catid, $imageid, $userid, $username, $dateline, $imagetitle;

	if (is_array($validatepost))
	{
		foreach ($validatepost AS $key => $val)
		{
			if ($validatepost["$key"] == 2)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid = '$key'");
			}

			if ($validatepost["$key"] == 1)
			{

				// Update image info
				$image = $db->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid[$key]'");
				if ($image['lastpostdateline'] < $dateline["$key"])
				{
					$lastpostquery = ", lastpostuserid = '$userid[$key]', lastpostusername = '" . addslashes($username["$key"]) . "', lastpostdateline = '$dateline[$key]'";
				}
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET posts = posts+1 $lastpostquery WHERE imageid = '$imageid[$key]'");
            $db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_posts SET visible = 1 WHERE postid = '$key'");
				// Send email to subscribed users
				send_subscribed_posts($imageid["$key"], true, $userid["$key"], $username["$key"], $message["$key"]);

				// Update image info
                $cat = $db->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid = '$catid[$key]'");
				if ($cat['lastpostdateline'] < $dateline["$key"])
				{
					$lastpostcatquery = ", lastpostid = '$key', lastpostuserid = '$userid[$key]', lastpostusername = '" . addslashes($username["$key"]) . "', lastpostdateline = '$dateline[$key]', lastpostimagetitle = '" . addslashes($imagetitle[$key]) . "'";
				}

				// Update directory info
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET postcount = postcount+1 $lastpostcatquery WHERE catid = '$catid[$key]'");

                $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_posts SET visible = 1 WHERE postid = '$key'");
			}
		}
	}
($hook = vBulletinHook::fetch_hook('ppgal_validate_post')) ? eval($hook) : false;
}

// ############################# Subscribed Posts #########################
function send_subscribed_posts($imageid, $moderation = false, $userid = '', $username = '', $message = '')
{
	global $db, $vbulletin, $ppg_options, $post;

	if ($ppg_options['gallery_allowsubscribe'])
	{
		$image = $db->query_first("
                SELECT images.imageid, images.title, posts.dateline, categories.title AS cattitle
                FROM " . TABLE_PREFIX . "ppgal_images AS images
                LEFT JOIN " . TABLE_PREFIX . "ppgal_posts AS posts USING (imageid)
                LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories ON (images.catid = categories.catid)
                WHERE images.imageid = '$imageid' ORDER BY dateline DESC LIMIT 1
        ");

		if (!$moderation)
		{
			$userid = $vbulletin->userinfo['userid'];
		}
		else
		{
			$post['message'] = $message;
			$vbulletin->userinfo['username'] = $username;
		}

		$image['title'] = stripslashes($image['title']);
		$image['category'] = stripslashes($image['cattitle']);

		$subscriptions = $db->query_read("
				SELECT subscriptions.userid, username, email
				FROM " . TABLE_PREFIX . "ppgal_subscribeimage AS subscriptions
				INNER JOIN " . TABLE_PREFIX . "user AS user USING (userid)
				WHERE imageid = '$imageid' AND user.lastactivity > '$image[dateline]' AND subscriptions.userid != '$userid'
		");
		while ($subscription = $vbulletin->db->fetch_array($subscriptions))
		{
			eval(fetch_email_phrases('adv_gallery_subscribe_image'));
			vbmail($subscription['email'], $subject, $message);
		}
		$db->free_result($subscriptions);
		unset($subscription);
	}
}

// ############################ Fetch Page Data ###############################
function fetch_page_data($script)
{
	global $db, $ppg_options, $condition, $pparray, $wherequery, $_REQUEST, $search;

	if ($_REQUEST['do'] != 'searchresults' OR $_REQUEST['do'] == 'searchresults' AND sizeof($wherequery) > 1)
	{
	  $pagedata = $db->query_first("
	  		SELECT COUNT(*) AS count
	  		FROM " . TABLE_PREFIX . $condition['fromtable'] . "
	  		" . iif($condition[join], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join'] . ' USING (imageid)') . "
	  		" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
	  ");
	}
	else
	{
		$pagedata['count'] = $search['numresults'];
	}

	$pagedata['pagenumber'] = intval($_REQUEST['page']);

	// Work out pages & limits
	if (!$pagedata['pagenumber'])
	{
		$pagedata['pagenumber'] = 1;
	}

	if ($script == 'browseimages')
	{
		if ($script != 'gallery_mod')
    {
		if (intval($_REQUEST['perpage']))
		{
			set_bbarray_cookie('gallery_perpage', 1, $_REQUEST['perpage'], 1);
		}

		if (fetch_bbarray_cookie('gallery_perpage', 1))
		{
			$pagedata['perpage'] = fetch_bbarray_cookie('gallery_perpage', 1);
		}
	}
	}

	if (!intval($pagedata['perpage']) OR ($script == 'browseimages' AND !in_array($pagedata['perpage'], $pparray)))
	{
	  $pagedata['perpage'] = $ppg_options['gallery_imagesperpage'];
	}

	$pagedata['minlimit'] = intval(($pagedata['pagenumber'] - 1) * $pagedata['perpage'] + 1);
	$pagedata['maxlimit'] = intval($pagedata['pagenumber'] * $pagedata['perpage']);

	if ($pagedata['maxlimit'] > $pagedata['count'])
	{
		$pagedata['maxlimit'] = $pagedata['count'];
		if ($pagedata['minlimit'] > $pagedata['count'])
		{
		  $pagedata['minlimit'] = $pagedata['count'] - $pagedata['perpage'];
		}
	}
	if ($pagedata['minlimit'] <= 0)
	{
	  $pagedata['minlimit'] = 1;
	}

	$pagedata['pagecount'] = ceil($pagedata['count'] / $pagedata['perpage']);

	return $pagedata;
}

function empty_category($catid)
{
	global $db, $vbulletin;

	$deletearray = array();
	$images = $db->query_read("SELECT imageid, userid, filename, thumbname, originalname FROM " . TABLE_PREFIX . "ppgal_images WHERE catid = '$catid'");
	while ($image = $vbulletin->db->fetch_array($images))
	{
		$deletearray["$image[imageid]"]['catid'] = $catid;
		$deletearray["$image[imageid]"]['userid'] = $image['userid'];
		$deletearray["$image[imageid]"]['filename'] = $image['filename'];
		$deletearray["$image[imageid]"]['thumbname'] = $image['thumbname'];
		$deletearray["$image[imageid]"]['originalname'] = $image['originalname'];
	}

	if (is_array($deletearray))
	{
		delete_images('', $deletearray);
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET imagecount = 0, postcount = 0, catimage = '', lastpostusername = '', lastimageid = '', lastimagetitle = '', lastimageuserid = '', lastimageusername = '', lastimagedateline = '', lastpostid = '', lastpostimagetitle = '', lastpostuserid = '', lastpostusername = '', lastpostdateline = '' WHERE catid = '$catid'");

}

// ############################# Delete Category ##############################
function delete_category($catid)
{
	global $db, $ppg_options, $vbulletin;

	$getcatids = fetch_category_children($catid);

	$catids = implode(',', $getcatids);

	$deletearray = array();
	$images = $db->query_read("SELECT imageid, catid, userid, filename, originalname, thumbname FROM " . TABLE_PREFIX . "ppgal_images WHERE catid IN($catids)");
	while ($image = $vbulletin->db->fetch_array($images))
	{
		$deletearray["$image[imageid]"]['catid'] = $image['catid'];
		$deletearray["$image[imageid]"]['userid'] = $image['userid'];
		$deletearray["$image[imageid]"]['filename'] = $image['filename'];
		$deletearray["$image[imageid]"]['thumbname'] = $image['thumbname'];
		$deletearray["$image[imageid]"]['originalname'] = $image['originalname'];
	}

	if (is_array($deletearray))
	{
		delete_images('', $deletearray);
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_categories WHERE catid IN($catids)");

($hook = vBulletinHook::fetch_hook('ppgal_delete_category')) ? eval($hook) : false;

update_category_cache();
}

// ######## Update child categories display order of a parent by title ( A,B,C order ) ##############
function update_category_displayorder($catid)
{
$getcats = $db->query_read("
        SELECT title, displayorder
        FROM " . TABLE_PREFIX . "ppgal_categories
        WHERE parent = '$catid'
        ORDER BY title ASC
");
	while ($category = $vbulletin->db->fetch_array($getcats))
	{
    $count = $count + 10;
      $db->query_write("
          UPDATE " . TABLE_PREFIX . "ppgal_categories
          SET displayorder = '$count'
          WHERE title = '" . addslashes($category[title]) . "'
          AND parent = '$catid'
      ");
	}
update_category_cache();
}

// ########################### Find Category Children #########################
function fetch_category_children($cat = 0)
{
	global $categorycache;

	$getcatarray = construct_categories($categorycache, $cat);
	$catarray = array();
	$catarray[] = $cat;
	if (!empty($getcatarray))
	{
		foreach ($getcatarray AS $cats)
		{
			$catarray[] = $cats['catid'];
		}
	}
	return $catarray;
}


// ##################### Check Image Viewing Permissions ######################
function check_image_view($image, $scriptname = 'showimage')
{
	global $categoryperms, $categorycache, $vbulletin;

	check_image_id($image['imageid']);

	if (empty($categoryperms))
	{
		$categoryperms = fetch_category_perms();
	}

	if (!$categoryperms["$image[catid]"]['canviewlargimage'])
	{
		print_no_permission();
	}

	if ($categorycache["$image[catid]"]['catuserid'] AND !is_category_mod($image['catid']) AND $categorycache["$image[catid]"]['catuserid'] != $vbulletin->userinfo['userid'] AND (!$categorycache["$image[catid]"]['membercat'] OR $categorycache["$image[catid]"]['membercat'] AND $image['userid'] != $vbulletin->userinfo['userid']))
	{
		$useroptions = construct_cat_user_opts($image['catid'], $categorycache["$image[catid]"]['useroptions']);
		if (!$useroptions['allow_view'])
		{
			print_no_permission();
		}
	}

	check_category_password($image['catid'], true, $scriptname);
}

// ######################## Construct Replacement Array #######################
if (!function_exists('construct_replacement_array'))
{
	function construct_replacement_array($optreplace, $replacearray)
	{
		global $vbulletin;
		if (!empty($optreplace))
		{
			foreach ($optreplace AS $filename)
			{
				if (trim($filename))
				{
					$replacearray['find'][] = '"' . $filename;
					$replacearray['replace'][] = '"' . $vbulletin->options['bburl'] . '/' . $filename;
				}
			}
		}
		return array_merge((array)$optreplace, (array)$replacearray);
	}
}

// ######################### Fetch Ignored Userids ############################
function fetch_ignored_users($catid = 0)
{
	global $vbulletin;
	$ignusers = array();
	if (!is_category_mod($catid))
	{
		$ignusers = fetch_coventry();
	}
	if ($vbulletin->userinfo['ignorelist'])
	{
		$ignusers = array_merge((array)$ignusers, (array)explode(' ', $vbulletin->userinfo['ignorelist']));
	}

	if (!empty($ignusers))
	{
		return implode(',', $ignusers);
	}
}

// ####################### Update Stats Cache ##############################

function build_gallery_stats()
{
global $vbulletin;
$totalcache = array();
    $timages = $vbulletin->db->query_read("
        SELECT COUNT(imageid) AS images,
        SUM(views) AS views,
        SUM(posts) AS posts,
        SUM(filesize) AS filesize,
        SUM(originalfilesize) AS origfilesize
        FROM " . TABLE_PREFIX . "ppgal_images
    ");

    while ($timage = $vbulletin->db->fetch_array($timages))
    {
       $totalcache1[] = $timage;
    }

    $tcats = $vbulletin->db->query_read("
        SELECT COUNT(catid) AS categories,
        SUM(membercat) AS membercat
        FROM " . TABLE_PREFIX . "ppgal_categories
    ");

    while ($tcat = $vbulletin->db->fetch_array($tcats))
    {
       $totalcache2[] = $tcat;
    }

    $tcards = $vbulletin->db->query_read("
        SELECT COUNT(cardid) AS cards
        FROM " . TABLE_PREFIX . "ppgal_ecards
    ");

    while ($tcard = $vbulletin->db->fetch_array($tcards))
    {
       $totalcache3[] = $tcard;
    }

$totalcache = array_merge((array)$totalcache1, (array)$totalcache2, (array)$totalcache3);

($hook = vBulletinHook::fetch_hook('ppgal_build_stats')) ? eval($hook) : false;

build_datastore('ppg_stats', serialize($totalcache), 1);
}


($hook = vBulletinHook::fetch_hook('ppgal_func_complete')) ? eval($hook) : false;
?>