<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

require_once(DIR . '/includes/functions_gallery.php');

// Get our category & options caches
$categorycache =& $vbulletin->gallery_c_cache;
$ppg_options =& $vbulletin->adv_gallery_opt;
$gallery_permissions =& $vbulletin->gallery_ugroups;

// permissions check
if (empty($galleryperms))
{
    $bbuserino['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);
    if (empty($bbuserino['usergrouparray']))
    {
        $bbuserino['usergrouparray'] = array(1);
    }
    foreach ($bbuserino['usergrouparray'] AS $usergroupid)
    {
        if (empty($gallery_permissions["$usergroupid"]))
        {
            $usergroupid = 1;
        }
        foreach ($gallerypermissionsbit AS $option => $value)
        {
            if (!$galleryperms["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
            {
                $galleryperms["$option"] = 0;
                if ($gallery_permissions["$usergroupid"]['gallery_perms'] & $value)
                {
                    $galleryperms["$option"] = 1;
                }
            }
        }
    }
}



if ($ppg_options['gallery_active'] AND $userinfo['profile_active'] AND $galleryperms['canviewprofileblock']){

// needed to get imagebit fields
function ppgal_profile_image_fields()
{
	global  $show;

    $query['fields'] = ' ,images.userid, images.username, images.description, images.dateline, images.views, posts';
    $query['fields'] .= ' ,width, height, originalwidth, originalheight';
    $query['fields'] .= ' ,filesize, originalfilesize';
	$query['fields'] .= ', images.lastpostdateline, images.lastpostuserid, images.lastpostusername';
	$query['fields'] .= ', votenum, votetotal';
	$query['fields'] .= iif($fields, ', images.' . $fields);

	if ($show['category'])
	{
		$query['fields'] .= ', categories.title AS cattitle';
		$query['tables'] .= 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_categories AS categories USING (catid)';
	}

	return $query;
}

// create image bit
function ppgal_profile_imagebits(&$images, $highlight = '', $itype, &$showfields, &$show)
{
	global $ppg_options, $stylevar, $vbulletin, $vbphrase, $adv_sorturl, $catinfo, $counter, $cellwidth, $categoryperms, $categorycache, $catopts, $bbcode_parser;

	if ($counter > $ppg_options['gallery_columns'])
	{
		$imagebits .= '</tr><tr>';
		$counter = 1;
	}

	$images['title'] = stripslashes($images['title']);

	if (!$images['title'])
	{
		$images['title'] = $images['filename'];
	}

	if (!$catopts["$images[catid]"])
	{
		$catopts["$images[catid]"] = construct_cat_opts($images['catid'], $categorycache["$images[catid]"]['options']);
	}

	if ($images['originalname'])
	{
		if ($ppg_options['gallery_watermark'] AND $ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = 'displayimage.php?imageid=' . $images['imageid'] . '&original=1';
		}
		else if ($ppg_options['gallery_originalwindow'])
		{
			$images['originalurl'] = construct_image_url($images, 'originalname');
		}
		else
		{
			$images['originalurl'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $images['imageid'] . '&amp;original=1';
		}
	}

	$images['username'] = stripslashes($images['username']);
	$images['cattitle'] = stripslashes($images['cattitle']);
    $images['views'] = vb_number_format($images['views']);
	$images['filesize'] = vb_number_format($images['filesize'], 1, true);
	$images['dateadded'] = vbdate($vbulletin->options['dateformat'], $images['dateline']);
	$images['timeadded'] = vbdate($vbulletin->options['timeformat'], $images['dateline']);
   	$images['description'] = stripslashes($images['description']);


	if ($images['originalfilesize'])
	{
		$images['originalfilesize'] = vb_number_format($images['originalfilesize'], 1, true);
	}


    $images['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $images['lastpostdateline']);
    $images['lastposttime'] = vbdate($vbulletin->options['timeformat'], $images['lastpostdateline']);
    $images['lastpostusername'] = stripslashes($images['lastpostusername']);
    $images['replies'] = vb_number_format($images['posts']);


    $images['url'] = construct_image_url($images, $itype);
    $itype = '';
    $images['rating'] = '';

    if ($images['votetotal'] AND $images['votenum'])
	{
		$images['truerating'] = vb_number_format($images['votetotal'] / $images['votenum'], 2);
		$images['rating'] = round($images['truerating']);
	}

	eval('$imagebits .= "' . fetch_template('adv_gallery_member_imagebit') . '";');

	return $imagebits;
}



// Create a list of fields to be shown in the imagebit
if($userinfo['profile_imagebitdisplay']){
$showfield = explode(',', $userinfo['profile_imagebitdisplay']);
}
if (!empty($showfield))
	{
		$showfields = array();
		foreach ($showfield AS $field)
		{
			$showfields["$field"] = 1;
		}
		if ($showfields['category'] == 1){
			$show['category'] = true;
		}
	}


$galleryorderby = $userinfo['profile_orderby'];
$catlimit = $userinfo['profile_include'];
$notcat = $userinfo['profile_exclude'];
$ppg_options['gallery_columns'] = $userinfo['profile_column'];
$placement = $userinfo['profile_place'];
$itype = $userinfo['profile_showimg'];  // thumbname || filename || originalname

$query = ppgal_profile_image_fields();

switch ($placement)
{
    case 1: $placement = '$header'; break;
    case 2: $placement = '$navbar'; break;
    case 3: $placement = '$template_hook[profile_right_first]'; break;
    case 4: $placement = '$template_hook[profile_right_mini]'; break;
    case 5: $placement = '$template_hook[profile_right_album]'; break;
    case 6: $placement = '$template_hook[profile_right_last]'; break;
    case 7: $placement = '$template_hook[profile_left_first]'; break;
    case 8: $placement = '$template_hook[profile_left_last]'; break;
    case 9: $placement = '<!-- end usercss -->'; break;
}

switch ($galleryorderby){
    case 2:
        $galleryorderby = 'views DESC';
        $imgblock['title'] = ''.$vbphrase['most_viewed'].'';
    break;
    case 3:
        $galleryorderby = 'posts DESC';
        $imgblock['title'] = ''.$vbphrase['most_comments'].'';
    break;
    case 4:
        $galleryorderby = 'votetotal DESC';
        $imgblock['title'] = ''.$vbphrase['highest_rated'].'';
    break;
    case 5:
        $galleryorderby = 'RAND()';
        $imgblock['title'] = ''.$vbphrase['random'].'';
    break;
    default:
        $galleryorderby = 'dateline DESC';
        $imgblock['title'] = ''.$vbphrase['latest_submition'].'';
}



// Get a list of categories to be EXCLUDED from our query
if ($privatecatids = fetch_private_categories())
{
    $privcatids = 'images.catid NOT IN(' . $privatecatids . ') AND ';
}

$ignusers = fetch_ignored_users();

if ($ignusers)
{
	$ignquery = 'AND images.userid NOT IN(' . $ignusers . ')';
}

$profileimages_datecut = TIMENOW - (86400*$userinfo['profile_cutoff']);

$counter = 0;
$cellwidth = round(100 / $ppg_options['gallery_columns']) . '%';
$getrand = $db->query_read("
    SELECT $votequery imageid, images.title, images.description, filename, thumbname, originalname, extension, images.catid $query[fields]
    FROM " . TABLE_PREFIX . "ppgal_images AS images
    $query[tables]
    WHERE $privcatids valid = 1 $ignquery AND images.userid = $userinfo[userid]
" . iif(!empty($userinfo['profile_cutoff']), "AND dateline >= $profileimages_datecut") . "
" . iif(!empty($catlimit), "AND images.catid IN ($catlimit)") . "
" . iif(!empty($notcat), "AND images.catid NOT IN ($notcat)") . "
" . iif($itype == 'thumbname', "AND images.thumbname != ''") . "
" . iif($itype == 'filename', "AND images.filename != ''") . "
" . iif($itype == 'originalname', "AND images.originalname != ''") . "
    ORDER BY $galleryorderby
    LIMIT ".$userinfo['profile_limit']."
");

	while ($images = $vbulletin->db->fetch_array($getrand))
	{ 
		$counter++;
        $adv_sorturl = '&amp;catid=' . $images['catid'];
        $gal_imagebits .= ppgal_profile_imagebits($images, '', $itype, $showfields, $show);
	}
    $gal_imagebits .= construct_empty_cellbits($ppg_options['gallery_columns']);

$db->free_result($getrand);

// ### Update the template to have the path qualified ###
	$gal_imagebits = str_replace(array('"showimage.php', '"browseimages.php'), array('"' . $ppg_options['gallery_url'] . '/showimage.php', '"' . $ppg_options['gallery_url'] . '/browseimages.php'), $gal_imagebits);

    $search_text = $placement;
    $vbulletin->templatecache['MEMBERINFO'] = str_replace($search_text,
    $search_text.fetch_template('adv_gallery_profile'),$vbulletin->templatecache['MEMBERINFO']);

}


?>