<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'gallery_stats');
define('PP_SCRIPT', 'vBGallery');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
    'ADV_GALLERY_STATS',
    'adv_gallery_stats_navbar',
    'adv_gallery_stats_nav1',
    'adv_gallery_stats_stat1',
    'adv_gallery_stats_stat2',
    'adv_gallery_stats_categories',
    'adv_gallery_stats_comments',
    'adv_gallery_stats_views',
    'adv_gallery_stats_upload',
    'adv_gallery_stats_close',
    'adv_gallery_stats_nodisplay'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################

require_once('./gallery_global.php');
require_once(DIR . '/includes/adminfunctions.php');
require_once(DIR . '/includes/functions_gallery.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


if ($ppg_options['gallery_stats_active'] AND $show['stats'])
{

      $topuploads = intval($ppg_options['gallery_stats_uploads']);
      $topcomments = intval($ppg_options['gallery_stats_comments']);
      $topviewed = intval($ppg_options['gallery_stats_viewed']);
      $topcategories = intval($ppg_options['gallery_stats_categories']);

      if ($topuploads < 0){
      $topuploads = 10;
      }

      if ($topcomments < 0){
      $topcomments = 5;
      }

      if ($topviewed < 0){
      $topviewed = 5;
      }

      if ($topcategories < 0){
      $topcategories = 5;
      }

if (empty($_REQUEST['do']))
    {

// Top Gallery Uploads
        $get_stats_uploads = $db->query_read("
            SELECT user.userid, user.usergroupid, user.username, ppgal_user.ppicount
            FROM " . TABLE_PREFIX . "user AS user
            LEFT JOIN " . TABLE_PREFIX . "ppgal_user AS ppgal_user ON (ppgal_user.userid = user.userid)
            WHERE ppicount > 0
            ORDER BY ppicount DESC
            LIMIT $topuploads
        ");

        if ($db->num_rows($get_stats_uploads)){
            while ($getstats_upload = $db->fetch_array($get_stats_uploads)){
            $getstats_upload['fullusername'] = strip_tags($getstats_upload['username']);
            $getstats_upload['username'] = strip_tags($getstats_upload['username']);
            $getstats_upload['musername'] = fetch_musername($getstats_upload);
            eval('$maxuploadxs .= "' . fetch_template('adv_gallery_stats_upload') . '";');
            }
        }else{
			eval('$maxuploadxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
		}

// Most Comments on a image
        $maxcommentx = $db->query_read("
            SELECT * FROM " . TABLE_PREFIX . "ppgal_images
            WHERE posts > 0
            ORDER BY posts DESC
            LIMIT $topcomments
        ");

        if ($db->num_rows($maxcommentx)){
            while ($maxcomment = $db->fetch_array($maxcommentx)){
            $maxcomment['url'] = construct_image_url($maxcomment, 'thumbname');
            $maxcomment['title'] = str_replace('&amp;', '&', $maxcomment['title']);
	        $maxcomment['description'] = str_replace('&amp;', '&', $maxcomment['description']);
            eval('$maxcommentxs .= "' . fetch_template('adv_gallery_stats_comments') . '";');
            }
        }else{
			eval('$maxcommentxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
		}

// Most Image Views
        $maxviewx = $db->query_read("
            SELECT * FROM " . TABLE_PREFIX . "ppgal_images
            WHERE views > 0
            ORDER BY views DESC
            LIMIT $topviewed
        ");

        if ($db->num_rows($maxviewx)){
            while ($maxview = $db->fetch_array($maxviewx)){
            $maxview['url'] = construct_image_url($maxview, 'thumbname');
            $maxview['title'] = str_replace('&amp;', '&', $maxview['title']);
	        $maxview['description'] = str_replace('&amp;', '&', $maxview['description']);
            eval('$maxviewxs .= "' . fetch_template('adv_gallery_stats_views') . '";');
            }
        }else{
			eval('$maxviewxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
		}

// Most Popular Categories in images
        $bestcatx = $db->query_read("
            SELECT * FROM " . TABLE_PREFIX . "ppgal_categories
            WHERE imagecount > 0
            ORDER BY imagecount DESC
            LIMIT $topcategories
        ");

        if ($db->num_rows($bestcatx)){
            while ($bestcat = $db->fetch_array($bestcatx)){
                eval('$maxcatxs .= "' . fetch_template('adv_gallery_stats_categories') . '";');
            }
        }else{
			eval('$maxcatxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
		}
    eval('$topresult = "' . fetch_template('adv_gallery_stats_nav1') . '";');
}

$navbits = array();
$navbits[''] = "$vbphrase[stats_menu1]";
$tablename = "($vbphrase[adv_gallery_stats_navbar])";

// Poll Stats
if ($_REQUEST['do']=='ecards' OR $_REQUEST['do']=='uploads' OR $_REQUEST['do']=='posts')
{

// Top Gallery Uploads
        $get_stats_uploads = $db->query_read("
            SELECT user.userid, user.usergroupid, user.username, ppgal_user.ppicount
            FROM " . TABLE_PREFIX . "user AS user
            LEFT JOIN " . TABLE_PREFIX . "ppgal_user AS ppgal_user ON (ppgal_user.userid = user.userid)
            WHERE ppicount > 0
            ORDER BY ppicount DESC
            LIMIT $topuploads
        ");

        if ($db->num_rows($get_stats_uploads))
		{
            while ($getstats_upload = $db->fetch_array($get_stats_uploads))
            {
            $getstats_upload['fullusername'] = strip_tags($getstats_upload['username']);
            $getstats_upload['username'] = strip_tags($getstats_upload['username']);
            $getstats_upload['musername'] = fetch_musername($getstats_upload);
            eval('$maxuploadxs .= "' . fetch_template('adv_gallery_stats_upload') . '";');
            }
        }else{
			eval('$maxuploadxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
		}

// Most Popular Categories in images
        $bestcatx = $db->query_read("
            SELECT * FROM " . TABLE_PREFIX . "ppgal_categories
            WHERE imagecount > 0
            ORDER BY imagecount DESC
            LIMIT $topcategories
        ");

        if ($db->num_rows($bestcatx))
		{
            while ($bestcat = $db->fetch_array($bestcatx))
            {
            eval('$maxcatxs .= "' . fetch_template('adv_gallery_stats_categories') . '";');
            }
        }else{
			eval('$maxcatxs = "' . fetch_template('adv_gallery_stats_nodisplay') . '";');
		}


    switch ($_REQUEST['do'])
    {
    	case 'ecards':
    		$type = 'necard';
    		$tablename = "$vbphrase[stats_ecard_stats]";
            $navbits[''] = "$vbphrase[stats_ecard_stats]";
            break;
    	case 'uploads':
    		$type = 'nimage';
    		$tablename = "$vbphrase[stats_upload_stats_stat]";
            $navbits[''] = "$vbphrase[stats_upload_stats_stat]";
            break;
    	case 'posts':
    		$type = 'npost';
    		$tablename = "$vbphrase[stats_most_comments]";
            $navbits[''] = "$vbphrase[stats_most_comments]";
            break;
    }


    $orderby = 'dateline ASC';
    $vbulletin->GPC['scope'] = 'daily';
    $sqlformat = '%w %U %m %Y';
    $phpformat = '! d, Y';

    $cutoff = intval($ppg_options['gallery_stats_days']);

    if ($cutoff <= 0){
    $cutoff = 30;
    }

    $start_time = TIMENOW - 3600 * 24 * $cutoff;
    $end_time = TIMENOW;

	$statistics = $db->query_read("
		SELECT SUM($type) AS total,
		DATE_FORMAT(from_unixtime(dateline), '$sqlformat') AS formatted_date,
		MAX(dateline) AS dateline
  		FROM " . TABLE_PREFIX . "ppgal_stats
		WHERE dateline >= $start_time
		AND dateline <= $end_time
		GROUP BY formatted_date
		" . (empty($vbulletin->GPC['nullvalue']) ? " HAVING total > 0 " : "") . "
		ORDER BY $orderby
	");

	while ($stats = $db->fetch_array($statistics))
	{ // we will now have each days total of the type picked and we can sort through it
		$month = strtolower(date('F', $stats['dateline']));
		$dates[] = str_replace(' ', '&nbsp;', str_replace('#', $vbphrase['week'] . '&nbsp;' . strftime('%U', $stats['dateline']), str_replace('!', $vbphrase["$month"], date($phpformat, $stats['dateline']))));
		$results[] = $stats['total'];
	}

    if (!sizeof($results)){
    eval(standard_error(fetch_error('no_matches_found')));
    }

	// we'll need a poll image
	$style = $db->query_first("
		SELECT stylevars FROM " . TABLE_PREFIX . "style
		WHERE styleid = " . $vbulletin->options['styleid'] . "
		LIMIT 1
	");
	$stylevars = unserialize($style['stylevars']);
	unset($style);

    eval('$topresult .= "' . fetch_template('adv_gallery_stats_stat1') . '";');

	$maxvalue = max($results);
	foreach ($results as $key => $value)
	{
		$i++;
		$bar = ($i % 6) + 1;
		if ($maxvalue == 0){
			$percentage = 100;
		}else{
			$percentage = ceil(($value/$maxvalue) * 100);
		}
		$topresult .= print_statistic_result($dates["$key"], $bar, $value, $percentage);
	}
}

// Total Stats pulled from datastore
$stats['images'] = vb_number_format($maximages);
$stats['views'] = vb_number_format($maxviews);
$stats['categories'] = vb_number_format($maxcategories);
$stats['memcat'] = vb_number_format($maxmembercat);
$stats['cards'] = vb_number_format($maxcards);
$stats['posts'] = vb_number_format($maxposts);
$stats['diskspace'] = vb_number_format($maxfilesize + $maxorigfilesize, 1, true);

// Page is open
$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');
eval('print_output("' . fetch_template('ADV_GALLERY_STATS') . '");');

}else{

// Page is closed
     $navbits = array();
     $navbits[''] = "$vbphrase[stats_menu1]";
     $navbits = construct_navbits($navbits);
     eval('$navbar = "' . fetch_template('navbar') . '";');
     eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');
     eval('print_output("' . fetch_template('adv_gallery_stats_close') . '");');
}


?>