<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////


require_once(DIR . '/includes/functions_gallery.php');

// let's pull some datastore info
$categorycache =& $vbulletin->gallery_c_cache;
$ppg_options =& $vbulletin->adv_gallery_opt;
$gallery_permissions =& $vbulletin->gallery_ugroups;
$totalcache =& $vbulletin->ppg_stats;


/* ######################  FORUMHOME STATS ADD-ON ###################################*/

// Total Stats pulled from datastore
// This will show on ForumHome when it shows on Gallery Home.
if ($ppg_options['gallery_showstats'] AND $ppg_options['gallery_stats_forumhome']){

  $total = array();
  foreach ($totalcache AS $totals){
   $total[] = $totals;
  }

  $maximages = $total['0']['images'];
  $maxviews = $total['0']['views'];
  $maxposts = $total['0']['posts'];
  $maxfilesize = $total['0']['filesize'];
  $maxorigfilesize = $total['0']['origfilesize'];
  $maxcategories = $total['1']['categories'];
  $maxmembercat = $total['1']['membercat'];
  $maxcards = $total['2']['cards'];
  unset($total);

  // Convert stats to clean numbers
  $stats['images'] = vb_number_format($maximages);
  $stats['views'] = vb_number_format($maxviews);
  $stats['categories'] = vb_number_format($maxcategories);
  $stats['memcat'] = vb_number_format($maxmembercat);
  $stats['cards'] = vb_number_format($maxcards);
  $stats['posts'] = vb_number_format($maxposts);
  $stats['diskspace'] = vb_number_format($maxfilesize + $maxorigfilesize, 1, true);

  $show['stats'] = true;

  // Try and auto place stats
  $search_text = '<!-- end logged-in users -->';
  $vbulletin->templatecache['FORUMHOME'] = str_replace($search_text,
  $search_text.fetch_template('adv_gallery_forumhome_stats'),$vbulletin->templatecache['FORUMHOME']);

  // place $vbgallery_stats in FORUMHOME template if ^ auto insert does not work.
  eval('$vbgallery_stats = "' . fetch_template('adv_gallery_forumhome_stats') . '";');
}

// check gallery permissions
if (empty($galleryperms))
{
    $bbuserino['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

    if (empty($bbuserinfo['usergrouparray']))
    {
        $bbuserinfo['usergrouparray'] = array(1);
    }

    foreach ($bbuserino['usergrouparray'] AS $usergroupid)
    {
        if (empty($gallery_permissions["$usergroupid"]))
        {
            $usergroupid = 1;
        }

        foreach ($gallerypermissionsbit AS $option => $value)
        {
            if (!$galleryperms["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
            {
                $galleryperms["$option"] = 0;
                if ($gallery_permissions["$usergroupid"]['gallery_perms'] & $value)
                {
                    $galleryperms["$option"] = 1;
                }
            }
        }
    }
}
/* ######################  FORUMHOME IMAGES ADD-ON ###################################*/

// This is the start of the forumhome add-on to display images
if ($ppg_options['gallery_active'] AND $ppg_options['add_home_active'] AND $galleryperms['canviewforumhomeblock']){

// Create a list of fields to be shown in the imagebit
if ($ppg_options['add_home_imagebitdisplay']){
$showfield = explode(',', $ppg_options['add_home_imagebitdisplay']);
}

if (!empty($showfield)){
    $showfields = array();
	foreach ($showfield AS $field){
	    $showfields["$field"] = 1;
	}
	if ($showfields['category'] == 1){
	    $show['category'] = true;
	}
}

//  Show Variables
if ($ppg_options['add_home_navbar'] == '1'){
	if ($galleryperms['cansearchimages'])
	{
		$show['search'] = true;
	}
	if ($galleryperms['cansendimagetofriend'])
	{
		$show['sendtofriend'] = true;
	}
	if ($ppg_options['gallery_showmodcolumn'])
	{
		$show['modcolumn'] = true;
	}
	if ($ppg_options['gallery_allowsubscribe'] AND $vbulletin->userinfo['userid'])
	{
		$show['subscribe'] = true;
	}
	if ($ppg_options['gallery_allowfav'] AND $vbulletin->userinfo['userid'])
	{
		$show['favorites'] = true;
	}
	if ($galleryperms['cancreatecategories'])
	{
		$show['catmanager'] = true;
	}
	
	$gallery_modcache = unserialize($vbulletin->gal_mod_cache);
	
	if ($permissions['adminpermissions'] & CANCONTROLPANEL)
	{
		$show['modoptions'] = true;
	}
	else if (!empty($gallery_modcache))
	{
		foreach ($gallery_modcache AS $moderator)
		{
			if ($moderator['userid'] == $vbulletin->userinfo['userid'])
			{
				$show['modoptions'] = true;
			}
		}
	}
	
	// Navbar Width
	$lnavrows = 3;
	if ($show['favorites'] OR $show['subscribe'] OR $show['catmanager']){
		$lnavrows++;
	}
	if ($ppg_options['gallery_newimagelimit']){
		$lnavrows++;
	}
	if ($ppg_options['gallery_popimagelimit']){
		$lnavrows++;
	}
	if ($show['uploadlink']){
		$lnavrows++;
	}
	if ($show['modoptions']){
		$lnavrows++;
	}

	$navbarwidth = intval(100 / $lnavrows) . '%';
	
	if ($ppg_options['gallery_newimagelimit']){
		foreach (explode(',', $ppg_options['gallery_newimagelimit']) AS $ndatecut){
			$show['newimagenav'] = true;
			$dayphrase = construct_phrase($vbphrase['last_x_days'], $ndatecut);
			eval('$newimagenavbits .= "' . fetch_template('adv_gallery_newestbits') . '";');
			$show['newimagenav'] = false;
			eval('$newpostnavbits .= "' . fetch_template('adv_gallery_newestbits') . '";');
		}
	}
	eval('$gallerynav = "' . fetch_template('adv_gallery_nav') . '";');
}
// end NAV
$galleryorderby = $ppg_options['add_home_orderby'];
$catlimit = $ppg_options['add_home_include'];
$notcat = $ppg_options['add_home_exclude'];
$ppg_options['gallery_columns'] = $ppg_options['add_home_column'];
$placement = $ppg_options['add_home_place'];

require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
$query = fetch_image_fields();


// Placement on FORUMHOME template
switch ($placement){
  case 2: $placement = '<body>'; break;
  case 3: $placement = '$header'; break;
  case 4: $placement = '<!-- what\'s going on box -->'; break;
  case 5: $placement = '<!-- end what\'s going on box -->'; break;
  case 6: $placement = '<!-- end logged-in users -->'; break;
  case 7: $placement = '7'; break;
  default: $placement = '$navbar';
}

// Image display order.
switch ($galleryorderby){
  case 2: $galleryorderby = 'views DESC'; break;
  case 3: $galleryorderby = 'posts DESC'; break;
  case 4:
    $votequery = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
    $galleryorderby = 'voteavg DESC, votenum DESC';
  break;
  case 5: $galleryorderby = 'RAND()'; break;
  default: $galleryorderby = 'dateline DESC';
}

// Get a list of categories to be EXCLUDED from our query
if ($privatecatids = fetch_private_categories())
{
    $privcatids = 'images.catid NOT IN(' . $privatecatids . ') AND ';
}

$ignusers = fetch_ignored_users();

if ($ignusers)
{
	$ignquery = 'AND images.userid NOT IN(' . $ignusers . ')';
}

///////////////////////////
$homeimages_datecut = TIMENOW - (86400*$ppg_options['add_home_cutoff']);

$cellwidth = round(100 / $ppg_options['gallery_columns']) . '%';
$counter = 0;
  $getrand = $db->query_read("
      SELECT $votequery imageid, images.title, images.description, filename, thumbname, originalname, extension, images.catid $query[fields]
      FROM " . TABLE_PREFIX . "ppgal_images AS images
      $query[tables]
      WHERE $privcatids valid = 1 $ignquery
  " . iif(!empty($ppg_options['add_home_cutoff']), "AND dateline >= $homeimages_datecut") . "
  " . iif(!empty($catlimit), "AND images.catid IN ($catlimit)") . "
  " . iif(!empty($notcat), "AND images.catid NOT IN ($notcat)") . "
      ORDER BY $galleryorderby
      LIMIT ".$ppg_options['add_home_limit']."
  ");

  while ($images =  $vbulletin->db->fetch_array($getrand)){
      $counter++;
      $adv_sorturl = '&amp;catid=' . $images['catid'];
      $gal_imagebits .= construct_imagebits($images);
  }

  $gal_imagebits .= construct_empty_cellbits($ppg_options['gallery_columns']);

  $db->free_result($getrand);
  unset($images);

// ### Update the template to have the path qualified ###
	$gal_imagebits = str_replace(array('"showimage.php', '"browseimages.php'), array('"' . $ppg_options['gallery_url'] . '/showimage.php', '"' . $ppg_options['gallery_url'] . '/browseimages.php'), $gal_imagebits);

	if ($placement != 7)
	{ // auto placement by choice

					if ($placement != '<!-- end logged-in users -->')
					{
							$search_text = $placement;
							$vbulletin->templatecache['FORUMHOME'] = str_replace($search_text,
							$search_text.fetch_template('adv_gallery_forumhome'),$vbulletin->templatecache['FORUMHOME']);
					}else{
							$search_text = $placement;
							$vbulletin->templatecache['FORUMHOME'] = str_replace($search_text,
							$search_text.fetch_template('adv_gallery_forumhome_who'),$vbulletin->templatecache['FORUMHOME']);
					}
	}else{
		// Place $vbgallery in FORUMHOME template for custom location
		eval('$vbgallery = "' . fetch_template('adv_gallery_forumhome') . '";');
	}
}
?>