<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('GET_IMGTYPE_ARRAY', true);
define('THIS_SCRIPT', 'displayimage');
define('PP_SCRIPT', 'vBGallery');
// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$specialtemplates = array(
	'gallery_c_cache',
	'adv_gallery_opt',
    'gallery_ugroups'
);

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_config.php');

chdir($forumpath);
require_once('./includes/init.php');
require_once('./includes/functions.php');
require_once('./includes/functions_gallery.php');
require_once('./includes/functions_gallery_imageedit.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$ppg_options =& $vbulletin->adv_gallery_opt;
$categorycache =& $vbulletin->gallery_c_cache;
$gallery_permissions =& $vbulletin->gallery_ugroups;

// permissions check
if (empty($galleryperms))
{
    $bbuserino['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

    if (empty($bbuserinfo['usergrouparray']))
    {
        $bbuserinfo['usergrouparray'] = array(1);
    }
    foreach ($bbuserino['usergrouparray'] AS $usergroupsid)
    {
        if (empty($gallery_permissions["$usergroupsid"]))
        {
            $usergroupid = 1;
        }
        foreach ($gallerypermissionsbit AS $option => $value)
        {
            if (!$galleryperms["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
            {
                $galleryperms["$option"] = 0;
                if ($gallery_permissions["$usergroupsid"]['gallery_perms'] & $value)
                {
                    $galleryperms["$option"] = 1;
                }
            }
        }
    }
}


if ($_REQUEST['original'] AND $galleryperms['canvieworiginal'] AND $galleryperms['canviewgallery'] AND $ppg_options['gallery_active']){

$imageid = intval($_REQUEST['imageid']);
$imageinfo = $db->query_first("
	SELECT imageid, catid, userid, " . iif($_REQUEST['original'], 'originalname AS filename, originalfilesize AS filesize, originalwidth AS width, originalheight AS height', 'filename, filesize, width, height') . ", extension, dateline 
	FROM " . TABLE_PREFIX . "ppgal_images AS images 
	WHERE imageid = '$imageid'
");

$categoryperms = fetch_category_perms($imageinfo['catid']);

$imageinfo['location'] = fetch_folder_path($imageinfo) . '/' . $imageinfo['filename'];


if (!in_array(strtolower($imageinfo['extension']), array_keys($imgtypearray)))
{
if ($fp = @fopen($imageinfo['location'], "rb"))
	{
    header('Expires: ' . gmdate('D, d M Y H:i:s', (TIMENOW + 31536000)) . ' GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		header('Cache-Control: no-cache, must-revalidate');           // HTTP/1.1
		header('Pragma: no-cache');                                   // HTTP/1.0
		header('Content-Disposition: inline; filename=' . $imageinfo['filename']);
		header('Content-transfer-encoding: binary');
		header('Content-length: ' . strlen($imageinfo['filesize']));
		header('Content-type: image/' . $imageinfo['extension']);
		header('Content-Type: application/octet-stream');
		header('Content-Type: application/force-download',  true);
		header('Content-Type: application/download', true);
		fpassthru($fp);
	}
}
else
{
	$extension = ($imageinfo['extension'] == 'jpg') ? 'jpeg' : $imageinfo['extension'];
	//header block
	header('Cache-control: max-age=6000');
	header('Expires: ' . gmdate('D, d M Y H:i:s', (TIMENOW + 60)) . ' GMT');
	header('Content-transfer-encoding: binary');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $imageinfo['dateline']) . ' GMT');
	header('ETag: "' . $imageinfo['dateline'] . '-' . $vbulletin->GPC['userid'] . '"');
	header('Content-type: image/' . $extension);
	//end headers, content-disposition comes later..

	$catoptions = fetch_adv_category_setting($imageinfo['catid']);
	if ($catoptions['gallery_watermark'] AND !$ppg_options['gallery_permwatermark'])
	{
		// watermark function only supports jpg and png.. (we can add gif, but will loose gif animation)
		// check also if function imagecreatefromjpeg is there.. so if we have imagemagic user.. see if he has GD installed..
		if(in_array($extension, array('jpeg','png')) AND function_exists("imagecreatefromjpeg"))
		{
			header("Content-Disposition: inline; filename=wm_"  . iif($_REQUEST['original'], 'original_', 'normal_') .  $imageinfo['filename']);
			watermark_image('normal');
			exit;
		}
	}
	header("Content-Disposition: inline; filename=" . iif($_REQUEST['original'], 'original_', 'normal_') . $imageinfo['filename']);
	readfile($imageinfo['location']);
	exit;
}
}


if (!$_REQUEST['original'] && $galleryperms['canviewlargimage'] && $galleryperms['canviewgallery'] && $ppg_options['gallery_active']){

$imageid = intval($_REQUEST['imageid']);
$imageinfo = $db->query_first("
	SELECT imageid, catid, userid, " . iif($_REQUEST['original'], 'originalname AS filename, originalfilesize AS filesize, originalwidth AS width, originalheight AS height', 'filename, filesize, width, height') . ", extension, dateline
	FROM " . TABLE_PREFIX . "ppgal_images AS images
	WHERE imageid = '$imageid'
");

$categoryperms = fetch_category_perms($imageinfo['catid']);

$imageinfo['location'] = fetch_folder_path($imageinfo) . '/' . $imageinfo['filename'];


if (!in_array(strtolower($imageinfo['extension']), array_keys($imgtypearray)))
{
if ($fp = @fopen($imageinfo['location'], "rb"))
	{
    header('Expires: ' . gmdate('D, d M Y H:i:s', (TIMENOW + 31536000)) . ' GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		header('Cache-Control: no-cache, must-revalidate');           // HTTP/1.1
		header('Pragma: no-cache');                                   // HTTP/1.0
		header('Content-Disposition: inline; filename=' . $imageinfo['filename']);
		header('Content-transfer-encoding: binary');
		header('Content-length: ' . strlen($imageinfo['filesize']));
		header('Content-type: image/' . $imageinfo['extension']);
		header('Content-Type: application/octet-stream');
		header('Content-Type: application/force-download',  true);
		header('Content-Type: application/download', true);
		fpassthru($fp);
	}
}
else
{
	$extension = ($imageinfo['extension'] == 'jpg') ? 'jpeg' : $imageinfo['extension'];
	//header block
	header('Cache-control: max-age=6000');
	header('Expires: ' . gmdate('D, d M Y H:i:s', (TIMENOW + 60)) . ' GMT');
	header('Content-transfer-encoding: binary');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $imageinfo['dateline']) . ' GMT');
	header('ETag: "' . $imageinfo['dateline'] . '-' . $vbulletin->GPC['userid'] . '"');
	header('Content-type: image/' . $extension);
	//end headers, content-disposition comes later..

	$catoptions = fetch_adv_category_setting($imageinfo['catid']);
	if ($catoptions['gallery_watermark'] AND !$ppg_options['gallery_permwatermark'])
	{
		// watermark function only supports jpg and png.. (we can add gif, but will loose gif animation)
		// check also if function imagecreatefromjpeg is there.. so if we have imagemagic user.. see if he has GD installed..
		if(in_array($extension, array('jpeg','png')) AND function_exists("imagecreatefromjpeg"))
		{
			header("Content-Disposition: inline; filename=wm_"  . iif($_REQUEST['original'], 'original_', 'normal_') .  $imageinfo['filename']);
			watermark_image('normal');
			exit;
		}
	}
	header("Content-Disposition: inline; filename=" . iif($_REQUEST['original'], 'original_', 'normal_') . $imageinfo['filename']);
	readfile($imageinfo['location']);
	exit;
}
}
?>