<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'ecard');
define('PP_SCRIPT', 'vBGallery');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'adv_gallery_ecard',
	'posting'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_ECARD_SEND',
	'adv_gallery_ecard_layouts',
	'ADV_GALLERY_ECARD_VIEW',
	'adv_gallery_ecard_confirmcode'
);

// pre-cache templates used by specific actions
$actiontemplates = array();


// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_newpost.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

($hook = vBulletinHook::fetch_hook('ppgal_ecard_start')) ? eval($hook) : false;

if (!$ppg_options['gallery_enableecards'])
{
	print_no_permission();
}

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'viewcard';
}

// ###################### Do Send Card ######################
if ($_POST['do'] == 'sendcard')
{
	$cardinfo = $vbulletin->input->clean_gpc('p', 'cardinfo', TYPE_ARRAY_STR);
	$cardcolors = $vbulletin->input->clean_gpc('p', 'cardcolors', TYPE_ARRAY_STR);
	$post = $vbulletin->input->clean_gpc('p', 'post', TYPE_ARRAY_STR);
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg', TYPE_BOOL);
    $message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
    $ajax = $vbulletin->input->clean_gpc('p', 'message', TYPE_BOOL);

    $image = $db->query_first("
        SELECT catid
        FROM " . TABLE_PREFIX . "ppgal_images
        WHERE imageid = '$imageid'
    ");

	$categoryperms = fetch_category_perms($image['catid']);

	if (!$categoryperms['cansendecard'])
	{
		print_no_permission();
	}

	if ($wysiwyg)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$post['message'] = convert_wysiwyg_html_to_bbcode($message);
	}

	// Normal editor
	else
	{
		$post['message'] = $message;
	}

    if ($ajax)
	{
		// posting via ajax so we need to handle those %u0000 entries
		$post['message'] = convert_urlencoded_unicode($post['message']);
	}

    $cardinfo['title'] = str_replace('&amp;', '&', $cardinfo['title']);
    $post['message'] = fetch_censored_text($post['message']);

	if ($post['parseurl'])
	{
		$post['message'] = convert_url_to_bbcode($post['message']);
	}

	// Check for errors
	$errors = array();

	if (!$cardinfo['username'] AND (!$cardinfo['name'] OR !$cardinfo['email']))
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_ecard_noname') . '";');
  }

	if ($cardinfo['username'])
	{
		$userinfo = $db->query_first("SELECT userid, email, username FROM " . TABLE_PREFIX . "user WHERE username = '$cardinfo[username]'");

		if (!$userinfo['userid'])
		{
			eval('$errors[] = "' . addslashes(fetch_error('listbaduser', htmlspecialchars($cardinfo['username']), $vbulletin->session->vars['sessionurl'])) . '";');
		}

		$sendto = $userinfo['email'];
		$sendname = $userinfo['username'];
	}
	else
	{
		$userinfo['email'] = $cardinfo['email'];
		$userinfo['username'] = $cardinfo['name'];
		$sendname = $cardinfo['name'];
	}

	if (!$vbulletin->userinfo['userid'] AND !$post['username'])
	{
		eval('$errors[] = "' . fetch_error('bademail') . '";');
	}

	// Guest username check
	if (!$vbulletin->userinfo['userid'])
	{
		if (!$post['username'])
		{
			eval('$errors[] = "' . fetch_error('nousername') . '";');
		}
		else if (strlen($post['username']) < $vbulletin->options['minuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametooshort', $vbulletin->options['minuserlength']) . '";');
		}
		else if (strlen($post['username']) > $vbulletin->options['maxuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametoolong', $vbulletin->options['maxuserlength']) . '";');
		}
		else if ($dupecheck = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes(htmlspecialchars($post['username'])) . "'"))
		{
			eval('$errors[] = "' . fetch_error('usernametaken', addslashes(htmlspecialchars($post['username'])), $vbulletin->session->vars['sessionurl']) . '";');
		}
	}

	if ($vbulletin->options['maximages'])
	{
		require_once(DIR . '/includes/class_bbcode_alt.php');
		require_once(DIR . '/includes/functions_misc.php');
		$bbcode_parser =& new vB_BbCodeParser_ImgCheck($vbulletin, fetch_tag_list());

		$imagecount = fetch_character_count($bbcode_parser->parse($post['message'], 'nonforum', $post['enablesmilies'], true), '<img');
		if ($imagecount > $vbulletin->options['maximages'])
		{
			eval('$errors[] = "' . fetch_error('toomanyimages', $imagecount, $vbulletin->options['maximages']) . '";');
		}
	}

	if (!empty($errors))
	{
		construct_checkboxes($_POST);
		$cardpreview = stripslashes(construct_errors($errors));
		$newpost['message'] = htmlspecialchars_uni($post['message']);
		$_REQUEST['do'] = 'send';
	}
	else if ($_POST['preview'])
	{
		$cardinfo['fromuserid'] = $vbulletin->userinfo['userid'];
		$cardinfo['fromemail'] = htmlspecialchars($post['fromemail']);
		$cardinfo['fromusername'] = iif($vbulletin->userinfo['userid'], $vbulletin->userinfo['username'], htmlspecialchars($post['username']));
		$newpost['message'] = htmlspecialchars_uni($post['message']);
		$_REQUEST['do'] = 'send';
	}
	else
	{

		if ($vbulletin->userinfo['userid'] == 0)
		{
			$vbulletin->userinfo['username'] = $post['username'];
			$vbulletin->userinfo['userid'] = 0;
		}

		$gencode = rand(1000000, 9999999);
		$cardcolors = serialize($_POST['cardcolors']);
		$cardinfo['allowsmilies'] = 1;
        if ($cardinfo['disable_smilies'])
        {
            $cardinfo['allowsmilies'] = 0;
        }
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "ppgal_ecards (userid, tousername, imageid, fromuserid, fromusername, fromemail, title, message, dateline, passcode, layout, bgcolors, receipt, showsignature, allowsmilies) VALUES ('$userinfo[userid]', '" . addslashes($userinfo['username']) . "', '$imageid', '" . $vbulletin->userinfo['userid'] . "', '" . addslashes($vbulletin->userinfo['username']) . "', '" . addslashes(htmlspecialchars($post['fromemail'])) . "', '" . addslashes($cardinfo['title']) . "', '" . addslashes($post['message']) . "', '" . time() . "', '" . addslashes(md5($gencode)) . "', '$cardinfo[layout]', '$cardcolors', '$cardinfo[request_receipt]', '$cardinfo[signature]', '" . iif($cardinfo['disablesmilies'], 0, 1) . "')");

		$cardid = $db->insert_id();

		eval(fetch_email_phrases('adv_gallery_ecard'));
		vbmail($userinfo['email'], $subject, $message);

		$vbulletin->url = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid;
		eval(print_standard_redirect('adv_gallery_ecard_sent'));
	}
}

// ###################### Send Card ######################
if ($_REQUEST['do'] == 'send')
{
	$cardinfo = $vbulletin->input->clean_gpc('r', 'cardinfo', TYPE_ARRAY_STR);

  $image = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");

	$categoryperms = fetch_category_perms();

	$catopts = construct_cat_opts($image['catid'], $categorycache["$image[catid]"]['options']);

	if (!$categoryperms["$image[catid]"]['cansendecard'])
	{
		print_no_permission();
	}

	check_image_view($image, 'ecard');

	$layoutchecked["$cardinfo[layout]"] = 'checked="checked"';
	$post['username'] = htmlspecialchars($post['username']);
	$cardinfo['username'] = htmlspecialchars($cardinfo['username']);
	$cardinfo['name'] = htmlspecialchars($cardinfo['name']);

	if (!$ppg_options['gallery_ecardssmilies'])
	{
		$cardinfo['disable_smilies'] = true;
	}

	if ($_POST['preview'] AND empty($errors))
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		$cardinfo['date'] = vbdate($vbulletin->options['dateformat'], time());
		$cardinfo['time'] = vbdate($vbulletin->options['timeformat'], time());
		$cardinfo['message'] = $bbcode_parser->do_parse($post['message'], $ppg_options['gallery_ecardshtml'], iif($cardinfo['disable_smilies'], 0, 1), $ppg_options['gallery_ecardsbbcode'], $ppg_options['gallery_ecardsimgcode']);

		$image['url'] = 	construct_image_url($image);
		eval('$cardpreview = "' . fetch_template('adv_gallery_ecard_layouts') . '";');
	}
	else
	{
		$show['image_preview'] = true;
		$layoutchecked['1'] = 'checked="checked"';
		$image['thumburl'] = 	construct_image_url($image, 'thumbname');
	}

	$bgcolors = array(
		'#000000' => $vbphrase['black'],
		'#A0522D' => $vbphrase['sienna'],
		'#556B2F' => $vbphrase['darkolivegreen'],
		'#006400' => $vbphrase['darkgreen'],
		'#483D8B' => $vbphrase['darkslateblue'],
		'#000080' => $vbphrase['navy'],
		'#4B0082' => $vbphrase['indigo'],
		'#2F4F4F' => $vbphrase['darkslategray'],
		'#8B0000' => $vbphrase['darkred'],
		'#FF8C00' => $vbphrase['darkorange'],
		'#808000' => $vbphrase['olive'],
		'#008000' => $vbphrase['green'],
		'#008080' => $vbphrase['teal'],
		'#0000FF' => $vbphrase['blue'],
		'#708090' => $vbphrase['slategray'],
		'#696969' => $vbphrase['dimgray'],
		'#FF0000' => $vbphrase['red'],
		'#F4A460' => $vbphrase['sandybrown'],
		'#9ACD32' => $vbphrase['yellowgreen'],
		'#2E8B57' => $vbphrase['seagreen'],
		'#48D1CC' => $vbphrase['mediumturquoise'],
		'#4169E1' => $vbphrase['royalblue'],
		'#800080' => $vbphrase['purple'],
		'#808080' => $vbphrase['gray'],
		'#FF00FF' => $vbphrase['magenta'],
		'#FFA500' => $vbphrase['orange'],
		'#FFFF00' => $vbphrase['yellow'],
		'#00FF00' => $vbphrase['lime'],
		'#00FFFF' => $vbphrase['cyan'],
		'#00BFFF' => $vbphrase['deepskyblue'],
		'#9932CC' => $vbphrase['darkorchid'],
		'#C0C0C0' => $vbphrase['silver'],
		'#FFC0CB' => $vbphrase['pink'],
		'#F5DEB3' => $vbphrase['wheat'],
		'#FFFACD' => $vbphrase['lemonchiffon'],
		'#98FB98' => $vbphrase['palegreen'],
		'#AFEEEE' => $vbphrase['paleturquoise'],
		'#ADD8E6' => $vbphrase['lightblue'],
		'#DDA0DD' => $vbphrase['plum'],
		'#FFFFFF' => $vbphrase['white']
	);

	$coloroptions = array(
		'border_color',
		'background_image',
		'background_card',
		'title_text',
		'background_subject'
	);

	function construct_background_colors($selected = '')
	{
		global $bgcolors;

		foreach ($bgcolors AS $value => $color)
		{
			$colorselect .= '<option ' . iif($selected == $value, 'selected="selected"') . ' style="background-color:' . $value . '" value="' . $value . '">' . $color . '</option>';
		}
		return $colorselect;
	}

	foreach ($coloroptions AS $coloropt)
	{
		$colorselect["$coloropt"] = construct_background_colors($cardcolors["$coloropt"]);
	}

	require_once(DIR . '/includes/functions_editor.php');
	
	// Editor & message area
	$vbulletin->options['allowbbcode'] = $ppg_options['gallery_ecardssmilies'];
  $vbulletin->options['allowbbimagecode'] = $ppg_options['gallery_ecardsimgcode'];
  $vbulletin->options['allowsmilies'] = $ppg_options['gallery_ecardsbbcode'];
	
	$editorid = construct_edit_toolbar($newpost['message'], 0, 0, $catopts['allow_post_smilies'],  1, 0);

	$messagearea = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $messagearea);

	$posticons = construct_icons(intval($newpost['iconid']));

	if ($vbulletin->userinfo['userid'] AND !$post['preview'] AND trim($vbulletin->userinfo['signature']))
	{
		$signaturechecked = 'checked';
	}

	$navbits['showimage.php?' . $vbulletin->session->vars['sessionurl'] . "i=$image[imageid]"] = $image['title'];
	$navbits[''] = $vbphrase['send_as_ecard'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

	eval('print_output("' . fetch_template('ADV_GALLERY_ECARD_SEND') . '");');
}

// ############################ View e-Card #############################
if ($_REQUEST['do'] == 'viewcard')
{
	$cardid = $vbulletin->input->clean_gpc('r', 'cardid', TYPE_INT);
	$passcode = $vbulletin->input->clean_gpc('r', 'passcode', TYPE_INT);

  $cardinfo = $db->query_first("
  		SELECT ecards.*, ecards.userid AS touserid, images.title AS imagetitle, images.catid, images.userid, width, height, filename, extension, signature
		FROM " . TABLE_PREFIX . "ppgal_ecards AS ecards
  		LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (ecards.imageid = images.imageid)
  		LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = ecards.fromuserid)
  		WHERE ecards.cardid = '$cardid'
  ");

	if (!$cardinfo['cardid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['ecard'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['contactuslink']  .  $vbulletin->session->vars['sessionurl_q'])));
	}

	if ($ppg_options['gallery_ecardperms'])
	{
		check_image_view($cardinfo, 'ecard');
	}

	if ($cardinfo['passcode'] != md5($passcode) AND !fetch_bbarray_cookie('ecard', $cardinfo['passcode']) AND (!$vbulletin->userinfo['userid'] OR ($vbulletin->userinfo['userid'] != $cardinfo['touserid'] AND $vbulletin->userinfo['userid'] != $cardinfo['fromuserid'])) AND !is_category_mod($image['catid']))
	{
		eval('$cardpreview = "' . fetch_template('adv_gallery_ecard_confirmcode') . '";');
	}
	else
	{
		set_bbarray_cookie('ecard', $cardinfo['passcode'], $cardinfo['cardid'], 1);

		if (!$cardinfo['viewed'] AND $cardinfo['receipt'] AND ($cardinfo['fromuserid'] == 0 OR $cardinfo['fromuserid'] != $vbulletin->userinfo['userid']))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_ecards SET viewed = 1 WHERE cardid = '$cardinfo[cardid]'");
			$mailuser = $db->query_first("SELECT email, username FROM " . TABLE_PREFIX . "user WHERE userid = '$cardinfo[fromuserid]'");

			eval(fetch_email_phrases('adv_gallery_ecard_viewed'));
			vbmail(iif($mailuser['email'], $mailuser['email'], $cardinfo['fromname']), $subject, $message);
		}

		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	  $cardinfo['date'] = vbdate($vbulletin->options['dateformat'], $cardinfo['dateline']);
	  $cardinfo['time'] = vbdate($vbulletin->options['timeformat'], $cardinfo['dateline']);
		$cardinfo['message'] = $bbcode_parser->do_parse($cardinfo['message'], $ppg_options['gallery_ecardshtml'], $cardinfo['allowsmilies'], $ppg_options['gallery_ecardsbbcode'], $ppg_options['gallery_ecardsimgcode']);
		$image['url'] = construct_image_url($cardinfo, 'filename');
		$cardinfo['title'] = stripslashes($cardinfo['title']);
		$cardinfo['fromusername'] = unhtmlspecialchars($cardinfo['fromusername']);
		$cardinfo['fromuserid'] = $cardinfo['fromuserid'];
		$cardinfo['tousername'] = unhtmlspecialchars($cardinfo['tousername']);

		$cardcolors = unserialize($cardinfo['bgcolors']);

		if ($cardinfo['showsignature'] AND $cardinfo['signature'])
		{
			$signature = $bbcode_parser->parse($cardinfo['signature'], 0, $cardinfo['allowsmilie']);
		}

		eval('$cardpreview = "' . fetch_template('adv_gallery_ecard_layouts') . '";');
	}

	$navbits[''] = $vbphrase['view_ecard'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

($hook = vBulletinHook::fetch_hook('ppgal_ecard_complete')) ? eval($hook) : false;

    eval('$navbar = "' . fetch_template('navbar') . '";'); 
	eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');
  eval('print_output("' . fetch_template('ADV_GALLERY_ECARD_VIEW') . '");');
}

?>