<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('PP_SCRIPT', 'vBGallery');
define('VB_AREA', 'vBGallery');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array_merge(array('adv_gallery'), (array)$phrasegroups);

// get special data templates from the datastore
$specialtemplates = array_merge(
	array(
		'gallery_c_cache',
		'gal_mod_cache',
		'adv_gallery_opt',
		'gallery_ugroups',
        'ppg_stats'
	),
	(array)$specialtemplates
);

// pre-cache templates used by all actions
$globaltemplates = array_merge(
	array(
        'adv_gallery_announcement',
        'adv_gallery_navbar',
		'adv_gallery_categoryjump',
		'adv_gallery_footer',
		'adv_gallery_navbar_newestbits'
	),
	(array)$globaltemplates
);

// pre-cache templates used by specific actions
$actiontemplates = array();


// ######################### REQUIRE BACK-END ############################
require_once('./gallery_config.php');

chdir($forumpath);
require_once('./global.php');
require_once(DIR . '/includes/functions_gallery.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


if ($redirect)
{
	header("Location: $redirect");
	exit;
}


// Set Options Array
$ppg_options =& $vbulletin->adv_gallery_opt;

// Set Permissions Array
$gallery_permissions =& $vbulletin->gallery_ugroups;

// Set Stats Array
$totalcache =& $vbulletin->ppg_stats;

// ################################ Gallery Stats ##############################
$total = array();
foreach ($totalcache AS $totals)
{
 $total[] = $totals;
}
$maximages = $total['0']['images'];
$maxviews = $total['0']['views'];
$maxposts = $total['0']['posts'];
$maxfilesize = $total['0']['filesize'];
$maxorigfilesize = $total['0']['origfilesize'];
$maxcategories = $total['1']['categories'];
$maxmembercat = $total['1']['membercat'];
$maxcards = $total['2']['cards'];
unset($total);


// ################################ Replacements ##############################



	$headinclude = str_replace(
		array(
			'"clientscript',
			'url(images/',
			'name="generator" content="',
            '"external.php'
		),
		array(
			'"' . $vbulletin->options['bburl'] . '/clientscript',
			'url(' . $vbulletin->options['bburl'] . '/images/',
			'name="generator" content="PhotoPost vBGallery, ',
            '"' . $vbulletin->options['bburl'] . '/external.php'
		),
		$headinclude
	);

$vbulletin->templatecache['modifypassword'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['modifypassword']);
$vbulletin->templatecache['register'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['register']);
$vbulletin->templatecache['STANDARD_ERROR_LITE'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['STANDARD_ERROR_LITE']);
$vbulletin->templatecache['STANDARD_ERROR_LOGIN'] = str_replace( '"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['STANDARD_ERROR_LOGIN']);


$vbulletin->templatecache['STANDARD_ERROR'] = str_replace(
	array(
		'"login.php',
		'"register.php',
        '"clientscript'
	),
	array(
		'"' . $vbulletin->options['bburl'] . '/login.php',
		'"' . $vbulletin->options['bburl'] . '/register.php',
        '"' . $vbulletin->options['bburl'] . '/clientscript'
	),
	$vbulletin->templatecache['STANDARD_ERROR']
);


// $navbar replacement
$navreplacearray = explode("\r\n", $ppg_options['gallery_navbar_replace']);

// echo $vbulletin->templatecache['navbar'];

$navreplace['find'] = array(
	'"clientscript',
	'\'misc.php',
	'$GLOBALS[\'vbulletin\']->options[\'bbtitle\']',
	'$GLOBALS[\'vbulletin\']->options[\'forumhome\'] . ".php'
);

$navreplace['replace'] = array(
	'"' . $vbulletin->options['bburl'] . '/clientscript',
	'\'' . $vbulletin->options['bburl'] . '/misc.php',
    iif($ppg_options['gallery_navbarhomelink'], '$GLOBALS[\'vbulletin\']->options[\'hometitle\']', '$GLOBALS[\'ppg_options\'][\'gallery_title\']'),
    iif($ppg_options['gallery_navbarhomelink'], '$GLOBALS[\'vbulletin\']->options[\'homeurl\'] . "', '$GLOBALS[\'ppg_options\'][\'gallery_url\'] . "/index.php')
);

$navreplace = construct_replacement_array($navreplacearray, $navreplace);

$vbulletin->templatecache['navbar'] = str_replace($navreplace['find'], $navreplace['replace'], $vbulletin->templatecache['navbar']);
$vbphrase['private_messages_nav'] = str_replace('"private.php', '"' . $vbulletin->options['bburl'] . '/private.php', $vbphrase['private_messages_nav']);

// $footer replacement
$footerreplacearray = explode("\r\n", $ppg_options['gallery_footer_replace']);

$footerreplace['find'] = array(
	'"' . $admincpdir,
	'"' . $modcpdir,
);

$footerreplace['replace'] = array(
	'"' . $vbulletin->options['bburl'] . '/' . $admincpdir,
	'"' . $vbulletin->options['bburl'] . '/' . $modcpdir,
);

$footerreplace = construct_replacement_array($footerreplacearray, $footerreplace);


$vbulletin->templatecache['pm_popup_script'] = str_replace('$pmpopupurl', $vbulletin->options['bburl'] . '/$pmpopupurl', $vbulletin->templatecache['pm_popup_script']);

// Cron replacement
$cronimage = '';
if ($vbulletin->cron <= TIMENOW) {

	$cronimage = '<img src="' . $vbulletin->options['bburl'] . '/cron.php?' . $vbulletin->session->vars['sessionurl'] . '&amp;rand=' . vbrand(1, 1000000) . '" alt="" width="1" height="1" border="0" />';

} else {

	$cronimage = '';

}

eval('$footer = "' . fetch_template('adv_gallery_footer') . '";');
eval('$footer .= "' . fetch_template('footer') . '";');

if ($shownewpm)
{
	eval('$pmscript = "' . fetch_template('pm_popup_script') . '";');
	$footer .= str_replace('"private.php', '"' . $vbulletin->options['bburl'] . '/private.php', $pmscript);
}

// $header replacement
$headerreplacearray = explode("\r\n", $ppg_options['gallery_header_replace']);

$headerreplace['find'] = array();
$headerreplace['replace'] = array();

$headerreplace = construct_replacement_array($headerreplacearray, $headerreplace);

$header = str_replace($headerreplace['find'], $headerreplace['replace'], $header);

$vbulletin->options['useforumjump'] = false;

if (!$ppg_options['gallery_active'])
{
	if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
	{
		$warning = $vbphrase['alert_gallery_turned_off'];
		$header = $warning . $header;
		$footer .= $warning;
	}
	else
	{
		eval(standard_error($ppg_options['gallery_closedmessage']));
	}
}

// ########################## Gallery Permissions #############################
$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

if (empty($vbulletin->userinfo['usergrouparray']))
{
	$vbulletin->userinfo['usergrouparray'] = array(1);
}

foreach ($vbulletin->userinfo['usergrouparray'] AS $usergroupid)
{
	if (empty($gallery_permissions["$usergroupid"]))
	{
		$usergroupid = 1;
	}

	foreach ($gallerypermissionsbit AS $option => $value)
	{
		if (in_array($option, array('moderateimages', 'moderateposts')) AND $galleryperms["$option"] == 0 AND isset($galleryperms["$option"]))
		{
			continue;
		}
		if (!$galleryperms["$option"] OR in_array($option, array('moderateimages', 'moderateposts')))
		{
			$galleryperms["$option"] = 0;
			if ($gallery_permissions["$usergroupid"]['gallery_perms'] & $value)
			{
				$galleryperms["$option"] = 1;
			}
		}
	}

	foreach ($gallery_permissions["$usergroupid"] AS $option => $value)
	{
		if (($option == 'gallery_maxcats' AND !($gallery_permissions["$usergroupid"]['gallery_perms'] & $gallerypermissionsbit['cancreatecategories'])) OR ($option == 'gallery_maxdiskspace' AND !($gallery_permissions["$usergroupid"]['gallery_perms'] & $gallerypermissionsbit['canuploadimages'])))
		{
			continue;
		}
		if (((($value > $galleryperms["$option"] AND $galleryperms["$option"] != '0') OR !$value) AND $option != 'gallery_perms'))
		{
			$galleryperms["$option"] = $value;
		}
	}
}

// Check main permissions
if (!$galleryperms['canviewgallery'])
{
	print_no_permission();
}

// ############################### Common Globals #############################
$imageid = $vbulletin->input->clean_gpc('r', 'imageid', TYPE_INT);
$i = $vbulletin->input->clean_gpc('r', 'i', TYPE_INT);

if (!isset($_POST['catid']))
{
	$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_NOHTML);
	$c = $vbulletin->input->clean_gpc('r', 'c', TYPE_NOHTML);
}

if (isset($i) AND $i != 0)
{
	$imageid = $i;
}
if ($c)
{
	$catid = $c;
}

$categorycache =& $vbulletin->gallery_c_cache;
unset($vbulletin->gallery_c_cache, $galleryoptions, $vbulletin->adv_gallery_opt);

// First element of navbar
if (THIS_SCRIPT != 'gallery_index' AND $ppg_options['gallery_navbarhomelink'])
{
	$navbits["$ppg_options[gallery_url]"] = $ppg_options['gallery_title'];
}

// ########################### Show Variables #################################
if ($ppg_options['gallery_showstats']){
$show['stats'] = true;
}

if ($galleryperms['cansearchimages'])
{
	$show['search'] = true;
}
if ($galleryperms['cansendimagetofriend'])
{
	$show['sendtofriend'] = true;
}
if ($ppg_options['gallery_showmodcolumn'])
{
	$show['modcolumn'] = true;
}
if ($ppg_options['gallery_allowsubscribe'] AND $vbulletin->userinfo['userid'])
{
	$show['subscribe'] = true;
}
if ($ppg_options['gallery_allowfav'] AND $vbulletin->userinfo['userid'])
{
	$show['favorites'] = true;
}
if ($galleryperms['cancreatecategories'])
{
	$show['catmanager'] = true;
}
if ($ppg_options['gallery_showcatdesc'] AND in_array(THIS_SCRIPT, array('showimage', 'browseimages')))
{
	$show['catdesc'] = true;
}

$gallery_modcache =& $vbulletin->gal_mod_cache;

if ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
{
	$show['modoptions'] = true;
}
else if (!empty($gallery_modcache))
{
	foreach ($gallery_modcache AS $moderator)
	{
		if ($moderator['userid'] == $vbulletin->userinfo['userid'])
		{
			$show['modoptions'] = true;
		}
	}
}

if (THIS_SCRIPT == 'gallery_index')
{
	$ppg_options['gallery_imagebitdisplay'] = $ppg_options['gallery_imagebitdisplay_index'];

	if ($ppg_options['gallery_newhomeimages'])
	{
      $newhomepos = $ppg_options['gallery_newhomepos'];
      switch ($newhomepos){
        case 1: $newhomepos = '$pos1';  break;
        case 2: $newhomepos = '$pos2';  break;
        case 3: $newhomepos = '$pos3';  break;
        case 4: $newhomepos = '$pos4';  break;
        case 5: $newhomepos = '$pos5';  break;
        case 6: $newhomepos = '$pos6';  break;
        case 7: $newhomepos = '$pos7';  break;
        case 8: $newhomepos = '$pos8';  break;
        default:
          $newhomepos = '$pos6';
      }
    }

    if ($ppg_options['gallery_randomhomeimages'])
	{
      $ranhomepos = $ppg_options['gallery_randomhomepos'];
      switch ($ranhomepos){
        case 1: $ranhomepos = '$pos1';  break;
        case 2: $ranhomepos = '$pos2';  break;
        case 3: $ranhomepos = '$pos3';  break;
        case 4: $ranhomepos = '$pos4';  break;
        case 5: $ranhomepos = '$pos5';  break;
        case 6: $ranhomepos = '$pos6';  break;
        case 7: $ranhomepos = '$pos7';  break;
        case 8: $ranhomepos = '$pos8';  break;
        default:
          $ranhomepos = '$pos6';
      }
    }
}

if ($ppg_options['gallery_imagebitdisplay'])
{
	$showfield = explode(',', $ppg_options['gallery_imagebitdisplay']);
}

if (!empty($showfield))
{
	$showfields = array();
	foreach ($showfield AS $field)
	{
		$showfields["$field"] = 1;
	}
}


// ######################### Gallery Announcement ##########################
if ($ppg_options['gallery_announcement'])
{

function announcement_gallery($announcement_in)
{
	extract ($GLOBALS);

			while (preg_match("/\[\[(.*)\]\](.*)\[\[(\/\\1)\]\]/siU", $announcement_in, $matches14))
			{
				@eval ('if ('.stripslashes($matches14[1]).') { $eval_deger= "1"; } else { $eval_deger= "0"; }');
				if ($eval_deger == 1)	//if conditional applied
				{

					$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
					$matches14[2] = $parser->do_parse($matches14[2], 1, 1, 1, 1, 1, 1);
					return $matches14[2];
				}
				else //conditional not applied so let's delete it so that it wont be matched in preg_match again..
				{
					$announcement_in = str_replace($matches14[0], '', $announcement_in);
				}
			}

		// no conditional found or applied, so return whatever exists/remains in announcement box
		$matches14[2] = trim($announcement_in);
		if (trim($matches14[2]))
		{
			$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	        $matches14[2] = $parser->do_parse($matches14[2], 1, 1, 1, 1, 1, 1);
		}
		return $matches14[2];
}

	require_once(DIR . '/includes/class_bbcode_alt.php');

			$vboptions      =& $vbulletin->options;
			$technicalemail =& $vbulletin->config['Database']['technicalemail'];
			$bbuserinfo		=& $vbulletin->userinfo;
			$date           = date('l, F jS Y @ h:i:s A');
			$scriptpath     = str_replace('&amp;', '&', $vbulletin->scriptpath);
			$referer        = REFERRER;
			$ipaddress      = IPADDRESS;

  	eval('$announcement_in = "' . addslashes($ppg_options['gallery_announcement']) . '";');

		$announcement_in = str_replace("\\'", "'", $announcement_in);
		$ppgal_announcement = announcement_gallery($announcement_in);

	if (trim($ppgal_announcement))
	{
	eval('$ppgal_announcement = "' . fetch_template('adv_gallery_announcement') . '";');
	}
}

// ######################### Navbar Width ##########################
$lnavrows = 3;
if ($show['favorites'] OR $show['subscribe'] OR $show['catmanager'])
{
	$lnavrows++;
}
if ($ppg_options['gallery_newimagelimit'])
{
	$lnavrows++;
}
if ($ppg_options['gallery_popimagelimit'])
{
	$lnavrows++;
}
if ($show['uploadlink'])
{
	$lnavrows++;
}
if ($show['modoptions'])
{
	$lnavrows++;
}

$navbarwidth = intval(100 / $lnavrows) . '%';

if ($ppg_options['gallery_newimagelimit'])
{
	foreach (explode(',', $ppg_options['gallery_newimagelimit']) AS $ndatecut)
	{
		$show['newimagenav'] = true;
		$dayphrase = construct_phrase($vbphrase['last_x_days'], $ndatecut);
		eval('$newimagenavbits .= "' . fetch_template('adv_gallery_navbar_newestbits') . '";');
		$show['newimagenav'] = false;
		eval('$newpostnavbits .= "' . fetch_template('adv_gallery_navbar_newestbits') . '";');
	}
}


// echoimage.php
if ($ppg_options['gallery_watermark'] AND !$ppg_options['gallery_permwatermark'])
{
	$ppg_options['gallery_echoimage'] = true;
}

// ######################### WOL Bypass ##########################
if (THIS_SCRIPT == 'gallery_index' OR THIS_SCRIPT == 'gallery_search' OR THIS_SCRIPT == 'gallery_misc')
{
$vbulletin->userinfo['badlocation'] = 500;
}

?>