<?php
# Zoints SEO 2.2.2
# Copyright (C) 2006  Zoints Inc
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
# 

 
error_reporting(E_ALL & ~E_NOTICE);

#
# GLOBAL Functions
#

function redirect_301($url)
{
	global $vbulletin;
	
	if (strpos($url, 'http://') === false)
	{
		$url = $vbulletin->options['bburl'] . '/' . $url;
	}

	header("HTTP/1.1 301 Moved Permanently");
	header("Location: $url");
	exit;
}

function zseo_url_thread($info, $page = 1, $extra = '', $pos = '', $archive = false, $redirectcheck = false, $forcenoarchive = false)
{
	global $vbulletin, $show;

	$prefix = '';
	
	if ($show['guest'] AND $vbulletin->options['zointsseo_thread_decay'])
	{
		if ($info['lastpost'] < (TIMENOW - 86400 * $vbulletin->options['zointsseo_thread_decay_days']))
		{
			# thread is decayed
			if ($vbulletin->options['zointsseo_style_decay'] OR $vbulletin->options['zointsseo_archive_sitemap'])
			{
				if (THIS_SCRIPT == 'archive')
				{
					$prefix = $vbulletin->options['bburl'] . '/';
				}
				$archive = false;
			}
			else
			{
				if (THIS_SCRIPT != 'archive')
				{
					$prefix = $vbulletin->options['bburl'] . '/' . iif($vbulletin->options['zointsseo_rewrite_sitemap'], 'sitemap', 'archive') . '/';
				}
				$archive = true;
				if ($forcenoarchive)
				{
					$archive = false;
				}
				
				if (THIS_SCRIPT == 'archive' AND $vbulletin->options['zointsseo_archive_sitemap'])
				{
					$prefix = $vbulletin->options['bburl'] . '/';
					$archive = false;
				}
			}
		}
	}
	
	if (THIS_SCRIPT == 'archive' AND $vbulletin->options['zointsseo_archive_sitemap'] AND !$redirectcheck)
	{
		$prefix = $vbulletin->options['bburl'] . '/';
		$archive = false;
	}


	
	$info['title'] = !empty($info['threadtitle']) ? $info['threadtitle'] : $info['title'];
	$extra = $vbulletin->session->vars['sessionurl'] . $extra;
	
	$file = true;
	if ($archive OR $vbulletin->options['zointsseo_rewrite_urls'] == 2)
	{
		$file = false;
	}
	
	if ($archive)
	{
		$archive_file = iif($vbulletin->options['zointsseo_rewrite_urls'] == 2, '', 'index.php/');
	}

	if ($vbulletin->options['zointsseo_on'] AND $vbulletin->options['zointsseo_rewrite_urls'])
	{
		$suffix = (empty($extra) ? '' : "?$extra") . $pos;
		
		if ($vbulletin->options['zointsseo_rewrite_index'])
		{
			return $prefix . iif($file, 'showthread.php/', $archive_file) . zseo_cleaned_string($info['title']) . '-' . iif(!$file, 't') . "$info[threadid]/index" . iif($page > 1, $page) . ".html$suffix";
		}
		return $prefix . iif($file, 'showthread.php/', $archive_file) . zseo_cleaned_string($info['title']) . '-' . iif(!$file, 't') . "$info[threadid]" . iif($page > 1, "p$page") . ".html$suffix";
	}
	
	if ($archive)
	{
		return $prefix . "t-$info[threadid]" . iif($page > 1, "-p-$page") . '.html' . (empty($extra) ? '' : "&amp;$extra" . $pos);
	}

	return $prefix . "showthread.php?t=$info[threadid]" . iif($page > 1, "&page=$page") . (empty($extra) ? '' : "&amp;$extra" . $pos);
}

function zseo_url_post($info, $page = 1, $extra = '', $pos = '')
{
	global $vbulletin;
	
	$info['title'] = !empty($info['threadtitle']) ? $info['threadtitle'] : $info['title'];
	$extra = $vbulletin->session->vars['sessionurl'] . $extra;
	
	$file = true;
	if ($vbulletin->options['zointsseo_rewrite_urls'] == 2)
	{
		$file = false;
	}
	if ($vbulletin->options['zointsseo_on'] AND $vbulletin->options['zointsseo_rewrite_urls'])
	{
		$suffix = (empty($extra) ? '' : "?$extra") . $pos;
		if ($vbulletin->options['zointsseo_rewrite_index'])
		{
			return iif($file, "showthread.php/") . zseo_cleaned_string($info['title']) . "-p$info[postid]/index" . iif($page > 1, $page) . ".html$suffix";
		}
		return iif($file, "showthread.php/") . zseo_cleaned_string($info['title']) . "-p$info[postid]" . iif($page > 1, "p$page") . ".html$suffix";
	}
	#var_dump($page);
	return "showthread.php?p=$info[postid]" . iif($page > 1, "&page=$page") . (empty($extra) ? '' : "&$extra" . $pos);
}

function zseo_url_forum($info, $page = 1, $extra = '', $pos = '', $archive = false)
{
	global $vbulletin;
	
	$info['title'] = !empty($info['forumtitle']) ? $info['forumtitle'] : $info['title'];
	$extra = $vbulletin->session->vars['sessionurl'] . $extra;
	
	$file = true;
	if ($archive OR $vbulletin->options['zointsseo_rewrite_urls'] == 2)
	{
		$file = false;
	}
	
	if ($vbulletin->options['zointsseo_on'] AND $vbulletin->options['zointsseo_rewrite_urls'])
	{
		$suffix = (empty($extra) ? '' : "?$extra") . $pos;
		if ($vbulletin->options['zointsseo_rewrite_index'])
		{
			return iif($file, 'forumdisplay.php/') . zseo_cleaned_string($info['title']) . "-" . iif(!$file, iif($info['z'],'z','f')) . "$info[forumid]/index" . iif($page > 1, $page) . ".html$suffix";
		}
		return iif($file, 'forumdisplay.php/') . zseo_cleaned_string($info['title']) . "-" . iif(!$file, iif($info['z'],'z','f')) . "$info[forumid]" . iif($page > 1, "p$page") . ".html$suffix";
	}
	if ($archive)
	{
		return iif($info['z'], 'z', 'f') . "-$info[forumid]" . iif($page > 1, "-p-$page") . '.html' . (empty($extra) ? '' : "&amp;$extra" . $pos);
	}
	return "forumdisplay.php?f=$info[forumid]" . iif($page > 1, "&page=$page") . (empty($extra) ? '' : "&$extra") . $pos;
}

function zseo_url_allpage($info, $page = 1)
{
	global $vbulletin;
	
	
	$file = true;

	if ($vbulletin->options['zointsseo_on'] AND $vbulletin->options['zointsseo_rewrite_urls'])
	{
		if ($vbulletin->options['zointsseo_rewrite_index'])
		{
			return iif($file, "forumdisplay.php/") . zseo_cleaned_string($info['title']) . "-all$info[forumid]/index" . iif($page > 1, $page) . ".html";
		}
		return iif($file, "forumdisplay.php/") . zseo_cleaned_string($info['title']) . "-all$info[forumid]" . iif($page > 1, "p$page") . ".html";
	}
	return "forumdisplay.php?f=$info[forumid]&do=allpage" . iif($page > 1, "&page=$page");
}

function zseo_cleaned_string($string)
{
	global $vbulletin;
	
	$bit = iif($vbulletin->options['zointsseo_url_separator'], '_', '-');
	
	$string = strtolower($string);
	$string = unhtmlspecialchars($string);
	
	$string = str_replace("'", '', $string);
	$words = preg_split("#[^a-z0-9]#", $string, -1, PREG_SPLIT_NO_EMPTY);
	
	$words = zseo_strip_stopwords($words, $bit);
	$words = zseo_limit_keywords($words, $bit);
	return implode($bit, $words);
}

function zseo_limit_keywords($words, $bit)
{
	global $vbulletin;
	
	if ($vbulletin->options['zointsseo_url_keyword_limit'] > 0 AND count($words) > $vbulletin->options['zointsseo_url_keyword_limit'])
	{
		return array_slice($words,0,$vbulletin->options['zointsseo_url_keyword_limit']);
	}
	return $words;
}

function zseo_strip_stopwords($words, $bit)
{
	global $vbulletin;
	
	if ($vbulletin->options['zointsseo_strip_stopwords'] AND !empty($vbulletin->options['zointsseo_stopwords']))
	{
		$stopwords = strtolower($vbulletin->options['zointsseo_stopwords']);
		$stopwords = preg_split("#[\s\r\n,]+#", $stopwords, -1, PREG_SPLIT_NO_EMPTY);
		
		foreach ($words as $key => $word)
		{
			if (in_array($word, $stopwords))
			{
				unset($words[$key]);
			}
		}
	}
	
	return $words;
}

function fetch_dynamic_guest_message($forumid, $onlytitle = false)
{
	global $vbulletin;
	
	if ($forumid < 1)
	{
		if ($onlytitle)
		{
			return $vbulletin->options['zointsseo_dynguestmessage_title'];
		}
		return array(
			'title' 	=> $vbulletin->options['zointsseo_dynguestmessage_title'],
			'message' 	=> $vbulletin->options['zointsseo_dynguestmessage_message']
		);
	}
	
	if (!isset($vbulletin->forumcache[$forumid]))
	{
		return fetch_dynamic_guest_message(-1, $onlytitle);
	}
	
	$forum = $vbulletin->forumcache[$forumid];
	
	if ($onlytitle)
	{
		if (!empty($forum['dynguestmsg_title']))
		{
			return $forum['dynguestmsg_title'];
		}
		return fetch_dynamic_guest_message($forum['parentid'], true);
	}
	
	if (empty($forum['dynguestmsg']))
	{
		return fetch_dynamic_guest_message($forum['parentid']);
	}
	
	$message = array(
		'title' => $forum['dynguestmsg_title'],
		'message' => $forum['dynguestmsg']
	);
	
	if (empty($message['title']))
	{
		$message['title'] = fetch_dynamic_guest_message($foruminfo['parentid'], true);
	}
	
	return $message;
}

function fetch_dynamic_permission_message($forumid, $onlytitle = false)
{
	global $vbulletin;
	
	if ($forumid < 1)
	{
		if ($onlytitle)
		{
			return $vbulletin->options['zointsseo_dynpermissionmessage_title'];
		}
		return array(
			'title' 	=> $vbulletin->options['zointsseo_dynpermissionmessage_title'],
			'message' 	=> $vbulletin->options['zointsseo_dynpermissionmessage_message']
		);
	}
	
	if (!isset($vbulletin->forumcache[$forumid]))
	{
		return fetch_dynamic_permission_message(-1, $onlytitle);
	}
	
	$forum = $vbulletin->forumcache[$forumid];
	
	if ($onlytitle)
	{
		if (!empty($forum['permmsg_title']))
		{
			return $forum['permmsg_title'];
		}
		return fetch_dynamic_permission_message($forum['parentid'], true);
	}
	
	if (empty($forum['permmsg']))
	{
		return fetch_dynamic_permission_message($forum['parentid']);
	}
	
	if ($forum['permmsg'] == '-1')
	{
		return fetch_dynamic_guest_message($forum['forumid']);
	}
	
	$message = array(
		'title' => $forum['permmsg_title'],
		'message' => $forum['permmsg']
	);

	if (empty($message['title']))
	{
		$message['title'] = fetch_dynamic_permission_message($foruminfo['parentid'], true);
	}
	
	return $message;
}

function zseo_build_ads()
{
	global $vbulletin;
	
	$ads = array();
	$placements = $vbulletin->db->query_read("
		SELECT zap.*, za.*, zak.rcl is_rcl
		FROM " . TABLE_PREFIX . "zseo_ad_placement zap
		LEFT JOIN " . TABLE_PREFIX . "zseo_ad za ON(za.adid = zap.adid)
		LEFT JOIN " . TABLE_PREFIX . "zseo_ad_key zak ON(zak.ad_key = zap.ad_key)
		WHERE active = 1
		ORDER BY zap.ad_key, zap.adid
	");
	
	while ($placement = $vbulletin->db->fetch_array($placements))
	{
		$ad = array(
			'rcl' 		=> intval($placement['rcl']),
			'ad'		=> $placement['ad'],
			'is_rcl'	=> intval($placement['is_rcl'])
		);
		
		if ($placement['ad_key'] == 't_postx')
		{
			$ad['post'] = intval($placement['post']);
		}
		
		$ads["$placement[ad_key]"][] = $ad;
	}
	
	build_datastore('zseo_ads', serialize($ads));
}
?>