<?php
# Zoints SEO 2.2.2
# Copyright (C) 2006  Zoints Inc
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
# 

error_reporting(E_ALL & ~E_NOTICE);

#
# ARCHIVE Functions
#

function zoints_fetch_iforumcache()
{
	global $vbulletin;
	
	$ifcache = array();
	
	$forums = $vbulletin->db->query_read("
		SELECT forumid, title, link, parentid, displayorder, title_clean, description, description_clean, threadcount,
		(options & " . $vbulletin->bf_misc_forumoptions['cancontainthreads'] . ") AS cancontainthreads
		FROM " . TABLE_PREFIX . "forum AS forum
		WHERE displayorder <> 0 AND
		password = '' AND
		(options & " . $vbulletin->bf_misc_forumoptions['active'] . ")
		ORDER BY displayorder
	");
	$vbulletin->iforumcache = array();
	while ($forum = $vbulletin->db->fetch_array($forums))
	{
		$ifcache[$forum['parentid']][$forum['displayorder']][$forum['forumid']] = $forum;
	}
	unset($forum);
	$vbulletin->db->free_result($forums);

	return $ifcache;
}

function zoints_archive_forum_list($parentid = -1, $indent = '', $index = false, $first = false)
{
	global $vbulletin, $vbphrase;

	$output = '';

	if (empty($vbulletin->iforumcache))
	{
		$vbulletin->iforumcache = zoints_fetch_iforumcache();
	}
	if (is_array($vbulletin->iforumcache["$parentid"]))
	{
		if ($parentid != -1)
		{
			$output .= "$indent<li>\n$indent  <ul>\n";
		}
		else
		{
			$output .= "$indent<ul>\n";
		}
		foreach($vbulletin->iforumcache["$parentid"] AS $temp)
		{
			foreach($temp AS $forumid => $forum)
			{
				($hook = vBulletinHook::fetch_hook('archive_forum')) ? eval($hook) : false;
				
				if (!($vbulletin->userinfo['forumpermissions']["$forumid"] & $vbulletin->bf_ugp_forumpermissions['canview']) AND !$vbulletin->options['showprivateforums'])
				{
					continue;
				}
				else if ($index AND $vbulletin->options['zointsseo_archive_navigation'])
				{
					if ($forum['link'] === '' AND !$forum['cancontainthreads'])
					{
						#$forum['z'] = true;
						$forum['link'] = zseo_url_forum($forum, 1, '', '', true);
						$output .= "$indent  <li><a href=\"$forum[link]\">$forum[title_clean]</a></li>\n";
					}
					$output .= zoints_archive_forum_list($forumid, "$indent  ", true, false);
				}
				else
				{
					if ($forum['link'] !== '')
					{
						$output .= "$indent  <li><a href=\"$forum[link]\">$forum[title_clean]</a></li>\n";
					}
					else if ($vbulletin->options['zointsseo_archive_navigation'])
					{
						$forumpages = ceil($forum['threadcount'] / $vbulletin->options['archive_threadsperpage']);
						$pages = ceil($forumpages / $vbulletin->options['zointsseo_archive_pages_per_page']);
						$forum['z'] = true;
						if (!$pages)
						{
							$output .= "$indent  <li><a href=\"" . zseo_url_forum($forum, 1, '', '', true) . "\">$forum[title_clean] " . construct_phrase($vbphrase['page_x'], 1) . "</a></li>\n";
						}
						else
						{
							for ($i = 1; $i <= $pages; $i++)
							{
								if ($vbulletin->options['zointsseo_on'] AND $vbulletin->options['zointsseo_rewrite_urls'])
								{
									$forumlink = zseo_url_forum($forum, $i, '', '', true);
								}
								else
								{
									$forumlink = (!SLASH_METHOD ? 'index.php?' : '') . "z-$forumid" . iif($i > 1, "-p-$i") . ".html";
								}
								$output .= "$indent  <li><a href=\"" . $forumlink . "\">$forum[title_clean] " . construct_phrase($vbphrase['page_x'], $i) . "</a></li>\n";
							}
						}
					}
					else if ($forum['cancontainthreads'])
					{
						if ($vbulletin->options['zointsseo_on'] AND $vbulletin->options['zointsseo_rewrite_urls'])
						{
							$forumlink = zseo_url_forum($forum, 1, '', '', true);
						}
						else
						{
							$forumlink = (!SLASH_METHOD ? 'index.php?' : '') . "f-$forumid.html";
						}
						$output .= "$indent  <li><a href=\"" . $forumlink . "\">$forum[title_clean]</a></li>\n";
					}
					else
					{
						$output .= "$indent  <li><strong>$forum[title_clean]</strong></li>\n";
					}
					$output .= zoints_archive_forum_list($forumid, "$indent  ");
				}
			}
		}
		if ($parentid != -1)
		{
			$output .= "$indent  </ul>\n$indent</li>\n";
		}
		else
		{
			$output .= "$indent</ul>\n";
		}
	}

	return $output;
}

function zoints_archive_navigation($foruminfo, $threadinfo = false, $zointspage = 0)
{
	global $vbulletin, $vbphrase, $pda;

	$navarray = array('<a href="./">' . $vbulletin->options['bbtitle'] . '</a>');

	if ($foruminfo['forumid'])
	{
		$parentlist = explode(',', $foruminfo['parentlist']);
		$parentlist = array_reverse($parentlist);
		unset($parentlist[0]);
		
		foreach ($parentlist AS $forumid)
		{
			$forum = $vbulletin->forumcache[$forumid];
			if ($zointspage > 0 AND $forumid == $foruminfo['forumid'])
			{
				$forum['z'] = true;
				$page = iif($zointspage > 1, " " . construct_phrase($vbphrase['page_x'], $zointspage));
				$navarray[] = "<a href=\"" . zseo_url_forum($forum, $zointspage, '', '', true) . "\">" . $forum['title_clean'] . "$page</a>";
			}
			if ($threadinfo === false AND $forumid == $foruminfo['forumid'])
			{
				$navarray[] = $forum['title_clean'];
			}
			else
			{
				if ($forum['z'])
				{
					unset($forum['z']);
				}
				$page = ($foruminfo['forumid'] == $forumid AND $foruminfo['currentpage'] > 1) ? $foruminfo['currentpage'] : 1;
				$navarray[] = "<a href=\"" . zseo_url_forum($forum, $page, '', '', true) . "\">" . $forum['title_clean'] . "</a>";
			}
		}
		
		if (is_array($threadinfo))
		{
			$navarray[] = $threadinfo['title'];
		}
	}

	if ($pda)
	{
		if ($vbulletin->userinfo['userid'] == 0)
		{
			$loginlink = iif(SLASH_METHOD, '?login=1', 'index.php?login=1');
			$extra = '<div class="pda"><a href="' . $loginlink . '" rel="nofollow">' . $vbphrase['log_in'] . "</a></div>\n";
		}
	}
	else
	{
		$pdalink = iif(SLASH_METHOD, '?pda=1', 'index.php?pda=1');
		$extra = '<div class="pda"><a href="' . $pdalink . '" rel="nofollow">' . $vbphrase['pda'] . "</a></div>\n";
	}

	$return = zseo_archive_ad('g_nav1');
	$return .= '<div id="navbar">' . implode(' &gt; ', $navarray) . "</div>\n<hr />\n" . $extra;
	$return .= zseo_archive_ad('g_nav2');
	($hook = vBulletinHook::fetch_hook('archive_navigation')) ? eval($hook) : false;
	return $return;
}

function zoints_archive_page_navigation($total, $perpage, $info, $thread = false)
{
	global $p, $vbphrase;

	$output = '';
	$numpages = ceil($total / $perpage);

	if ($numpages > 1)
	{
		$output .= "<div id=\"pagenumbers\"><b>$vbphrase[pages] :</b>\n";

		for ($i = 1; $i <= $numpages; $i++)
		{
			if ($i == $p)
			{
				$output .= "[<b>$i</b>]\n";
			}
			else
			{
				$type = 'zseo_url_' . ($thread ? 'thread' : 'forum');
				$output .= "<a href=\"" . $type($info, $i, '', '', true) . "\">$i</a>\n";
			}
		}

		$output .= "</div>\n<hr />\n";
	}

	return $output;
}

function zoints_improved_archive_page_navigation($start, $end, $page, $numpages, $info)
{
	global $vbulletin, $vbphrase;
	
	$output = "<div id=\"pagenumbers\"><b>$vbphrase[pages] :</b>\n";

	for ($i = $start; $i <= $end AND $i <= $numpages; $i++)
	{
		if ($i == $page)
		{
			$output .= "[<b>$i</b>]\n";
		}
		else
		{
			$output .= "<a href=\"" . zseo_url_forum($info, $i, '', '', true) . "\">$i</a>\n";
		}
	}
	
	$output .= "</div>\n<hr />\n";
	return $output;
}

function zseo_archive_ad($key, $post = 0)
{
	global $vbulletin, $zointsads, $foruminfo, $threadinfo;
	
	if (isset($vbulletin->zseo_ads))
	{
		if (!is_array($vbulletin->zseo_ads))
		{
			$vbulletin->zseo_ads = unserialize($vbulletin->zseo_ads);
		}
	}
	else
	{
		$datastore = $vbulletin->db->query_first("SELECT data FROM " . TABLE_PREFIX . "datastore WHERE title = 'zseo_ads'");
		$vbulletin->zseo_ads = unserialize($datastore['data']);
		unset($datastore);
	}
	
	$output = '';
	if (isset($vbulletin->zseo_ads[$key]) AND count($vbulletin->zseo_ads[$key]))
	{
		foreach ($vbulletin->zseo_ads[$key] as $ad)
		{
			if ($ad['post'] > 0 AND $ad['post'] != $post)
			{
				continue;
			}
			
			if (!$ad['is_rcl'])
			{
				$valign = iif($ad['rcl'], iif($ad['rcl'] == 1, 'middle', 'bottom'), 'top');
				$output .= "<td valign=\"$valign\">";
			}
			else
			{
				$style = "text-align: " . iif($ad['rcl'], iif($ad['rcl'] == 1, 'center', 'right'), 'left');
				$output .= "<div style=\"$style\">";
			}
			
			eval('$output .= "' . str_replace('"', '\"', $ad['ad']) . '";');
			
			if (!$ad['is_rcl'])
			{
				$output .= "</td>";
			}
			else
			{
				$output .= "</div>";
			}
		}
	}
	return $output;
}
?>