<?php
# Zoints SEO 2.2.2
# Copyright 2006, Zoints Inc.
#
# This code may not be redistributed without prior written consent.
#
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array('dynamicguestmsg');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

$vbulletin->input->clean_array_gpc('r', array(
	'forumid' => TYPE_UINT
));

if ($vbulletin->GPC['forumid'])
{
	$foruminfo = fetch_foruminfo($vbulletin->GPC['forumid']);
	
	if (!$foruminfo)
	{
		print_stop_message('invalid_forum_specified');
	}
}

// ############################# LOG ACTION ###############################
log_admin_action(iif($vbulletin->GPC['forumid'] != 0, "forum id = " . $vbulletin->GPC['forumid']));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['zseo']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'keyview';
}

// ########################################################################
// ############################ ARCHIVE ADS ###############################
// ########################################################################

if ($_REQUEST['do'] == 'adview')
{
	$ads = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "zseo_ad ORDER BY adid");
	
	$placements = array();
	$placements_q = $db->query_read("SELECT adid, COUNT(*) count FROM " . TABLE_PREFIX . "zseo_ad_placement GROUP BY adid");
	while ($placement = $db->fetch_array($placements_q))
	{
		$placements["$placement[adid]"] = $placement['count'];
	}
	
	print_form_header('zseo', '');
	print_table_header($vbphrase['zseo_archive_ad_manager'], 4);
	print_cells_row(array($vbphrase['zseo_ad_title'], $vbphrase['zseo_ad_placements'], $vbphrase['edit'], $vbphrase['delete']), 1);
	while ($ad = $db->fetch_array($ads))
	{
		$cells = array();
		$cells[] = "<a href=\"zseo.php?do=admodify&amp;adid=$ad[adid]\">$ad[title]</a>";
		$cells[] = intval($placements["$ad[adid]"]);
		$cells[] = construct_link_code($vbphrase['edit'], 'zseo.php?do=admodify&amp;adid=' . $ad['adid']);
		$cells[] = construct_link_code($vbphrase['delete'], 'zseo.php?do=addelete&amp;adid=' . $ad['adid']);
		print_cells_row($cells);
	}
	print_table_footer();
	
	echo '<div align="center">' . construct_link_code($vbphrase['zseo_add_ad'], 'zseo.php?do=admodify') . '</div>';
}

if ($_REQUEST['do'] == 'admodify')
{
	$adkeys = array();
	$adkeys_q = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "zseo_ad_key ORDER BY displayorder");
	while ($adkey = $db->fetch_array($adkeys_q))
	{
		$adkeys["$adkey[ad_key]"] = $adkey;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'adid' => TYPE_UINT
	));

	$ad = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "zseo_ad WHERE adid = " . $vbulletin->GPC['adid']);
	if ($ad['adid'])
	{
		$placement = array();
		$placements = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "zseo_ad_placement WHERE adid = $ad[adid]");
		while ($p = $db->fetch_array($placements))
		{
			$placement["$p[ad_key]"] = $p;
		}
	}

	print_form_header('zseo', 'adupdate');
	construct_hidden_code('adid', $vbulletin->GPC['adid']);
	print_table_header($ad['adid'] ? $vbphrase['zseo_edit_ad'] : $vbphrase['zseo_ad_add']);
	print_input_row($vbphrase['title'], 'title', $ad['title'], 1, 60);
	print_textarea_row($vbphrase['zseo_ad_code'], 'ad', $ad['ad']);
	print_table_footer(2, '', '', false);
	
	
	?>
<script type="text/javascript" language="javascript">
<!--
function zseo_form_en(disabled, adkey)
{
	disabled = !disabled;
	document.cpform["placement[" + adkey + "][rcl]"].disabled = disabled;
	if (adkey == 't_postx')
	{
		document.cpform["placement[" + adkey + "][post]"].disabled = disabled;
	}
}
-->
</script>
<?php
	print_table_start();
	print_table_header($vbphrase['zseo_ad_placements'] . ' ' . $vbphrase['zseo_placements_explain'],3);
	print_column_style_code(array('','width: 80%','width: 20%;'));
	$g = '';
	
	foreach ($adkeys as $adkey => $key)
	{
		$disabled = '';
		$checked = '';
		if (!isset($placement[$adkey]) OR !$placement[$adkey]['active'])
		{
			$disabled = 'disabled="disabled"';
		}
		else
		{
			$checked = 'checked="checked"';
		}
	
	
		if ($g != substr($adkey, 0, 1))
		{
			$g = substr($adkey, 0, 1);
			print_cells_row(array('', $vbphrase["zseo_ad_$g"], $vbphrase['zseo_alignment']), 0, 'thead');
		}
		$cells = array();
		$cells[] = "<input type=\"checkbox\" name=\"placement[$adkey][active]\" value=\"1\" " . iif(true, '') . "\" $checked onclick=\"zseo_form_en(this.checked,'$adkey')\" />";
		$cells[] = $vbphrase["zseo_ad_$adkey"];
		
		if ($adkey == 't_postx')
		{
			$val = $placement[$adkey]['post'];
			if (!$val)
			{
				$val = 1;
			}
			$cell = array_pop($cells);
			$cell = str_replace('#', "#<input type=\"text\" name=\"placement[$adkey][post]\" size=\"2\" value=\"$val\" class=\"bginput\" style=\"height: 1.5em;\" $disabled />", $cell);
			array_push($cells, $cell);
		}
		
		if ($key['rcl'])
		{
			$cells[] = "<select name=\"placement[$adkey][rcl]\" class=\"bginput\" $disabled>" . construct_select_options(array(
				0 => $vbphrase['zseo_left'],
				1 => $vbphrase['zseo_center'],
				2 => $vbphrase['zseo_right']
			), $placement[$adkey]['rcl']) . "</select>";
		}
		else# if ($adkey == 'i_right')
		{
			$cells[] = "<select name=\"placement[$adkey][rcl]\" class=\"bginput\" $disabled>" . construct_select_options(array(
				0 => $vbphrase['zseo_top'],
				1 => $vbphrase['zseo_middle'],
				2 => $vbphrase['zseo_bottom']
			), $placement[$adkey]['rcl']) . "</select>";
		}
/*		else
		{
			$cells[] = $vbphrase['n_a'];
		}*/
		
		print_cells_row($cells);
	}
	print_table_footer(2, '', '', false);
	
	print_table_start();
	print_submit_row();
	
	if ($ad['adid'])
	{
		echo '<div align="center">' . construct_link_code($vbphrase['zseo_add_ad'], 'zseo.php?do=admodify') . '</div>';
	}
}

if ($_REQUEST['do'] == 'adupdate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'adid' 		=> TYPE_UINT,
		'title'		=> TYPE_STR,
		'ad'		=> TYPE_STR,
		'placement' => TYPE_ARRAY
	));
	
	if (empty($vbulletin->GPC['title']) OR empty($vbulletin->GPC['ad']))
	{
		print_stop_message('zseo_please_enter_title_and_ad');
	}
	
	if (!$vbulletin->GPC['adid'])
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "zseo_ad
				(title, ad)
			VALUES (
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($vbulletin->GPC['ad']) . "'
		)");
		
		$ad = array(
			'adid'	=> $db->insert_id(),
			'title' => $vbulletin->GPC['title'],
			'ad'	=> $vbulletin->GPC['ad']
		);
	}
	else
	{
		$ad = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "zseo_ad WHERE adid = " . $vbulletin->GPC['adid']);
		if (!$ad)
		{
			print_stop_message('zseo_ad_not_found');
		}
		if ($ad['title'] != $vbulletin->GPC['title'] OR $ad['ad'] != $vbulletin->GPC['ad'])
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "zseo_ad SET
					title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
					ad = '" . $db->escape_string($vbulletin->GPC['ad']) . "'
				WHERE adid = $ad[adid]
			");
		}
	}
	
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "zseo_ad_placement WHERE adid = $ad[adid]");
	
	$placements = array();
	foreach ($vbulletin->GPC['placement'] as $adkey => $placement)
	{
		$placements[] = "(
			'" . $db->escape_string($adkey) . "',
			$ad[adid],
			" . intval($placement['rcl']) . ",
			" . intval($placement['active']) . ",
			" . intval($placement['post']) . "
		)";
	}
	
	if (count($placements))
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "zseo_ad_placement
				(ad_key, adid, rcl, active, post)
			VALUES 
				" . implode(',', $placements)
		);
	}
	
	zseo_build_ads();
	
	if ($vbulletin->GPC['adid'])
	{
		print_cp_redirect('zseo.php?do=admodify&adid=' . $ad['adid']);
	}
	else
	{
		print_cp_redirect('zseo.php?do=adview');
	}
}

if ($_REQUEST['do'] == 'addelete')
{
	$vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	
	$ad = $db->query_first("SELECT adid, title FROM " . TABLE_PREFIX . "zseo_ad WHERE adid = " . $vbulletin->GPC['adid']);
	if (!$ad)
	{
		print_stop_message('zseo_ad_not_found');
	}
	
	$vbulletin->input->clean_gpc('p', 'confirmation', TYPE_UINT);
	if (!$vbulletin->GPC['confirmation'])
	{
		print_form_header('zseo', 'addelete');
		construct_hidden_code('adid', $ad['adid']);
		construct_hidden_code('confirmation', 1);
		print_table_header($vbphrase['zseo_delete_confirmation']);
		print_description_row(construct_phrase($vbphrase['zseo_are_you_sure_you_want_to_delete_ad_x'], $ad['title']));
		print_submit_row($vbphrase['yes'], false, 2, $vbphrase['no']);
	}
	else
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "zseo_ad WHERE adid = $ad[adid]");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "zseo_ad_placement WHERE adid = $ad[adid]");
		zseo_build_ads();
		print_cp_redirect('zseo.php?do=adview');
	}
}

// ########################################################################
// ################### DYNAMIC PERMISSION MESSAGES ########################
// ########################################################################

if ($_REQUEST['do'] == 'permview')
{
	print_form_header('zseo', 'permedit');
	print_table_header($vbphrase['zseo_dynamic_permissions_messages']);
	
	if (!$vbulletin->options['zointsseo_dynpermissionmessage'])
	{
		print_label_row($vbphrase['zseo_warning'], $vbphrase['zseo_dynpermissionmessage_off']);
		print_checkbox_row('', 'turnon', false, 1, $vbphrase['zseo_turn_on_dynpermissionmessage']);
	}
	
	print_description_row($vbphrase['default'], false, 2, 'thead');
	print_input_row($vbphrase['title'], 'default_title', $vbulletin->options['zointsseo_dynpermissionmessage_title'], true, 75, 150);
	print_textarea_row($vbphrase['message'], 'default_message', $vbulletin->options['zointsseo_dynpermissionmessage_message']);
	
	foreach ($vbulletin->forumcache as $forumid => $forum)
	{
		if (!empty($forum['permmsg']) OR !empty($forum['ermmsg_title']))
		{
			print_description_row($forum['title'] . ' ' . construct_link_code($vbphrase['delete'], 'zseo.php?do=permdelete&amp;forumid=' . $forum['forumid']), false, 2, 'thead');
			if ($forum['permmsg'] == -1)
			{
				$message = fetch_dynamic_guest_message($foruminfo['forumid']);
				print_description_row($vbphrase['zseo_inheriting_permmsg_from_dynguestmessage']);
				print_label_row($vbphrase['title'], htmlspecialchars($message['title']));
				print_label_row($vbphrase['message'], htmlspecialchars($message['message']));
			}
			else
			{
				print_label_row($vbphrase['title'], "<input type=\"text\" class=\"bginput\" tabindex=\"1\" name=\"message[$forumid][title]\" value=\"" . htmlspecialchars($forum['permmsg_title']) . "\" size=\"75\" maxlength=\"150\"> " . $vbphrase['zseo_leave_blank_for_default']);
				print_textarea_row($vbphrase['message'], "message[$forumid][message]", $forum['permmsg']);
			}
		}
	}
	print_submit_row();


	print_form_header('zseo', 'permadd');
	print_table_header($vbphrase['add']);
	print_forum_chooser($vbphrase['forum'], 'forumid');
	print_checkbox_row($vbphrase['zseo_inherit_from_dynamic_guest_message'], 'inherit', 0);
	print_description_row($vbphrase['zseo_ucor']);
	print_label_row($vbphrase['title'], "<input type=\"text\" class=\"bginput\" tabindex=\"1\" name=\"title\" value=\"\" size=\"75\" maxlength=\"150\"> " . $vbphrase['zseo_leave_blank_for_default']);
	print_textarea_row($vbphrase['body'], 'message');
	print_submit_row($vbphrase['add']);
	print_table_footer();
}

if ($_POST['do'] == 'permedit')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'turnon' => TYPE_BOOL,
		'default_title' => TYPE_STR,
		'default_message' => TYPE_STR,
		'message' => TYPE_ARRAY
	));
	
	$options = false;
	if ($vbulletin->GPC['turnon'] AND !$vbulletin->options['zointsseo_dynpermissionmessage'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '1'
			WHERE varname = 'zointsseo_dynpermissionmessage'
		");
		$options = true;
	}
	
	if ($vbulletin->options['zointsseo_dynpermissionmessage_title'] != $vbulletin->GPC['default_title'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '" . $db->escape_string($vbulletin->GPC['default_title']) . "'
			WHERE varname = 'zointsseo_dynpermissionmessage_title'
		");
		$options = true;
	}
	
	if ($vbulletin->options['zointsseo_dynpermissionmessage_message'] != $vbulletin->GPC['default_message'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET
				value = '" . $db->escape_string($vbulletin->GPC['default_message']) . "'
			WHERE varname = 'zointsseo_dynpermissionmessage_message'
		");
		$options = true;
	}
	
	if ($options)
	{
		build_options();
	}
	
	if (is_array($vbulletin->GPC['message']) AND count($vbulletin->GPC['message']))
	{
		foreach ($vbulletin->GPC['message'] as $forumid => $message)
		{
			if (isset($vbulletin->forumcache[$forumid]))
			{
				if (empty($message['message']))
				{
					$forum = $vbulletin->forumcache[$forumid];
					$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
					$fdm->set_existing($forum);
					$fdm->set('permmsg_title', '');
					$fdm->set('permmsg', '');
					$fdm->save();
				}
				else
				{
					$forum = $vbulletin->forumcache[$forumid];
					$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
					$fdm->set_existing($forum);
					$save = false;
					
					if ($forum['permmsg_title'] != $message['title'])
					{
						$fdm->set('permmsg_title', $message['title']);
						$save = true;
					}
					
					if ($forum['permmsg'] != $message['message'])
					{
						$fdm->set('permmsg', $message['message']);
						$save = true;
					}
					
					if ($save === true)
					{
						$fdm->save();
					}
					unset($fdm, $forum);
				}
			}
		}
	}
	print_cp_redirect('zseo.php?do=permview');
}

if ($_POST['do'] == 'permadd')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'inherit'	=> TYPE_BOOL,
		'title' 	=> TYPE_STR,
		'message' 	=> TYPE_STR
	));
	
	if (empty($vbulletin->GPC['message']) AND !$vbulletin->GPC['inherit'])
	{
		print_stop_message('zseo_please_enter_message');
	}
	
	if ($vbulletin->GPC['inherit'])
	{
		$vbulletin->GPC['title'] = '';
		$vbulletin->GPC['message'] = '-1';
	}
	
	$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
	$fdm->set_existing($foruminfo);
	$fdm->set('permmsg_title', $vbulletin->GPC['title']);
	$fdm->set('permmsg', $vbulletin->GPC['message']);
	$fdm->save();
	
	print_cp_redirect('zseo.php?do=permview');
}

if ($_REQUEST['do'] == 'permdelete')
{
	$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
	$fdm->set_existing($foruminfo);
	$fdm->set('permmsg_title', '');
	$fdm->set('permmsg', '');
	$fdm->save();
	
	print_cp_redirect('zseo.php?do=permview');
}


// ########################################################################
// ##################### DYNAMIC GUEST MESSAGES ###########################
// ########################################################################

if ($_REQUEST['do'] == 'dynview')
{
	print_form_header('zseo', 'dynedit');
	print_table_header($vbphrase['zseo_dynamic_guest_messages']);
	
	if (!$vbulletin->options['zointsseo_dynguestmessage'])
	{
		print_label_row($vbphrase['zseo_warning'], $vbphrase['zseo_zointsseo_dynguestmessage_off']);
		print_checkbox_row('', 'turnon', false, 1, $vbphrase['zseo_turn_on_zointsseo_dynguestmessage']);
	}
	
	print_description_row($vbphrase['default'], false, 2, 'thead');
	#zointsseo_dynguestmessage_title
	print_input_row($vbphrase['title'], 'default_title', $vbulletin->options['zointsseo_dynguestmessage_title'], true, 75, 150);
	print_textarea_row($vbphrase['message'], 'default_message', $vbulletin->options['zointsseo_dynguestmessage_message']);
	
	foreach ($vbulletin->forumcache as $forumid => $forum)
	{
		if (!empty($forum['dynguestmsg']) OR !empty($forum['dynguestmsg_title']))
		{
			print_description_row($forum['title'] . ' ' . construct_link_code($vbphrase['delete'], 'zseo.php?do=dyndelete&amp;forumid=' . $forum['forumid']), false, 2, 'thead');
			print_label_row($vbphrase['title'], "<input type=\"text\" class=\"bginput\" tabindex=\"1\" name=\"message[$forumid][title]\" value=\"" . htmlspecialchars($forum['dynguestmsg_title']) . "\" size=\"75\" maxlength=\"150\"> " . $vbphrase['zseo_leave_blank_for_default']);
			print_textarea_row($vbphrase['message'], "message[$forumid][message]", $forum['dynguestmsg']);
			#print_textarea_row($vphrase['message']);
		}
	}
	print_submit_row();


	print_form_header('zseo', 'dynadd');
	print_table_header($vbphrase['add']);
	print_forum_chooser($vbphrase['forum'], 'forumid');
	print_label_row($vbphrase['title'], "<input type=\"text\" class=\"bginput\" tabindex=\"1\" name=\"title\" value=\"\" size=\"75\" maxlength=\"150\"> " . $vbphrase['zseo_leave_blank_for_default']);
	print_textarea_row($vbphrase['body'], 'message');
	print_submit_row($vbphrase['add']);
	print_table_footer();
}

if ($_POST['do'] == 'dynedit')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'turnon' => TYPE_BOOL,
		'default_title' => TYPE_STR,
		'default_message' => TYPE_STR,
		'message' => TYPE_ARRAY
	));
	
	$options = false;
	if ($vbulletin->GPC['turnon'] AND !$vbulletin->options['zointsseo_dynguestmessage'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '1'
			WHERE varname = 'zointsseo_dynguestmessage'
		");
		$options = true;
	}
	
	if ($vbulletin->options['zointsseo_dynguestmessage_title'] != $vbulletin->GPC['default_title'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '" . $db->escape_string($vbulletin->GPC['default_title']) . "'
			WHERE varname = 'zointsseo_dynguestmessage_title'
		");
		$options = true;
	}
	
	if ($vbulletin->options['zointsseo_dynguestmessage_message'] != $vbulletin->GPC['default_message'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET
				value = '" . $db->escape_string($vbulletin->GPC['default_message']) . "'
			WHERE varname = 'zointsseo_dynguestmessage_message'
		");
		$options = true;
	}
	
	if ($options)
	{
		build_options();
	}
	
	if (is_array($vbulletin->GPC['message']) AND count($vbulletin->GPC['message']))
	{
		foreach ($vbulletin->GPC['message'] as $forumid => $message)
		{
			if (isset($vbulletin->forumcache[$forumid]))
			{
				if (empty($message['message']))
				{
					$forum = $vbulletin->forumcache[$forumid];
					$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
					$fdm->set_existing($forum);
					$fdm->set('dynguestmsg_title', '');
					$fdm->set('dynguestmsg', '');
					$fdm->save();
				}
				else
				{
					$forum = $vbulletin->forumcache[$forumid];
					$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
					$fdm->set_existing($forum);
					$save = false;
					
					if ($forum['dynguestmsg_title'] != $message['title'])
					{
						$fdm->set('dynguestmsg_title', $message['title']);
						$save = true;
					}
					
					if ($forum['dynguestmsg'] != $message['message'])
					{
						$fdm->set('dynguestmsg', $message['message']);
						$save = true;
					}
					
					if ($save === true)
					{
						$fdm->save();
					}
					unset($fdm, $forum);
				}
			}
		}
	}
	print_cp_redirect('zseo.php?do=dynview');
}

if ($_POST['do'] == 'dynadd')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'title' 	=> TYPE_STR,
		'message' 	=> TYPE_STR
	));
	
	if (empty($vbulletin->GPC['message']))
	{
		print_stop_message('zseo_please_enter_message');
	}
	
	$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
	$fdm->set_existing($foruminfo);
	$fdm->set('dynguestmsg_title', $vbulletin->GPC['title']);
	$fdm->set('dynguestmsg', $vbulletin->GPC['message']);
	$fdm->save();
	
	print_cp_redirect('zseo.php?do=dynview');
}

if ($_REQUEST['do'] == 'dyndelete')
{
	$fdm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
	$fdm->set_existing($foruminfo);
	$fdm->set('dynguestmsg_title', '');
	$fdm->set('dynguestmsg', '');
	$fdm->save();
	
	print_cp_redirect('zseo.php?do=dynview');
}

// ########################################################################
// ########################## META KEYWORDS ###############################
// ########################################################################

if ($_REQUEST['do'] == 'keyview')
{
	print_form_header('zseo', 'keyedit');
	print_table_header($vbphrase['zseo_meta_keywords']);
	print_description_row($vbphrase['zseo_meta_keywords_description']);
	
	if (!$vbulletin->options['zointsseo_meta_keywords'])
	{
		print_label_row($vbphrase['zseo_warning'], $vbphrase['zseo_meta_keywords_off']);
		print_checkbox_row('', 'turnon', false, 1, $vbphrase['zseo_turn_on_meta_keywords']);
	}
	
	print_input_row($vbphrase['default'], 'default', $vbulletin->options['keywords'], true, 100);
	foreach ($vbulletin->forumcache as $forumid => $forum)
	{
		if (!empty($forum['metakeywords']))
		{
			print_label_row($forum['title'], "<input type=\"text\" class=\"bginput\" tabindex=\"1\" name=\"keywords[$forumid]\" value=\"$forum[metakeywords]\" size=\"100\"> " .
				construct_link_code($vbphrase['delete'], 'zseo.php?do=keydelete&amp;forumid=' . $forum['forumid']));
		}
	}
	print_submit_row();
	
	print_form_header('zseo', 'keyadd');
	print_table_header($vbphrase['add']);
	print_forum_chooser($vbphrase['forum'], 'forumid');
	print_input_row($vbphrase['zseo_meta_keywords'], 'keywords', '', true, 100);
	print_submit_row($vbphrase['add']);
	print_table_footer();
}

if ($_REQUEST['do'] == 'keydelete')
{
	$forum_dm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
	$forum_dm->set_existing($foruminfo);
	$forum_dm->set('metakeywords', '');
	$forum_dm->save();
	print_cp_redirect('zseo.php?do=keyview');
}

if ($_POST['do'] == 'keyadd')
{
	$vbulletin->input->clean_gpc('p', 'keywords', TYPE_STR);
	
	if (empty($vbulletin->GPC['keywords']))
	{
		print_stop_message('zseo_please_enter_keywords');
	}
	
	if ($foruminfo['metakeywords'] != htmlspecialchars($vbulletin->GPC['keywords']))
	{
		$forum_dm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
		$forum_dm->set_existing($foruminfo);
		$forum_dm->set('metakeywords', $vbulletin->GPC['keywords']);
		$forum_dm->save();
	}
	print_cp_redirect('zseo.php?do=keyview');
}

if ($_POST['do'] == 'keyedit')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'default' 	=> TYPE_STR,
		'keywords' 	=> TYPE_ARRAY,
		'turnon'	=> TYPE_BOOL
	));
	
	$forumids = array_filter(array_map('intval', array_keys($vbulletin->GPC['keywords'])));
	
	if (count($forumids))
	{
		$forums = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "forum WHERE forumid IN(" . implode(',', $forumids) . ")");
		while ($forum = $db->fetch_array($forums))
		{
			$keywords = $vbulletin->GPC['keywords'][$forum['forumid']];
			if (htmlspecialchars($keywords) != $forum['metakeywords'])
			{
				$forum_dm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
				$forum_dm->set_existing($forum);
				$forum_dm->set('metakeywords', $keywords);
				$forum_dm->save();
			}
		}
	}
	
	$options = false;
	if ($vbulletin->GPC['default'] != $vbulletin->options['keywords'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '" . $db->escape_string($vbulletin->GPC['default']) . "'
			WHERE varname = 'keywords'
		");
		$options = true;
	}
	
	if ($vbulletin->GPC['turnon'] AND !$vbulletin->options['zointsseo_meta_keywords'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '1'
			WHERE varname = 'zointsseo_meta_keywords'
		");
		$options = true;
	}
	
	if ($options)
	{
		build_options();
	}
	
	print_cp_redirect('zseo.php?do=keyview');
}

// ########################################################################
// ########################## META DESCRIPTION ############################
// ########################################################################


if ($_REQUEST['do'] == 'descview')
{
	print_form_header('zseo', 'descedit');
	print_table_header($vbphrase['zseo_meta_description']);
	print_description_row($vbphrase['zseo_meta_descriptions_description']);
	
	if (!$vbulletin->options['zointsseo_meta_description'])
	{
		print_label_row($vbphrase['zseo_warning'], $vbphrase['zseo_meta_description_off']);
		print_checkbox_row('', 'turnon', false, 1, $vbphrase['zseo_turn_on_meta_description']);
	}
	
	print_input_row($vbphrase['default'], 'default', $vbulletin->options['description'], true, 100);
	print_input_row($vbphrase['zointsseo_forumhome_description'], 'forumhome', $vbulletin->options['zointsseo_forumhome_description'], true, 100);
	foreach ($vbulletin->forumcache as $forumid => $forum)
	{
		if (!empty($forum['metadescription']))
		{
			print_label_row($forum['title'], "<input type=\"text\" class=\"bginput\" tabindex=\"1\" name=\"description[$forumid]\" value=\"$forum[metadescription]\" size=\"100\"> " .
				construct_link_code($vbphrase['delete'], 'zseo.php?do=descdelete&amp;forumid=' . $forum['forumid']));
		}
	}
	print_submit_row();
	
	print_form_header('zseo', 'descadd');
	print_table_header($vbphrase['add']);
	print_forum_chooser($vbphrase['forum'], 'forumid');
	print_input_row($vbphrase['zseo_meta_description'], 'description', '', true, 100);
	print_submit_row($vbphrase['add']);
	print_table_footer();
}

if ($_REQUEST['do'] == 'descdelete')
{
	$forum_dm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
	$forum_dm->set_existing($foruminfo);
	$forum_dm->set('metadescription', '');
	$forum_dm->save();
	print_cp_redirect('zseo.php?do=descview');
}

if ($_POST['do'] == 'descadd')
{
	$vbulletin->input->clean_gpc('p', 'description', TYPE_STR);
	
	if (empty($vbulletin->GPC['description']))
	{
		print_stop_message('zseo_please_enter_description');
	}
	
	if ($foruminfo['metadescription'] != htmlspecialchars($vbulletin->GPC['description']))
	{
		$forum_dm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
		$forum_dm->set_existing($foruminfo);
		$forum_dm->set('metadescription', $vbulletin->GPC['description']);
		$forum_dm->save();
	}
	print_cp_redirect('zseo.php?do=descview');
}

if ($_POST['do'] == 'descedit')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'default' 		=> TYPE_STR,
		'forumhome'		=> TYPE_STR,
		'description' 	=> TYPE_ARRAY,
		'turnon'		=> TYPE_BOOL
	));
	
	$forumids = array_filter(array_map('intval', array_keys($vbulletin->GPC['description'])));
	
	if (count($forumids))
	{
		$forums = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "forum WHERE forumid IN(" . implode(',', $forumids) . ")");
		while ($forum = $db->fetch_array($forums))
		{
			$description = $vbulletin->GPC['description'][$forum['forumid']];
			if (htmlspecialchars($description) != $forum['metadescription'])
			{
				$forum_dm = datamanager_init('Forum', $vbulletin, ERRTYPE_CP);
				$forum_dm->set_existing($forum);
				$forum_dm->set('metadescription', $description);
				$forum_dm->save();
			}
		}
	}
	
	$options = false;
	if ($vbulletin->GPC['default'] != $vbulletin->options['description'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '" . $db->escape_string($vbulletin->GPC['default']) . "'
			WHERE varname = 'description'
		");
		$options = true;
	}
	
	if ($vbulletin->GPC['forumhome'] != $vbulletin->options['zointsseo_forumhome_description'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '" . $db->escape_string($vbulletin->GPC['forumhome']) . "'
			WHERE varname = 'zointsseo_forumhome_description'
		");
		$options = true;
	}
	
	if ($vbulletin->GPC['turnon'] AND !$vbulletin->options['zointsseo_meta_description'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting SET 
				value = '1'
			WHERE varname = 'zointsseo_meta_description'
		");
		$options = true;
	}
	
	if ($options)
	{
		build_options();
	}
	
	print_cp_redirect('zseo.php?do=descview');
}



print_cp_footer();
?>