<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$specialtemplates = array(
	'adv_links_opts',
	'adv_links_cats',
	'adv_links_mods',
	'adv_links_perms'
);

switch ($_REQUEST['do'])
{
	case 'menu':
		$phrasegroups = array('cphome');
	break;

	case 'modifysettings':
		$phrasegroups = array('cpoption');
	break;

	case 'editcat':
	case 'managecats':
	case 'deletecat':
	case 'emptycat':
		$phrasegroups = array('adv_links_managecats');
	break;
}

$phrasegroups[] = 'adv_links';
$phrasegroups[] = 'adv_links_cp';

// Require backend
require_once('./global.php');
require_once(DIR . '/includes/class_vba_links.php');
require_once(DIR . '/includes/functions_vba_links.php');
require_once(DIR . '/includes/adminfunctions_vba_links.php');
require_once(DIR . '/includes/functions_vba_links_cats.php');

if (!isset($_REQUEST['do']))
{
	$_REQUEST['do'] = 'frameset';
}

$vba_options =& $vbulletin->adv_links_opts;

// Load the $vba_links class
$vba_links =& new vba_links($vbulletin);

// ############################# Build frameset ###############################
if ($_REQUEST['do'] == 'frameset')
{
	$navframe = '<frame src="vba_links_admin.php?do=menu" name="nav" scrolling="yes" border="no" />';
	$mainframe = '<frame src="vba_links_admin.php?do=main" name="main" scrolling="yes" border="no" />';

	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
	<html dir="' . $stylevar['textdirection'] . '" lang="'. $stylevar['languagecode'] . '">
	<head>
		<title>' . $vbphrase['vba_links'] . '</title>
		<script type="text/javascript">
		<!-- //
		if (self.parent.frames.length != 0)
		{
			document.write(\'Get me out of this frame set!\');
			self.parent.location.replace(document.location.href);
		}
		// -->
		</script>
	</head>
	<frameset cols="' . iif($stylevar['textdirection'] == 'ltr', '195,*', '*,195') . '" framespacing="0" border="0" frameborder="0" frameborder="no" border="0">
			' . iif($stylevar['textdirection'] == 'ltr', $navframe . $mainframe, $mainframe . $navframe);
	exit;
}

// ################################# Nav menu #################################
if ($_REQUEST['do'] == 'menu')
{
	require_once(DIR . '/includes/adminfunctions_navpanel.php');
	print_cp_header();

	echo '<div><img alt="" border="" src="../cpstyles/vba_cp_logo.gif" title="' . $vbphrase['admin_control_panel'] . '" hspace="4" vspace="4" /></div><div style="width:168px; padding:4px">';

	echo '<br /><div class="navtitle">' . $vbphrase['vba_links_category'] . '</div><div class="navgroup">';

	construct_nav_option($vbphrase['modify_settings'], 'vba_links_admin.php?do=modifysettings');
	construct_nav_option($vbphrase['manage_categories'], 'vba_links_admin.php?do=managecats');
	construct_nav_option($vbphrase['add_category'], 'vba_links_admin.php?do=addcat');
	construct_nav_option($vbphrase['usergroup_permissions'], 'vba_links_admin.php?do=permissions');
	construct_nav_option($vbphrase['category_permissions'], 'vba_links_admin.php?do=categorypermissions');
	construct_nav_option($vbphrase['add_link'], 'vba_links_admin.php?do=newlink');
	construct_nav_option($vbphrase['mass_manage_links'], 'vba_links_admin.php?do=viewlinks');
	construct_nav_option($vbphrase['custom_fields'], 'vba_links_admin.php?do=customfields');
	construct_nav_option($vbphrase['validate_new_links'], '../' . $vbulletin->config['Misc']['modcpdir'] . '/vba_links.php?do=moderate&amp;type=links');
	construct_nav_option($vbphrase['validate_new_posts'], '../' . $vbulletin->config['Misc']['modcpdir'] . '/vba_links.php?do=moderate&amp;type=posts');
	construct_nav_option($vbphrase['validate_new_categories'], '../' . $vbulletin->config['Misc']['modcpdir'] . '/vba_links.php?do=moderate&amp;type=categories');
	construct_nav_option($vbphrase['edit_link_to_us_page'], 'vba_links_admin.php?do=linktous');
	construct_nav_option($vbphrase['status_reports'], 'vba_links_admin.php?do=statusreports');
	construct_nav_option($vbphrase['maintenance'], 'vba_links_admin.php?do=maintenance');

	foreach ($options AS $links)
	{
		echo $links;
	}
	exit;
}

// ############################ JavaScript Close ############################
if ($_REQUEST['do'] == 'closebox')
{
	?>
	<html>
	<head>
	</head>
	<body>
	<script type="text/javascript">
		window.close();
	</script>
	</body>
	</html>
	<?php
}

/*
 * Time for print_cp_header() if we've made it this far.
 * Get any status report info first if applicable
 */
$onload = '';
$headinsert = '';

if ($_REQUEST['do'] == 'checkstatus')
{
	$repid = intval($_REQUEST['repid']);
	$perpage = intval($_REQUEST['perpage']);

	if (!$repid)
	{
		$type = htmlspecialchars($_REQUEST['type']);

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "adv_links_reports
				(data, dateline, checkagain, type)
			VALUES (
				'',
				" . TIMENOW . ",
				1,
				'" . $db->escape_string($type) . "'
		)");
		$repid = $vbulletin->db->insert_id();

		$report = array();
		$report['lastlinkid'] = 0;
		$report['type'] = $type;
	}

	if ($report['type'] == 'linkrecipurl')
	{
		require_once(DIR . '/includes/functions_vba_links_savelink.php');

		$checkurl = fetch_check_url();

		if (!$checkurl)
		{
			print_stop_message('adv_links_reciprocal_links_disabled');
		}
	}
	else
	{
		$onload = 'setTimeout(\'delayer()\', 5000)';
		$headinsert = '<script type="text/javascript">
<!--
function delayer()
{
	window.location = "vba_links_admin.php?do=checkstatus&repid=' . $repid . '&perpage=' . $perpage . '"
} //-->
</script>';
	}
}

print_cp_header($vbphrase['vbadvanced_links_directory'], $onload, $headinsert);


// ######################## Add / Edit Setting ###########################
if ($_REQUEST['do'] == 'addsetting' OR $_REQUEST['do'] == 'editsetting')
{
	$varname = $_REQUEST['varname'];

	// Get setting phrases
	$settingphrase = fetch_settings_phrases();

	$settinggroups = array();
	$groups = $db->query("
		SELECT grouptitle
		FROM " . TABLE_PREFIX . "adv_settinggroup
		WHERE grouptitle LIKE 'adv_links%'
			OR grouptitle = 'adv_global'
		ORDER BY displayorder
	");
	while ($group = $db->fetch_array($groups))
	{
		$settinggroups[$group['grouptitle']] = $settingphrase["settinggroup_$group[grouptitle]"];
	}

	print_form_header('vba_links_admin', 'do' . $_REQUEST['do']);
	print_table_header(iif($_REQUEST['do'] == 'editsetting', $vbphrase['edit_setting'] . ': ' . $varname, $vbphrase['add_setting']));

	if ($_REQUEST['do'] == 'editsetting')
	{
		$setting = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '" . $db->escape_string($varname) . "'");

		construct_hidden_code('setting[varname]', $setting['varname']);
		print_label_row($vbphrase['varname'], '<b>' . $setting['varname'] . '</b>');

		$phrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE varname IN ('setting_$setting[varname]_title', 'setting_$setting[varname]_desc') AND fieldname = 'vbsettings'");
		while ($phrase = $db->fetch_array($phrases))
		{
			if ($phrase['varname'] == "setting_$setting[varname]_title")
			{
				$setting['title'] = $phrase['text'];
			}
			else
			{
				$setting['description'] = $phrase['text'];
			}
		}
	}
	else
	{
		print_input_row($vbphrase['varname'], 'setting[varname]', $setting['varname']);
	}

	construct_hidden_code('oldgrouptitle', $setting['grouptitle']);

	print_input_row($vbphrase['title'], 'title', $setting['title']);
	print_select_row($vbphrase['setting_group'], 'setting[grouptitle]', $settinggroups, iif($_REQUEST['do'] == 'addsetting', $_REQUEST['grouptitle'], $setting['grouptitle']));
	print_textarea_row($vbphrase['description'], 'desc', $setting['description']);
	print_textarea_row($vbphrase['option_code'], 'setting[optioncode]', $setting['optioncode'], 4, 50);
	print_textarea_row($vbphrase['default'], 'setting[defaultvalue]', $setting['defaultvalue'], 4, 50);
	print_input_row($vbphrase['display_order'], 'setting[displayorder]', $setting['displayorder']);
	print_yes_no_row($vbphrase['serialize'], 'setting[serialize]', $setting['serialize']);
	print_submit_row();
}

// ######################## Do Add Setting ###########################
if ($_POST['do'] == 'doaddsetting')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'setting' => TYPE_ARRAY,
		'title' => TYPE_STR,
		'desc' => TYPE_STR,
		'oldgrouptitle' => TYPE_STR
	));

	$vbulletin->db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product)
		VALUES (
			-1,
			'setting_" . $vbulletin->GPC['setting']['varname'] . "_title',
			'" . $db->escape_string(htmlspecialchars($vbulletin->GPC['title'])) ."',
			'vbsettings',
			'adv_links'
	)");

	$vbulletin->db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product)
		VALUES (
			-1,
			'setting_" . $vbulletin->GPC['setting']['varname'] . "_desc',
			'" . $db->escape_string($vbulletin->GPC['desc']) . "',
			'vbsettings',
			'adv_links'
	)");

	$vbulletin->db->query_write(fetch_query_sql($vbulletin->GPC['setting'], 'adv_setting'));

	require_once(DIR . '/includes/adminfunctions_language.php');
	build_language(-1);

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings', 0);

}

// ######################## Do Edit Setting ###########################
if ($_POST['do'] == 'doeditsetting')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'setting' => TYPE_ARRAY,
		'title' => TYPE_STR,
		'desc' => TYPE_STR,
		'oldgrouptitle' => TYPE_NOHTML
	));

	$vbulletin->db->query_write(fetch_query_sql(
		$vbulletin->GPC['setting'],
		'adv_setting',
		"WHERE varname = '" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "'
			AND grouptitle = '" . $db->escape_string($vbulletin->GPC['oldgrouptitle']) . "'"
	));

	// Try to insert just incase
	$vbulletin->db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(varname, text, fieldname)
		VALUES (
			'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_desc',
			'" . $db->escape_string($vbulletin->GPC['desc']) . "',
			'vbsettings'
		)
	");

	$vbulletin->db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(varname, text, fieldname)
		VALUES (
			'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_title',
			'" . $db->escape_string($vbulletin->GPC['title']) . "',
			'vbsettings'
		)
	");

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($vbulletin->GPC['desc']) . "'
		WHERE varname = 'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_desc'
	");

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($vbulletin->GPC['title']) . "'
		WHERE varname = 'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_title'
	");

	require_once(DIR . '/includes/adminfunctions_language.php');
	build_language(-1);

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings', 0);
}

// ########################## Remove Setting ###########################
if ($_REQUEST['do'] == 'removesetting')
{
	$varname = htmlspecialchars($_REQUEST['varname']);
	$grouptitle = htmlspecialchars($_REQUEST['grouptitle']);

	print_form_header('vba_links_admin', 'doremovesetting');
	construct_hidden_code('varname', $varname);
	construct_hidden_code('grouptitle', $grouptitle);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_delete_the_x_called_y'], $vbphrase['setting'], $varname, $vbphrase['varname'], $varname, ''));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ######################### Do Remove Setting ############################
if ($_POST['do'] == 'doremovesetting')
{
	$varname = $db->escape_string($_POST['varname']);
	$grouptitle = $db->escape_string($_POST['grouptitle']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	$dupecheck = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
	if (!$dupecheck['varname'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_desc'");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_title'");
	}

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings', 0);
}

// ##### Get options array
if ($_REQUEST['do'] == 'viewlinks' OR $_REQUEST['do'] == 'maintenance')
{
	$orderopts = array(
		'linkid' => $vbphrase['linkid'],
		'name' => $vbphrase['title'],
		'dateline' => $vbphrase['date_added'],
		'rating' => $vbphrase['rating'],
		'posts' => $vbphrase['number_of_replies'],
		'views' => $vbphrase['number_of_views'],
		'username' => $vbphrase['username'],
		'lastpostdateline' => $vbphrase['last_posting_date']
	);

	$diropts = array(
		'ASC' => $vbphrase['ascending'],
		'DESC' => $vbphrase['descending']
	);

	$pageoptarray = array(10, 25, 50, 75, 100, 250, 500, 1000);

	foreach ($pageoptarray AS $numb)
	{
		$perpageopts[$numb] = $numb;
	}
}

// ##### Custom Field Types
$customfieldtypes = array(
	'text' => $vbphrase['text_input_single_line'],
	'textarea' => $vbphrase['textarea_multiple_line'],
	'select' => $vbphrase['select_preset_options'],
	'radio' => $vbphrase['radio_options_must_choose'],
	'checkbox' => $vbphrase['checkbox_multiple_options']
);


// ##### Main admin page ######################################################
if ($_REQUEST['do'] == 'main')
{
	$cversion = $vba_options['links_version'];

	print_form_header('', '');
	print_table_header($vbphrase['welcome_to_vba_links_control_panel']);
	print_description_row(iif($cversion, construct_phrase($vbphrase['currently_running_latest_available'], $vba_options['links_version'], $cversion, iif($cversion == $vba_options['links_version'], $vbphrase['your_vba_version_up_to_date'], $vbphrase['newer_version_available'])), $vbphrase['version_info_unavailable']));
	print_table_footer();
}




// ####################### Modify Settings ############################
if ($_REQUEST['do'] == 'modifysettings')
{
	$grouptitle = $vbulletin->input->clean_gpc('r', 'grouptitle', TYPE_NOHTML);

	$settingphrase = fetch_settings_phrases();

	$grouptitlecache = array();

	// Start printing the settinggroup select box
	$grouptitles = array('all' => '-- ' . $vbphrase['show_all_settings'] . ' --');

	$groups = $db->query_read("
		SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup
		WHERE grouptitle LIKE 'adv_links%' OR grouptitle = 'adv_global'
		ORDER BY displayorder
	");
	while ($group = $db->fetch_array($groups))
	{
		$grouptitles[$group['grouptitle']] = $settingphrase['settinggroup_' . $group['grouptitle']];
		$grouptitlecache["$group[grouptitle]"] = $group['grouptitle'];
	}

	// Print it out
	print_form_header('vba_links_admin', 'modifysettings', false, true, 'cpform', '90%', '', true, 'get');
	if ($grouptitle)
	{
		print_table_header($vbphrase['setting_group'] . ' <select name="grouptitle" onchange="this.form.submit();" class="bginput" style="width:350px">' .
			construct_select_options($grouptitles, $grouptitle) . '</select> <input type="submit" class="button" value="' . $vbphrase['go'] . '" />'
		);
		print_table_footer();
	}
	else
	{
		print_table_header(construct_phrase($vbphrase['x_options'], $vbphrase['vbadvanced_links_directory']));
		print_label_row($vbphrase['settings_to_edit'], '<select name="grouptitle" ondblclick="this.form.submit();" class="bginput" style="width:350px" size="' . sizeof($grouptitles) . '">' .
			construct_select_options($grouptitles, 'all') . '</select>'
		);
		print_submit_row($vbphrase['edit_settings'], '');
	}

	// Get options for specific group, or all
	if ($grouptitle)
	{
		$settingscache = array();
		$settings = $db->query_read("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE optioncode != 'hidden' AND
				" . iif($grouptitle == 'all',
					"(adv_settinggroup.grouptitle LIKE 'adv_links%' OR adv_settinggroup.grouptitle = 'adv_global')",
					"adv_setting.grouptitle = '" . $db->escape_string($grouptitle) . "'"
				) . "
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
		");

		while ($setting = $db->fetch_array($settings))
		{
			if ($setting['serialize'])
			{
				$setting['value'] = unserialize($setting['value']);
				if (!is_array($setting['value']))
				{
					$setting['value'] = array();
				}
			}

			$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		}

		$db->free_result($settings);
		unset($setting);

		print_form_header('vba_links_admin', 'saveopts');

		foreach ($grouptitlecache AS $grouptitle)
		{
			print_adv_setting_group($grouptitle, 0);
		}

		print_submit_row();
	}
}


// ####################### Save Settings ############################
if ($_POST['do'] == 'saveopts')
{
	require_once(DIR . '/includes/functions_misc.php');

	$notices = array();

	$grouptitles = $vbulletin->input->clean_gpc('p', 'grouptitles', TYPE_ARRAY);

	$getsettings = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle IN('" . implode("', '", array_keys($grouptitles)) . "')
	");
	while ($adv_setting = $db->fetch_array($getsettings))
	{
		$varname =& $adv_setting['varname'];
		$postvalue =& $_POST['setting'][$varname];

		if ($adv_setting['optioncode'] == 'hidden')
		{
			$postvalue = $adv_setting['value'];
		}

		if ($adv_setting['serialize'])
		{
			$postvalue = serialize($postvalue);
		}

		if ($adv_setting['value'] != $postvalue)
		{
			switch ($varname)
			{

				case 'links_catsdir':
				case 'links_catsorder':
						$updatecatcache = true;
				break;

				case 'links_home_excats':
					if (is_array($postvalue))
					{
						$postvalue = implode(',', $postvalue);
					}
					else
					{
						$postvalue = '';
					}

					if ($postvalue != $vba_options['links_home_excats'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "cron SET nextrun = " . TIMENOW . " WHERE varname = 'adv_links_rand'");
					}
				break;

				case 'links_randonhome':
					if ($postvalue != $vba_options['links_randonhome'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "cron SET nextrun = " . TIMENOW . " WHERE varname = 'adv_links_rand'");
					}
				break;
			}

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting
				SET value = '" . $db->escape_string($postvalue) . "'
				WHERE varname = '" . $db->escape_string($varname) . "'
					AND grouptitle = '" . $db->escape_string($adv_setting['grouptitle']) . "'
			");
		}
	}

	$db->free_result($getsettings);
	unset($adv_setting);

	$adv_options = array();
	$settings = $db->query_read("
		SELECT adv_setting.*
		FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
		LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup ON (adv_setting.grouptitle = adv_settinggroup.grouptitle)
		WHERE adv_setting.grouptitle LIKE 'adv_links%' OR adv_setting.grouptitle = 'adv_global'
	");

	while ($setting = $db->fetch_array($settings))
	{
		if ($setting['serialize'])
		{
			$setting['value'] = unserialize($setting['value']);
			if (!is_array($setting['value']))
			{
				$setting['value'] = array();
			}
		}

		$adv_options[$setting['varname']] = $setting['value'];
	}

	$db->free_result($settings);
	unset($setting);

	build_datastore('adv_links_opts', serialize($adv_options), 1);

	// Category order changed
	$vba_options =& $adv_options;
	if ($updatecatcache)
	{
		update_category_cache();
	}

	// Notices
	if (!empty($notices))
	{
		$printnotice = '<ul>';
		foreach ($notices AS $notice)
		{
			$printnotice .= '<li>' . $notice . '</li>';
		}
		$printnotice .= '</ul>';

		print_stop_message('adv_links_settings_saved_but_problems_found', $printnotice);
	}
	else
	{
		print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings', 0);
	}
}

// ################## Edit Permissions For Usergroup #######################
if ($_REQUEST['do'] == 'permissions')
{
	$u = intval($_REQUEST['u']);

	$usergroups = $db->query_read("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $db->fetch_array($usergroups))
	{
		$grouparray[$usergroup['usergroupid']] = $usergroup['title'];
	}

	// Editing a specific group
	if ($u)
	{
		$usergroup = $vbulletin->adv_links_perms[$u];
		$usergroup['title'] = $grouparray[$u];
		$usergroup['usergroupid'] = $u;
	}

	print_form_header('vba_links_admin', 'permissions', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header(iif($usergroup['usergroupid'], $usergroup['title'], $vbphrase['modify_permissions']));

	print_description_row($vbphrase['usergroup'] . ': <select name="u" class="bginput" onchange="submit();">' . construct_select_options($grouparray, $u) . '</select> <input class="button" type="submit" value="' . $vbphrase['go'] . '" />', 0, 1, '', 'center');
	print_table_footer();

	if ($u)
	{
		print_form_header('vba_links_admin', 'updateperms');

		$perms = convert_bits_to_array($usergroup['links_perms'], $vba_links->_permbits);

		print_label_row('<b>' . $usergroup['title'] . '</b>', '<input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 1);" type="button" value="' . $vbphrase['all_yes'] . '" /> <input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 0);" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

		construct_hidden_code('usergroupid', $usergroup['usergroupid']);
		construct_hidden_code('usergrouptitle', $usergroup['title']);

		print_permission_rows(false);

		print_submit_row($vbphrase['save']);
	}
}

// ######################## Do Update Permissions #####################
if ($_POST['do'] == 'updateperms')
{
	$usergroup = $_POST['usergroup'];
	$usergroupid = intval($_POST['usergroupid']);
	$usergrouptitle = $_POST['usergrouptitle'];

	require_once(DIR . '/includes/functions_misc.php');

	$usergroup['links_perms'] = convert_array_to_bits($usergroup, $vba_links->_permbits, 1);

	$vbulletin->adv_links_perms[$usergroupid] = $usergroup;

	build_datastore('adv_links_perms', serialize($vbulletin->adv_links_perms), 1);

	define('CP_REDIRECT', 'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=permissions');
	print_stop_message('saved_usergroup_x_successfully', $usergrouptitle);
}

// ##################### Edit Permissions For Usergroup #######################
if ($_REQUEST['do'] == 'categorypermissions')
{
	$catinfo = array();

	$getcats = $db->query_read("
		SELECT catid, title, parent, haslinks, displayorder
		FROM " . TABLE_PREFIX . "adv_links_categories
		ORDER BY $vba_options[links_catsorder] $vba_options[links_catsdir], haslinks
	");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$db->free_result($getcats);
	unset($categories);

	$usergroupperms = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_permissions");
	while ($uperms = $vbulletin->db->fetch_array($usergroupperms))
	{
		$usergroup['title'] = $vbulletin->usergroupcache[$u]['title'];
		$hasperms[$uperms['usergroupid']][$uperms['catid']] = true;
	}

	print_form_header('', '');
	print_table_header($vbphrase['category_permissions']);
	print_description_row($vbphrase['permissions_color_key']);
	print_table_break();

	print_description_row('<div class="darkbg" style="border: 2px inset">' . print_category_perm_rows($catinfo, 0) . '</div>');
	print_table_footer();

}

// ######################## Edit Permissions for Category #####################
if ($_REQUEST['do'] == 'editcategoryperms')
{
	$u = intval($_REQUEST['u']);
	$c = intval($_REQUEST['c']);

	?>
	<script type="text/javascript">
	<!--
	function js_set_custom()
	{
		if (document.cpform.useusergroup[1].checked == false)
		{
			if (confirm("<?php echo $vbphrase['for_setting_to_have_effect_custom_permissions_must_be_enabled']; ?>"))
			{
				document.cpform.useusergroup[1].checked = true;
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return true;
		}
	}
	// -->
	</script>
	<?php

	$vba_links->default_permissions($u);

	if ($usergroup = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links_permissions WHERE usergroupid = '$u' AND catid = '$c'"))
	{
		$perms = convert_bits_to_array($usergroup['permissions'], $vba_links->_permbits);
	}
	else
	{
		$perms = convert_bits_to_array($vbulletin->adv_links_perms[$u]['links_perms'], $vba_links->_permbits);
	}

	$usergroup['title'] = $vbulletin->usergroupcache["$u"]['title'];
	$category['title'] = $vbulletin->adv_links_cats["$c"]['title'];

	print_form_header('vba_links_admin', 'doeditcatperms');
	construct_hidden_code('usergroup[usergroupid]', $u);
	construct_hidden_code('usergroup[catid]', $c);
	print_table_header(construct_phrase($vbphrase['edit_category_permissions_for_usergroup_x_in_category_y'], $usergroup['title'], $category['title']));

	print_description_row('
		<label for="useusergroup_0"><input ' . iif(!isset($usergroup['permissions']), ' checked="checked"') . ' id="useusergroup_0" name="useusergroup" onclick="this.form.reset(); this.checked=true;" type="radio" value="0" />' . $vbphrase['use_default_permissions_note_delete_previous_permissions_set'] . '</label>
		<br />
		<label for="useusergroup_1"><input id="useusergroup_1" ' . iif(isset($usergroup['permissions']), ' checked="checked"') . ' name="useusergroup" type="radio" value="1" />' . $vbphrase['use_custom_permissions'] . '</label>
	', 0, 2, 'tfoot', '' , 'mode');
	print_table_break();

	print_table_break();

	print_label_row('<b>' . $usergroup['title'] . '</b>',
		'<input id="checkall" name="checkall" onclick="if (js_set_custom()) { js_check_all_option(this.form, 1); }" type="button" value="' . $vbphrase['all_yes'] . '" />
		<input id="checkall" name="checkall" onclick="if (js_set_custom()) { js_check_all_option(this.form, 0); }" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

	construct_hidden_code('usergroupid', $usergroup['usergroupid']);
	construct_hidden_code('usergrouptitle', $usergroup['title']);

	print_permission_rows(true);

	print_submit_row($vbphrase['save']);
}

// ###################### Do Add/Edit Category Permissions ####################
if ($_POST['do'] == 'doeditcatperms')
{
	$usergroup = $_POST['usergroup'];
	$useusergroup = intval($_POST['useusergroup']);
	$usergroup['usergroupid'] = intval($usergroup['usergroupid']);
	$usergroup['catid'] = intval($usergroup['catid']);

	require_once(DIR . '/includes/functions_misc.php');

	$perms = convert_array_to_bits($usergroup, $vba_links->_permbits, 1);

	$checkexists = $db->query_first("SELECT permissionid FROM " . TABLE_PREFIX . "adv_links_permissions WHERE catid = $usergroup[catid] AND usergroupid = $usergroup[usergroupid]");

	if (!$useusergroup AND $checkexists['permissionid'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_permissions WHERE usergroupid = $usergroup[usergroupid] AND catid = $usergroup[catid]");
	}

	if ($useusergroup)
	{
		if ($checkexists['permissionid'])
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_links_permissions SET permissions = '$perms' WHERE usergroupid = $usergroup[usergroupid] AND catid = $usergroup[catid]");
		}
		else
		{
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "adv_links_permissions
					(catid, usergroupid, permissions)
				VALUES (
					$usergroup[catid],
					$usergroup[usergroupid],
					'$perms'
			)");
		}
	}
	update_category_cache();
	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categorypermissions', 0);
}

// ######################### Reset Category Permissions ######################
if ($_REQUEST['do'] == 'resetperms')
{
	$catid = intval($_REQUEST['catid']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_permissions WHERE catid = $catid");
	update_category_cache();

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categorypermissions', 0);
}

// ############################ Deny All Permission ###########################
if ($_REQUEST['do'] == 'denyperms')
{
	$usergroups = $db->query_read("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
	while ($usergroup = $vbulletin->db->fetch_array($usergroups))
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "adv_links_permissions
				(catid, usergroupid, permissions)
			VALUES (
				" . intval($_REQUEST['catid']) . ",
				'$usergroup[usergroupid]',
				0
		)");
	}

	update_category_cache();

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categorypermissions', 0);
}

// ############################# Manage Categories #########################
if ($_REQUEST['do'] == 'managecats')
{
	?>
	<script type="text/javascript">
	function js_dir_jump(catid)
	{
		action = eval("document.cpform.c" + catid + ".options[document.cpform.c" + catid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				page = 'vba_links_admin.php?do=editcat&catid=';
			break;
			case 'remove':
				page = 'vba_links_admin.php?do=deletecat&catid=';
			break;
			case 'addsub':
				page = 'vba_links_admin.php?do=addcat&parentid=';
			break;
			case 'view':
				page = 'vba_links_admin.php?do=viewlinks&catid=';
			break;
			case 'empty':
				page = 'vba_links_admin.php?do=emptycat&catid=';
			break;
			case 'massdelete':
				page = 'vba_links_admin.php?do=viewlinks&massedit=1&amp;catid=';
			break;
		}
		document.cpform.reset();

		window.location = page + catid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
	}

	function js_mod_jump(catid)
	{
		modid = eval("document.cpform.m" + catid + ".options[document.cpform.m" + catid + ".selectedIndex].value");
		document.cpform.reset();
		switch (modid)
		{
			case 'addmod':
				window.location = "vba_links_admin.php?s=<?php echo $vbulletin->session->vars['sessionhash'] ?>&do=addmoderator&catid=" + catid;
			break;
			default:

				window.location = "vba_links_admin.php?s=<?php echo $vbulletin->session->vars['sessionhash'] ?>&do=editmoderator&modid=" + modid + "&catid=" + catid;
			break;
		}
	}

	</script>

	<?php

	$catid = intval($_REQUEST['catid']);

	$diroptions = array(
		'edit' => $vbphrase['edit_category'],
		'view' => $vbphrase['view_category'],
		'empty' => $vbphrase['empty_category'],
		'remove' => $vbphrase['remove_category'],
		'addsub' => $vbphrase['add_sub_category'],
		'massdelete' => $vbphrase['mass_delete_suspend']
	);

	print_form_header('vba_links_admin', 'doorder');
	print_table_header($vbphrase['modify_links_categories'], 4);

	if ($vba_options['links_catsorder'] == 'title')
	{
		print_description_row($vbphrase['please_note_categories_ordered_by_title'], '', 4);
	}

	print_cells_row(array($vbphrase['title'], $vbphrase['controls'], $vbphrase['display_order'], $vbphrase['moderator']), 1, 'tcat');

	$catinfo = array();
	$hassubs = array();
	$getcats = $db->query_read("
		SELECT catid, title, parent, haslinks, displayorder, parentlist, active, valid
		FROM " . TABLE_PREFIX . "adv_links_categories
		ORDER BY $vba_options[links_catsorder] $vba_options[links_catsdir], haslinks
	");
	while ($categories = $db->fetch_array($getcats))
	{
		$catinfo[$categories['catid']] = $categories;

		$hassubs[$categories['parent']] = true;
	}

	$db->free_result($getcats);
	unset($categories);

	// ##### Get Moderator Info
	$catmods = array();
	$mods = $db->query("
		SELECT user.userid, user.username, moderator.catid
		FROM " . TABLE_PREFIX . "adv_links_moderator AS moderator
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (moderator.userid = user.userid)
	");
	while ($lmods = $db->fetch_array($mods))
	{
		$lmods['musername'] = fetch_musername($lmods);
		$catmods[$lmods['catid']][$lmods['userid']] = $lmods;
	}

	$db->free_result($mods);
	unset($lmods);

	// ##### Construct the categories
	$catinfo = construct_categories($catinfo, 0, -1);

	if ($catid)
	{
		$maxlevel = $catinfo[$catid]['level'] + 1;
		$parentcheck = explode(',', $catinfo[$catid]['parentlist']);
	}

	if (!empty($catinfo))
	{
		foreach ($catinfo as $cats)
		{
			// Expand options
			if ($vba_options['links_admincatcollapse'] AND $cats['level'] > 1)
			{
				// Just check catid/level first to avoid explode() and in_array()
				if (!$catid OR $cats['level'] > $maxlevel)
				{
					continue;
				}
				else if (!array_intersect($parentcheck, explode(',', $cats['parentlist'])))
				{
					continue;
				}
			}

			// +/- links
			if ($catid)
			{
				if (in_array($cats['catid'], $parentcheck))
				{
					$cats['isparent'] = true;
				}
			}

			// Moderators
			if ($catmods[$cats['catid']])
			{
				$modcounts = 0;
				foreach($catmods[$cats['catid']] AS $moderator)
				{
					$modcounts++;
					$modopts[$cats['catid']] .= '<option value="' . $moderator['userid'] . '"> &nbsp; ' . $moderator['username'] . '</option>';
					$modcount[$cats['catid']] = $modcounts;
				}
			}

			$cell = array();

			$expandit = '';

			if ($vba_options['links_admincatcollapse'])
			{
				if ($catid == $cats['catid'] OR $cats['isparent'])
				{
					$expandit = '[-]';
				}
				else if ($hassubs[$cats['catid']])
				{
					$expandit = '[<a href="vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=managecats&amp;catid=' . $cats['catid'] . '">+</a>]';
				}
				else
				{
					$expandit = '&nbsp;&nbsp;&nbsp;&nbsp;';
				}
			}

			$cell[] = $expandit . '<b>' . str_repeat('- - ', ($cats['level'] - 1)) . ' <a href="vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editcat&amp;catid=' . $cats['catid'] . '">' . $cats['title'] . '</a></b>'
				. iif(!$cats['valid'], ' <span class="smallfont">(' . $vbphrase['awaiting_moderation'] . ')</span>')
				. iif(!$cats['active'], ' <span class="smallfont">(' . $vbphrase['inactive'] . ')</span> ');

			$cell[] = '<select name="c' . $cats['catid'] . '" onchange="js_dir_jump(' . $cats['catid'] . ');" class="bginput">' . construct_select_options($diroptions) . '</select><input class="button" type="button" value="' . $vbphrase['go'] . '" onclick="js_dir_jump(' . $cats['catid'] . ');" />';

			$cell[] = '<input type="text" class="bginput" name="order[' . $cats['catid'] . ']" size="3" title="' . $vbphrase['edit_display_order'] . '" value="' . $cats['displayorder'] . '" />';

			$cell[] = '<select class="bginput" name="m' . $cats['catid'] . '" onchange="js_mod_jump(' . $cats['catid'] . ');"><option value="0">' . $vbphrase['moderators'] . ' (' . vb_number_format($modcount[$cats['catid']]) . ')</option>' . $modopts[$cats['catid']] . '<option value="addmod">' . $vbphrase['add_moderator'] . '</option></select><input class="button" onclick="js_mod_jump(' . $cats['catid'] . ');" type="button" value="' . $vbphrase['go'] . '" />';

			print_cells_row($cell);

		}
		unset($catinfo, $moderator, $catmods);
	}
	print_submit_row($vbphrase['update_order'], $vbphrase['reset'], 4);
}

// ####################### Re-Order Categories #########################
if ($_POST['do'] == 'doorder')
{
	foreach ($_POST['order'] AS $catid => $disorder)
	{
		$catid = intval($catid);
		$disorder = intval($disorder);

		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET displayorder = $disorder WHERE catid = $catid");
	}

	update_category_cache();

	define('CP_REDIRECT', 'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=managecats');
	print_stop_message('saved_display_order_successfully');
}

// ############################# Add / Edit Category #########################
if ($_REQUEST['do'] == 'addcat' OR $_REQUEST['do'] == 'editcat')
{
	$catid = intval($_REQUEST['catid']);
	$parentid = intval($_REQUEST['parentid']);

	print_form_header('vba_links_admin', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editcat')
	{
		$cat = $db->query_first("
			SELECT categories.*, user.username
			FROM " . TABLE_PREFIX . "adv_links_categories AS categories
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
			WHERE catid = '$catid'
		");

		$headertitle = $vbphrase['edit_category'] . ' - ' . $cat['title'] . ' (' . $vbphrase['id'] . ': ' . $cat['catid'] . ')';

		construct_hidden_code('catinfo[catid]', $cat['catid']);

		$options = convert_bits_to_array($cat['options'], $vba_links->_categoryopts);
		$useropts = convert_bits_to_array($cat['useroptions'], $vba_links->_catuseropts);
	}
	else
	{
		$headertitle = $vbphrase['add_category'];

		$cat['parent'] = $parentid;
		$cat['haslinks'] = 1;
		$cat['active'] = 1;
		$cat['valid'] = 1;
		$options = array(
			'open_for_links' => 1,
			'open_for_posts' => 1,
			'allow_desc_html' => 0,
			'allow_desc_bbcode' => 1,
			'allow_desc_bbimgcode' => 0,
			'allow_desc_smilies' => 1,
			'allow_desc_links' => 0,
			'allow_custom_html' => 0,
			'allow_custom_bbcode' => 1,
			'allow_custom_bbimgcode' => 1,
			'allow_custom_smilies' => 1,
			'allow_post_html' => 0,
			'allow_post_bbcode' => 1,
			'allow_post_bbimgcode' => 1,
			'allow_post_smilies' => 1,
			'allow_post_icons' => 1,
			'allow_replies' => 1,
			'allow_ratings' => 1,
			'allow_custom_links' => 1,
			'canhavepassword' => 1
		);
	}

	if ($cat['catuserid'])
	{
		$cat['title'] = unhtmlspecialchars($cat['title']);
		$cat['description'] = unhtmlspecialchars($cat['description']);
	}

	// Main options
	print_table_header($headertitle);
	print_input_row($vbphrase['title'], 'catinfo[title]', $cat['title']);
	print_textarea_row($vbphrase['description'], 'catinfo[description]', $cat['description']);
	print_input_row($vbphrase['display_order'] . iif($_REQUEST['do'] == 'addcat', $vbphrase['set_to_neg_1_first']), 'catinfo[displayorder]', $cat['displayorder']);
	print_category_select('catinfo[parent]', $vbphrase['category_parent'], $cat['parent']);
	print_input_row($vbphrase['email_address_to_notify_when_new_link'], 'catinfo[newlinkemail]', $cat['newlinkemail']);
	print_input_row($vbphrase['email_address_to_notify_when_new_post'], 'catinfo[newpostemail]', $cat['newpostemail']);

	// Category options
	print_table_header($vbphrase['category_options']);
	print_yes_no_row($vbphrase['act_as_category'], 'catinfo[haslinks]', $cat['haslinks']);
	print_yes_no_row($vbphrase['category_is_valid_not_awaiting_moderation'], 'catinfo[valid]', $cat['valid']);
	print_yes_no_row($vbphrase['category_is_active_will_not_appear_ramians_accessible'], 'catinfo[active]', $cat['active']);
	print_yes_no_row($vbphrase['category_is_open_for_links'], 'options[open_for_links]', $options['open_for_links']);
	print_yes_no_row($vbphrase['category_is_open_for_posts'], 'options[open_for_posts]', $options['open_for_posts']);
	print_yes_no_row($vbphrase['allow_ratings'], 'options[allow_ratings]', $options['allow_ratings']);
	print_yes_no_row($vbphrase['no_follow_links'], 'options[nofollow]', $options['nofollow']);
	print_yes_no_row($vbphrase['allow_users_create_subcats'], 'catinfo[allowusercats]', $cat['allowusercats']);
	print_radio_row(
		$vbphrase['reciprocal_link_check'],
		'catinfo[recipoptions]',
		array(
			0 => $vbphrase['use_default_setting'],
			3 => $vbphrase['no'],
			1 => $vbphrase['yes_do_not_require'],
			2 => $vbphrase['yes_require']
		),
		$cat['recipoptions'],
		'smallfont'
	);

	// User options
	print_table_header($vbphrase['user_options']);
	print_input_row($vbphrase['category_owner_enter_username'], 'catinfo[catusername]', $cat['username']);
	print_yes_no_row($vbphrase['allow_other_users_view'], 'useropts[allow_view]', $useropts['allow_view']);
	print_yes_no_row($vbphrase['allow_other_users_add_links'], 'useropts[allow_newlinks]', $useropts['allow_newlinks']);
	print_yes_no_row($vbphrase['allow_other_users_reply'], 'useropts[allow_reply]', $useropts['allow_reply']);
	print_yes_no_row($vbphrase['allow_other_users_rate'], 'useropts[allow_rating]', $useropts['allow_rating']);

	// Access options
	print_table_header($vbphrase['access_options']);
	print_input_row($vbphrase['category_password_acts_in_addition_other_permissions'], 'catinfo[password]', $cat['password']);
	print_yes_no_row($vbphrase['apply_this_password_to_child_categories'], 'options[childpass]', $options['childpass']);
	print_yes_no_row($vbphrase['can_have_password'], 'options[canhavepassword]', $options['canhavepassword']);

	print_table_header($vbphrase['link_description']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_desc_html]', $options['allow_desc_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_desc_bbcode]', $options['allow_desc_bbcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_desc_smilies]', $options['allow_desc_smilies']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_desc_bbimgcode]', $options['allow_desc_bbimgcode']);
	print_yes_no_row($vbphrase['automatically_parse_links_in_text'], 'options[allow_desc_links]', $options['allow_desc_links']);

	print_table_header($vbphrase['custom_fields']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_custom_html]', $options['allow_custom_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_custom_bbcode]', $options['allow_custom_bbcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_custom_smilies]', $options['allow_custom_smilies']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_custom_bbimgcode]', $options['allow_custom_bbimgcode']);
	print_yes_no_row($vbphrase['automatically_parse_links_in_text'], 'options[allow_custom_links]', $options['allow_custom_links']);

	print_table_header($vbphrase['posting_options']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_post_html]', $options['allow_post_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_post_bbcode]', $options['allow_post_bbcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_post_smilies]', $options['allow_post_smilies']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_post_bbimgcode]', $options['allow_post_bbimgcode']);
	print_yes_no_row($vbphrase['allow_icons'], 'options[allow_post_icons]', $options['allow_post_icons']);

	print_table_break();

	print_submit_row($vbphrase['save'], $vbphrase['reset'], 6);
}

// ############################# Do Add / Edit Cat #########################
if ($_POST['do'] == 'doeditcat' OR $_POST['do'] == 'doaddcat')
{
	$catinfo = $vbulletin->input->clean_gpc('p', 'catinfo', TYPE_ARRAY);
	$options = $vbulletin->input->clean_gpc('p', 'options', TYPE_ARRAY);
	$useropts = $vbulletin->input->clean_gpc('p', 'useropts', TYPE_ARRAY);
	$oldparentid = $vbulletin->input->clean_gpc('p', 'oldparentid', TYPE_INT);
	$setting = $vbulletin->input->clean_gpc('p', 'setting', TYPE_ARRAY);

	if (!trim($catinfo['title']))
	{
		print_stop_message('adv_links_cant_have_category_without_title');
	}

	$catinfo['catuserid'] = '';

	// Category has an owner
	if ($catinfo['catusername'])
	{
		$catuser = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($catinfo['catusername']) . "'");
		$catinfo['catuserid'] = $catuser['userid'];
		if (!$catuser['userid'])
		{
			print_stop_message('invalid_user_specified');
		}
	}
	unset($catinfo['catusername']);

	// Run htmlspecialchars() if it's a user owned category,
	// since HTML is not allowed in these
	if ($catinfo['catuserid'])
	{
		$catinfo['title'] = htmlspecialchars($catinfo['title']);
		$catinfo['description'] = htmlspecialchars($catinfo['description']);
	}

	require_once(DIR . '/includes/functions_misc.php');

	$catinfo['options'] = convert_array_to_bits($options, $vba_links->_categoryopts);
	$catinfo['useroptions'] = convert_array_to_bits($useropts, $vba_links->_catuseropts);

	// ## Add category
	if ($_POST['do'] == 'doaddcat')
	{
		$db->query_write(fetch_query_sql($catinfo, 'adv_links_categories'));

		$newcatid = $db->insert_id();

		insert_category_parentlist($catinfo['parent']);
	}
	// ## Edit category
	else
	{
		if ($catinfo['parentid'] == $catinfo['catid'])
		{
			print_stop_message('adv_links_cant_parent_category_to_self');
		}

		$oldcat = $db->query_first("SELECT parent FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $catinfo[catid]");

		$db->query_write(fetch_query_sql($catinfo, 'adv_links_categories', 'WHERE catid = ' . $catinfo['catid']));

		if ($oldcat['parent'] != $catinfo['parent'])
		{
			rebuild_parents($catinfo['catid']);
		}
	}

	update_category_cache();

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=managecats', 0);
}

// ############################# Delete Category #########################
if ($_REQUEST['do'] == 'deletecat')
{
	$catid = intval($_REQUEST['catid']);

	print_form_header('vba_links_admin', 'dodeletecat');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_category']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Category #########################
if ($_POST['do'] == 'dodeletecat')
{
	$catid = intval($_POST['catid']);

	$catids = array($catid);
	if ($catinfo = construct_categories($vbulletin->adv_links_cats, $catid))
	{
		foreach ($catinfo AS $cats)
		{
			$catids[] = $cats['catid'];
		}
	}

	$catids = implode(',', $catids);

	remove_links_in_cat($catids);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid IN ($catids)");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_subscribecat WHERE catid IN ($catids)");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_moderator WHERE catid IN ($catids)");

	update_category_cache();

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=managecats', 0);

}

// ############################# Empty Category #########################
if ($_REQUEST['do'] == 'emptycat')
{
	$catid = intval($_REQUEST['catid']);

	print_form_header('vba_links_admin', 'doemptycat');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_empty_category']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Empty Category #########################
if ($_POST['do'] == 'doemptycat')
{
	$catid = intval($_POST['catid']);

	remove_links_in_cat($catid);

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_links_categories SET
			linkcount = 0,
			postcount = 0,
			lastlinkid = 0,
			lastlinktitle = '',
			lastlinkusername = '',
			lastlinkuserid = 0,
			lastlinkdateline = 0,
			lastpostid = 0,
			lastpostlinktitle = '',
			lastpostusername = '',
			lastpostuserid = 0,
			lastpostdateline = 0
		WHERE catid = $catid
	");

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=managecats', 0);
}

// ############################# Add Moderator #########################
if ($_REQUEST['do'] == 'addmoderator')
{
	$catid = intval($_REQUEST['catid']);

	$cat = $db->query_first("SELECT catid, title FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $catid");
	print_form_header('vba_links_admin', 'doaddmod');
	print_table_header($vbphrase['add_moderator'] . '-' . $cat['title']);
	construct_hidden_code('catid', $cat['catid']);
	construct_hidden_code('cattitle', $cat['title']);
	print_description_row($vbphrase['add_moderator_note_permissions']);
	print_input_row($vbphrase['username']. ':', 'username');
	print_submit_row();
}

// ############################# Do Add Moderator #########################
if ($_POST['do'] == 'doaddmod')
{
	$catid = intval($_POST['catid']);
	$username = htmlspecialchars($_POST['username']);

	$user = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($username) . "'");

	if (!$user['userid'])
	{
		print_stop_message('invalid_username_specified');
	}

	$ismod = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "adv_links_moderator WHERE userid = $user[userid] AND catid = $catid");

	if ($ismod['userid'])
	{
		print_stop_message('user_is_already_mod');
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_links_moderator
			(userid, catid)
		VALUES (
			$user[userid],
			$catid
	)");

	update_adv_links_mods();

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=managecats', 0);

}

// ############################ Edit Moderator ###########################
if ($_REQUEST['do'] == 'editmoderator')
{
	$catid = intval($_REQUEST['catid']);
	$modid = intval($_REQUEST['modid']);

	$moderator = $db->query_first("
		SELECT moderator.userid, user.username, moderator.catid, categories.title
		FROM " . TABLE_PREFIX . "adv_links_moderator AS moderator
		INNER JOIN " . TABLE_PREFIX . "adv_links_categories AS categories ON (moderator.catid = categories.catid)
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (moderator.userid = user.userid)
		WHERE moderator.userid = $modid AND moderator.catid = $catid
	");

	if (!$moderator['userid'])
	{
		print_stop_message('invalid_user_specified');
	}

	print_form_header('vba_links_admin', 'deletemod');
	construct_hidden_code('userid', $moderator['userid']);
	construct_hidden_code('catid', $moderator['catid']);
	print_table_header(construct_phrase($vbphrase['remove_x_from_moderating_y'], $moderator['username'], $moderator['title']));
	print_description_row(construct_phrase($vbphrase['do_you_wish_to_remove_x_from_moderating_y'], $moderator['username'], $moderator['title']));

	print_submit_row();
}

// ##### Do Edit Moderator ####################################################
if ($_POST['do'] == 'deletemod')
{
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_moderator WHERE userid = " . intval($_POST['userid']) . " AND catid = " . intval($_POST['catid']));

	update_adv_links_mods();

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=managecats', 0);
}

// ########################## Manage Custom Fields ########################
if ($_REQUEST['do'] == 'customfields')
{
	print_form_header('vba_links_admin', 'addcustomfield', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['add_custom_field']);
	print_select_row($vbphrase['custom_field_type'], 'type', $customfieldtypes);
	print_submit_row($vbphrase['continue'], '');

	print_form_header('vba_links_admin', 'ordercustom');
	print_table_header($vbphrase['custom_fields'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['type'], $vbphrase['display_order'], $vbphrase['controls']), 0, 'thead', -1);

	$getfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields ORDER BY displayorder");
	if ($db->num_rows($getfields))
	{
		while ($fields = $db->fetch_array($getfields))
		{
			$cells = array();
			$cells[] = $fields['title'];
			$cells[] = '<span class="smallfont">' . $customfieldtypes[$fields['type']] . '</span>';
			$cells[] = '<input class="bginput" name="order[' . $fields['fieldid'] . ']" size="3" type="text" value="' . $fields['displayorder'] . '" />';
			$cells[] = construct_link_code(
				$vbphrase['edit'],
				'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editcustomfield&amp;fieldid=' . $fields['fieldid']
			) . construct_link_code(
				$vbphrase['delete'],
				'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=removecustomfield&amp;fieldid=' . $fields['fieldid']
			);
			print_cells_row($cells, '', '', -1);
		}

		print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 4);

	}
	else
	{
		print_description_row($vbphrase['not_added_custom_fields'], '', 6);
	}
	print_table_footer();

}

// ########################### Re-Order Custom Fields ########################
if ($_POST['do'] == 'ordercustom')
{
	foreach ($_POST['order'] AS $key => $disorder)
	{
		$disorder = intval($disorder);
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_cfields SET displayorder = $disorder WHERE fieldid = '" . $db->escape_string($key) . "'");
	}

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=customfields', 0);
}

// ############################## Add Custom Field ##########################
if ($_REQUEST['do'] == 'addcustomfield' OR $_REQUEST['do'] == 'editcustomfield')
{
	$type = htmlspecialchars($_REQUEST['type']);
	$fieldid = intval($_REQUEST['fieldid']);

	print_form_header('vba_links_admin', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editcustomfield')
	{
		$custom = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields WHERE fieldid = $fieldid");
		construct_hidden_code('custom[fieldid]', $custom['fieldid']);
		$type = $custom['type'];

		$headertitle = $vbphrase['edit_custom_field'] . ' - ' . $custom['title'];
	}
	else
	{
		$headertitle = $vbphrase['add_custom_field'] . ' - ' . $customfieldtypes[$type];
		$custom['searchable'] = 1;
	}

	construct_hidden_code('custom[type]', $type);
	print_table_header($headertitle, 4);
	print_input_row($vbphrase['title'], 'custom[title]', $custom['title']);
	print_textarea_row($vbphrase['description'], 'custom[description]', $custom['description']);
	print_input_row($vbphrase['display_order'], 'custom[displayorder]', $custom['displayorder']);

	if ($type == 'text' OR $type == 'textarea')
	{
		print_input_row($vbphrase['max_length_of_allowed_user_input'], 'custom[maxlength]', $custom['maxlength']);
	}
	else
	{
		print_textarea_row(construct_phrase($vbphrase['x_enter_the_options_that_the_user_can_choose_from'], $vbphrase['options']), 'custom[options]', $custom['options']);
	}

	print_yes_no_row($vbphrase['field_required'], 'custom[required]', $custom['required']);
	print_yes_no_row($vbphrase['field_is_searchable'], 'custom[searchable]', $custom['searchable']);

	if ($_REQUEST['do'] == 'addcustomfield' OR $custom['catids'] == 'all')
	{
		$custom['catids'] = array('all');
	}
	else
	{
		$custom['catids'] = explode(',', $custom['catids']);
	}

	$cselect = array();
	$cselect['all'] = $vbphrase['all_categories'];
	$cselect['---'] = '--------------------------';

	foreach ($vbulletin->adv_links_cats AS $catids => $catinfo)
	{
		$cselect[$catids] = $catinfo['title'];
	}

	$selectbox = '<select name="custom[catids][]" multiple="multiple" style="width:275px" size="' . iif(sizeof($vbulletin->adv_links_cats) + 2 >= 10, 10, sizeof($vbulletin->adv_links_cats) + 2) . '"><option value="all"' . iif($custom['catids'] == array('all'), ' selected="selected"') . '>' . $vbphrase['all_categories'] . '</option><option value="---">------------------</option>';

	foreach ($vbulletin->adv_links_cats AS $catids => $catinfo)
	{
		$selectbox .= '<option value="' . $catids . '" ' . iif(in_array($catids, $custom['catids']),'selected="selected"') . '>' . str_repeat('--', $catinfo['level']) . $catinfo['title'] . '</option>';
	}
	$selectbox .= '</select><div class="smallfont"><input name="custom[incsubs]" value="1" type="checkbox" ' . iif($custom['incsubs'], 'checked="checked" ') . '/> ' . $vbphrase['also_apply_to_subcategories'] . '</div>';

	print_label_row($vbphrase['categories_to_appear_in'], $selectbox);

	print_submit_row();
}

// ########################## Do Add Custom Field #########################
if ($_POST['do'] == 'doaddcustomfield' OR $_POST['do'] == 'doeditcustomfield')
{
	$custom = $_POST['custom'];

	if (!trim($custom['title']))
	{
		print_stop_message('adv_links_must_choose_title_for_custom');
	}

	if (sizeof($custom['catids']) > 1 AND in_array('all', $custom['catids']))
	{
		print_stop_message('adv_links_custom_chosen_all');
	}

	if (!empty($custom))
	{
		$cfields = array();
		foreach ($custom AS $key => $value)
		{
			if (is_array($value))
			{
				$cfields[$key] = implode(',', $value);
			}
			else
			{
				$cfields[$key] = $value;
			}
		}
	}

	$db->query_write(fetch_query_sql($cfields, 'adv_links_cfields', iif($_POST['do'] == 'doeditcustomfield', 'WHERE fieldid = ' . $custom['fieldid'])));

	if ($_POST['do'] == 'doaddcustomfield')
	{
		$newfieldid = $db->insert_id();
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_cfields_entries ADD field$newfieldid MEDIUMTEXT NOT NULL");
	}

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=customfields', 0);

}

// ##### Delete Custom Field ##################################################
if ($_REQUEST['do'] == 'removecustomfield')
{
	$fieldid = intval($_REQUEST['fieldid']);

	$custom = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields WHERE fieldid = $fieldid");

	print_form_header('vba_links_admin', 'doremovecustomfield');
	print_table_header($vbphrase['confirm_deletion']);
	construct_hidden_code('fieldid', $custom['fieldid']);
	print_description_row(
		construct_phrase($vbphrase['are_you_sure_you_want_to_delete_the_x_called_y'],
			$vbphrase['custom_fields'],
			$custom['title'],
			$vbphrase['id'],
			$custom['fieldid']
	));
	print_submit_row($vbphrase['yes'], $vbphrase['no']);
}

// ##### Do Delete Custom Field ###############################################
if ($_POST['do'] == 'doremovecustomfield')
{
	$fieldid = intval($_POST['fieldid']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_cfields WHERE fieldid = $fieldid");
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_cfields_entries DROP field$fieldid");

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=customfields', 0);

}

// ##### New Link #############################################################
if ($_REQUEST['do'] == 'newlink')
{
	print_form_header('vba_links_admin', 'addlink');
	print_table_header($vbphrase['add_a_link']);
	print_category_select('catid', $vbphrase['category'], 0, $vbphrase['please_choose_a_category'], true);
	print_input_row($vbphrase['url'], 'link[linkurl]', $link['linkurl']);
	print_submit_row();
}

// ##### Add / Edit Link ######################################################
if ($_REQUEST['do'] == 'addlink' OR $_REQUEST['do'] == 'editlink')
{
	$linkid = intval($_REQUEST['linkid']);
	$catid = intval($_REQUEST['catid']);
	$cw = intval($_REQUEST['cw']);

	require_once(DIR . '/includes/functions_vba_links_savelink.php');

	print_form_header('vba_links_admin', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editlink')
	{
		$headerphrase = '<span style="float:' . $stylevar['right'] . '">(<a href="' . $link['linkurl'] . '" target="_blank">' . $link['name'] . '</a>)</span>';
		$submitphrase = $vbphrase['save'];
		$cfieldspop = true;

		iif($link['userid'],
			'<a href="' . $vbulletin->options['bburl'] . '/member.php?u=' . $link['userid'] . '">' . $link['username'] . '</a>',
			$vbphrase['unregistered']) .
		') &nbsp; ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $link['dateline']) . '</span>' . $vbphrase['edit_link'] . ': ' . $link['name'] . ' (' . $vbphrase['id'] . $link['linkid'] . ')';

		$link = $db->query_first("
			SELECT links.*, customfields.*
			FROM " . TABLE_PREFIX . "adv_links AS links
			LEFT JOIN " . TABLE_PREFIX . "adv_links_cfields_entries AS customfields ON (links.linkid = customfields.lid)
			WHERE linkid = $linkid
		");

		construct_hidden_code('linkid', $link['linkid']);
		construct_hidden_code('closewin', $cw);
	}
	else
	{
		if (!$catid)
		{
			print_stop_message('adv_links_must_choose_category');
		}

		$headerphrase = $vbphrase['add_a_link'] . ': ' . $vbulletin->adv_links_cats[$catid]['title'];
		$submitphrase = $vbphrase['add_a_link'];
		$cfieldspop = false;

		$link['linkurl'] = $_POST['link']['linkurl'];

		fetch_meta();

		$link['catid'] = $catid;
		$link['valid'] = 1;
		$link['open'] = 1;
		$link['sticky'] = 0;
		$link['suspended'] = 0;
	}

	print_table_header($headerphrase, 2, 0, '', 'left');
	print_input_row($vbphrase['title'], 'link[name]', unhtmlspecialchars($link['name']));
	print_input_row($vbphrase['url'], 'link[linkurl]', $link['linkurl']);
	print_input_row($vbphrase['reciprocal_link_url'], 'link[linkrecipurl]', $link['linkrecipurl']);
	print_textarea_row($vbphrase['description'], 'link[description]', unhtmlspecialchars($link['description']), 5, 34);

	if ($_REQUEST['do'] == 'editlink')
	{
		print_category_select('link[catid]', $vbphrase['category'], $link['catid'], $vbphrase['please_choose_a_category'], true);
	}
	else
	{
		construct_hidden_code('link[catid]', $catid);
	}

	print_input_row($vbphrase['keywords'], 'link[keywords]', $link['keywords']);
	print_input_row($vbphrase['views'], 'link[views]', intval($link['views']));

	if ($_REQUEST['do'] == 'addlink')
	{
		print_input_row($vbphrase['submitted_by'], 'link[username]', unhtmlspecialchars($vbulletin->userinfo['username']));
	}

	print_yes_no_row($vbphrase['validated'], 'link[valid]', $link['valid']);
	print_yes_no_row($vbphrase['open'], 'link[open]', $link['open']);
	print_yes_no_row($vbphrase['sticky'], 'link[sticky]', $link['sticky']);
	print_yes_no_row($vbphrase['suspended'], 'link[suspended]', $link['suspended']);

	construct_custom_fieldbits($link, '', $cfieldspop, true);

	print_submit_row($submitphrase);

}

// ##### Do Add / Edit Link ###################################################
if ($_POST['do'] == 'doaddlink' OR $_POST['do'] == 'doeditlink')
{
	require_once(DIR . '/includes/functions_vba_links_savelink.php');

	$link = $_POST['link'];
	$linkid = intval($_POST['linkid']);
	$closewin = intval($_POST['closewin']);

	if (!$link['catid'])
	{
		print_stop_message('adv_links_must_choose_category');
	}
	if ($link['linkurl'] == 'http://' OR !$link['linkurl'] OR !$link['name'])
	{
		print_stop_message('required_field_missing_be_sure_entered_all');
	}

	if ($_POST['do'] == 'doaddlink')
	{
		if (!$link['username'])
		{
			$link['username'] = $vbulletin->userinfo['username'];
		}

		if ($link['username'] == $vbulletin->userinfo['username'])
		{
			$link['userid'] = $vbulletin->userinfo['userid'];
		}
		else
		{
			$user = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($link['username']) . "'");
			$link['userid'] = $user['userid'];

			if (!$link['userid'])
			{
				print_stop_message('invalid_user_specified');
			}
		}
	}

	$link['name'] = htmlspecialchars($link['name']);
	$link['description'] = htmlspecialchars($link['description']);
	$link['keywords'] = clean_keywords($link['keywords']);

	// Editing a link
	if ($_POST['do'] == 'doeditlink')
	{
		$oldlink = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links WHERE linkid = $linkid");

		$db->query_write(fetch_query_sql($link, 'adv_links', 'WHERE linkid = ' . $linkid));

		construct_customfields_sql($linkid, false);

		update_counts_moved($linkid, $link, $oldlink);

		if ($closewin)
		{
			print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=closebox');
		}
		else
		{
			print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewlinks', 0);
		}
	}
	else
	{
		// Adding a link

		$link['ipaddress'] = IPADDRESS;
		$link['dateline'] = TIMENOW;
		$db->query_write(fetch_query_sql($link, 'adv_links'));
		$newlinkid = $db->insert_id();

		construct_customfields_sql($newlinkid);

		if ($link['valid'] AND !$link['suspended'])
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_links_categories SET
					linkcount = linkcount+1,
					lastlinkid = $newlinkid,
					lastlinktitle = '" . $db->escape_string($link['name']) . "',
					lastlinkusername = '" . $db->escape_string($link['username']) . "',
					lastlinkuserid = $link[userid],
					lastlinkdateline = " . TIMENOW . "
				WHERE catid = $link[catid]
			");
		}

		print_stop_message('adv_links_your_link_has_been_added');
	}
}

// ############################# Delete Link #########################
if ($_REQUEST['do'] == 'deletelink')
{
	$linkid = intval($_REQUEST['linkid']);

	$link = $db->query_first("SELECT linkid, name, catid FROM " . TABLE_PREFIX . "adv_links WHERE linkid = $linkid");

	if (!$link['linkid'])
	{
		print_stop_message('invalid_x_specified', 'linkid');
	}

	print_form_header('vba_links_admin', 'dodeletelink');
	construct_hidden_code('catid', $link['catid']);
	construct_hidden_code('linkid', $link['linkid']);
	construct_hidden_code('closewin', $cw);

	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_link'], $link['name']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Link #########################
if ($_POST['do'] == 'dodeletelink')
{
	$linkid = intval($_POST['linkid']);
	$closewin = intval($_POST['closewin']);
	$catid = intval($_POST['catid']);

	$link = $db->query_first("SELECT name, posts FROM " . TABLE_PREFIX . "adv_links WHERE linkid = $linkid");
	$postcount = intval($link['postcount']);

	$cat = $db->query_first("
		SELECT linkid, name, dateline, username, userid
		FROM " . TABLE_PREFIX . "adv_links
		WHERE catid = $catid
			AND suspended = 0
			AND valid = 1
			AND linkid != $linkid
		ORDER BY dateline DESC
	");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_links_categories SET
			linkcount = linkcount-1,
			postcount = postcount-$postcount,
			lastlinkid = '$cat[linkid]',
			lastlinktitle = '" . $db->escape_string($cat['name']) . "',
			lastlinkuserid = '$cat[userid]',
			lastlinkdateline = '$cat[dateline]',
			lastlinkusername = '" . $db->escape_string($cat['username']) . "'
		WHERE catid = $catid
	");

	delete_links($linkid);

	if ($closewin)
	{
		define('CP_REDIRECT', 'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=closebox');
		print_stop_message('deleted_x_successfully', 'link');
	}
	else
	{
		print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewlinks', 0);
	}
}

// ############################# View Links #########################
if ($_REQUEST['do'] == 'viewlinks')
{
	$catid = intval($_REQUEST['catid']);
	$repid = intval($_REQUEST['repid']);
	$onlystatcode = htmlspecialchars($_REQUEST['onlystatcode']);

	$perpage = intval($_POST['perpage']);
	$pagenumber = intval($_POST['pagenumber']);
	$currentpage = intval($_POST['currentpage']);
	$linkaction = $_POST['linkaction'];
	$domassedit = $_POST['domassedit'];
	$conditions = $_POST['conditions'];
	$orderby = $_POST['orderby'];
	$direction = $_POST['direction'];

	$checkedpages = $_POST['checkedpages'];

	if ($domassedit)
	{
		$_REQUEST['do'] = 'confirmmassedit';
	}
	else
	{
		$headerarray = array();
		$wherequery = array();

		$headerarray[] = '&nbsp;';

		// Viewing Status report
		if ($repid)
		{
			$prevreports = array();
			$getreports = $db->query("SELECT * FROM " . TABLE_PREFIX . "adv_links_reports WHERE repid <= $repid ORDER BY repid DESC LIMIT 6");
			while ($reports = $db->fetch_array($getreports))
			{
				$reports['data'] = unserialize($reports['data']);

				if ($reports['repid'] == $repid)
				{
					$report = $reports;
				}
				else
				{
					$prevreports[$reports['dateline']] = $reports['data'];
				}
			}

			if (!is_array($report['data']))
			{
				$report['data'] = array();
			}

			$reporttime = $report['endtime'] - $report['dateline'];

			$reptimemin = floor($reporttime / 60);
			$reptimesec = $reporttime - ($reptimemin * 60);

			$statuscodes = array_unique(array_values($report['data']));

			$statuscodescounts = array_count_values(array_map('intval', array_values($report['data'])));

			print_form_header('', '');
			print_table_header(construct_phrase($vbphrase['status_report_no_generated_date_time'], $repid, vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $report['dateline']), $reptimemin, $reptimesec));

			print_cells_row(array($vbphrase['status'], $vbphrase['links']), 1);
			foreach ($statuscodes AS $code)
			{
				print_label_row(iif($onlystatcode == $code, '<strong><i>') . construct_link_code('<span style="color:' . $status_array[$code]['color'] . '">' . $status_array[$code]['text'] . '</span>', 'vba_links_admin.php?do=viewlinks&amp;repid=' . $repid . '&amp;onlystatcode=' . $code), '<div align="center">' . $statuscodescounts[$code] . '</div>') . iif($onlystatcode == $code, '</i></strong>');
			}

			print_table_footer();

			if ($onlystatcode)
			{
				$dataids = array_keys($report['data'], $onlystatcode);
			}
			else
			{
				$dataids = array_keys($report['data']);
			}

			if (!empty($dataids))
			{
				$dataids = implode(',', $dataids);
			}
			else
			{
				$dataids = 0;
			}

			$wherequery[] = "linkid IN($dataids)";
			construct_hidden_code('repid', $repid);
			construct_hidden_code('onlystatcode', $onlystatcode);
			$headerarray[] = $vbphrase['status'];
		}

		$headerarray[] = $vbphrase['title'] . ' / ' . $vbphrase['date_added'];
		$headerarray[] = $vbphrase['replies'];
		$headerarray[] = $vbphrase['views'];

		if ($catid AND $catid != -1)
		{
			$wherequery[] = 'links.catid = ' . $catid;
		}
		else
		{
			$headerarray[] = $vbphrase['category'];
			$showdirs = true;
		}

		if (!$orderby)
		{
			$orderby = 'name';
		}
		$doorderby = construct_orderby();

		if ($direction != 'DESC')
		{
			$direction = 'ASC';
		}

		if (!$perpage)
		{
			$perpage = 50;
		}

		if (empty($conditions))
		{
			if ($_REQUEST['formsubmitted'])
			{
				print_stop_message('adv_links_must_check_show_links_that_are');
			}
			else
			{
				$conditions = array('allgood' => 1, 'moderation' => 1, 'suspended' => 1);
			}
		}

		// Show suspended / awaiting moderation / all
		if ($conditions['allgood'])
		{
			if (!$conditions['moderation'])
			{
				$wherequery[] = 'links.valid = 1';
			}

			if (!$conditions['suspended'])
			{
				$wherequery[] = 'links.suspended = 0';
			}
		}
		else
		{
			if ($conditions['suspended'] AND $conditions['moderation'])
			{
				$wherequery[] = 'links.valid = 0 OR links.suspended = 1';
			}
			else if ($conditions['moderation'])
			{
				$wherequery[] = 'links.valid = 0';
			}
			else if ($conditions['suspended'])
			{
				$wherequery[] = 'links.suspended = 1';
			}
		}

		$condition['fromtable'] = 'adv_links AS links';

		// Get the page data
		$pagedata = fetch_page_data($perpage);

		switch ($_REQUEST['gotopagenumber'])
		{
			case $vbphrase['last'] . ' ':
				$pagedata['pagenumber'] = $pagedata['pagecount'];
			break;
			case '< ' . $vbphrase['prev']:
				$pagedata['pagenumber'] = $currentpage - 1;
			break;
			case $vbphrase['next'] . ' >':
				$pagedata['pagenumber'] = $currentpage + 1;
		}

		echo '	<script type="text/javascript">
function js_check_alllinks(formobj)
{
	exclude = new Array();
	exclude[0] = \'conditions[moderation]\';
	exclude[1] = \'conditions[suspended]\';
	exclude[2] = \'conditions[allgood]\';

	js_toggle_all(formobj, \'checkbox\', \'\', exclude, formobj.allbox.checked);
}	</script>';


		print_form_header('vba_links_admin', 'viewlinks');

		if ($linkaction)
		{
			foreach ($linkaction AS $lnkid => $laction)
			{
				if ($laction)
				{
					construct_hidden_code('linkaction[' . $lnkid . ']', $laction);
				}
			}
		}

		construct_hidden_code('currentpage', $pagedata['pagenumber']);
		construct_hidden_code('checkedpages[' . $pagedata['pagenumber'] . ']', 1);

		if (!empty($checkedpages))
		{
			foreach ($checkedpages AS $cpage => $cpageval)
			{
				construct_hidden_code('checkedpages[' . $cpage . ']', 1);
			}
		}

		construct_hidden_code('formsubmitted', 1);

		print_table_header(construct_phrase($vbphrase['showing_links_x_to_y_of_z'], number_format($pagedata['minlimit']), number_format($pagedata['maxlimit']), number_format($pagedata['count'])));

		print_category_select('catid', $vbphrase['showing_links_in'], $catid, $vbphrase['all_categories'], true, -1);
		print_select_row($vbphrase['order_by'], 'orderby', $orderopts, $orderby);
		print_select_row($vbphrase['direction'], 'direction', $diropts, $direction);
		print_select_row($vbphrase['per_page'], 'perpage', $perpageopts, $pagedata['perpage']);

		$condopts = array(
			'moderation' => $vbphrase['awaiting_moderation'],
			'suspended' => $vbphrase['suspended'],
			'allgood' => $vbphrase['not_awaiting_moderation_or_suspended']
		);

		foreach ($condopts AS $condvar => $condtext)
		{
			$condboxes .= '<input id="' . $condvar . '" type="checkbox" ' . iif(in_array($condvar, array_keys($conditions)), 'checked="checked"') . ' name="conditions[' . $condvar . ']" value="1" /><label for="' . $condvar . '">' . $condtext . '</label><br />';
		}

		print_label_row($vbphrase['show_links_that_are'], $condboxes);

		print_description_row('<input class="button" type="submit" value="' . $vbphrase['show_links'] . '" /> <input class="button" type="reset" value="  ' . $vbphrase['reset'] . '  " />', '', 2, 'thead', 'center');
		print_table_break();

		$pagenav = '<div class="smallfont"><strong>' . construct_phrase($vbphrase['page_x_of_y'], $pagedata['pagenumber'], $pagedata['pagecount']) . '</strong></div>';

		// Construct the pagenav
		if ($pagedata['pagecount'] > 1)
		{
			if ($pagedata['pagenumber'] != 1)
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&laquo; ' . $vbphrase['first'] . '" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&lt; ' . $vbphrase['prev'] . '" /> ';
			}

			$i = 0;
			$thispage = $pagedata['pagenumber'] - 5;

			if ($pagedata['pagenumber'] + 5 > $pagedata['pagecount'])
			{
				$thispage = $pagedata['pagecount'] - 9;
			}

			if ($thispage < 0)
			{
				$thispage = 0;
			}

			$pageprint = iif($pagedata['pagecount'] >= 9, 9, $pagedata['pagecount']);

			while ($i++ < $pageprint)
			{
				$thispage++;
				$pagenav .= '<input class="button" name="page" type="submit" value="' . iif($thispage > 9, $thispage, ' ' . $thispage . ' ') . '"' . iif($pagedata['pagenumber'] == $thispage, ' disabled="disabled"') . ' /> ';
			}

			if ($pagedata['pagenumber'] != $pagedata['pagecount'])
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['next'] . ' &gt;" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['last'] . ' &raquo;" />';
			}
		}

		print_table_header($pagenav, 7);

		print_description_row('<div align="' . $stylevar['left'] . '">
			<input id="checkall" name="allbox" ' . iif($_REQUEST['allbox'], 'checked="checked"') . ' onclick="js_check_alllinks(this.form);" type="checkbox" value="1" /> <label for="checkall">' . $vbphrase['check_all'] . '</label>
		</div>', false, 7);


		print_cells_row($headerarray, 1, 'tcat');

		$getlinks = $db->query("
			SELECT " . iif($orderby == 'rating', 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,') . " links.*, links_categories.catid, links_categories.title
			FROM " . TABLE_PREFIX . "adv_links AS links
			LEFT JOIN " . TABLE_PREFIX . "adv_links_categories AS links_categories ON (links.catid = links_categories.catid)
			" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
			ORDER BY $doorderby $direction
			LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
		");

		if ($db->num_rows($getlinks))
		{
			$target = '';
			$close = '';

			$target = 'target="_blank"';
			$close = '&amp;cw=1';

			while ($links = $db->fetch_array($getlinks))
			{
				$cell = array();

				$selected = array();

				if ($linkaction[$links['linkid']] OR ($_REQUEST['allbox'] AND !$checkedpages[$pagedata['pagenumber']]))
				{
					$links['selected'] = 'checked="checked"';
				}

				// Delete / suspend controls
				$cell[] = '<label for="linkaction_' . $links['linkid'] . '"><input id="linkaction_' .$links['linkid'] . '" ' . $links['selected'] . ' name="linkaction[' . $links['linkid'] . ']" type="checkbox" value="1" />';

				// Link status for reports
				if ($repid)
				{
					$link['status'] = $status_array[$report['data'][$links['linkid']]];

					if (!empty($prevreports))
					{
						$morebold = false;
						foreach ($prevreports AS $repdate => $replinks)
						{
							if ($replinks[$links['linkid']] != $report['data'][$links['linkid']])
							{
								$morebold = true;
							}

							if ($replinks[$links['linkid']])
							{
								$links['prevrep'] .= iif($links['prevrep'], "\r\n") . vbdate($vbulletin->options['dateformat'], $repdate) . ' - ' . $status_array[$replinks[$links['linkid']]]['text'];
							}
						}
					}

					$cell[] = '<div class="smallfont" style="color:' . $link['status']['color'] . '">' . $link['status']['text'] . '</div><div class="smallfont" style="padding-top:4px">' . construct_link_code(iif($morebold, '<strong>' . $vbphrase['previous_reports'] . '</strong>', $vbphrase['previous_reports']), 'vba_links_admin.php?do=comparereports&amp;linkid=' . $links['linkid'] . '&amp;type=' . $report['type'], true, $links['prevrep']) . '</div>';
				}

				$cell[] = '<strong>' . $links['name'] . '</strong> ' . iif($links['suspended'], '(<font color="red" size="1">' . $vbphrase['suspended'] . '</font>)') . ' ' . iif(!$links['valid'], '(<font color="yellow" size="1">' . $vbphrase['awaiting_moderation'] . '</font>)') . '

				<div class="smallfont"> - ' . $vbphrase['by'] . ' ' . iif($links['username'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $links['userid'] . '" target="_blank">' . $links['username'] . '</a>', $vbphrase['guest']) . ' ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $links['dateline']) . '</div>

				<div class="smallfont" style="white-space: nowrap; padding-top: 6px">
					<a href="' . $links['linkurl'] . '" target="_blank">[' . $vbphrase['view_site'] . ']</a>
					<a href="vba_links_admin.php?do=editlink&amp;catid=' . $catid . '&amp;linkid=' . $links['linkid'] . $close . '" ' . $target . '>[' . $vbphrase['edit'] . ']</a>
					<a href="vba_links_admin.php?do=deletelink&catid=' . $catid . '&linkid=' . $links['linkid'] . $close . '" ' . $target . '>[' . $vbphrase['delete'] . ']</a>
					</div>';

				$cell[] = '<div align="center">' . vb_number_format($links['posts']) . '</div>';
				$cell[] = '<div align="center">' . vb_number_format($links['views']) . '</div>';

				if ($showdirs)
				{
					$cell[] = $links['title'];
				}

				print_cells_row($cell, '', '', -2);
			}

			if ($pagedata['pagecount'] > 1)
			{
				print_table_header($pagenav, 7);
			}

			print_table_footer(7, $vbphrase['action'] . ': <select name="action"><option value="delete">' . $vbphrase['delete'] . '</option><option value="suspend">' . $vbphrase['suspend'] . '</option><option value="move">' . $vbphrase['move'] . '</option></select> <input type="submit" class="button" name="domassedit" value="' . $vbphrase['go'] . '" style="font-weight:bold" tabindex="1" />', 0, $colspan);
		}
		else
		{
			print_description_row('<b>' . $vbphrase['no_links_matched_query'] . '</b>', '', 6, '', 'center');
		}

		print_table_footer();
	}
}

// ##### Confirm Mass Suspend / Delete ########################################
if ($_REQUEST['do'] == 'confirmmassedit')
{
	$action = $vbulletin->input->clean_gpc('r', 'action', VAR_STR_NOHTML);

	$linkaction = $_REQUEST['linkaction'];

	print_form_header('vba_links_admin', 'domassedit');
	construct_hidden_code('action', $action);

	$linkcache = array();

	if (!empty($linkaction))
	{
		$getlinks = $db->query("
			SELECT links.*, title
			FROM " . TABLE_PREFIX . "adv_links AS links
			LEFT JOIN " . TABLE_PREFIX . "adv_links_categories AS categories ON (links.catid = categories.catid)
			WHERE linkid IN (" . implode(',', array_keys($linkaction)) . ")
		");

		if ($db->num_rows($getlinks))
		{
			print_table_header(construct_phrase($vbphrase['you_have_chosen_to_x_links'], $vbphrase[$action]), 4);

			if ($action == 'move')
			{
				echo '<tr class="' . fetch_row_bgclass() . '" valign="top">';
				echo '<td colspan="4" style="padding: 8px">' . $vbphrase['please_select_category_to_move_links_to'] . '<br /><select class="bginput" name="newcatid">';
				echo '<option value="0">' . $vbphrase['please_choose_a_category'] . '</option>';
				echo print_cat_select($selectedid, 'submitlink');
				echo '</select>';
			 	echo '</td></tr>';
			}

			print_cells_row(array($vbphrase[$action], $vbphrase['link_name'], $vbphrase['category'], $vbphrase['date_added']), 'tcat');

			while ($link = $db->fetch_array($getlinks))
			{
				$cell = array();
				$havelinks = true;
				$cell[] = '<input checked="checked" name="linkids[' . $link['linkid'] . ']" type="checkbox" value="1" />';
				$cell[] = $link['name'];
				$cell[] = $link['title'];
				$cell[] = '<div align="right" class="smallfont" style="white-space: nowrap">' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $link['dateline']) . '</div><div align="right">by ' . iif($link['userid'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $link['userid'] . '" target="_blank">' . $link['username'] . '</a>', $vbphrase['guest']) . '</div>';

				print_cells_row($cell, '', '', -1);
			}
			print_table_break();
		}

		$db->free_result($link);
		unset($link);
	}

	if ($havelinks)
	{
		print_submit_row();
	}
	else
	{
		print_table_header($vbphrase['error']);
		print_description_row($vbphrase['no_links_selected']);
	}
}

// ############################ Do Mass Delete #########################
if ($_POST['do'] == 'domassedit')
{
	$action = $vbulletin->input->clean_gpc('p', 'action', VAR_STR_NOHTML);
	$newcatid = $vbulletin->input->clean_gpc('p', 'newcatid', VAR_INT);

	$linkids = array();
	if (!empty($_POST['linkids']))
	{
		$linkids = array_map('intval', array_keys($_POST['linkids'], 1));
	}

	if ($action == 'move')
	{
		if (!$newcatid)
		{
			print_stop_message('adv_links_must_choose_category_move');
		}

		$newcat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $newcatid");
	}

	if (!empty($linkids))
	{
		$catcache = array();
		$getcats = $db->query_read("SELECT catid, postcount, linkcount, lastlinkid, lastlinkdateline, lastpostid, lastpostdateline FROM " . TABLE_PREFIX . "adv_links_categories");
		while ($cats = $db->fetch_array($getcats))
		{
			$catcache[$cats['catid']] = $cats;
		}

		// Get the link/cat info first
		$catcounts = array();
		$lastlinkupdate = array();
		$lastpostupdate = array();

		if ($action == 'move')
		{
			$newcatcounts = array(
				'lastlinkdateline' => $catcache[$newcatid]['lastlinkdateline'],
				'lastpostdateline' => $catcache[$newcatid]['lastpostdateline']
			);

			$lastpostupdate[] = $newcatid;
		}

		$getlinks = $db->query_read("SELECT linkid, name, userid, username, catid, dateline, posts, valid, suspended, lastpostdateline FROM " . TABLE_PREFIX . "adv_links WHERE linkid IN(" . implode(',', $linkids) . ") AND valid = 1 AND suspended = 0");
		while ($link = $db->fetch_array($getlinks))
		{
			$catcounts[$link['catid']]['linkcount']++;
			$catcounts[$link['catid']]['postcount'] += $link['posts'];

			if ($link['linkid'] == $catcache[$link['catid']]['lastlinkid'])
			{
				$lastlinkupdate[] = $link['catid'];
			}

			if ($link['lastpostdateline'] >= $catcache[$link['catid']]['lastpostdateline'])
			{
				$lastpostupdate[] = $link['catid'];
			}

			if ($action == 'move' AND $link['catid'] != $newcatid)
			{
				$newcatcounts['linkcount']++;
				$newcatcounts['postcount'] += $link['posts'];

				// Check last link
				if ($catcache[$newcatid]['lastlinkdateline'] < $link['dateline'])
				{
					$newcatcounts['lastlinkid'] = $link['linkid'];
					$newcatcounts['lastlinkdateline'] = $link['dateline'];
					$newcatcounts['lastlinkuserid'] = $link['userid'];
					$newcatcounts['lastlinkusername'] = $link['username'];
					$newcatcounts['lastlinktitle'] = $link['name'];
				}

				// Check last post
				if ($catcache[$newcatid]['lastpostdateline'] < $link['lastpostdateline'])
				{
					$lastpostupdate[] = $link['catid'];
				}
			}
		}

		// Now that we have a record of what the info was, alter it
		switch ($action)
		{
			case 'delete':
				delete_links($linkids);
			break;

			case 'suspend':
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links SET suspended = 1 WHERE linkid IN(" . implode(',', $linkids) . ")");
			break;

			case 'move':
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links SET catid = $newcatid WHERE linkid IN(" . implode(',', $linkids) . ")");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_links_categories SET
						linkcount = linkcount+$newcatcounts[linkcount],
						postcount = postcount+$newcatcounts[postcount]
						" . iif($newcatcounts['lastlinkid'], ",
							lastlinkid = $newcatcounts[lastlinkid],
							lastlinkdateline = $newcatcounts[lastlinkdateline],
							lastlinkuserid = $newcatcounts[lastlinkuserid],
							lastlinkusername = '" . $db->escape_string($newcatcounts['lastlinkusername']) . "',
							lastlinktitle = '" . $db->escape_string($newcatcounts['lastlinktitle']) . "'
						") . "
					WHERE catid = $newcatid
				");
			break;
		}

		// Need to update last post stuff
		if (!empty($lastpostupdate))
		{
			foreach ($lastpostupdate AS $lpcat)
			{
				$lastpost = $db->query_first("
					SELECT postid, post.dateline, post.userid, post.username, post.linkid, link.name
					FROM " . TABLE_PREFIX . "adv_links_posts AS post
					LEFT JOIN " . TABLE_PREFIX . "adv_links AS link ON (post.linkid = link.linkid)
					WHERE catid = $lpcat AND suspended = 0 AND valid = 1
					ORDER BY post.dateline DESC
				");

				$catcounts[$lpcat]['lastpostid'] = $lastpost['postid'];
				$catcounts[$lpcat]['lastpostdateline'] = $lastpost['dateline'];
				$catcounts[$lpcat]['lastpostuserid'] = $lastpost['userid'];
				$catcounts[$lpcat]['lastpostusername'] = $lastpost['username'];
				$catcounts[$lpcat]['lastpostlinktitle'] = $lastpost['name'];
			}
		}

		if (!empty($lastlinkupdate))
		{
			foreach ($lastlinkupdate AS $lpcat)
			{
				$lastlink = $db->query_first("SELECT linkid, name, dateline, userid, username FROM " . TABLE_PREFIX . "adv_links WHERE catid = $lpcat AND valid = 1 AND suspended = 0 ORDER BY dateline DESC");

				$catcounts[$lpcat]['lastlinkid'] = $lastlink['linkid'];
				$catcounts[$lpcat]['lastlinkdateline'] = $lastlink['dateline'];
				$catcounts[$lpcat]['lastlinkuserid'] = $lastlink['userid'];
				$catcounts[$lpcat]['lastlinkusername'] = $lastlink['username'];
				$catcounts[$lpcat]['lastlinktitle'] = $lastlink['name'];
			}
		}

		// Now update the category counts
		if (!empty($catcounts))
		{
			foreach ($catcounts AS $catid => $update)
			{
				if (!$update['postcount'])
				{
					unset($update['postcount']);
				}

				if (!$update['linkcount'])
				{
					unset($update['linkcount']);
				}

				if (empty($update))
				{
					continue;
				}

				$queryset = array();
				foreach ($update AS $var => $value)
				{
					if ($var == 'linkcount' OR $var == 'postcount')
					{
						$queryset[$var] = "$var = $var - $value";
					}
					else
					{
						$queryset[$var] = "$var = '" . $db->escape_string($value) . "'";
					}
				}

				if (!empty($queryset))
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET " . implode(',', $queryset) . "	WHERE catid = $catid");
				}
			}
		}
	}

	print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewlinks', 0);

}

// #################### Check duplicates ###################
if ($_REQUEST['do'] == 'checkdupes')
{
	print_form_header('vba_links_admin', 'confirmmassedit');
	print_table_header($vbphrase['find_duplicate_links']);
	print_table_break();

	$linkarray = array();

	$links = $db->query("
		SELECT linkid, linkurl, name, userid, username, dateline, title
		FROM " . TABLE_PREFIX . "adv_links AS links
		LEFT JOIN " . TABLE_PREFIX . "adv_links_categories AS categories ON (links.catid = categories.catid)
	");
	while ($link = $db->fetch_array($links))
	{
		$linkarray[] = $link;
	}

	$db->free_result($links);
	unset($link);

	foreach($linkarray AS $link)
	{
		find_duplicates($linkarray, $link['linkurl']);
	}
	print_submit_row($vbphrase['delete'], '', 6);
}


// ############################# Maintenance #########################
if ($_REQUEST['do'] == 'maintenance')
{

	// Check for Duplicates
	print_form_header('vba_links_admin', 'checkdupes');
	print_table_header($vbphrase['find_duplicate_links']);
	print_description_row($vbphrase['find_duplicate_links_desc']);
	print_submit_row($vbphrase['find_duplicate_links'], '');

	// Update Category Counters
	print_form_header('vba_links_admin', 'updatecounters');
	print_table_header($vbphrase['update_categories']);
	print_description_row($vbphrase['update_categories_counters_desc'] . '<br /><br />
		<div><input checked="checked" name="linkcount" type="checkbox" value="1" /> ' . $vbphrase['link_counts'] . '</div>
		<div><input checked="checked" name="postcount" type="checkbox" value="1" /> ' . $vbphrase['post_counts'] . '</div>
		<div><input checked="checked" name="lastlinks" type="checkbox" value="1" /> ' . $vbphrase['last_link_info'] . '</div>
		<div><input checked="checked" name="lastposts" type="checkbox" value="1" /> ' . $vbphrase['last_post_info'] . '</div>
	');
	print_submit_row($vbphrase['update_counters'], '');

	// Update links last post
	print_form_header('vba_links_admin', 'updatelastpost');
	print_table_header($vbphrase['update_last_posts']);
	print_description_row($vbphrase['update_last_posts_desc']);
	print_submit_row($vbphrase['update_counters'], '');

}

// #################### Update Counters #################
if ($_REQUEST['do'] == 'updatecounters')
{
	$linkcount = intval($_REQUEST['linkcount']);
	$postcount = intval($_REQUEST['postcount']);
	$lastlinks = intval($_REQUEST['lastlinks']);
	$lastposts = intval($_REQUEST['lastposts']);

	if (!$linkcount AND !$postcount AND !$lastlinks AND !$lastposts)
	{
		print_stop_message('adv_links_must_choose_update');
	}
	update_count(0, $linkcount, $postcount, $lastlinks, $lastposts);

	define('CP_REDIRECT', 'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=maintenance');
	print_stop_message('adv_links_updated_counters');
}

// ###################### Update Last Post #############################
if ($_REQUEST['do'] == 'updatelastpost')
{
	// Limit to only links with posts
	$idlimit = array();
	$linkids = $db->query_read("SELECT DISTINCT linkid FROM " . TABLE_PREFIX . "adv_links_posts");
	while ($ids = $db->fetch_array($linkids))
	{
		$idlimit[] = $ids['linkid'];
	}

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_links SET
			lastpostid = 0,
			lastpostdateline = 0,
			lastpostuserid = 0,
			lastpostusername = '',
			posts = 0
		" . iif(!empty($idlimit), "WHERE linkid NOT IN(" . implode(', ', $idlimit) . ")")
	);

	if (!empty($idlimit))
	{
		$links = $db->query_read("
			SELECT linkid, lastpostid, lastpostdateline, lastpostuserid, lastpostusername, posts
			FROM " . TABLE_PREFIX . "adv_links
			WHERE linkid IN(" . implode(',', $idlimit) . ")
		");
		while ($link = $db->fetch_array($links))
		{
			$posts = $db->query_first("
				SELECT postid, userid, dateline, username
				FROM " . TABLE_PREFIX . "adv_links_posts
				WHERE linkid = $link[linkid]
					AND visible = 1
				ORDER BY dateline DESC
			");

			$pcount = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_links_posts WHERE linkid = $link[linkid] AND visible = 1");

			if (($link['lastpostdateline'] != $posts['dateline'] AND $posts['dateline'])
				OR $link['lastpostid'] != $posts['postid']
				OR $link['posts'] != $pcount['count']
				OR $link['lastpostusername'] != $posts['username']
			)
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_links SET
						posts = '$pcount[count]',
						lastpostid = '$posts[postid]',
						lastpostdateline = '$posts[dateline]',
						lastpostuserid = '$posts[userid]',
						lastpostusername = '" . $db->escape_string($posts['username']) . "'
					WHERE linkid = $link[linkid]
				");
			}
			unset($posts);
		}
	}

	define('CP_REDIRECT', 'vba_links_admin.php?do=maintenance');
	print_stop_message('adv_links_updated_counters');
}

// ##### Find Broken Links ####################################################
if ($_REQUEST['do'] == 'checkstatus')
{
	require_once(DIR . '/includes/functions_vba_links_savelink.php');

	$page = intval($_REQUEST['page']);

	$maxlink = $db->query_first("SELECT COUNT(*) AS count, MAX(linkid) AS linkid FROM " . TABLE_PREFIX . "adv_links " . iif($report['type'] == 'linkrecipurl', "WHERE linkrecipurl != ''"));

	if (!$perpage)
	{
		$perpage = 25;
	}

	$report = $db->query_first("SELECT data, lastlinkid, checkagain, type FROM " . TABLE_PREFIX . "adv_links_reports WHERE repid = $repid");
	$report['data'] = unserialize($report['data']);

	if ($report['checkagain'])
	{
		// Double check it incase there was a timeout issue
		$report['lastlinkid'] = $report['lastlinkid'] - 1;
	}

	$checkcnt = sizeof($report['data']);

	if ($checkcnt)
	{
		echo construct_phrase($vbphrase['x_percent_complete'], number_format(($checkcnt / $maxlink['count']) * 100)) . '<br /><br />';
	}

	echo '<div>' . construct_link_code($vbphrase['click_here_if_stuck'], 'vba_links_admin.php?do=checkstatus&amp;repid=' . $repid . '&perpage=' . $perpage) . '</div><br />';

	$getlinks = $db->query("
		SELECT linkid, name, linkurl, linkrecipurl
		FROM " . TABLE_PREFIX . "adv_links
		WHERE linkid > $report[lastlinkid] " . iif($report['type'] == 'linkrecipurl', " AND linkrecipurl != ''") . "
		ORDER BY linkid
		LIMIT $perpage
	");
	while ($link = $db->fetch_array($getlinks))
	{
		$report['data'][$link['linkid']] = 1;
		// Update with the last linkid now incase it gets stuck
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links_reports SET
				lastlinkid = $link[linkid],
				data = '" . $db->escape_string(serialize($report['data'])) . "',
				checkagain = " . iif($report['checkagain'], 0, 1) . "
			WHERE repid = $repid
		");

		echo construct_phrase($vbphrase['checking_link_x'], $link['name']);
		vbflush();

		$lastlink = $link['linkid'];

		// Reciprocal URL's
		if ($report['type'] == 'linkrecipurl')
		{
			$checkit = check_for_recip_link($checkurl);

			if ($checkit === 'invalid' OR $checkit === 'nomatch')
			{
				$status['code'] = 404;
			}
			else
			{
				$status['code'] = 200;
			}
		}
		// Broken links
		else
		{
			$status = check_url_status($link['linkurl']);
		}

		if (!$status['code'])
		{
			$status['code'] = 1;
		}
		$report['data'][$link['linkid']] = $status['code'];

		echo ' <span style="color:' . $status_array[$status['code']]['color'] . '">' . $status_array[$status['code']]['text'] . '</span><br />';

		$report['checkagain'] = 0;
	}

	// All done, so redirect to the report
	if ($maxlink['linkid'] == $lastlink)
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links_reports SET
				data = '" . $db->escape_string(serialize($report['data'])) . "',
				endtime = " . TIMENOW . "
			WHERE repid = $repid
		");

		print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewlinks&repid=' . $repid);
	}
	else
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links_reports SET
				data = '" . $db->escape_string(serialize($report['data'])) . "',
				checkagain = 0
			WHERE repid = $repid
		");

		print_cp_redirect('vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=checkstatus&page=' . ($page + 1) . '&repid=' . $repid . '&perpage=' . $perpage, 0);
	}
}

// ##### View Reports #########################################################
if ($_REQUEST['do'] == 'statusreports')
{

	print_form_header('vba_links_admin', 'checkstatus');
	print_table_header($vbphrase['generate_new_report']);
	print_description_row($vbphrase['generate_report_note']);
	print_select_row($vbphrase['check_for'], 'type', array('linkurl' => $vbphrase['broken_problematic_links'], 'linkrecipurl' => $vbphrase['reciprocal_links']));
	print_select_row($vbphrase['number_of_links_to_process'], 'perpage', array(10 => 10, 25 => 25, 50 => 50, 100 => 100), 25);
	print_submit_row($vbphrase['generate_report'], '');
	print_table_break();

	print_table_header($vbphrase['status_reports'], 3);

	$reports = $db->query("SELECT * FROM " . TABLE_PREFIX . "adv_links_reports ORDER BY dateline DESC");
	if ($db->num_rows($reports))
	{
		print_cells_row(array($vbphrase['id'], $vbphrase['date'], $vbphrase['controls']), true, false, -2);
		while ($report = $db->fetch_array($reports))
		{
			$cell = array();

			$cell[] = '(' . $report['repid'] . ')';

			$cell[] = vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $report['dateline']) . iif(!$report['endtime'], ' (' . $vbphrase['incomplete'] . ')');

			$cell[] = construct_link_code($vbphrase['view'], 'vba_links_admin.php?do=viewlinks&amp;repid=' . $report['repid']) . ' - ' .
				construct_link_code($vbphrase['delete'], 'vba_links_admin.php?do=deletereport&amp;repid=' . $report['repid']);

			print_cells_row($cell, false, false, -2);
		}
	}
	else
	{
		print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['status_reports']), '', 3);
	}

	print_table_footer();
}

// ##### Delete Report ########################################################
if ($_REQUEST['do'] == 'deletereport')
{
	print_form_header('vba_links_admin', 'dodeletereport');
	construct_hidden_code('repid', intval($_REQUEST['repid']));
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_this_report']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Delete Report #####################################################
if ($_POST['do'] == 'dodeletereport')
{
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_reports WHERE repid = " . intval($_REQUEST['repid']));
	print_cp_redirect('vba_links_admin.php?do=statusreports');
}

// ##### Compare Reports ######################################################
if ($_REQUEST['do'] == 'comparereports')
{
	$linkid = intval($_REQUEST['linkid']);
	$type = $_REQUEST['type'];

	$link = $db->query_first("SELECT linkid, name, linkurl FROM " . TABLE_PREFIX . "adv_links WHERE linkid = $linkid");

	print_form_header('vba_links_admin', 'closebox');
	print_table_header('<span style="float:' . $stylevar['right'] . '">(<a href="' . $link['linkurl'] . '" target="_blank">' . $link['linkurl'] . '</a>)</span><span style="float:' . $stylevar['left'] . '">' . $vbphrase['status_reports'] . ' &raquo; ' . iif($type == 'linkrecipurl', $vbphrase['reciprocal_links'], $vbphrase['broken_problematic_links']) . ' &raquo; ' . $link['name'] . '</span>');

	$reports = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_reports WHERE type = '" . $db->escape_string($_REQUEST['type']) . "' ORDER BY dateline DESC");
	while ($report = $db->fetch_array($reports))
	{
		$report['data'] = unserialize($report['data']);

		print_label_row(
			vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $report['dateline']),
			iif($report['data'][$linkid], '<span style="color:' . $status_array[$report['data'][$linkid]]['color'] . '">' . $status_array[$report['data'][$linkid]]['text'] . '</span>', $vbphrase['no_data'])
		);
	}

	print_submit_row($vbphrase['close'], '');
}

// ##### Edit Link to Us Page #################################################
if ($_REQUEST['do'] == 'linktous')
{
	print_form_header('vba_links_admin', 'addbanner');
	print_table_header($vbphrase['edit_link_to_us_page_banners'], 5);
	print_description_row($vbphrase['to_further_customize_page'], '', 5);
	print_cells_row(array($vbphrase['display_order'], $vbphrase['title'], $vbphrase['dimensions'], $vbphrase['filesize'], $vbphrase['options']), 1, '', -1);

	$getbanners = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_banners ORDER BY displayorder");
	if ($db->num_rows($getbanners))
	{
		while ($banner = $db->fetch_array($getbanners))
		{
			$cell = array();
			$cell[] = $banner['displayorder'];
			$cell[] = construct_link_code(iif($banner['title'], $banner['title'], $banner['filename']), 'vba_links_admin.php?do=editbanner&amp;bannerid=' . $banner['bannerid']);
			$cell[] = $banner['width'] . ' x ' . $banner['height'];
			$cell[] = fetch_rfilesize($banner['filesize']);
			$cell[] = construct_link_code($vbphrase['edit'], 'vba_links_admin.php?do=editbanner&amp;bannerid=' . $banner['bannerid']) . ' ' . construct_link_code($vbphrase['delete'], 'vba_links_admin.php?do=deletebanner&amp;bannerid=' . $banner['bannerid']);

			print_cells_row($cell, '', '', -1);
		}
	}
	else
	{
		print_description_row($vbphrase['no_banners_currently_uploaded'], '', 5);
	}

	print_submit_row($vbphrase['add_banner'], '', 5);
}

// ##### Add banner ###########################################################
if ($_REQUEST['do'] == 'addbanner')
{
	print_form_header('vba_links_admin', 'doaddbanner', true);
	print_table_header($vbphrase['add_banner']);
	print_input_row($vbphrase['title'], 'baninfo[title]');
	print_upload_row($vbphrase['banner_image'], 'banner');
	print_input_row($vbphrase['display_order'], 'baninfo[displayorder]');
	print_submit_row();
}

// ##### Edit banner ##########################################################
if ($_REQUEST['do'] == 'editbanner')
{
	$banner = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links_banners WHERE bannerid = " . intval($_REQUEST['bannerid']));

	print_form_header('vba_links_admin', 'doeditbanner', true);
	construct_hidden_code('bannerid', $banner['bannerid']);
	construct_hidden_code('currentfile', $banner['filename']);

	print_table_header($vbphrase['edit_banner'] . ': ' . $banner['filename']);
	print_input_row($vbphrase['title'], 'baninfo[title]', $banner['title']);
	print_label_row($vbphrase['current_image'], '<img src="' . $vba_options['links_uploadurl'] . '/' . $banner['filename'] . '" width="' . $banner['width'] . '" height="' . $banner['height'] . '" alt="" />');
	print_upload_row($vbphrase['banner_image'], 'banner');
	print_input_row($vbphrase['display_order'], 'baninfo[displayorder]', $banner['displayorder']);
	print_submit_row();
}

// ##### Do Add Banner ########################################################
if ($_POST['do'] == 'doaddbanner' OR $_POST['do'] == 'doeditbanner')
{
	$banner = $_FILES['banner'];
	$baninfo = $vbulletin->input->clean_gpc('p', 'baninfo', TYPE_ARRAY);
	$currentfile = $vbulletin->input->clean_gpc('p', 'currentfile', TYPE_STR);

	if (!$banner['tmp_name'] AND $_POST['do'] == 'doeditbanner')
	{
		$banner['name'] = $currentfile;
	}

	if (!$banner['tmp_name'] AND $_POST['do'] == 'doaddbanner')
	{
		print_stop_message('there_has_been_an_error_in_the_upload');
	}

	if (!is_writable($vba_options['links_uploaddir']))
	{
		print_stop_message('adv_links_upload_dir_not_writable');
	}

	$baninfo['filename'] = preg_replace("/[^a-z_.0-9-]/i", '', $banner['name']);

	$banlocation = $vba_options['links_uploaddir'] . '/' . $baninfo['filename'];

	if (file_exists($banlocation) AND ($baninfo['filename'] != $currentfile OR $_POST['do'] == 'doaddbanner'))
	{
		print_stop_message('adv_links_duplicate_filename', $baninfo['filename']);
	}

	@move_uploaded_file($banner['tmp_name'], $banlocation);
	@chmod($banlocation, 0777);

	$bandata = getimagesize($banlocation);
	$baninfo['width'] = $bandata[0];
	$baninfo['height'] = $bandata[1];

	$baninfo['filesize'] = filesize($banlocation);

	$db->query_write(fetch_query_sql($baninfo, 'adv_links_banners', iif($_POST['do'] == 'doeditbanner', 'WHERE bannerid = ' . intval($_POST['bannerid']))));

	print_cp_redirect('vba_links_admin.php?do=linktous');
}

// ##### Delete Banner ########################################################
if ($_REQUEST['do'] == 'deletebanner')
{
	print_form_header('vba_links_admin', 'dodeletebanner');
	construct_hidden_code('bannerid', intval($_REQUEST['bannerid']));
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_this_banner']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Delete Banner #####################################################
if ($_POST['do'] == 'dodeletebanner')
{
	$banner = $db->query_first("SELECT bannerid, filename FROM " . TABLE_PREFIX . "adv_links_banners WHERE bannerid = " . intval($_POST['bannerid']));

	@unlink($vba_options['links_uploaddir'] . '/' . $banner['filename']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_banners WHERE bannerid = '$banner[bannerid]'");
	print_cp_redirect('vba_links_admin.php?do=linktous');
}

// ##### Rebuild Parent Lists #################################################
if ($_REQUEST['do'] == 'rebuildparents')
{
	echo 'Parents Rebuilt.';
	rebuild_parents();
}

// ##### Update Category Cache ###############################################
if ($_REQUEST['do'] == 'updatecache')
{
	echo 'Category cache updated.';
	update_category_cache();
}

print_cp_footer();

?>