<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$phrasegroups = array('style');

$scriptname = 'Links Directory';
$scriptfile = 'vbalinks_install';

require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_language.php');
require_once(DIR . '/includes/adminfunctions_vba_links.php');
require_once(DIR . '/includes/functions_vba_links.php');
require_once(DIR . '/includes/functions_vba_links_cats.php');


define('PRODUCT_CODE', 'adv_links');

print_cp_header('vBadvanced ' . $scriptname . ' Install');

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'install';
}

// ##### Check version
if (!in_array(substr($vbulletin->options['templateversion'], 0, 3), array(3.6, 3.7)))
{
	echo 'It appears that you are trying to install the vBulletin 3.6 version of vBadvanced ' . $scriptname . ' on an older version of vBulletin.<br />Please go back to vbadvanced.com and download the version of vBadvanced ' . $scriptname . ' that corresponds to your version of vBulletin, or upgrade to vBulletin 3.6 before proceeding.';
	exit;
}

if (!is_object($db))
{
	echo 'It appears that you are trying to install the vBulletin 3.6 version of vBadvanced ' . $scriptname . ' on a vBulletin 3.0 forum.<br />Please go back to vbadvanced.com and download the version for vBulletin 3.0.';
	exit;
}

// ##################### Delete Template Function #####################
function kill_template($title, $printphrase = 0)
{
	global $db;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title = '$title'");

	return '<div class="smallfont">Removed template ' . $title . '</div>';
}

// ##### Insert all templates #################################################
function insert_all_templates()
{
	global $maintemplates, $db;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("', '", array_keys($maintemplates)) . "') AND styleid = '-1'");

	foreach ($maintemplates AS $name => $content)
	{
		$tempinsert .= "(
			'$name',
			'" . $db->escape_string(compile_template($content)) . "',
			'" . $db->escape_string($content) ."',
			'-1',
			'template',
			" . TIMENOW . ",
			'vBadvanced',
			'$version',
			'" . PRODUCT_CODE . "'
		),";
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "template
			(title, template, template_un, styleid, templatetype, dateline, username, version, product)
		VALUES
			" . substr($tempinsert, 0, strlen($tempinsert) - 1)
	);

}


// ##################### Insert Settings Function #####################
function insert_setting()
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$checksetting = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");

	if ($checksetting['varname'])
	{
		return false;
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES (
			'$varname',
			'" . $grouptitle . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['defaultvalue']) . "',
			'" . $db->escape_string($setting['optioncode']) . "',
			" . $setting['displayorder'] . ",
			'$setting[serialize]'
	)");

	$phrasetypeid = 'vbsettings';

	// Title phrase
	insert_phrase('setting_' . $varname . '_title', $setting['title']);

	// Description phrase
	insert_phrase('setting_' . $varname . '_desc', $setting['description']);

	return '<div class="smallfont">Added Setting - ' . $title . '</div>';

}

// ##################### Update Settings Function #####################
function update_setting()
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET
			defaultvalue = '" . $db->escape_string($setting['defaultvalue']) . "',
			optioncode = '" . $db->escape_string($setting['optioncode']) . "',
			displayorder = $setting[displayorder],
			grouptitle = '$grouptitle',
			serialize = '$setting[serialize]'
		WHERE varname = '$varname'
	");

	return '<div>Updated Setting - ' . $varname . '</div>';
}

// ##################### Delete Setting Function #####################
function kill_setting($title, $printphrase = 0)
{
	global $db;

	if ($varname == 'adv_global')
	{
		return;
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$title'");

	kill_phrase('setting_" . $title . "_title');
	kill_phrase('setting_" . $title . "_desc');

	return '<div class="smallfont">Removed Setting - ' . $title . '</div>';
}

// ##### Insert Phrase Function ###############################################
function insert_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $phrasetypeid, $varname, $text, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	kill_phrase();

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	return '<div class="smallfont">Added Phrase - ' . $varname . '</div>';
}

// ##### Update Phrase Function ###############################################
function update_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $varname, $text, $phrasetypeid, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	// Insert first, just to make sure it's really there
	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($text) ."',
			dateline = " . TIMENOW . ",
			version = '$version',
			username = 'vBadvanced'
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Updated Phrase - ' . $varname . '</div>';
}

// ##################### Delete Phrase Function #####################
function kill_phrase($forcevarname = '')
{
	global $db, $varname, $phrasetypeid;

	if ($forcevarname)
	{
		$varname = $forcevarname;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "phrase
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Removed phrase ' . $varname . '</div>';
}

// ##### Complete Phrase Insert/Delete ########################################
function insert_all_phrases()
{
	global $db, $mainphrases, $mainsettings, $version;

	// Settings phrases
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		foreach ($settings AS $varname => $setting)
		{
			$mainphrases['vbsettings']['setting_' . $varname . '_title'] = $setting['title'];
			$mainphrases['vbsettings']['setting_' . $varname . '_desc'] = $setting['description'];
		}
	}

	// Main phrases
	foreach ($mainphrases AS $fieldname => $phrases)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE fieldname = '$fieldname'
				" . iif(substr($fieldname, 0, 9) != 'adv_links',
					"AND varname IN('" . implode("','", array_keys($phrases)) . "')"
				) . "
				AND languageid = '-1'
		");

		$insertquery = '';
		foreach ($phrases AS $varname => $text)
		{
			$insertquery .= "('-1', '$varname', '" . $db->escape_string($text) . "', '$fieldname', '" . PRODUCT_CODE . "', 'vBadvanced', " . TIMENOW . ", '$version'),";
		}

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product, username, dateline, version)
			VALUES
				" . substr($insertquery, 0, strlen($insertquery) - 1)
		);
	}

	build_language(-1);

}

// ########################### Start Install Table ############################
function print_install_table_start($title = '', $reqdo = '')
{
	global $scriptfile, $scriptname;

	if ($reqdo)
	{
		print_form_header($scriptfile, $reqdo);
	}
	else
	{
		echo '<form action="' . $scriptfile . '.php" method="post"><input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';
		print_table_start();
	}

	if (!$title)
	{
		$title = 'vBadvanced ' . $scriptname . ' Install';
	}

	print_table_header($title);
}

// ############################ End Install Table #############################
function print_install_table_end()
{
	global $stepphrase, $scriptname, $step, $nextstep, $nextdo, $rebuildtemp;

	print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');

	if (!$step)
	{
		print_radio_row('', 'do',
			array(
				'install' => 'Begin the installation process.',
				'upgrade' => 'Upgrade.',
				'install_templates' => 'Reinstall the templates.',
				'install_phrases' => 'Reinstall the phrases.',
				'doimages' => 'Update your image paths.',
				'uninstall' => 'Uninstall vBadvanced ' . $scriptname . '.'
			),
			'install'
		);
	}

	construct_hidden_code('step', iif($nextstep, $nextstep, $step + 1));

	if ($nextdo)
	{
		construct_hidden_code('do', $nextdo);
	}

	print_table_break();

	if ($rebuildtemp)
	{
		build_all_styles(0, 0);
	}

	if ($step == 'finished')
	{
		print_table_footer();
	}
	else
	{
		print_submit_row('Continue', '');
	}
}

// ##### Insert Plugins #######################################################
function insert_plugins()
{
	global $db, $vba_plugins;

	foreach ($vba_plugins AS $devkey => $plugin)
	{
		$plugin['devkey'] = $devkey;

		if (!$plugin['product'])
		{
			$plugin['product'] = PRODUCT_CODE;
		}
		$plugin['active'] = 1;

		$plugcheck = $db->query_first("SELECT devkey FROM " . TABLE_PREFIX . "plugin WHERE devkey = '$devkey'");

		$db->query_write(fetch_query_sql($plugin, 'plugin', iif($plugcheck['devkey'], "WHERE devkey = '$devkey'", '')));
	}

	vBulletinHook::build_datastore($db);
}

// ##### See if plugins are active ############################################
if (!$vbulletin->options['enablehooks'])
{
	print_install_table_start();

	$stepphrase = '<b>Warning:</b> Plugins are currently globally disabled in your options. In order for plugins and products to function correctly, you must <a href="options.php?do=options&amp;dogroup=plugin" target="_blank">enable the plugin system</a>.';

	$_REQUEST['do'] = 'nohooks';
	$nextdo = 'installstart';

	print_install_table_end();
	exit;
}


// ########################## Main Templates Array ############################
$maintemplates = array(
'ADV_LINKS' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title]</title>
$headinclude
</head>
<body>

<script type="text/javascript">
<!--
function rate(linkid)
{
	window.open("newreply.php?do=ratelink&linkid="+linkid, "rate", "toolbar=no, scrollbars=no, resizable=yes, width=320, height=140");
}
-->
</script>

$header

$navbar

$linksnav

<if condition="$show[\'subdirs\']">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%">$vbphrase[sub_categories]: $navinfo[title]</td>

			<if condition="$show[\'searchlinks\']">
				<td class="vbmenu_control" id="dirsearch"><a href="search.php?$session[sessionurl]catid=$catid" rel="nofollow">$vbphrase[search_this_category]</a> <script type="text/javascript"> vbmenu_register("dirsearch"); </script></td>
			</if>
		</tr>
	</table>

	<div class="vbmenu_popup" id="dirsearch_menu" style="display:none">
		<form action="search.php" method="post">
			<input name="s" type="hidden" value="$session[sessionhash]" />
			<input name="do" type="hidden" value="searchresults" />
			<input name="quicksearch" type="hidden" value="1" />
			<input name="catids[]" type="hidden" value="$catid" />
			<table border="0" cellpadding="4" cellspacing="1">
				<tr>
					<td class="thead">$vbphrase[search_this_category]</td>
				</tr>
				<tr>
					<td class="vbmenu_option" title="nohilite">
						<input class="bginput" name="string" size="20" type="text" /> $gobutton</td>
				</tr>
				<tr>
					<td class="vbmenu_option"><a href="search.php?$session[sessionurl]catid=$catid" rel="nofollow">$vbphrase[advanced_search]</a></td>
				</tr>
			</table>
		</form>
	</div>

</if>

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<thead>
		<tr>
			<td class="thead" width="4%">&nbsp;</td>
			<td align="$stylevar[left]" class="thead" width="100%">$vbphrase[category_description]</td>
			<td align="center" class="thead" nowrap="nowrap">$vbphrase[last_link]</td>

			<if condition="$vba_options[\'links_allowreplies\']">
				<td align="center" class="thead" nowrap="nowrap">$vbphrase[last_reply]</td>
			</if>

			<td align="center" class="thead">$vbphrase[links]</td>
			<if condition="$vba_options[\'links_allowreplies\']">
				<td align="center" class="thead">$vbphrase[replies]</td>
			</if>
			<if condition="$show[\'modcolumn\']">
				<td align="center" class="thead">$vbphrase[moderator]</td>
			</if>

		</tr>
	</thead>
		$categorybits
	</tbody>
</table>
<br />

<if condition="$show[\'stats\']">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="2"><a href="#top" onclick="return toggle_collapse(\'links_statistics\')" style="float:right"><img alt="" border="0" id="collapseimg_links_statistics" src="$stylevar[imgdir_button]/collapse_tcat$vbcollapse[collapseimg_links_statistics].gif" /></a><phrase 1="$vba_options[links_title]">$vbphrase[x_statistics]</phrase></td>
			</tr>
		</thead>
		<tbody id="collapseobj_links_statistics" style="$vbcollapse[collapseobj_links_statistics]">
			<tr>
				<td class="alt2"><img alt="<phrase 1="$vba_options[links_title]">$vbphrase[x_statistics]</phrase>" src="$stylevar[imgdir_misc]/stats.gif" /></td>
				<td class="alt1" width="100%">$vbphrase[categories]: $stats[categories], $vbphrase[links]: $stats[links], $vbphrase[posts]: $stats[posts], $vbphrase[total_views] $stats[views]</td>
			</tr>
		</tbody>
	</table>
	<br />
</if>

<if condition="$show[\'newlinks\']">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="6"><a href="#top" onclick="return toggle_collapse(\'newlinks\')" style="float:right"><img alt="" border="0" id="collapseimg_newlinks" src="$stylevar[imgdir_button]/collapse_tcat$vbcollapse[collapseimg_newlinks].gif" /></a><phrase 1="$vba_options[links_newonhome]">$vbphrase[newest_x_links]</phrase></td>
			</tr>
		</thead>
		<tbody id="collapseobj_newlinks" style="$vbcollapse[collapseobj_newlinks]">
			<tr>
				<td class="thead" width="2%">&nbsp;</td>
				<td align="$stylevar[left]" class="thead"><span style="float:$stylevar[right]">$vbphrase[rating]
				</span>$vbphrase[link_name_description]</td>

				<td align="center" class="thead" nowrap="nowrap" width="15%">
					<if condition="$vba_options[\'links_allowreplies\']">
						$vbphrase[last_reply]
					<else />
						$vbphrase[last_updated]
					</if>
				</td>

				<if condition="$vba_options[\'links_allowreplies\']">
					<td align="center" class="thead" nowrap="nowrap" width="5%">$vbphrase[replies]</td>
				</if>

				<td align="center" class="thead" nowrap="nowrap" width="5%">$vbphrase[views]</td>

				<td align="center" class="thead" nowrap="nowrap" width="15%">$vbphrase[category]</td>

			</tr>

			$newlinkbits
		</tbody>
	</table>
	<br />
</if>

<if condition="$show[\'randomlinks\']">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="6"><a href="#top" onclick="return toggle_collapse(\'randlinks\')" style="float:right"><img alt="" border="0" id="collapseimg_randlinks" src="$stylevar[imgdir_button]/collapse_tcat$vbcollapse[collapseimg_randlinks].gif" /></a>$vbphrase[random_links]</td>
			</tr>
		</thead>
		<tbody id="collapseobj_randlinks" style="$vbcollapse[collapseobj_randlinks]">
			<tr>
				<td class="thead" width="2%">&nbsp;</td>
				<td align="$stylevar[left]" class="thead"><span style="float:$stylevar[right]">$vbphrase[rating]</span>$vbphrase[link_name_description]</td>

				<td align="center" class="thead" nowrap="nowrap" width="15%">
					<if condition="$vba_options[\'links_allowreplies\']">
						$vbphrase[last_reply]
					<else />
						$vbphrase[last_updated]
					</if>
				</td>

				<if condition="$vba_options[\'links_allowreplies\']">
					<td align="center" class="thead" nowrap="nowrap" width="5%">$vbphrase[replies]</td>
				</if>

				<td align="center" class="thead" nowrap="nowrap" width="5%">$vbphrase[views]</td>

				<td align="center" class="thead" nowrap="nowrap" width="15%">$vbphrase[category]</td>

			</tr>

			$randomlinkbits
		</tbody>
	</table>
	<br />
</if>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr>
		<td width="100%">
			<table cellpadding="2" cellspacing="0" width="100%">
				<tr valign="bottom">
					<td align="left" class="smallfont"><img alt="" class="inlineimg" src="$stylevar[imgdir_statusicon]/forum_new.gif" title="$vbphrase[category_contains_new_links]" /> $vbphrase[category_contains_new_links]</td>
				</tr>
				<tr>
					<td class="smallfont"><img alt="" class="inlineimg" src="$stylevar[imgdir_statusicon]/forum_old.gif" title="$vbphrase[category_contains_no_new_links]" /> $vbphrase[category_contains_no_new_links]</td>
				</tr>
			</table>
		</td>
		<td>$categoryjump</td>
	</tr>
</table>

$footer
</body>
</html>',


'adv_links_addlink_custombits' =>
'<fieldset class="fieldset"><legend>$field[title]</legend>
	<div style="padding:$stylevar[formspacer]px">
									$field[description]<br />
	$inputbox

	</div>
</fieldset>
',


'ADV_LINKS_ADD_EDIT' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - <if condition="$show[\'editlink\']">$vbphrase[edit_link]<else />$vbphrase[submit_a_link]</if></title>
$headinclude
</head>
<body>

$header

$navbar

$linksnav

$linkerrors

$deleteoption

<form action="addlink.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="<if condition="$show[\'editlink\']">doeditlink<else />doaddlink</if>" />

	<if condition="$show[\'editlink\']">
		<input name="linkid" type="hidden" value="$link[linkid]" />
		<input name="link[oldcatid]" type="hidden" value="$link[catid]" />
	</if>

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="2"><b><if condition="$show[\'editlink\']">$vbphrase[edit_link]<else />$vbphrase[submit_a_link]</if></b>: <span class="smallfont">$link[linkurl]</span></td>
			</tr>
		</thead>

		<tbody>
			<tr>
				<td align="center" class="panelsurround">
					<div class="panel">
						<div align="$stylevar[left]" style="width:$stylevar[formwidth]">

							<fieldset class="fieldset"><legend>$vbphrase[website_name]</legend>
								<div style="padding:$stylevar[formspacer]px">
									$vbphrase[please_enter_name_of_site]<br />
									<input type="text" class="bginput" name="link[name]" size="40" value="$link[name]" />
								</div>
							</fieldset>

							<if condition="$show[\'editlink\'] OR $haderrors">
								<fieldset class="fieldset"><legend>$vbphrase[url]</legend>
									<div style="padding:$stylevar[formspacer]px">
										$vbphrase[enter_url_for_website]<br />
										<input type="text" class="bginput" name="link[linkurl]" value="$link[linkurl]" size="40" />
									</div>
								</fieldset>
							<else />
								<input type="hidden" name="link[linkurl]" value="$link[linkurl]" />
							</if>

							<if condition="$vba_options[\'links_recipcheck\']">
								<fieldset class="fieldset"><legend>$vbphrase[reciprocal_link_url]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<if condition="$vba_options[\'links_recipcheck\'] == 2">$vbphrase[reciprocal_link_url_desc_require]<else />$vbphrase[reciprocal_link_url_desc_optional]</if><br />
										<input class="bginput" name="link[linkrecipurl]" size="40" type="text" value="$link[linkrecipurl]" />
									</div>
								</fieldset>
							</if>

							<if condition="$show[\'editlink\']">
								<fieldset class="fieldset"><legend>$vbphrase[category]:</legend>
									<div style="padding:$stylevar[formspacer]px">
										$vbphrase[select_category_for_website]<br />
										<select name="link[catid]" size="1">
										<option value="0">$vbphrase[please_choose_a_category]</option>
										$options
										</select>
									</div>
								</fieldset>
							<else />
								<input type="hidden" name="link[catid]" value="$link[catid]" />
							</if>

							<fieldset class="fieldset"><legend>$vbphrase[description]</legend>
								<div style="padding:$stylevar[formspacer]px">
									$vbphrase[enter_description_for_website]<br />
									<textarea cols="40" class="bginput" name="link[description]" rows="6">$link[description]</textarea>
								</div>
							</fieldset>

							<fieldset class="fieldset"><legend>$vbphrase[keywords]</legend>
								<div style="padding:$stylevar[formspacer]px">
									$vbphrase[enter_keywords_for_website]<br />
									<input class="bginput" name="link[keywords]" size="40" type="text" value="$link[keywords]" />
								</div>
							</fieldset>

							<if condition="$show[\'linknotes\']">
								<fieldset class="fieldset"><legend>$vbphrase[link_notes]</legend>
									<div style="padding:$stylevar[formspacer]px">
										$vbphrase[enter_notes_for_website]<br />
										<input class="bginput" name="link[notes]" size="40" type="text" value="$link[notes]" />
									</div>
								</fieldset>
							</if>

							$customfieldbits

							<if condition="($vba_options[\'links_allowfav\'] OR $vba_options[\'links_allowsubscribe\']) AND !$show[\'guest\'] AND !$show[\'editlink\']">
								<fieldset class="fieldset"><legend>$vbphrase[additional_options]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<if condition="$vba_options[\'links_allowsubscribe\']">
											<label for="cb_subscribe"><input id="cb_subscribe" type="checkbox" name="linkoptions[subscribe]" value="1" $checked[subscribe] /> $vbphrase[subscribe_to_link]</label><br />
										</if>
										<if condition="$vba_options[\'links_allowfav\']">
											<label for="cb_favorites"><input id="cb_favorites" type="checkbox" name="linkoptions[favorite]" value="1" $checked[favorite] /> $vbphrase[add_to_favorites]</label>
										</if>
									</div>
								</fieldset>
							</if>

							$imagereg

						</div>
					</div>
					<div style="padding-top:6px"><input class="button" type="submit" value="<if condition="$show[\'editlink\']">$vbphrase[save_changes]<else />$vbphrase[submit]</if>" /> <input class="button" type="reset" value="$vbphrase[reset_fields]" />
					</div>
				</td>
			</tr>
		</tbody>
	</table>
</form>

<br />

$footer
</body>
</html>',


'ADV_LINKS_ADD_START' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[submit_a_link]</title>
$headinclude
</head>
<body>

$header

$navbar

$linksnav

$linkerrors

<form action="addlink.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="addlink" />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="2">$vbphrase[submit_a_link]</td>
			</tr>
		</thead>

		<tbody>
			<tr>
				<td align="center" class="panelsurround">
					<div class="panel">
						<div align="$stylevar[left]" style="width:$stylevar[formwidth]">
							<fieldset class="fieldset"><legend>$vbphrase[url]</legend>
								<div style="padding:$stylevar[formspacer]px">
									$vbphrase[enter_url_for_website]<br />
									<input type="text" class="bginput" name="link[linkurl]" value="<if condition="$show[\'editlink\'] OR $errors">$link[linkurl]<else />http://</if>" size="40" />
								</div>
							</fieldset>

							<fieldset class="fieldset"><legend>$vbphrase[category]:</legend>
								<div style="padding:$stylevar[formspacer]px">
									$vbphrase[select_category_for_website]<br />
									<select name="link[catid]" size="1">
									<option value="0">$vbphrase[please_choose_a_category]</option>
									$options
									</select><if condition="$addcatlink"> [<a href="managecats.php?$session[sessionurl]do=addcat" rel="nofollow"><if condition="$moderatecats">$vbphrase[suggest_new_category]<else />$vbphrase[add_category]</if></a>]</if>
								</div>
							</fieldset>

						</div>
					</div>
					<div style="padding-top:6px"><input class="button" type="submit" value="<if condition="$show[\'editlink\']">$vbphrase[save_changes]<else />$vbphrase[submit]</if>" /> <input class="button" type="reset" value="$vbphrase[reset_fields]" />
					</div>
				</td>
			</tr>
		</tbody>
	</table>
</form>

<br />

$footer
</body>
</html>',


'ADV_LINKS_BROWSELINKS' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$catinfo[title] - $vba_options[links_title]</title>
$headinclude
</head>
<body>

<script type="text/javascript">
function rate(linkid)
{
	window.open("newreply.php?do=ratelink&linkid="+linkid, "rate", "toolbar=no, scrollbars=no, resizable=yes, width=320, height=140");
}
</script>

$header
$navbar

$linksnav

<if condition="$show[\'subcats\']">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%">$vbphrase[sub_categories]: $catinfo[title]</td>
		</tr>
	</table>

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="thead" width="4%">&nbsp;</td>
			<td align="$stylevar[left]" class="thead" width="100%">$vbphrase[category_description]</td>
			<td align="center" class="thead" nowrap="nowrap">$vbphrase[last_link]</td>

			<if condition="$vba_options[\'links_allowreplies\']">
				<td align="center" nowrap="nowrap" class="thead">$vbphrase[last_reply]</td>
			</if>

			<td align="center" class="thead">$vbphrase[links]</td>
			<if condition="$vba_options[\'links_allowreplies\']">
				<td align="center" class="thead">$vbphrase[replies]</td>
			</if>
			<if condition="$show[\'modcolumn\']">
				<td align="center" class="thead">$vbphrase[moderator]</td>
			</if>

		</tr>

	$subcatbits

	</table>
	<br />
</if>

<if condition="$letterbits">
<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		$letterbits
	</tr>
</table>
<br />
</if>

<div align="$stylevar[right]" style="padding-bottom:3px">$pagenav</div>

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		<td class="tcat" width="100%" id="orderby">

		<if condition="$_REQUEST[\'do\'] == \'poplinks\'">
			<a href="browselinks.php?$session[sessionurl]do=poplinks"><phrase 1="$vba_options[links_poplinklimit]">$catinfo[title]</phrase></a> <if condition="$vba_options[\'links_allowreplies\'] OR $vba_options[\'links_allowrating\']"><script type="text/javascript"> vbmenu_register("orderby"); </script></if>
		</if>

		<if condition="$_REQUEST[\'do\'] == \'browselinks\' OR $_REQUEST[\'do\'] == \'favorites\' OR $_REQUEST[\'do\'] == \'member\' OR $_REQUEST[\'do\'] == \'subscriptions\'">
			$vbphrase[links_in_category]: <span class="normal">$catinfo[title]</span>
		<else />
			<if condition="$_REQUEST[\'do\'] != \'poplinks\'">$catinfo[title]</if>
		</if>

		<if condition="$_REQUEST[\'do\'] == \'searchresults\'">
			: <span class="smallfont"><if condition="$search[\'string\']"><span class="smallfont">$vbphrase[key_words]: $keywords</span></if> <if condition="$search[\'string\'] AND $search[\'username\']">; </if> <if condition="$search[\'username\']">$vbphrase[posts_made_by]: $search[usernames]</span></if>
		</if>

		<if condition="$_REQUEST[\'do\'] == \'searchresults\' OR $_REQUEST[\'do\'] == \'newlinks\' OR $_REQUEST[\'do\'] == \'newposts\'">
			<td align="$stylevar[right]" class="tcat" nowrap="nowrap"><span class="smallfont"><phrase 1="$pagedata[minlimit]" 2="$pagedata[maxlimit]" 3="$pagedata[count]">$vbphrase[showing_links_x_to_y_of_z]</phrase><if condition="$_REQUEST[\'do\'] == \'searchresults\'"><br /><phrase 1="$search[searchtime]">$vbphrase[search_took_x_seconds]</phrase></if></span></td>
		</if>

		</td>

		<if condition="$show[\'category_tools\']">
			<td class="vbmenu_control" id="cattools"><a href="#goto_cattools">$vbphrase[category_tools]</a> <script type="text/javascript"> vbmenu_register("cattools"); </script></td>
		</if>
		<if condition="$show[\'cat_search\'] AND $show[\'searchlinks\']">
			<td class="vbmenu_control" id="catsearch"><a href="#goto_catsearch">$vbphrase[search_this_category]</a> <script type="text/javascript"> vbmenu_register("catsearch"); </script></td>
		</if>
	</tr>
</table>

<if condition="$vboptions[\'usepopups\'] AND $_REQUEST[\'do\'] == \'poplinks\'">
<!-- Pop-up for popular links -->
	<div class="vbmenu_popup" id="orderby_menu" style="display:none">
		<table cellpadding="4" cellspacing="1" border="0">
			<if condition="$orderby != \'views\'">
				<tr>
					<td class="vbmenu_option"><b><a href="browselinks.php?$session[sessionurl]do=poplinks&amp;orderby=views"><phrase 1="$vba_options[links_poplinklimit]">$vbphrase[top_x_visited_links]</phrase></a></b></td>
				</tr>
			</if>
			<if condition="$orderby != \'rating\'">
				<tr>
					<td class="vbmenu_option"><b><a href="browselinks.php?$session[sessionurl]do=poplinks&amp;orderby=rating"><phrase 1="$vba_options[links_poplinklimit]">$vbphrase[top_x_rated_links]</phrase></a></b></td>
				</tr>
			</if>

			<if condition="$orderby != \'posts\' AND $vba_options[\'links_allowreplies\']">
				<tr>
					<td class="vbmenu_option"><b><a href="browselinks.php?$session[sessionurl]do=poplinks&amp;orderby=posts"><phrase 1="$vba_options[links_poplinklimit]">$vbphrase[top_x_replied_to_links]</phrase></a></b></td>
				</tr>
			</if>
		</table>
	</div>
<!-- / Pop-up for popular links -->
</if>

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		<td class="thead" width="2%">&nbsp;</td>

		<if condition="$_REQUEST[\'do\'] == \'poplinks\' OR $_REQUEST[\'do\'] == \'newlinks\'">

			<td align="$stylevar[left]" class="thead">
				<if condition="$vba_options[\'links_allowrating\']">
					<div style="float:$stylevar[right]">$vbphrase[rating]</div>
				</if>
				$vbphrase[link_name_description]
				<if condition="$vba_options[\'links_allowreplies\']">
					/ $vbphrase[date_added]
				</if>
			</td>

			<td align="center" class="thead" nowrap="nowrap">
				<if condition="$vba_options[\'links_allowreplies\']">
					$vbphrase[last_post]
				<else />
					$vbphrase[date_added]
				</if>
			</td>

			<if condition="$vba_options[\'links_allowreplies\']">
				<td align="center" class="thead" nowrap="nowrap">$vbphrase[replies]</td>
			</if>

			<td align="center" class="thead" nowrap="nowrap">$vbphrase[views]</td>

			<if condition="$show[\'categoryhead\']">
				<td align="center" class="thead" nowrap="nowrap">$vbphrase[category]</td>
			</if>
		<else />

			<td align="$stylevar[left]" class="thead">
				<if condition="$vba_options[\'links_allowrating\']">
					<div style="float:$stylevar[right]"><a href="browselinks.php?$session[sessionurl]$sorturls[rating]" rel="nofollow">$vbphrase[rating]</a> $arrow[rating]</div>
				</if>
				<a href="browselinks.php?$session[sessionurl]$sorturls[name]" rel="nofollow">$vbphrase[link_name_description]</a> $arrow[name]
				<if condition="$vba_options[\'links_allowreplies\']">
					/ <a href="browselinks.php?$session[sessionurl]$sorturls[dateline]" rel="nofollow">$vbphrase[date_added]</a> $arrow[dateline]
				</if>
			</td>

			<td align="center" class="thead" nowrap="nowrap">
				<if condition="$vba_options[\'links_allowreplies\']">
					<a href="browselinks.php?$session[sessionurl]$sorturls[lastpostdateline]" rel="nofollow">$vbphrase[last_post]</a> $arrow[lastpostdateline]
				<else />
					<a href="browselinks.php?$session[sessionurl]$sorturls[dateline]" rel="nofollow">$vbphrase[date_added]</a> $arrow[dateline]
				</if>
			</td>

			<if condition="$vba_options[\'links_allowreplies\']">
				<td align="center" class="thead" nowrap="nowrap"><a href="browselinks.php?$session[sessionurl]$sorturls[posts]" rel="nofollow">$vbphrase[replies]</a> $arrow[posts]</td>
			</if>

			<td align="center" class="thead" nowrap="nowrap"><a href="browselinks.php?$session[sessionurl]$sorturls[views]" rel="nofollow">$vbphrase[views]</a> $arrow[views]</td>

			<if condition="$show[\'categoryhead\']">
				<td align="center" class="thead" nowrap="nowrap"><a href="browselinks.php?$session[sessionurl]$sorturls[category]" rel="nofollow">$vbphrase[category]</a> $arrow[category]</td>
			</if>
		</if>
	</tr>
	$linkbits
</table>

<div align="$stylevar[right]" style="padding-top:3px">$pagenav</div>

<br />

<if condition="!$show[\'disablelinkdisplay\']">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" <if condition="!$categorymods">colspan="2"</if>>$vbphrase[display_options]</td>

			<if condition="$categorymods">
				<td class="tcat" width="35%">$vbphrase[moderators]</td>
			</if>

		</tr>
		<tr>
			<td class="thead" <if condition="!$categorymods">colspan="2"</if>><phrase 1="$pagedata[minlimit]" 2="$pagedata[maxlimit]" 3="$pagedata[count]">$vbphrase[showing_links_x_to_y_of_z]</phrase>
			</td>

			<if condition="$categorymods">
				<td class="thead">$vbphrase[moderators]: $modcount</td>
			</if>

		</tr>
		<tr>
			<td class="alt1">
				<form action="browselinks.php" method="get">
					<input name="s" type="hidden" value="$session[sessionhash]" />
					<input name="do" type="hidden" value="$_REQUEST[do]" />
					<input name="catid" type="hidden" value="$catid" />
					<input name="searchid" type="hidden" value="$searchid" />
					<input name="linkuserid" type="hidden" value="$linkuserid" />
					<table cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<td class="smallfont">$vbphrase[sorted_by]:</td>
							<td>
								<select name="orderby" style="width:120px">
									<option $ordersel[name] value="name">$vbphrase[link_name]</option>
									<option $ordersel[dateline] value="dateline">$vbphrase[last_updated]</option>
									<option $ordersel[views] value="views">$vbphrase[views]</option>
									<option $ordersel[rating] value="rating">$vbphrase[rating]</option>
								</select>
							</td>
							<td class="smallfont">$vbphrase[sort_order]:</td>
							<td>
								<select name="direction" style="width:120px">
									<option value="asc" >$vbphrase[ascending]</option>
									<option value="desc" >$vbphrase[descending]</option>
								</select>
							</td>

							<if condition="$categorymods">
								</tr>
								<tr>
							</if>

							<td class="smallfont">$vbphrase[from_the]:</td>
							<td>
								<select name="cutoffdate" style="width:120px">
									<option $datecutsel[1] value="1">$vbphrase[last_day]</option>
									<option $datecutsel[2] value="2">$vbphrase[last_2_days]</option>
									<option $datecutsel[7] value="7">$vbphrase[last_week]</option>
									<option $datecutsel[14] value="14">$vbphrase[last_2_weeks]</option>
									<option $datecutsel[30] value="30">$vbphrase[last_month]</option>
									<option $datecutsel[45] value="45">$vbphrase[last_45_days]</option>
									<option $datecutsel[60] value="60"><phrase 1="2">$vbphrase[last_x_months]</phrase></option>
									<option $datecutsel[90] value="90"><phrase 1="3">$vbphrase[last_x_months]</phrase></option>
									<option $datecutsel[180] value="180"><phrase 1="6">$vbphrase[last_x_months]</phrase></option>
									<option $datecutsel[270] value="270"><phrase 1="9">$vbphrase[last_x_months]</phrase></option>
									<option $datecutsel[365] value="365">$vbphrase[last_year]</option>
									<option $datecutsel[all] value="-1">$vbphrase[beginning]</option>
								</select>
							</td>

							<td>&nbsp;</td>
							<td><input class="button" style="width:120px" type="submit" value="$vbphrase[show_links]" /></td>
						</tr>
					</table>
				</form>
			</td>

		<if condition="$categorymods">
			<td class="alt1">
			$categorymods
			</td>
		</if>
		</tr>
	</table>

	<if condition="!$show[\'popups\'] AND !$linkuserid">
		<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
			<tr>
				<if condition="$show[\'category_tools\']"><td class="thead" width="50%">$vbphrase[category_tools]</td></if>
				<td class="thead">$vbphrase[search_this_category]</td>
			</tr>
			<tr>
				<if condition="$show[\'category_tools\']"><td class="alt1" valign="top">
					<div>
						<img alt="$vbphrase[subscribe_to_this_category]" class="inlineimg" src="$stylevar[imgdir_button]/subscribe.gif" /> <span class="smallfont">
						<if condition="$show[\'unsubscribe_cat\']">
							<a href="misc.php?do=unsubscribe&amp;type=cat$adv_sorturl">$vbphrase[unsubscribe_from_this_category]</a>
						<else />
							<a href="misc.php?do=subscribe&amp;type=cat$adv_sorturl">$vbphrase[subscribe_to_this_category]</a>
						</if></span></div>
						<if condition="$parentid">
							<div><img alt="$vbphrase[view_parent_category]" class="inlineimg" src="$stylevar[imgdir_button]/subscribe.gif" /> <span class="smallfont"><a href="browselinks.php?c=$parentid" rel="nofollow">$vbphrase[view_parent_category]</a></span></div>
						</if>
					</td></if>
					<td class="alt1">
						<form action="search.php" method="post">
							<input name="s" type="hidden" value="$session[sessionhash]" />
							<input name="do" type="hidden" value="searchresults" />
							<input name="quicksearch" type="hidden" value="1" />
							<input name="catid[]" type="hidden" value="$catid" />
							<input class="bginput" name="string" size="20" type="text" />$gobutton<br />
							<span class="smallfont"><a href="search.php?$session[sessionurl]cat=$catid" rel="nofollow">$vbphrase[advanced_search]</a></span>
						</form>
					</td>
				</tr>
		</table>
		<br />

	<else />

		<if condition="$show[\'cat_search\'] AND $show[\'searchlinks\']">
			<div class="vbmenu_popup" id="catsearch_menu" style="display:none">
				<form action="search.php" method="post">
					<input name="s" type="hidden" value="$session[sessionhash]" />
					<input name="do" type="hidden" value="searchresults" />
					<input name="quicksearch" type="hidden" value="1" />
					<input name="catids[]" type="hidden" value="$catid" />
					<table border="0" cellpadding="4" cellspacing="1">
						<tr>
							<td class="thead">$vbphrase[search_this_category]</td>
						</tr>
						<tr>
							<td class="vbmenu_option" title="nohilite">
								<input class="bginput" name="string" size="20" type="text" /> $gobutton</td>
						</tr>
						<tr>
							<td class="vbmenu_option"><a href="search.php?catid=$catid" rel="nofollow">$vbphrase[advanced_search]</a></td>
						</tr>
					</table>
				</form>
			</div>
		</if>

		<if condition="$show[\'category_tools\']">
			<div class="vbmenu_popup" id="cattools_menu" style="display:none">
				<table border="0" cellpadding="4" cellspacing="1">
					<tr>
						<td class="thead">$vbphrase[category_tools]</td>
					</tr>
					<if condition="$show[\'subscribe\']">
						<tr>
							<td class="vbmenu_option">
								<if condition="$show[\'unsubscribe_cat\']">
									<a href="misc.php?do=unsubscribe&amp;type=cat$adv_sorturl">$vbphrase[unsubscribe_from_this_category]</a>
								<else />
									<a href="misc.php?do=subscribe&amp;type=cat$adv_sorturl">$vbphrase[subscribe_to_this_category]</a>
								</if>
							</td>
						</tr>
					</if>
					<if condition="$parentid">
						<tr>
							<td class="vbmenu_option"><span class="smallfont"><a href="browselinks.php?c=$parentid" rel="nofollow">$vbphrase[view_parent_category]</a></span></td>
						</tr>
					</if>
				</table>
			</div>
		</if>
		<br />
	</if>

</if>



<table cellpadding="2" cellspacing="0" width="100%">
	<tr valign="bottom">
		<td align="$stylevar[left]" width="100%">
			<table cellpadding="2" cellspacing="0">
				<tr align="$stylevar[left]">
					<td><img alt="$vbphrase[new_link]" border="0" src="$stylevar[imgdir_statusicon]/thread_new.gif" /></td>
					<td class="smallfont">$vbphrase[new_link]</td>
					<td><img alt="$vbphrase[new_hot_link]" border="0" src="$stylevar[imgdir_statusicon]/thread_hot_new.gif" /></td>
					<td class="smallfont">$vbphrase[new_hot_link]</td>
				</tr>
				<tr>
					<td><img alt="$vbphrase[old_link]" border="0" src="$stylevar[imgdir_statusicon]/thread.gif" /></td>
					<td class="smallfont">$vbphrase[old_link]</td>
					<td><img alt="$vbphrase[old_hot_link]" border="0" src="$stylevar[imgdir_statusicon]/thread_hot.gif" /></td>
					<td class="smallfont">$vbphrase[old_hot_link]</td>
				</tr>

				<tr>
					<td><img src="$stylevar[imgdir_statusicon]/thread_lock.gif" alt="$vbphrase[closed_link]" border="0" /></td>
					<td class="smallfont">$vbphrase[closed_link]</td>
					<td>&nbsp;</td>
				</tr>

			</table>
		</td>
		<td align="$stylevar[right]" valign="bottom">$categoryjump</td>
	</tr>
</table>


$footer

</body>
</html>',


'adv_links_categorybit_level1' =>
'</tbody>
<tbody>
<tr>
	<td colspan="2" class="alt1" align="left">

		<table border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr>
				<td valign="top"><if condition="$vba_options[\'links_showonoff\']"><img alt="" border="0" src="$stylevar[imgdir_statusicon]/forum_$onoff.gif" /><else />&nbsp;</if></td>
				<td><img alt="" src="$vboptions[bburl]/$vboptions[cleargifurl]" width="9" /></td>
				<td width="100%"><b><a href="browselinks.php?$session[sessionurl]c=$cats[catid]">$cats[title]</a></b>
				<if condition="$vba_options[\'links_showcatowner\'] AND $cats[\'catuserid\']">
					<div class="smallfont">(<a href="member.php?$session[sessionurl]u=$cats[catuserid]" rel="nofollow">$cats[username]</a>)</div>
				</if>
					<div class="smallfont">$cats[description]</div>
					<if condition="$show[\'subscribe_options\']">
						<div class="smallfont">
							[<a href="misc.php?$session[sessionurl]do=unsubscribe&amp;type=cat&amp;c=$cats[catid]&amp;return=subscriptions">$vbphrase[unsubscribe_from_this_category]</a>]
						</div>
					</if>
					$subcatbits
				</td>
			</tr>
		</table>
	</td>


	<td class="alt2" nowrap="nowrap">
		<if condition="$cats[\'lastlinkid\']">
			<span class="smallfont"><b><a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastlinkid]">$cats[lastlinktitle]</a></b><br />
			$vbphrase[by]
			<if condition="$cats[\'lastlinkuserid\']">
				<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$cats[lastlinkuserid]" rel="nofollow">$cats[lastlinkusername]</a>
			<else />
				$vbphrase[guest]
			</if>
			</span><div class="smallfont" align="right">$cats[lastupdateddate] <span class="time">$cats[lastupdatedtime]</span> <a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastlinkid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" /></a></div>
		<else />
			<div align="center">$vbphrase[never]</div>
		</if>
	</td>


	<if condition="$vba_options[\'links_allowreplies\']">
		<td class="alt1" nowrap="nowrap">
			<if condition="$cats[\'lastpostdateline\']">
				<span class="smallfont">
				<if condition="!$show[\'dateonly\']">
					<strong><a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastpostlinkid]&amp;p=$cats[lastpostid]#post$cats[lastpostid]">$cats[lastpostlinktitle]</a></strong><br />
					<if condition="$cats[\'lastpostuserid\']">
						<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$cats[lastpostuserid]" 2="$cats[lastpostusername]" rel="nofollow">$vbphrase[by_x]</phrase>
					<else />
						$vbphrase[guest]
					</if>
					<br />
				</if>
				$cats[lastpostdate] <span class="time">$cats[lastposttime]</span></span>
				<a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastpostlinkid]&amp;p=$cats[lastpostid]#post$cats[lastpostid]"><img border="0" src="$stylevar[imgdir_button]/lastpost.gif" alt="$vbphrase[go_to_last_post]" /></a>
			<else />
				<span class="smallfont">$vbphrase[never]</span>
			</if>
		</td>
	</if>

	<td align="center" class="<if condition="$vba_options[\'links_allowreplies\']">alt2<else />alt1</if>"><span class="smallfont">$cats[linkcount]</span></td>

	<if condition="$vba_options[\'links_allowreplies\']">
		<td align="center" class="alt1"><span class="smallfont">$cats[postcount]</span></td>
	</if>

	<if condition="$show[\'modcolumn\']">
		<td align="center" class="alt2">$cats[moderator]</td>
	</if>

</tr>',


'adv_links_categorybit_level2' =>
'<tr>
	<td class="alt2" valign="top"><if condition="$vba_options[\'links_showonoff\']"><img alt="" border="0" src="$stylevar[imgdir_statusicon]/forum_$onoff.gif" /><else />&nbsp;</if></td>

	<td class="alt1"><b><a href="browselinks.php?$session[sessionurl]c=$cats[catid]">$cats[title]</a></b>
		<if condition="$vba_options[\'links_showcatowner\'] AND $cats[\'catuserid\']">
			<div class="smallfont">(<a href="member.php?$session[sessionurl]u=$cats[catuserid]" rel="nofollow">$cats[username]</a>)</div>
		</if>
		<div class="smallfont">$cats[description]</div>

		<if condition="$show[\'subscribe_options\']">
			<div class="smallfont">
				[<a href="misc.php?$session[sessionurl]do=unsubscribe&amp;type=cat&amp;c=$cats[catid]&amp;return=subscriptions">$vbphrase[unsubscribe_from_this_category]</a>]
			</div>
		</if>
		$subcatbits
	</td>

	<td class="alt2" nowrap="nowrap">
		<if condition="$cats[\'lastlinkid\']">
			<span class="smallfont"><b><a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastlinkid]">$cats[lastlinktitle]</a></b><br />
			$vbphrase[by]
			<if condition="$cats[\'lastlinkuserid\']">
				<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$cats[lastlinkuserid]" rel="nofollow">$cats[lastlinkusername]</a>
			<else />
				$vbphrase[guest]
			</if>
			</span><div class="smallfont" align="right">$cats[lastupdateddate] <span class="time">$cats[lastupdatedtime]</span> <a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastlinkid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" /></a></div>
		<else />
			<div align="center">$vbphrase[never]</div>
		</if>
	</td>

	<if condition="$vba_options[\'links_allowreplies\']">
		<td class="alt1" nowrap="nowrap">
			<if condition="$cats[\'lastpostdateline\']">
				<span class="smallfont">
				<if condition="!$show[\'dateonly\']">
					<strong><a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastpostlinkid]&amp;p=$cats[lastpostid]#post$cats[lastpostid]">$cats[lastpostlinktitle]</a></strong><br />
					<if condition="$cats[\'lastpostuserid\']">
						<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$cats[lastpostuserid]" rel="nofollow">$cats[lastpostusername]</a>
					<else />
						$vbphrase[guest]
					</if>
				<br />
				</if>
				$cats[lastpostdate] <span class="time">$cats[lastposttime]</span></span>
				<a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$cats[lastpostlinkid]&amp;p=$cats[lastpostid]#post$cats[lastpostid]"><img border="0" src="$stylevar[imgdir_button]/lastpost.gif" alt="$vbphrase[go_to_last_post]" /></a>
			<else />
				<span class="smallfont">$vbphrase[never]</span>
			</if>
		</td>
	</if>

	<td align="center" class="<if condition="$vba_options[\'links_allowreplies\']">alt2<else />alt1</if>"><span class="smallfont">$cats[linkcount]</span></td>

	<if condition="$vba_options[\'links_allowreplies\']">
		<td align="center" class="alt1"><span class="smallfont">$cats[postcount]</span></td>
	</if>

	<if condition="$show[\'modcolumn\']">
		<td align="center" class="alt2">$cats[moderator]</td>
	</if>

</tr>',


'adv_links_categorybit_main' =>
'<if condition="$catcount != 1">
	</tbody>
</if>
<tbody>
	<tr>
		<td class="tcat" colspan="7">
			<a href="#top" onclick="return toggle_collapse(\'dirbit_$cats[catid]\')" style="float:$stylevar[right]"><img alt="" border="0" id="collapseimg_dirbit_$cats[catid]" src="$stylevar[imgdir_button]/collapse_tcat$catimgcollapse.gif" /></a>
			<a href="index.php?$session[sessionurl]c=$cats[catid]">$cats[title]</a>
			<div class="smallfont">$cats[description]</div>
		</td>
	</tr>
</tbody>

<tbody id="collapseobj_dirbit_$cats[catid]" style="$catcollapse">',


'adv_links_categorybit_subcat' =>
'<if condition="$vba_options[\'links_showonoff\']"><img alt="" class="inlineimg" src="$stylevar[imgdir_statusicon]/subforum_$subonoff.gif" /></if> <span class="smallfont"><a href="browselinks.php?$session[sessionurl]c=$subcatid">$subcats[title]</a></span>',


'adv_links_categoryjump' =>
'<div class="smallfont" style="text-align:$stylevar[left]; white-space:nowrap">
	<form action="browselinks.php" method="get">
		<input name="s" type="hidden" value="$session[sessionhash]" />
		<input name="do" type="hidden" value="jump" />
		<b>Category Jump</b><br />
		<select name="catid" onchange="this.form.submit();">
			<option value="home">$vbphrase[home]</option>
			<option $doselect[favorites] value="favorites">$vbphrase[my_favorites]</option>
			<option $doselect[subscriptions] value="subscriptions">$vbphrase[my_subscriptions]</option>
			<option $doselect[newlinks] value="newlinks">$vbphrase[whats_new]</option>
			<option $doselect[poplinks] value="poplinks">$vbphrase[whats_popular]</option>
			<option $doselect[search] value="search">$vbphrase[search]</option>
			<optgroup label="Categories">$options</optgroup>
		</select> $gobutton
	</form>
</div>',


'ADV_LINKS_CATMANAGER' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[category_manager]</title>
$headinclude
</head>
<body>
$header
$navbar

$linksnav

<form action="managecats.php" method="get">
	<input name="do" type="hidden" value="addcat" />
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%">$vbphrase[category_manager]</td>
		</tr>
		<tr>
			<td align="center" class="panelsurround">
				<div class="panel">
					<div align="$stylevar[left]" style="width:$stylevar[formwidth]">
						<table align="center" border="0" cellpadding="2" cellspacing="0" width="100%">
							$categorybits
						</table>
					</div>
				</div>

				<div style="padding-top:6px"><input class="button" type="submit" value=" $vbphrase[add_category] " /></div>
			</td>
		</tr>
	</table>
</form>
<br />

$footer
</body>
</html>',


'ADV_LINKS_CATMANAGER_ADDEDIT_CAT' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[category_manager]</title>
$headinclude
</head>
<body>
$header
$navbar

$linksnav

<form action="managecats.php" method="post">
	<input name="do" type="hidden" value="<if condition="$_REQUEST[\'do\'] == \'editcat\'">doeditcat<else />doaddcat</if>" />
	<input name="s" type="hidden" value="$session[sessionhash]" />
	$hiddenbits
	<if condition="$_REQUEST[\'do\'] == \'editcat\'">
		<input name="category[catid]" type="hidden" value="$category[catid]" />
		<input name="category[thisparent]" type="hidden" value="$category[parent]" />
	</if>

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%">
				<if condition="$_REQUEST[\'do\'] == \'editcat\'">
					$vbphrase[edit_category]: $category[title]
				<else />
					$vbphrase[add_category]
				</if>
			</td>
		</tr>
		<tr>
			<td align="center" class="panelsurround">
				<div class="panel">
					<div align="$stylevar[left]" style="width:$stylevar[formwidth]">

						<fieldset class="fieldset">
							<legend>$vbphrase[title]</legend>
							<div style="padding:$stylevar[formspacer]px">
								$vbphrase[please_enter_title_for_category]<br />
								<input class="bginput" name="category[title]" size="35" type="text" value="$category[title]" />
							</div>
						</fieldset>

						<fieldset class="fieldset">
							<legend>$vbphrase[description]</legend>
							<div style="padding:$stylevar[formspacer]px">
								$vbphrase[please_enter_description_for_category]<br />
								<textarea class="bginput" cols="40" name="category[description]" rows="3">$category[description]</textarea>
							</div>
						</fieldset>

						<fieldset class="fieldset">
						<legend>$vbphrase[parent_category]</legend>
							<div style="padding:$stylevar[formspacer]px">
								$vbphrase[please_select_category_for_yours_appear_under]<br />
								<select name="category[parent]">
								<option value="">$vbphrase[please_select_one]</option>
								$catoptions
								</select>
							</div>
						</fieldset>

						<if condition="$vba_options[\'links_usercats_password\']">
							<fieldset class="fieldset">
							<legend>$vbphrase[password]</legend>
								<table cellpadding="0" cellspacing="$stylevar[formspacer]" width="400">
									<tr>
										<td colspan="2">
											<if condition="$category[password]">
												$vbphrase[if_you_would_like_change_password]<br /><input class="bginput" name="category[currentpass]" size="25" type="password" />
											<else />
												$vbphrase[if_you_would_like_enter_password_category]
											</if>
										</td>
									</tr>
									<tr>
										<td>$vbphrase[password]:</td>
										<td>$vbphrase[confirm_password]:</td>
									</tr>
									<tr>
										<td><input class="bginput" name="category[password]" size="25" type="password" /></td>
										<td><input class="bginput" name="category[confirmpassword]" size="25" type="password" /></td>
									</tr>
								</table>
							</fieldset>
						</if>
						<if condition="$show[\'catopts\']">
							<fieldset class="fieldset">
								<legend>$vbphrase[category_options]</legend>
								<div style="padding:$stylevar[formspacer]px">
									<if condition="$defcatopts[\'allow_view\'] == 2">
										<label for="allow_view"><input $checked[allow_view] class="bginput" id="allow_view" name="useropts[allow_view]" type="checkbox" value="1" /> $vbphrase[allow_other_users_view]</label><br />
									</if>
									<if condition="$defcatopts[\'allow_newlinks\'] == 2">
										<label for="allow_upload"><input $checked[allow_newlinks] class="bginput" id="allow_newlinks" name="useropts[allow_newlinks]" type="checkbox" value="1" /> $vbphrase[allow_other_users_add_links]</label><br />
									</if>
									<if condition="$defcatopts[\'allow_reply\'] == 2">
										<label for="allow_reply"><input $checked[allow_reply] class="bginput" id="allow_reply" name="useropts[allow_reply]" type="checkbox" value="1" /> $vbphrase[allow_other_users_reply]</label><br />
									</if>
									<if condition="$defcatopts[\'allow_rating\'] == 2">
										<label for="allow_rating"><input $checked[allow_rating] class="bginput" id="allow_rating" name="useropts[allow_rating]" type="checkbox" value="1" /> $vbphrase[allow_other_users_rate]</label><br />
									</if>
								</div>
							</fieldset>
						</if>
					</div>
				</div>
				<div style="padding-top:6px">
				<input class="button" type="submit" value="<if condition="$_REQUEST[\'do\'] == \'editcat\'">$vbphrase[edit_category]<else />$vbphrase[add_category]</if>" /> <input class="button" type="reset" value="$vbphrase[reset_fields]" />
				</div>
			</td>
		</tr>
	</table>
</form>
<br />

$footer
</body>
</html>',


'adv_links_catmanager_categorybits' =>
'<tr>
	<if condition="$category[\'catuserid\'] == $bbuserinfo[\'userid\']">
		<td style="white-space:nowrap"><span class="smallfont">
		<if condition="$vba_options[\'links_usercats_delete\']">
			[<a href="managecats.php?$session[sessionurl]do=deletecat&amp;c=$category[catid]">$vbphrase[remove]</a>]-</if>
		<if condition="$vba_options[\'links_usercats_empty\']">
			[<a href="managecats.php?$session[sessionurl]do=emptycat&amp;c=$category[catid]">$vbphrase[empty]</a>]-</if>
		<if condition="$vba_options[\'links_usercat_edit\']">[<a href="managecats.php?$session[sessionurl]do=editcat&amp;c=$category[catid]">$vbphrase[edit]</a>]</if></span></td>
		<td width="100%">&nbsp;&nbsp;$dashes <b><a href="browselinks.php?$session[sessionurl]c=$category[catid]">$category[title]</a></b>
		<if condition="!$category[\'approved\']">($vbphrase[awaiting_moderation])</if></td>
	<else />
		<td>&nbsp;</td>
		<td><i>$dashes $category[title]</i></td>
	</if>
</tr>',


'adv_links_conformation' =>
'<form action="$formaction.php" method="post">
	<input name="do" type="hidden" value="$dovalue" />
	<input type="hidden" name="s" value="$session[sessionhash]" />
	<input type="hidden" name="$itemname" value="$itemid" />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%">$titlephrase</td>
		</tr>
		<if condition="$itemtitle">
			<tr>
				<td class="thead">$itemtitle</td>
			</tr>
		</if>
		<tr>
			<td align="center" class="panelsurround">
				<div class="panel">
					<table width="$stylevar[formwidth]" cellpadding="4">
						<tr>
							<td><input type="checkbox" name="confirmaction" value="1" /></td>
							<td align="$stylevar[left]">$confirmphrase</td>
						</tr>
					</table>
				</div>
				<div style="padding-top:6px">
				<input class="button" type="submit" value="$buttonphrase" />
				</div>
			</td>
		</tr>
	</table>
</form>
<br />
',


'adv_links_deletebit' =>
'<form action="moderate.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="dodeletelink" />
	<input name="linkid" type="hidden" value="$link[linkid]" />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat"><b>$vbphrase[delete_this_link]</td>
			</tr>
				<if condition="$show[\'linkname\']">
					<tr><td class="thead"><b>$vbphrase[link_name]:</b> $link[name]</td>
				</tr>
			</if>

			<tr>
				<td align="center" class="panelsurround">
					<div class="panel">
						<div align="$stylevar[left]" style="width:$stylevar[formwidth]">
							<div class="smallfont">$vbphrase[delete_link_message]</div>
							<fieldset class="fieldset"><legend>$vbphrase[delete_options]</legend>
								<label for="deletelink_no"><input checked="checked" id="deletelink_no" name="deletelink" type="radio" value="0" />$vbphrase[do_not_delete_link]</label><br />
								<label for="deletelink_yes"><input id="deletelink_yes" name="deletelink" type="radio" value="1" />$vbphrase[delete_this_link]</label>
							</fieldset>
						</div>
					</div>
				</div>
				<div style="padding-top:6px"><input class="button" type="submit" value="$vbphrase[delete_this_link]" /></div>
				</td>
			</tr>
		</tbody>
	</table>
</form>
<br />',


'adv_links_footer' =>
'<!-- Do NOT remove this copyright notice. Doing so is a violation of your license agreement! -->
<br />
<div align="center" class="smallfont"><phrase 1="$vba_options[links_version]">$vbphrase[powered_by_vba_links]</phrase></div>',


'adv_links_inactive_warning' =>
'<div align="center" style="color: red; background-color: white; border: 1px solid black; padding:2px">$vbphrase[adv_links_alert_turned_off]</div>',


'adv_links_letter' =>
'<if condition="$letterselected">
	<td align="center" class="alt1" width="3%"><span class="smallfont">[<b>$letter</b>]</span></td>
<else />
	<td align="center" class="alt2" width="3%"><span class="smallfont"><a href="$letterurl" title="<phrase 1="$item" 2="$letter">$vbphrase[view_x_beginning_with_letter_y]</phrase>">$letter</a></span></td>
</if>',


'adv_links_linkbit' =>
'<tr>
	<td class="alt2"><img alt="" src="$stylevar[imgdir_statusicon]/$link[folder].gif" /></td>

	<td class="alt1"><span style="float:$stylevar[right]">

		<if condition="$show[\'link_rating\']">
			<img alt="" border="0" src="$stylevar[imgdir_rating]/rating_$link[roundrating].gif" title="<phrase 1="$link[votenum]" 2="$link[truerating]">$vbphrase[votes_average]</phrase>" />
		</if>
		</span>

		<div id="menu_linkbit_$link[linkid]">
			<if condition="$link[\'sticky\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_link]" />
			</if>
			<if condition="$show[\'subscribed\']">
			<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_link]" />
		</if>

			<a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]$adv_sorturl">$link[name]</a>
			<if condition="$vba_options[\'links_browsedropdown\']"><script type="text/javascript"> vbmenu_register("menu_linkbit_$link[linkid]", true); </script></if>
		</div>

		<if condition="$vba_options[\'links_allowreplies\']">
			<fieldset class="fieldset">
				<legend><phrase 1="$link[username]" 2="$link[updatedate]" 3="$link[updatetime]" 4="$vboptions[bburl]/member.php?$session[sessionurl]u=$link[userid]" rel="nofollow">
				<if condition="$link[\'userid\']">
					$vbphrase[by_username_on_date]
				<else />
					$vbphrase[by_guest_on_date]
				</if>
				</phrase></legend>$link[description]
			</fieldset>
		<else />
			<span class="smallfont">$link[description]</span>
		</if>

		<!-- Begin Drop Down Menu -->
		<if condition="$vba_options[\'links_browsedropdown\']">
			<div class="vbmenu_popup" id="menu_linkbit_$link[linkid]_menu" style="display:none">
				<table cellpadding="4" cellspacing="1">
					<tr>
						<td align="$stylevar[left]" class="thead">$vbphrase[link_options]</td>
					</tr>

					<tr>
						<td align="$stylevar[left]" class="vbmenu_option falseclass"><a href="showlink.php?$session[sessionurl]l=$link[linkid]" target="_blank"<if condition="$show[\'nofollow\']"> rel="nofollow"</if>>$vbphrase[view_site]</a></td>
					</tr>

					<tr>
						<td align="$stylevar[left]" class="vbmenu_option"><a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]$adv_sorturl">$vbphrase[view_link_details]</a></td>
					</tr>

					<if condition="$show[\'replylink\']">
						<tr>
							<td align="$stylevar[left]" class="vbmenu_option"><a href="newreply.php?$session[sessionurl]l=$link[linkid]" rel="nofollow">$vbphrase[post_reply]</a></td>
						</tr>
					</if>

					<if condition="$show[\'ratelink\']">
						<tr>
							<td align="$stylevar[left]" class="vbmenu_option"><a href="javascript:rate($link[linkid])">$vbphrase[rate_link]</a></td>
						</tr>
					</if>

					<if condition="$show[\'favorites\']">
						<tr>
							<td align="$stylevar[left]" class="vbmenu_option">
								<if condition="$link[\'favid\']">
									<a href="misc.php?$session[sessionurl]do=removefav&amp;l=$link[linkid]&amp;return=$returnto$adv_sorturl">$vbphrase[remove_from_favorites]</a>
								<else />
									<a href="misc.php?$session[sessionurl]do=addfav&amp;l=$link[linkid]&amp;return=$returnto$adv_sorturl">$vbphrase[add_to_favorites]</a>
								</if>
							</td>
						</tr>
					</if>

					<if condition="$show[\'subscribe\']">
						<tr>
							<td align="$stylevar[left]" class="vbmenu_option"><if condition="$show[\'subscribed\']">
								<a href="misc.php?$session[sessionurl]do=unsubscribe&amp;type=link&amp;l=$link[linkid]&amp;return=$returnto$adv_sorturl">$vbphrase[unsubscribe_from_link]</a>
							<else />
								<a href="misc.php?$session[sessionurl]do=subscribe&amp;type=link&amp;l=$link[linkid]&amp;return=$returnto$adv_sorturl">$vbphrase[subscribe_to_link]</a>
							</if>
							</td>
						</tr>
					</if>


					<if condition="$show[\'sendtofriend\']">
						<tr>
							<td align="$stylevar[left]" class="vbmenu_option"><a href="misc.php?$session[sessionurl]do=sendtofriend&amp;l=$link[linkid]&amp;return=$returnto$adv_sorturl" rel="nofollow">$vbphrase[send_to_friend]</a></td>
						</tr>
					</if>

					<tr>
						<if condition="$show[\'report_link\']">
							<td align="$stylevar[left]" class="vbmenu_option"><a href="misc.php?$session[sessionurl]do=report&amp;linkid=$link[linkid]$adv_sorturl" rel="nofollow">$vbphrase[report_to_moderator]</a></td>
						</if>
					</tr>

				</table>
			</div>
		</if>
		<!-- End Drop Down Menu -->

	</td>

	<td align="$stylevar[right]" class="alt2" nowrap="nowrap">
		<if condition="$vba_options[\'links_allowreplies\']">
			<if condition="$show[\'replies\']">
				<span class="smallfont">$link[lastpostdate] <span class="time">$link[lastposttime]</span><br />
				$vbphrase[by]
				<if condition="$link[\'lastpostuserid\']">
					<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$link[lastpostuserid]" rel="nofollow">$link[lastpostusername]</a></span>
				<else />
					$vbphrase[guest]
				</if>
				<a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]&amp;p=$link[lastpostid]#post$link[lastpostid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a>
			<else />
				<div align="center">$vbphrase[never]</div>
			</if>
		<else />
			<span class="smallfont">$link[updatedate] <span class="time">$link[updatetime]</span><br />
			$vbphrase[by]
			<if condition="$link[\'userid\']">
				<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$link[userid]" rel="nofollow">$link[username]</a>
			<else />
				$vbphrase[guest]
			</if>
		</if>
	</td>

	<if condition="$vba_options[\'links_allowreplies\']">
		<td align="center" class="alt1"><span class="smallfont">$link[replies]</span></td>
	</if>

	<td align="center" class="<if condition="$vba_options[\'links_allowreplies\']">alt2<else />alt1</if>"><span class="smallfont">$link[views]</span></td>

	<if condition="$show[\'categoryhead\']">

		<td align="center" class="<if condition="$vba_options[\'links_allowreplies\']">alt1<else />alt2</if>"><span class="smallfont"><a href="browselinks.php?$session[sessionurl]c=$link[catid]">$link[category]</a></span></td>
	</if>
</tr>',


'ADV_LINKS_LINKTOUS' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[link_to_us]</title>
$headinclude

</head>
<body>

$header
$navbar

$linksnav

<if condition="$bannerbits">
<form name="js_copy_form">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat">$vbphrase[link_to_us]</td>
		</tr>

		$bannerbits

	</table>
</form>
	<br />
</if>



<table cellpadding="0" cellspacing="0" border="0" width="100%">
	<tr>
		<td width="100%">&nbsp;</td>
		<td align="right">$categoryjump</td>
	</tr>
</table>
$footer

</body>
</html>',


'adv_links_linktous_bannerbits' =>
'<tr>
	<td class="thead"><span style="float:$stylevar[right]">$banner[width] x $banner[height] ($banner[filesize])</span>$banner[title]</td>
</tr>
<tr>
	<td class="alt1" align="center">
		<img src="$vba_options[links_uploadurl]/$banner[filename]" width="$banner[width]" height="$banner[height]" />
		<div style="padding:3px"><textarea name="banner_$banner[bannerid]" rows="2" cols="55" onclick="document.js_copy_form.banner_$banner[bannerid].focus();document.js_copy_form.banner_$banner[bannerid].select();return false">&lt;a href=&quot;$vboptions[homeurl]&quot;&gt;&lt;img src=&quot;$vba_options[links_uploadurl]/$banner[filename]&quot; width=&quot;$banner[width]&quot; height=&quot;$banner[height]&quot; alt=&quot;$vboptions[hometitle]&quot; border=&quot;0&quot; /&gt;&lt;/a&gt;</textarea></div>
	</td>
</tr>',


'adv_links_massdelete_postbits' =>
'<tr>
	<td class="thead"><div style="float:$stylevar[right]"><phrase 1="$post[username]" 2="$postdate" 3="$posttime" 4="$vboptions[bburl]/member.php?$session[sessionurl]u=$post[userid]">$vbphrase[by_username_on_date]</phrase></div>
<label for="deletepost$post[postid]"><input checked="checked" id="deletepost$post[postid]" name="deletepost[$post[postid]]" type="checkbox" value="1" /> $vbphrase[delete]</label></td>
</tr>
<tr>
	<td class="alt1">$post[pagetext]</td>
</tr>',


'ADV_LINKS_MASSDELETE_POSTS' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vboptions[links_title] - $vbphrase[delete_posts]</title>
$headinclude

</head>
<body>

$header

$navbar

$linksnav

<form action="moderate.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="dodeleteposts" />
	<input name="linkid" type="hidden" value="$linkid" />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat">$vbphrase[delete_posts]: $linkname</td>
		</tr>
		<tr>
			<td class="alt2"><input checked="checked" id="cb_allbox" name="allbox" onclick="js_check_all(this.form);" type="checkbox" /> $vbphrase[check_uncheck_all]</td>
		</tr>
	</table>
	<br />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		$postbits
	</table>

<div align="center" style="padding-top:5px"><input class="button" type="submit" value="$vbphrase[delete_posts]" /></div>

</form>
<br />

$footer
</body>
</html>',


'adv_links_minierror' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head><title>$vbphrase[error]</title>
$headinclude
$headinsert
</head>
<body>

<table align="center" class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" width="100%">
	<tr>
		<td class="tcat">$vbphrase[vbulletin_message]</td>
	</tr>
	<tr>
		<td class="panelsurround" align="center">
			<div class="panel">
				<div align="$stylevar[left]">$errormessage</div>
			</div>
		</td>
	</tr>
</table>

</body>
</html>',


'ADV_LINKS_MODERATE' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[moderate_new]</title>
$headinclude
</head>
<body>
$header
$navbar

$linksnav

<div align="center" style="padding-bottom:5px">
[<if condition="$type == \'links\'"><b><phrase 1="$vbphrase[links]">$vbphrase[moderate_x]</phrase></b><else /><a href="moderate.php?$session[sessionurl]do=moderate&amp;type=links"><phrase 1="$vbphrase[links]">$vbphrase[moderate_x]</phrase></a></if> ($invalidlink[count])]
-
[<if condition="$type == \'posts\'"><b><phrase 1="$vbphrase[posts]">$vbphrase[moderate_x]</phrase></b><else /><a href="moderate.php?$session[sessionurl]do=moderate&amp;type=posts"><phrase 1="$vbphrase[posts]">$vbphrase[moderate_x]</phrase></a></if> ($invalidpost[count])]
-
[<if condition="$type == \'categories\'"><b><phrase 1="$vbphrase[categories]">$vbphrase[moderate_x]</phrase></b><else /><a href="moderate.php?$session[sessionurl]do=moderate&amp;type=categories"><phrase 1="$vbphrase[categories]">$vbphrase[moderate_x]</phrase></a></if> ($invalidcat[count])]
</div>

<form action="moderate.php" method="post">
<input name="s" type="hidden" value="$session[sessionhash]" />
<input name="do" type="hidden" value="dovalidate" />
<input name="type" type="hidden" value="$type" />
<input name="page" type="hidden" value="$page" />
<input name="pagecount" type="hidden" value="$pagecount" />
<input name="itemcount" type="hidden" value="$itemcount" />
<input name="lastitemid" type="hidden" value="$lastitemid" />

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		<td class="tcat" width="100%">$tableheader: $pageinfo</td>
	</tr>
	<if condition="$show[\'validate\']">
		<tr>
			<td class="alt1" align="center">
				<if condition="$type == \'links\'">
					<div style="float:$stylevar[right]"><label for="sendmailcheck">$vbphrase[send_email]<input $checkedemail id="sendmailcheck" name="allbox" onclick="js_check_all(this.form);" type="checkbox" value="1" /></label>
					</div>
				</if>
				<label for="checkall1"><input $checkedaction[1] id="checkall1" name="checkall" onclick="js_check_all_option(this.form, \'1\');" type="radio" value="1" /> $vbphrase[validate_all]</label>
				<label for="checkall2"><input $checkedaction[2] id="checkall2" name="checkall" onclick="js_check_all_option(this.form, \'2\');" type="radio" value="2" /> $vbphrase[delete_all]</label>
				<label for="checkall0"><input $checkedaction[0] id="checkall0" name="checkall" onclick="js_check_all_option(this.form, 0);" type="radio" value="0"/> $vbphrase[ignore_all]</label>
			</td>
		</tr>
	</table>
	<br />
	$moderationbits

	<else />
	<tr>
		<td class="alt1"><phrase 1="$vbphrase[$type]">$vbphrase[no_x_awaiting_moderation]</phrase></td>
	</tr>
	</table>
	</if>


<if condition="$show[\'validate\']">
	<div align="center" style="padding-top:5px"><input class="button" type="submit" value="$vbphrase[submit]" /> <input class="button" type="reset" value="$vbphrase[reset]" /></div>
</if>

</form>

<br />

$footer
</body>
</html>',


'adv_links_moderate_actionrows' =>
'		<if condition="$type == \'links\'">
			<span style="float:$stylevar[right]"><label for="sendmail_$varid">$vbphrase[send_email] <input $checkedemail id="sendmail_$varid"name="sendmail[$varid]" type="checkbox" value="1" /></label></span>
		</if>
		<label for="val_$varid">
				<input $checkedaction[1] id="val_$varid" name="$varname[$varid]" type="radio" value="1" />$vbphrase[validate]</label>
			<label for="del_$varid">
				<input $checkedaction[2] id="del_$varid" name="$varname[$varid]" type="radio" value="2" />$vbphrase[delete]</label>
			<label for="ign_$varid">
				<input $checkedaction[0] id="ign_$varid" name="$varname[$varid]" type="radio" value="0" />$vbphrase[ignore]</label>',


'adv_links_moderate_catbits' =>
'<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
<tr>
	<td class="thead"><span style="float:$stylevar[right]">
		<if condition="$cat[\'catuserid\']">
			<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$cat[catuserid]" target="_blank">$cat[username]</a>
		<else />
			$vbphrase[unregistered]
		</if></span>
		$cat[title]
	</td>
</tr>
<tr>
	<td align="center" class="panelsurround">
		<div class="panel">
			<div align="$stylevar[left]" style="width:$stylevar[formwidth]">
				<fieldset class="fieldset">
					<legend>$vbphrase[title]</legend>
					<div style="padding:$stylevar[formspacer]px">
						<input name="cats[$cat[catid]][title]" size="50" type="text" value="$cat[title]" />
					</div>
				</fieldset>
				<fieldset class="fieldset">
					<legend>$vbphrase[description]</legend>
					<div style="padding:$stylevar[formspacer]px">
					<textarea cols="45" name="cats[$cat[catid]][description]" rows="5">$cat[description]</textarea>
					</div>
				</fieldset>

			</div>
		</div>

		<div style="padding-top:6px">
		$rowactions
		</div>
	</td>
</tr>
</table>
<br />',


'adv_links_moderate_linkbits' =>
'<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
<tr>
	<td class="thead"><span style="float:$stylevar[right]">
		<if condition="$link[\'userid\']">
			<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$link[userid]" target="_blank">$link[username]</a>
		<else />
			$vbphrase[unregistered]
		</if>
		&nbsp; $link[dateadded] <span class="time">$link[timeadded]</span></span>
		$link[name]
	</td>
</tr>
<tr>
<td align="center" class="panelsurround">
	<div class="panel">
		<div align="$stylevar[left]" style="width:$stylevar[formwidth]">
		<input name="link[$link[linkid]][email]" type="hidden" value="$link[email]" />
		<input name="link[$link[linkid]][dateline]" type="hidden" value="$link[dateline]" />
		<input name="link[$link[linkid]][username]" type="hidden" value="$link[username]" />
		<input name="link[$link[linkid]][userid]" type="hidden" value="$link[userid]" />

		<fieldset class="fieldset">
			<legend>$vbphrase[title]</legend>
			<div style="padding:$stylevar[formspacer]px">
			<input name="link[$link[linkid]][name]" size="50" type="text" value="$link[name]" />
			</div>
		</fieldset>

		<fieldset class="fieldset">
			<legend>$vbphrase[url]</legend>
			<div style="padding:$stylevar[formspacer]px">
			<input name="link[$link[linkid]][linkurl]" size="50" type="text" value="$link[linkurl]" /> <span class="smallfont">[<a href="$link[linkurl]" target="_blank">$vbphrase[view_site]</a>]</span>
			</div>
		</fieldset>

		<fieldset class="fieldset">
			<legend>$vbphrase[description]</legend>
			<div style="padding:$stylevar[formspacer]px">
			<textarea cols="45" name="link[$link[linkid]][description]" rows="5">$link[description]</textarea>
			</div>
		</fieldset>

		<fieldset class="fieldset">
			<legend>$vbphrase[category]</legend>
			<div style="padding:$stylevar[formspacer]px">
			<select name="link[$link[linkid]][catid]">
				$catoptions
			</select>
			</div>
		</fieldset>

		<fieldset class="fieldset">
			<legend>$vbphrase[keywords]</legend>
			<div style="padding:$stylevar[formspacer]px">
			<input name="link[$link[linkid]][keywords]" size="50" type="text" value="$link[keywords]" />
			</div>
		</fieldset>

		<fieldset class="fieldset">
			<legend>$vbphrase[link_notes]</legend>
			<div style="padding:$stylevar[formspacer]px">
			<input name="link[$link[linkid]][notes]" size="50" type="text" value="$link[notes]" />
			</div>
		</fieldset>

		$customfieldbits

	</div>
</div>
<div style="padding-top:6px">

$rowactions
</td>
</tr>
</table>
<br />',


'adv_links_moderate_postbits' =>
'<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
<tr>
	<td class="thead"><span style="float:$stylevar[right]">
		<if condition="$post[\'userid\']">
			<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$post[userid]" target="_blank">$post[username]</a>
		<else />
			$vbphrase[unregistered]
		</if>
		&nbsp; $post[dateadded] <span class="time">$post[timeadded]</span></span>
		<a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$post[linkid]" target="_blank">$post[name]</a>
	</td>
</tr>
<tr>
	<td align="center" class="panelsurround">
		<div class="panel">
			<div align="$stylevar[left]" style="width:$stylevar[formwidth]">

				<input type="hidden" name="post[$post[postid]][linkid]" value="$post[linkid]" />
				<input type="hidden" name="post[$post[postid]][catid]" value="$post[catid]" />
				<input type="hidden" name="post[$post[postid]][userid]" value="$post[userid]" />
				<input type="hidden" name="post[$post[postid]][username]" value="$post[username]" />
				<input type="hidden" name="post[$post[postid]][dateline]" value="$post[dateline]" />
				<input type="hidden" name="post[$post[postid]][linkname]" value="$post[name]" />

				<fieldset class="fieldset">
					<legend>$vbphrase[title]</legend>
					<div style="padding:$stylevar[formspacer]px">
						<input name="post[$post[postid]][title]" size="50" type="text" value="$post[title]" />
					</div>
				</fieldset>

				<fieldset class="fieldset">
					<legend>$vbphrase[description]</legend>
					<div style="padding:$stylevar[formspacer]px">
					<textarea cols="45" name="post[$post[postid]][message]" rows="5">$post[pagetext]</textarea>
					</div>
				</fieldset>

			</div>
		</div>

	<div style="padding-top:6px">

		$rowactions
		</div>
	</td>
</tr>
</table>
<br />',


'ADV_LINKS_MODOPTS' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vboptions[links_title] - $navname</title>
$headinclude
</head>
<body>

$header

$navbar

$linksnav

$content

$footer
</body>
</html>',


'ADV_LINKS_MYSTUFF' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[my_stuff]</title>
$headinclude
</head>
<body>

<script type="text/javascript">
function rate(linkid)
{
	window.open("newreply.php?do=ratelink&linkid="+linkid, "rate", "toolbar=no, scrollbars=no, resizable=yes, width=320, height=140");
}
</script>

$header

$navbar

$linksnav

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		<td align="$stylevar[left]" class="tcat" width="100%">$vbphrase[my_stuff]</td>
	</tr>
	<if condition="$show[\'favorites\']">
		<tr>
			<td class="alt1"><a href="browselinks.php?$session[sessionurl]do=favorites">$vbphrase[my_favorites]</a><br />
			$vbphrase[my_favorites_description]
			</td>
		</tr>
	</if>
	<if condition="$show[\'subscribe\']">
		<tr>
			<td class="alt2"><a href="browselinks.php?$session[sessionurl]do=subscriptions">$vbphrase[my_subscriptions]</a><br />
			$vbphrase[my_subscriptions_description]</td>
		</tr>
	</if>
</table>

$footer
</body>
</html>',


'adv_links_navbar' =>
'<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr align="center">

		<td class="alt1" width="$lnavbarwidth"><span class="smallfont"><a href="index.php$session[sessionurl_q]">$vbphrase[home]</a></span></td>

		<if condition="$show[\'mystuff\']">
			<td class="alt1" id="mystuff" nowrap="nowrap" width="$lnavbarwidth"><span class="smallfont"><a href="misc.php?$session[sessionurl]do=mystuff">$vbphrase[my_stuff]</a></span> <script type="text/javascript"> vbmenu_register("mystuff"); </script></td>
		</if>

		<td class="alt1" nowrap="nowrap" width="$lnavbarwidth"><span class="smallfont"><a href="addlink.php?$session[sessionurl]c=$catid" rel="nofollow">$vbphrase[submit_a_link]</a></span></td>

		<if condition="$show[\'link_to_us\']">
			<td class="alt1" nowrap="nowrap" width="$lnavbarwidth"><span class="smallfont"><a href="misc.php?$session[sessionurl]do=linktous">$vbphrase[link_to_us]</a></span></td>
		</if>

		<if condition="$vba_options[\'links_newlinklimit\']">
			<td class="alt1" id="whatsnew" nowrap="nowrap" width="$lnavbarwidth"><span class="smallfont"><a href="browselinks.php?$session[sessionurl]do=newlinks">$vbphrase[whats_new]</a></span><if condition="$vba_options[\'links_allowreplies\']"> <script type="text/javascript"> vbmenu_register("whatsnew"); </script></if></td>
		</if>

		<if condition="$vba_options[\'links_poplinklimit\']">
			<td class="alt1" id="whatspopular" nowrap="nowrap" width="$lnavbarwidth"><span class="smallfont"><a href="browselinks.php?$session[sessionurl]do=poplinks">$vbphrase[whats_popular]</a></span> <script type="text/javascript"> vbmenu_register("whatspopular"); </script></td>
		</if>

		<td class="alt1" width="$lnavbarwidth"><span class="smallfont"><a href="search.php?$session[sessionurl]" rel="nofollow">$vbphrase[search]</a></span></td>

		<if condition="$show[\'modoptions\']">
			<td class="alt1" nowrap="nowrap" width="$lnavbarwidth"><span class="smallfont"><a href="moderate.php?$session[sessionurl]">$vbphrase[moderate_new]</a></span></td>
		</if>


	</tr>
</table>
<br />

<if condition="$show[\'popups\']">

	<if condition="$show[\'mystuff\']">
		<div class="vbmenu_popup" id="mystuff_menu" style="display:none">
			<table cellpadding="4" cellspacing="1">

				<if condition="$show[\'favorites\']">
					<tr>
						<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=favorites">$vbphrase[my_favorites]</a> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</td>
					</tr>
				</if>
				<if condition="$show[\'subscribe\']">
					<tr>
						<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=subscriptions">$vbphrase[my_subscriptions]</a></td>
					</tr>
				</if>
				<if condition="$show[\'managecats\']">
					<tr>
						<td class="vbmenu_option"><a href="managecats.php?$session[sessionurl]">$vbphrase[category_manager]</a></td>
					</tr>
				</if>
			</table>
		</div>
	</if>

	<div class="vbmenu_popup" id="whatspopular_menu" style="display:none">
		<table cellpadding="4" cellspacing="1" border="0">
			<if condition="$orderby != \'views\'">
				<tr>
					<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=poplinks&amp;orderby=views"><phrase 1="$vba_options[links_poplinklimit]">$vbphrase[top_x_visited_links]</phrase></a></td>
				</tr>
			</if>
			<tr>
				<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=poplinks&amp;orderby=rating"><phrase 1="$vba_options[links_poplinklimit]">$vbphrase[top_x_rated_links]</phrase></a></td>
			</tr>
			<tr>
				<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=poplinks&amp;orderby=posts"><phrase 1="$vba_options[links_poplinklimit]">$vbphrase[top_x_replied_to_links]</phrase></a></td>
			</tr>
		</table>
	</div>

	<if condition="$vba_options[\'links_newlinklimit\']">
		<div class="vbmenu_popup" id="whatsnew_menu" style="display:none">
			<table cellpadding="4" cellspacing="1" border="0">
				<tr>
					<td class="thead">$vbphrase[new_links]</td>
				</tr>
				<tr>
					<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=newlinks&amp;cutoffdate=lastvisit">$vbphrase[since_your_last_visit]</a></td>
				</tr>
				$newlinknavbits

				<if condition="$vba_options[\'links_allowreplies\']">
					<tr>
						<td class="thead">$vbphrase[new_posts]</td>
					</tr>
					<tr>
						<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=newposts&amp;cutoffdate=lastvisit">$vbphrase[since_your_last_visit]</a></td>
					</tr>
					$newpostnavbits
				</if>
			</table>
		</div>
	</if>

</if>',


'adv_links_navbar_newestbits' =>
'<tr>
	<td class="vbmenu_option"><a href="browselinks.php?$session[sessionurl]do=<if condition="$show[\'newlinknav\']">newlinks<else />newposts</if>&amp;cutoffdate=$ndatecut">$dayphrase</a></td>
</tr>',


'adv_links_nodisplay' =>
'
<tr class="alt1" valign="middle">
	<td align="center" colspan="6"><b><phrase 1="$vbphrase[links]">$vbphrase[no_x_to_display]</phrase></b></td>
</tr>',


'adv_links_ratingpopup' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[rate_link]</title>
$headinclude
</head>
<body>

<form action="newreply.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="rate" />
	<input name="linkid" type="hidden" value="$link[linkid]" />
	<input name="catid" type="hidden" value="$link[catid]" />
	<input name="redirpage" type="hidden" value="close" />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat">$vbphrase[rate_link]</td>
		</tr>
		<tr>
			<td align="center" class="panelsurround">
				<div class="panel">
					<div style="width:250px" align="left">
						<fieldset class="fieldset">
							<legend>$vbphrase[rate] $linkname</legend>
							<div style="padding:$stylevar[formspacer]px">
								<select name="vote">
								<option value="5">5 : $vbphrase[excellent]</option>
								<option value="4">4 : $vbphrase[good]</option>
								<option value="3">3 : $vbphrase[average]</option>
								<option value="2">2 : $vbphrase[bad]</option>
								<option value="1">1 : $vbphrase[terrible]</option>
								</select>
								$gobutton
							</div>
						</fieldset>
					</div>
				</div>
			</td>
		</tr>
	</table>
</form>

</body>
</html>',


'adv_links_rating_closebox' =>
'<html>
<head>
</head>
<body>
<script type="text/javascript">
  window.close();
</script>
</body>
</html>
',


'ADV_LINKS_REPLY' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[reply_to_link]</title>
$headinclude
</head>
<body>
$header
$navbar

$linksnav

<if condition="$show[\'deleteopt\']">
	<form action="newreply.php" method="post">
		<input name="s" type="hidden" value="$session[sessionhash]" />
		<input name="postid" type="hidden" value="$post[postid]" />
		<input name="do" type="hidden" value="dodeletepost" />
		<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
			<tr>
				<td class="tcat" width="100%">$vbphrase[delete_this_message]</td>
			</tr>
			<tr>
				<td align="center" class="panelsurround">
					<div class="panel">
						<div align="$stylevar[left]" style="width:$stylevar[formwidth]">
							<div class="smallfont">$vbphrase[delete_message_check_appropriate_option]</div>
								<fieldset class="fieldset">
									<legend>$vbphrase[delete_options]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<div><label for="dont_delete"><input checked="checked" id="dont_delete" name="deletepost" type="radio" value="0" />$vbphrase[do_not_delete_message]</label></div>

										<div><label for="do_delete"><input id="do_delete" name="deletepost" type="radio" value="1" />$vbphrase[delete_message]</label></div>
									</div>
								</fieldset>
						</div>
					</div>

					<div style="padding-top:$stylevar[cellpadding]px">
						<input class="button" type="submit" value="$vbphrase[delete_this_message]" />
					</div>
				</td>
			</tr>
		</table>
	</form>
	<br />
</if>

<form action="newreply.php" name="vbform" method="post"<if condition="!is_browser(\'webtv\')"> onsubmit="return vB_Editor[\'$editorid\'].prepare_submit(0, $vboptions[postminchars])"</if>>

	<input type="hidden" name="s" value="$session[sessionhash]" />
	<input type="hidden" name="do" value="<if condition="$show[\'editpost\']">doedit<else />postreply</if>" />
	<input type="hidden" name="linkid" value="$linkid" />
	<input type="hidden" name="catid" value="$link[catid]" />
	<if condition="$show[\'editpost\']">
		<input name="postid" type="hidden" value="$post[postid]" />
	</if>

	$postpreview

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%"><span class="smallfont" style="float:$stylevar[right]"><b>$vbphrase[link]:</b> <a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]">$link[name]</a></span><if condition="$show[\'editpost\']">$vbphrase[edit_post]<else />$vbphrase[reply_to_link]</if></td>
		</tr>
		<tr>
			<td align="center" class="panelsurround">
				<div class="panel">
					<div align="$stylevar[left]" style="width:$stylevar[formwidth]">
						$usernamecode

						<table cellpadding="0" cellspacing="0">
							<tr>
								<td><span class="smallfont">$vbphrase[title]:</span></td>
							</tr>
							<tr>
								<td><input class="bginput" maxlength="100" name="title" size="50" type="text" value="$post[title]" /> <img alt="$selectedicon[alt]" id="display_posticon" src="$selectedicon[src]" /></td>
							</tr>
						</table>

						<table cellpadding="0" cellspacing="0">
							<tr>
								<td>
									<span class="smallfont">$vbphrase[message]:</span>
									$messagearea
									$iconbits

$imagereg
								</td>
							</tr>
						</table>
					</div>
				</div>

				<div style="padding-top:$stylevar[cellpadding]px">
					<input accesskey="s" class="button" name="sbutton" type="submit" value="<if condition="$show[\'editpost\']">$vbphrase[save_changes]<else />$vbphrase[submit_reply]</if>" />
					<input accesskey="p" class="button" name="preview" type="submit" value="$vbphrase[preview_post]" />
				</div>
			</td>
		</tr>
	</table>

	<br />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%">$vbphrase[additional_options]</td>
		</tr>

		<tr valign="top">
			<td align="center" class="panelsurround">
				<div class="panel">
					<div align="$stylevar[left]" style="width:$stylevar[formwidth]">

						<fieldset class="fieldset">
							<legend>$vbphrase[miscellaneous_options]</legend>
							<div style="padding:$stylevar[formspacer]px">
								<if condition="$bbuserinfo[\'signature\']">
									<div><label for="signature"><input type="checkbox" name="signature" value="1" id="signature" $checked[signature] />$vbphrase[show_your_signature]</label></div>
								</if>
								<div><label for="parseurl"><input type="checkbox" name="parseurl" value="1" id="parseurl" tabindex="1" $checked[parseurl] />$vbphrase[automatically_parse_links_in_text]</label></div>
								$disablesmiliesoption
							</div>
						</fieldset>

						<if condition="$show[\'ratingopts\']">
							<fieldset class="fieldset">
								<legend>$vbphrase[rate_link]</legend>
								<div style="padding:$stylevar[formspacer]px">$vbphrase[add_rating_for_link]<br />
									<select name="vote">
										<option value="0" $votesel[0]>$vbphrase[choose_a_rating]</option>
										<option value="5" $votesel[5]>5 : $vbphrase[excellent]</option>
										<option value="4" $votesel[4]>4 : $vbphrase[good]</option>
										<option value="3" $votesel[3]>3 : $vbphrase[average]</option>
										<option value="2" $votesel[2]>2 : $vbphrase[bad]</option>
										<option value="1" $votesel[1]>1 : $vbphrase[terrible]</option>
									</select>
								</div>
							</fieldset>
						</if>
					</div>
				</div>

				<div style="padding-top:$stylevar[cellpadding]px">
					<input accesskey="s" class="button" name="sbutton" type="submit" value="<if condition="$show[\'editpost\']">$vbphrase[save_changes]<else />$vbphrase[submit_reply]</if>" />
					<input accesskey="p" class="button" name="preview" tabindex="1" type="submit" value="$vbphrase[preview_post]" />
				</div>
			</td>
		</tr>
	</table>
</form>

<if condition="$show[\'reviewbits\']">
	<br />

	$spacer_close
	$spacer_open

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat">
				<a href="#top" onclick="return toggle_collapse(\'postreview\')" style="float:$stylevar[right]"><img alt="" border="" id="collapseimg_postreview" src="$stylevar[imgdir_button]/collapse_tcat$vbcollapse[collapseimg_threadreview].gif" /></a>
				$vbphrase[topic_review_newest_first]
			</td>
		</tr>
	</table>

	<div id="collapseobj_postreview" style="$vbcollapse[collapseobj_postreview]">

		<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">

			$reviewbits

			<if condition="$show[\'reviewmore\']">
				<tr>
					<td class="tfoot" align="center" colspan="2"><span class="smallfont">
						<phrase 1="$vboptions[maxposts]" 2="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]" target="_blank">$vbphrase[link_has_more_than_x_posts]</phrase>
					</span></td>
				</tr>
			</if>
		</table>
	</div>
</if>


$footer

</body>
</html>',


'ADV_LINKS_REPORT' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title]- $vbphrase[report_to_moderator]</title>
$headinclude
</head>
<body>

$header

$navbar

$linksnav

<form action="misc.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="doreport" />
	<input name="linkid" type="hidden" value="$link[linkid]" />
	<if condition="$type == \'post\'">
		<input name="postid" type="hidden" value="$link[postid]" />
	</if>

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="2"><div class="smallfont" style="float:$stylevar[right]"><b>$vbphrase[link]:</b> <a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]">$link[name]</a></div><b><if condition="$type == \'link\'">$vbphrase[report_link]<else />$vbphrase[report_post]</if></b></td>
			</tr>
		</thead>

		<tbody>
			<tr>
				<td align="center" class="panelsurround">
					<div class="panel">
						<div style="width:640px" align="left">
							<div class="smallfont" style="padding:$stylevar[formspacer]px">

								$usernamecode
								<br />

								<fieldset class="fieldset">
									<legend>$vbphrase[message]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<textarea cols="60" name="reason" rows="6"></textarea>
									</div>
									<div class="smallfont" style="padding:$stylevar[formspacer]px">
										<if condition="$type == \'post\'">
											$vbphrase[only_used_to_report]
										<else />
											$vbphrase[only_used_to_report_links]
										</if>
									</div>
								</fieldset>

								$imagereg
							</div>
						</div>
					</div>
				<div style="padding-top:6px"><input class="button" type="submit" value="$vbphrase[send_report]" /></div>
			</td>
			</tr>
		</tbody>
	</table>
</form>

<br />

$footer
</body>
</html>',


'ADV_LINKS_SEARCH' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title]- $vbphrase[search]</title>
$headinclude
</head>
<body>

$header

$navbar

$linksnav

<form action="search.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="searchresults" />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<tr>
			<td class="tcat" width="100%">$vbphrase[search] $vba_options[links_title]</td>
		</tr>
		<tr>
			<td align="center" class="panelsurround">

				<table cellpadding="0" cellspacing="$stylevar[formspacer]" class="panel" width="100%">
					<tr>
						<td align="$stylevar[left]">
							<fieldset class="fieldset">
								<legend>$vbphrase[search_by_key_word]</legend>
								<div style="padding:$stylevar[formspacer]px">
									$vbphrase[key_words]:<br />
									<input class="bginput" name="string" size="35" type="text" /><br />
<label for="matchwholeword"><input id="matchwholeword" name="matchwholeword" type="checkbox" value="1" /> $vbphrase[match_whole_word_only]</label>
								</div>
							</fieldset>
						</td>
						<td align="$stylevar[left]" width="50%">
							<fieldset class="fieldset">
								<legend>$vbphrase[search_by_user_name]</legend>
								<div style="padding:$stylevar[formspacer]px">
									$vbphrase[username]:<br />
									<input class="bginput" name="username" size="25" type="text" /><br /><label for="exactusername"><input id="exactusername" name="exactusername" type="checkbox" value="1" />$vbphrase[exact_name]</label>
								</div>
							</fieldset>
						</td>
					</tr>
					<if condition="$imagereg">
						<tr>
							<td colspan="2" valign="top">$imagereg</td>
						</tr>
					</if>
				</table>

				<div align="$stylevar[left]" class="thead" style="padding:$stylevar[cellpadding]px">
					<a href="#top" onclick="return toggle_collapse(\'search_options\')" style="float:$stylevar[right]"><img alt="" border="0" id="collapseimg_search_options" src="$stylevar[imgdir_button]/collapse_thead$vbcollapse[collapseimg_search_options].gif" /></a> $vbphrase[search_options]
				</div>

				<div id="collapseobj_search_options" style="$vbcollapse[collapseobj_search_options]">
					<table cellpadding="0" cellspacing="$stylevar[formspacer]" class="panel" width="100%">
						<tr valign="top">
							<td align="$stylevar[left]" width="50%">
								<fieldset class="fieldset">
									<legend>$vbphrase[search_fields]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<table cellpadding="0" cellspacing="0" width="100%">
											<tr>
												<td width="50%"><label for="sf_name"><input checked="checked" id="sf_name" name="fields[]" type="checkbox" value="name" />$vbphrase[link_name]</label></td>
												<td><label for="sf_keywords"><input checked="checked" id="sf_keywords" name="fields[]" type="checkbox" value="keywords" />$vbphrase[keywords]</label></td>
											</tr>
											<tr>
												<td><label for="sf_description"><input checked="checked" id="sf_description" name="fields[]" type="checkbox" value="description" />$vbphrase[description]</label></td>
												<if condition="$vba_options[\'links_allowreplies\']">
													<td>
														<label for="sf_posts"><input id="sf_posts" name="fields[]" type="checkbox" value="pagetext" />$vbphrase[posts]</label>
													</td>
												</if>
												$customfieldboxes
											</tr>
										</table>
									</div>
								</fieldset>

								<fieldset class="fieldset">
									<legend>$vbphrase[find_links_from]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<select name="dateline" style="width:150px">
											<option selected="selected" value="0">$vbphrase[any_date]</option>
											<option value="lastvisit">$vbphrase[your_last_visit]</option>
											<option value="1">$vbphrase[yesterday]</option>
											<option value="7">$vbphrase[a_week_ago]</option>
											<option value="14"><phrase 1="2">$vbphrase[x_weeks_ago]</phrase></option>
											<option value="30">$vbphrase[a_month_ago]</option>
											<option value="90"><phrase 1="3">$vbphrase[x_months_ago]</phrase></option>
											<option value="180"><phrase 1="6">$vbphrase[x_months_ago]</phrase></option>
											<option value="365">$vbphrase[a_year_ago]</option>
										</select>
										<select name="new_old">
											<option selected="selected" value="newer">$vbphrase[and_newer]</option>
											<option value="older">$vbphrase[and_older]</option>
										</select>
									</div>
								</fieldset>

								<if condition="$vba_options[\'links_allowreplies\']">
									<fieldset class="fieldset">
										<legend>$vbphrase[find_links_with]</legend>
										<div style="padding:$stylevar[formspacer]px">
											<select name="leastmost" style="width:150px">
												<option selected="selected" value="least">$vbphrase[at_least]</option>
												<option value="most">$vbphrase[at_most]</option>
											</select>
											<input class="bginput" name="replycount" size="2" style="font-size:11px" type="text" value="0" /> $vbphrase[replies]
										</div>
									</fieldset>
								</if>

								<fieldset class="fieldset">
									<legend>$vbphrase[sort_results_by]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<select name="orderby" style="width:150px">
											<option value="name">$vbphrase[link_name]</option>
											<option value="posts">$vbphrase[number_of_replies]</option>
											<option value="views">$vbphrase[number_of_views]</option>
											<option value="dateline">$vbphrase[date_added]</option>
											<option value="lastpostdateline">$vbphrase[last_posting_date]</option>
											<option value="username">$vbphrase[username]</option>
											<option value="category">$vbphrase[category]</option>
										</select>
										<select name="direction">
											<option selected="selected" value="ASC">$vbphrase[in_ascending_order]</option>
											<option value="DESC">$vbphrase[in_descending_order]</option>
										</select>
									</div>
								</fieldset>

							</td>
							<td width="50%">
								<fieldset class="fieldset">
									<legend>$vbphrase[search_in_categories]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<select name="catids[]" size="13" multiple="multiple" style="width:100%">
											<option $selected[0] value="0">$vbphrase[search_all_categories]</option>
											$categorylist
										</select>
										<div align="$stylevar[left]">
											<label for="subcats"><input checked="checked" id="subdirs" name="subcats" type="checkbox" value="1" />$vbphrase[also_search_sub_categories]</label>
										</div>
									</div>
								</fieldset>
							</td>
						</tr>
					</table>
				</div>
				<div style="padding-top:$stylevar[cellpadding]px">
					<input accesskey="s" class="button" name="dosearch" type="submit" value="$vbphrase[search_now]" />
					<input accesskey="r" class="button" type="reset" value="$vbphrase[reset_fields]" />
				</div>
			</td>
		</tr>
	</table>
</form>

<br />

$footer
</body>
</html>',


'adv_links_search_custombits' =>
'<td><label for="sf_$field[fieldid]"><input checked="checked" id="sf_$field[fieldid]" name="cfields[]" type="checkbox" value="field$field[fieldid]" />$field[title]</label></td>',


'ADV_LINKS_SENDTOFRIEND' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title]- $vbphrase[send_to_friend]</title>
$headinclude
</head>
<body>

$header

$navbar

$linksnav

<form action="misc.php" method="post">
	<input name="s" type="hidden" value="$session[sessionhash]" />
	<input name="do" type="hidden" value="dosendtofriend" />
	<input name="linkid" type="hidden" value="$link[linkid]" />
	<input name="return" type="hidden" value="$return" />
	<input name="catid" type="hidden" value="$catid" />

	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="2"><div class="smallfont" style="float:$stylevar[right]"><b>$vbphrase[link]:</b> <a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]">$linkname</a></div><b>$vbphrase[send_to_friend]</b></td>
			</tr>
		</thead>

		<tbody>
			<tr>
				<td align="center" class="panelsurround">
					<div class="panel">
						<div style="width:640px" align="left">
							<div class="smallfont" style="padding:$stylevar[formspacer]px">

								$usernamecode

								<fieldset class="fieldset">
									<legend>$vbphrase[recipient_name]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<input class="bginput" name="sendtoname" size="50" type="text" />
									</div>
								</fieldset>

								<fieldset class="fieldset">
									<legend>$vbphrase[recipient_email_address]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<input class="bginput" name="sendtoemail" size="50" type="text" />
									</div>
								</fieldset>

								<fieldset class="fieldset">
									<legend>$vbphrase[email_subject]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<input class="bginput" name="subject" size="50" type="text" value="$link[name]" />
									</div>
								</fieldset>

								<fieldset class="fieldset">
									<legend>$vbphrase[message]</legend>
									<div style="padding:$stylevar[formspacer]px">
										<textarea cols="60" name="message" rows="6"><phrase 1="$vba_options[links_homeurl]/showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]" 2="$bbuserinfo[username]">$vbphrase[adv_links_send_to_friend_message]</phrase>
</textarea>
									</div>
								</fieldset>

								$imagereg
							</div>
						</div>
					</div>
				<div style="padding-top:6px"><input class="button" type="submit" value="$vbphrase[send]" /> <input class="button" type="reset" value="$vbphrase[reset]" /></div>
			</td>
			</tr>
		</tbody>
	</table>
</form>

<br />

$footer
</body>
</html>',


'ADV_LINKS_SHOWLINK' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$link[name] - $vba_options[links_title]</title>

$headinclude

<script type="text/javascript">
function openimwindow(imtype, userid, width, height)
{
	return openWindow("$vboptions[bburl]/sendmessage.php?" + SESSIONURL + "do=im&type=" + imtype + "&userid=" + userid, width, height);
}
</script>

<script type="text/javascript">
function open_rating_window(linkid)
{
	window.open("misc.php?do=viewratings&linkid="+linkid, "rating", "toolbar=no, scrollbars=yes, resizable=yes, width=240, height=320");
}
</script>

</head>
<body>

$header

$navbar

$linksnav

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		<td class="tcat" width="100%">$link[name]</td>
		<if condition="$vboptions[\'usepopups\']">
			<td class="vbmenu_control" id="linkopts"><a href="#goto_linkopts">$vbphrase[link_options]</a> <script type="text/javascript"> vbmenu_register("linkopts"); </script></td>
			<if condition="$show[\'ratelink\']">
				<td class="vbmenu_control" id="ratelink"><a href="#goto_ratelink">
					<if condition="$link[\'votetotal\']">
						$vbphrase[rating]: <img alt="" border="0" class="inlineimg" src="$stylevar[imgdir_rating]/rating_$link[roundrating].gif" title="<phrase 1="$link[votenum]" 2="$link[voteavg]">$vbphrase[x_votes_y_average]</phrase>" />
					<else />
						$vbphrase[rate_link]
					</if>
					</a> <script type="text/javascript"> vbmenu_register("ratelink"); </script>
				</td>
			</if>
		</if>
	</tr>
</table>

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		<td class="thead" colspan="2">
			<if condition="$show[\'modopts\'] OR $show[\'report_link\']">
				<span style="float:$stylevar[right]">
					<if condition="$show[\'report_link\']">
						<a href="misc.php?$session[sessionurl]do=report&amp;linkid=$link[linkid]" rel="nofollow"><img class="inline" alt="$vbphrase[report_to_moderator]" border="0" src="$stylevar[imgdir_button]/report.gif" /></a>
					</if>
					<if condition="$show[\'modopts\']">
						<a href="moderate.php?$session[sessionurl]do=getip&amp;l=$link[linkid]"><img class="inline" alt="$vbphrase[ip]: $link[ipaddress]" border="0" class="inlineimg" src="$stylevar[imgdir_button]/ip.gif" /></a>
					</if>
				</span>
			</if>
			<img alt="$post[statustitle]" border="0" class="inlineimg" src="$stylevar[imgdir_statusicon]/post_$link[statusicon].gif" /> $link[dateadded] $link[timeadded]
		</td>
	</tr>
	<tr class="alt1">
		<td width="25%">$vbphrase[description]:</td>
		<td>$link[description]</td>
	</tr>

	<tr class="alt2">
		<td>$vbphrase[url]:</td>
		<td><a href="showlink.php?$session[sessionurl]l=$link[linkid]&amp;linkurl=$link[linkurl]" target="_blank"<if condition="$show[\'nofollow\']"> rel="nofollow"</if>>$link[linkurl_display]</a></td>
	</tr>

	<tr class="alt1">
		<td>$vbphrase[category]:</td>
		<td><a href="browselinks.php?$session[sessionurl]c=$link[catid]">$link[category]</a></td>
	</tr>

	<tr class="alt2">
		<td>$vbphrase[keywords]:</td>
		<td>$link[keywords]</td>
	</tr>

	<tr class="alt1">
		<td>$vbphrase[views]:</td>
		<td>$link[views]</td>
	</tr>

	<if condition="$show[\'replies\']">
		<tr class="alt2">
			<td>$vbphrase[replies]:</td>
			<td>$link[posts]</td>
		</tr>
	</if>
	<tr class="alt1">
		<td>$vbphrase[user]:</td>
		<td>
			<if condition="$link[\'userid\']">
				<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$link[userid]" rel="nofollow">$link[username]</a> <span class="smallfont">(<a href="browselinks.php?$session[sessionurl]do=member&amp;linkuserid=$link[userid]" rel="nofollow"><phrase 1="$link[username]" 2="$plurals">$vbphrase[view_all_of_users_links]</phrase></a>)</span>
			<else />
				$vbphrase[guest]
			</if>
		</td>
	</tr>

	<!-- Custom Fields -->
	$customfieldbits
	<!-- / Custom Fields -->

	<if condition="!$vboptions[\'usepopups\'] AND ((($vba_options[\'links_allowfav\'] OR $show[\'subscribe\']) AND $bbuserinfo[\'userid\']) OR $show[\'sendtofriend\'])">
		<tr>
			<td align="center" class="tfoot" colspan="2">
				<if condition="$vba_options[\'links_allowfav\'] AND $bbuserinfo[\'userid\']">
					<if condition="$link[\'favid\']">
						<a href="misc.php?$session[sessionurl]do=removefav&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[remove_from_favorites]</a>
					<else />
						<a href="misc.php?$session[sessionurl]do=addfav&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[add_to_favorites]</a>
					</if> |
				</if>

				<if condition="$show[\'subscribe\']">
					<if condition="$link[\'issubscribed\']">
						<a href="misc.php?$session[sessionurl]do=unsubscribe&amp;type=link&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[unsubscribe_from_link]</a>
					<else />
						<a href="misc.php?$session[sessionurl]do=subscribe&amp;type=link&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[subscribe_to_link]</a>
					</if>
					|
				</if>
				<if condition="$show[\'sendtofriend\']">
					<a href="misc.php?$session[sessionurl]do=sendtofriend&amp;l=$link[linkid]&amp;return=link$adv_sorturl" rel="nofollow">$vbphrase[send_to_friend]</a>
				</if>
			</td>
		</tr>
	</if>



</table>


<if condition="$vboptions[\'usepopups\']">
	<!-- Link Tools Popup -->
	<div class="vbmenu_popup" id="linkopts_menu" style="display:none">
		<form action="moderate.php" method="post">
			<input name="s" type="hidden" value="$session[sessionhash]" />
			<table border="0" cellpadding="4" cellspacing="1">
				<tr>
					<td class="thead">$vbphrase[link_options]</td>
				</tr>

				<if condition="$show[\'replylink\']">
					<tr>
						<td class="vbmenu_option"><a href="newreply.php?$session[sessionurl]l=$link[linkid]" rel="nofollow">$vbphrase[post_reply]</a></td>
					</tr>
				</if>

				<if condition="$vba_options[\'links_allowfav\'] AND $bbuserinfo[\'userid\']">
					<tr>
						<td class="vbmenu_option">
							<if condition="$link[\'favid\']">
								<a href="misc.php?$session[sessionurl]do=removefav&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[remove_from_favorites]</a>
							<else />
								<a href="misc.php?$session[sessionurl]do=addfav&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[add_to_favorites]</a>
							</if>
						</td>
					</tr>
				</if>

				<if condition="$show[\'sendtofriend\']">
					<tr>
						<td class="vbmenu_option"><a href="misc.php?$session[sessionurl]do=sendtofriend&amp;l=$link[linkid]&amp;return=link" rel="nofollow">$vbphrase[send_to_friend]</a></td>
					</tr>
				</if>

				<if condition="$show[\'subscribe\']">
					<tr>
						<td class="vbmenu_option"><if condition="$link[\'issubscribed\']">
							<a href="misc.php?$session[sessionurl]do=unsubscribe&amp;type=link&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[unsubscribe_from_link]</a>
						<else />
							<a href="misc.php?$session[sessionurl]do=subscribe&amp;type=link&amp;l=$link[linkid]&amp;return=link$adv_sorturl">$vbphrase[subscribe_to_link]</a>
						</if>
						</td>
					</tr>
				</if>

				<if condition="$show[\'report_link\']">
					<tr>
						<td class="vbmenu_option"><a href="misc.php?$session[sessionurl]do=report&amp;linkid=$link[linkid]" rel="nofollow">$vbphrase[report_to_moderator]</a></td>
					</tr>
				</if>

				<if condition="$show[\'modopts\']">
					<tr>
						<td class="thead">$vbphrase[admin_options]</td>
					</tr>
					<tr>
						<td class="vbmenu_option" title="nohilite">
							<div><label for="sticklink"><input id="sticklink" name="do" type="radio" value="sticklink" /><if condition="$link[\'sticky\']">$vbphrase[unstick_link]<else />$vbphrase[stick_link]</if>
							</label></div>

							<div><label for="suspendlink"><input id="suspendlink" name="do" type="radio" value="suspendlink" /><if condition="$link[\'suspended\']">$vbphrase[unsuspend_link]<else />$vbphrase[suspend_link]</if>
							</label></div>

							<div><label for="closelink"><input id="closelink" name="do" type="radio" value="closelink" /><if condition="$link[\'open\']">$vbphrase[close_link]<else />$vbphrase[open_link]</if>
							</label></div>

							<if condition="$countreplies[\'count\']">
								<div><label for="deleteposts"><input id="deleteposts" name="do" type="radio" value="deleteposts" />$vbphrase[delete_posts]</label></div>
							</if>
							<div><label for="deletelink"><input id="deletelink" name="do" type="radio" value="deletelink" />$vbphrase[delete_this_link]</label></div>

						</td>
					</tr>
					<tr>
						<td class="vbmenu_option" title="nohilite">
							<input name="linkid" type="hidden" value="$link[linkid]" />
							<input name="s" type="hidden" value="$session[sessionhash]" />
							<input class="button" type="submit" value="$vbphrase[perform_action]" />
						</td>
					</tr>
				</if>
			</table>
		</form>
	</div>

	<!-- Rate Link Popup -->
	<div class="vbmenu_popup" id="ratelink_menu" style="display:none">
		<form action="newreply.php" method="post">
			<input name="s" type="hidden" value="$session[sessionhash]" />
			<input name="do" type="hidden" value="rate" />
			<input name="linkid" type="hidden" value="$link[linkid]" />
			<table cellpadding="4" cellspacing="1">
				<tr>
					<td class="thead">$vbphrase[rate_link]</td>
				</tr>

				<if condition="$show[\'whoratedlink\']">
					<tr>
						<td class="vbmenu_option"><a href="#" onclick="open_rating_window($link[linkid]);">$vbphrase[view_other_members_ratings]</a></td>
					</tr>
				</if>

				<tr>
					<td class="vbmenu_option" title="nohilite">
						<table cellpadding="0" cellspacing="0">
						<tr>
							<td><label for="vote5"><input id="vote5" name="vote" type="radio" value="5" />$vbphrase[excellent]</label></td>
							<td>&nbsp;<img alt="$vbphrase[excellent]" src="$stylevar[imgdir_rating]/rating_5.gif" /></td>
						</tr>
						<tr>
							<td><label for="vote4"><input id="vote4" name="vote" type="radio" value="4" />$vbphrase[good]</label></td>
							<td>&nbsp;<img alt="$vbphrase[good]" src="$stylevar[imgdir_rating]/rating_4.gif" /></td>
						</tr>
						<tr>
							<td><label for="vote3"><input id="vote3" name="vote" type="radio" value="3" />$vbphrase[average]</label></td>
							<td>&nbsp;<img alt="$vbphrase[average]" src="$stylevar[imgdir_rating]/rating_3.gif" /></td>
						</tr>
						<tr>
							<td><label for="vote2"><input id="vote2" name="vote" type="radio" value="2" />$vbphrase[bad]</label></td>
							<td>&nbsp;<img alt="$vbphrase[bad]" src="$stylevar[imgdir_rating]/rating_2.gif" /></td>
						</tr>
						<tr>
							<td><label for="vote1"><input id="vote1" name="vote" type="radio" value="1" />$vbphrase[terrible]</label></td>
							<td>&nbsp;<img alt="$vbphrase[terrible]" src="$stylevar[imgdir_rating]/rating_1.gif" /></td>
						</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center" class="vbmenu_option" title="nohilite">
						<input class="button" type="submit" value="$vbphrase[vote_now]" />
					</td>
				</tr>
			</table>
		</form>
	</div>
</if>

<table border="0" cellpadding="0" cellspacing="0" width="100%" style="padding-top:5px">
	<tr valign="bottom">
		<if condition="$show[\'replylink\']">
			<td align="$stylevar[left]">
				<a href="newreply.php?$session[sessionurl]l=$link[linkid]" rel="nofollow">
				<if condition="$show[\'closedbutton\']">
					<img alt="" border="0" src="$stylevar[imgdir_button]/threadclosed.gif" />
				<else />
					<img alt="$vbphrase[reply_to_link]" border="0" src="$stylevar[imgdir_button]/reply.gif" /></a>
				</if>
			</td>
		</if>

		<td align="$stylevar[right]">

		<if condition="$show[\'editlink\']"><div><a href="addlink.php?$session[sessionurl]do=editlink&amp;l=$link[linkid]"><img alt="$vbphrase[edit_delete_link]" border="0" src="$stylevar[imgdir_button]/edit.gif" title="$vbphrase[edit_delete_link]" /></a></div></if>
			<if condition="!$vboptions[\'usepopups\']">
				<div>
					<if condition="$show[\'modopts\']">
						<form action="moderate.php" method="post">
							<input name="s" type="hidden" value="$session[sessionhash]" />
							<input name="linkid" type="hidden" value="$link[linkid]" />
							<div class="smallfont">
								<b>$vbphrase[admin_options]:</b>
								<select name="do" onchange="this.form.submit()" style="width:120px">
									<option value="sticklink"><if condition="$link[\'sticky\']">$vbphrase[unstick_link]<else />$vbphrase[stick_link]</if></option>

									<option value="suspendlink"><if condition="$link[\'suspended\']">
									$vbphrase[unsuspend_link]<else />$vbphrase[suspend_link]</if></option>

									<option value="closelink"><if condition="$link[\'open\']">$vbphrase[close_link]<else />$vbphrase[open_link]</if></option>

									<if condition="$countreplies[\'count\']">
										<option value="deleteposts">$vbphrase[delete_posts]</option>
									</if>
									<option value="deletelink">$vbphrase[delete_this_link]</option>

								</select> $gobutton
							</div>
						</form>
					</if>
					<if condition="$show[\'ratelink\']">
						<form action="newreply.php" method="post">
							<input name="s" type="hidden" value="$session[sessionhash]" />
							<input name="linkid" type="hidden" value="$link[linkid]" />
							<div class="smallfont" style="padding-top:5px">
								<b>$vbphrase[rate_link]:
								<select name=vote" onchange="this.form.submit()" style="width:120px">
									<option value="5">5 : $vbphrase[excellent]</option>
									<option value="4">4 : $vbphrase[good]</option>
									<option value="3">3 : $vbphrase[average]</option>
									<option value="2">2 : $vbphrase[bad]</option>
									<option value="1">1 : $vbphrase[terrible]</option>
								</select> $gobutton
							</div>
						</form>
					</if>
				</div>
			</if>
		<div style="padding-top:5px">$pagenav</div></td>
	</tr>
</table>

<br />
<div class="smallfont" align="center">
&laquo; <a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]&amp;goto=previous$adv_sorturl" rel="nofollow">$vbphrase[previous_link]</a> | <a href="showlink.php?$session[sessionurl]do=showdetails&amp;l=$link[linkid]&amp;goto=next$adv_sorturl" rel="nofollow">$vbphrase[next_link]</a> &raquo;</div>
<br />
<if condition="$show[\'postheader\']">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" style="border-bottom-width:0px" width="100%">
		<tr>
			<td class="tcat">$vbphrase[replies_to_link]: $link[name]</td>
		</tr>
	</table>
	$spacer_close


	<div id="posts">$postbit</div>

	<div id="lastpost"></div>

	$spacer_open

	<table width="100%" cellpadding="0" cellspacing="0">
		<tr>
			<if condition="$show[\'replylink\']">
				<td align="$stylevar[left]">
					<a href="newreply.php?$session[sessionurl]l=$link[linkid]" rel="nofollow">
					<if condition="$show[\'closedbutton\']">
						<img alt="" border="0" src="$stylevar[imgdir_button]/threadclosed.gif" />
					<else />
						<img alt="$vbphrase[reply_to_link]" border="0" src="$stylevar[imgdir_button]/reply.gif" /></a>
					</if>
				</td>
			</if>
			<td><div style="padding-top:3px">$pagenav</div></td>
		</tr>
	</table>
<else />

	<div id="posts"></div>

</if>

<br />

<if condition="$show[\'quickreply\']">
<script type="text/javascript" src="$vboptions[bburl]/clientscript/vbulletin_quick_edit.js"></script>
$vBeditTemplate[clientscript]

	<form action="newreply.php" method="post" name="vbform" onsubmit="return qr_prepare_submit(this, $vboptions[postminchars]);" id="qrform">
	<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
		<thead>
			<tr>
				<td class="tcat" colspan="2">
					<a style="float:$stylevar[right]" href="#top" onclick="return <if condition="$show[\'wysiwyg\'] == 2 AND !is_browser(\'ie\')">editor_loaded ? false : </if> toggle_collapse(\'quickreply\');"><img id="collapseimg_quickreply" src="$stylevar[imgdir_button]/collapse_tcat$vbcollapse[collapseimg_quickreply].gif" alt="" border="0" /></a>
					$vbphrase[quick_reply]
				</td>
			</tr>
		</thead>
		<tbody id="qr_error_tbody" style="display:none">
			<tr>
				<td class="thead">$vbphrase[errors_occured_when_submitted]</td>
			</tr>
			<tr>
				<td class="alt1" id="qr_error_td"></td>
			</tr>
			<tr>
				<td class="tfoot" align="center"><span class="smallfont"><a href="#" onclick="return qr_hide_errors()">$vbphrase[okay]</a></span></td>
			</tr>
			</tbody>
			<tbody id="collapseobj_quickreply" style="$vbcollapse[collapseobj_quickreply]">
			<tr>
				<td class="panelsurround" align="center">
					<div class="panel">
						<table cellpadding="0" cellspacing="0" border="0" align="center">
						<tr>
							<td class="smallfont" align="$stylevar[left]">$vbphrase[message]:</td>
						</tr>
						<tr>
							<td id="$editorid" class="vBulletin_editor" align="$stylevar[left]">$messagearea</td>
						</tr>
						<tr>
							<td align="$stylevar[left]">

								<fieldset class="fieldset" style="padding:$stylevar[formspacer]px 0px 0px 0px">
									<legend>$vbphrase[options]</legend>
									<div>
										<if condition="$bbuserinfo[\'signature\']">
											<div style="float:$stylevar[right]"><label for="cb_signature"><input type="checkbox" name="signature" value="1" id="cb_signature" tabindex="5" checked="checked" />$vbphrase[show_your_signature]</label></div>
										</if>
										<label for="qr_quickreply"><input type="checkbox" name="quickreply" value="1" id="qr_quickreply" accesskey="w" tabindex="4" />$vbphrase[quote_message_in_reply]</label>
									</div>
								</fieldset>

							</td>
						</tr>
						</table>
					</div>

					<div style="padding-top:$stylevar[cellpadding]px">
						<input type="hidden" name="s" value="$session[sessionhash]" />
						<input type="hidden" name="do" value="postreply" />
						<input type="hidden" name="linkid" value="$link[linkid]" id="qr_threadid" />
						<input type="hidden" name="p" value="$qrpostid" id="qr_postid" />
						<input type="hidden" name="parseurl" value="1" />
						<input type="hidden" name="clickedelm" value="" />
						<input type="submit" class="button" value="$vbphrase[post_quick_reply]" accesskey="s" title="(Alt + S)" name="sbutton" tabindex="2" id="qr_submit" onclick="this.form.clickedelm.value = this.value" />
						<input type="submit" class="button" value="$vbphrase[go_advanced]" accesskey="x" title="(Alt + X)" name="preview" tabindex="3" id="qr_preview" onclick="this.form.clickedelm.value = this.value" />
					</div>

					<div align="center" id="qr_posting_msg" style="display:none; padding-top:6px">
						<strong>$vbphrase[posting_quick_reply_please_wait]</strong>
					</div>
				</td>
			</tr>
		</tbody>
	</table>
	</form>

	<if condition="!is_browser(\'ie\') AND $show[\'wysiwyg\']">
		<div id="qr_scroll"></div>
	</if>

	<br />

	<script type="text/javascript" src="$vboptions[bburl]/clientscript/vbulletin_quick_reply.js"></script>
</if>

<table cellpadding="2" cellspacing="0" width="100%">
	<tr valign="bottom">
		<td align="$stylevar[left]" width="100%">
			&nbsp;
		</td>
		<td align="$stylevar[right]" valign="bottom">$directoryjump</td>
	</tr>
</table>

$footer
</body>
</html>',


'adv_links_showlink_custombits' =>
'<tr class="$bgclass">
	<td>$field[title]:</td>
	<td>$field[value]</td>
</tr>
',


'adv_links_showlink_keywordbit' =>
'<a href="search.php?$session[sessionurl]do=searchresults&amp;string=$keyword&amp;catid=0&amp;quicksearch=1" rel="nofollow">$keyword</a>',


'adv_links_showlink_ratingbits' =>
'<tr>
<td class="$bgclass"><if condition="$rating[\'userid\']"><a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$rating[userid]" target="_blank">$rating[username]</a><else />$vbphrase[unregistered]</if></td>
<td class="$bgclass" align="center">$rating[rating]</td>
</tr>',


'ADV_LINKS_SHOWLINK_RATINGS' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vba_options[links_title] - $vbphrase[view_other_members_ratings]</title>
$headinclude
</head>
<body style="padding:0px">

<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<tr>
		<td class="tcat" colspan="2"><span class="smallfont">$vbphrase[view_other_members_ratings]</span></td>
	</tr>
	<tr>
		<td class="thead">$vbphrase[username]</td>
		<td class="thead" align="center">$vbphrase[rating]</td>
	</tr>
	$ratingbits
</table>

</body>
</html>');


// ################### Main Phrases Array #########################

// Main phrases
$mainphrases['adv_links'] = array(
	'add_category' => 'Add Category',
	'add_rating_for_link' => 'If you\'d like, you may add a rating for this link.',
	'add_to_favorites' => 'Add to Favorites',
	'additional_options' => 'Additional Options',
	'adv_links_alert_turned_off' => '<strong>Alert:</strong> The links directory is currently turned off!',
	'admin_options' => 'Admin Options',
	'adv_links_send_to_friend_message' => 'I thought you might be interested in this web site:
{1}

From,
{2}',
	'all' => 'All',
	'also_search_sub_categories' => 'Also search sub-categories',
	'ascending' => 'Ascending',
	'awaiting_moderation' => 'Awaiting Moderation',
	'by' => 'by',
	'by_guest_on_date' => 'by Guest on {2} <span class="time">{3}</span>',
	'by_username_on_date' => 'by <a href="{4}">{1}</a> on {2} <span class="time">{3}</span>',
	'categories' => 'Categories',
	'category' => 'Category',
	'category_contains_new_links' => 'Category Contains New Links',
	'category_contains_no_new_links' => 'Category Contains No New Links',
	'category_description' => 'Category / Description',
	'category_manager' => 'Category Manager',
	'category_options' => 'Category Options',
	'category_tools' => 'Category Tools',
	'close_link' => 'Close Link',
	'closed_link' => 'Closed Link',
	'date_added' => 'Date Added',
	'delete_all' => 'Delete All',
	'delete_link_message' => 'To delete this link, check the appropriate box below and then click the \'Delete This Link\' button.',
	'delete_options' => 'Delete Options',
	'delete_this_link' => 'Delete This Link',
	'descending' => 'Descending',
	'description' => 'Description',
	'do_not_delete_link' => 'Do Not Delete This Link',
	'edit_category' => 'Edit Category',
	'edit_delete_link' => 'Edit/Delete Link',
	'edit_link' => 'Edit Link',
	'enter_description_for_website' => 'Please enter a description for your web site.',
	'enter_keywords_for_website' => 'Please enter some keywords for your web site<br />(Used for searching), separated by spaces.',
	'enter_notes_for_website' => 'As a moderator, you may enter any private notes for this link here.',
	'enter_url_for_website' => 'Please enter the URL to the web site here.',
	'error' => 'Error!',
	'find_links_from' => 'Find links from',
	'find_links_with' => 'Find links with',
	'from_the' => 'From the',
	'home' => 'Home',
	'ignore_all' => 'Ignore All',
	'keywords' => 'Keywords',
	'last_link' => 'Last Link',
	'last_reply' => 'Last Reply',
	'last_updated' => 'Last Updated',
	'last_x_days' => 'Last {1} Days',
	'last_x_months' => 'Last {1} Months',
	'link' => 'Link',
	'link_has_more_than_x_posts' => 'This link has more than {1} replies. Click <a href="{2}" target="_blank">here</a> to review all posts.',
	'link_name' => 'Link Name',
	'link_name_description' => 'Link Name &amp; Description',
	'link_notes' => 'Link Notes',
	'link_options' => 'Link Options',
	'link_to_us' => 'Link To Us',
	'links' => 'Links',
	'links_in_category' => 'Links in Category',
	'match_whole_word_only' => 'Match whole word only',
	'moderate_new' => 'Moderate New',
	'moderate_x' => 'Moderate {1}',
	'my_favorites' => 'My Favorites',
	'my_favorites_description' => 'Here you will find a list of all links that have been added to your favorites category.',
	'my_stuff' => 'My Stuff',
	'my_subscriptions' => 'My Subscriptions',
	'my_subscriptions_description' => 'Here you will find a list of all links and/or categories in which you are subscribed to.',
	'new_hot_link' => 'New Hot Link',
	'new_link' => 'New Link',
	'new_links' => 'New Links',
	'newest_x_links' => 'Newest {1} Links',
	'next_link' => 'Next Link',
	'no_x_awaiting_moderation' => 'No {1} Awaiting Moderation',
	'no_x_to_display' => 'No {1} to Display',
	'old_hot_link' => 'Old Hot Link',
	'old_link' => 'Old Link',
	'only_used_to_report_links' => '<b>Note:</b> This should ONLY be used to report broken links, spam, inappropriate content, or otherwise problematic links.',
	'open_link' => 'Open Link',
	'parent_category' => 'Parent Category',
	'please_choose_a_category' => 'Please Choose a Category',
	'please_enter_name_of_site' => 'Please enter the name of the web site you are submitting here.',
	'please_select_one' => 'Please select one',
	'plural_s' => 's',
	'post_reply' => 'Post Reply',
	'powered_by_vba_links' => 'Powered by: vBadvanced Links Directory v{1}',
	'previous_link' => 'Previous Link',
	'random_links' => 'Random Links',
	'rate' => 'Rate',
	'rate_link' => 'Rate Link',
	'rated' => 'Rated',
	'rating' => 'Rating',
	'reciprocal_link_url' => 'Reciprocal Link URL',
	'reciprocal_link_url_desc_optional' => 'If you have linked back to our site, you may enter the URL to your reciprocal link here.',
	'reciprocal_link_url_desc_require' => 'Please enter the URL to the page on your web site that contains a reciprocal link back to our web site. Please note that this is required and must be present before you may submit your link.',
	'remove_from_favorites' => 'Remove From Favorites',
	'replied_to' => 'Replied to',
	'replies_to_link' => 'Replies to Link',
	'reply_to_link' => 'Reply To Link',
	'report_link' => 'Report Link',
	'report_post' => 'Report Post',
	'report_to_moderator' => 'Report to Moderator',
	'search_all_categories' => 'Search All Categories',
	'search_fields' => 'Search fields',
	'search_in_categories' => 'Search in Categories',
	'search_this_category' => 'Search This Category',
	'select_category_for_website' => 'Please select the category into which your site best fits.',
	'send_email' => 'Send Email',
	'send_to_friend' => 'Send to Friend',
	'show_links' => 'Show Links',
	'showing_links_x_to_y_of_z' => 'Showing links {1} to {2} of {3} ',
	'since_your_last_visit' => 'Since Your Last Visit',
	'sort_order' => 'Sort Order',
	'sorted_by' => 'Sorted By',
	'stick_link' => 'Stick Link',
	'sticky_link' => 'Sticky Link',
	'sub_categories' => 'Sub-Categories',
	'submit_a_link' => 'Submit a Link',
	'subscribe_to_link' => 'Subscribe to Link',
	'subscribe_to_this_category' => 'Subscribe to This Category',
	'suggest_new_category' => 'Suggest New Category',
	'suspend_link' => 'Suspend Link',
	'title' => 'Title',
	'top_x_rated_links' => 'Top {1} Rated Links',
	'top_x_replied_to_links' => 'Top {1} Replied to Links',
	'top_x_visited_links' => 'Top {1} Visited Links',
	'top_x_y_links' => 'Top {4} <select name="orderby" onchange="this.form.submit();">
<option {5} value="views">{1}</option>
<option {6} value="posts">{2}</option>
<option {7} value="rating">{3}</option>
</select>
Links',
	'total_views' => 'Total Views',
	'unstick_link' => 'Unstick Link',
	'unsubscribe_from_link' => 'Unsubscribe From Link',
	'unsubscribe_from_this_category' => 'Unsubscribe From This Category',
	'unsuspend_link' => 'Un-suspend Link',
	'url' => 'URL',
	'usernames_links' => '{1}\'{2} Links',
	'validate' => 'Validate',
	'validate_all' => 'Validate All',
	'view_all_of_users_links' => 'View All of {1}\'{2} Links',
	'view_link_details' => 'View Link Details',
	'view_other_members_ratings' => 'View Other Members Ratings',
	'view_parent_category' => 'View Parent Category',
	'view_site' => 'View Site',
	'view_x_beginning_with_letter_y' => 'View {1} beginning with the letter {2}',
	'viewed' => 'Viewed',
	'votes_average' => '{1} votes - {2} average',
	'website_name' => 'Web Site Name',
	'whats_new' => 'What\'s New',
	'whats_popular' => 'What\'s Popular',
	'x_awaiting_moderation' => '{1} Awaiting Moderation',
	'you_are_subscribed_to_this_link' => 'You are subscribed to this link'
);

$mainphrases['adv_links_managecats'] = array(
	'add_sub_category' => 'Add Sub-Category',
	'allow_other_users_add_links' => 'Allow Other Users to Add Links to Category',
	'allow_other_users_rate' => 'Allow Other Users to Rate Links',
	'allow_other_users_reply' => 'Allow Other Users to Reply to Links',
	'allow_other_users_view' => 'Allow Other Users to View Category',
	'are_you_sure_delete_category' => 'Are you sure you want to delete this category? Doing so will also delete all links in this category!',
	'are_you_sure_empty_category' => 'Are you sure you want to empty this category? Doing so will also delete all links in this category!',
	'confirm_password' => 'Confirm Password',
	'empty' => 'Empty',
	'empty_category' => 'Empty Category',
	'if_you_would_like_change_password' => 'If you would like to change the password for this category, enter the current password here and then the new password in the spaces below.',
	'if_you_would_like_enter_password_category' => 'If you would like, you may protect this category with a password.',
	'please_enter_description_for_category' => 'Please enter a description for this category.',
	'please_enter_title_for_category' => 'Please enter a title for this category.',
	'please_select_category_for_yours_appear_under' => 'Please select the category in which you would like for your new category to appear under.',
	'remove_category' => 'Remove Category',
	'unlimited' => 'Unlimited',
	'you_do_not_have_any_categories' => 'You do not currently have any categories.',
	'you_have_used_x_out_of_y_categories_allowed' => 'You have used {1} out of {2} categories allowed.'
);

// Admin CP Phrases
$mainphrases['adv_links_cp'] = array(
	'access_options' => 'Access Options',
	'act_as_category' => 'Act as Category?<div class="smallfont">Will act as a &quot;Header Category&quot; if no.</div>',
	'add_a_category' => 'Add Category',
	'add_a_link' => 'Add Link',
	'add_banner' => 'Add Banner',
	'add_custom_field' => 'Add Custom Field',
	'add_category' => 'Add Category',
	'add_link' => 'Add Link',
	'add_moderator' => 'Add Moderator',
	'add_moderator_note_permissions' => 'Please note that making an user a moderator gives them permission to edit, delete, suspend, and stick links in this category. It also gives them permission to edit and delete posts.',
	'all_categories' => 'All Categories',
	'all_links' => 'All Links',
	'allow_icons' => 'Allow Icons',
	'allow_ratings' => 'Allow Ratings',
	'allow_replies' => 'Allow Replies',
	'allow_users_create_subcats' => 'Allow Users to Create Sub-Categories',
	'also_apply_to_subcategories' => 'Also Apply to Sub-Categories',
	'apply_this_password_to_child_categories' => 'Apply this password to child categories',
	'are_you_sure_delete_link' => 'Are you sure you want to delete <b>{1}?<br /> This link can not be recovered once it is deleted!</b>',
	'are_you_sure_delete_this_banner' => 'Are you sure you want to delete this banner?',
	'are_you_sure_delete_this_report' => 'Are you sure you want to delete this report?',
	'automatically_parse_links_in_text' => 'Automatically Parse Links in Text',
	'banner_image' => 'Banner Image',
	'broken_problematic_links' => 'Broken / Problematic Links',
	'can_add_links' => 'Can Add Links',
	'can_create_categories' => 'Can Create Categories',
	'can_delete_others_links' => 'Can Delete Others\'s Links',
	'can_delete_others_posts' => 'Can Delete Others\' Posts',
	'can_delete_own_links' => 'Can Delete Own Links',
	'can_delete_own_posts' => 'Can Delete Own Posts',
	'can_edit_others_links' => 'Can Edit Other\'s Links',
	'can_edit_others_posts' => 'Can Edit Others\' Posts',
	'can_edit_own_links' => 'Can Edit Own Links',
	'can_edit_own_posts' => 'Can Edit Own Posts',
	'can_have_password' => 'Can have password
<div class="smallfont">(Setting this to no will prevent a password from being inherited from a parent category.)</div>',
	'can_rate_links' => 'Can Rate Links',
	'can_reply_to_links' => 'Can Reply to Links',
	'can_report_links_posts' => 'Can Report Links / Posts',
	'can_search_links' => 'Can Search Links',
	'can_see_who_rated' => 'Can See Who Rated',
	'can_send_link_friend' => 'Can Send Links to Friends',
	'can_view_category' => 'Can View Category',
	'can_view_links' => 'Can View Links',
	'can_view_links_directory' => 'Can View Links Directory',
	'can_view_replies_to_links' => 'Can View Replies to Links',
	'category_is_valid_not_awaiting_moderation' => 'Category is Validated<div class="smallfont">Category appears as &quot;Awaiting Moderation&quot; and is unaccessible otherwise.</div>',
	'check_for' => 'Check for',
	'checkbox_multiple_options' => 'Checkbox (Multiple options)',
	'checking_link_x' => 'Checking link &quot;{1}&quot;...',
	'click_here_if_stuck' => 'Click here if this page gets stuck for more than one minute',
	'current_image' => 'Current Image',
	'currently_running_latest_available' => 'You are currently running vBadvanced Links Directory v{1}.<br />
<br />
The latest version available is {2}.<br />
<br />
{3}',
	'custom_field_type' => 'Custom Field Type',
	'deleted_link_key' => 'Deleted Link: {1}<br />',
	'direction' => 'Direction',
	'do_you_wish_to_remove_x_from_moderating_y' => 'Do you wish to remove {1} as a moderator of {2}?',
	'categories_to_appear_in' => 'Categories to Appear In
<div class="smallfont">Here you may choose which category(ies) you would like for this custom field to appear in. To have this custom field appear in all categories simply choose the \'All Categories\' option. To select more than one category, hold down your \'Ctrl\' key while selecting the categories with your mouse.',
	'category_is_active_will_not_appear_ramians_accessible' => 'Category is Active
<div class="smallfont">Will not appear if set to no, but remains accessible if the category\'s URL is known.</div>',
	'category_is_open_for_links' => 'Category is Open For Links<br />
<span class="smallfont">Set this to \'No\' if you would like to prevent any new links from being submitted in this category.</span>',
	'category_is_open_for_posts' => 'Category is Open For Posts<br />
<span class="smallfont">Set this to \'No\' if you would like to prevent any new posts from being made in this category.</span>',
	'category_options' => 'Category Options',
	'category_owner_enter_username' => 'Category Owner
<div class="smallfont">If you would like this category to belong to a specific user, enter that user\'s name here.<br />
<b>Note:</b> The rest of the User Options only apply if you enter an username here.',
	'category_parent' => 'Category Parent',
	'category_password_acts_in_addition_other_permissions' => 'Category Password
<div class="smallfont">(Optional: This acts in addition to any other permissions set for this category.)</div>',
	'do_nothing' => 'Do Nothing',
	'edit_banner' => 'Edit Banner',
	'edit_custom_field' => 'Edit Custom Field',
	'edit_category' => 'Edit Category',
	'edit_category_permissions_for_usergroup_x_in_category_y' => 'Edit Category Permissions For Usergroup: <i>{1}</i> in Category <i>{2}</i>',
	'edit_link_to_us_page_banners' => 'Edit Link to Us Page Banners',
	'email_address_to_notify_when_new_link' => 'Email addresses to notify when a new link is submitted<br />
<span class="smallfont">(Separate each address with a space)</span>',
	'email_address_to_notify_when_new_post' => 'Email addresses to notify when a new post is made<br />
<span class="smallfont">(Separate each address with a space)</span>',
	'field_is_searchable' => 'Field is searchable',
	'filesize' => 'Filesize',
	'find_duplicate_links' => 'Find Duplicate Links',
	'find_duplicate_links_desc' => 'This tool will allow you to easily find and remove duplicate links.',
	'for_setting_to_have_effect_custom_permissions_must_be_enabled' => 'For this setting to have any effect, custom permissions for this usergroup must be enabled. The radio button above has been changed for you to allow this.',
	'general_options' => 'General Options',
	'generate_new_report' => 'Generate New Report',
	'generate_report' => 'Generate Report',
	'generate_report_note' => 'This tool will attempt to generate a report with the status of each of your links, helping you to find broken or otherwise problematic links. It can also be used to find web sites which have removed your reciprocal link by changing the &quot;Check for&quot; option to &quot;Reciprocal Links&quot;.<br />Please note that reports may take quite some time to be generated depending on the number of links you have.',
	'id' => 'id',
	'ignore_all' => 'Ignore All',
	'inactive' => 'Inactive',
	'incomplete' => 'Incomplete',
	'last_link_info' => 'Last Link Info',
	'last_post_info' => 'Last Post Info',
	'last_posting_date' => 'Last Post Date',
	'link_counts' => 'Link Counts',
	'link_description' => 'Link Description',
	'link_adding_editing_options' => 'Link Adding/Editing Options',
	'linkid' => 'Linkid',
	'links_admin' => 'Links Admin',
	'manage_moderators' => 'Manage Moderators',
	'mass_delete' => 'Mass Delete Links',
	'mass_delete_suspend' => 'Mass Delete / Suspend',
	'maximum_categories_set_0_no_limit' => 'Maximum number of categories<div class="smallfont">The maximum number of categories a user in this group may create. Set this to 0 for unlimited.<br />Note that the &quot;Allow Users to Create Categories&quot; option under your main settings must be enabled as well.</div>',
	'moderate_this_groups_categories' => 'Moderate This Group\'s Categories',
	'moderate_this_groups_links' => 'Moderate This Group\'s Links',
	'moderate_this_groups_posts' => 'Moderate This Group\'s Posts',
	'modify_links_categories' => 'Modify Links Categories',
	'modify_permissions' => 'Modify Permissions',
	'newer_version_available' => '<b>There is a newer version of vBadvanced Links Directory available!</b>',
	'no_banners_currently_uploaded' => 'No banners currently uploaded.',
	'no_data' => 'No Data',
	'no_follow_links' => 'No Follow Links<div class="smallfont">This option will add rel=&quot;nofollow&quot; to any links submitted to this category to prevent spiders from crawling those links.</div>',
	'no_links_matched_query' => 'No Links Matched Your Query',
	'no_links_selected' => 'You haven\'t selected any links!',
	'not_added_custom_fields' => 'You have not added any custom fields',
	'not_awaiting_moderation_or_suspended' => 'Not awaiting moderation or suspended',
	'not_found' => 'Not Found',
	'number_of_links_to_process' => 'Number of links to process at a time',
	'open' => 'Open',
	'permissions_color_key' => '<div class="darkbg" style="border:2px inset"><div style="padding: 4px"><b>Color Key:</b></div><ul class="darkbg" style="padding: 0px; padding-top: 0px; padding-left: 24px; padding-bottom: 8px;"><li class="col-g"><b>Standard:</b> Using default usergroup permissions.</li><li class="col-c"><b>Customized:</b> Using custom permissions for this usergroup.</li><li class="col-i"><b>Inherited:</b> Using custom permissions inherited from a parent category.</li></ul></div>',
	'please_note_categories_ordered_by_title' => 'Please note that you currently have your options set to order categories alphabetically, therefore the &quot;Display Order&quot; here will have no effect. This may be changed by setting your &quot;Order Categories By&quot; option to sort by &quot;Display Order&quot; in your main vBa Links Directory settings.',
	'please_select_category_to_move_links_to' => 'Please select the category you wish to move the selected links to.',
	'post_counts' => 'Post Counts',
	'posting_options' => 'Posting Options',
	'previous_reports' => 'Previous Reports',
	'private_category' => 'Private Category?',
	'radio_options_must_choose' => 'Radio (Two options, must choose one or the other)',
	'reciprocal_link_check' => 'Reciprocal Link Check <div class="smallfont">This option will allow you to check for and/or require that links being submitted to this category have a link back to your site.</div>',
	'reciprocal_links' => 'Reciprocal Links',
	'remove_x_from_moderating_y' => 'Remove {1} from moderating {2}',
	'required_field_missing_be_sure_entered_all' => 'A required field was missing! Please be sure you entered a Name and URL for your link!',
	'select_preset_options' => 'Select (Preset options in a drop-down select box)',
	'serialize' => 'Serialize',
	'setting_group' => 'Setting Group',
	'show' => 'Show',
	'show_links_that_are' => 'Show links that are',
	'showing_links_in' => 'Showing links in',
	'status_report_no_generated_date_time' => 'Status Report #{1}&nbsp;&nbsp;&nbsp;Generated on {2}&nbsp;&nbsp;&nbsp;in {3}min {4} sec.',
	'status_reports' => 'Status Reports',
	'sticky' => 'Sticky',
	'submitted_by' => 'Submitted By',
	'suspend' => 'Suspend',
	'suspend_all' => 'Suspend All',
	'suspended' => 'Suspended',
	'suspended_link_key' => 'Suspended Link: {1}<br />',
	'text_input_single_line' => 'Text Input (Single line of text)',
	'textarea_multiple_line' => 'Textarea (Multiple lines of text)',
	'to_further_customize_page' => 'Note: To further customize this page, you may modify the \'ADV_LINKS_LINKTOUS\' template through the <a href="template.php?do=modify">Style Manager</a> and add your own code.',
	'type' => 'Type',
	'update_categories' => 'Update Categories',
	'update_categories_counters_desc' => 'This tool will allow you to update your category counters. Please check the appropriate boxes to the right and then press the "Update Counters" button.',
	'update_counters' => 'Update Counters',
	'update_last_posts' => 'Update Last Post Info',
	'update_last_posts_desc' => 'This tool will search through all of your links and update the last post info for each.',
	'update_order' => 'Update Order',
	'use_custom_permissions' => 'Use Custom Permissions',
	'use_default_permissions_note_delete_previous_permissions_set' => 'Use Default Permissions (Note: this will delete any previous custom permissions set)',
	'use_default_setting' => 'Use Default Setting',
	'user_options' => 'User Options',
	'valid' => 'Valid',
	'validated' => 'Validated',
	'vbadvanced_links_category' => 'vBadvanced Links Directory',
	'view_category' => 'View Category',
	'welcome_to_vba_links_control_panel' => 'Welcome to the vBadvanced Links Directory Admin Control Panel',
	'x_options' => '{1} Options',
	'x_percent_complete' => '{1}% Complete.',
	'yes_do_not_require' => 'Yes, but do not require the link',
	'yes_require' => 'Yes, require a reciprocal link',
	'you_have_chosen_to_x_links' => 'You have chosen to {1} the following links:',
	'your_vba_version_up_to_date' => 'Your version of vBadvanced Links Directory is up to date.'
);

// Redirection phrases
$mainphrases['frontredirect'] = array(
	'adv_links_addedfav' => '$linkname has been added to your favorites.',
	'adv_links_addedsubscription' => 'Your subscription to $subname has been added.',
	'adv_links_category_emptied' => 'Your category has been emptied.',
	'adv_links_category_deleted' => 'Your category has been removed',
	'adv_links_closed' => '$link[name] has been closed. You are now being returned to the link.',
	'adv_links_deleted' => '$link[name] has been deleted.',
	'adv_links_linkedited' => 'Your link has been successfully modified!',
	'adv_links_opened' => '$linkname has been opened. You are now being returned to the link.',
	'adv_links_posts_deleted' => 'The selected posts have been deleted. You are now being returned to the link.',
	'adv_links_removedfav' => '$linkname has been removed from your favorites.',
	'adv_links_removedsubscription' => 'Your subscription to $subname has been removed.',
	'adv_links_stucklink' => '$linkname has been stuck.',
	'adv_links_suspendedlink' => '$linkname has been suspended.',
	'adv_links_transferring' => 'Transferring you to $linkname...',
	'adv_links_unstucklink' => '$linkname has been unstuck.',
	'adv_links_unsuspendedlink' => '$linkname has been un-suspended.',
	'adv_new_x_validated' => 'Validated new $type.',
	'adv_links_addednew' => 'Thank you, your link has been added. You will now be taken to your link.'
);

// Email body phrases
$mainphrases['emailbody'] = array(
	'adv_links_deletion' => 'Hello $link[username],
This is to inform you that your link ($link[name]) was not approved and was removed from our database.

Possible reasons for this may include:
1) Inappropriate content.
2) Wrong category.
3) Irrelevant or not pertaining to our web site.

Yours,
$vboptions[hometitle] Team',
	'adv_links_newlink' => 'Hello,

$bbuserinfo[username] has just submitted a new link in the $cat[title] category. You may view the link here:

$vba_options[links_homeurl]/showlink.php?do=showdetails&l=$newlinkid

Here are the details for that link:
************************
Name: $link[name]
URL: $link[linkurl]
Description: $link[description]
User: $bbuserinfo[username]
************************',
	'adv_links_newpost' => 'Hello,

$bbuserinfo[username] has just replied to a link entitled $link[name] in the $catemail[title] category of $vba_options[links_title].

This link is located at $vba_options[links_homeurl]/showlink.php?do=showdetails&l=$linkid

Here is the message that has just been posted:
**********************
$post[message]
**********************',
	'adv_links_reportlink' => '$bbuserinfo[username] ( mailto:$bbuserinfo[email] ) has reported this link:

$cat[name]
$vba_options[links_homeurl]/showlink.php?do=showdetails&l=$linkid

This is the reason that the user gave:
$reason

This message has been sent to all moderators of this category and all administrators.

Please respond to this as applicable.',
	'adv_links_reportpost' => '$bbuserinfo[username] ( mailto:$bbuserinfo[email] ) has reported this post:

$cat[name]
$vba_options[links_homeurl]/showlink.php?do=showdetails&amp;l=$linkid#post$postid

This is the reason that the user gave:
$reason

This message has been sent to all moderators of this category and all administrators.

Please respond to this post as applicable.',
	'adv_links_subscribe_link' => 'Hello $subscription[username],
$username has just replied to a link you have subscribed to entitled - $link[name] - in the $categoryname category of $vba_options[links_title].

This link is located at: $vba_options[links_homeurl]/showlink.php?do=showdetails&l=$link[linkid]&goto=newpost

Here is the message that has just been posted:
*******************
$post[message]
*******************

There may be other replies also, but you will not receive any more notifications until you visit the category again.

Yours, $vboptions[hometitle] team


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Unsubscription information: To unsubscribe from this link, please visit this page: $vba_options[links_homeurl]/misc.php?do=unsubscribe&return=link&l=$linkid.',
	'adv_links_subscribecat' => 'Hello $subscription[username],

You are subscribed to the category $link[category], there have been $linkcount new links and $postcount new posts.
$vba_options[links_homeurl]/browselinks.php?c=$link[catid]

The following links are new:
$newlinkbits

The following links have new posts:
$newpostbits

Yours,
$vboptions[hometitle] team

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Unsubscription information:

To unsubscribe from this category, please visit this link:
$vba_options[links_homeurl]/misc.php?do=unsubscribe&type=cat&catid=$link[catid]
',
	'adv_links_subscribecat_postbit' => '************
$post[name]
$vba_options[links_homeurl]/showlink.php?l=$post[linkid]&p=$post[postid]#post$post[postid]
Link submitted by: $post[username]
On: $post[dateline]
',
	'adv_links_subscribecatbit' => '************
$link[name]
$vba_options[links_homeurl]/showlink.php?l=$link[linkid]
In Category: $link[category]
Submitted by: $link[username]
Last post: $link[lastpost]
',
	'adv_links_validation' => 'Hello $link[username],
This is to inform you that your link ($link[name]) has been approved and has been added to our database.

You may view your link here: $vba_options[links_homeurl]/showlink.php?l=$linkid

Yours,
$vboptions[hometitle] Team'
);

// Email subject phrases
$mainphrases['emailsubject'] = array(
	'adv_links_deletion' => 'Your link was removed.',
	'adv_links_newlink' => 'New Link Notification: $cat[title]',
	'adv_links_newpost' => 'New Post Notification: $catemail[title]',
	'adv_links_reportlink' => 'Reported link from $vba_options[links_title]',
	'adv_links_reportpost' => 'Reported post from $vba_options[links_title]',
	'adv_links_subscribe_link' => 'Reply to Link: $link[name]',
	'adv_links_subscribecat' => '"$link[category]" Update',
	'adv_links_validation' => 'Your link has been approved!'
);

// Error phrases
$mainphrases['error'] = array(
	'adv_links_cant_have_category_without_title' => 'You can\'t have a category without a title!',
	'adv_links_cant_parent_category_to_self' => 'You can\'t parent a category to itself!',
	'adv_links_categorypassword' => '<p>A password is required to access this category. Please enter this password now. Note: This requires cookies!</p>

<form action="browselinks.php" method="post">
<input name="s" value="{1}" type="hidden" />
<input name="do" value="enterpassword" type="hidden" />
<input name="url" value="{2}" type="hidden" />
<input name="catid" value="{3}" type="hidden" />

<div align="center" style="padding="$stylevar[cellpadding]"><b>Password:</b> <input class="bginput" name="catpassword" type="password" /> <input class="button" value="Submit" type="submit" /></div>
</form>',
	'adv_links_custom_chosen_all' => 'It appears that you have chosen to only apply this custom field to specific categories, but you have also chosen the \'All Categories\' option as well. Please go back and either select only the \'All Categories\' option, or choose your specific categories and de-select the \'All Categories\' option.',
	'adv_links_duplicate' => 'The URL (<a href="{1}">{1}</a>) is already in our database. We\'re sorry, but duplicate URL\'s are not allowed.
{2}',
	'adv_links_duplicate_filename' => 'A file called "{1}" already exists. Please rename your file and try again.',
	'adv_links_duplicate_viewlink' => 'Please <a href="showlink.php?do=showdetails&amp;l={1}">click here</a> if you would like to view the existing entry for this link.',
	'adv_links_error_no_search_fields' => 'You must choose some fields to search in!',
	'adv_links_invalid_url' => 'The URL you entered is not valid. Please make sure that you have entered a valid URL.',
	'adv_links_invalid_reciprocal_url' => 'We could not find a link back to our site on the URL you have entered for the &quot;Reciprocal Link URL&quot; option. Please ensure that the link has already been added, and that it is pointing to &quot;{1}&quot;',
	'adv_links_keyword_too_long' => 'One or more of the keywords you have entered ({1}) is too long. Please make sure all keywords are {2} characters or less.',
	'adv_links_missingfiled' => 'A required field was missing. Please be sure you entered a title, URL, and description for your link.',
	'adv_links_moderators_only' => 'You must be a links directory moderator to access this section.',
	'adv_links_must_choose_category' => 'You must choose a category for your link.',
	'adv_links_must_choose_category_move' => 'You must choose a category to move the links to!',
	'adv_links_must_choose_parent_for_category' => 'You must choose a parent category in which your new category will appear under.',
	'adv_links_must_check_show_links_that_are' => 'You must check at least one box in the &quot;Show links that are" option.',
	'adv_links_must_choose_title_for_custom' => 'You must choose a title for your custom field!',
	'adv_links_must_choose_update' => 'You must choose something to update!',
	'adv_links_nodelete' => 'You must check the "Delete This {1}" box to delete this {1}.',
	'adv_links_not_open_for_posts' => 'Sorry, but this category is not open for new posts.',
	'adv_links_novotingperms' => 'Sorry, but you do not have permission to vote on links.',
	'adv_links_reciprocal_links_disabled' => 'Reciprocal link checking failed. This usually means that you either have your &quot;Reciprocal Link Check&quot; option turned off, or your &quot;Reciprocal Link URL&quot; setting is invalid. Please check these under your main vBa Links Directory settings and try again.',
	'adv_links_reciprocal_url_must_match' => 'The domain name in the reciprocal URL you have entered does not match the domain name for the web site URL you have entered. These two links must be from the same domain.',
	'adv_links_search_nocat' => 'You must choose a category to search in!',
	'adv_links_submitted' => 'Thank you! Your link has been successfully submitted to the database. It will appear once an admin has had time to review and approve it.<br /><br />
<a href="index.php{1}">Click here to return to {2}</a>',
	'adv_links_too_many_keywords' => 'You have entered too many keywords ({1}). Please limit your keywords to {2} words or less.',
	'adv_links_updated_counters' => 'Updated counters sucessfully.',
	'adv_links_upload_dir_not_writable' => 'Your "Banner Upload Category" is not writable. Please ensure that the path you have entered for your "Banner Upload Category" setting is correct and that the category is chmod to 777.',
	'adv_links_x_too_long' => 'The {1} you have entered is too long ({2} characters). The maximum number of characters allowed is {3}.',
	'adv_links_your_link_has_been_added' => 'Your link has been sucessfully added to the database.'
);

// CP home phrases
$mainphrases['cphome'] = array(
	'vba_links_directory' => 'vBa Links Directory',
	'modify_settings' => 'Modify Settings',
	'manage_categories' => 'Manage Categories',
	'add_category' => 'Add Category',
	'usergroup_permissions' => 'Usergroup Permissions',
	'category_permissions' => 'Category Permissions',
	'add_link' => 'Add Link',
	'mass_manage_links' => 'Mass Manage Links',
	'custom_fields' => 'Custom Fields',
	'validate_new_links' => 'Validate New Links',
	'validate_new_posts' => 'Validate New Posts',
	'validate_new_categories' => 'Validate New Categories',
	'edit_link_to_us_page' => 'Edit Link to Us Page',
	'maintenance' => 'Maintenance',
	'status_reports' => 'Status Reports'
);

$mainphrases['style'] = array(
	'group_adv_links' => 'vBadvanced Links Directory'
);

$mainphrases['cron'] = array(
	'task_adv_links_rand_title' => 'vBa Links Directory Random Homepage Links',
	'task_adv_links_rand_desc' => 'Generates a list of random linkids for use on your links directory homepage.',
	'task_adv_links_search_title' => 'vBa Links Directory Search Cleanup',
	'task_adv_links_search_desc' => 'Removes old search info.',
	'task_adv_links_subscriptions_title' => 'vBa Links Directory Subscriptions',
	'task_adv_links_subscriptions_desc' => 'Sends out subscribed emails.'
);


// ##### Settinggroups
$mainphrases['vbsettings'] = array(
	'settinggroup_adv_global' => 'vBadvanced Global Options',
	'settinggroup_adv_links_addlink' => 'Add Links Options',
	'settinggroup_adv_links_browselinks' => 'Browselinks Options (browselinks.php)',
	'settinggroup_adv_links_categorybit' => 'Category Options',
	'settinggroup_adv_links_index' => 'Main Index Page Options',
	'settinggroup_adv_links_main' => 'Main Options',
	'settinggroup_adv_links_posting' => 'Posting Options',
	'settinggroup_adv_links_showlink' => 'Show Link Options (showlink.php)',
	'settinggroup_adv_links_title_paths' => 'Title, URL\'s, and Paths',
	'settinggroup_adv_links_usercats' => 'User Category Options'
);


// ##### Settings #############################################################
$mainsettings['adv_global'] = array(
	'global_header_replace' => array(
		'title' => 'Header Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your header that should be prefixed with your Forum\'s URL.',
		'value' => '',
		'optioncode' => 'textarea',
		'displayorder' => '1'
	),
	'global_navbar_replace' => array(
		'title' => 'Navbar Replacements',
		'description' => 'Here you may enter a list of filenames that should be prefixed with your Forum\'s URL.',
		'value' => 'memberlist.php
usercp.php
register.php
faq.php
calendar.php
search.php
login.php
forumdisplay.php
profile.php
private.php
subscription.php
member.php
online.php',
		'optioncode' => 'textarea',
		'displayorder' => '2'
	),
	'global_footer_replace' => array(
		'title' => 'Footer Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your footer that should be prefixed with your Forum\'s URL.',
		'value' => 'archive
sendmessage.php
profile.php',
		'optioncode' => 'textarea',
		'displayorder' => '3'
	)
);

$mainsettings['adv_links_title_paths'] = array(
	'links_title' => array(
		'title' => 'Links Directory Title',
		'description' => 'The title of your links directory. This will be displayed in the navbar, &lt;title&gt; tags, and other places throughout the program.',
		'value' => 'Links Directory',
		'optioncode' => '',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_homeurl' => array(
		'title' => 'Links Home URL',
		'description' => 'The URL to your vBadvanced Links Directory folder, with NO trailing slash, filename, or anything else at the end.<br />
Ex: http://yoursite.com/links',
		'value' => '',
		'optioncode' => '',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_uploaddir' => array(
		'title' => 'Link to Us Banner Upload Directory',
		'description' => 'The full path (NOT the URL!) to the folder in which your banner images for your &quot;Link to Us&quot; page will be stored. Ex: /home/yoursite/public_html/links/banners',
		'value' => '',
		'optioncode' => '',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_uploadurl' => array(
		'title' => 'Link to Us Banner Upload URL',
		'description' => 'The URL to the folder in which your banner images for your &quot;Link to Us&quot; page will be stored.',
		'value' => '',
		'optioncode' => '',
		'displayorder' => '4',
		'serialize' => 0
	)
);

$mainsettings['adv_links_main'] = array(
	'links_version' => array(
		'title' => 'Version',
		'description' => 'Leave this setting alone.',
		'value' => '2.0.1',
		'optioncode' => 'hidden',
		'displayorder' => '0',
		'serialize' => 0
	),
	'links_active' => array(
		'title' => 'Links Directory Active',
		'description' => 'From time to time, you may wish to turn your links directory off to the public for whatever reason. When you turn your links directory off, visitors (with the exception of administrators and moderators) will see the message you specify in the option below rather than your links directory.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_closedmessage' => array(
		'title' => 'Links Directory Closed Message',
		'description' => 'This is the message that will be displayed to visitors when the links directory is closed.',
		'value' => 'We are sorry, but the links directory is closed for maintenance. Please check back soon.',
		'optioncode' => 'textarea',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_newlinklimit' => array(
		'title' => 'What\'s New Date Limits',
		'description' => 'Enter a list of days (separated by commas) that you would like to allow your users to search for new links/posts from in the &quot;What\'s New&quot; section. Set this to 0 to disable the &quot;What\'s New&quot;  section.',
		'value' => '1,3,7,14,30,60',
		'optioncode' => '',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_poplinklimit' => array(
		'title' => 'Popular Links Limit',
		'description' => 'The number of links to display in the &quot;What\'s Popular&quot; section of your links directory. Set this to 0 to disable the &quot;What\'s Popular&quot; section.',
		'value' => '20',
		'optioncode' => '',
		'displayorder' => '4',
		'serialize' => 0
	),
	'links_poplinks_votelimit' => array(
		'title' => 'Minimum Votes for Top Rated',
		'description' => 'The minimum number of votes that a link must have before being shown as a top rated link in the "What\'s Popular" section.',
		'value' => '2',
		'optioncode' => '',
		'displayorder' => '5',
		'serialize' => 0
	),
	'links_remotesite' => array(
		'title' => 'Remote Site Function',
		'description' => 'Here you may choose which function to use to connect to remote sites. These functions are used for things like checking for invalid URL\'s entered upon submission, and Status Reports. CURL is the recommended function, though not all servers will have this installed.',
		'value' => 'curl',
		'optioncode' => '<select class=\\"bginput\\" name=\\"setting[$setting[varname]]\\">
<option " . iif($setting[value] == \'curl\', \'selected=\\"selected\\"\'). " value=\\"curl\\">CURL</option>
<option " . iif($setting[value] == \'fsockopen\', \'selected=\\"selected\\"\'). " value=\\"fsockopen\\">fsockopen</option>
</select>',
		'displayorder' => '6',
		'serialize' => 0
	),
	'links_allowrating' => array(
		'title' => 'Enable Ratings',
		'description' => 'Turn this option on to allow ratings. Note that you may also enable/disable ratings on a per-category basis by editing specific categories.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '7',
		'serialize' => 0
	),
	'links_allowfav' => array(
		'title' => 'Enable User Favorites',
		'description' => 'This option will enable the "My Favorites" section and allow your members to add links to their favorites for quick access later.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '8',
		'serialize' => 0
	),
	'links_linktous' => array(
		'title' => 'Enable Link To Us Page',
		'description' => 'This option will enable the "Link To Us" page in your links directory navbar. Please note that this page may be modified through the "Edit Link to Us Page" link under the "vBa Links Directory" section in the left frame. Or for further customization you may edit your ADV_LINKS_LINKTOUS template.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '9',
		'serialize' => 0
	),
	'links_allowsubscribe' => array(
		'title' => 'Allow Subscriptions',
		'description' => 'Turn this option on if you would like to allow users to subscribe to links/categories and receive email updates when a new post or link is added.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '10',
		'serialize' => 0
	),
	'links_enable_dirjump' => array(
		'title' => 'Enable Category Jump',
		'description' => 'This will display a &quot;Category Jump&quot;, similar to vBulletin\'s Forum Jump.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '11',
		'serialize' => 0
	),
	'links_admincatcollapse' => array(
		'title' => 'Enable Collapsible Categories in Admin CP',
		'description' => 'This option will allow you to collapse/expand categories in the &quot;Manage Categories&quot; section of the Admin CP. Web sites with a large number of categories should turn this on for performance reasons.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '12',
		'serialize' => 0
	),
	'links_navbarhomelink' => array(
		'title' => 'Navbar Beginning Link',
		'description' => 'Here you may choose to start the breadcrumbs in your navbar off with either a link back to your homepage or forums.',
		'value' => '0',
		'optioncode' => '<div class=\\"smallfont\\"><input name=\\"setting[$setting[varname]]\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\"><label for=\\"$setting[varname]_0\\">None</label></div><div class=\\"smallfont\\"><input name=\\"setting[$setting[varname]]\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\"><label for=\\"$setting[varname]_1\\">Homepage</label></div><div class=\\"smallfont\\"><input name=\\"setting[$setting[varname]]\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\"><label for=\\"$setting[varname]_2\\">Forum Home</label></div>',
		'displayorder' => '13',
		'serialize' => 0
	),
	'links_imageverify' => array(
		'title' => 'Enable Image Verification',
		'description' => 'This option will display a random image which users will have to copy the content from into a text box to ensure that it is not an automated bot. It is strongly suggested that this option be enabled if you allow guests to perform any of the actions to the right.',
		'value' => 'a:5:{i:0;s:7:"addlink";i:1;s:5:"reply";i:2;s:6:"search";i:3;s:6:"report";i:4;s:12:"sendtofriend";}',
		'optioncode' => '<table width=\\"100%\\">
<tr>
<td valign=\\"top\\">
	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_addlink\\" value=\\"addlink\\" " . iif(in_array(\'addlink\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_addlink\\">" . $vbphrase[submit_a_link] . "</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_reply\\" value=\\"reply\\" " . iif(in_array(\'reply\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_reply\\">$vbphrase[reply]</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_search\\" value=\\"search\\" " . iif(in_array(\'search\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_search\\">$vbphrase[search]</label></span><br />
</td>

<td valign=\\"top\\">
	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_report\\"value=\\"report\\" " . iif(in_array(\'report\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_report\\">" . $vbphrase[report_link] . "</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_sendtofriend\\"value=\\"sendtofriend\\" " . iif(in_array(\'sendtofriend\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_sendtofriend\\">$vbphrase[send_to_friend]</label></span><br />
</td>
</tr>
</table>',
		'displayorder' => '14',
		'serialize' => 1
	)
);

$mainsettings['adv_links_index'] = array(
	'links_catdepth_index' => array(
		'title' => 'Depth of Directories on Index',
		'description' => 'The depth of categories to show on your main index page. If you set this option to \'2\', the current category level and any child categories one level below that will be displayed.',
		'value' => '2',
		'optioncode' => '',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_newonhome' => array(
		'title' => 'New Links on Index',
		'description' => 'The number of new links you would like to appear on your main links directory index page. Set this to 0 to disable it.',
		'value' => '5',
		'optioncode' => '',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_randonhome' => array(
		'title' => 'Random Links on Index',
		'description' => 'The number of random links you would like to appear on your main links directory index page. Set this to 0 to disable it.',
		'value' => '5',
		'optioncode' => '',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_home_excats' => array(
		'title' => 'Categories to Exclude From New / Random Links',
		'description' => 'Here you may select any category(ies) that you wish to exclude from being displayed in the new and random links sections.<br />Tip: To select more than one category or to de-select a category, hold down your \'Ctrl\' key while selecting the categories with your mouse.',
		'value' => '',
		'optioncode' => 'catselect',
		'displayorder' => '4',
		'serialize' => 0
	),
	'links_showstats' => array(
		'title' => 'Show Stats',
		'description' => 'Turn this option on if you would like to display stats such as the total number of categories, links, posts, and views.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '5',
		'serialize' => 0
	)
);

$mainsettings['adv_links_browselinks'] = array(
	'links_deforder' => array(
		'title' => 'Default Links Order',
		'description' => 'The default order that links should appear in. This affects links displayed in categories, favorites section, and search results (if no order is specified).',
		'value' => 'name',
		'optioncode' => '<select class=\\"bginput\\" name=\\"setting[$setting[varname]]\\">
<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"name\\">Name</option>
<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">Date Posted</option>
<option " . iif($setting[value] == \'lastpostdateline\', \'selected=\\"selected\\"\'). " value=\\"lastpostdateline\\">Last Post</option>
<option " . iif($setting[value] == \'rating\', \'selected=\\"selected\\"\'). " value=\\"rating\\">Rating</option>
<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">Number of Views</option>
<option " . iif($setting[value] == \'posts\', \'selected=\\"selected\\"\'). " value=\\"posts\\">Number of Posts</option>
</select>
',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_defdirection' => array(
		'title' => 'Default Links Order Direction',
		'description' => 'The default direction that links should be ordered by. This affects links displayed in categories, favorites section, and search results (if no order is specified).',
		'value' => 'ASC',
		'optioncode' => '<select class=\\"bginput\\" name=\\"setting[$setting[varname]]\\">
<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">Descending</option>
<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">Ascending</option>
</select>',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_perpage' => array(
		'title' => 'Links Per Page',
		'description' => 'The maximum number of links to display before splitting into multiple pages.',
		'value' => '25',
		'optioncode' => '',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_desclength_browse' => array(
		'title' => 'Maximum Characters of Description to Display',
		'description' => 'The maximum number of characters of the links description that should be displayed before being cut off. Set this to 0 to show the entire description.',
		'value' => '250',
		'optioncode' => '',
		'displayorder' => '4',
		'serialize' => 0
	),
	'links_hotviews' => array(
		'title' => 'Views to qualify as a hot link',
		'description' => 'The number of views a link must receive before being marked as a &quot;hot link&quot;.
Set this option and the one below it to 0 to disable hot links.',
		'value' => '150',
		'optioncode' => '',
		'displayorder' => '5',
		'serialize' => 0
	),
	'links_hotposts' => array(
		'title' => 'Posts to qualify as a hot link',
		'description' => 'The number of posts a link must receive before being marked as a &quot;hot link&quot;.
Set this option and the option above to 0 to disable hot links.',
		'value' => '10',
		'optioncode' => '',
		'displayorder' => '6',
		'serialize' => 0
	),
	'links_browsedropdown' => array(
		'title' => 'Enable Drop Down Menu on Browselinks?',
		'description' => 'This option will enable a DHTML drop-down menu that will appear when the title of a link is clicked on. This menu displays more options from the &quot;showlink.php&quot; page and will allow your users to access these options more quickly. Turn this option off to disable the drop-down menu and have your members taken straight to the link details page when clicking on a link\'s title instead.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '7',
		'serialize' => 0
	)
);

$mainsettings['adv_links_categorybit'] = array(
	'links_catsorder' => array(
		'title' => 'Order Categories By',
		'description' => 'Here you may choose to order categories by either the display order specified for each category, or alphabetically.',
		'value' => 'displayorder',
		'optioncode' => '<select class=\\"bginput\\" name=\\"setting[$setting[varname]]\\"> <option " . iif($setting[value] == \'displayorder\', \'selected=\\"selected\\"\'). " value=\\"displayorder\\">Display Order</option> <option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">Alphabetically</option></select>',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_catsdir' => array(
		'title' => 'Category Display Direction',
		'description' => 'The default direction that categories should appear in.',
		'value' => 'ASC',
		'optioncode' => '<select class=\\"bginput\\" name=\\"setting[$setting[varname]]\\">
<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">Descending</option>
<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">Ascending</option>
</select>',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_lastlink_maxlength' => array(
		'title' => 'Maximum Characters of Last Link',
		'description' => 'The maximum number of characters that should be displayed for the title of the last link before being cut off. Set this to 0 to show the entire title.',
		'value' => '20',
		'optioncode' => '',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_catdepth' => array(
		'title' => 'Depth of Directories',
		'description' => 'The depth of categories to show in the category listings. If you set this option to \'2\', the current category level and any child categories one level below that will be displayed.',
		'value' => '2',
		'optioncode' => '',
		'displayorder' => '4',
		'serialize' => 0
	),
	'links_showsubcats' => array(
		'title' => 'Display Smaller Sub-Category Columns',
		'description' => 'This option will allow you to display links to a category\'s sub-subcategories in a condensed form in the category listings. If you wish to separate the sub-categories into columns, you may specify the number of columns here. Otherwise set this option to 0 to disable sub-categories.',
		'value' => '1',
		'optioncode' => '',
		'displayorder' => '5',
		'serialize' => 0
	),
	'links_showmodcolumn' => array(
		'title' => 'Show Moderator Column',
		'description' => 'Turn this option on if you would like to display a column listing the moderator(s) for each category.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '6',
		'serialize' => 0
	),
	'links_showlinkcount' => array(
		'title' => 'Show Link / Post Counts in Restricted Categories',
		'description' => 'This option will display the number of links/posts in restricted categories even if the user does not have permission to view that category. When set to "No", users will see 0 links/posts for categories they do have permission to view.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '7',
		'serialize' => 0
	),
	'links_showcatowner' => array(
		'title' => 'Display Category Owner\'s Username',
		'description' => 'If a category owned by a member, this option will allow that user\'s name to be shown under the category title.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '8',
		'serialize' => 0
	),
	'links_showonoff' => array(
		'title' => 'Show On/Off Indicators',
		'description' => 'This option will display a small image in your category listings that indicates whether a category has new links/posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '9',
		'serialize' => 0
	)
);

$mainsettings['adv_links_showlink'] = array(
	'links_repliesperpage' => array(
		'title' => 'Replies Per Page',
		'description' => 'The maximum number of replies to be displayed before splitting into multiple pages. Please note that if a user has changed the value for &quot;Number of Posts to Show Per Page&quot; in their User CP then that value will override this setting.',
		'value' => '25',
		'optioncode' => '',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_urlcutoff' => array(
		'title' => 'Maximum Characters of URL to Display',
		'description' => 'The maximum number of characters of the URL to display before replacing the rest with "...". This helps to keep the page from stretching if the link has a long URL. Set this option to 0 to display the entire URL.',
		'value' => '65',
		'optioncode' => '',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_convertkeywords' => array(
		'title' => 'Convert Keywords to Links',
		'description' => 'Turn this option on if you would like to automatically convert keywords to links, allowing your members to quickly search for a keyword by clicking it.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_showquickreply' => array(
		'title' => 'Show Quick Reply?',
		'description' => 'This option will display the &quot;Quick Reply&quot; box on your links pages and allow users to quickly reply to links.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '4',
		'serialize' => 0
	)
);

$mainsettings['adv_links_addlink'] = array(
	'links_maxtitlelength' => array(
		'title' => 'Maximum Length of Title',
		'description' => 'The maximum number of characters allowed in the title of a link.',
		'value' => '50',
		'optioncode' => '',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_maxdesclength' => array(
		'title' => 'Maximum Length of Description',
		'description' => 'The maximum number of characters allowed in the description of a link.',
		'value' => '1000',
		'optioncode' => '',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_maxkeywords' => array(
		'title' => 'Maximum Keywords Allowed',
		'description' => 'The maximum number of keywords allowed for a link.',
		'value' => '8',
		'optioncode' => '',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_maxkeywordlength' => array(
		'title' => 'Maximum Keyword Length',
		'description' => 'The maximum number of characters a keyword may contain.',
		'value' => '15',
		'optioncode' => '',
		'displayorder' => '4',
		'serialize' => 0
	),
	'links_newlinkemail' => array(
		'title' => 'Email Address to Notify of New Links',
		'description' => 'Enter a list of email addresses here (separated by spaces) that you would like to have an email sent to when a new link is added.',
		'value' => '',
		'optioncode' => '',
		'displayorder' => '5',
		'serialize' => 0
	),
	'links_newlinkemail_all' => array(
		'title' => 'Notify of All Links',
		'description' => 'If you would like to only be notified of links submitted which are awaiting validation, set this option to \'No\'. Otherwise you will be notified of any links submitted whether they are awaiting validation or not.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '6',
		'serialize' => 0
	),
	'links_autofill' => array(
		'title' => 'Auto-Fill Fields',
		'description' => 'When enabled, this option will attempt to collect data about the web site being submitted using it\'s meta tags and automatically fill in the \'Title\', \'Description\', and \'Keywords\' fields based on these tags.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '7',
		'serialize' => 0
	),
	'links_verifynew' => array(
		'title' => 'Verify New Links',
		'description' => 'Turn this option on if you would like to check links and make sure they exist before they are allowed to be submitted. This option will help prevent broken links from being posted, but may also create problems if a server is down or otherwise unaccessible.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '8',
		'serialize' => 0
	),
	'links_allowdupes' => array(
		'title' => 'Allow Duplicate Links',
		'description' => 'Turn this option off if you would like to prevent users from being able to submit the same link more than once.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '9',
		'serialize' => 0
	),
	'links_recipcheck' => array(
		'title' => 'Reciprocal Link Check',
		'description' => 'This option will allow you to check for and/or require that links being submitted have a link back to your site.',
		'value' => '1',
		'optioncode' => '<div class=\\"smallfont\\"><input name=\\"setting[$setting[varname]]\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\"><label for=\\"$setting[varname]_0\\">$vbphrase[no]</label></div><div class=\\"smallfont\\"><input name=\\"setting[$setting[varname]]\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[yes_do_not_require]</label></div><div class=\\"smallfont\\"><input name=\\"setting[$setting[varname]]\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\"><label for=\\"$setting[varname]_2\\">$vbphrase[yes_require]</label></div>',
		'displayorder' => '10',
		'serialize' => 0
	),
	'links_recipcheck_url' => array(
		'title' => 'Reciprocal Link URL',
		'description' => 'By default, the reciprocal link checking option above will check that there is a link back to the URL specified for your &quot;Home URL&quot; option in your main vBulletin settings. If you wold like to require a different URL, you may enter it here.',
		'value' => '',
		'optioncode' => '',
		'displayorder' => '11',
		'serialize' => 0
	)
);

$mainsettings['adv_links_posting'] = array(
	'links_allowreplies' => array(
		'title' => 'Enable Replies to Links',
		'description' => 'Turning this option on will allow users to post comments about links.
Please note that the users must have permission to post replies which can be modified in the &quot;Modify Permissions&quot; section in the &quot;vBa Links Directory&quot; section of the Admin CP.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_update_postcount' => array(
		'title' => 'Count Posts Towards Post Counts?',
		'description' => 'Turn this option on if you would like posts made in the links directory to affect a user\'s post count.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_allowicons' => array(
		'title' => 'Allow Icons in Posts',
		'description' => 'Turn this option on if you would like to allow your users to select an icon in there posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_allowsmilie' => array(
		'title' => 'Enable Smilies',
		'description' => 'Turn this option on if you would like to allow your members to use smilies in their posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '4',
		'serialize' => 0
	),
	'links_quotetitle' => array(
		'title' => 'Quote Titles in Replies',
		'description' => 'Turn this option on if you would like to automatically fill the title of new posts with either the link name, or the post title (if replying to a specific post), prefixed by \'Re: \'. The user may still specify their own title if they wish to do so.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '5',
		'serialize' => 0
	)
);

$mainsettings['adv_links_usercats'] = array(
	'links_allow_user_cats' => array(
		'title' => 'Allow Users to Create Categories',
		'description' => 'Turning this on will allow your users to create their own categories. If you would like to give your users any control over the category once it is created, select the &quot;Yes (User owns the category)&quot; option. Otherwise, select the &quot;Yes (User does NOT own the category)&quot; option to treat it as a normal category once submitted.',
		'value' => '0',
		'optioncode' => '<div class=\\"smallfont\\"><input " . iif($setting[\'value\'] == 0, \'checked="checked"\'). " type=\\"radio\\" id=\\"allow_user_cats_0\\" name=\\"setting[$setting[varname]]\\" value=\\"0\\" /> <label for=\\"allow_user_cats_0\\">No</label></div>
<div class=\\"smallfont\\"><input " . iif($setting[\'value\'] == 1, \'checked="checked"\'). "type=\\"radio\\" id=\\"allow_user_cats_1\\" name=\\"setting[$setting[varname]]\\" value=\\"1\\" /> <label for=\\"allow_user_cats_1\\">Yes (User owns the category)</label></div>
<div class=\\"smallfont\\"><input " . iif($setting[\'value\'] == 2, \'checked="checked"\'). "type=\\"radio\\" id=\\"allow_user_cats_2\\" name=\\"setting[$setting[varname]]\\" value=\\"2\\" /> <label for=\\"allow_user_cats_2\\">Yes (User does NOT own the category)</label></label></div>',
		'displayorder' => '1',
		'serialize' => 0
	),
	'links_usercat_titlemax' => array(
		'title' => 'Maximum Length of Title',
		'description' => 'The maximum number of characters allowed in the title for user created categories.',
		'value' => '50',
		'optioncode' => '',
		'displayorder' => '2',
		'serialize' => 0
	),
	'links_usercat_descmax' => array(
		'title' => 'Maximum Length of Description',
		'description' => 'The maximum number of characters allowed in the description for user created categories.',
		'value' => '250',
		'optioncode' => '',
		'displayorder' => '3',
		'serialize' => 0
	),
	'links_newcatsattop' => array(
		'title' => 'Add New Categories to the Top',
		'description' => 'Turn this option on if you would like newly created user categories to be added the top of the list. Otherwise the categories will be added at the end.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '4',
		'serialize' => 0
	),
	'links_usercats_password' => array(
		'title' => 'Allow Users to Set Password',
		'description' => 'Turn this option on if you would like to give your users the ability to protect their categories with a password.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '5',
		'serialize' => 0
	),
	'links_usercat_edit' => array(
		'title' => 'Allow Users to Edit Their Categories',
		'description' => 'Turn this option on if you would like to allow your users to edit their categories after they have created them.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '6',
		'serialize' => 0
	),
	'links_usercats_delete' => array(
		'title' => 'Allow Users to Delete Their Categories',
		'description' => 'Turn this option on if you would like to allow your users to delete categories once they have created them.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '7',
		'serialize' => 0
	),
	'links_usercats_empty' => array(
		'title' => 'Allow Users to Empty Their Categories',
		'description' => 'Turn this option on if you would like to allow your users to empty their categories of all links/posts.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '8',
		'serialize' => 0
	),
	'links_usercats_modopts' => array(
		'title' => 'Allow Category Owner Moderator Abilities',
		'description' => 'This option will give the owner of user created categories the same privileges as moderators (delete links/posts, validate new, stick links, close links, etc) for the categories they create.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '9',
		'serialize' => 0
	),
	'links_usercats_defaultopts' => array(
		'title' => 'Default Category Options',
		'description' => 'Here you may choose a default for each option with user created categories, or set it to allow the user to choose.',
		'value' => 'a:4:{s:10:"allow_view";s:1:"0";s:14:"allow_newlinks";s:1:"0";s:11:"allow_reply";s:1:"0";s:12:"allow_rating";s:1:"0";}',
		'optioncode' => '<table width=\\"100%\\"> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow View</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_view1\\"><input id=\\"allow_view1\\" " . iif($setting[\'value\'][\'allow_view\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_view]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_view0\\"><input id=\\"allow_view0\\" " . iif($setting[\'value\'][\'allow_view\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_view]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_view2\\"><input id=\\"allow_view2\\" " . iif($setting[\'value\'][\'allow_view\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_view]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow New Links</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_newlinks1\\"><input id=\\"allow_newlinks1\\" " . iif($setting[\'value\'][\'allow_newlinks\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_newlinks]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_newlinks0\\"><input id=\\"allow_newlinks0\\" " . iif($setting[\'value\'][\'allow_newlinks\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_newlinks]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_newlinks2\\"><input id=\\"allow_newlinks2\\" " . iif($setting[\'value\'][\'allow_newlinks\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_newlinks]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow Replies</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_reply1\\"><input id=\\"allow_reply1\\" " . iif($setting[\'value\'][\'allow_reply\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_reply]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_reply0\\"><input id=\\"allow_reply0\\" " . iif($setting[\'value\'][\'allow_reply\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_reply]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_reply2\\"><input id=\\"allow_reply2\\" " . iif($setting[\'value\'][\'allow_reply\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_reply]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> <tr> <td class=\\"smallfont\\" nowrap=\\"nowrap\\">Allow Rating</td> <td class=\\"smallfont\\" nowrap=\\"nowrap\\"><label for=\\"allow_rating1\\"><input id=\\"allow_rating1\\" " . iif($setting[\'value\'][\'allow_rating\'] == 1, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_rating]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_rating0\\"><input id=\\"allow_rating0\\" " . iif($setting[\'value\'][\'allow_rating\'] == 0, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_rating]\\" type=\\"radio\\" value=\\"0\\" />No</label> <label for=\\"allow_rating2\\"><input id=\\"allow_rating2\\" " . iif($setting[\'value\'][\'allow_rating\'] == 2, \'checked="checked"\'). " name=\\"setting[$setting[varname]][allow_rating]\\" type=\\"radio\\" value=\\"2\\" />User Choice</label></td> </tr> </table> ',
		'displayorder' => '10',
		'serialize' => 1
	)
);

// Put them in order here, then we'll use the key + 1 of the array
$adv_settinggroups = array(
	'adv_global',
	'adv_links_title_paths',
	'adv_links_main',
	'adv_links_index',
	'adv_links_browselinks',
	'adv_links_categorybit',
	'adv_links_showlink',
	'adv_links_addlink',
	'adv_links_posting',
	'adv_links_usercats'
);

// ##### Plugins
$vba_plugins = array(
	'adv_error' => array(
		'title' => 'vBadvanced Error Replacements',
		'hookname' => 'error_generic',
		'product' => 'adv_global',
		'phpcode' => 'if (defined(\'VBA_SCRIPT\')) { require_once(\'./includes/vba_global_error.php\'); }'
	),

	'adv_links_modcp' => array(
		'title' => 'vBa Links Directory Mod CP',
		'hookname' => 'mod_index_navigation',
		'phpcode' => 'construct_nav_option($vbphrase[\'validate_new_links\'], \'vba_links.php?do=validate\');
construct_nav_option($vbphrase[\'validate_new_posts\'], \'vba_links.php?do=validateposts\');
construct_nav_group($vbphrase[\'vba_links_directory\']);
construct_nav_spacer();'
	),

	'adv_links_template' => array(
		'title' => 'vBa Links Directory Template Group',
		'hookname' => 'template_groups',
		'phpcode' => '$only[\'adv_links\'] = $vbphrase[\'group_adv_links\'];'
	),
	'adv_links_navlinks' => array(
	'title' => 'vBa Links Directory - Prefix Notifications w/ vBulletin URL',
	'hookname' => 'notifications_list',
	'phpcode' => 'if (VBA_SCRIPT == \'links_directory\' AND !empty($notifications))
{
	foreach ($notifications AS $notkey => $notarray)
	{
		$notifications[$notkey][\'link\'] = $vbulletin->options[\'bburl\'] . \'/\' . $notifications[$notkey][\'link\'];
	}
}')
);

// ##### Version Number
$version = $mainsettings['adv_links_main']['links_version']['value'];

// ############################### Install ####################################
if (substr($_REQUEST['do'], '', 7) == 'install')
{
	$step = htmlspecialchars($_REQUEST['step']);

	print_install_table_start();

	$only = substr($_REQUEST['do'], 8);

	if ($only)
	{
		$step = $only;
	}

	switch ($step)
	{
		case 1:

			$db->reporterror = 0;
			$check = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'links_version'");
			if ($check['varname'])
			{
				$stepphrase = 'vBadvanced ' . $scriptname . ' is already installed!';
				print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
				print_table_footer();
				exit;
			}

			$db->reporterror = 1;

			$enginevar = 'ENGINE';
			if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
			{
				$enginevar = 'TYPE';
			}

			// ##### Insert Tables
			$db->query_write("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_setting (
					varname varchar(100) NOT NULL default '',
					grouptitle varchar(50) NOT NULL default '',
					value mediumtext NOT NULL default '',
					defaultvalue varchar(250) NOT NULL default '',
					optioncode mediumtext NOT NULL,
					displayorder smallint(3) unsigned NOT NULL default '0',
					serialize smallint(3) unsigned NOT NULL default '0'
				) $enginevar=MyISAM"
			);

			// Try to add the serialize column for older versions of vBa products
		  $db->reporterror = 0;
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
		  $db->reporterror = 1;

			$db->query_write("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_settinggroup (
					grouptitle varchar(50) NOT NULL default '',
					displayorder smallint(3) unsigned NOT NULL default '0',
					PRIMARY KEY (grouptitle)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links (
					linkid int(11) NOT NULL auto_increment,
					`name` varchar(255) NOT NULL default '',
					linkurl TEXT NOT NULL default '',
					linkrecipurl TEXT NOT NULL default '',
					catid smallint(5) unsigned NOT NULL default '0',
					description TEXT NOT NULL,
					keywords varchar(255) default NULL,
					views int(10) NOT NULL default '0',
					posts int(10) unsigned NOT NULL default '0',
					valid smallint(5) NOT NULL default '0',
					`open` smallint(3) unsigned NOT NULL default '0',
					notes varchar(255) NOT NULL default '',
					sticky smallint(3) unsigned NOT NULL default '0',
					username varchar(50) default NULL,
					dateline int(10) unsigned NOT NULL default '0',
					lastupdated int(10) unsigned NOT NULL default '0',
					userid int(10) unsigned NOT NULL default '0',
					suspended smallint(3) NOT NULL default '0',
					votenum smallint(5) unsigned NOT NULL default '0',
					votetotal smallint(5) unsigned NOT NULL default '0',
					ipaddress varchar(15) NOT NULL default '',
					lastpostid int(10) unsigned NOT NULL default '0',
					lastpostdateline int(10) unsigned NOT NULL default '0',
					lastpostuserid int(10) unsigned NOT NULL default '0',
					lastpostusername varchar(255) default NULL,
					PRIMARY KEY	(linkid),
					KEY catid (catid,suspended,valid,dateline),
					FULLTEXT KEY `name` (`name`),
					FULLTEXT KEY description (description),
					FULLTEXT KEY keywords (keywords)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_banners (
					bannerid int(10) unsigned NOT NULL auto_increment,
					filename varchar(255) default NULL,
					title varchar(255) NOT NULL,
					width smallint(4) unsigned NOT NULL default '0',
					height smallint(4) unsigned NOT NULL default '0',
					filesize int(10) unsigned NOT NULL default '0',
					displayorder smallint(4) unsigned NOT NULL default '0',
					PRIMARY KEY	(bannerid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_categories (
					catid smallint(5) NOT NULL auto_increment,
					title varchar(255) NOT NULL default '',
					description text NOT NULL,
					parent smallint(5) default NULL,
					haslinks smallint(3) unsigned NOT NULL default '0',
					valid SMALLINT(3) unsigned NOT NULL DEFAULT '0',
					active smallint(3) unsigned NOT NULL default '0',
					catuserid int(10) unsigned NOT NULL default '0',
					allowusercats smallint(3) unsigned NOT NULL default '0',
					postcount int(10) unsigned NOT NULL default '0',
					linkcount int(10) unsigned NOT NULL default '0',
					parentlist varchar(250) NOT NULL default '0',
					`password` varchar(100) NOT NULL default '',
					displayorder int(10) unsigned NOT NULL default '0',
					private smallint(3) unsigned NOT NULL default '0',
					lastlinkid int(10) unsigned NOT NULL default '0',
					lastlinktitle varchar(255) default NULL,
					lastlinkusername varchar(50) NOT NULL default '',
					lastlinkuserid int(10) unsigned NOT NULL default '0',
					lastlinkdateline int(10) unsigned NOT NULL default '0',
					lastpostid int(10) unsigned NOT NULL default '0',
					lastpostlinkid int(10) unsigned NOT NULL default '0',
					lastpostlinktitle varchar(255) NOT NULL default '',
					lastpostuserid int(10) unsigned NOT NULL default '0',
					lastpostusername varchar(100) NOT NULL default '',
					lastpostdateline int(10) unsigned NOT NULL default '0',
					options int(10) unsigned NOT NULL default '0',
					useroptions int(10) unsigned NOT NULL default '0',
					recipoptions smallint(3) unsigned NOT NULL default '0',
					newlinkemail varchar(255) NOT NULL default '',
					newpostemail varchar(255) NOT NULL default '',
					PRIMARY KEY	(catid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_cfields (
					fieldid smallint(3) unsigned NOT NULL auto_increment,
					title varchar(250) NOT NULL default '',
					description varchar(250) NOT NULL default '',
					`type` varchar(20) NOT NULL default '',
					required smallint(3) unsigned NOT NULL default '0',
					displayorder smallint(3) unsigned NOT NULL default '0',
					searchable smallint(3) unsigned NOT NULL default '0',
					maxlength smallint(3) unsigned NOT NULL default '0',
					options mediumtext NOT NULL,
					catids varchar(255) NOT NULL default '',
					incsubs smallint(3) unsigned NOT NULL default '0',
					PRIMARY KEY	(fieldid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_cfields_entries (
					lid int(10) unsigned NOT NULL default '0',
					PRIMARY KEY	(lid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_favorites (
					linkid int(10) unsigned NOT NULL default '0',
					userid int(10) unsigned NOT NULL default '0',
					UNIQUE KEY linkid (linkid,userid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_moderator (
					userid int(10) unsigned NOT NULL default '0',
					catid smallint(5) unsigned NOT NULL default '0',
					UNIQUE KEY `userid` (`userid`,`catid`)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_permissions (
					permissionid int(10) unsigned NOT NULL auto_increment,
					catid int(10) unsigned NOT NULL default '0',
					usergroupid int(10) unsigned NOT NULL default '0',
					permissions int(10) unsigned NOT NULL default '0',
					PRIMARY KEY	(permissionid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_posts (
					postid int(10) unsigned NOT NULL auto_increment,
					linkid int(10) unsigned NOT NULL default '0',
					title varchar(255) NOT NULL default '',
					pagetext text NOT NULL,
					userid int(10) unsigned NOT NULL default '0',
					username varchar(50) NOT NULL default '',
					dateline int(10) unsigned NOT NULL default '0',
					ipaddress varchar(15) NOT NULL default '',
					iconid smallint(3) unsigned NOT NULL default '0',
					allowsmilie smallint(3) unsigned NOT NULL default '0',
					showsignature smallint(3) unsigned NOT NULL default '0',
					visible smallint(3) NOT NULL default '0',
					PRIMARY KEY	(postid),
					KEY linkid (linkid),
					KEY userid (userid),
					KEY iconid (iconid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_rate (
					rateid int(10) unsigned NOT NULL auto_increment,
					linkid int(10) unsigned NOT NULL default '0',
					userid int(10) unsigned NOT NULL default '0',
					rating smallint(3) unsigned NOT NULL default '0',
					ipaddress varchar(15) NOT NULL default '',
					PRIMARY KEY	(rateid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_search (
					searchid int(10) unsigned NOT NULL auto_increment,
					`string` varchar(100) NOT NULL default '',
					username text NOT NULL,
					sfields varchar(50) NOT NULL default '',
					catids mediumtext NOT NULL,
					dateline int(10) unsigned NOT NULL default '0',
					userid int(10) unsigned NOT NULL default '0',
					linkids mediumtext NOT NULL,
					orderby varchar(20) NOT NULL default '',
					direction varchar(4) NOT NULL default '',
					numresults smallint(5) unsigned NOT NULL default '0',
					wholeword smallint(3) unsigned NOT NULL default '0',
					searchtime tinytext NOT NULL,
					PRIMARY KEY	(searchid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_subscribecat (
					userid int(10) unsigned NOT NULL default '0',
					catid smallint(5) unsigned NOT NULL default '0',
					KEY userid (userid),
					KEY catid (catid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_subscribelink (
					userid int(10) unsigned NOT NULL default '0',
					linkid int(10) unsigned NOT NULL default '0',
					KEY linkid (linkid),
					KEY userid (userid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_reports (
					repid int(10) unsigned NOT NULL auto_increment,
					userid int(10) unsigned NOT NULL default '0',
					`data` text,
					dateline int(10) unsigned NOT NULL default '0',
					endtime int(10) unsigned NOT NULL default '0',
					lastlinkid INT(10) UNSIGNED DEFAULT '0' NOT NULL,
					checkagain SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL,
					`type` varchar(20) NOT NULL,
					PRIMARY KEY	(repid)
				) $enginevar=MyISAM
			");

			// #### Insert Product
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "product
					(productid, title, description, version, active)
				VALUES (
					'" . PRODUCT_CODE . "',
					'vBadvanced Links Directory',
					'vBadvanced Links Directory',
					'" . $version . "',
					1
			)");

			// ##### Plugins
			insert_plugins();

			// ##### Phrasegroups
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language ADD phrasegroup_adv_links MEDIUMTEXT NOT NULL");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language ADD phrasegroup_adv_links_cp MEDIUMTEXT NOT NULL");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language ADD phrasegroup_adv_links_managecats MEDIUMTEXT NOT NULL");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrasetype
					(fieldname, title, editrows, product)
				VALUES (
					'adv_links',
					'vBadvanced Links Directory',
					3,
					'" . PRODUCT_CODE . "'
			)");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrasetype
					(fieldname, title, editrows, product)
				VALUES (
					'adv_links_cp',
					'vBadvanced Links Directory CP',
					3,
					'" . PRODUCT_CODE . "'
			)");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrasetype
					(fieldname, title, editrows, product)
				VALUES (
					'adv_links_managecats',
					'vBadvanced Links Directory Category Manager',
					3,
					'" . PRODUCT_CODE . "'
			)");

			insert_all_phrases();

			$stepphrase .= 'Added phrases.<br /><br />';
			vbflush();

			// Datastore
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "datastore
					(title, unserialize)
				VALUES
					('adv_links_cats', 1),
					('adv_links_mods', 1),
					('adv_links_opts', 1),
					('adv_links_perms', 1),
					('adv_links_rand', 1)
			");

			$stepphrase .= 'Inserted links fields to the datastore table.<br /><br />';

			// ##### Permissions for datastore
			$linksperms = array();
			$ugroups = $db->query_read("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
			while ($ugroup = $db->fetch_array($ugroups))
			{
				$linksperms[$ugroup['usergroupid']]['links_perms'] = 4284359;
			}

			// Admin
			$linksperms['6']['links_perms'] = 6946751;
			// Guests
			$linksperms['1']['links_perms'] = 67393;

			build_datastore('adv_links_perms', serialize($linksperms), 1);

			$stepphrase .= 'Inserted links directory permissions.<br /><br />';
			vbflush();

			// ##### Insert templates
			insert_all_templates();

			$stepphrase .= 'Added templates.<br /><br />';
			vbflush();

			// ##### Cron jobs
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "cron
					(nextrun, weekday, day, hour, minute, filename, loglevel, varname, product)
				VALUES
					(" . TIMENOW . ", -1, -1, 1, 0, './includes/cron/vba_links_search.php', 1, 'adv_links_search', 'adv_links'),
					(" . TIMENOW . ", -1, -1, 0, 0, './includes/cron/vba_links_subscriptions.php', 1, 'adv_links_subscriptions', 'adv_links'),
					(" . TIMENOW . ", -1, -1, -1, 0, './includes/cron/vba_links_rand.php', 1, 'adv_links_rand', 'adv_links')
			");

			$stepphrase .= 'Inserted links fields to the cron table.<br /><br />';

			// ##### Settings
			$vba_globalcheck = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

			if ($vba_globalcheck['grouptitle'])
			{
				unset($adv_settinggroups['adv_global']);
			}

			foreach ($adv_settinggroups AS $groupkey => $groupname)
			{
				// I have no idea how people are getting errors from this, but we'll use INSERT IGNORE to prevent them
				$db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('$groupname', " . ($groupkey + 1) . ")");
			}

			// ###### Insert Settings
			$setttinginsert = '';
			$adv_options = array();

			if (!function_exists('curl_init'))
			{
				$mainsettings['adv_links_main']['links_remotesite']['value'] = 'fsockopen';
			}

			foreach ($mainsettings AS $grouptitle => $settings)
			{
				foreach ($settings AS $varname => $setting)
				{
					$adv_options[$varname] = $setting['value'];
					$setttinginsert .= "(
						'$varname',
						'" . $grouptitle . "',
						'" . $db->escape_string($setting['value']) . "',
						'" . $db->escape_string($setting['defaultvalue']) . "',
						'" . $db->escape_string($setting['optioncode']) . "',
						" . $setting['displayorder'] . ",
						'$setting[serialize]'
					),";
				}
			}

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "adv_setting
					(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
				VALUES
					" . substr($setttinginsert, 0, strlen($setttinginsert) - 1)
			);

			$vba_options =& $adv_options;

			build_datastore('adv_links_opts', serialize($adv_options), 1);

			$stepphrase .= 'Inserted settings.<br /><br />';

			// ##### Default categories
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_links_categories (catid, title, description, active, valid, parent, haslinks, postcount, linkcount, parentlist, displayorder, options) VALUES (1, 'Header Category', 'Header Category Description', 1, 1, 0, 0, 0, 0, 1, 1, 5848)");

			$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_links_categories (catid, title, description, active, valid, parent, haslinks, postcount, linkcount, parentlist, displayorder, options) VALUES (2, 'Main Category', 'Main Category Description', 1, 1, 1, 1, 0, 0, '2,1', 1, 38619)");

			$stepphrase .= 'Inserted Main Category & Main Category.<br /><br />';
			vbflush();

			update_category_cache();

			$nextdo = 'mainsettings';
			$rebuildtemp = true;


		break;

		// Install templates
		case 'templates':

			insert_all_templates();

			$stepphrase = 'Templates updated.';
			$nextdo = 'finished';
			$rebuildtemp = true;

		break;

		// Install phrases
		case 'phrases':

			insert_all_phrases();

			$stepphrase = 'Phrases updated.';
			$nextdo = 'finished';

		break;

		// Main page
		default:

			// Make sure adv_global setting group has the correct phrase
			$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET text = 'vBadvanced Global Options' WHERE varname = 'settinggroup_adv_global'");

			$stepphrase = '<b>Welcome to vBadvanced ' . $scriptname . ' version ' . $version . '.</b><br />Please select an action and click the \'Continue\' button.';
	}

	print_install_table_end();
}

// ##### Main Settings ########################################################
if ($_REQUEST['do'] == 'mainsettings')
{
	$settingphrase = array();
	$getphrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'vbsettings' AND product = 'adv_links' ORDER BY languageid ASC");
	while($phrases = $db->fetch_array($getphrases))
	{
		$settingphrase[$phrases['varname']] = $phrases['text'];
	}

	require_once(DIR . '/includes/adminfunctions_options.php');

	$settingscache = array();
	$grouptitlecache = array();
	$settings = $db->query_read("
		SELECT adv_setting.*
		FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
		LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup USING (grouptitle)
		WHERE varname IN('links_title', 'links_homeurl', 'links_uploaddir', 'links_uploadurl')
		ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $db->fetch_array($settings))
	{
		$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
		$grouptitlecache[$setting['grouptitle']] = $setting['grouptitle'];
	}

	$homeurl = $vbulletin->options['homeurl'] . '/links';
	if (@file_get_contents($homeurl . '/index.php'))
	{
		$settingscache['adv_links_title_paths']['links_homeurl']['value'] = $homeurl;
		$settingscache['adv_links_title_paths']['links_uploadurl']['value'] = $vbulletin->options['homeurl'] . '/links/banners';
	}

	$uploaddir = $_SERVER['DOCUMENT_ROOT'] . '/links/banners';
	if (is_dir($uploaddir))
	{
		$settingscache['adv_links_title_paths']['links_uploaddir']['value'] = $uploaddir;
	}

	$db->free_result($settings);
	unset($setting);
	print_form_header($scriptfile, 'saveopts');

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_adv_setting_group($grouptitle, 0);
		print_table_break();
	}
	print_submit_row();
}

// ##### Save Settings ########################################################
if ($_REQUEST['do'] == 'saveopts')
{
	foreach ($_POST['setting'] AS $varname => $value)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string($value) . "' WHERE varname = '$varname'");
	}

	$adv_options = array();
	$settings = $db->query_read("SELECT varname, value FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_links%' OR grouptitle = 'adv_global'");
	while ($setting = $db->fetch_array($settings))
	{
		$adv_options[$setting['varname']] = $setting['value'];
	}

	$db->free_result($settings);
	unset($setting);

	build_datastore('adv_links_opts', serialize($adv_options), 1);

	print_cp_redirect($scriptfile . '.php?do=doimages');
}

// ##### Update Image Paths ###################################################
if ($_REQUEST['do'] == 'doimages')
{
	// ##### Do Path Check
	function do_path_check($imageurl, $makeclass = true)
	{
		global $vbulletin;

		if ($makeclass)
		{
			$class = exec_switch_bg();
		}

		$returnurl = $imageurl;
		if (substr($imageurl, 0, 1) == '/')
		{
			$returnurl = substr($imageurl, 1);
		}

		if (is_file('./' . $imageurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize($vbulletin->options['bburl'] . '/' . $returnurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize('../' . $returnurl))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else if (@fopen($returnurl, "r"))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else
		{
			return array(
				'checked' => false,
				'class' => 'redalert',
				'newpath' => $imageurl
			);
		}
	}

	// ##### Preg match for CSS Images
	function fetch_image_replaced_string($estring)
	{
		preg_match_all("#url\(([^\"]+?)\)#i", $estring, $checkimages);

		$checked = false;
		$class = exec_switch_bg();
		if (empty($checkimages[1]))
		{
			$newstring = $estring;
		}
		else
		{
			foreach ($checkimages[1] AS $imgpath)
			{
				$paths = do_path_check($imgpath . $imgcheck, false);

				$urlpos = strpos($estring, $imgpath);
				$newstring .= substr($estring, 0, $urlpos) . $paths['newpath'];

				if ($paths['checked'])
				{
					$checked = true;
				}
				if ($paths['class'] == 'redalert')
				{
					$class = 'redalert';
				}

				$estring = substr($estring, ($urlpos + strlen($imgpath)));
			}
			$newstring .= $estring;
		}

		return array(
			'class' => $class,
			'checked' => $checked,
			'newstring' => $newstring,
			'newpath' => $paths['newpath']
		);
	}

	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber');
	$type = $vbulletin->input->clean_gpc('r', 'type');

	$perpage = ($type == 'styleimages') ? 5 : 50;

	if (!$type)
	{
		$type = 'icons';
	}

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	print_form_header($scriptfile, 'updateimages');
	print_table_header('Image Paths', 5);
	print_description_row('For this part of the installation process, we will attempt to update all of your images for use with vBadvanced. Please check each image here to make sure that it is displayed properly!<br /><br />
	In most cases, it should not be necessary to make any changes here. If the current image already has the correct path then the "Update" box beside it will not be checked since no changes are necessary. If the current image does not have the correct path, but this script is able to determine the correct path, then the "Update" box will be checked and the correct URL entered into the text box. If neither of the above applies, then you will see the entire box outlined in <font color="red">red</font> and it will be necessary to modify the path yourself.', 0, 5);
	print_table_break();

	$countquery = '';
	switch ($type)
	{
		case 'icons':

			if ($vbulletin->options['showdeficon'] AND $pagenumber == 1)
			{
				print_table_break();

				print_table_header('Default Post Icon', 5);

				print_cells_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$paths = do_path_check($vbulletin->options['showdeficon']);

				echo '<tr class="' . $paths['class'] . '"><td align="center"><input type="checkbox" name="updatedicon" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td><td>deficon</td><td align="center"><input name="deficon" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $vbulletin->options['showdeficon'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				print_table_break();
			}

			print_table_header('Update Icon Paths', 5);
			$countquery = "icon WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'smilies':
			print_table_header('Update Smilie Paths', 5);
			$countquery = "smilie WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'styleimages':
			print_table_header('Update Style Paths', 5);
			$countquery = 'style';
		break;
	}

	$itemcount = $db->query_first('SELECT COUNT(*) AS count FROM ' . TABLE_PREFIX . $countquery);

	if (!$itemcount['count'])
	{
		$nextpage = 1;
		construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
		print_description_row('No ' . $type . ' need updating. Please click &quot;Save&quot; to continue', '', 5);
	}
	else
	{
		$nextpage = $pagenumber + 1;

		if ($maxlimit >= $itemcount['count'])
		{
			if ($type == 'styleimages')
			{
				$nextpage = 0;
			}
			else
			{
				$maxlimit = $itemcount['count'];
				$nextpage = 1;
				construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
			}
		}
		else
		{
			construct_hidden_code('type', $type);
		}
		if ($minlimit > $itemcount['count'])
		{
			$minlimit = $itemcount['count'] - $perpage;
		}

		if ($minlimit < 1)
		{
			$minlimit = 1;
		}

		switch ($type)
		{
			// ##### Icons
			case 'icons':

				print_cells_row(array('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$icons = $db->query("
					SELECT *
					FROM " . TABLE_PREFIX . "icon
					WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
					ORDER BY iconid
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($icon = $db->fetch_array($icons))
				{
					construct_hidden_code('title[' . $icon['iconid'] . ']', $icon['title']);

					$paths = do_path_check($icon['iconpath']);

					echo '<tr class="' . $paths['class'] . '">
						<td align="left"><input type="checkbox" name="updateicon[' . $icon['iconid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
						<td>' . $icon['title'] . '</td>
						<td align="center"><input name="iconpath[' . $icon['iconid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td>
						<td align="center"><img src="' . $icon['iconpath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td>
					</tr>';
				}

				print_table_break();

			break;

			// ##### Smilies
			case 'smilies':

				print_cells_row(array('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$smilies = $db->query("
						SELECT * FROM " . TABLE_PREFIX . "smilie
						WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
						ORDER BY smilieid
						LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($smilie = $db->fetch_array($smilies))
				{
					construct_hidden_code('title[' . $smilie['smilieid'] . ']', $smilie['title']);

					$paths = do_path_check($smilie['smiliepath']);

					echo '<tr class="' . $paths['class'] . '"><td align="left"><input type="checkbox" name="updatesmilie[' . $smilie['smilieid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . 'value="1" /></td><td>' . $smilie['title'] . '</td><td align="center"><input name="smiliepath[' . $smilie['smilieid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $smilie['smiliepath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				}

			break;

			// ##### Style Images
			case 'styleimages':

				print_cells_row(array('<span style="white-space: nowrap"><input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?</span>', 'Style CSS Selector', 'New URL', 'Image Verification'), 'thead');

				// Get image titles & paths
				$scache = array();
				$styleimages = $db->query("
					SELECT * FROM " . TABLE_PREFIX . "template
					WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%' AND title != 'EXTRA')
				");
				while ($simage = $db->fetch_array($styleimages))
				{
					$scache["$simage[styleid]"]["$simage[title]"] = $simage['template'];
				}

				// Images to check for
				$stylechecks = array(
					'imgdir_attach' => '/attach.gif',
					'imgdir_button' => '/reply_small.gif',
					'imgdir_editor' => '/quote.gif',
					'imgdir_misc' => '/stats.gif',
					'imgdir_poll' => '/bar6-l.gif',
					'imgdir_rating' => '/rating_5.gif',
					'imgdir_reputation' => '/reputation_pos.gif',
					'imgdir_statusicon' => '/forum_new.gif'
				);

				// Get styles
				$styles = $db->query("
					SELECT styleid, title
					FROM " . TABLE_PREFIX . "style
					WHERE styleid != '-1'
					ORDER BY styleid, title
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($style = $db->fetch_array($styles))
				{
					print_table_header($style['title'], 4, 0, '', $stylevar['left']);

					if (empty($scache[$style['styleid']]))
					{
						$scache[$style['styleid']] = $scache['-1'];
					}

					// Find anything that's in the main style but not this one.
					$defstyle = array_diff(array_keys($scache['-1']), array_keys($scache[$style['styleid']]));

					if (!empty($defstyle))
					{
						foreach ($defstyle AS $varname)
						{
							$scache[$style['styleid']][$varname] = $scache['-1'][$varname];
						}
					}

					foreach ($scache[$style['styleid']] AS $varname => $imgpath)
					{
						$imagesample = '';
						if ($varname == 'EXTRA2')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['all']);

							$classinput = '<textarea name="stylepath[' . $style['styleid'] . '][' . $varname . ']" rows="8" cols="45">' . htmlspecialchars($paths['newstring']) . '</textarea>';
						}

						else if (substr($varname, 0, 1) == '.' OR $varname == 'body')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['background']);

							$classinput = '<input size="50" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" value="' . htmlspecialchars($paths['newstring']) . '" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';

						}
						else
						{
							$imgcheck = $stylechecks["$varname"];

							$paths = do_path_check($imgpath . $imgcheck);

							if (substr($varname, 0, 1) == '.')
							{
								$newpath = $paths['newpath'];
							}
							else
							{
								$newpath = substr($paths['newpath'], 0, intval(strlen($paths['newpath']) - strlen($imgcheck)));
							}

							$classinput = '<input class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $newpath . '" size="45" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';
						}

						echo '<tr class="' . $paths['class'] . '">
								<td align="left"><input type="checkbox" name="updatepath[' . $style['styleid'] . '][' . $varname . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
								<td>' . $varname . '</td>
								<td align="center">' . $classinput . '</td>
							<td align="center"><div style="overflow: auto; width: 300px; max-height: 120px;">' . $imagesample . '</div></td>
						</tr>';
					}

				}
			break;

			print_table_break();
			break;
		}
	}

	construct_hidden_code('nextpage', $nextpage);
	print_submit_row('Save', 'Reset', 5);
}

// ##### Do Update Image Paths ################################################
if ($_POST['do'] == 'updateimages')
{
	$vbulletin->input->clean_array_gpc('p', array('updateicon', 'iconpath', 'updatesmilie', 'smiliepath', 'updatepath', 'stylepath', 'type' => TYPE_STR, 'nextpage' => TYPE_INT));

	$updateicon = $vbulletin->input->clean_gpc('p', 'updateicon');
	$iconpath = $vbulletin->input->clean_gpc('p', 'iconpath');
	$updatesmilie = $vbulletin->input->clean_gpc('p', 'updatesmilie');
	$smiliepath = $vbulletin->input->clean_gpc('p', 'smiliepath');
	$updatepath = $vbulletin->input->clean_gpc('p', 'updatepath');
	$stylepath = $vbulletin->input->clean_gpc('p', 'stylepath');
	$type = $vbulletin->input->clean_gpc('p', 'type');
	$nextpage = $vbulletin->input->clean_gpc('p', 'nextpage', TYPE_INT);
	$deficon = $vbulletin->input->clean_gpc('p', 'deficon', TYPE_NOHTML);

	// ##### Update Style Images
	if (is_array($updatepath))
	{
		// Get image titles & paths
		$defstyle = array();
		$styleimages = $db->query("
			SELECT title, template FROM " . TABLE_PREFIX . "template
			WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%') AND styleid = '-1'
		");
		while ($simage = $db->fetch_array($styleimages))
		{
			$defstyle["$simage[title]"] = $simage['template'];
		}

		foreach ($updatepath AS $sid => $values)
		{
			$sid = intval($sid);

			$tempcache = array();
			$gettemps = $db->query_read("
				SELECT title, template
				FROM " . TABLE_PREFIX . "template
				WHERE title IN('" . implode("', '", array_keys($values)) . "')
					AND styleid = $sid
			");
			while ($temps = $db->fetch_array($gettemps))
			{
				$tempcache[$temps['title']] = $temps['template'];
			}

			foreach ($values AS $var => $update)
			{
				if ($update)
				{
					$insert = false;
					$newtemp = $stylepath[$sid][$var];

					if (!isset($tempcache[$var]))
					{
						$insert = true;
						$tempcache[$var] = $defstyle[$var];
					}

					// EXTRA
					if ($var == 'EXTRA2')
					{
						$template = unserialize($tempcache[$var]);
						$template['all'] = $newtemp;
						$newtemp = serialize($template);
					}
					// CSS Class
					else if (substr($var, 0, 1) == '.' OR $var == 'body')
					{
						$template = unserialize($tempcache[$var]);

						$template['background'] = $newtemp;

						$newtemp = serialize($template);
					}

					if ($insert)
					{
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "template
								(styleid, title, template, template_un, templatetype, dateline, username, product)
							VALUES (
								'$sid',
								'$var',
								'" . $db->escape_string($newtemp) . "',
								'',
								'" . iif(substr($var, 0, 1) == '.', 'css', 'stylevar') . "',
								" . TIMENOW . ",
								'" . $db->escape_string($vbulletin->userinfo['username']) . "',
								'vbulletin'
						)");
					}
					else
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "template SET template = '" . $db->escape_string($newtemp) . "' WHERE title = '$var' AND styleid = '$sid'");
					}
				}
			}
		}
		build_all_styles(0, 0, $scriptfile . '.php?do=install&step=finished');
	}

	// ##### Update Icons
	else if (is_array($updateicon))
	{
		foreach ($iconpath AS $key => $val)
		{
			if ($updateicon[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "icon SET
						iconpath = '" . $db->escape_string($val) . "'
					WHERE iconid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('icon');
	}

	// ##### Update Smilies
	else if (is_array($updatesmilie))
	{
		foreach ($smiliepath AS $key => $val)
		{
			if ($updatesmilie[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "smilie SET
						smiliepath = '" . $db->escape_string($val) . "'
					WHERE smilieid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('smilie');
	}

	// ##### Default Icon URL
	if ($_POST['updatedicon'])
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '$deficon' WHERE varname = 'showdeficon'");
		echo '<br />showdeficon updated.<br />';
		build_options();
	}

	if ($nextpage)
	{
		print_cp_redirect($scriptfile . '.php?do=doimages&type=' . $type . '&pagenumber=' . $nextpage);
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished');
	}
}

// ############################ Last Step #############################
if ($_REQUEST['do'] == 'finished')
{
	print_install_table_start();

	$stepphrase = 'vBadvanced ' . $scriptname . ' installation complete!<br /><br /><span style="color:red"><b>You should now delete this file from your admincp category.<br />Leaving this file here could be a security risk!</b><br /><br /><a href="index.php"><b>Log Into Admin CP --&gt;</b></a>';
	$step = 'finished';

	print_install_table_end();
}

// ############################## Upgrade ###############################
if ($_REQUEST['do'] == 'upgrade')
{
	print_install_table_start('vBadvanced ' . $scriptname . ' Upgrade', 'upgrade');

	$checkver = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'links_version'");

	$enginevar = 'ENGINE';
	if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
	{
		$enginevar = 'TYPE';
	}

	switch ($checkver['value'])
	{
		// #####
		case $version:

			$stepphrase .= '<strong>You are already running vBadvanced ' . $scriptname . ' ' . $version . '!</strong>';
		break;

			// #####
			case '1.0.0 RC2':

			$db->query("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "links_customfields (
					fieldid smallint(3) unsigned NOT NULL auto_increment,
					title varchar(250) NOT NULL default '',
					description varchar(250) NOT NULL default '',
					type varchar(20) NOT NULL default '',
					required smallint(3) unsigned NOT NULL default '0',
					displayorder smallint(3) unsigned NOT NULL default '0',
					searchable smallint(3) unsigned NOT NULL default '0',
					maxlength smallint(3) unsigned NOT NULL default '0',
					options mediumtext NOT NULL,
					PRIMARY KEY (fieldid)
				) $enginevar=MyISAM
			");

			$stepphrase .= 'Created table <b>links_customfields</b>.<br /><br />';
			vbflush();


			$db->query("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "links_customfields_entries (
					lid int(10) unsigned NOT NULL default '0',
					PRIMARY KEY	(lid)
				) $enginevar=MyISAM
			");

			$stepphrase .='Created table <b>links_customfields_entries</b>.<br /><br />';

			$links = $db->query("SELECT linkid FROM " . TABLE_PREFIX . "links");
			while ($link = $db->fetch_array($links))
			{
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "links_customfields_entries (lid) VALUES ('$link[linkid]')");
			}
			$stepphrase .= 'Added current links into custom fields table.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_categories ADD options int(10) unsigned NOT NULL default '0', ADD newlinkemail varchar(255) NOT NULL default '', ADD newpostemail varchar(255) NOT NULL default ''");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_subscribelink DROP PRIMARY KEY");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_subscribelink ADD INDEX (userid), ADD INDEX (linkid)");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_subscribecat DROP PRIMARY KEY");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_subscribecat ADD INDEX (userid)");

			$db->query_write("UPDATE " . TABLE_PREFIX . "links_categories SET options = 5851");

			$stepphrase .= 'Added new fields to links_categories table.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links ADD notes VARCHAR(255) NOT NULL AFTER open");
			$stepphrase .= 'Added \'notes\' field to links table.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'adv_links' AND varname IN ('guest', 'never', 'replies', 'search', 'submit_link', 'views')");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'adv_links_cp' AND varname IN ('validated_link_key', 'must_choose_dir_for_link', 'settinggroup_adv_links_addlink', 'settinggroup_adv_links_browselinks', 'settinggroup_adv_links_index', 'settinggroup_adv_links_main', 'settinggroup_adv_links_posting', 'settinggroup_adv_links_showlink', 'no_links_awaiting_moderation', 'modify_usergroup_permissions')");

			$stepphrase .= 'Removed redundant phrases.<br /><br />';

			$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET fieldname = 'adv_links' WHERE fieldname = 'adv_links_cp' AND varname IN ('valid', 'validate', 'validate_all', 'ignore_all', 'no_links_awaiting_moderation', 'email_all', 'links_awaiting_moderation', 'delete_all', 'posts_awaiting_moderation')");

			$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET varname = 'newest_x_links', text =
'Newest {1} Links' WHERE varname = 'newest_links'");

			kill_template('adv_links_ratingbit');

			foreach ($mainsettings AS $grouptitle => $settings)
			{
				foreach ($settings AS $varname => $setting)
				{
					if (in_array($varname, array('links_navbarhomelink', 'links_newlinkemail', 'links_newlinkemail_all')))
					{
						insert_setting();
					}
				}
			}

			kill_setting('links_validation_email_body');
			kill_setting('links_validation_email_title');
			kill_setting('links_deletion_email_message');
			kill_setting('links_deletion_email_subject');

		break;

		// #####
		case '1.0.0 RC3':

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_search ADD username TEXT NOT NULL AFTER string");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_search ADD searchtime TINYTEXT NOT NULL");

			$stepphrase .= 'Added new fields to the links_search table.<br /><br />';
			vbflush();


		// #####
		case '1.0.0':

			$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title, unserialize) VALUES ('adv_links_perms', 1)");

			require_once(DIR . '/includes/functions_misc.php');
			$usergroups = $db->query_read("SELECT usergroupid, linkspermissions FROM " . TABLE_PREFIX . "usergroup");
			while ($usergroup = $vbulletin->db->fetch_array($usergroups))
			{
				$perms = convert_bits_to_array($usergroup['linkspermissions'], $linkspermissionsbit);
				$linksperms = convert_array_to_bits($perms, $linkspermissionsbit, 1);

				$db->query_write("UPDATE " . TABLE_PREFIX . "usergroup SET linkspermissions = '$linksperms' WHERE usergroupid = '$usergroup[usergroupid]'");
			}

			$linksperms = array();
			$ugroups = $db->query_read("SELECT usergroupid, linkspermissions FROM " . TABLE_PREFIX . "usergroup");
			while ($ugroup = $vbulletin->db->fetch_array($ugroups))
			{
				$linksperms["$ugroup[usergroupid]"]['links_perms'] = $ugroup['linkspermissions'];
			}

			build_datastore('adv_links_perms', serialize($linksperms), 1);

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP linkspermissions");

			$stepphrase .= 'Updated links permissions for new permissions system.<br /><br />';
			vbflush();


			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'error' AND varname LIKE 'adv_links%'");

		// #####
		case '1.0.1':
		case '1.0.1 (vB 3.5)':

			/* Some people may have an incorrect version number due to a member posted
			 fix that was incorrect, so make sure they don't get an error if so */
			$db->reporterror = 0;

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "product
					(productid, title, description, version, active)
				VALUES (
					'" . PRODUCT_CODE . "',
					'vBadvanced Links Directory',
					'',
					'" . $version . "',
					1
			)");

			$stepphrase .= 'Added product data.<br /><br />';
			vbflush();

			$db->reporterror = 1;

			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = 1 WHERE title IN ('links_d_cache', 'links_mod_cache', 'adv_links_opts', 'links_ugroups')");

		// #####
		case '1.0.1 (vB 3.6)':
		case '$version':

			// Rename tables
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links RENAME " . TABLE_PREFIX . "adv_links");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_categories RENAME " . TABLE_PREFIX . "adv_links_categories");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_customfields RENAME " . TABLE_PREFIX . "adv_links_cfields");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_customfields_entries RENAME " . TABLE_PREFIX . "adv_links_cfields_entries");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_favorites RENAME " . TABLE_PREFIX . "adv_links_favorites");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_moderator RENAME " . TABLE_PREFIX . "adv_links_moderator");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_posts RENAME " . TABLE_PREFIX . "adv_links_posts");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_rate RENAME " . TABLE_PREFIX . "adv_links_rate");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_search RENAME " . TABLE_PREFIX . "adv_links_search");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_subscribedir RENAME " . TABLE_PREFIX . "adv_links_subscribecat");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "links_subscribelink RENAME " . TABLE_PREFIX . "adv_links_subscribelink");

			$stepphrase .= 'Renamed tables.<br /><br />';

			// Create new tables
			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_banners (
					bannerid int(10) unsigned NOT NULL auto_increment,
					filename varchar(255) default NULL,
					title varchar(255) NOT NULL,
					width smallint(4) unsigned NOT NULL default '0',
					height smallint(4) unsigned NOT NULL default '0',
					filesize int(10) unsigned NOT NULL default '0',
					displayorder smallint(4) unsigned NOT NULL default '0',
					PRIMARY KEY	(bannerid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_permissions (
					permissionid int(10) unsigned NOT NULL auto_increment,
					catid int(10) unsigned NOT NULL default '0',
					usergroupid int(10) unsigned NOT NULL default '0',
					permissions int(10) unsigned NOT NULL default '0',
					PRIMARY KEY	(permissionid)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . "adv_links_reports (
					repid int(10) unsigned NOT NULL auto_increment,
					userid int(10) unsigned NOT NULL default '0',
					`data` text,
					dateline int(10) unsigned NOT NULL default '0',
					endtime int(10) unsigned NOT NULL default '0',
					lastlinkid INT(10) UNSIGNED DEFAULT '0' NOT NULL,
 					checkagain SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL,
					`type` varchar(20) NOT NULL,
					PRIMARY KEY	(repid)
				) $enginevar=MyISAM
			");

			$stepphrase .= 'Created new tables.<br /><br />';
			vbflush();


			// Alter tables
			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . "adv_links_categories
					CHANGE lastposter lastlinkusername VARCHAR(100) DEFAULT NULL,
					CHANGE lastuserid lastlinkuserid INT(10) UNSIGNED DEFAULT '0',
					CHANGE lastupdated lastlinkdateline INT(10) UNSIGNED DEFAULT '0'
			");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD active smallint(3) unsigned NOT NULL default '0' AFTER haslinks");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD catuserid int(10) unsigned NOT NULL default '0' AFTER active");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD `allowusercats` SMALLINT( 3 ) UNSIGNED DEFAULT '0' NOT NULL AFTER `catuserid`");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD `password` varchar(100) NOT NULL default '' AFTER `parentlist`");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD lastpostid int(10) unsigned NOT NULL default '0' AFTER lastlinkdateline");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD lastpostlinktitle varchar(255) NOT NULL default '' AFTER lastpostid");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD lastpostuserid int(10) unsigned NOT NULL default '0' AFTER lastpostlinktitle");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD lastpostusername varchar(100) NOT NULL default '' AFTER lastpostuserid");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD lastpostdateline int(10) unsigned NOT NULL default '0' AFTER lastpostusername");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD useroptions int(10) unsigned NOT NULL default '0' AFTER options");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD valid SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL AFTER haslinks");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links CHANGE `url` `linkurl` TEXT NOT NULL");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links ADD linkrecipurl TEXT NOT NULL AFTER keywords");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links ADD ipaddress varchar(15) NOT NULL default '' AFTER votetotal");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_moderator DROP username");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_cfields
				ADD catids TEXT NOT NULL,
				ADD incsubs SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL
			");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_subscribecat CHANGE `dirid` `catid` SMALLINT(3) UNSIGNED DEFAULT '0'");

			$stepphrase .= 'Altered existing tables.<br /><br />';
			vbflush();


			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET valid = 1, active = 1, options = options+32768");

			// Update phrase fieldnames
			$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET product = '" . PRODUCT_CODE . "', fieldname = 'adv_links' WHERE fieldname = 574");
			$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET product = '" . PRODUCT_CODE . "', fieldname = 'adv_links_cp' WHERE fieldname = 575");

			// Datastore tables
			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET title = 'adv_links_cats' WHERE title = 'links_d_cache'");
			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET title = 'adv_links_mods' WHERE title = 'links_mods_cache'");
			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET title = 'adv_links_perms' WHERE title = 'links_ugroups'");
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('adv_links_rand')");

			// ##### Update private categories and insert cat permissions
			$getpcats = $db->query_read("SELECT catid FROM " . TABLE_PREFIX . "adv_links_categories WHERE private = 1");
			if ($db->num_rows($getpcats))
			{
				$dstore = $db->query_first("SELECT data FROM " . TABLE_PREFIX . "datastore WHERE title = 'adv_links_perms'");
				$dstore['data'] = unserialize($dstore['data']);

				$privgroups = array();
				if (!empty($dstore['data']))
				{
					foreach ($dstore['data'] AS $groupid => $groupperms)
					{
						if ($groupperms['links_perms'] & 131072)
						{
							$privgroups[] = $groupid;
						}
					}
				}

				if (!empty($privgroups))
				{
					$updategroups = array_diff(array_keys($dstore['data']), $privgroups);
				}

				if (!empty($updategroups))
				{
					while ($pcat = $db->fetch_array($getpcats))
					{
						foreach ($updategroups AS $ugroup)
						{
							$groupupdatevalues .= "$comma ($pcat[catid], $ugroup, 0)";
							$comma = ',';
						}
					}

					$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_links_permissions (catid, usergroupid, permissions) VALUES $groupupdatevalues");
				}
			}

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories DROP private");

			$stepphrase .= 'Removed private category option and imported to category permissions system.<br /><br />';


			// ##### Cron jobs
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "cron SET
					varname = 'adv_links_search',
					filename = './includes/cron/vba_links_search.php',
					product = 'adv_links'
				WHERE filename = './includes/cron/links_search.php'
			");
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "cron SET
					varname = 'adv_links_subscriptions',
					filename = './includes/cron/vba_links_subscriptions.php',
					product = 'adv_links'
				WHERE filename = './includes/cron/links_subscriptions.php'
			");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "cron
					(nextrun, weekday, day, hour, minute, filename, loglevel, varname, product)
				VALUES
					(" . TIMENOW . ", -1, -1, -1, 0, './includes/cron/vba_links_rand.php', 1, 'adv_links_rand', 'adv_links')
			");

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_cfields SET catids = 'all'");

			// Update the mod cache to support the new structure
			update_adv_links_mods();

			$nextdo = 'removephrases';
			construct_hidden_code('slashes', 1);

			// Update what's new for new format
			$db->query_first("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $mainsettings['adv_links_main']['links_newlinklimit']['value'] . "' WHERE varname = 'links_newlinklimit'");

		// ##### 2.0 Beta 2
		case '2.0 Beta 2':
		case '2.0 Beta 2 (vB 3.6)':

			// Update remote site setting
			if (!function_exists('curl_init'))
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = 'fsockopen' WHERE varname = 'links_remotesite'");
			}

			// Update datastore entries to unserialize
			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = 1 WHERE title IN('adv_links_cats', 'adv_links_mods', 'adv_links_opts', 'adv_links_perms', 'adv_links_rand')");

			$db->query_write("UPDATE " . TABLE_PREFIX . "cron SET nextrun = " . TIMENOW . " WHERE filename = './includes/cron/adv_links_rand.php'");

		// ##### 2.0 RC1
		case '2.0 RC1':
		case '2.0 RC1 (vB 3.6)':

			// Fix index
			$db->reporterror = 0;
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links DROP INDEX linkid, ADD INDEX catid (catid, suspended, valid, dateline)");
			$db->reporterror = 1;

			// Add reciprocal field
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD recipoptions SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL AFTER useroptions");

			// Remove old templates
			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "template WHERE title IN(
					'adv_links_directorybit_level1',
					'adv_links_directorybit_level2',
					'adv_links_directorybit_main',
					'ADV_LINKS_RESULTS',
					'adv_links_directoryjump')
			");

		// ##### 2.0.0
		case '2.0.0':
		case '2.0.0 (vB 3.6)':

			// Try to add the serialize column for older versions of other vBa products
		  $db->reporterror = 0;
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
		  $db->reporterror = 1;

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links ADD `lastpostid` INT(10) UNSIGNED DEFAULT '0' NOT NULL AFTER `ipaddress`");

			$stepphrase .= 'Altered adv_links table to add lastpostid column.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_links_categories ADD `lastpostlinkid` INT(10) UNSIGNED DEFAULT '0' NOT NULL AFTER `lastpostid`");

			$stepphrase .= 'Altered adv_links_categories table to add lastpostlinkid column.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language ADD phrasegroup_adv_links_managecats MEDIUMTEXT NOT NULL");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrasetype
					(fieldname, title, editrows, product)
				VALUES (
					'adv_links_managecats',
					'vBadvanced Links Directory Category Manager',
					3,
					'" . PRODUCT_CODE . "'
			)");

			$stepphrase .= 'Added &quot;adv_links_managecats&quot; phrase group.<br /><br />';

			// Update usergroups to add the new canreport permission
			$groupds = $db->query_first("SELECT data FROM " . TABLE_PREFIX . "datastore WHERE title = 'adv_links_perms'");

			$groupds['data'] = unserialize($groupds['data']);

			$groupperms = array();

			foreach ($groupds['data'] AS $groupid => $group)
			{
				$groupperms[$groupid]['links_maxcats'] = $group['links_maxcats'];

				$groupperms[$groupid]['links_perms'] = iif($groupid > 1, $group['links_perms'] + 4194304, $group['links_perms']);
			}

			$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET data = '" . $db->escape_string(serialize($groupperms)) . "' WHERE title = 'adv_links_perms'");

			$stepphrase .= 'Updated usergroup permissions to add \'Can report links\' permissions.<br /><br />';

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string('a:5:{i:0;s:7:"addlink";i:1;s:5:"reply";i:2;s:6:"search";i:3;s:6:"report";i:4;s:12:"sendtofriend";}') . "' WHERE varname = 'links_imageverify'");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'links_post_imageverify'");

			$stepphrase .= 'Updated image verification options.<br /><br />';

			// Update Parentlists
			$getcats = $db->query_read("SELECT catid, parentlist FROM " . TABLE_PREFIX . "adv_links_categories");
			while ($cats = $db->fetch_array($getcats))
			{
				$parentlist = implode(',', array_map('trim', explode(',', $cats['parentlist'])));

				if ($cats['parentlist'] != $parentlist)
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET parentlist = '$parentlist' WHERE catid = $cats[catid]");
				}
			}

			$domaintenance = true;

		// #####
		default:

			// Update Phrases
			insert_all_phrases();

			$stepphrase .= 'Added / updated phrases.<br /><br />';

			// Templates
			insert_all_templates();

			$stepphrase .= 'Updated templates.<br /><br />';
			vbflush();

			// Settings
			foreach ($mainsettings AS $grouptitle => $settings)
			{
				foreach ($settings AS $varname => $setting)
				{
					if (!insert_setting())
					{
						update_setting();
					}
				}
			}

			// Update settinggroups
			foreach ($adv_settinggroups AS $displayorder => $grouptitle)
			{
				$displayorder = $displayorder + 1;

				$checksg = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = '$grouptitle'");

				if ($checksg['grouptitle'])
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_settinggroup SET displayorder = $displayorder WHERE grouptitle = '$grouptitle'");
				}
				else
				{
					// I have no idea how people are getting errors from this, but we'll use INSERT IGNORE to prevent them
					$db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup (grouptitle, displayorder) VALUES ('$grouptitle', $displayorder)");
				}
			}

			$stepphrase .= 'Updated settinggroups.<br /><br />';
			vbflush();

			// Plugins
			insert_plugins();
			$stepphrase .= 'Updated plugins.<br /><br />';

			// Version Number
			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $version . "' WHERE varname = 'links_version'");
			$db->query_write("UPDATE " . TABLE_PREFIX . "product SET version = '" . $version . "' WHERE productid = 'adv_links'");

			// Settings Cache
			$adv_options = array();
			$settings = $db->query_read("
				SELECT adv_setting.*
				FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
				LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup ON (adv_setting.grouptitle = adv_settinggroup.grouptitle)
				WHERE adv_setting.grouptitle LIKE 'adv_links%' OR adv_setting.grouptitle = 'adv_global'
			");

			while ($setting = $db->fetch_array($settings))
			{
				if ($setting['serialize'])
				{
					$setting['value'] = unserialize($setting['value']);
					if (!is_array($setting['value']))
					{
						$setting['value'] = array();
					}
				}

				$adv_options[$setting['varname']] = $setting['value'];
			}

			$db->free_result($settings);
			unset($setting);

			build_datastore('adv_links_opts', serialize($adv_options), 1);

			$stepphrase .= 'Updated version number.<br /><br />';

			$vba_options =& $adv_options;

			// Update the category cache to include any new values
			update_category_cache();

			$step = 1;
			$rebuildtemp = 1;

			if (!$nextdo)
			{
				$nextdo = 'finished';
			}

			if ($domaintenance)
			{
				$stepphrase .= 'Upgrade complete. It is recommended that you use the &quot;Update Categories&quot; and &quot;Update Last Post Info&quot; tools in the Maintenance section of your vBa Links Directory. <a href="vba_links_admin.php?do=maintenance">Go there now</a>.';
			}

	}

	print_install_table_end();
}

// ######################### Uninstall #########################
if ($_REQUEST['do'] == 'uninstall')
{
	$step = $_POST['step'];


	print_form_header($scriptfile, 'uninstall');
	print_table_header('Uninstall vBadvanced ' . $scriptname);

	$db->reporterror = 0;

	switch ($step)
	{
		case 1:
			$stepphrase = 'We\'re sorry you didn\'t like vBadvanced ' . $scriptname . '. Running this script will remove all changes that were made for vBadvanced ' . $scriptname . '.</div>';
		break;

		case 2:

			// ##### Drop tables
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_banners");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_categories");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_cfields");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_cfields_entries");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_favorites");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_moderator");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_permissions");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_posts");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_rate");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_search");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_subscribecat");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_subscribelink");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . "adv_links_reports");

			$stepphrase = 'Removed tables.<br /><br />';

			// Phrases
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE fieldname IN ('adv_links', 'adv_links_cp', 'adv_links_managecats')");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = '" . PRODUCT_CODE . "'");

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language DROP phrasegroup_adv_links");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language DROP phrasegroup_adv_links_cp");
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language DROP phrasegroup_adv_links_managecats");

			$stepphrase .= 'Removed phrases.<br /><br />';

			// Plugins
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = '" . PRODUCT_CODE . "'");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE product = '" . PRODUCT_CODE . "'");

			$stepphrase .= 'Remove product and plugins.<br /><br />';

			// Templates
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("','", array_keys($maintemplates)) . "')");

			$stepphrase .= 'Removed templates.<br /><br />';

			// Settings
			foreach ($mainsettings AS $grouptitle => $settings)
			{
				foreach ($settings AS $varname => $setting)
				{
					kill_setting($varname);
				}
			}

			unset($adv_settinggroups['adv_global']);

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle IN('" . implode("','", array_keys($adv_settinggroups)) . "')");

			$stepphrase .= 'Removed settings.<br /><br />';

			// Datastore entries
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "datastore WHERE title IN ('adv_links_cats', 'adv_links_mods', 'adv_links_opts', 'adv_links_perms', 'adv_links_rand')");

			$stepphrase .= 'Removed fields from the datastore table.<br /><br />';


			$db->query_write("DELETE FROM " . TABLE_PREFIX . "cron WHERE varname IN('adv_links_search', 'adv_links_subscriptions', 'adv_links_rand')");

			$stepphrase .= 'Removed scheduled tasks.<br />';

			$nextstep = 'finished';


		break;

		case 'finished':

			$stepphrase = 'vBadvanced ' . $scriptname . ' Successfully Uninstalled.<br /> <br /><a href="index.php"><b>Log Into Admin CP --&gt;</b></a><br /><br /><a href="' . $scriptfile . '.php"><b>Click here to re-install --&gt;</b></a>';

		break;
	}

	print_install_table_end();
}

// ##### Global settings re-install ###########################################
if ($_REQUEST['do'] == 'globalsettings')
{
	foreach ($mainsettings['adv_global'] AS $varname => $setting)
	{
		insert_setting();
	}

	$settings = $db->query("SELECT varname, value FROM " . TABLE_PREFIX . "adv_setting WHERE varname LIKE 'links%' OR varname LIKE 'global%'");
	while ($setting = $db->fetch_array($settings))
	{
		$adv_options["$setting[varname]"] = $setting['value'];
	}
	$db->free_result($settings);
	build_datastore('adv_links_opts', serialize($adv_options), 1);

}

// ##### Find old phrases #####################################################
if ($_REQUEST['do'] == 'removephrases')
{
	$checkphrase = array();

	print_form_header($scriptfile, 'doremovephrases');

	if ($_REQUEST['slashes'])
	{
		construct_hidden_code('slashes', 1);
	}
	print_table_header('Remove old phrases');
print_description_row('The following phrases have been found, but are not from the current version of vBa Links Directory. If you have added any phrases for hacks or any other reason, please un-check the box next to any phrases you wish to keep. Otherwise, click the &quot;Save&quot; button to remove the selected phrases.<br /><br /><div><input type="checkbox" id="allbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> <label for="allbox">Check All</label></div>');
	foreach ($mainphrases AS $fieldname => $phrases)
	{
		$checkphrase = array_merge($checkphrase, array_keys($phrases));
	}

	print_cells_row(array('Remove', 'Phrase Varname / Text'), true);

	$phrases = $db->query_read("SELECT varname, text, fieldname, languageid FROM " . TABLE_PREFIX . "phrase WHERE fieldname IN('adv_links', 'adv_links_cp', 'adv_links_managecats') AND varname NOT IN('" . implode("', '", $checkphrase) . "')");

	if ($db->num_rows($phrases))
	{
		while ($phrase = $db->fetch_array($phrases))
		{
			print_label_row('<input type="checkbox" checked="checked" name="phrase[' . $phrase['fieldname'] . '][' . $phrase['languageid'] . '][' . $phrase['varname'] . '] value="1" />', $phrase['varname'] . '<div class="smallfont">' . $phrase['text'] . '</div>');
		}
	}
	else
	{
		print_description_row('No extra phrases found. Please click &quot;Save&quot; to continue.');
	}

	print_submit_row();
	print_table_footer();
}

// ###### Do remove phrases
if ($_POST['do'] == 'doremovephrases')
{

	$killphrase = array();
	if (!empty($_POST['phrase']))
	{
		foreach ($_POST['phrase'] AS $fieldname => $phrases)
		{
			foreach ($phrases AS $langid => $phrase)
			{
				foreach ($phrase AS $varname => $val)
				{
					$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = '$varname' AND languageid = '$langid' AND fieldname = '$fieldname'");
				}
			}
		}
	}

	build_language(-1);

	if ($_POST['slashes'])
	{
		print_cp_redirect($scriptfile . '.php?do=removeslashes');
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished');
	}
}

// ##### Fix entries that had addslashes() run on them
if ($_REQUEST['do'] == 'removeslashes')
{
	$getcats = $db->query_read("SELECT catid, title, description FROM " . TABLE_PREFIX . "adv_links_categories WHERE title LIKE '%\'%' OR description LIKE '%\'%'");
	while ($cat = $db->fetch_array($getcats))
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links_categories SET
				title = '" . $db->escape_string(stripslashes($cat['title'])) . "',
				description = '" . $db->escape_string(stripslashes($cat['description'])) . "'
			WHERE catid = $cat[catid]
		");
	}

	$getlinks = $db->query_read("SELECT linkid, name, description FROM " . TABLE_PREFIX . "adv_links WHERE name LIKE '%\'%' OR description LIKE '%\'%'");
	while ($link = $db->fetch_array($getlinks))
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links SET
				name = '" . $db->escape_string(stripslashes($link['name'])) . "',
				description = '" . $db->escape_string(stripslashes($link['description'])) . "'
			WHERE linkid = $link[linkid]
		");
	}

	print_cp_redirect($scriptfile . '.php?do=finished');
}

// ##### Rebuild settings #####################################################
if ($_REQUEST['do'] == 'rebuildsettings')
{
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		foreach ($settings AS $varname => $setting)
		{
			if (!insert_setting())
			{
				update_setting();
			}
		}
	}
}

// ##### Update plugins #######################################################
if ($_REQUEST['do'] == 'updateplugins')
{
	insert_plugins();
	echo 'Plugins reinstalled.';
}

// ##### Update settinggroups #######################################################
if ($_REQUEST['do'] == 'sgroups')
{
	foreach ($adv_settinggroups AS $groupkey => $groupname)
	{
		$db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('$groupname', " . ($groupkey + 1) . ")");
	}

	echo 'Settinggroups updated.';
}

print_cp_footer();

?>