<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$status_array = array(
	'1'			=> array('color' => 'red', 'text' => 'Status Check Failed'),
	'N/A'	 	=> array('color' => 'yellow', 'text' => 'Ikke HTTP'),
	'OK'		=> array('color' => 'green', 'text' => 'Valid hostname'),
	'FEJL'	=> array('color' => 'red', 'text' => 'Invalid hostname'),
	'Dd'		=> array('color' => 'red', 'text' => 'No response'),
	'100'		=> array('color' => 'yellow', 'text' => 'Continue'),
	'101'		=> array('color' => 'yellow', 'text' => 'Switching Protocols'),
	'200'		=> array('color' => 'green', 'text' => 'OK'),
	'201'		=> array('color' => 'yellow', 'text' => 'Created'),
	'202'		=> array('color' => 'green', 'text' => 'Accepted'),
	'203'		=> array('color' => 'red', 'text' => 'Non-Authoritative Information'),
	'204'		=> array('color' => 'red', 'text' => 'No Content'),
	'205'		=> array('color' => 'yellow', 'text' => 'Reset Content'),
	'206'		=> array('color' => 'yellow', 'text' => 'Partial Content'),
	'300'		=> array('color' => 'yellow', 'text' => 'Multiple Choices'),
	'301'		=> array('color' => 'red', 'text' => 'Moved Permanently'),
	'302'		=> array('color' => 'green', 'text' => 'Found'),
	'303'		=> array('color' => 'yellow', 'text' => 'See Other'),
	'304'		=> array('color' => 'yellow', 'text' => 'Not Modified'),
	'305'		=> array('color' => 'yellow', 'text' => 'Use Proxy'),
	'307'		=> array('color' => 'yellow', 'text' => 'Temporary Redirect'),
	'400'		=> array('color' => 'red', 'text' => 'Bad Request'),
	'401'		=> array('color' => 'yellow', 'text' => 'Unauthorized'),
	'402'		=> array('color' => 'yellow', 'text' => 'Payment Required'),
	'403'		=> array('color' => 'red', 'text' => 'Forbidden'),
	'404'		=> array('color' => 'red', 'text' => 'Not Found'),
	'405'		=> array('color' => 'yellow', 'text' => 'Method Not Allowed'),
	'406'		=> array('color' => 'yellow', 'text' => 'Not Acceptable'),
	'407'		=> array('color' => 'yellow', 'text' => 'Proxy Authentication Required'),
	'408'		=> array('color' => 'yellow', 'text' => 'Request Timeout'),
	'409'		=> array('color' => 'yellow', 'text' => 'Conflict'),
	'410'		=> array('color' => 'red', 'text' => 'Gone'),
	'411'		=> array('color' => 'yellow', 'text' => 'Length Required'),
	'412'		=> array('color' => 'yellow', 'text' => 'Precondition Failed'),
	'413'		=> array('color' => 'yellow', 'text' => 'Request Entity Too Large'),
	'414'		=> array('color' => 'yellow', 'text' => 'Request-URI Too Long'),
	'415'		=> array('color' => 'yellow', 'text' => 'Unsupported Media Type'),
	'416'		=> array('color' => 'yellow', 'text' => 'Requested Range Not Satisfiable'),
	'417'		=> array('color' => 'yellow', 'text' => 'Expectation Failed'),
	'500'		=> array('color' => 'yellow', 'text' => 'Internal Server Error'),
	'501'		=> array('color' => 'yellow', 'text' => 'Not Implemented'),
	'502'		=> array('color' => 'yellow', 'text' => 'Bad Gateway'),
	'503'		=> array('color' => 'yellow', 'text' => 'Service Unavailable'),
	'504'		=> array('color' => 'yellow', 'text' => 'Gateway Timeout'),
	'505'		=> array('color' => 'yellow', 'text' => 'HTTP Version Not Supported')
);

// ##################### Update Moderator Cache ########################
function update_adv_links_mods()
{
	global $db;

	$mods = array();

	$getmods = $db->query("
		SELECT user.userid, user.username, catid
		FROM " . TABLE_PREFIX . "adv_links_moderator AS links_moderator
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (links_moderator.userid = user.userid)
		ORDER BY catid, username
	");
	while ($mod = $db->fetch_array($getmods))
	{
		$children = fetch_category_children($mod['catid']);

		foreach ($children AS $mcat)
		{
			$mods[$mcat][$mod['userid']] = $mod['username'];
		}

		$mods[$mcat] = array_unique($mods[$mcat]);
	}

	$db->free_result($getmods);

	build_datastore('adv_links_mods', serialize($mods), 1);
}

// ######################## Make Category Select Field ########################
function print_category_select($selectname, $title = '', $selectedid = 0, $nonevalue = '', $disablecat = false, $nonele = 0)
{
	global $catselect, $vbulletin, $vbphrase;

	if (!$nonevalue)
	{
		$nonevalue = $vbphrase['none'];
	}

	echo '<tr class="' . fetch_row_bgclass() . '" valign="top">';
	echo '<td>' . $title . '</td>';
	echo '<td>';

	echo '<select class="bginput" name="' . $selectname . '" size="1">';
	if ($nonevalue)
	{
		echo '<option value="' . $nonele . '">' . $nonevalue . '</option>';
	}

	$options = print_cat_select($selectedid, iif($disablecat, 'submitlink', 'admin'));

	echo $options;

	echo '</select>';
 	echo '</td></tr>';
	unset($options);
}

// ######################### Print Duplicate Links ###########################
function print_dupelinks($link)
{
	global $vbulletin, $vbphrase;
	$cell = array();
	$cell[] = '<span class="smallfont" style="white-space: nowrap"><label for="deletelink[' . $link['linkid'] . ']"><input id="deletelink[' . $link['linkid'] . ']" name="deletelink[' . $link['linkid'] . ']" type="radio" value="1" />' . $vbphrase['yes'] . '</label> <label for="nodeletelink[' . $link['linkid'] . ']"><input checked="checked" id="nodeletelink[' . $link['linkid'] . ']" name="deletelink[' . $link['linkid'] . ']" type="radio" value="0" />' . $vbphrase['no'] . '</label></span>';
	$cell[] = '<span class="smallfont">' . $link['linkid'] . '</span>';
	$cell[] = $link['name'];
	$cell[] = '<span class="smallfont">' . $link['title'] . '</span>';
	$cell[] = '<div align="right" class="smallfont">' . vbdate($vbulletin->options['dateformat'], $link['dateline']) . '<br />' . $vbphrase['by'] . ' ' . iif($link['username'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $link['userid'] . '" target="_blank">' . $link['username'] . '</a>', $vbphrase['unregistered']) . '</div>';
	print_cells_row($cell, '', '', -2, 'middle');
}

// ################# Construct dupelicate links ######################
function find_duplicates($linkarray, $url)
{
	global $link, $counter, $donearray, $vbphrase;

	if (empty($donearray))
	{
		$donearray = array();
	}
	$counter = 0;
	foreach ($linkarray AS $links)
	{

		$links['url'] = str_replace('www.', '', $links['url']);
		$url = str_replace('www.', '', $url);

		if ($links['url'] == $url AND $links['linkid'] != $link['linkid'] AND !in_array($links['linkid'], $donearray))
		{
			$counter++;
			$donearray[] = $links['linkid'];
			$donearray[] = $link['linkid'];
			if ($counter == 1)
			{
				print_table_break();
				print_table_header('<a href="' . $link['url'] . '" target="blank">' . $link['url'] . '</a>', 6);
				print_cells_row(array($vbphrase['delete'], $vbphrase['id'], $vbphrase['title'], $vbphrase['category'], '' . $vbphrase['date_added'] . ' / ' . $vbphrase['submitted_by'] . ''), 1, tcat);
				print_dupelinks($link);
			}
			print_dupelinks($links);
		}
	}
}

// ################# Print Directories For Permissions Page ###################
function construct_categories_perms($catinfo, $cat = 0)
{
	global $counter, $vbulletin, $vbphrase, $categories;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$categories .= '<ul class="lsq"><li><b>' . $cats['title'] . '</b></li>';
				$categories .= '<ul class="usergroups">';

				foreach ($vbulletin->usergroupcache AS $group)
				{
					$categories .= '<li>[<a href="vba_links_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
				}

				$categories .= '</ul><br />';

				construct_categories_perms($catinfo, $cats['catid']);
				$categories .= '</ul>';
				$counter--;
			}
		}
	}
	return $categories;
}

// ###################### Print Category Permissions Rows #####################
function print_category_perm_rows($catinfo, $cat = 0)
{
	global $counter, $vbulletin, $vbphrase, $categories, $hasperms;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$categories .= '<ul class="lsq"><li><b>' . $cats['title'] . '</b> <span class="smallfont">( <a href="vba_links_admin.php?do=resetperms&amp;catid=' . $cats['catid'] . '">[Reset]</a> <a href="vba_links_admin.php?do=denyperms&amp;catid=' . $cats['catid'] . '">[Deny All]</a> )</li>';
				$categories .= '<ul class="usergroups">';

				foreach ($vbulletin->usergroupcache AS $group)
				{
					if ($hasperms["$group[usergroupid]"]["$cats[catid]"])
					{
						$categories .= '<li class="col-c">[<a href="vba_links_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
					else if ($hasperms["$group[usergroupid]"]["$cats[parent]"])
					{
						$hasperms["$group[usergroupid]"]["$cats[catid]"] = true;
						$categories .= '<li class="col-i">[<a href="vba_links_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';

					}
					else
					{
						$categories .= '<li>[<a href="vba_links_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
				}

				$categories .= '</ul><br />';

				print_category_perm_rows($catinfo, $cats['catid']);
				$categories .= '</ul>';
				$counter--;
			}
		}
	}
	return $categories;
}

// ######################## Print Permission Rows #############################
function print_permission_rows($category)
{
	global $vbphrase, $perms, $usergroup;

	$jscustom = '';
	if ($category)
	{
		$jscustom = 'js_set_custom();';
	}

	print_description_row($vbphrase['general_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase[iif($category, 'can_view_category', 'can_view_links_directory')], 'usergroup[canviewlinksdir]', $perms['canviewlinksdir'], $jscustom);
	print_yes_no_row($vbphrase['can_view_links'], 'usergroup[canviewlinks]', $perms['canviewlinks'], $jscustom);
	print_yes_no_row($vbphrase['can_search_links'], 'usergroup[cansearch]', $perms['cansearch'], $jscustom);
	print_yes_no_row($vbphrase['can_send_link_friend'], 'usergroup[cansendtofriend]', $perms['cansendtofriend'], $jscustom);
	print_yes_no_row($vbphrase['can_rate_links'], 'usergroup[canrate]', $perms['canrate'], $jscustom);
	print_yes_no_row($vbphrase['can_report_links_posts'], 'usergroup[canreport]', $perms['canreport'], $jscustom);

	print_description_row($vbphrase['link_adding_editing_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_add_links'], 'usergroup[canaddlinks]', $perms['canaddlinks'], $jscustom);
	print_yes_no_row($vbphrase['moderate_this_groups_links'], 'usergroup[moderatelinks]', $perms['moderatelinks'], $jscustom);

	if ($usergroup['usergroupid'] > 1)
	{
		print_yes_no_row($vbphrase['can_edit_own_links'], 'usergroup[canedit]', $perms['canedit'], $jscustom);
		print_yes_no_row($vbphrase['can_edit_others_links'], 'usergroup[caneditothers]', $perms['caneditothers'], $jscustom);
		print_yes_no_row($vbphrase['can_delete_own_links'], 'usergroup[candelete]', $perms['candelete'], $jscustom);
		print_yes_no_row($vbphrase['can_delete_others_links'], 'usergroup[catdeleteothers]', $perms['catdeleteothers'], $jscustom);
	}

	if (!$category)
	{
		print_description_row($vbphrase['category_options'], 0, 2, 'thead');
		print_yes_no_row($vbphrase['can_create_categories'], 'usergroup[cancreatecats]', $perms['cancreatecats'], $jscustom);
		print_yes_no_row($vbphrase['moderate_this_groups_categories'], 'usergroup[moderatecats]', $perms['moderatecats'], $jscustom);
		if ($usergroup['usergroupid'] > 1)
		{
			print_input_row($vbphrase['maximum_categories_set_0_no_limit'], 'usergroup[links_maxcats]', $usergroup['links_maxcats'], $jscustom);
		}
	}

	print_description_row($vbphrase['posting_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_view_replies_to_links'], 'usergroup[canviewreplies]', $perms['canviewreplies'], $jscustom);
	print_yes_no_row($vbphrase['can_reply_to_links'], 'usergroup[canreply]', $perms['canreply'], $jscustom);
	print_yes_no_row($vbphrase['moderate_this_groups_posts'], 'usergroup[moderateposts]', $perms['moderateposts'], $jscustom);
	if ($usergroup['usergroupid'] > 1)
	{
		print_yes_no_row($vbphrase['can_edit_own_posts'], 'usergroup[caneditposts]', $perms['caneditposts'], $jscustom);
		print_yes_no_row($vbphrase['can_edit_others_posts'], 'usergroup[caneditothersposts]', $perms['caneditothersposts'], $jscustom);
		print_yes_no_row($vbphrase['can_delete_own_posts'], 'usergroup[candeleteposts]', $perms['candeleteposts'], $jscustom);
		print_yes_no_row($vbphrase['can_delete_others_posts'], 'usergroup[candeleteothersposts]', $perms['candeleteothersposts'], $jscustom);
	}
	print_yes_no_row($vbphrase['can_see_who_rated'], 'usergroup[canseewhorated]', $perms['canseewhorated'], $jscustom);

}

// ##### Fetch Settings Phrases ###############################################
function fetch_settings_phrases()
{
	global $db;

	$return = array();
	$getphrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'vbsettings' ORDER BY languageid ASC");
	while($phrase = $db->fetch_array($getphrases))
	{
		$return[$phrase['varname']] = $phrase['text'];
	}

	return $return;
}

// ######################### Print Settings ###########################
function print_adv_setting_group($grouptitle, $revert = 1)
{
	global $vbulletin, $settingscache, $grouptitlecache, $vbphrase, $settingphrase, $stylevar, $vbulletin;

	if (empty($settingscache[$grouptitle]))
	{
		return;
	}
	construct_hidden_code('grouptitles[' . $grouptitle . ']', 1);

	print_table_header('<a name="#' . $grouptitle . '"></a>' . $settingphrase['settinggroup_' . $grouptitle] .
		iif($vbulletin->debug AND !$revert,
		 	'<span class="normal">' .
//			construct_link_code($vbphrase['edit'], 'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editgroup&amp;grouptitle=' . $grouptitle . ADV_URL_PREFIX) .
//			construct_link_code($vbphrase['delete'], 'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=removegroup&amp;grouptitle=' . $grouptitle. ADV_URL_PREFIX) .
			construct_link_code($vbphrase['add_setting'], 'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=addsetting&amp;grouptitle=' . $grouptitle . $identifylink . ADV_URL_PREFIX) .
			'</span>'
		)
	);

	foreach ($settingscache[$grouptitle] AS $settingid => $setting)
	{
		if ($setting['type'] == 'hidden')
		{
			continue;
		}

		$settingtext = '<div class="smallfont" style="float:' . $stylevar['right'] . '">';

		if ($vbulletin->debug AND !$revert)
		{
			$settingtext .=
				construct_link_code(
					$vbphrase['edit'],
					'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editsetting&varname=' . $setting['varname']) .
				construct_link_code(
					$vbphrase['delete'],
					'vba_links_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=removesetting&varname=' . $setting['varname'] . '&amp;grouptitle=' . $grouptitle
				);
		}

		if ($revert)
		{
			$settingtext .= '&nbsp; &nbsp; ' . $vbphrase['use_default'] . ' <input ' . iif($setting['default'], 'checked="checked"') . ' type="checkbox" name="usedefault[' . $setting['varname'] . ']" value="1" />';
		}

		$settingtext .= '</div><div>' . $settingphrase["setting_$setting[varname]_title"] . '<a name="' . $setting['varname'] . '"></a></div>';

		print_description_row($settingtext, 0, 2, 'optiontitle" title="$vba_options[' . $setting['varname'] . ']"');

		$description = '<div class="smallfont" title="$vba_options[' . $setting['varname'] . ']">' . $settingphrase["setting_$setting[varname]_desc"] . '</div>';
		$name = "setting[$setting[varname]]";

		switch ($setting['optioncode'])
		{
			case '':
				print_input_row($description, $name, $setting['value'], 1, 40, '', '', iif($revert, 'bginput" onfocus="js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'textarea':
				print_textarea_row($description, $name, $setting['value'], 8, 40, '', '', '', iif($revert, 'bginput" onfocus="js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'yesno':
				print_yes_no_row($description, $name, $setting['value'], iif($revert, 'bginput" onclick="js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'catselect':

				$selectbox = '<select name="' . $name . '[]" multiple="multiple" style="width:275px" size="' . iif(sizeof($vbulletin->adv_links_cats) > 10, 10, sizeof($vbulletin->adv_links_cats)) . '">';

				$setting['value'] = explode(',', $setting['value']);
				foreach ($vbulletin->adv_links_cats AS $cat)
				{
					$selectbox .= '<option value="' . $cat['catid'] . '" ' . iif(in_array($cat['catid'], $setting['value']),'selected="selected"') . '>' . str_repeat('--', $cat['level']) . $cat['title'] . '</option>';
				}
				$selectbox .= '</select>';

				print_label_row($description, $selectbox);
			break;

			default:
						eval("\$right = \"<div id=\\\"ctrl_setting[$setting[varname]]\\\">$setting[optioncode]</div>\";");
				print_label_row($description, $right, '', 'top', $name);
		}
	}
	print_table_break();
}

?>