<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

class vba_links
{

	var $_catperms = array();
	var $_permissions = array();

	var $_permbits = array(
		'canviewlinks'					=> 1,
		'canaddlinks'						=> 2,
		'canedit'								=> 4,
		'caneditothers'					=> 8,
		'candelete' 						=> 16,
		'catdeleteothers'				=> 32,
		'moderatelinks'					=> 64,
		'canreply'							=> 128,
		'canviewreplies'				=> 256,
		'cansearch'							=> 512,
		'cansendtofriend'			 	=> 1024,
		'canrate' 							=> 2048,
		'caneditposts'					=> 4096,
		'caneditothersposts'		=> 8192,
		'candeleteposts'				=> 16384,
		'candeleteothersposts'	=> 32768,
		'canviewlinksdir'				=> 65536,
//	'canviewprivatedirs'		=> 131072,
		'moderateposts'					=> 262144,
		'cancreatecats'					=> 524288,
		'moderatecats'					=> 1048576,
		'canseewhorated'				=> 2097152,
		'canreport'							=> 4194304
	);

	// Category options
	var $_categoryopts = array(
		'open_for_links' => 				1,
		'open_for_posts' => 				2,
		'allow_post_html' => 				4,
		'allow_post_bbcode' => 			8,
		'allow_post_smilies' => 		16,
		'allow_post_icons' => 			32,
		'allow_post_bbimgcode' => 	64,
		'allow_post_icons' => 			128,
		'allow_custom_html' => 			256,
		'allow_custom_bbcode' => 		512,
		'allow_custom_smilies' => 	1024,
		'allow_custom_icons' => 		2048,
		'allow_custom_bbimgcode' => 4096,
		'canhavepassword' => 				8192,
		'childpass' => 							16384,
		'allow_ratings' => 					32768,
		'nofollow' => 							65536,
		'allow_desc_html' => 				131072,
		'allow_desc_bbcode' => 			262144,
		'allow_desc_bbimgcode' => 	524288,
		'allow_desc_smilies' => 		1048576,
		'allow_desc_links' => 			2097152,
		'allow_custom_links' => 		4194304
	);

	// User Category Options
	var $_catuseropts = array(
		'allow_view' => 1,
		'allow_newlinks' => 2,
		'allow_reply' => 4,
		'allow_rating' => 8
	);

	var $_link = array();
	var $_cat = array();

	// ##### Load link ##########################################################
	/*
	 * Quick and easy way of loading a link and running it through all permissions
	*/
	function load_link($customfields = '', $permvar = 'canviewlinks')
	{
		global $vbphrase, $linkid;

		if ($customfields)
		{
			$cfields = ', cfields.*';
			$cjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'adv_links_cfields_entries AS cfields ON (links.linkid = cfields.lid)';
		}

		$this->_link = $this->vbulletin->db->query_first("
			SELECT links.* $cfields
			FROM " . TABLE_PREFIX . "adv_links AS links
			$cjoin
			WHERE linkid = $linkid
		");

		$this->check_link(array(), $permvar);

	}

	// ##### Check Link #########################################################
	/*
	 * Checks a link to make sure the user has all permissions to view it
	 * Sets $this->_link if it was not already set in load_link()
	 * Also sets $this->_cat since it can be used outside of the load_link function
 */
	function check_link($link = array(), $permvar = 'canviewlinks')
	{
		global $vbphrase, $vbulletin;

		if (!empty($link))
		{
			$this->_link =& $link;
		}

		if (!$this->_link['linkid'])
		{
			eval(standard_error(fetch_error('noid', $vbphrase['link'])));
		}

		if (($this->_link['suspended'] OR !$this->_link['valid']) AND !is_category_mod($this->_link['catid']))
		{
			eval(standard_error(fetch_error('noid', $vbphrase['link'])));
		}

		$this->_cat =& $this->vbulletin->adv_links_cats[$this->_link['catid']];

		if ($this->_cat['catuserid'] AND $this->_cat['catuserid'] != $vbulletin->userinfo['userid'] AND !$this->_cat['valid'])
		{
			print_no_permission();
		}

		$this->check_cat_perms($permvar, $this->_link, true);

		if (!cat_user_opt('allow_view', $this->_link['catid']))
		{
			print_no_permission();
		}

		check_category_password($this->_link['catid']);
	}

	// ##### Fetch Category Permissions #########################################
	function fetch_category_perms($catid = 0, $ugid = false)
	{
		if ($ugid !== false)
		{
			$usergroupids = array($ugid);
		}
		else
		{
			$usergroupids = fetch_membergroupids_array($this->vbulletin->userinfo);
		}

		$catid = intval($catid);

		if ($catid == 0)
		{
			$idarray =& $this->vbulletin->adv_links_cats;
		}
		else
		{
			$idarray = array($catid => $this->vbulletin->adv_links_cats[$catid]);
		}

		foreach ($idarray AS $catid => $categoryinfo)
		{
			$catperms =& $this->vbulletin->adv_links_cats[$catid]['permissions'];

			// Not set for this cat, so use the default
			if (empty($catperms))
			{
				$this->_catperms[$catid] =& $this->_permissions;
				continue;
			}

			$this->permbits_to_array($usergroupids, $catperms, $catid);
		}

	}

	// ##### Convert permissions bitfield to an array ###########################
	function permbits_to_array($usergroupids, $thiscatperms = '', $catid = 0)
	{
		global $vbulletin;

		foreach ($usergroupids AS $usergroupid)
		{
			if (!$catid)
			{
				$thiscatperms[$usergroupid] = $vbulletin->adv_links_perms[$usergroupid]['links_perms'];

				// Set this here since it should prevent bad permissions for new usergroups
				if (!isset($thiscatperms[$usergroupid]))
				{
					$usergroupid = 1;
				}
			}

			// Nothing's set, so continue and have it set to the default below
			if (!isset($thiscatperms[$usergroupid]))
			{
				continue;
			}

			foreach ($this->_permbits AS $option => $value)
			{
				if (($option == 'moderatelinks' OR $option == 'moderateposts' OR $option == 'moderatecats') AND $this->_catperms[$catid][$option] === 0)
				{
					continue;
				}

				if (!$this->_catperms[$catid][$option] OR ($option == 'moderatelinks' OR $option == 'moderateposts' OR $option == 'moderatecats'))
				{
					$this->_catperms[$catid][$option] = 0;

					if ($thiscatperms[$usergroupid] & $value)
					{
						$this->_catperms[$catid][$option] = 1;
					}
				}
			}
		}

		if (!isset($this->_catperms[$catid]))
		{
			$this->_catperms[$catid] = $this->_permissions;
		}
	}

	// ##### Get default permissions ############################################
	function default_permissions($groupid = false)
	{
		if ($groupid !== false)
		{
			$grouparray = array($groupid);
		}
		else
		{
			$grouparray =& $this->vbulletin->userinfo['usergrouparray'];
		}

		$defperms =& $this->vbulletin->adv_links_perms;

		$this->permbits_to_array($grouparray);

		$this->_permissions = $this->_catperms['0'];

		unset($this->_catperms['0']);

		// Max categories, perhaps more in the future
		foreach ($grouparray AS $groupid)
		{
			if ($this->_permissions['max_cats'] !== 0 AND $defperms[$groupid]['max_cats'])
			{
				$this->_permissions['max_cats'] = $defperms[$groupid]['max_cats'];
			}
		}
	}

	// ##### Check default permissions ##########################################
	function check_perms($permvar)
	{
		return $this->_permissions[$permvar];
	}

	// ##### Check category permissions #########################################
	function check_cat_perms($permvar, $iteminfo = array(), $errorout = false)
	{
		if (empty($this->_catperms))
		{
			$this->fetch_category_perms();
		}

		if (empty($iteminfo) AND !empty($this->_link))
		{
			$iteminfo =& $this->_link;
		}

		if (!$this->_catperms[$iteminfo['catid']][$permvar] AND $errorout)
		{
			print_no_permission();
		}

		return $this->_catperms[$iteminfo['catid']][$permvar];
	}

}


?>