<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### stripos function for PHP4- ###########################################
if (!function_exists('stripos'))
{
	function stripos($haystack, $needle, $offset = 0)
	{
		return(strpos(strtolower($haystack), strtolower($needle), $offset));
	}
}

// ########################### Delete Links #############################
function delete_links($linkarray)
{
	global $db;

	if (is_array($linkarray))
	{
		$linkarray = implode(',', array_map('intval', $linkarray));
	}

	if (!$linkarray)
	{
		return;
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links WHERE linkid IN ($linkarray)");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_posts WHERE linkid IN ($linkarray)");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_favorites WHERE linkid IN ($linkarray)");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_subscribelink WHERE linkid IN ($linkarray)");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_cfields_entries WHERE lid IN ($linkarray)");
}

// ###################### Construct Orderby #######################
function construct_orderby()
{
	global $orderby, $vba_options, $direction;

	switch ($orderby)
	{
		case 'name':
		case 'views':
		case 'dateline':
		case 'lastpostdateline':
		case 'linkid':
		case 'posts':
			return 'links.' . $orderby;
		break;

		case 'category':
			return 'categories.title';
		break;

		case 'rating':
			return 'voteavg ' . $direction . ', votenum';
		break;

		default:
			return 'links.' . $vba_options['links_deforder'];
	}
}

// ##### Find Category Mods #####################################################
function is_category_mod($catid)
{
	global $vbulletin, $permissions, $vba_options;

	$cat = $vbulletin->adv_links_cats[$catid];

	if (!$vbulletin->userinfo['userid'])
	{
		return false;
	}
	if ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
	{
		return true;
	}
	if ($cat['catuserid'] AND $vbulletin->userinfo['userid'] == $cat['catuserid'] AND $vba_options['links_usercats_modopts'])
	{
		return true;
	}
	if (isset($vbulletin->adv_links_mods[$catid][$vbulletin->userinfo['userid']]))
	{
		return true;
	}

	return false;
}

// ##### Highlight Keywords ###################################################
function highlight_keywords($string, $keywords, $wholeword)
{
	$keywords = explode(' ', $keywords);

	if (empty($keywords))
	{
		return $string;
	}

	foreach ($keywords AS $word)
	{
		$string = preg_replace("/($word)([^>]*<)/i", "<span class=\"highlight\">$1</span>$2", $string);
	}
	
	return $string;
}

// ##### Print Category Select Field ##########################################
function print_cat_select($selectedid = 0, $type)
{
	global $vbulletin, $vba_links, $allowedparents, $category;

	switch ($type)
	{
		case 'catjump':
			$permvar = 'canviewlinksdir';
		break;

		case 'submitlink':
			$permvar = 'canaddlinks';
		break;

		case 'search':
			$permvar = 'cansearch';
		break;

		case 'managecats':
			$permvar = 'cancreatecats';
		break;

		case 'admin':
		break;
	}

	if (!is_array($allowedparents))
	{
		$allowedparents = array();
	}

	if (!empty($vbulletin->adv_links_cats))
	{
		foreach ($vbulletin->adv_links_cats AS $catid => $cats)
		{
			$iscatmod = is_category_mod($cats['catid']);

			if ($type != 'admin' AND VB_AREA != 'AdminCP')
			{
				if
				(
					($type == 'managecats' AND (!$cats['allowusercats'] AND !in_array($cats['catid'], $allowedparents) OR $cats['catid'] == $category['catid']))
						OR
					($type == 'submitlink' AND (!cat_opt('open_for_links', $catid)))
						OR
					(!$cats['valid'] AND ($cats['catuserid'] != $vbulletin->userinfo['userid'] OR !$cats['catuserid']))
				)
				{
					continue;
				}


				if ($cats['parent'] != 0 AND !$vbulletin->adv_links_cats["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
				{
					$cats['active'] = 0;
					$vbulletin->adv_links_cats[$cats['catid']]['active'] = 0;
				}

				// Does the user own the category?
				if (!$iscatmod)
				{
					if ((!cat_user_opt('allow_submit') AND $type == 'submitlink') OR !cat_user_opt('allow_view') OR !$cats['valid'])
					{
						continue;
					}
				}

				if ($type == 'moderation')
				{
					if (!$iscatmod)
					{
						continue;
					}
				}
				else if (!$vba_links->check_cat_perms($permvar, $cats) OR !check_category_password($cats['catid'], false))
				{
					continue;
				}
			} // End if($type != 'admin')

			$dashes = '';
			if ($cats['level'] > 1)
			{
				$dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
			}

			$selected = '';
			if ($selectedid == $cats['catid'])
			{
				$selected = 'selected="selected"';
				$class = 'fjsel';
			}
			else if ($cats['level'] <= 4)
			{
				$class = 'fjdpth' . $cats['level'];
			}
			else
			{
				$class = 'fjdpth';
			}

			if (!$cats['haslinks'] AND (($type == 'submitlink' OR $type == 'moderation') OR in_array($cats['catid'], $allowedparents)))
			{
				if ($options)
				{
					$endgroup = true;
					$options .= '</optgroup>';
				}
				$options .= '<optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $dashes . '' . $cats['title'] . '">';
			}
			else
			{
				$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . $cats['title'] . '</option>';
			}
		}
		if ($endgroup)
		{
			$options .= '</optgroup>';
		}
		unset($cats);
	}
	return $options;
}

// ############################ Category Jump #################################
function print_category_jump($dcatid = 0)
{
	global $catid, $vba_options, $_REQUEST, $vbphrase, $stylevar, $gobutton;

	if (!$vba_options['links_enable_dirjump'])
	{
		return;
	}

	$action = $_REQUEST['do'];

	if ($_REQUEST['do'] == 'searchresults')
	{
		$action = 'search';
	}

	$doselect[$action] = 'class="fjsel" selected="selected"';

	$options = print_cat_select($dcatid, 'catjump');

	eval('$categoryjump = "' . fetch_template('adv_links_categoryjump') . '";');

	return $categoryjump;
}

// ################# Construct the navbits for browselinks ######################
function fetch_cat_navbits($catid)
{
	global $vbulletin, $navbits;

	foreach (array_reverse(explode(',', $vbulletin->adv_links_cats[$catid]['parentlist'])) AS $key => $parent)
	{
		$navbits['browselinks.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $parent] = $vbulletin->adv_links_cats[$parent]['title'];
	}

	return $navbits;
}

// ########## Adv Sorting URL (used for sorting on showlink.php ###############
function construct_adv_sort_url($exclude = array())
{
	global $vbulletin, $_REQUEST;

	if ($_REQUEST['c'])
	{
		$_REQUEST['catid'] = $_REQUEST['c'];
	}

	if ((!$_REQUEST['do'] OR $_REQUEST['do'] == 'showdetails') AND $_REQUEST['catid'])
	{
		$_REQUEST['do'] = $_REQUEST['catid'];
	}

	if (in_array($_REQUEST['do'], array('favorites', 'poplinks', 'newlinks', 'subscriptions', 'member', 'searchresults')))
	{
		$url = '&amp;catid=' . $_REQUEST['do'];
	}
	else
	{
		$url = '&amp;catid=' . intval($_REQUEST['catid']);
	}

	$actions = array(
		'orderby' => TYPE_NOHTML,
		'direction' => TYPE_NOHTML,
		'linkuserid' => TYPE_INT,
		'searchid' => TYPE_INT,
		'page' => TYPE_INT,
		'ltr' => TYPE_NOHTML,
		'cutoffdate' => TYPE_INT
	);

	if (!empty($exclude))
	{
		foreach ($exclude AS $exaction)
		{
			unset($actions[$exaction]);
		}
	}

	foreach ($actions AS $action => $type)
	{
		if ($_REQUEST[$action])
		{
			$url .= '&amp;' . $action . '=' . $vbulletin->input->clean_gpc('r', $action, $type);
		}
	}

	return $url;
}

// ###################### Initial Update Counters Function ##################
function update_count($catid = 0, $linkcounters = true, $postcounters = true, $updatelastlink = true, $updatelastpost = true)
{
	global $db;

	if ($catid)
	{
		$catquery = "WHERE catid = '$catid'";
	}

	$getcats = $db->query_read("SELECT catid FROM " . TABLE_PREFIX . "adv_links_categories " . iif($catid, 'WHERE catid = ' . $catid));
	while ($cats = $db->fetch_array($getcats))
	{
		$linkids = array();
		$getlinks = $db->query_read("
			SELECT linkid " . iif($updatelastlink, ', name, dateline, username, userid') . "
			FROM " . TABLE_PREFIX . "adv_links
			WHERE catid = $cats[catid]
				AND suspended = 0
				AND valid = 1
			ORDER BY dateline DESC
		");
		$cats['linkcount'] = $db->num_rows($getlinks);
		while ($links = $db->fetch_array($getlinks))
		{
			$linkids[] = $links['linkid'];

			// This should be the first row if $lastlinkid isn't set, so set the cat info
			if (!$cats['lastlinkid'] AND $updatelastlink)
			{
				$cats['lastlinkid'] = $links['linkid'];
				$cats['lastlinkdateline'] = $links['dateline'];
				$cats['lastlinkuser'] = $links['username'];
				$cats['lastlinkname'] = $links['name'];
				$cats['lastlinkuserid'] = $links['userid'];
			}
		}
		$db->free_result($getlinks);
		unset($links);

		$cats['pcount'] = 0;

		if (!empty($linkids) AND $postcounters)
		{
			$postids = array();

			$getposts = $db->query_read("
				SELECT postid, posts.linkid, posts.dateline, posts.userid, posts.username, links.name AS linktitle
				FROM " . TABLE_PREFIX . "adv_links_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "adv_links AS links ON (posts.linkid = links.linkid)
				WHERE posts.linkid IN (" . implode(',', $linkids) . ")
					AND visible = 1
				ORDER BY posts.dateline DESC
			");
			$cats['pcount'] = $db->num_rows($getposts);
			while ($posts = $db->fetch_array($getposts))
			{
				// This should be the first row if $lastlinkid isn't set, so set the cat info
				if (!$cats['lastpostid'] AND $updatelastpost)
				{
					$cats['lastpostid'] = $posts['postid'];
					$cats['lastpostlinkid'] = $posts['linkid'];
					$cats['lastpostdateline'] = $posts['dateline'];
					$cats['lastpostusername'] = $posts['username'];
					$cats['lastpostuserid'] = $posts['userid'];
					$cats['lastpostlinktitle'] = $posts['linktitle'];
				}
			}

			unset($linkids);
		}

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links_categories SET " .
					iif($linkcounters, "linkcount = '$cats[linkcount]', ") .
					iif($postcounters, "postcount = '$cats[pcount]'") .

					iif($updatelastlink, ",
						lastlinkid = '$cats[lastlinkid]',
						lastlinkdateline = '$cats[lastlinkdateline]',
						lastlinktitle = '" . $db->escape_string($cats['lastlinkname']) . "',
						lastlinkusername = '" . $db->escape_string($cats['lastlinkuser']) . "',
						lastlinkuserid = '$cats[lastlinkuserid]'") .
					iif($updatelastpost, ",
						lastpostid = '$cats[lastpostid]',
						lastpostlinkid = '$cats[lastpostlinkid]',
						lastpostdateline = '$cats[lastpostdateline]',
						lastpostlinktitle = '" . $db->escape_string($cats['lastpostlinktitle']) . "',
						lastpostusername = '" . $db->escape_string($cats['lastpostusername']) . "',
						lastpostuserid = '$cats[lastpostuserid]'") .
			" WHERE catid = '$cats[catid]' AND haslinks = 1
		");
	}
}

// ########################## Construct Categories ############################
function construct_categories($catinfo, $cat = 0)
{
	global $catcount;

	if (!$catinfo)
	{
		return array();
	}

	foreach ($catinfo AS $cats)
	{
		if ($cats['parent'] == $cat AND $cats['catid'] != $cat)
		{
			$catcount++;
			$cats['level'] = $catcount;

			$catarray[$cats['catid']] = $cats;

			if ($subcatinfo = construct_categories($catinfo, $cats['catid']))
			{
				foreach ($subcatinfo AS $subcatid => $subcat)
				{
					$catarray[$subcat['catid']] = $subcat;
				}
			}
			$catcount--;
		}
	}

	return $catarray;
}

// ########################### Find Category Children #########################
function fetch_category_children($cat = 0)
{
	global $vbulletin;

	$getcatarray = construct_categories($vbulletin->adv_links_cats, $cat);
	$catarray = array();
	$catarray[] = $cat;
	if (!empty($getcatarray))
	{
		foreach ($getcatarray AS $cats)
		{
			$catarray[] = $cats['catid'];
		}
	}
	return $catarray;
}

// ###################### Category Options #######################
function cat_opt($var, $chkcatid = '')
{
	global $vba_links, $vbulletin, $catid, $link;

	if (!$chkcatid)
	{
		if (intval($catid))
		{
			$chkcatid = $catid;
		}
		else if ($link['catid'])
		{
			$chkcatid = $link['catid'];
		}
	}

	return ($vbulletin->adv_links_cats[$chkcatid]['options'] & $vba_links->_categoryopts[$var]) ? true : false;
}

// ####################### Construct Category User Options ############################
function cat_user_opt($var, $chkcatid = 0)
{
	global $vba_links, $vbulletin, $catid;

	if ($catid AND !$chkcatid)
	{
		$chkcatid = $catid;
	}

	$catinfo =& $vbulletin->adv_links_cats[$chkcatid];

	if (!$catinfo['catuserid'] OR $catinfo['catuserid'] == $vbulletin->userinfo['userid'])
	{
		return true;
	}

	return ($catinfo['useroptions'] & $vba_links->_catuseropts[$var]) ? true : false;
}

// ############################# Subscribed Posts #########################
function send_subscribed_posts($linkid, $moderation = false, $userid = '', $username = '', $message = '')
{
	global $db, $vba_options, $vbulletin, $post;

	if ($vba_options['links_allowsubscribe'])
	{
		$link = $db->query_first("
			SELECT links.linkid, name, posts.dateline, categories.title
			FROM " . TABLE_PREFIX . "adv_links_posts AS posts
			INNER JOIN " . TABLE_PREFIX . "adv_links AS links ON (posts.linkid = links.linkid)
			INNER JOIN " . TABLE_PREFIX . "adv_links_categories AS categories ON (links.catid = categories.catid)
			WHERE links.linkid = '$linkid'
			ORDER BY dateline DESC
		");

		if (!$moderation)
		{
			$userid = $vbulletin->userinfo['userid'];
		}
		else
		{
			$post['message'] = $message;
			$vbulletin->userinfo['username'] = $username;
		}

		$categoryname = $link['title'];

		$subscriptions = $db->query("
			SELECT subscriptions.userid, username, email
			FROM " . TABLE_PREFIX . "adv_links_subscribelink AS subscriptions
			INNER JOIN " . TABLE_PREFIX . "user AS user USING (userid)
			WHERE linkid = '$linkid' AND user.lastactivity > '$link[dateline]' AND subscriptions.userid != '$userid'
		");
		while ($subscription = $db->fetch_array($subscriptions))
		{
			$username = $subscription['username'];
			eval(fetch_email_phrases('adv_links_subscribe_link', 0));
			vbmail($subscription['email'], $subject, $message);
		}
	}
}

// ##### Template replacements function #######################################
if (!function_exists('replace_template_filenames'))
{
	function replace_template_filenames($tempname, $extrafiles = array())
	{
		global $vbulletin, $vba_options;

		global $repfiles;

		$repfiles = array();

		$optreplace = explode("\r\n", $vba_options['global_' . $tempname . '_replace']);
		if (!empty($optreplace))
		{
			foreach ($optreplace AS $filename)
			{
				if (trim($filename))
				{
					$repfiles['find'][] = '"' . $filename;
					$repfiles['replace'][] = '"' . $vbulletin->options['bburl'] . '/' . $filename;
				}
			}
		}

		if (!empty($extrafiles['find']))
		{
			$repfiles['find'] = array_merge($repfiles['find'], $extrafiles['find']);
		}

		if (!empty($extrafiles['replace']))
		{
			$repfiles['replace'] = array_merge($repfiles['replace'], $extrafiles['replace']);
		}

		if (empty($repfiles))
		{
			return;
		}

		$vbulletin->templatecache[$tempname] = str_replace(
			$repfiles['find'],
			$repfiles['replace'],
			$vbulletin->templatecache[$tempname]
		);
	}
}

// ############################ Fetch Page Data ###############################
function fetch_page_data($perpage = 0, $count = false)
{
	global $vbulletin, $vba_options, $condition, $wherequery, $_REQUEST, $search;

	if ($count !== false)
	{
		$pagedata['count'] = $count;
	}
	else
	{
		$pagedata = $vbulletin->db->query_first("
			SELECT COUNT(*) AS count
			FROM " . TABLE_PREFIX . $condition['fromtable'] . "
			" . iif($condition['join'], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join'] . ' USING (linkid)') . "
			" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
		");
	}

	$pagedata['pagenumber'] = intval($_REQUEST['page']);

	// Work out pages & limits
	if (!$pagedata['pagenumber'])
	{
		$pagedata['pagenumber'] = 1;
	}

	$pagedata['perpage'] = iif($perpage, $perpage, $vba_options['links_perpage']);

	$pagedata['minlimit'] = intval(($pagedata['pagenumber'] - 1) * $pagedata['perpage'] + 1);
	$pagedata['maxlimit'] = intval($pagedata['pagenumber'] * $pagedata['perpage']);

	if ($pagedata['maxlimit'] > $pagedata['count'])
	{
		$pagedata['maxlimit'] = $pagedata['count'];
		if ($pagedata['minlimit'] > $pagedata['count'])
		{
			$pagedata['minlimit'] = $pagedata['count'] - $pagedata['perpage'];
		}
	}
	if ($pagedata['minlimit'] <= 0)
	{
		$pagedata['minlimit'] = 1;
	}

	$pagedata['pagecount'] = ceil($pagedata['count'] / $pagedata['perpage']);

	return $pagedata;
}

// ##### Check Password #######################################################
function check_category_password($catid, $printerror = true)
{
	global $vbulletin;

	$catinfo =& $vbulletin->adv_links_cats[$catid];

	if ((!$catinfo['password'] AND !$catinfo['parentpass']) OR !cat_opt('canhavepassword', $catid))
	{
		return true;
	}

	if ($catinfo['parentpass'] AND !$catinfo['password'])
	{
		$checkpass = $vbulletin->adv_links_cats[$catinfo['parentpass']]['password'];
		$checkcatid = $catinfo['parentpass'];
	}
	else
	{
		$checkpass = $catinfo['password'];
		$checkcatid = $catid;
	}

	if (md5($vbulletin->userinfo['userid'] . $checkpass) == fetch_bbarray_cookie('catpassword', $checkcatid))
	{
		return true;
	}

	if ($printerror)
	{
		eval(standard_error(fetch_error('adv_links_categorypassword', $vbulletin->session->vars['sessionurl'], $scriptpath, $catinfo['catid'])));
	}

	return false;
}

// ## Fetch Ignored Userids ###################################################
function fetch_ignored_users($catid = 0)
{
	global $vbulletin;

	if (!is_category_mod($catid))
	{
		$ignusers = fetch_coventry();
	}
	if ($vbulletin->userinfo['ignorelist'])
	{
		if (!is_array($ignusers))
		{
			$ignusers = array();
		}

		$ignusers = array_merge($ignusers, explode(' ', $vbulletin->userinfo['ignorelist']));
	}

	if (!empty($ignusers))
	{
		return implode(',', $ignusers);
	}
}

// ##### Fetch Formated Filesize ##############################################
function fetch_rfilesize($filesize, $dec = 2)
{
	global $vbphrase;

	foreach (array('GB' => 1073741824, 'MB' => 1048576, 'KB' => 1024) AS $ext => $limit)
	{
		if ($filesize >= $limit)
		{
			return vb_number_format($filesize / $limit, $dec) . ' ' . $ext;
		}
	}

	return intval($filesize) . ' ' . $vbphrase['bytes'];
}

// ##### Fetch Human Verification #############################################
function fetch_human_verify($area)
{
	global $vbulletin, $vba_options;

	if (IS_VB_37)
	{
		if ($vbulletin->options['hv_type'] AND in_array($area, $vba_options['links_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			if ($vbulletin->options['hv_type'] == 'Image')
			{
				$vbulletin->templatecache['humanverify_image'] = str_replace(
					'"image.php',
					'"' . $vbulletin->options['bburl'] . '/image.php',
					$vbulletin->templatecache['humanverify_image']
				);
			}
			
			require_once(DIR . '/includes/class_humanverify.php');
			$verification =& vB_HumanVerify::fetch_library($vbulletin);
			return $verification->output_token();
		}
	}
	else
	{
		global $vbphrase;

		// Image verification
		if ($vbulletin->options['regimagetype'] AND in_array($area, $vba_options['links_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			require_once(DIR . '/includes/functions_regimage.php');
			$imagehash = fetch_regimage_hash();
	
			$vbulletin->templatecache['imagereg'] = str_replace(
				'"image.php',
				'"' . $vbulletin->options['bburl'] . '/image.php',
				$vbulletin->templatecache['imagereg']
			);
	
			eval('$imagereg = "' . fetch_template('imagereg') . '";');
			
			return $imagereg;
		}
	}
}

// ##### Check Human Verification #############################################
function check_human_verify($area, $printerror = true)
{
	global $vbulletin, $vba_options;

	if (IS_VB_37)
	{
		if ($vbulletin->options['hv_type'] AND in_array($area, $vba_options['links_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			$vbulletin->input->clean_gpc('p', 'humanverify', TYPE_ARRAY);

			require_once(DIR . '/includes/class_humanverify.php');
			$verify =& vB_HumanVerify::fetch_library($vbulletin);
			if (!$verify->verify_token($vbulletin->GPC['humanverify']))
			{
				if ($printerror)
				{
					eval(standard_error(fetch_error($verify->fetch_error())));
				}
				else
				{
					return fetch_error($verify->fetch_error());
				}
			}
		}
	}
	else
	{
		if ($vbulletin->options['regimagetype'] AND in_array($area, $vba_options['links_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			global $vbphrase;

			$vbulletin->input->clean_array_gpc('p', array(
				'imagehash' => TYPE_STR,
				'imagestamp' => TYPE_STR
			));

			require_once(DIR . '/includes/functions_regimage.php');
			if (!verify_regimage_hash($vbulletin->GPC['imagehash'], $vbulletin->GPC['imagestamp']))
			{
				eval(standard_error(fetch_error('register_imagecheck')));
	  	}
		}
	}
}

?>