<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);


// ################### Function to Print Categories ########################
function print_categories($cat = 0, $catinfo = '', $subscriptions = false)
{
	global $db, $vbulletin, $vba_links, $vba_options, $vbcollapse, $stylevar, $vbphrase, $show, $stats;

	if ($cat)
	{
		$catinfo = construct_categories($vbulletin->adv_links_cats, $cat);

		$catids = array();
		if (!empty($catinfo))
		{
			foreach ($catinfo AS $cats)
			{
				if ($cats['catid'] != $cat)
				{
					$catids[] = $cats['catid'];
				}
			}
		}

		$catids = implode(',', $catids);

		if (!$catids)
		{
			return;
		}
	}
	else if (!$subscriptions)
	{
		foreach ($vbulletin->adv_links_cats AS $advcatid => $advcat)
		{
			$catinfo[$advcat['catid']] = array('level' => $advcat['level']);
		}
	}

	if ($vba_options['links_catdepth'] > 2)
	{
		$vba_options['links_catdepth'] = 2;
	}

	if (!$subscriptions)
	{
		$getcats = $db->query("
			SELECT catid, title, description, parent, parentlist, linkcount, postcount, active, valid, lastlinkid, lastlinktitle, lastlinkusername, lastlinkuserid, lastlinkdateline, lastpostid, lastpostlinkid, lastpostuserid, lastpostusername, lastpostlinktitle, lastpostdateline
			FROM " . TABLE_PREFIX . "adv_links_categories
			" . iif($catids, "WHERE catid IN($catids)") . "
			ORDER BY $vba_options[links_catsorder] $vba_options[links_catsdir], haslinks
		");
		while ($vbacats = $db->fetch_array($getcats))
		{
			$catrowid =& $vbacats['catid'];
			$maincat =& $vbulletin->adv_links_cats[$catrowid];
	
			if ($vbacats['parent'] AND !$vbulletin->adv_links_cats[$vbacats['parent']]['active'])
			{
				$maincat['active'] = 0;
				continue;
			}
	
			$maincat['description'] = $vbacats['description'];
	
			if ($vba_links->check_cat_perms('canviewlinks', $vbacats) OR $vba_options['links_showlinkcount'])
			{
				// Stats for the homepage
				if (!$cat)
				{
					$stats['categories']++;
					$stats['links'] += $vbacats['linkcount'];
					$stats['posts'] += $vbacats['postcount'];
				}
	
				// Last link
				if ($vbacats['lastlinkdateline'] > $catinfo[$catrowid]['lastlinkdateline'])
				{
					$catinfo[$catrowid]['lastlinkdateline'] = $vbacats['lastlinkdateline'];
					$catinfo[$catrowid]['lastlinktitle'] = $vbacats['lastlinktitle'];
					$catinfo[$catrowid]['lastlinkid'] = $vbacats['lastlinkid'];
					$catinfo[$catrowid]['lastlinkusername'] = $vbacats['lastlinkusername'];
					$catinfo[$catrowid]['lastlinkuserid'] = $vbacats['lastlinkuserid'];
				}
	
				// Last post
				if ($vbacats['lastpostdateline'] > $catinfo[$catrowid]['lastpostdateline'])
				{
					$catinfo[$catrowid]['lastpostid'] = $vbacats['lastpostid'];
					$catinfo[$catrowid]['lastpostlinkid'] = $vbacats['lastpostlinkid'];
					$catinfo[$catrowid]['lastpostdateline'] = $vbacats['lastpostdateline'];
					$catinfo[$catrowid]['lastpostlinktitle'] = $vbacats['lastpostlinktitle'];
					$catinfo[$catrowid]['lastpostusername'] = $vbacats['lastpostusername'];
					$catinfo[$catrowid]['lastpostuserid'] = $vbacats['lastpostuserid'];
				}
	
				// Subcats
				if ($catinfo[$catrowid]['level'] == ($vba_options['links_catdepth'] + 1)
					AND $vba_options['links_showsubcats']
					AND $vba_links->check_cat_perms('canviewlinksdir', $vbacats)
					AND $catinfo[$vbacats['parent']]['level']
					AND $vbacats['active']
					AND $vbacats['valid']
				)
				{
					$catinfo[$vbacats['parent']]['subcats'][$catrowid]['catid'] = $vbacats['catid'];
					$catinfo[$vbacats['parent']]['subcats'][$catrowid]['title'] = $vbacats['title'];
					$catinfo[$vbacats['parent']]['subcats'][$catrowid]['lastlinkdateline'] = $vbacats['lastlinkdateline'];
					$catinfo[$vbacats['parent']]['subcats'][$catrowid]['lastpostdateline'] = $vbacats['lastpostdateline'];
				}
	
				// Figure out the link/post counts & last link/post stuff
				if ($vbacats['parentlist'])
				{
					foreach (explode(',', $vbacats['parentlist']) AS $parid)
					{
						if ($catinfo[$parid]['level'])
						{
							$catinfo[$parid]['linkcount'] += $vbacats['linkcount'];
							$catinfo[$parid]['postcount'] += $vbacats['postcount'];
	
							if ($vbacats['lastlinkdateline'] > $catinfo[$parid]['lastlinkdateline'])
							{
								$catinfo[$parid]['lastlinkdateline'] = $vbacats['lastlinkdateline'];
								$catinfo[$parid]['lastlinktitle'] = $vbacats['lastlinktitle'];
								$catinfo[$parid]['lastlinkid'] = $vbacats['lastlinkid'];
								$catinfo[$parid]['lastlinkusername'] = $vbacats['lastlinkusername'];
								$catinfo[$parid]['lastlinkuserid'] = $vbacats['lastlinkuserid'];
							}
	
							if ($vbacats['lastpostdateline'] > $catinfo[$parid]['lastpostdateline'])
							{
								$catinfo[$parid]['lastpostid'] = $vbacats['lastpostid'];
								$catinfo[$parid]['lastpostlinkid'] = $vbacats['lastpostlinkid'];
								$catinfo[$parid]['lastpostdateline'] = $vbacats['lastpostdateline'];
								$catinfo[$parid]['lastpostlinktitle'] = $vbacats['lastpostlinktitle'];
								$catinfo[$parid]['lastpostusername'] = $vbacats['lastpostusername'];
								$catinfo[$parid]['lastpostuserid'] = $vbacats['lastpostuserid'];
							}
						}
					}
				}
				else
				{
					$catinfo[$catrowid]['linkcount'] += $vbacats['linkcount'];
					$catinfo[$catrowid]['postcount'] += $vbacats['postcount'];
				}
			}
		}
	}

	$subcatcolsize = 0;
	if ($vba_options['links_showsubcats'] > 1)
	{
		$subcatcolsize = floor(100 / $vba_options['links_showsubcats']);
	}

	if (!empty($catinfo))
	{
		$vbulletin->templatecache['forumhome_moderator'] = str_replace('"member.php', '"' . $vbulletin->options['bburl'] . '/member.php', $vbulletin->templatecache['forumhome_moderator']);

		foreach ($catinfo AS $cinfoid => $catquery)
		{
			if ($subscriptions)
			{
				$cats =& $catquery;
			}
			else
			{
				$cats =& $vbulletin->adv_links_cats[$cinfoid];
			}

			// Check permissions
			if (!$vba_links->check_cat_perms('canviewlinksdir', $cats) OR !$cats['active'] OR !$cats['valid'] OR $catquery['level'] > 2 OR $catquery['level'] > $vba_options['links_catdepth'])
			{
				continue;
			}

			$catcount++;

			if (!$cats['haslinks'])
			{
				$catcollapse = $vbcollapse['collapseobj_catbit_' . $cats['catid']];
				$catimgcollapse = $vbcollapse['collapseimg_catbit_' . $cats['catid']];

				eval('$categorybits .= "' . fetch_template('adv_links_categorybit_main') . '";');
			}
			else
			{
				// Sub categories
				$subcatbits = '';
				$subcatcomma = '';
				$subcatsperrow = '';
				$subcatrowcount = '';
				$firstsubcat = true;
				if (!empty($catquery['subcats']))
				{
					foreach ($catquery['subcats'] AS $subcatid => $subcats)
					{
						// Put them into columns if necessary
						if ($vba_options['links_showsubcats'] > 1)
						{
							if (!$subcatbits)
							{
								$subcatsperrow = ceil(sizeof($catquery['subcats']) / $vba_options['links_showsubcats']);
								$subcatbits = '<table width="100%" cellspacing="0" cellpadding="1"><tr><td width="' . $subcatcolsize . '%" valign="top">';
							}

							if ($subcatrowcount == $subcatsperrow)
							{
								$subcatbits .= '</td><td width="' . $subcatcolsize . '%" valign="top">';
								$subcatrowcount = 0;
							}

							$subcatrowcount++;
						}

						// On/off indicators
						if ($vba_options['links_showonoff'])
						{
							$subonoff = ($subcats['lastlinkdateline'] > $vbulletin->userinfo['lastvisit'] OR $subcats['lastpostdateline'] > $vbulletin->userinfo['lastvisit']) ? 'new' : 'old';
						}

						eval('$subcatbits .= "$subcatcomma' . fetch_template('adv_links_categorybit_subcat') . '";');

						if ($vba_options['links_showsubcats'] < 2)
						{
							$subcatcomma = ', ';
						}
						else if ($subcatrowcount != $subcatsperrow)
						{
							$subcatcomma = '<br />';
						}
						else
						{
							$subcatcomma = '';
						}

						$firstsubcat = false;
					}

					if ($vba_options['links_showsubcats'] > 1)
					{
						$subcatbits .= '</td></tr></table>';
					}
				}

				// Moderators
				if ($show['modcolumn'])
				{
					$cats['moderator'] = fetch_cat_moderators($cats['catid']);
				}

				// Counts
				$cats['linkcount'] = vb_number_format($catquery['linkcount']);
				$cats['postcount'] = vb_number_format($catquery['postcount']);

				// On/off indicators
				if ($vba_options['links_showonoff'])
				{
					if ($vbulletin->userinfo['lastvisit'] < $catquery['lastlinkdateline'] OR $vbulletin->userinfo['lastvisit'] < $catquery['lastpostdateline'])
					{
						$onoff = 'new';
					}
					else
					{
						$onoff = 'old';
					}
				}

				// Last link
				if ($catquery['lastlinkdateline'])
				{
					$cats['lastlinkid'] =& $catquery['lastlinkid'];
					$cats['lastlinkuserid'] =& $catquery['lastlinkuserid'];
					$cats['lastlinkusername'] =& $catquery['lastlinkusername'];

					$cats['lastupdateddate'] = vbdate($vbulletin->options['dateformat'], $catquery['lastlinkdateline']);
					$cats['lastupdatedtime'] = vbdate($vbulletin->options['timeformat'], $catquery['lastlinkdateline']);
					$cats['lastlinktitle'] = fetch_trimmed_title($catquery['lastlinktitle'], $vba_options['links_lastlink_maxlength']);
				}

				// Last post
				if ($catquery['lastpostdateline'])
				{
					$cats['lastpostid'] =& $catquery['lastpostid'];
					$cats['lastpostlinkid'] =& $catquery['lastpostlinkid'];
					$cats['lastpostdateline'] =& $catquery['lastpostdateline'];
					$cats['lastpostlinkid'] =& $catquery['lastpostlinkid'];
					$cats['lastpostuserid'] =& $catquery['lastpostuserid'];
					$cats['lastpostusername'] =& $catquery['lastpostusername'];

					$cats['lastpostlinktitle'] = fetch_trimmed_title($catquery['lastpostlinktitle'], $vba_options['links_lastlink_maxlength']);
					$cats['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $catquery['lastpostdateline']);
					$cats['lastposttime'] = vbdate($vbulletin->options['timeformat'], $catquery['lastpostdateline']);
				}

				if ($catquery['level'] == 0)
				{
					$catquery['level'] = 1;
				}

				eval('$categorybits .= "' . fetch_template('adv_links_categorybit_level' . $catquery['level']) . '";');
			}
		}
		unset($catinfo, $cats);
	}

	return $categorybits;
}

// ##### Fetch Category Moderators ############################################
function fetch_cat_moderators($catid)
{
	global $vbulletin, $vba_options;

	if (!empty($vbulletin->adv_links_mods[$catid]))
	{
		foreach ($vbulletin->adv_links_mods[$catid] AS $moduserid => $modusername)
		{
			$moderator = array(
				'userid' => $moduserid,
				'username' => $modusername
			);
			$moderator['musername'] = fetch_musername($moderator);

			eval('$catmods .= "$comma' . fetch_template('forumhome_moderator') . '";');

			$comma = ', ';
		}
	}

	if ($vbulletin->adv_links_cats[$catid]['catuserid'] AND $vba_options['links_usercats_modopts'])
	{
		$moderator['userid'] =& $vbulletin->adv_links_cats[$catid]['catuserid'];
		$moderator['username'] =& $vbulletin->adv_links_cats[$catid]['username'];
		$moderator['musername'] = fetch_musername($moderator);

		eval('$catmods .= "$comma' . fetch_template('forumhome_moderator') . '";');
	}

	return $catmods;
}

// ############################## Update Category Cache #######################
function update_category_cache()
{
	global $db, $vba_options, $vbulletin;

	$catsinfo = array();
	$catpermissions = array();

	$permissions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_permissions");
	while ($permission = $vbulletin->db->fetch_array($permissions))
	{
		$catpermissions[$permission['catid']][$permission['usergroupid']] = $permission['permissions'];
	}

	$db->free_result($permissions);
	unset($permission);

	$getcats = $db->query_read("
		SELECT catid, title, allowusercats, catuserid, parent, parentlist, haslinks, categories.password, active, valid, categories.options, recipoptions, useroptions, username
		FROM " . TABLE_PREFIX . "adv_links_categories AS categories
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
		ORDER BY $vba_options[links_catsorder] $vba_options[links_catsdir], haslinks
	");
	while ($cats = $vbulletin->db->fetch_array($getcats))
	{
		$catsinfo[$cats['catid']] = $cats;
	}

	$db->free_result($getcats);
	unset($cats);

	$catperms = construct_category_perms($catsinfo, 0, $catpermissions);

	$categoryinfo = array();

	if ($catinfo = construct_categories($catsinfo, 0, -1))
	{
		foreach ($catinfo AS $cats)
		{
			// Find any parent passwords and add them to save processing later
			if (cat_opt('canhavepassword', $cats['catid']) AND !$cats['password'])
			{
				$parentlist = explode(',', $cats['parentlist']);

				if (!empty($parentlist))
				{
					foreach ($parentlist AS $pcatid)
					{
						if ($catsinfo[$pcatid]['password'] AND cat_opt('childpass', $pcatid))
						{
							$cats['parentpass'] = $pcatid;
						}
					}
				}
			}

			$categoryinfo[$cats['catid']] = $cats;
			if ($catperms[$cats['catid']])
			{
				$categoryinfo[$cats['catid']]['permissions'] = $catperms[$cats['catid']];
			}
		}
	}

	$db->free_result($getcats);
	build_datastore('adv_links_cats', serialize($categoryinfo), 1);
}

// ####################### Construct Private Directories #######################
function fetch_private_categories($implode = true, $permvar = 'canviewlinks')
{
	global $vbulletin, $vba_links;

	$privcatids = array();
	foreach ($vbulletin->adv_links_cats AS $catid => $cats)
	{
		if (!$vba_links->check_cat_perms($permvar, $cats) OR !check_category_password($catid, false) OR (!is_category_mod($catid) AND !$cats['valid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid']))
		{
			$privcatids[] = $catid;
		}
	}

	if ($implode)
	{
		$privcatids = implode(',', array_unique($privcatids));
	}

	return $privcatids;
}

// ##### Fetch Allowed Parents ################################################
/*
 * This function allows us to see which parent categories should be visible
 * since it is possible for a user to own a category which is a sub-cat of
 * a category they do not have permissions for.
*/
function fetch_allowed_parents()
{
	global $vbulletin;

	$allowedparents = array();

	if (!empty($vbulletin->adv_links_cats))
	{
		foreach ($vbulletin->adv_links_cats AS $cats)
		{
			if ($cats['catuserid'] == $vbulletin->userinfo['userid'])
			{
				$plist = explode(',', $cats['parentlist']);
				if (!empty($plist))
				{
					foreach ($plist AS $parentid)
					{
						if ($vbulletin->adv_links_cats[$parentid]['valid'])
						{
							$allowedparents[] = $parentid;
						}
					}
				}
			}
		}
	}

	return array_unique($allowedparents);
}

// ####################### Insert Parentlist ###########################
function insert_category_parentlist($parentid)
{
	global $db, $newcatid, $vbulletin;

	if ($parentid)
	{
		$cat = $db->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $parentid");
	}

	$plist = $newcatid;

	if ($cat['parentlist'])
	{
		$plist .= ",$cat[parentlist]";
	}
	else if ($parentid)
	{
		$plist .= ",$parentid";
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET parentlist = '$plist' WHERE catid = $newcatid");
}

// ###################### Function to Construct Categories #####################
function construct_category_perms($catinfo, $cat = 0, $catpermissions)
{
	global $catperms;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$catperms[$cats['catid']] = $catpermissions[$cats['catid']];

				if (!empty($catperms[$cats['parent']]) AND empty($catperms[$cats['catid']]))
				{
					$catperms[$cats['catid']] = $catperms[$cats['parent']];
				}

				construct_category_perms($catinfo, $cats['catid'], $catpermissions);
			}
		}
	}
	return $catperms;
}

// ######################## Rebuild Parents ############
function rebuild_parents($catid = 0, $echooutput = false)
{
	global $db, $parentlist;

	$cats = array();

	$getcats = $db->query_read("SELECT catid, title, parent FROM " . TABLE_PREFIX . "adv_links_categories ORDER BY parent");
	while ($catinfo = $db->fetch_array($getcats))
	{
		$cats[$catinfo['catid']] = $catinfo;
	}

	$db->free_result($getcats);
	unset($catinfo);

	if ($catid)
	{
		$buildcats = fetch_category_children($catid);
	}
	else
	{
		$buildcats = array_keys($cats);
	}

	foreach ($buildcats AS $catids)
	{
		$cat =& $cats[$catids];

		$parentlist = array();
		$parentlist[] = $cat['catid'];
		construct_parents($cats, $cat['parent']);

		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET parentlist = '" . implode(',', $parentlist) . "' WHERE catid = '$cat[catid]'");

		if ($echooutput)
		{
			echo "Updated $cat[title]<br />";
		}
	}
}


// ########################### Find Parent Directories ########################
function construct_parents($catinfo, $catid)
{
	global $parentlist;

	foreach ($catinfo AS $subs)
	{
		if ($subs['catid'] == $catid)
		{
			$parentlist[] = $subs['catid'];
			construct_parents($catinfo, $subs['parent']);
		}
	}
	return $parentlist;

}

// #################### Construct Linkbit ######################
function construct_linkbits(&$link)
{
	global $vbulletin, $vba_options, $stylevar, $bbcode_parser, $vba_links, $vbphrase, $returnto, $show, $adv_sorturl, $catid, $highlight;

	// Folder - keep above number_format($link['views'])
	$link['folder'] = 'thread';

	if (!$link['open'])
	{
		$link['folder'] = 'thread_lock';
	}
	else if (($vbulletin->userinfo['lastvisit'] < $link['dateline'] OR $vbulletin->userinfo['lastvisit'] < $link['lastpostdateline']) AND ($link['views'] >= $vba_options['links_hotviews'] OR $links['posts'] >= $vba_options['links_hotposts']) AND ($vba_options['links_hotviews'] OR $vba_options['links_hotposts']))
	{
		$link['folder'] = 'thread_hot_new';
	}
	else if (($vbulletin->userinfo['lastvisit'] < $link['dateline'] OR $vbulletin->userinfo['lastvisit'] < $link['lastpostdateline']) AND $link['views'] < $vba_options['links_hotviews'])
	{
		$link['folder'] = 'thread_new';
	}
	else if (($link['views'] >= $vba_options['links_hotviews'] OR $link['posts'] >= $vba_options['links_hotposts']) AND ($vba_options['links_hotviews'] OR $vba_options['links_hotposts']))
	{
		$link['folder'] = 'thread_hot';
	}

	// Parse it
	$link['description'] = fetch_trimmed_title($link['description'], $vba_options['links_desclength_browse']);
	$link['replies'] = vb_number_format($link['posts']);
	$link['views'] = vb_number_format($link['views']);
	$link['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $link['lastpostdateline']);
	$link['lastposttime'] = vbdate($vbulletin->options['timeformat'], $link['lastpostdateline']);
	$link['updatedate'] = vbdate($vbulletin->options['dateformat'], $link['dateline']);
	$link['updatetime'] = vbdate($vbulletin->options['timeformat'], $link['dateline']);

	$link['description'] = $bbcode_parser->do_parse(
		$link['description'],
		cat_opt('allow_desc_html', $link['catid']),
		cat_opt('allow_desc_smilies', $link['catid']),
		cat_opt('allow_desc_bbcode', $link['catid']),
		cat_opt('allow_desc_bbimgcode', $link['catid'])
	);

	if ($show['categoryhead'])
	{
		$link['category'] = $vbulletin->adv_links_cats[$link['catid']]['title'];
	}

	$show['nofollow'] = false;
	if (cat_opt('nofollow', $link['catid']))
	{
		$show['nofollow'] = true;
	}

	if (!$vba_links->check_cat_perms('canviewreplies', $link) OR !$vba_options['links_allowreplies'] OR !$link['lastpostdateline'])
	{
		$show['replies'] = false;
		$link['replies'] = 0;
	}
	else
	{
		$show['replies'] = true;
	}

	if ($vba_options['links_allowreplies'] AND $vba_links->check_cat_perms('canreply', $link) AND cat_user_opt('allow_reply', $link['catid']))
	{
		$show['replylink'] = true;
	}

	if ($vba_options['links_allowrating'] AND $vba_links->check_cat_perms('canrate', $link) AND cat_user_opt('allow_ratings', $link['catid']) AND cat_opt('allow_ratings', $link['catid']))
	{
		$show['ratelink'] = true;
	}

	if ($vba_links->check_cat_perms('cansendtofriend', $link))
	{
		$show['sendtofriend'] = true;
	}

	if ($vba_links->check_cat_perms('canreport', $link))
	{
		$show['report_link'] = true;
	}

	$show['subscribed'] = false;
	if ($link['subid'])
	{
		$show['subscribed'] = true;
	}

	$show['link_rating'] = false;
	if ($vba_options['links_allowrating'] AND $link['votetotal'] AND $link['votenum'])
	{
		$link['truerating'] = vb_number_format($link['votetotal'] / $link['votenum'], 2);
		$link['roundrating'] = round($link['truerating']);
		$show['link_rating'] = true;
	}

	// Highlight keywords
	if ($show['highlight_description'])
	{
		$link['description'] = highlight_keywords($link['description'], $highlight['string'], $highlight['wholeword']);
	}
	if ($show['highlight_name'])
	{
		$link['name'] = highlight_keywords($link['name'], $highlight['string'], $highlight['wholeword']);
	}

	eval('$linkbits = "' . fetch_template('adv_links_linkbit') . '";');
	return $linkbits;
}

// ##### Update Counters (moving) #############################################
/*
 * Function to allow links to be moved and update the category counts
*/
function update_counts_moved($linkid, &$newlink, &$oldlink)
{
	global $vbulletin, $db;

	$upquerynew = '';
	$upqueryold = '';

	$oldcatid = $oldlink['catid'];

	if ($newlink['catid'] == $oldcatid
		AND $newlink['suspended'] == $oldlink['suspended']
		AND $newlink['valid'] == $oldlink['valid']
	)
	{
		return;
	}

	$addquery = "linkcount = linkcount+1, postcount = postcount+$oldlink[posts]";
	$substrquery = "linkcount = linkcount-1, postcount = postcount-$oldlink[posts]";

	// Suspended/valid state changed, so update the cat counters
	if ($oldlink['suspended'] != $newlink['suspended'] OR $oldlink['valid'] != $newlink['valid'])
	{
		// The link is now visible, so add to the counters
		if ($newlink['valid'] AND !$newlink['suspended'])
		{
			// Same cat
			if ($oldcatid == $newlink['catid'])
			{
				$upquerynew .= $addquery;
			}
			// We've moved categories
			else
			{
				// Remove from old
				$upqueryold .= $substrquery;

				// Add to new
				$upquerynew .= $addquery;

			}
		}
		// The link is no longer visible, so subtract
		else
		{
			$upqueryold .= $substrquery;
		}
	}
	// Moving cats, so set the counts here if they haven't been set above
	else if ($oldcatid != $newlink['catid'] AND $oldlink['valid'] AND !$oldlink['suspended'])
	{
		$upquerynew = $addquery;
		$upqueryold = $substrquery;
	}

	if ($oldcatid != $newlink['catid'])
	{
		$catcache = array();
		$catcounts = $db->query_read("SELECT catid, lastlinkid, lastlinkdateline, lastpostid, lastpostdateline FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid IN($newlink[catid], $oldcatid)");
		while ($cats = $db->fetch_array($catcounts))
		{
			$catcache[$cats['catid']] = $cats;
		}

		// Last link for new cat
		if ($catcache[$newlink['catid']]['lastlinkdateline'] < $oldlink['dateline'])
		{
			$upquerynew .= iif($upquerynew, ',') . "
				lastlinkid = $linkid,
				lastlinktitle = '" . $db->escape_string($oldlink['name']) . "',
				lastlinkuserid = '$oldlink[userid]',
				lastlinkusername = '" . $db->escape_string($oldlink['username']) . "',
				lastlinkdateline = '$oldlink[dateline]'
			";
		}

		// Last post for new cat
		if ($catcache[$cats['catid']]['lastpostdateline'] < $oldlink['lastpostdateline'])
		{
			$upquerynew .= iif($upquerynew, ',') . "
				lastpostid = '$oldlink[lastpostid]',
				lastpostlinktitle = '" . $db->escape_string($oldlink['name']) . "',
				lastpostuserid = '$oldlink[lastpostuserid]',
				lastpostusername = '" . $db->escape_string($oldlink['lastpostusername']) . "',
				lastpostdateline = '$oldlink[lastpostdateline]'
			";
		}

		if ($catcache[$oldcatid]['lastlinkid'] == $linkid)
		{
			$lastlink = $db->query_first("SELECT linkid, name, dateline, userid, username FROM " . TABLE_PREFIX . "adv_links WHERE catid = $oldcatid ORDER BY dateline DESC");

			$upqueryold .= iif($upqueryold, ',') . "
				lastlinkid = '$lastlink[linkid]',
				lastlinktitle = '" . $db->escape_string($lastlink['name']) . "',
				lastlinkuserid = '$lastlink[userid]',
				lastlinkusername = '" . $db->escape_string($lastlink['username']) . "',
				lastlinkdateline = '$lastlink[dateline]'
			";
		}

		if ($catcache[$oldcatid]['lastpostid'] == $oldlink['lastpostid'])
		{
			$lastpost = $db->query_first("
				SELECT postid, post.linkid, name, post.userid, post.username, post.dateline
				FROM " . TABLE_PREFIX . "adv_links_posts AS post
				LEFT JOIN " . TABLE_PREFIX . "adv_links AS links ON (post.linkid = links.linkid)
				WHERE catid = $oldcatid
				ORDER BY post.dateline DESC
			");

			$upqueryold .= iif($upqueryold, ',') . "
				lastpostid = '$lastpost[postid]',
				lastpostlinktitle = '" . $db->escape_string($lastpost['name']) . "',
				lastpostuserid = '$lastpost[userid]',
				lastpostusername = '" . $db->escape_string($lastpost['username']) . "',
				lastpostdateline = '$lastpost[dateline]'
			";
		}
	}

	if ($upquerynew)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET $upquerynew WHERE catid = $newlink[catid]");
	}

	if ($upqueryold)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET $upqueryold WHERE catid = $oldcatid");
	}
}

// ##### Remove Links In Category #############################################
function remove_links_in_cat($catid)
{
	global $db;

	$linkid = array();

	$linkids = $db->query_read("SELECT linkid FROM " . TABLE_PREFIX . "adv_links WHERE catid IN ($catid)");
	while ($links = $db->fetch_array($linkids))
	{
		$linkid[] = $links['linkid'];
	}

	if (!empty($linkid))
	{
		delete_links($linkid);
	}
}

?>