<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Print Moderation Rows ################################################
function print_moderation_rows()
{
	global $vbulletin, $db, $permissions, $vbphrase, $stylevar;

	global $wherequery, $condition, $pageinfo, $show, $checkedemail, $checkedaction, $catquery;
	global $tableheader, $page, $pagecount, $lastitemid, $itemcount, $checkall, $allbox, $type;

	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);

	$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_INT);
	$pagecount = $vbulletin->input->clean_gpc('r', 'pagecount', TYPE_INT);
	$itemcount = $vbulletin->input->clean_gpc('r', 'itemcount', TYPE_INT);
	$lastitemid = $vbulletin->input->clean_gpc('r', 'lastitemid', TYPE_INT);
	$checkall = $vbulletin->input->clean_gpc('r', 'checkall', TYPE_INT);
	$allbox = $vbulletin->input->clean_gpc('r', 'allbox', TYPE_INT);

	if ($type != 'posts' AND $type != 'categories')
	{
		$type = 'links';
	}

	$catquery = '';
	$modcats = array();

	// ##### Find out what categories we moderate
	if (!($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
	{
		if (!empty($vbulletin->adv_links_mods))
		{
			foreach ($vbulletin->adv_links_mods AS $mcat => $mcatinfo)
			{
				if ($mcatinfo[$vbulletin->userinfo['userid']])
				{
					$modcats[] = $mcat;
				}
			}
		}

		if (empty($modcats))
		{
			if (VB_AREA == 'Forum')
			{
				print_no_permission();
			}
			else
			{
				print_stop_message('adv_links_moderators_only');
			}
		}

		$catquery = ' IN(' . implode(',', $modcats) . ')';
	}

	$tableheader = construct_phrase($vbphrase['x_awaiting_moderation'], $vbphrase[$type]);

	if (VB_AREA != 'Forum')
	{
		print_form_header('vba_links', 'domoderate');
		print_table_header(construct_phrase($vbphrase['x_awaiting_moderation'], $vbphrase[$type]));
	}

	$condition = array();
	$wherequery = array();

	switch ($type)
	{
		// ##### Approving links
		case 'links':

			$custominfo = array();
			$cfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields ORDER BY displayorder");
			while ($field = $db->fetch_array($cfields))
			{
				$custominfo[] = $field;
			}
			$db->free_result($cfields);
			unset($field);

			$condition['fromtable'] = 'adv_links AS links';
			$wherequery = array('valid = 0');

			if ($catquery)
			{
				$wherequery[] = 'links.catid' . $catquery;
			}

			if ($lastitemid)
			{
				$wherequery[] = 'linkid > ' . $lastitemid;
			}

		break;

		// ##### Approving posts
		case 'posts':

			$condition['fromtable'] = 'adv_links_posts';
			$wherequery = array('visible = 0');

			if ($catquery)
			{
				$condition['join'] = 'adv_links AS links';
				$wherequery[] = 'links.catid' . $catquery;
			}

			if ($lastitemid)
			{
				$wherequery[] = 'postid > ' . $lastitemid;
			}

		break;

		// ##### Approving categories
		case 'categories':

			$condition['fromtable'] = 'adv_links_categories';
			$wherequery = array('valid = 0');

			if ($catquery)
			{
				$wherequery[] = 'parent' . $catquery;
			}

			if ($lastitemid)
			{
				$wherequery[] = 'catid > ' . $lastitemid;
			}

		break;
	}

	if (!$page)
	{
		$page = 1;
	}

	$perpage = 40;

	$pagedata = fetch_page_data($perpage, iif($page > 1, $itemcount, false));

	$itemcount = $pagedata['count'];
	$pagecount = $pagedata['pagecount'];

	$pageinfo = '';
	if ($itemcount)
	{
		$pageinfo = construct_phrase($vbphrase['page_x_of_y'], $page, $pagedata['pagecount']);

		if (VB_AREA != 'Forum')
		{
			print_description_row(construct_phrase($vbphrase['page_x_of_y'], $page, $pagedata['pagecount']));
		}
	}

	switch ($type)
	{
		case 'links':

			// ##### Get the links
			$getrows = $db->query_read("
				SELECT links.*, user.email, entries.*
				FROM " . TABLE_PREFIX . "adv_links AS links
				LEFT JOIN " . TABLE_PREFIX . "user AS user USING (userid)
				LEFT JOIN " . TABLE_PREFIX . "adv_links_cfields_entries AS entries ON (links.linkid = entries.lid)
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY linkid
				LIMIT $perpage
			");
		 break;

		// ##### Get the posts
		case 'posts':

			$getrows = $db->query_read("
				SELECT posts.*, links.catid, links.name, linkurl
				FROM " . TABLE_PREFIX . "adv_links_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "adv_links AS links ON (posts.linkid = links.linkid)
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY dateline
				LIMIT $perpage
			");

		break;

		// ##### Get the categories
		case 'categories':

		$getrows = $db->query_read("
			SELECT catid, title, description, parent, parentlist, catuserid, username
			FROM " . TABLE_PREFIX . "adv_links_categories AS categories
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
			WHERE " . implode(' AND ', $wherequery) . "
			ORDER BY catid DESC
			LIMIT $perpage
		");

		break;

	}

	if ($db->num_rows($getrows))
	{
		$show['validate'] = true;

		// Checkboxes
		if ($page == 1 OR $allbox)
		{
			$checkedemail = 'checked="checked"';
		}
		if ($page == 1)
		{
			$checkedaction['1'] = 'checked="checked"';
		}
		else
		{
			$checkedaction[$checkall] = 'checked="checked"';
		}

		if (VB_AREA != 'Forum')
		{
			construct_hidden_code('page', $page);
			construct_hidden_code('itemcount', $itemcount);
			construct_hidden_code('pagecount', $pagecount);
			construct_hidden_code('type', $type);

			// Check all buttons
			print_description_row('
				' . iif($type == 'links', '<div style="float:' . $stylevar['right'] . '">
				<label for="sendmailcheck">' . $vbphrase['send_email'] . ' <input ' . $checkedemail . ' id="sendmailcheck" name="allbox" onclick="js_check_all(this.form);" type="checkbox" value="1" /></label>
				</div>') . '
				<label for="checkall1"><input ' . $checkedaction['1'] . ' id="checkall1" name="checkall" onclick="js_check_all_option(this.form, \'1\');" type="radio" value="1" /> ' . $vbphrase[validate_all] . '</label>
				<label for="checkall2"><input ' . $checkedaction['2'] . ' id="checkall2" name="checkall" onclick="js_check_all_option(this.form, \'2\');" type="radio" value="2" /> ' . $vbphrase['delete_all'] . '</label>
				<label for="checkall0"><input ' . $checkedaction['0'] . ' id="checkall0" name="checkall" onclick="js_check_all_option(this.form, 0);" type="radio" value="0" /> ' . $vbphrase['ignore_all'] . '</label>', '', '', 'thead', 'center');
			print_table_break();
		}

		// Actions row
		$action_sprint = iif($type == 'links', '<div style="float:' . $stylevar['right'] . '">
			<label for="sendmail_%1$d">' . $vbphrase['send_email'] . ' <input ' . $checkedemail . ' id="sendmail_%1$d" name="sendmail[%1$d]" type="checkbox" value="1" /></label></div>')
			 . '<label for="val_%1$d">
				<input ' . $checkedaction['1'] . ' id="val_%1$d" name="%2$s[%1$d]" type="radio" value="1" />' . $vbphrase['validate'] . '</label>
			<label for="del_%1$d">
				<input ' . $checkedaction['2'] . ' id="del_%1$d" name="%2$s[%1$d]" type="radio" value="2" />' . $vbphrase['delete'] . '</label>
			<label for="ign_%1$d">
				<input ' . $checkedaction['0'] . ' id="ign_%1$d" name="%2$s[%1$d]" type="radio" value="0" />' . $vbphrase['ignore'] . '</label>';

		// ##### Print out the rows depending on which section we're dealing with
		switch ($type)
		{
			// ##### Links
			case 'links':

				while ($link = $db->fetch_array($getrows))
				{
					$rowactions = sprintf($action_sprint, $link['linkid'], 'validatelink');

					if (VB_AREA == 'Forum')
					{
						$link['dateadded'] = vbdate($vbulletin->options['dateformat'], $link['dateline']);
						$link['timeadded'] = vbdate($vbulletin->options['timeformat'], $link['dateline']);
						$link['description'] = htmlspecialchars($link['description']);
						$catoptions = print_cat_select($link['catid'], 'submitlink');
						$customfieldbits = construct_custom_fieldbits($link, $custominfo, true, false, true);

						eval('$moderationbits .= "' . fetch_template('adv_links_moderate_linkbits') . '";');
					}
					else
					{
						print_table_header('<span style="float:' . $stylevar['right'] . '">(' . iif($link['userid'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $link['userid'] . '" target="_blank">' . $link['username'] . '</a>', $vbphrase['unregistered']) . ') &nbsp; ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $link['dateline']) . '</span>' . $link['name'], 2, 0, '', 'left');
						construct_hidden_code('link[' . $link['linkid'] . '][email]', $link['email']);
						construct_hidden_code('link[' . $link['linkid'] . '][dateline]', $link['dateline']);
						construct_hidden_code('link[' . $link['linkid'] . '][username]', $link['username']);
						construct_hidden_code('link[' . $link['linkid'] . '][userid]', $link['userid']);

						print_input_row($vbphrase['title'], 'link[' . $link['linkid'] . '][name]', $link['name'], false);
						print_input_row('' . $vbphrase['url'] . ' <font size="1">[<a href="' . $link['linkurl'] . '" target="_blank">' . $vbphrase['view_site'] . '</a>]</font>', 'link[' . $link['linkid'] . '][linkurl]', $link['linkurl'], false);
						print_textarea_row($vbphrase['description'], 'link[' . $link['linkid'] . '][description]', $link['description'], 4, 36, false);
						print_category_select('link[' . $link['linkid'] . '][catid]', $vbphrase['category'], $link['catid'], $vbphrase['please_choose_a_category']);
						print_input_row($vbphrase['keywords'], 'link[' . $link['linkid'] . '][keywords]', $link['keywords'], false);
						print_input_row($vbphrase['views'], 'link[' . $link['linkid'] . '][views]', $link['views']);
						print_input_row($vbphrase['link_notes'], 'link[' . $link['linkid'] . '][notes]', $link['notes'], false);

						construct_custom_fieldbits($link, $custominfo, true, true, true);

						print_label_row($vbphrase['action'], $rowactions, 'thead');

						print_table_break();
					}

					$lastitemid = $link['linkid'];
				}
			break;

			// ##### Posts
			case 'posts':

				while ($post = $db->fetch_array($getrows))
				{
					$rowactions = sprintf($action_sprint, $post['postid'], 'validatepost');

					if (VB_AREA == 'Forum')
					{
						$post['dateadded'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
						$post['timeadded'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
						$post['pagetext'] = htmlspecialchars($post['pagetext']);

						eval('$moderationbits .= "' . fetch_template('adv_links_moderate_postbits') . '";');
					}
					else
					{
						print_table_header('<span style="float:' . $stylevar['right'] . '">(' . iif($post['userid'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $post['userid'] . '" target="_blank">' . $post['username'] . '</a>', $vbphrase['unregistered']) . ') &nbsp; ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $post['dateline']) . '</span><a href="' . $post['linkurl'] . '" target="_blank">' . $post['name'] . '</a>', 2, 0, '', 'left');
						construct_hidden_code('post[' . $post['postid'] . '][linkid]', $post['linkid']);
						construct_hidden_code('post[' . $post['postid'] . '][catid]', $post['catid']);
						construct_hidden_code('post[' . $post['postid'] . '][userid]', $post['userid']);
						construct_hidden_code('post[' . $post['postid'] . '][username]', $post['username']);
						construct_hidden_code('post[' . $post['postid'] . '][dateline]', $post['dateline']);
						construct_hidden_code('post[' . $post['postid'] . '][linkname]', $post['name']);

						print_input_row($vbphrase['title'], 'post[' . $post['postid'] . '][title]', $post['title'], false);
						print_textarea_row($vbphrase['message'], 'post[' . $post['postid'] . '][message]', $post['pagetext'], 4, 36);

						print_label_row($vbphrase['action'], $rowactions, 'thead');

						print_table_break();
					}

					$lastitemid = $post['postid'];
				}

			break;

			// ##### Categoires
			case 'categories':

				while ($cat = $db->fetch_array($getrows))
				{
					$rowactions = sprintf($action_sprint, $cat['catid'], 'validatecat');

					if (VB_AREA == 'Forum')
					{
						eval('$moderationbits .= "' . fetch_template('adv_links_moderate_catbits') . '";');
					}
					else
					{
						print_table_header('<span style="float:' . $stylevar['right'] . '">(' . iif($cat['catuserid'], '<a href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $cat['catuserid'] . '" target="_blank">' . $cat['username'] . '</a>') . ')</span>' . $cat['title'], 2, 0, '', 'left');

						print_input_row($vbphrase['title'], 'cats[' . $cat['catid'] . '][title]', $cat['title']);
						print_textarea_row($vbphrase['description'], 'cats[' . $cat['catid'] . '][description]', $cat['description'], 4, 36);

						print_label_row($vbphrase['action'], sprintf($rowactions, $cat['catid'], 'validatecat'), 'thead');
						print_table_break();
					}

					$lastitemid = $cat['catid'];
				}

			break;
		}

		if (VB_AREA != 'Forum')
		{
			construct_hidden_code('lastitemid', $lastitemid);
			print_submit_row();
		}
	}
	else if (VB_AREA != 'Forum')
	{
		print_description_row('<b>' . construct_phrase($vbphrase['no_x_awaiting_moderation'], $vbphrase[$action]) . '</b>', '', '', '', 'center');
		print_table_footer();
	}



	return $moderationbits;
}

// ##### Function to Validate New Links #######################################
function validate_new_links($linkinfo)
{
	global $vbulletin, $db, $vba_options, $post;

	$validatelink = $_POST['validatelink'];

	$checklinks = array_map('intval', array_keys($validatelink));

	$sendmail = $vbulletin->input->clean_gpc('p', 'sendmail', TYPE_ARRAY);

	$noupdate = array();
	if (!empty($checklinks))
	{
		$chklinks = $db->query_read("
			SELECT linkid, valid, suspended
			FROM " . TABLE_PREFIX . "adv_links
			WHERE linkid IN(" . implode(',', $checklinks) . ")
				AND (valid = 1 OR suspended = 1)
		");
		while ($chklink = $db->fetch_array($chklinks))
		{
			$noupdate[$chklink['linkid']] = 1;
		}
	}

	$deletelinks = array();
	$updatecats = array();

	if (is_array($validatelink) AND !empty($validatelink))
	{
		foreach ($validatelink AS $linkid => $action)
		{
			if (!$action)
			{
				continue;
			}

			$link =& $linkinfo[$linkid];

			$link['name'] = htmlspecialchars($link['name']);
			$link['description'] = htmlspecialchars($link['description']);
			$link['linkurl'] = htmlspecialchars($link['linkurl']);
			$link['keywords'] = htmlspecialchars($link['keywords']);
			$link['catid'] = intval($link['catid']);
			$link['views'] = intval($link['views']);

			switch($action)
			{
				case 2:
					$deletelinks[] = $linkid;

					if ($sendmail[$linkid] AND !empty($link['email']))
					{
						eval(fetch_email_phrases('adv_links_deletion', 0));

						vbmail($link['email'], $subject, $message);
					}
				break;

				case 1:

					if ($sendmail[$linkid] AND !empty($link['email']))
					{
						eval(fetch_email_phrases('adv_links_validation', 0));

						vbmail($link['email'], $subject, $message);

					}

					if (!$noupdate[$linkid])
					{
						$updatecats[$link['catid']]['linkcount']++;

						if ($link['dateline'] > $updatecats[$link['catid']]['lastlinkdateline'])
						{
							$updatecats[$link['catid']]['lastlinkid'] = $linkid;
							$updatecats[$link['catid']]['lastlinkusername'] = $link['username'];
							$updatecats[$link['catid']]['lastlinkuserid'] = $link['userid'];
							$updatecats[$link['catid']]['lastlinkdateline'] = $link['dateline'];
							$updatecats[$link['catid']]['lastlinktitle'] = $link['name'];
						}
					}


				default:

					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_links SET
							name = '" . $db->escape_string($link['name']) . "',
							description = '" . $db->escape_string($link['description']) . "',
							linkurl = '" . $db->escape_string($link['linkurl']) . "',
							keywords = '" . $db->escape_string($link['keywords']) . "',
							views = $link[views],
							catid = $link[catid],
							notes = '" . $db->escape_string($link['notes']) . "',
							valid = " . iif($action == 1, 1, 0) . "
						WHERE linkid = $linkid
					");

					construct_customfields_sql($linkid, false, true);
			}
		}

		if (!empty($updatecats))
		{
			$curdateline = array();
			$getcurcats = $db->query_read("
				SELECT catid, lastlinkdateline
				FROM " . TABLE_PREFIX . "adv_links_categories
				WHERE catid IN(" . implode(',', array_keys($updatecats)) . ")
			");
			while ($ccat = $db->fetch_array($getcurcats))
			{
				$curdateline[$ccat['catid']] = $ccat['lastlinkdateline'];
			}

			foreach ($updatecats AS $ucatid => $ucat)
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_links_categories SET
						linkcount = linkcount+$ucat[linkcount] " .

						iif($ucat['lastlinkdateline'] > $curdateline[$ucatid], ",
							lastlinkid = $ucat[lastlinkid],
							lastlinkusername = '" . $db->escape_string($ucat['lastlinkusername']) . "',
							lastlinktitle = '" . $db->escape_string($ucat['lastlinktitle']) . "',
							lastlinkuserid = $ucat[lastlinkuserid],
							lastlinkdateline = $ucat[lastlinkdateline]")
						. "
					WHERE catid = '$ucatid'
				");
			}

		}

		if (!empty($deletelinks))
		{
			delete_links($deletelinks);
		}
	}
}

// ##### Validate New Posts ###################################################
function validate_new_posts($postinfo)
{
	global $db, $vba_options, $_POST;

	$validatepost = $_POST['validatepost'];

	if (is_array($validatepost))
	{
		foreach ($validatepost AS $postid => $action)
		{
			if ($action == 2)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_posts WHERE postid = $postid");
			}
			else
			{
				$post = $postinfo[$postid];

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_links_posts SET
						title = '" . $db->escape_string(htmlspecialchars($post['title'])) . "',
						pagetext = '" . $db->escape_string($post['message']) . "',
						visible = " . intval($action) . "
					WHERE postid = $postid
				");

				if ($action == 1)
				{
					// Update link info
					$link = $db->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "adv_links WHERE linkid = $post[linkid]");

					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_links SET
							posts = posts+1 " .
								iif($link['lastpostdateline'] < $post['dateline'], ",
									lastpostuserid = $post[userid],
									lastpostusername = '" . $db->escape_string($post['username']) . "',
									lastpostdateline = $post[dateline]
								") . "
						WHERE linkid = $post[linkid]
					");

					// Send email to subscribed users
					send_subscribed_posts($post['linkid'], true, $post['userid'], $post['username'], $post['message']);

					// Update category info
					$cat = $db->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = '$post[catid]'");

					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_links_categories
							SET postcount = postcount+1 " .
								iif($cat['lastpostdateline'] < $post['dateline'], ",
									lastpostid = $postid,
									lastpostuserid = $post[userid],
									lastpostusername = '" . $db->escape_string($post['username']) . "',
									lastpostdateline = $post[dateline],
									lastpostlinktitle = '" . $db->escape_string($post['linkname']) . "'
								") . "
						 WHERE catid = $post[catid]");

					// Update user post counts
					if ($vba_options['links_update_postcount'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid = $post[userid]");
					}
				}
			}
		}
	}
}

// ##### Validate New Categories ##############################################
function validate_new_categories($catinfo)
{
	global $db, $vba_options, $_POST;

	$validatecat = $_POST['validatecat'];

	if (is_array($validatecat))
	{
		foreach ($validatecat AS $catid => $action)
		{
			if ($action == 2)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $catid");
			}
			else
			{
				$cat = $catinfo[$catid];

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_links_categories SET
						title = '" . $db->escape_string(htmlspecialchars($cat['title'])) . "',
						description = '" . $db->escape_string($cat['description']) . "',
						valid = " . intval($action) . "
					WHERE catid = $catid
				");
			}
		}
	}
}

?>