<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'links_addlink');

$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();

$actiontemplates = array(
	'addlink' => array(
		'ADV_LINKS_ADD_EDIT',
		'ADV_LINKS_ADD_START',
		'adv_links_addlink_custombits',
		'humanverify',
		'imagereg',
		'newpost_errormessage',
		'newpost_preview',
	),
	'doaddlink' => array(
		'ADV_LINKS_ADD_EDIT',
		'humanverify',
		'imagereg',
		'adv_links_addlink_custombits',
		'newpost_errormessage',
		'newpost_preview'
	),
	'editlink' => array(
		'ADV_LINKS_ADD_EDIT',
		'adv_links_deletebit',
		'adv_links_select',
		'adv_links_addlink_custombits'
	),
	'doeditlink' => array(
		'ADV_LINKS_ADD_EDIT',
		'adv_links_deletebit',
		'adv_links_select',
		'adv_links_addlink_custombits',
		'newpost_errormessage',
		'newpost_preview'
	),
	'newlink' => array(
		'ADV_LINKS_ADD_START',
		'adv_links_select'
	),

);

$actiontemplates['none'] =& $actiontemplates['newlink'];

require_once('./links_global.php');
require_once(DIR . '/includes/functions_vba_links_cats.php');
require_once(DIR . '/includes/functions_vba_links_savelink.php');

if (!isset($_REQUEST['do']))
{
	$_REQUEST['do'] = 'newlink';
}

// ############################### Do Add Link ################################
if ($_POST['do'] == 'doaddlink')
{
	$errors = array();

	$link = $vbulletin->input->clean_gpc('p', 'link', TYPE_ARRAY);
	$linkoptions = $vbulletin->input->clean_gpc('p', 'linkoptions', TYPE_ARRAY);

	$link['name'] = htmlspecialchars($link['name']);
	$link['linkurl'] = htmlspecialchars(trim($link['linkurl']));
	$link['catid'] = intval($link['catid']);
	$link['keywords'] = clean_keywords($link['keywords']);
	$link['linkrecipurl'] = trim($link['linkrecipurl']);

	$errors = check_link_errors($link);

	$vba_links->check_cat_perms('canaddlinks', $link, true);

	if ($link['catid'] AND !cat_user_opt('allow_newlinks', $link['catid']))
	{
		print_no_permission();
	}

	if ($errors)
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$linkerrors = construct_errors($errors);

		$checked = array();
		if ($linkoptions['subscribe'])
		{
			$checked['subscribe'] = 'checked="checked"';
		}

		if ($linkoptions['favorite'])
		{
			$checked['favorite'] = 'checked="checked"';
		}

		$_POST['do'] = 'addlink';
		$_POST['link']['keywords'] = $link['keywords'];
		$haderrors = true;
	}
	else
	{
		$valid = 0;
		if (!$vba_links->check_cat_perms('moderatelinks', $link))
		{
			$valid = 1;
		}

		$cat = $db->query_first("SELECT title, options, newlinkemail FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = '$link[catid]'");

		$sendmailto = explode(' ', $cat['newlinkemail']);

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "adv_links
				(catid, name, linkurl, description, keywords, linkrecipurl, valid, open, username, userid, dateline, ipaddress)
			VALUES (
				$link[catid],
				'" . $db->escape_string($link['name']) . "',
				'" . $db->escape_string($link['linkurl']) . "',
				'" . $db->escape_string($link['description']) . "',
				'" . $db->escape_string($link['keywords']) . "',
				'" . $db->escape_string($link['linkrecipurl']) . "',
				$valid,
				1,
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				" . $vbulletin->userinfo['userid'] . ",
				" . TIMENOW . ",
				'" . $db->escape_string(IPADDRESS) . "'
		)");

		$newlinkid = $db->insert_id();

		if ($vbulletin->userinfo['userid'])
		{
			if ($linkoptions['favorite'])
			{
				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "adv_links_favorites
						(userid, linkid)
					VALUES (
						" . $vbulletin->userinfo['userid'] . ",
						$newlinkid
				)");
			}

			if ($linkoptions['subscribe'])
			{
				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "adv_links_subscribelink
						(userid, linkid)
					VALUES (
						" . $vbulletin->userinfo['userid'] . ",
						$newlinkid
				)");
			}
		}

		construct_customfields_sql($newlinkid);

		if (!$valid OR $vba_options['links_newlinkemail_all'])
		{
			if ($vba_options['links_newlinkemail'])
			{
				$optmailer = explode(' ', $vba_options['links_newlinkemail']);
				$sendmailto = array_merge($optmailer, $sendmailto);
			}

			if (!empty($sendmailto))
			{
				foreach ($sendmailto AS $email)
				{
					eval(fetch_email_phrases('adv_links_newlink', 0));
					vbmail(trim($email), $subject, $message);
				}
			}
		}

		if (!$valid)
		{
			eval(standard_error(fetch_error('adv_links_submitted', $vbulletin->session->vars['sessionurl_q'], $vba_options['links_title'])));
		}
		else
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_links_categories SET
					linkcount = linkcount+1,
					lastlinkid = $newlinkid,
					lastlinkusername = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
					lastlinktitle = '" . $db->escape_string($link['name']) . "',
					lastlinkuserid = " . $vbulletin->userinfo['userid'] . ",
					lastlinkdateline = " . TIMENOW . "
				WHERE catid = $link[catid]
			");

			$vbulletin->url = 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&l=' . $newlinkid;
			eval(print_standard_redirect('adv_links_addednew'));
		}
	}
}

// ############################### Add a Link ###############################
if ($_POST['do'] == 'addlink')
{
	if (!$haderrors)
	{
		$link = $vbulletin->input->clean_gpc('p', 'link', TYPE_ARRAY);

		$errors = array();

		$link['catid'] = intval($link['catid']);

		$link['linkurl'] = htmlspecialchars($link['linkurl']);

		if (!in_array(substr(trim($link['linkurl']), 0, 6), array('http:/', 'https:', 'ftp://')))
		{
			$link['linkurl'] = 'http://' . $link['linkurl'];
		}

		$errors = check_link_errors($link);
	}

	// Check after the other errors as not having a catid will throw off the permissions
	if (empty($errors))
	{
		$vba_links->check_cat_perms('canaddlinks', $link, true);

		if ($link['catid'] AND !cat_user_opt('allow_newlinks', $link['catid']))
		{
			print_no_permission();
		}
	}

	if (!empty($errors))
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$linkerrors = construct_errors($errors);

		if (!$haderrors)
		{
			$_REQUEST['do'] = 'newlink';
		}
	}

	if ($_REQUEST['do'] != 'newlink')
	{

		if (empty($linkerrors))
		{
			fetch_meta();

			$link['keywords'] = clean_keywords($link['keywords'], true);
		}

		$_POST['catid'] =& $link['catid'];
		$customfieldbits = construct_custom_fieldbits($_POST);

		// Image verification
		$imagereg = fetch_human_verify('addlink');

		$navbits[''] = $vbphrase['submit_a_link'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		eval('print_output("' . fetch_template('ADV_LINKS_ADD_EDIT') . '");');
	}
}


// ##### Do Edit Link #########################################################
if ($_POST['do'] == 'doeditlink')
{
	$errors = array();

	$linkid = $vbulletin->input->clean_gpc('p', 'linkid', TYPE_INT);
	$newlink = $vbulletin->input->clean_gpc('p', 'link', TYPE_ARRAY);

	$vba_links->load_link();
	$link =& $vba_links->_link;

	if (!$vbulletin->userinfo['userid'] OR (($link['userid'] != $vbulletin->userinfo['userid'] AND !$vba_links->check_cat_perms('caneditothers')) OR !$vba_links->check_cat_perms('canedit') OR !$vba_links->check_cat_perms('canaddlinks')) AND !is_category_mod($link['catid']))
	{
		print_no_permission();
	}

	$link['linkrecipurl'] = $newlink['linkrecipurl'];

	$newlink['name'] = htmlspecialchars($newlink['name']);
	$newlink['linkurl'] = htmlspecialchars(trim($newlink['linkurl']));
	$newlink['keywords'] = clean_keywords($newlink['keywords']);
	$newlink['catid'] = intval($newlink['catid']);

	$errors = check_link_errors($newlink);

	if (!empty($errors))
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$linkerrors = construct_errors($errors);

		$_REQUEST['do'] = 'editlink';
		$haderrors = true;
	}
	else
	{
		$newlink['notes'] .= ' ' . $vbphrase['last_updated'] . ' ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], TIMENOW) . ' ' . $vbphrase['by'] . ' ' . $vbulletin->userinfo['username'];

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links SET
				catid = $newlink[catid],
				name = '" . $db->escape_string($newlink['name']) . "',
				linkurl = '" . $db->escape_string($newlink['linkurl']) . "',
				linkrecipurl = '" . $db->escape_string($newlink['linkrecipurl']) . "',
				description = '" . $db->escape_string($newlink['description']) . "',
				keywords = '" . $db->escape_string($newlink['keywords']) . "',
				lastupdated = " . TIMENOW . ",
				notes = '" . $db->escape_string($newlink['notes']) . "'
			WHERE linkid = $linkid
		");

		construct_customfields_sql($linkid, false);

		// Set these for the update_counts_moved() function
		$newlink['valid'] = $link['valid'];
		$newlink['suspended'] = $link['suspended'];

		update_counts_moved($linkid, $newlink, $link);

		$vbulletin->url = 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&l=' . $linkid;
		eval(print_standard_redirect('adv_links_linkedited'));
	}
}

// ############################## Edit Link ################################
if ($_REQUEST['do'] == 'editlink')
{

	$vba_links->load_link(true);

	$link =& $vba_links->_link;

	$iscatmod = is_category_mod($link['catid']);

	if ($vbulletin->userinfo['userid'] == 0 OR (($link['userid'] != $vbulletin->userinfo['userid'] AND !$vba_links->check_cat_perms('caneditothers')) OR !$vba_links->check_cat_perms('canedit')) AND !$iscatmod)
	{
		print_no_permission();
	}

	if ($haderrors AND !empty($newlink))
	{
		foreach ($newlink AS $nlinkvar => $nlinkval)
		{
			$link[$nlinkvar] = $nlinkval;
		}
	}

	if ($iscatmod)
	{
		$show['linknotes'] = true;
	}

	if (($link['userid'] == $vbulletin->userinfo['userid'] AND $vba_links->check_cat_perms('candelete')) OR $vba_links->check_cat_perms('catdeleteothers') OR $iscatmod)
	{
		eval('$deleteoption = "' . fetch_template('adv_links_deletebit') . '";');
	}

	$options = print_cat_select($link['catid'], 'submitlink');

	$customfieldbits = construct_custom_fieldbits($link, '', true);

	$navbits = fetch_cat_navbits($link['catid']);
	$navbits['showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&amp;l=' . $link['linkid']] = $link['name'];
	$navbits[''] = $vbphrase['edit_link'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$show['editlink'] = true;

	eval('print_output("' . fetch_template('ADV_LINKS_ADD_EDIT') . '");');
}

// ##### Submit New Link ######################################################
if ($_REQUEST['do'] == 'newlink')
{
	if (intval($catid))
	{
		$link['catid'] = $catid;
	}

	$options = print_cat_select(intval($link['catid']), 'submitlink');

	if (!$options)
	{
		print_no_permission();
	}

	if ($vba_links->check_perms('cancreatecats') AND $vba_options['links_allow_user_cats'])
	{
		$addcatlink = true;
		$moderatecats = $vba_links->check_perms('moderatecats');
	}

	$navbits[''] = $vbphrase['submit_a_link'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('ADV_LINKS_ADD_START') . '");');
}

?>