<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'links_browselinks');

$specialtemplates = array();

$globaltemplates = array(
	'ADV_LINKS_BROWSELINKS',
	'adv_links_letter',
	'adv_links_letter_selected',
	'adv_links_linkbit',
	'adv_links_nodisplay',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
	'forumdisplay_sortarrow'
);

$actiontemplates = array(
	'browselinks' => array(
		'adv_links_categorybit_level1',
		'adv_links_categorybit_level2',
		'adv_links_categorybit_main',
		'forumhome_moderator'
	),
	'favorites' => array(
		'forumdisplay_sortarrow'
	),
	'subscriptions' => array(
		'adv_links_categorybit_level1',
		'adv_links_categorybit_level2',
		'forumhome_moderator'
	)
);

$actiontemplates['none'] = &$actiontemplates['browselinks'];

$phrasegroups = array('forumdisplay');

if ($_REQUEST['do'] == 'searchresults' OR $_REQUEST['catid'] == 'searchresults')
{
	$phrasegroups[] = 'search';
}

if ($_REQUEST['catid'] AND $_REQUEST['do'] == 'jump')
{
	switch ($_REQUEST['catid'])
	{
		case 'home':
			$redirect = 'index.php' . $vbulletin->session->vars['sessionurl_q'];
		break;
		case 'search':
			$redirect = 'search.php' . $vbulletin->session->vars['sessionurl_q'];
		break;
		case 'favorites':
		case 'subscriptions':
		case 'newlinks':
		case 'poplinks':
			$redirect = 'browselinks.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . $_REQUEST['catid'];
		break;
	}
}

require_once('./links_global.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/functions_vba_links_cats.php');

if (!$_REQUEST['do'] OR $_REQUEST['do'] == 'jump')
{
	$_REQUEST['do'] = 'browselinks';
}

// Enter password for category
if ($_POST['do'] == 'enterpassword')
{
	$catpassword = $vbulletin->input->clean_gpc('p', 'catpassword', TYPE_NOHTML);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);

	if (!$vba_links->_cat['password'] AND $vba_links->_cat['parentpass'] AND $vba_links->_cat['parent'])
	{
		$checkpass = $vbulletin->adv_links_cats[$vba_links->_cat['parent']]['password'];
		$setcatid = $vba_links->_cat['parent'];
	}
	else
	{
		$checkpass = $vba_links->_cat['password'];
		$setcatid = $catid;
	}

	if (cat_opt('canhavepassword') AND $checkpass AND $checkpass == $catpassword)
	{
		set_bbarray_cookie('catpassword', $setcatid, md5($vbulletin->userinfo['userid'] . $catpassword), 1);
		$_REQUEST['do'] = 'browselinks';
	}
}

$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_INT);
$linkuserid = $vbulletin->input->clean_gpc('r', 'linkuserid', TYPE_INT);
$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
$ltr = $vbulletin->input->clean_gpc('r', 'ltr', TYPE_NOHTML);
$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_INT);
$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);
$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);

if ($cutoffdate != 'lastvisit')
{
	$cutoffdate = intval($cutoffdate);
}

$condition = array();
$wherequery = array();

$wherequery[] = 'suspended = 0 AND links.valid = 1';

if ($_REQUEST['do'] != 'browselinks')
{
	if ($privatecatids = fetch_private_categories())
	{
		$wherequery[] = 'links.catid NOT IN(' . $privatecatids . ')';
	}
}

$ignusers = fetch_ignored_users(intval($catid));
if ($ignusers)
{
	$wherequery[] = 'links.userid NOT IN(' . $ignusers . ')';
}

$show['categoryhead'] = true;
$show['category_tools'] = false;

if ($cutoffdate != 'lastvisit')
{
	$cutoffdate = intval($cutoffdate);
}

$show['ratingorderby'] = $vba_options['links_allowrating'];

// Let's figure out what we're doing here...
switch ($_REQUEST['do'])
{
	// ##### New Links
	case 'newlinks':

		if (!$vba_options['links_newlinklimit'])
		{
			print_no_permission();
		}

		if (!$cutoffdate)
		{
			$cutoffdate = 'lastvisit';
		}

		$catinfo['title'] = $vbphrase['new_links'] . ': ' .
			iif($cutoffdate == 'lastvisit',
				$vbphrase['since_your_last_visit'],
				construct_phrase($vbphrase['last_x_days'], $cutoffdate)
			);
		$catinfo['catid'] = 'newlinks';
		$navname = $vbphrase['whats_new'];
		$returnto = 'newlinks';
		$show['disablelinkdisplay'] = true;
		$condition['doorderby'] = 'dateline';
		$condition['direction'] = 'DESC';

	break;

	// ##### New Posts
	case 'newposts':

		if (!$vba_options['links_newlinklimit'])
		{
			print_no_permission();
		}

		if (!$cutoffdate)
		{
			$cutoffdate = 'lastvisit';
		}

		// Check view replies permission
		$noreplies = array();
		if (!empty($vbulletin->adv_links_cats))
		{
			foreach ($vbulletin->adv_links_cats AS $catid => $cats)
			{
				if (!$vba_links->check_cat_perms('canviewreplies', $cats))
				{
					$noreplies[] = $catid;
				}
			}
		}

		$wherequery[] = 'links.posts != 0';

		if (!empty($noreplies))
		{
			$wherequery[] = 'links.catid NOT IN(' . implode(',', $noreplies) . ')';
		}

		$catinfo['title'] = $vbphrase['new_posts'] . ': ' .
			iif($cutoffdate == 'lastvisit',
				$vbphrase['since_your_last_visit'],
				construct_phrase($vbphrase['last_x_days'], $cutoffdate)
			);
		$catinfo['catid'] = 'newposts';
		$navname = $vbphrase['whats_new'];
		$returnto = 'newposts';
		$show['newposts'] = true;
		$show['disablelinkdisplay'] = true;
		$condition['doorderby'] = 'links.lastpostdateline DESC, linkid';
		$condition['direction'] = 'DESC';

	break;

	// ##### Popular Links
	case 'poplinks':

		switch ($orderby)
		{
			case 'posts':
				$titlephrase = 'top_x_replied_to_links';
				$condition['doorderby'] = 'posts';
			break;

			case 'rating':
				$titlephrase = 'top_x_rated_links';
				$wherequery[] = 'votenum >= ' . $vba_options['links_poplinks_votelimit'];
				$condition['votequery'] = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
				$condition['doorderby'] = 'voteavg DESC, votenum';
			break;

			default:
				$titlephrase = 'top_x_visited_links';
				$condition['doorderby'] = 'views';
				$orderby = 'views';
				$show['disablelinkdisplay'] = true;
		}

		$catinfo['title'] = construct_phrase($vbphrase[$titlephrase], $vba_options['links_poplinklimit']);

		$orderbysel[$orderby] = 'selected="selected"';

		$condition['limit'] = $vba_options['links_poplinklimit'];
		$condition['direction'] = 'DESC';
		$navname = $vbphrase['whats_popular'];
		$catinfo['catid'] = 'poplinks';
		$returnto = 'poplinks';
		$show['poplinks'] = true;
	break;

	// ##### Favorites
	case 'favorites':
		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
		$catinfo['title'] = $vbphrase['my_favorites'];
		$navname = $vbphrase['my_favorites'];
		$catinfo['catid'] = 'favorites';
		$returnto = 'favorites';
		$show['cat_search'] = true;
		$condition['fromtable'] = 'adv_links_favorites AS favorites';
		$condition['join'] = 'adv_links AS links';
		$wherequery[] = 'favorites.userid = ' . $vbulletin->userinfo['userid'];
	break;

	// ##### Subscriptions
	case 'subscriptions':
		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
		$catinfo['title'] = $vbphrase['my_subscriptions'];
		$navname = $vbphrase['my_subscriptions'];
		$catinfo['catid'] = 'subscriptions';
		$returnto = 'subscriptions';
		$condition['fromtable'] = 'adv_links_subscribelink AS subscribelink';
		$condition['join'] = 'adv_links AS links';
		$wherequery[] = 'subscribelink.userid = ' . $vbulletin->userinfo['userid'];

		// ##### Subscribed Categories
		if ($page == 1 OR !$page)
		{
			$getsubcats = $db->query("
				SELECT categories.*, subscribecat.*
				FROM " . TABLE_PREFIX . "adv_links_categories AS categories
				INNER JOIN " . TABLE_PREFIX . "adv_links_subscribecat AS subscribecat ON (categories.catid = subscribecat.catid)
				WHERE subscribecat.userid = " . $vbulletin->userinfo['userid'] . "
				ORDER BY displayorder
			");
			if ($db->num_rows($getsubcats))
			{
				$show['subcats'] = true;
				$show['subscribe_options'] = true;

				$catsinfo = array();
				while ($subcats = $db->fetch_array($getsubcats))
				{
					$subcats['level'] = 1;
					$catsinfo[] = $subcats;
				}

				$subcatbits = print_categories(0, $catsinfo, true);
			}

			$db->free_result($getsubcats);
			unset($subcats);
		}
	break;

	// ##### Member search
	case 'member':
		if (!intval($linkuserid))
		{
			eval(standard_error(fetch_error('noid', $vbphrase['user'])));
		}
		$wherequery[] = 'links.userid = \'' . $linkuserid . '\'';
		$show['category_tools'] = false;
		$show['cat_search'] = false;
		$returnto = 'member';

		if ($page == 1 OR !$page)
		{
			$getsubcats = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_categories WHERE catuserid = '$linkuserid'");
			while ($cats = $vbulletin->db->fetch_array($getsubcats))
			{
				$catsinfo[$cats[catid]] = $cats;
				$catsinfo[$cats[catid]]['level'] = 1;
			}

			$db->free_result($getsubcats);
			unset($cats);

			if (!empty($catsinfo))
			{
				$wherequery[] = 'links.catid NOT IN(' . implode(',', array_keys($catsinfo)) . ')';
				$show['subcats'] = true;
				$subcatbits = print_categories(0, $catsinfo, true);
			}
		}

	break;

	// ##### Search Results
	case 'searchresults':

		$search = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links_search WHERE searchid = $searchid");
		if (!$search['searchid'])
		{
			eval(standard_error(fetch_error('searchnoresults', '')));
		}

		$condition['orderby'] = $search['orderby'];
		$catinfo['title'] = $vbphrase['search_results'];
		$navname = $vbphrase['search_results'];
		$wherequery[] = 'links.linkid IN(' . $search['linkids'] . ')';
		$returnto = 'searchresults';

		$search['keywords'] = explode(' ', $search['string']);
		foreach ($search['keywords'] AS $key => $keyword)
		{
			if ($key > 0)
			{
				$comma = ',';
			}
			$keywords .= $comma . '<b><u>' . $keyword . '</u></b>';
		}

		if ($search['username'])
		{
			$search['username'] = unserialize($search['username']);
			foreach ($search['username'] AS $userid => $username)
			{
				$search['usernames'][$userid] = '<a href="' . $vbulletin->options['bburl'] . '/member.php?u=' . $userid . '"><b><u>' . $username . '</b></u></a>';
			}
			$search['usernames'] = implode(' ' . $vbphrase['or'] . ' ', $search['usernames']);
		}

		$highlight['string'] = $search['string'];
		$search['sfields'] = explode(',', $search['sfields']);

		foreach ($search['sfields'] AS $sfield)
		{
			$show['highlight_' . $sfield] = true;
		}

		$highlight['wholeword'] = $search['wholeword'];

	break;

	// ##### Browse Links
	default:

		$catid = intval($catid);

		$catinfo =& $vbulletin->adv_links_cats[$catid];

		if (!$catinfo['catid'])
		{
			eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['webmasteremail'])));
		}

		$vba_links->check_cat_perms('canviewlinksdir', $catinfo, true);

		check_category_password($catinfo['catid']);

		if (!cat_user_opt('allow_ratings', $link['catid']) OR !cat_opt('allow_ratings', $link['catid']))
		{
			$show['ratingorderby'] = false;
		}

		// Get subscribed info
		if ($vba_options['links_allowsubscribe'] AND $vbulletin->userinfo['userid'])
		{
			// Get category info
			$subscribecat = $db->query_first("
				SELECT NOT ISNULL(catid) AS subcatid
				FROM " . TABLE_PREFIX . "adv_links_subscribecat
				WHERE catid = $catid AND userid = " . $vbulletin->userinfo['userid']
			);

			$catinfo['subcatid'] = $subscribecat['subcatid'];
		}

		if ($catinfo['subcatid'])
		{
			$show['unsubscribe_cat'] = true;
		}

		if (!$catinfo['haslinks'] OR !$vba_links->check_cat_perms('canviewlinks', $catinfo))
		{
			$nolinksdisplay = true;
			$show['disablelinkdisplay'] = true;
		}

		$wherequery[] = 'links.catid = ' . $catid;
		$condition['stickyorder'] = 'sticky DESC,';
		$show['categoryhead'] = false;
		$show['category_tools'] = true;
		$show['cat_search'] = $vba_links->check_cat_perms('cansearch', $catinfo);

		if ($subcatbits = print_categories($catid))
		{
			$show['subcats'] = true;
		}

		$vba_links->check_cat_perms('canviewlinks', $catinfo, true);

		$returnto = 'cat';
}

if (!isset($condition['fromtable']))
{
	$condition['fromtable'] = 'adv_links AS links';
}

$adv_sorturl = construct_adv_sort_url();

if (in_array($_REQUEST['do'], array('browselinks', 'favorites', 'subscriptions', 'member', 'newlinks', 'newposts', 'searchresults')))
{
	// Direction
	$direction = strtoupper($direction);
	if ($direction == 'DESC' OR $direction == 'ASC')
	{
		$condition['direction'] = $direction;
	}
	else if (!$condition['direction'])
	{
		$condition['direction'] = $vba_options['links_defdirection'];
		$direction = $vba_options['links_defdirection'];
	}

	// Order by
	if (!$orderby AND !$condition['doorderby'])
	{
		$orderby = $vba_options['links_deforder'];
		$condition['doorderby'] = construct_orderby();
	}
	else if (!$condition['doorderby'])
	{
		$condition['doorderby'] = construct_orderby();
	}

	if ($orderby == 'rating')
	{
		$condition['votequery'] = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
	}

	$oppositesort = iif($condition['direction'] == 'ASC', 'desc', 'asc');

	$catsel[$condition['direction']] = 'selected="selected"';

	// Cutoff date
	if ($cutoffdate AND $cutoffdate != -1)
	{
		$wherequery[] = 'links.' . iif($_REQUEST['do'] == 'newposts', 'lastpost') . 'dateline > ' . iif($cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (TIMENOW - ($cutoffdate * 86400)));
	}

	if (!$cutoffdate OR $cutoffdate == -1)
	{
		$cutoffdate = 'all';
	}

	$datecutsel = array();
	$datecutsel[$cutoffdate] = 'selected="selected"';

	$ordersel = array();
	$ordersel[$orderby] = 'selected="selected"';

	$item = $vbphrase['links'];

	// Letterbits
	$alphabet = array_merge(array($vbphrase['all'], '#'), range('A', 'Z'));
	$adv_sorturl_ltr = construct_adv_sort_url(array('ltr'));

	foreach($alphabet as $lkey => $letter)
	{
		if ($lkey == 0)
		{
			$linkletter = '';
		}
		else if ($lkey == 1)
		{
			$linkletter = 'nonalpha';
		}
		else
		{
			$linkletter = $letter;
		}

		$letterselected = ($ltr == $linkletter) ? true : false;

		$letterurl = 'browselinks.php?' . $vbulletin->session->vars['sessionurl'] . 'ltr=' . $linkletter . $adv_sorturl_ltr;

		eval('$letterbits .= "' . fetch_template('adv_links_letter') . '";');
	}

	if ($ltr AND ($ltr == 'nonalpha' OR in_array($ltr, $alphabet)))
	{
		$wherequery[] = iif($ltr == 'nonalpha', 'name NOT REGEXP("^[a-zA-Z]")', 'name LIKE(\'' . $ltr . '%\')');
	}

	$sorturl = 'browselinks.php?' . $vbulletin->session->vars['sessionurl'] . 'direction=' . $oppositesort . construct_adv_sort_url(array('direction'));
	eval('$arrow[$orderby] = "' . fetch_template('forumdisplay_sortarrow') . '";');

	if (!$nolinksdisplay)
	{
		$pagedata = fetch_page_data('', iif($_REQUEST['do'] == 'searchresults' AND sizeof($wherequery), $search['numresults'], false));
		$perpage = $pagedata['perpage'];
		$pagenumber = $pagedata['pagenumber'];
		$condition['limit'] = ($pagedata['minlimit'] - 1) . ',' . $pagedata['perpage'];
	}

	if (!$pagedata['count'])
	{
		$noimagedisplay = true;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $pagedata['count'], 'browselinks.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . $_REQUEST['do'], construct_adv_sort_url(array('page')));
}

if (!$nolinksdisplay)
{
	$queryfields = '';
	$queryjoin = '';

	if ($orderby == 'category')
	{
		$queryjoin = 'INNER JOIN ' . TABLE_PREFIX . 'adv_links_categories AS categories ON (links.catid = categories.catid)';
	}

	$linkids = array();
	$getids = $db->query_read("
			SELECT $condition[votequery] links.linkid
			FROM " . TABLE_PREFIX . $condition['fromtable'] . "
			" . iif($condition['join'], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join'] . ' USING (linkid)') . "
			$queryjoin
			" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
			ORDER BY $condition[stickyorder] $condition[doorderby] $condition[direction], links.linkid DESC
			LIMIT $condition[limit]
	");

	while ($linkid = $db->fetch_array($getids))
	{
		$linkids[] = $linkid['linkid'];
	}

	$db->free_result($getids);
	unset($linkid);

	if (!empty($linkids))
	{
		$linkids = implode(',', $linkids);

		// Load the BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		// Subscribed links
		if ($vba_options['links_allowsubscribe'] AND $vbulletin->userinfo['userid'] AND $_REQUEST['do'] != 'subscriptions')
		{
			$queryfields = ', NOT ISNULL(subscribelink.linkid) AS subid';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'adv_links_subscribelink AS subscribelink ON (links.linkid = subscribelink.linkid AND ' . $vbulletin->userinfo['userid'] . ' = subscribelink.userid)';
		}

		// Join favorites if userid
		if ($vbulletin->userinfo['userid'] AND $vba_options['links_allowfav'] AND $_REQUEST['do'] != 'favorites')
		{
			$queryfields .= ', NOT ISNULL(favorites.linkid) AS favid';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'adv_links_favorites AS favorites ON (favorites.linkid = links.linkid AND favorites.userid = ' . $vbulletin->userinfo['userid'] . ')';
		}

		// Get Links
		$getlinks = $db->query("
			SELECT $condition[votequery] links.linkid, name, links.description, linkurl, links.catid, views, posts, username, links.userid, dateline, sticky, open, votenum, votetotal, posts, links.lastpostid, links.lastpostdateline, links.lastpostuserid, links.lastpostusername, customfields.* $queryfields
			FROM " . TABLE_PREFIX . "adv_links AS links
			LEFT JOIN " . TABLE_PREFIX . "adv_links_cfields_entries AS customfields ON (links.linkid = customfields.lid)
			$queryjoin
			WHERE links.linkid IN($linkids)
			ORDER BY $condition[stickyorder] $condition[doorderby] $condition[direction]
		");

		while ($links = $db->fetch_array($getlinks))
		{
			if ($_REQUEST['do'] == 'favorites')
			{
				$links['favid'] = 1;
			}

			if ($_REQUEST['do'] == 'subscriptions')
			{
				$links['subid'] = 1;
			}
			$lusername = $links['username'];
			$linkbits .= construct_linkbits($links, $highlight);
		}

		if ($_REQUEST['do'] == 'member')
		{
			if (substr($lusername, -1) != 's')
			{
				$plurals = $vbphrase['plural_s'];
			}

			$catinfo['title'] = construct_phrase($vbphrase['usernames_links'], $lusername, $plurals);
			$navname = $catinfo['title'];
		}

		if ($_REQUEST['do'] == 'browselinks')
		{
			$vbulletin->templatecache['forumhome_moderator'] = str_replace('"member.php', '"' . $vbulletin->options['bburl'] . '/member.php', $vbulletin->templatecache['forumhome_moderator']);

			// Moderators
			$categorymods = fetch_cat_moderators($catid);
			$modcount = sizeof($vbulletin->adv_links_mods[$catid]);
		}

		$db->free_result($getlinks);
		unset($links);
	}
	else
	{
		eval('$linkbits = "' . fetch_template('adv_links_nodisplay') . '";');
	}
}
else
{
	if ($_REQUEST['do'] == 'member')
	{
		$user = $db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = '$linkuserid'");
		if (substr($user['username'], -1) != 's')
		{
			$plurals = $vbphrase['plural_s'];
		}
		$catinfo['title'] = construct_phrase($vbphrase['usernames_links'], $user['username'], $plurals);
		$navname = $catinfo['title'];
	}

	eval('$linkbits = "' . fetch_template('adv_links_nodisplay') . '";');
}

$sorturls['rating'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=rating&amp;direction=DESC';

$sorturls['rating'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=rating&amp;direction=DESC';
$sorturls['name'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=name';
$sorturls['dateline'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=dateline';
$sorturls['lastpostdateline'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=lastpostdateline';
$sorturls['posts'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=posts';
$sorturls['views'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=views';
$sorturls['category'] = construct_adv_sort_url(array('orderby', 'direction')) . '&amp;orderby=category';

$categoryjump = print_category_jump($catid);

if ($_REQUEST['do'] == 'browselinks')
{
	$navbits = fetch_cat_navbits($catid);
}
else
{
	$navbits[''] = $navname;
}

$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');

$pagedata['minlimit'] = vb_number_format(iif($pagedata['count'], $pagedata['minlimit'], 0));
$pagedata['maxlimit'] = vb_number_format($pagedata['maxlimit']);
$pagedata['count'] = vb_number_format($pagedata['count']);

eval('print_output("' . fetch_template('ADV_LINKS_BROWSELINKS') . '");');

?>