<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'links_index');

$phrasegroups = array();

$globaltemplates = array(
	'ADV_LINKS',
	'adv_links_categorybit_level1',
	'adv_links_categorybit_level2',
	'adv_links_categorybit_main',
	'adv_links_categorybit_subcat',
	'adv_links_linkbit',
	'forumhome_moderator'
);

$specialtemplates = array(
	'adv_links_mods',
	'adv_links_rand'
);

require_once('./links_global.php');
require_once(DIR . '/includes/functions_vba_links_cats.php');

$catinfo = array();
$stats = array();

$catid = intval($catid);

if ($catid)
{
	check_category_password($catid);

	$show['subcats'] = true;
	$categoryjump = print_category_jump($catid);

	$navinfo['title'] =& $vba_links->_cat['title'];

	if ($vba_options['links_navbarhomelink'])
	{
		$navbits["$vba_options[links_homeurl]/index.php"] = $vba_options['links_title'];
	}

	$navbits = fetch_cat_navbits($catid);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
}
else
{
	$vba_options['links_catdepth'] =& $vba_options['links_catdepth_index'];

	$show['categoryhead'] = true;
	$returnto = 'index';

	if ($vba_options['links_showstats'])
	{
		$show['stats'] = true;

		$stats['categories'] = vb_number_format($stats['categories']);
		$stats['links'] = vb_number_format($stats['links']);
		$stats['posts'] = vb_number_format($stats['posts']);

		$getstats = $db->query_first("SELECT SUM(views) AS views FROM " . TABLE_PREFIX . "adv_links");
		$stats['views'] = vb_number_format($getstats['views']);
	}

	$querycols = 'links.linkid, name, description, linkurl, links.catid, username, links.userid, views, open, dateline, votenum, votetotal';
	$queryjoin = '';

	if ($vba_options['links_randonhome'] OR $vba_options['links_newonhome'])
	{
		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		// Subscribed links
		if ($vba_options['links_allowsubscribe'] AND $vbulletin->userinfo['userid'])
		{
			$querycols .= ', NOT ISNULL(subscribelink.linkid) AS subid';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'adv_links_subscribelink AS subscribelink ON (links.linkid = subscribelink.linkid AND ' . $vbulletin->userinfo['userid'] . ' = subscribelink.userid) ';
		}

		// Get post info if user has permission
		if ($vba_options['links_allowreplies'])
		{
			$querycols .= ', posts, links.lastpostid, links.lastpostdateline, links.lastpostuserid, links.lastpostusername';
		}

		// Join favorites if userid
		if ($vbulletin->userinfo['userid'] AND $vba_options['links_allowfav'])
		{
			$querycols .= ', NOT ISNULL(favorites.linkid) AS favid';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'adv_links_favorites AS favorites ON (favorites.linkid = links.linkid AND favorites.userid = ' . $vbulletin->userinfo['userid'] . ')';
		}

		$privcats = fetch_private_categories();

		if ($vba_options['links_home_excats'])
		{
			$privcats = $vba_options['links_home_excats'] . iif($privcats, ", $privcats");
		}

		if ($privcats)
		{
			$privatecats = 'AND links.catid NOT IN(' . $privcats . ')';
		}

		if (intval($vba_options['links_newonhome']))
		{
			$getnew = $db->query_read("SELECT $querycols
					FROM " . TABLE_PREFIX . "adv_links AS links
					$queryjoin
					WHERE valid = 1 AND suspended = 0 $privatecats
					ORDER BY dateline DESC
					LIMIT $vba_options[links_newonhome]");
			if ($db->num_rows($getnew))
			{
				$show['newlinks'] = true;
				while ($links = $db->fetch_array($getnew))
				{
					$newlinkbits .= construct_linkbits($links, 1);
				}
			}
		}

		if (intval($vba_options['links_randonhome']))
		{
			$randids = array();

			if (!empty($vbulletin->adv_links_rand))
			{
				foreach ($vbulletin->adv_links_rand AS $rndgroup => $rndlinks)
				{
					if (!in_array($rndgroup, $vbulletin->userinfo['usergrouparray']))
					{
						continue;
					}

					if ($rndlinks['linkgroup'])
					{
						$randids = array_merge($randids, $vbulletin->adv_links_rand[$rndlinks['linkgroup']]['links']);
					}
					else if (!empty($rndlinks['links']))
					{
						$randids = array_merge($randids, $rndlinks['links']);
					}
				}
			}

			if (!empty($randids))
			{
				$getrand = $db->query_read("SELECT $querycols
						FROM " . TABLE_PREFIX . "adv_links AS links
						$queryjoin
						WHERE valid = 1 AND suspended = 0 $privatecats AND links.linkid IN(" . implode(',', $randids) . ")
						ORDER BY RAND()
						LIMIT $vba_options[links_randonhome]
				");
				if ($db->num_rows($getrand))
				{
					$show['randomlinks'] = true;
					while ($links = $db->fetch_array($getrand))
					{
						$randomlinkbits .= construct_linkbits($links, 1);
					}
				}
			}
		}
	}

	if ($vba_options['links_navbarhomelink'])
	{
		$navbits[''] = $vba_options['links_title'];
		$navbits = construct_navbits($navbits);
	}
	eval('$navbar = "' . fetch_template('navbar') . '";');
}

$categorybits = print_categories($catid);

eval('print_output("' . fetch_template('ADV_LINKS') . '");');

?>