<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'links_managecats');

$globaltemplates = array();

$specialtemplates = array();

$phrasegroups = array('adv_links_managecats');

$actiontemplates = array(
	'manage' => array(
		'ADV_LINKS_CATMANAGER',
		'adv_links_catmanager_categorybits'
	),
	'addcat' => array(
		'ADV_LINKS_CATMANAGER_ADDEDIT_CAT'
	),
	'editcat' => array(
		'ADV_LINKS_CATMANAGER_ADDEDIT_CAT'
	),
	'deletecat' => array(
		'ADV_LINKS_MODOPTS',
		'adv_links_conformation'
	),
	'emptycat' => array(
		'ADV_LINKS_MODOPTS',
		'adv_links_conformation'
	)

);

$actiontemplates['none'] = &$actiontemplates['manage'];

require_once('./links_global.php');

if (!$vba_links->check_perms('cancreatecats') OR !$vbulletin->userinfo['userid'] OR !$vba_options['links_allow_user_cats'])
{
	print_no_permission();
}

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

// ######################### Main Manage Cats Page ###########################
if ($_REQUEST['do'] == 'manage')
{
	require_once(DIR . '/includes/functions_vba_links_cats.php');

	$allowedparents = fetch_allowed_parents();

	$catcount = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_links_categories WHERE catuserid = " . $vbulletin->userinfo['userid']);

	$categorybits = construct_phrase($vbphrase['you_have_used_x_out_of_y_categories_allowed'], $catcount['count'], iif($vba_links->check_perms('links_maxcats'), $vba_links->check_perms('links_maxcats'), $vbphrase['unlimited']));

	// Now print out the categories
	$haveusercats = false;
	if (!empty($vbulletin->adv_links_cats))
	{
		foreach ($vbulletin->adv_links_cats AS $category)
		{
			if ($category['catuserid'] == $vbulletin->userinfo['userid'] OR in_array($category['catid'], $allowedparents))
			{
				$haveusercats = true;
				$dashes = str_repeat('--', $category['level'] - 1);
				$category['title'] = $category['title'];
				eval('$categorybits .= "' . fetch_template('adv_links_catmanager_categorybits') . '";');
			}
		}
	}

	if (!$haveusercats)
	{
		$categorybits .= $vbphrase['you_do_not_have_any_categories'];
	}

	$navbits[''] = $vbphrase['category_manager'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('ADV_LINKS_CATMANAGER') . '");');
}
// ############################# Add / Edit Category #########################
if ($_REQUEST['do'] == 'addcat' OR $_REQUEST['do'] == 'editcat')
{
	require_once(DIR . '/includes/functions_vba_links_cats.php');

	$defcatopts =& $vba_options['links_usercats_defaultopts'];
	$show['catopts'] = iif(in_array(2, array_values($defcatopts)), true);

	foreach ($defcatopts AS $varname => $value)
	{
		if ($value != 2)
		{
			$hiddenbits .= '<input type="hidden" name="useropts[' . $varname . ']" value="' . $defcatopts["$varname"] . '" />';
		}
	}

	if ($_REQUEST['do'] == 'editcat')
	{
		if (!$vba_options['links_usercat_edit'])
		{
			print_no_permission();
		}
		$category = $db->query_first("SELECT catid, title, description, catuserid, parent, password, useroptions FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $catid");

		if ($category['catuserid'] != $vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}

		$useropts = convert_bits_to_array($category['useroptions'], $vba_links->_catuseropts);

		foreach ($useropts AS $option => $value)
		{
			if ($value == 1)
			{
				$checked["$option"] = 'checked="checked"';
			}
		}
		$navbits['browselinks.php?' . $vbulletin->session->vars['sessionurl'] . "c=$category[catid]"] = $category['title'];
		$navbits[''] = $vbphrase['edit_category'];
	}
	else
	{
		// Check to see how many categories they've created
		if ($vba_links->check_perms('links_maxcats'))
		{
			$catcount = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_links_categories WHERE catuserid = " . $vbulletin->userinfo['userid']);
			if ($catcount['count'] >= $vba_links->check_perms('links_maxcats'))
			{
				eval(standard_error(fetch_error('adv_links_too_many_categories', $vba_links->check_perms('links_maxcats'))));
			}
		}

		foreach ($vba_links->_catuseropts AS $option => $value)
		{
			$checked["$option"] = 'checked="checked"';
		}

		$navbits[''] = $vbphrase['add_category'];
	}

	$allowedparents = fetch_allowed_parents();

	$catoptions = print_cat_select($category['parent'], 'managecats');

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('ADV_LINKS_CATMANAGER_ADDEDIT_CAT') . '");');
}

// ########################### Do Add / Edit Category #########################
if ($_POST['do'] == 'doaddcat' OR $_POST['do'] == 'doeditcat')
{
	require_once(DIR . '/includes/functions_vba_links_cats.php');

	$useropts = $vbulletin->input->clean_gpc('p', 'useropts', TYPE_ARRAY_STR);
	$category = $vbulletin->input->clean_gpc('p', 'category', TYPE_ARRAY_STR);

	$category['parent'] = intval($category['parent']);
	$category['catid'] = intval($category['catid']);
	$category['thisparent'] = intval($category['thisparent']);

	// Error checking
	if ($category['password'] != $category['confirmpassword'])
	{
		eval(standard_error(fetch_error('passwordmismatch')));
	}

	if (empty($category['title']))
	{
		eval(standard_error(fetch_error('adv_links_cant_have_category_without_title')));
	}

	if (empty($category['parent']))
	{
		eval(standard_error(fetch_error('adv_links_must_choose_parent_for_category')));
	}

	if (strlen($category['title']) > $vba_options['links_usercat_titlemax'])
	{
		eval(standard_error(fetch_error('adv_links_x_too_long', $vbphrase['title'], vb_number_format(strlen($category['title'])), $vba_options['links_usercat_titlemax'])));
	}

	if (strlen($category['description']) > $vba_options['links_usercat_descmax'])
	{
		eval(standard_error(fetch_error('adv_links_x_too_long', $vbphrase['description'], vb_number_format(strlen($category['description'])), $vba_options['links_usercat_descmax'])));
	}

	if ($category['parent'] == $category['catid'])
	{
		eval(standard_error(fetch_error('adv_links_cant_parent_category_self')));
	}

	if (!$vba_options['links_usercats_password'])
	{
		$category['password'] = '';
		$category['confirmpassword'] = '';
	}

	foreach ($vba_options['links_usercats_defaultopts'] AS $varname => $value)
	{
		$useropts["$varname"] = iif($value == 2, $useropts["$varname"], $value);
	}

	require_once(DIR . '/includes/functions_misc.php');
	$useroptions = convert_array_to_bits($useropts, $vba_links->_catuseropts);

	// Editing the category
	if ($_POST['do'] == 'doeditcat')
	{
		$checkuser = $db->query_first("SELECT password, catuserid FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $category[catid]");
		if ($checkuser['catuserid'] != $vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}

		if ($checkuser['password'] != $category['currentpass'] AND $category['password'])
		{
			eval(standard_error(fetch_error('adv_links_wrongpassword', $vbulletin->session->vars['sessionurl'], $category['catid'])));
		}

		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links_categories SET
				title = '" . $db->escape_string(htmlspecialchars($category['title'])) . "',
				description = '" . $db->escape_string(htmlspecialchars($category['description'])) . "',
				parent = $category[parent],
				" . iif($category['currentpass'], "password = '" . $db->escape_string(htmlspecialchars($category['password'])) . "',") . "
				useroptions = '$useroptions'
			WHERE catid = $category[catid]
		");

		if ($category['parent'] != $category['thisparent'])
		{
			rebuild_parents($category['catid']);
		}
	}
	else
	{
		// Else we're adding a category
		if ($vba_links->check_perms('links_maxcats'))
		{
			$catcount = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_links_categories WHERE catuserid = '" . $vbulletin->userinfo['userid'] . "'");
			if ($catcount['count'] >= $vba_links->check_perms('links_maxcats'))
			{
				eval(standard_error(fetch_error('adv_links_too_many_categories', $vba_links->check_perms('links_maxcats'))));
			}
		}

		if ($vba_options['links_newcatsattop'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET displayorder = displayorder+1 WHERE parent = $category[parent]");
			$category['displayorder'] = 1;
		}
		else
		{
			$order = $db->query_first("SELECT MAX(displayorder) AS displayorder FROM " . TABLE_PREFIX . "adv_links_categories WHERE parent = $category[parent]");

			$category['displayorder'] = $order['displayorder'] + 1;
		}

		$parentcat = $vbulletin->adv_links_cats[$category['parent']];

		$newcatopts = $parentcat['options'];

		if (!cat_opt('open_for_links', $category['parent']))
		{
			$newcatopts += $vba_links->_categoryopts['open_for_links'];
		}

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "adv_links_categories
				(title, description, catuserid, parent, displayorder, haslinks, active, valid, password, options, useroptions)
			VALUES (
				'" . $db->escape_string(htmlspecialchars($category['title'])) . "',
				'" . $db->escape_string(htmlspecialchars($category['description'])) . "',
				" . iif($vba_options['links_allow_user_cats'] == 2, 0, $vbulletin->userinfo['userid']) . ",
				$category[parent],
				$category[displayorder],
				1,
				1,
				" . iif($vba_links->check_perms('moderatecats'), 0, 1) . ",
				'" . $db->escape_string(htmlspecialchars($category['password'])) . "',
				'$newcatopts',
				'$useroptions'
		)");

		$newcatid = $db->insert_id();

		insert_category_parentlist($category['parent']);

	}

	update_category_cache();

	$vbulletin->url = 'managecats.php' . $vbulletin->session->vars['sessionurl_q'];
	eval(print_standard_redirect('adv_links_addednewcat'));
}

// ####################### Delete / Empty Category ############################
if (in_array($_REQUEST['do'], array('deletecat', 'emptycat')))
{
	$cat = $vbulletin->adv_links_cats[$catid];

	if (!$cat['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['webmasteremail'])));
	}

	if ($cat['catuserid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$itemname = 'catid';
	$itemid = $cat['catid'];
	$formaction = 'managecats';
	$dovalue = 'do' . $_REQUEST['do'];
	$itemtitle = $cat['title'];

	$navbits = fetch_cat_navbits($catid);

	if ($_REQUEST['do'] == 'emptycat')
	{
		if (!$vba_options['links_usercats_empty'])
		{
			print_no_permission();
		}
		$titlephrase = $vbphrase['empty_category'];
		$buttonphrase = $vbphrase['empty'];
		$confirmphrase = $vbphrase['are_you_sure_empty_category'];
		$navbits[''] = $vbphrase['empty_category'];
		$navname = $vbphrase['empty_category'];
	}
	else
	{
		if (!$vba_options['links_usercats_delete'])
		{
			print_no_permission();
		}
		$titlephrase = $vbphrase['remove_category'];
		$buttonphrase = $vbphrase['delete'];
		$confirmphrase = $vbphrase['are_you_sure_delete_category'];
		$navbits[''] = $vbphrase['remove_category'];
		$navname = $vbphrase['remove_category'];
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('$content = "' . fetch_template('adv_links_conformation') . '";');

	eval('print_output("' . fetch_template('ADV_LINKS_MODOPTS') . '");');
}

// ####################### Do Delete / Empty Category #########################
if ($_POST['do'] == 'dodeletecat' OR $_POST['do'] == 'doemptycat')
{
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);

	if (!$_POST['confirmaction'])
	{
		eval(standard_error(fetch_error('adv_links_nodelete')));
	}

	$cat = $vbulletin->adv_links_cats[$catid];

	if (!$cat['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['webmasteremail'])));
	}

	if ($cat['catuserid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->url = 'managecats.php' . $vbulletin->session->vars['sessionurl_q'];

	require_once(DIR . '/includes/functions_vba_links_cats.php');

	if ($_POST['do'] == 'doemptycat')
	{
		if (!$vba_options['links_usercats_empty'])
		{
			print_no_permission();
		}

		remove_links_in_cat($catid);

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links_categories SET
				linkcount = 0,
				postcount = 0,
				lastlinkid = 0,
				lastlinktitle = '',
				lastlinkusername = '',
				lastlinkuserid = 0,
				lastlinkdateline = 0,
				lastpostid = 0,
				lastpostlinktitle = '',
				lastpostusername = '',
				lastpostuserid = 0,
				lastpostdateline = 0
			WHERE catid = $catid
		");

		eval(print_standard_redirect('adv_links_category_emptied'));
	}
	else
	{
		if (!$vba_options['links_usercats_delete'])
		{
			print_no_permission();
		}

		$catids = array($catid);
		if ($catinfo = construct_categories($vbulletin->adv_links_cats, $catid))
		{
			foreach ($catinfo AS $cats)
			{
				$catids[] = $cats['catid'];
			}
		}

		if (!empty($catids))
		{
			$catids = implode(',', $catids);

			remove_links_in_cat($catids);

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid IN ($catids)");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_subscribecat WHERE catid IN ($catids)");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_moderator WHERE catid IN ($catids)");

			update_category_cache();
		}

		eval(print_standard_redirect('adv_links_category_deleted'));
	}
}

?>