<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'links_newreply');

$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
	'iconcache'
);

$globaltemplates = array(
	'ADV_LINKS_REPLY',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
	'newreply_reviewbit',
	'humanverify',
	'imagereg'
);

$actiontemplates = array(
	'ratelink' => array(
		'adv_links_ratingpopup'
	)
);

$actiontemplates['none'] =& $actiontemplates['newreply'];

$phrasegroups = array(
	'posting',
	'threadmanage'
);

require_once('./links_global.php');
require_once(DIR . '/includes/functions_newpost.php');

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'newreply';
}

// ################### Function for mini-errors #################
function print_mini_error($errormessage)
{
	global $headinclude, $vbphrase, $stylevar;

	$errormessage = fetch_error($errormessage, PHRASETYPEID_ERROR);

	eval('print_output("' . fetch_template('adv_links_minierror') . '");');
	exit;
}

// ############# Function To Rate Links #####################
function rate_link($vote, $linkid, $redirpage = '')
{
	global $vba_links, $vba_options, $db, $vbulletin, $link, $newpostid, $newpostid, $adv_sorturl;

	$linkid = intval($linkid);
	$vote = intval($vote);

	if (empty($vba_links->_link))
	{
		$vba_links->load_link();
		$link =& $vba_links->_link;
	}

	if (!$vba_links->check_cat_perms('canrate') OR !$vba_options['links_allowrating'] OR !cat_opt('allow_ratings', $link['catid']))
	{
		if ($redirpage == 'close')
		{
			eval(print_mini_error('adv_links_novotingperms'));
		}
		else
		{
			print_no_permission();
		}
	}

	if ($vote < 1 or $vote > 5)
	{
		if ($redirpage == 'close')
		{
			eval(print_mini_error('error_invalidvote'));
		}
		else
		{
			eval(standard_error(fetch_error('error_invalidvote')));
		}
	}

	switch ($redirpage)
	{
		case 'close':
			$redirurl = 'newreply.php?do=closebox';
		break;

		case 'post':
			$redirurl = 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&' . $adv_sorturl . 'postid=' . $newpostid . '#post' . $newpostid;
		break;

		default :
			$redirurl = 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&l=' . $linkid;
	}
	// Check For Duplicates
	if (fetch_bbarray_cookie('rating_linkid', $linkid))
	{
		if ($redirpage == 'close')
		{
			eval(print_mini_error('threadratevoted'));
		}
		else
		{
			eval(standard_error(fetch_error('threadratevoted')));
		}
	}

	if ($rating = $db->query_first("
			SELECT rateid, rating
			FROM " . TABLE_PREFIX . "adv_links_rate
			WHERE linkid = $linkid
			AND " . iif($vbulletin->userinfo['userid'],
				'userid = ' . $vbulletin->userinfo['userid'],
				"ipaddress = '" . $db->escape_string(IPADDRESS) . "'"
	)))
	{
		if (!$vbulletin->options['votechange'])
		{
			if ($redirpage == 'close')
			{
				eval(print_mini_error('threadratevoted'));
			}
			else
			{
				eval(standard_error(fetch_error('threadratevoted')));
			}
		}
		else
		{
			if ($vote != $rating['rating'])
			{
				$newvote = $vote - $rating['rating'];
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_rate SET rating = $vote WHERE rateid = $rating[rateid]");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links SET votetotal = votetotal + $newvote WHERE linkid = $linkid");
			}
			$vbulletin->url = $redirurl;
			eval(print_standard_redirect('redirect_threadrate_update'));
		}
	}
	else
	{
		// No duplicates, so insert the rating
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "adv_links_rate
				(linkid, rating, userid, ipaddress)
			VALUES (
				$linkid,
				$vote,
				" . $vbulletin->userinfo['userid'] . ",
				'" . $db->escape_string(IPADDRESS) . "'
		)");

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links SET
				votetotal = votetotal + $vote,
				votenum = votenum + 1
			WHERE linkid = $linkid
		");

		set_bbarray_cookie('rating_linkid', $linkid, $vote, 1);

		$vbulletin->url = $redirurl;
		eval(print_standard_redirect('redirect_threadrate_add'));
	}
}

// ########################## Do Reply to Link #############################
if ($_POST['do'] == 'postreply' OR $_POST['do'] == 'doedit')
{
	if (!$vba_options['links_allowreplies'])
	{
		print_no_permission();
	}

	$linkid = $vbulletin->input->clean_gpc('p', 'linkid', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);
	$postid = $vbulletin->input->clean_gpc('p', 'postid', TYPE_INT);
	$vote = $vbulletin->input->clean_gpc('p', 'vote', TYPE_INT);
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg', TYPE_BOOL);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$ajax = $vbulletin->input->clean_gpc('p', 'ajax', TYPE_BOOL);
	$iconid = $vbulletin->input->clean_gpc('p', 'iconid', TYPE_INT);
	$signature = $vbulletin->input->clean_gpc('p', 'signature', TYPE_INT);
	$imagehash = $vbulletin->input->clean_gpc('p', 'imagehash', TYPE_STR);
	$imagestamp = $vbulletin->input->clean_gpc('p', 'imagestamp', TYPE_STR);

	require_once(DIR . '/includes/functions_misc.php');

	$vba_links->load_link();
	$link =& $vba_links->_link;

	$catid = $link['catid'];

	// Edit post permissions
	if ($_POST['do'] == 'doedit')
	{
		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}

		if (!is_category_mod($link['catid']))
		{
			$oldpost = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "adv_links_posts WHERE postid = $postid");

			if (($vbulletin->userinfo['userid'] != $oldpost['userid'] AND !$vba_links->check_cat_perms('caneditothersposts')) OR ($vbulletin->userinfo['userid'] == $oldpost['userid'] AND !$vba_links->check_cat_perms('caneditposts')))
			{
				print_no_permission();
			}
		}
	}
	// New reply permissions
	else
	{
		if (!$vba_links->check_cat_perms('canreply') OR !cat_user_opt('allow_reply'))
		{
			print_no_permission();
		}
		if (!cat_opt('open_for_posts'))
		{
			eval(standard_error(fetch_error('adv_links_not_open_for_posts')));
		}
		// Check to see if it's open
		if (!is_category_mod($link['catid']) AND !$link['open'])
		{
			print_no_permission();
		}
	}

	$post['title'] = htmlspecialchars(fetch_censored_text($_POST['title']));
	$post['username'] = $_POST['username'];

	// WYSIWYG
	if ($wysiwyg)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$post['message'] = convert_wysiwyg_html_to_bbcode($message);
	}

	// Normal editor
	else
	{
		$post['message'] = $message;
	}

	// Quote from quickreply
	if ($_POST['quickreply'])
	{
		$postinfo = $db->query_first("SELECT username, title, pagetext FROM " . TABLE_PREFIX . "adv_links_posts WHERE postid = $postid");

		$vbulletin->options['quotetitle'] = 0;
		if ($vba_options['links_quotetitle'] AND !$post['title'])
		{
			$vbulletin->options['quotetitle'] = 1;
		}

		$post['title'] = fetch_quote_title($post['title'], $postinfo['title']);

		$originalposter = fetch_quote_username($postinfo['username']);
		$pagetext = strip_quotes($postinfo['pagetext']);
		eval('$quotemessage = "' . fetch_template('newpost_quote', 1, 0) . '";');
		$post['message'] = "$quotemessage $post[message]";
		$newpost['message'] = "$quotemessage $post[message]";
	}

	// Insert title if necessary
	if (!$post['title'] AND $_POST['fromquickreply'] AND $vba_options['links_quotetitle'])
	{
		$vbulletin->options['quotetitle'] = 1;
		$post['title'] = fetch_quote_title($post['title'], $link['name']);
	}

	// Smilies
	$post['disablesmilies'] = $_POST['disablesmilies'];

	$post['enablesmilies'] = 0;
	if (!$post['disablesmilies'])
	{
		$post['enablesmilies'] = 1;
	}

	// ##### Check for errors
	$errors = array();

	// Image verification
	$imagereg = '';

	$imageerror = check_human_verify('reply', false);

	if ($imageerror)
	{
		eval('$errors[] = "' . $imageerror . '";');
	}

	$postlength = strlen($post['message']);

	// Check message length
	if (!$post['message'] AND $vbulletin->options['postminchars'])
	{
		eval('$errors[] = "' . fetch_error('nosubject') . '";');
	}

	if ($vbulletin->options['postminchars'] AND $postlength < $vbulletin->options['postminchars'])
	{
		eval('$errors[] = "' . fetch_error('tooshort', $postlength, $vbulletin->options['postminchars']) . '";');
	}
	else if ($vbulletin->options['postmaxchars'] AND $postlength > $vbulletin->options['postmaxchars'])
	{
		eval('$errors[] = "' . fetch_error('toolong', $postlength, $vbulletin->options['postmaxchars']) . '";');
	}

	// Guest username check
	if (!$vbulletin->userinfo['userid'])
	{
		if (!$post['username'])
		{
			eval('$errors[] = "' . fetch_error('nousername') . '";');
		}
		else if (strlen($post['username']) < $vbulletin->options['minuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametooshort', $vbulletin->options['minuserlength']) . '";');
		}
		else if (strlen($post['username']) > $vbulletin->options['maxuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametoolong', $vbulletin->options['maxuserlength']) . '";');
		}
		else if ($dupecheck = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string(htmlspecialchars($post['username'])) . "'"))
		{
			eval('$errors[] = "' . fetch_error('usernametaken', addslashes(htmlspecialchars($post['username'])), $vbulletin->session->vars['sessionurl']) . '";');
		}
	}

	$post['message'] = fetch_censored_text($post['message']);

	if ($_POST['parseurl'])
	{
		$post['message'] = convert_url_to_bbcode($post['message']);
	}

	// Duplicate post / flood check
	if ($_REQUEST['do'] == 'postreply' AND $vbulletin->userinfo['userid'])
	{
		$lpost = $db->query_first("SELECT postid, title, pagetext, dateline FROM " . TABLE_PREFIX . "adv_links_posts WHERE userid = " . $vbulletin->userinfo['userid'] . " ORDER BY dateline DESC LIMIT 1");

		// Have the same post, so just redirect the user
		if ($post['message'] == $lpost['pagetext'] AND $post['title'] == $lpost['title'])
		{
			$vbulletin->url = 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&amp;l=' . $linkid . '&amp;postid=' . $lpost['postid'] . '#post' . $lpost['postid'];
			eval(print_standard_redirect('redirect_postthanks'));
		}

		// Have flooding, so display error
		if ($vbulletin->options['floodchecktime'] AND !$_POST['preview'] AND (TIMENOW - $lpost['dateline']) <= $vbulletin->options['floodchecktime'])
		{
			eval('$errors[] = "' . fetch_error('postfloodcheck', $vbulletin->options['floodchecktime'], ($vbulletin->options['floodchecktime'] - (TIMENOW - $lpost['dateline']))) . '";');
		}
	}

	if ($vbulletin->options['maximages'])
	{
		require_once(DIR . '/includes/class_bbcode_alt.php');
		$bbcode_parser_img =& new vB_BbCodeParser_ImgCheck($vbulletin, fetch_tag_list());

		$imagecount = fetch_character_count($bbcode_parser_img->parse($post['message'], 'nonforum', $post['enablesmilies'], true), '<img');
		if ($imagecount > $vbulletin->options['maximages'])
		{
			eval('$errors[] = "' . fetch_error('toomanyimages', $imagecount, $vbulletin->options['maximages']) . '";');
		}
	}

	// Errors!
	if ($errors)
	{
		$postpreview = construct_errors($errors);
		construct_checkboxes($_POST);
		$newpost['message'] = htmlspecialchars($post['message']);
		$_REQUEST['l'] = $linkid;

		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'newreply';
		}
	}

	// Just previewing
	else if ($_POST['preview'])
	{
		if (!cat_opt('allow_post_smilies') OR !$vba_options['links_allowsmilie'])
		{
			$post['disablesmilies'] = 1;
		}

		$postpreview = process_post_preview($post);
		$newpost['message'] = $post['message'];
		construct_checkboxes($_POST);

		$_REQUEST['l'] = $linkid;
		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['postid'] = $postid;
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'newreply';
		}
	}
	else
	{
		// Everything's good, so get ready to insert or update

		// New reply
		if ($_REQUEST['do'] == 'postreply')
		{
			if ($vba_links->check_cat_perms('moderateposts'))
			{
				$visible = 0;
			}
			else
			{
				$visible = 1;
			}

			// Insert the post
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "adv_links_posts
					(linkid, title, pagetext, userid, username, dateline, ipaddress, iconid, allowsmilie, showsignature, visible)
				VALUES (
					$linkid,
					'" . $db->escape_string($post['title']) . "',
					'" . $db->escape_string($post['message']) . "',
					" . $vbulletin->userinfo['userid'] . ",
					'" . $db->escape_string($vbulletin->userinfo['username']) . "',
					" . TIMENOW . ",
					'" . $db->escape_string(IPADDRESS) . "',
					" . $iconid . ",
					$post[enablesmilies],
					$signature,
					$visible
			)");

			$newpostid = $db->insert_id();

			if (!$visible OR $vba_options['links_newlinkemail_all'])
			{
				$catemail = $db->query_first("SELECT title, newpostemail FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $link[catid]");

				$sendmailto = explode(' ', $catemail['newpostemail']);

				if (!empty($sendmailto))
				{
					foreach ($sendmailto AS $email)
					{
						eval(fetch_email_phrases('adv_links_newpost', 0));
						vbmail(trim($email), $subject, $message);
					}
				}
			}

			if ($visible == 1)
			{
				send_subscribed_posts($linkid);

				// Update link info
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_links SET
						posts = posts+1,
						lastpostuserid = " . $vbulletin->userinfo['userid'] . ",
						lastpostusername = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
						lastpostdateline = " . TIMENOW . "
					WHERE linkid = $linkid
				");

				// Update category info
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_links_categories SET
						postcount = postcount+1,
						lastpostid = $newpostid,
						lastpostlinktitle = '" . $db->escape_string($link['name']) . "',
						lastpostuserid = " . $vbulletin->userinfo['userid'] . ",
						lastpostusername = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
						lastpostdateline = " . TIMENOW . "
					WHERE catid = $link[catid]
				");

				// Update user post counts
				if ($vba_options['links_update_postcount'])
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid = " . $vbulletin->userinfo['userid']);
				}
			}
			// Add vote if necessary
			if ($vote)
			{
				rate_link($vote, $linkid, 'post');
			}
		}

		// Editing a post
		else
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_links_posts SET
					title = '" . $db->escape_string($post['title']) . "',
					pagetext = '" . $db->escape_string($post['message']) . "',
					iconid = $iconid,
					allowsmilie = $post[enablesmilies],
					showsignature = $signature
				WHERE postid = $postid
			");
			$newpostid = $postid;
		}

		$vbulletin->url = 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&amp;l=' . $linkid . '&amp;postid=' . $newpostid . '#post' . $newpostid;

		if ($_POST['do'] == 'postreply')
		{
			eval(print_standard_redirect('redirect_postthanks'));
		}
		else
		{
			eval(print_standard_redirect('redirect_editthanks'));
		}
	}
}

// ########################## Reply to Link #############################
if ($_REQUEST['do'] == 'newreply' OR $_REQUEST['do'] == 'editpost')
{
	if (!$vba_options['links_allowreplies'])
	{
		print_no_permission();
	}

	$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_INT);
	$p = $vbulletin->input->clean_gpc('r', 'p', TYPE_INT);
	$vote = $vbulletin->input->clean_gpc('r', 'vote', TYPE_INT);
	$iconid = $vbulletin->input->clean_gpc('r', 'iconid', TYPE_INT);

	if ($p)
	{
		$postid = $p;
	}

	// Get post info for quoting or editing
	if ($postid)
	{
		$post = $db->query_first("SELECT postid, linkid, title, pagetext, username, userid, showsignature, allowsmilie, iconid FROM " . TABLE_PREFIX . "adv_links_posts WHERE postid = $postid");

		if (!$post['linkid'])
		{
			eval(standard_error(fetch_error('noid', $vbphrase['link'])));
		}

		$linkid = $post['linkid'];
	}

	$vba_links->load_link();
	$link =& $vba_links->_link;

	$catid = $link['catid'];

	if (!cat_opt('open_for_posts') OR !cat_user_opt('allow_reply'))
	{
		eval(standard_error(fetch_error('adv_links_not_open_for_posts')));
	}

	// Check to see if it's open
	if (!is_category_mod($link['catid']) AND !$link['open'])
	{
		print_no_permission();
	}

	$navbits = fetch_cat_navbits($link['catid']);

	// Check permissions
	if ($_REQUEST['do'] == 'newreply')
	{
		if (!$vba_links->check_cat_perms('canreply'))
		{
			print_no_permission();
		}
	}
	else
	{
		$show['editpost'] = true;

		if ((!$vbulletin->userinfo['userid'] OR ($vbulletin->userinfo['userid'] != $post['userid'] AND !$vba_links->check_cat_perms('caneditothersposts')) OR ($vbulletin->userinfo['userid'] == $post['userid'] AND !$vba_links->check_cat_perms('caneditposts'))) AND !is_category_mod($link['catid']))
		{
			print_no_permission();
		}
	}

	// Got a post with no errors, so start processing
	if (!empty($post) AND empty($errors))
	{
		if ($_REQUEST['do'] == 'editpost')
		{
			if (!$_REQUEST['preview'])
			{
				$newpost['message'] = $post['pagetext'];
				if (!$post['allowsmilie'])
				{
					$checked['disablesmilies'] = 'checked="checked"';
				}
				if ($post['showsignature'])
				{
					$checked['signature'] = 'checked="checked"';
				}
				else
				{
					$checked['signature'] = '';
				}
			}
		}
		else
		{
			// Go Advanced
			if ($_REQUEST['preview'])
			{
				$pagetext = $post['pagetext'];
			}
			// Quote from quickreply
			else if (!$_REQUEST['quickreply'])
			{
				$originalposter = fetch_quote_username($post['username']);
				$pagetext = trim(htmlspecialchars(strip_quotes($post['pagetext'])));
				eval('$newpost[\'message\'] = "' . fetch_template('newpost_quote', 1, 0) . '";');
			}
		}
	}

	if (!isset($post['title']))
	{
		$post['title'] = $link['name'];
	}

	// Construct voting box for preview
	$votesel = array();
	$votesel[$vote] = 'selected="selected"';

	$navbits = fetch_cat_navbits($vba_links->_cat['parentlist']);
	$navbits['showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&amp;l=' . $link['linkid']] = $link['name'];

	if ($_REQUEST['do'] == 'editpost')
	{
		$navbits[''] = $vbphrase['edit_post'];

		if (!isset($checked['parseurl']))
		{
			$checked['parseurl'] = 'checked="checked"';
		}

		if ($post['showsignature'])
		{
			$checked['signature'] = 'checked="checked"';
		}

		if (!$post['allowsmilie'])
		{
			$checked['disablesmilies'] = 'checked="checked"';
		}

		if (($vba_links->check_cat_perms('candeleteposts') AND $vbulletin->userinfo['userid'] == $post['userid']) OR $vba_links->check_cat_perms('candeleteothersposts') OR is_category_mod($link['catid']))
		{
			$show['deleteopt'] = true;
			$show['editpost'] = true;
		}
	}
	else
	{
		// Get title if necessary
		$vbulletin->options['quotetitle'] = 0;
		if ($vba_options['links_quotetitle'])
		{
			$vbulletin->options['quotetitle'] = 1;
		}
		$post['title'] = fetch_quote_title($post['title'], $link['name']);

		// Check URL box if isn't set
		if (!isset($checked['parseurl']))
		{
			$checked['parseurl'] = 'checked="checked"';
		}

		// Signature check box
		if (trim($vbulletin->userinfo['signature']) AND !$preview AND !isset($checked['signature']))
		{
			$checked['signature'] = 'checked="checked"';
		}

		// Last of the navbits
		$navbits[''] = $vbphrase['reply_to_link'];

		// Rating option
		if ($vba_options['links_allowrating'] AND $vba_links->check_cat_perms('canrate', $link) AND cat_user_opt('allow_rating') AND cat_opt('allow_ratings', $link['catid']))
		{
			$show['ratingopts'] = true;
		}

		// Get replies for topic review
		if ($vba_links->check_cat_perms('canviewreplies'))
		{
			$countposts = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_links_posts WHERE linkid = $linkid");
		}

		if (cat_opt('allow_post_smilie'))
		{
			$query['getsmilie'] = true;
		}

		if ($countposts['count'])
		{
			$getposts = $db->query("
				SELECT pagetext, username, dateline " . iif($query['getsmilie'], ', allowsmilie') . "
				FROM " . TABLE_PREFIX . "adv_links_posts
				WHERE linkid = $linkid
					AND visible != 0
				ORDER BY dateline DESC
				LIMIT " . $vbulletin->options['maxposts']
			);
			if ($db->num_rows($getposts))
			{
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
				$show['reviewbits'] = true;

				while ($posts = $db->fetch_array($getposts))
				{
					$posttime = vbdate($vbulletin->options['timeformat'], $posts['dateline']);
					$postdate = vbdate($vbulletin->options['dateformat'], $posts['dateline']);
					$username = $posts['username'];
					$reviewmessage = $bbcode_parser->do_parse($posts['pagetext'], cat_opt('allow_post_html'), $post['allowsmilie'], cat_opt('allow_post_bbcode'), cat_opt('allow_post_bbimgcode'));
					eval('$reviewbits .= "' . fetch_template('newreply_reviewbit') . '";');
				}
			}
			if ($countposts['count'] > $vbulletin->options['maxposts'])
			{
				$show['reviewmore'] = true;
			}
			$db->free_result($getposts);
			unset($posts);
		}
	}

	require_once(DIR . '/includes/functions_editor.php');
	$textareacols = fetch_textarea_width();

	$iconbits = construct_icons($iconid, iif($vba_options['links_allowicons'] AND cat_opt('allow_post_icons'), 1, 0));
	$selectedicon['src'] = str_replace($vbulletin->options['cleargifurl'], $vbulletin->options['bburl'] . '/' . $vbulletin->options['cleargifurl'], $selectedicon['src']);

	$editsmilie = cat_opt('allow_post_smilies');

	if (!empty($post) AND !$post['allowsmilie'])
	{
		$editsmilie = 0;
	}

	// Replace custom BB code images
	if (!empty($vbulletin->bbcodecache))
	{
		foreach ($vbulletin->bbcodecache AS $bbcodeid => $bbcodeinfo)
		{
			if ($bbcodeinfo['buttonimage'])
			{
				$vbulletin->bbcodecache[$bbcodeid]['buttonimage'] = $vbulletin->options['bburl'] . '/' . $bbcodeinfo['buttonimage'];
			}
		}
	}

	// Fake IE6 to so it won't try to use the IE7 popups
	$vbulletin->templatecache['editor_clientscript'] .= '<script type=\"text/javascript\">
    <!--
        var is_ie7 = false;
    -->
    </script>';

	$vbulletin->options['allowbbimagecode'] = (cat_opt('allow_post_bbimgcode') ? 1 : 0);
	// Editor & message area
	$editorid = construct_edit_toolbar($newpost['message'], false, 0, cat_opt('allow_post_smilies'), $editsmilie, 0);

	$messagearea = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $messagearea);

	eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

	// Image verification
	$imagereg = fetch_human_verify('reply');

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('ADV_LINKS_REPLY') . '");');
}

// ############################## Delete Post #############################
if ($_POST['do'] == 'dodeletepost')
{
	$postid = $vbulletin->input->clean_gpc('p', 'postid', TYPE_INT);
	$deletepost = $vbulletin->input->clean_gpc('p', 'deletepost', TYPE_INT);

	$post = $db->query_first("
		SELECT postid, posts.userid, posts.linkid, links.catid
		FROM " . TABLE_PREFIX . "adv_links_posts AS posts
		INNER JOIN " . TABLE_PREFIX . "adv_links AS links ON (posts.linkid = links.linkid)
		WHERE postid = $postid
	");

	if (!$post['postid'])
	{
		$idname = $vbphrase['post'];
		eval(standard_error(fetch_error('noid', $vbphrase['post'])));
	}

	$catid = $post['catid'];

	if ((!$vbulletin->userinfo['userid'] OR ($post['userid'] != $vbulletin->userinfo['userid'] AND !$vba_links->check_cat_perms('candeleteothersposts', $post)) OR (!$vba_links->check_cat_perms('candeleteposts', $post))) AND !is_category_mod($post['catid']))
	{
		print_no_permission();
	}

	if (!$deletepost)
	{
		eval(standard_error(fetch_error('adv_links_nodelete', $vbphrase['message'])));
	}
	else
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_links_posts WHERE postid = $post[postid]");

		$lastpost = $db->query_first("
			SELECT postid, dateline, userid, username
			FROM " . TABLE_PREFIX . "adv_links_posts
			WHERE linkid = $post[linkid]
			ORDER BY dateline DESC
		");

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_links SET
				posts = posts-1,
				lastpostdateline = '$lastpost[dateline]',
				lastpostuserid = '$lastpost[userid]',
				lastpostusername = '" . $db->escape_string($lastpost['username']) . "'
			WHERE linkid = $post[linkid]
		");

		$linkcat = $db->query_first("SELECT catid, lastpostid FROM " . TABLE_PREFIX . "adv_links_categories WHERE catid = $post[catid]");

		$lastpostquery = '';
		if ($linkcat['lastpostid'] == $post['postid'])
		{
			$lastcatpost = $db->query_first("
				SELECT postid, link.name, post.userid, post.username, post.dateline
				FROM " . TABLE_PREFIX . "adv_links_posts AS post
				LEFT JOIN " . TABLE_PREFIX . "adv_links AS link ON (post.linkid = link.linkid)
				WHERE link.catid = $post[catid]
					AND suspended = 0
					AND valid = 1
				ORDER BY post.dateline DESC
			");

			$lastpostquery = ",
				lastpostid = '$lastcatpost[postid]',
				lastpostlinktitle = '" . $db->escape_string($lastcatpost['name']) . "',
				lastpostuserid = '$lastcatpost[userid]',
				lastpostusername = '" . $db->escape_string($lastcatpost['username']) . "',
				lastpostdateline = '$lastcatpost[dateline]'
			";
		}

		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_categories SET postcount = postcount-1 $lastpostquery WHERE catid = $post[catid]");

		$vbulletin->url = 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&l=' . $post['linkid'];
		eval(print_standard_redirect('adv_links_posts_deleted'));
	}
}

// ############################### Rate Link ###############################
if ($_REQUEST['do'] == 'ratelink')
{
	$vba_links->load_link(false, 'canrate');
	$link =& $vba_links->_link;

	if ($vba_options['links_allowrating'] AND $vba_links->check_cat_perms('canrate', $link) AND cat_user_opt('allow_rating') AND cat_opt('allow_ratings', $link['catid']))
	{
		$show['ratelink'] = true;
	}

	eval('print_output("' . fetch_template('adv_links_ratingpopup') . '");');
}

// ############################### Do Rate Link ###############################
if ($_POST['do'] == 'rate')
{
	$vote = $vbulletin->input->clean_gpc('p', 'vote', TYPE_INT);
	$linkid = $vbulletin->input->clean_gpc('p', 'linkid', TYPE_INT);
	$redirpage = $vbulletin->input->clean_gpc('p', 'redirpage', TYPE_NOHTML);

	rate_link($vote, $linkid, $redirpage);
}

// ############################### Close Rating Box ###############################
if ($_REQUEST['do'] == 'closebox')
{
	eval('print_output("' . fetch_template('adv_links_rating_closebox') . '");');
}

?>