<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Check for errors after submission ####################################
function check_link_errors($link)
{
	global $db, $vba_options, $vbulletin, $vbphrase, $_POST, $errors, $imagehash, $imagestamp;

	// Catid
	if (!$link['catid'])
	{
		eval('$errors[] = "' . fetch_error('adv_links_must_choose_category') . '";');
	}
	else
	{
		// Category reciprocal option -
		// Not really error checking, but this seems to be a good place for it
		$catrecip =& $vbulletin->adv_links_cats[$link['catid']]['recipoptions'];

		switch ($catrecip)
		{
			case 3:
				$vba_options['links_recipcheck'] = 0;
			break;

			case 0:
			break;

			default:
				$vba_options['links_recipcheck'] = $catrecip;
		}
	}

	// Missing default fields
	if ($link['linkurl'] == 'http://' OR !$link['linkurl'] OR ($_POST['do'] != 'addlink' AND (!$link['name'] OR !$link['description'])))
	{
		eval('$errors[] = "' . fetch_error('adv_links_missingfiled') . '";');
	}

	// Max title length
	if ($vba_options['links_maxtitlelength'] AND strlen($link['name']) > $vba_options['links_maxtitlelength'])
	{
		eval('$errors[] = "' . fetch_error('adv_links_x_too_long', $vbphrase['title'], vb_number_format(strlen($link['name'])), vb_number_format($vba_options['links_maxtitlelength'])) . '";');
	}

	// Max desc length
	if ($vba_options['links_maxdesclength'] AND strlen($link['description']) > $vba_options['links_maxdesclength'])
	{
		eval('$errors[] = "' . fetch_error('adv_links_x_too_long', $vbphrase['description'], vb_number_format(strlen($link['description'])), vb_number_format($vba_options['links_maxdesclength'])) . '";');
	}

	// Image verification
	if ($_POST['do'] == 'doaddlink')
	{
		$imageerror = check_human_verify('addlink');
	
		if ($imageerror)
		{
			eval('$errors[] = "' . $imageerror . '";');
		}
	}

	// Check that the URL is valid
	if ($vba_options['links_recipcheck'] == 2 AND $_POST['do'] != 'addlink')
	{
		$originalurl = trim(iif($vba_options['links_recipcheck_url'], $vba_options['links_recipcheck_url'], $vbulletin->options['homeurl']));

		$checkurl = fetch_check_url();

		$reciperror = check_for_recip_link($checkurl);

		if ($reciperror === 'invalid')
		{
			eval('$errors[] = "' . fetch_error('adv_links_invalid_reciprocal_url', $checkurl['originalurl']) . '";');
		}
		else if ($reciperror === 'nomatch')
		{
			eval('$errors[] = "' . fetch_error('adv_links_reciprocal_url_must_match') . '";');
		}
	}

	$urlparsed = @parse_url(trim($link['linkurl']));

	// Verify that the website exists
	if ($vba_options['links_verifynew'])
	{
		// Use CURL
		if ($vba_options['links_remotesite'] == 'curl')
		{
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $link['linkurl']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_MAXREDIRS, 10); // follow up to 10 redirections - avoids loops
			curl_setopt($ch, CURLOPT_HEADER, true);
			curl_setopt($ch, CURLOPT_NOBODY, true);

			$linkchk = curl_exec($ch);
			curl_close($ch);

			preg_match_all("/HTTP\/1\.[1|0]\s(\d{3})/", $linkchk, $matches);

			$code = end($matches[1]);

			if(!$linkchk)
			{
				eval('$errors[] = "' . fetch_error('adv_links_invalid_url') . '";');
			}
			else if($code != 200)
			{
				eval('$errors[] = "' . fetch_error('adv_links_invalid_url') . '";');
			}
		}

		// Use fsockopen()
		else
		{
			if(!@fsockopen($urlparsed['host'], 80, $errno, $errstr, 20))
			{
				eval('$errors[] = "' . fetch_error('adv_links_invalid_url') . '";');
			}
		}
	}

	// Check for duplicates
	if (!$vba_options['links_allowdupes'] AND $_POST['do'] != 'doeditlink')
	{
		$finddomain = strip_url($urlparsed['host']);

		$checkdupe = $db->query_read("SELECT linkid, linkurl, valid FROM " . TABLE_PREFIX . "adv_links WHERE linkurl LIKE '%$finddomain%' " . iif(!$dupe, "AND linkid != '$link[linkid]'") . " LIMIT 1");
		while ($dupe = $db->fetch_array($checkdupe))
		{
			$dupe['urlparsed'] = @parse_url($dupe['linkurl']);
			$dupe['linkurl'] = strip_url($dupe['urlparsed']['host']);

			if ($dupe['linkurl'] == $finddomain)
			{
				$errors[] = fetch_error('adv_links_duplicate', htmlspecialchars($link['linkurl']), iif($dupe['valid'], fetch_error('adv_links_duplicate_viewlink', $dupe['linkid']), ''));
			}
		}
	}

	// Custom fields
	if ($_POST['do'] != 'addlink')
	{
		$cfields = array();
		$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields");
		while ($custom = $db->fetch_array($customfields))
		{
			if (!check_custom_field_cats($custom, $link))
			{
				continue;
			}

			if ($custom['required'] AND empty($_POST['field' . $custom['fieldid']]))
			{
				eval('$errors[] = "' . addslashes(fetch_error('requiredfieldmissing', $custom['title'])) . '";');
			}
		}
	}

	return $errors;
}

// ##### Check custom field cats ##############################################
function check_custom_field_cats(&$field, &$link)
{
	if ($field['catids'] == 'all')
	{
		return true;
	}

	$field['catids'] = explode(',', $field['catids']);

	if (!in_array($link['catid'], $field['catids']) AND !$field['incsubs'])
	{
		return false;
	}

	// Check for fields that belong to a parent category
	if ($field['incsubs'])
	{
		$subcats = array();
		foreach ($field['catids'] AS $fcat)
		{
			$subcats = array_merge($subcats, fetch_category_children($fcat));
		}
		if (!in_array($link['catid'], $subcats))
		{
			return false;
		}
	}

	return true;
}

// ######################### Create Custom Fields #############################
function construct_custom_fieldbits($link, $custominfo = '', $editing = false, $admin = false, $makearray = false)
{
	global $db, $vbphrase;

	if (empty($custominfo))
	{
		$custominfo = array();
		$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields ORDER BY displayorder");
		while ($field = $db->fetch_array($customfields))
		{
			$custominfo[] = $field;
		}
		$db->free_result($customfields);
		unset($field);
	}

	if (!empty($custominfo))
	{
		foreach ($custominfo AS $field)
		{
			// Make sure the field applies to this category

			if (!check_custom_field_cats($field, $link))
			{
				continue;
			}

			// We've made it this far, so start processing them
			$fieldname = 'field' . $field['fieldid'];
			$inputname = 'field' . $field['fieldid'] . iif($makearray, '[' . $link['linkid'] . ']');

			if ($field['options'])
			{
				$field['options'] = explode("\n", $field['options']);
			}

			if (!is_array($link[$fieldname]))
			{
				$link[$fieldname] = htmlspecialchars($link[$fieldname]);
			}

			switch ($field['type'])
			{
				case 'textarea':
					$inputbox = '<textarea class="bginput" cols="40" name="' . $inputname . '" rows="6">' . $link[$fieldname] . '</textarea>';
				break;

				case 'select':

					if (!empty($field['options']))
					{
						$inputbox = '<select name="' . $inputname . '">';
						$inputbox .= '<option value="">' . $vbphrase['please_select_one'] . '</option>';

						foreach ($field['options'] AS $option)
						{
							$option = trim($option);
							$inputbox .= '<option ' . iif($link[$fieldname] == $option, 'selected="selected"') . ' value="' . $option . '">' . $option . '</option>';
						}
						$inputbox .= '</select>';
					}
				break;

				case 'radio':

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<div><label for="' . $inputname . '_' . $key . '"><input id="' . $inputname . '_' . $key . '" name="' . $inputname . '" ' . iif($link[$fieldname] == $option, 'checked="checked"') . ' type="radio" value="' . $option . '">' . $option . '</label></div>';
					}
				break;

				case 'checkbox':

					if (!is_array($link[$fieldname]) AND !$editing)
					{
						$link[$fieldname] = array();
					}
					else if ($editing)
					{
						$link[$fieldname] = explode(', ', $link[$fieldname]);
					}

					$optarray = array();
					foreach ($link[$fieldname] AS $okey => $ovalue)
					{
						$optarray[] = htmlspecialchars($ovalue);
					}

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $inputname . '_' . $key . '"><input id="' . $inputname . '_' . $key . '" name="' . $inputname . '[]" ' . iif(in_array($option, $optarray), 'checked="checked"') . ' type="checkbox" value="' . $option . '">' . $option . '</label><br />';
					}
				break;

				default:
					$inputbox = '<input class="bginput" name="' . $inputname . '" size="35" value="' . $link[$fieldname] . '" />';

			}

			if ($admin)
			{
				print_label_row($field['title'], $inputbox);
			}
			else
			{
				eval('$cfbits .= "' . fetch_template('adv_links_addlink_custombits') . '";');
			}
			unset($inputbox);
		}
	}

	return $cfbits;
}

// ######################## Sort custom fields to insert into the db ####################
function construct_customfields_sql($linkid, $add = true, $makearray = false)
{
	global $db, $_POST, $link;

	if (!$add AND !$check = $db->query_first("SELECT lid FROM " . TABLE_PREFIX . "adv_links_cfields_entries WHERE lid = $linkid"))
	{
		$add = true;
	}

	if (cat_opt('allow_custom_links', $link['catid']))
	{
		require_once(DIR . '/includes/functions_newpost.php');
	}

	$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields");
	while ($custom = $db->fetch_array($customfields))
	{
		$thisfield = 'field' . $custom['fieldid'];

		// Form an array if we have multiple links
		if ($makearray)
		{
			$fieldname = $_POST[$thisfield][$linkid];
		}
		else
		{
			$fieldname = $_POST[$thisfield];
		}

		// Check field length
		if (strlen($fieldname) > $values['maxlength'] AND $values['maxlength'])
		{
			$fieldname = substr($fieldname, 0, $values['maxlength']);
		}

		if (is_array($fieldname))
		{
			$fieldname = implode(', ', array_map('htmlspecialchars', $fieldname));
		}

		if (cat_opt('allow_custom_links', $link['catid']))
		{
			$fieldname = convert_url_to_bbcode($fieldname);
		}

		if ($add)
		{
			$insert['fields'] .= ',' . $thisfield;
			$insert['values'] .= ", '" . $db->escape_string($fieldname) . "'";
		}
		else
		{
			$insert['fields'] .= ", $thisfield = '" . $db->escape_string($fieldname) . "'";
		}
	}

	if ($add)
	{
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_links_cfields_entries (lid $insert[fields]) VALUES ($linkid $insert[values])");
	}
	else if (!empty($insert))
	{
		$insert['fields'] = substr($insert['fields'], 1);
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_links_cfields_entries SET $insert[fields] WHERE lid = $linkid");
	}
}

// ##### Strip URL ############################################################
function strip_url($linkurl)
{
	$linkurl = str_replace(array('http://www.', 'http://'), '', $linkurl);

	if (substr($linkurl, strlen($linkurl) - 1, strlen($linkurl) - 1) == '/')
	{
		$linkurl = substr($linkurl, 0, strlen($linkurl) - 1);
	}

	return $linkurl;
}

// ########################## Check URL #######################
function check_url_status($url)
{
	global $statusarray, $vba_options;

	// Use CURL
	if ($vba_options['links_remotesite'] == 'curl')
	{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HEADER, true);
		curl_setopt($ch, CURLOPT_NOBODY, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_MAXREDIRS, 10); // Follow up to 10 redirects
		curl_setopt($ch, CURLOPT_TIMEOUT, 10);
		$linkchk = curl_exec($ch);
		curl_close($ch);
		preg_match_all("/HTTP\/1\.[1|0]\s(\d{3})/", $linkchk, $matches);

		$return['code'] = end($matches[1]);

	}
	// Else use fsockopen()
	else
	{
		$urlArray = parse_url($url . '/');
		if (!$urlArray['port'])
		{
			$urlArray['port'] = 80;
		}
		if (!$urlArray['path'])
		{
			$urlArray['path'] = '/';
		}
		$sock = @fsockopen($urlArray['host'], $urlArray['port'], $errnum, $errstr, 10);
		if (!$sock)
		{
			$return['code'] = 'Dd';
		}
		else
		{
			$dump .= "HEAD $urlArray[path] HTTP/1.1\r\n";
			$dump .= "User-Agent: Link Checker\r\n";
			$dump .= "Host: $urlArray[host]\r\nConnection: close\r\n";
			$dump .= "Connection: close\r\n\r\n";
			@fputs($sock, $dump);
			while($str = @fgets($sock, 1024))
			{
				if (eregi("^http/[0-9]+.[0-9]+ ([0-9]{3}) [a-z ]*", $str))
				{
					$return['code'] = trim(eregi_replace("^http/[0-9]+.[0-9]+ ([0-9]{3}) [a-z ]*", "\\1", $str));
				}
				if (eregi('^Content-Type: ', $str))
				{
					$return['contentType'] = trim(eregi_replace('^Content-Type: ', '', $str));
				}
			}
			@fclose($sock);
		}
	}

	$status['code'] = $return['code'];
	$status['status'] = $status_array["$return[code]"];

	return $status;
}

// ##### Fetch Check URL ######################################################
function fetch_check_url()
{
	global $vba_options, $vbulletin;

	if (!$vba_options['links_recipcheck'])
	{
		return false;
	}

	$checkurl = trim(iif($vba_options['links_recipcheck_url'], $vba_options['links_recipcheck_url'], $vbulletin->options['homeurl']));

	$return['originalurl'] = $checkurl;

	$urllen = strlen($checkurl);

	if (substr($checkurl, -1, 1) == '/')
	{
		$urllen = $urllen - 1;
		$checkurl = substr($checkurl, 0, $urllen);
	}

	$nocheck = false;
	if (substr($checkurl, 0, 11) == 'http://www.')
	{
		$return['checkfor'] = 'http://';
		$return['checkurl'] = substr($checkurl, 11, $urllen);
	}
	else if (substr($checkurl, 0, 7) == 'http://')
	{
		$return['checkfor'] = 'http://';
		$return['checkurl'] = substr($checkurl, 7, $urllen);
	}
	else if (substr($checkurl, 0, 8) == 'https://')
	{
		$return['checkfor'] = 'https://';
		$return['checkurl'] = substr($checkurl, 8, $urllen);
	}
	else if (substr($checkurl, 0, 6) == 'ftp://')
	{
		$return['checkfor'] = 'ftp://';
		$return['checkurl'] = substr($checkurl, 6, $urllen);
	}
	else
	{
		return false;
	}

	return $return;
}

// ##### Check for a reciprocal link ##########################################
function check_for_recip_link($checkurl)
{
	global $link, $vba_options, $errors;

	if (!is_array($checkurl))
	{
		return true;
	}

	$getlinkurl = @parse_url($link['linkurl']);
	$getrecipurl = @parse_url($link['linkrecipurl']);

	if (!$getrecipurl['host'])
	{
		return 'invalid';
	}
	else if ($getlinkurl['host'] != $getrecipurl['host'])
	{
		return 'nomatch';
	}
	else
	{
		// Use CURL if available
		if ($vba_options['links_remotesite'] == 'curl')
		{
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $link['linkrecipurl']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_MAXREDIRS, 10); // follow up to 10 redirections - avoids loops
			$recipcheck = curl_exec($ch);
			curl_close($ch);
		}
		// Use file_get_contents()
		else
		{
			$recipcheck = @file_get_contents($link['linkrecipurl']);
		}

		$recipcheck = strtolower($recipcheck);

		$checkurl['checkfor'] = strtolower($checkurl['checkfor']);

		// Quick string check
		if (!stristr($recipcheck, $checkurl['checkfor'] . $checkurl['checkurl']) AND !stristr($recipcheck, $checkurl['checkfor'] . 'www.' . $checkurl['checkurl']))
		{
			return 'invalid';
		}

		// Full check
		preg_match_all("/<a *href=[\"' ]?([^\"' >]+)[\"' ]?[^>]*>/i", $recipcheck, $hreftags);

		$hreftags = array_map('strtolower', $hreftags[1]);

		if (!in_array($checkurl['checkfor'] . $checkurl['checkurl'], $hreftags) AND !in_array($checkurl['checkfor'] . 'www.' . $checkurl['checkurl'], $hreftags))
		{
			return 'invalid';
		}
	}

	return true;
}

// ##### Fetch Meta Tags ######################################################
function fetch_meta()
{
	global $vba_options, $link;

	if (!$haderrors AND $vba_options['links_autofill'])
	{
		$meta = @get_meta_tags($link['linkurl']);

		$link['description'] = substr(htmlspecialchars($meta['description']), 0, $vba_options['links_maxdesclength']);
		$link['keywords'] = htmlspecialchars($meta['keywords']);

		if ($meta['title'])
		{
			$link['name'] = htmlspecialchars($meta['title']);
		}
		else
		{
			// Try to get the title if it's not in the meta tags
			if ($stream = @fopen($link['linkurl'], 'r'))
			{
				$webpage = fread($stream, 2000);

				fclose($stream);

				if ($webpage)
				{
					$titlestart = stripos($webpage, '<title>');

					if ($titlestart !== false)
					{
						$titlestart += 7;
						$link['name'] = htmlspecialchars(substr($webpage, $titlestart, (stripos($webpage, '</title>') - $titlestart)));
					}
				}
			}
		}

		$link['name'] = substr($link['name'], 0, $vba_options['links_maxtitlelength']);

	}
}

// ##### Clean Keywords #######################################################
function clean_keywords($words, $frommeta = false)
{
	global $vba_options, $errors;

	$words = explode(' ', htmlspecialchars(str_replace(',', ' ', $words)));
	if (empty($words))
	{
		return;
	}

	$cleanwords = array();
	$longwords = array();

	foreach ($words AS $wordkey => $word)
	{
		$word = trim($word);
		$wordlen = strlen($word);
		if ($vba_options['links_maxkeywordlength'] AND $wordlen > $vba_options['links_maxkeywordlength'] AND !$frommeta)
		{
			$longwords[] = $word;
		}
		else if (trim($word) AND !in_array($word, $cleanwords))
		{
			$cleanwords[] = $word;
		}
	}

	if ($frommeta AND $vba_options['links_maxkeywords'])
	{
		$cleanwords = array_slice($cleanwords, 0, $vba_options['links_maxkeywords']);
	}

	if ($vba_options['links_maxkeywords'] AND sizeof($cleanwords) > $vba_options['links_maxkeywords'])
	{
		eval('$errors[] = "' . fetch_error('adv_links_too_many_keywords', sizeof($cleanwords), $vba_options['links_maxkeywords']) . '";');
	}

	if (!empty($longwords))
	{
		eval('$errors[] = "' . fetch_error('adv_links_keyword_too_long', implode(', ', $longwords), $vba_options['links_maxkeywordlength']) . '";');
	}

	return implode(' ', $cleanwords);
}

?>