<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('VBA_SCRIPT', 'links_directory');

require_once('./links_config.php');

chdir($forumpath);

$specialtemplates = array_merge(
	array(
		'adv_links_cats',
		'adv_links_mods',
		'adv_links_opts',
		'adv_links_perms'
	),
	$specialtemplates
);

$globaltemplates = array_merge(
	array(
		'adv_links_navbar',
		'adv_links_navbar_newestbits',
		'adv_links_categoryjump',
		'adv_links_footer'
	),
	$globaltemplates
);

$phrasegroups = array_merge(
	array(
		'adv_links'
	),
	$phrasegroups
);

require_once('./global.php');

// Redirect if using cat jump (have to have it here to include the session)
if ($redirect)
{
	header("Location: $redirect");
	exit;
}

require_once(DIR . '/includes/class_vba_links.php');
require_once(DIR . '/includes/functions_vba_links.php');

if (is_array($vba_options))
{
	$vba_options = array_merge($vba_options, $vbulletin->adv_links_opts);
}
else
{
	$vba_options =& $vbulletin->adv_links_opts;
}

// Load the $vba_links class
$vba_links =& new vba_links();
$vba_links->vbulletin =& $vbulletin;

// ################################ Replacements ##############################
// $headinclude replacement
$headinclude = str_replace(
	array(
		'"clientscript',
		'url(images/',
		'name="generator" content="'
	),
	array(
		'"' . $vbulletin->options['bburl'] . '/clientscript',
		'url(' . $vbulletin->options['bburl'] . '/images/',
		'name="generator" content="vBadvanced, '
	),
	$headinclude
);

// $navbar replacement
$navreplace = array(
	'find' => array(
		'"clientscript',
		'\'misc.php'
	),
	'replace' => array(
		'"' . $vbulletin->options['bburl'] . '/clientscript',
		'\'' . $vbulletin->options['bburl'] . '/misc.php'
	)
);

switch ($vba_options['links_navbarhomelink'])
{
	case 0:
		$navreplace['find'][] =	'$GLOBALS[\'vbulletin\']->options[\'bbtitle\']';
		$navreplace['find'][] =	'$GLOBALS[\'vbulletin\']->options[\'forumhome\'] . ".php';

		$navreplace['replace'][] = '$vba_options[links_title]';
		$navreplace['replace'][] = '$vba_options[links_homeurl] . "/index.php';
	break;

	case 1:
		$navreplace['find'][] =	'$GLOBALS[\'vbulletin\']->options[\'bbtitle\']';
		$navreplace['find'][] =	'$GLOBALS[\'vbulletin\']->options[\'forumhome\'] . ".php';

		$navreplace['replace'][] = '$GLOBALS[\'vbulletin\']->options[\'hometitle\']';
		$navreplace['replace'][] = '$GLOBALS[\'vbulletin\']->options[\'homeurl\'] . "';
	break;

	case 2:
		$navreplace['find'][] =	'$GLOBALS[\'vbulletin\']->options[\'forumhome\'] . ".php';

		$navreplace['replace'][] = '$GLOBALS[\'vbulletin\']->options[\'bburl\'] . "/" . $GLOBALS[\'vbulletin\']->options[\'forumhome\'] . ".php';
	break;
}

replace_template_filenames('navbar', $navreplace);

$vbphrase['private_messages_nav'] = str_replace('"private.php', '"' . $vbulletin->options['bburl'] . '/private.php', $vbphrase['private_messages_nav']);

// Hook replacements (from navbar)
$hookreplacenames = array(
	'navbar_buttons_left',
	'navbar_buttons_right',
	'navbar_search_menu',
	'navbar_quick_links_menu_pos1',
	'navbar_quick_links_menu_pos2',
	'navbar_quick_links_menu_pos3'
);

if (!empty($repfiles))
{
	foreach ($hookreplacenames AS $hookr)
	{
		if (!$template_hook[$hookr])
		{
			continue;
		}

		$template_hook[$hookr] = str_replace(
			$repfiles['find'],
			$repfiles['replace'],
			$template_hook[$hookr]
		);		
	}
}

// ##### header replacement
replace_template_filenames('header');

// Temp fix - just re-eval the header for replacements
if ($vba_options['global_header_replace'])
{
	eval('$header = "' . fetch_template('header') . '";');
}

// Cron replacement
$cronimage = '';
if ($vbulletin->cron <= TIMENOW)
{
	$cronimage = '<img src="' . $vbulletin->options['bburl'] . '/cron.php?' . $vbulletin->session->vars['sessionurl'] . '&amp;rand=' . vbrand(1, 1000000) . '" alt="" width="1" height="1" border="0" />';
}

// $footer replacement
replace_template_filenames(
	'footer',
	array(
		'find' => array(
			'href=\"$admincpdir',
			'href=\"$modcpdir'
		),
		'replace' => array(
			'href=\"' . $vbulletin->options['bburl'] . '/' . $admincpdir,
			'href=\"' . $vbulletin->options['bburl'] . '/' . $modcpdir
		)
	)
);

eval('$footer = "' . fetch_template('adv_links_footer') . '";');
eval('$footer .= "' . fetch_template('footer') . '";');

$footer = str_replace($footerreplace['find'], $footerreplace['replace'], $footer) . '<!-- vBadvanced -->';

if ($shownewpm)
{
	eval('$pmscript = "' . fetch_template('pm_popup_script') . '";');
	$footer .= str_replace('"private.php', '"' . $vbulletin->options['bburl'] . '/private.php', $pmscript);
}

if (!$vba_options['links_active'])
{
	if (($permissions['adminpermissions'] & CANCONTROLPANEL) OR ($permissions['adminpermissions'] AND ISMODERATOR))
	{
		eval('$warning = "' . fetch_template('adv_links_inactive_warning') . '";');
		$header = $warning . $header;
		$footer .= $warning;
	}
	else
	{
		eval(standard_error($vba_options['links_closedmessage']));
	}
}

// ########################## Links Permissions #############################
$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

if (empty($vbulletin->userinfo['usergrouparray']))
{
	$vbulletin->userinfo['usergrouparray'] = array(1);
}

$vba_links->default_permissions();

// Check main permissions
if (!$vba_links->check_perms('canviewlinksdir'))
{
	print_no_permission();
}

$vba_links->fetch_category_perms();

// First element of navbar
if (THIS_SCRIPT != 'links_index' AND $vba_options['links_navbarhomelink'])
{
	$navbits["$vba_options[links_homeurl]/index.php"] = $vba_options['links_title'];
}

// ###################### Show Variables ##############################
if ($vba_links->check_perms('cansearch'))
{
	$show['searchlinks'] = true;
}
if ($vba_options['links_browsedropdown'])
{
	$show['linkbit_popup'] = true;
}
if ($vba_options['links_showmodcolumn'])
{
	$show['modcolumn'] = true;
}

$show['modoptions'] = false;
if ($vbulletin->userinfo['userid'])
{
	if ($vba_options['links_allowsubscribe'])
	{
		$show['subscribe'] = true;
	}
	if ($vba_options['links_allowfav'] AND $vbulletin->userinfo['userid'])
	{
		$show['favorites'] = true;
	}
	if ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
	{
		$show['modoptions'] = true;
	}
	else if (!empty($vbulletin->adv_links_mods))
	{
		foreach ($vbulletin->adv_links_mods AS $modcatid => $moderator)
		{
			if ($moderator[$vbulletin->userinfo['userid']])
			{
				$show['modoptions'] = true;
			}
		}
	}
}

// ##### Common Globals
$vbulletin->input->clean_array_gpc('r', array(
	'linkid' => TYPE_INT,
	'l' => TYPE_INT,
	'catid' => TYPE_NOHTML,
	'c' => TYPE_NOHTML
));

if ($vbulletin->GPC['l'])
{
	$vbulletin->GPC['linkid'] = $vbulletin->GPC['l'];
}

if (isset($vbulletin->GPC['c']) AND intval($vbulletin->GPC['c']))
{
	$vbulletin->GPC['catid'] = $vbulletin->GPC['c'];
}

$catid =& $vbulletin->GPC['catid'];
$linkid =& $vbulletin->GPC['linkid'];

if ($catid == 'newlinks' OR $catid == 'poplinks' OR $catid == 'favorites' OR $catid == 'subscriptions' OR $catid == 'member' OR $catid == 'searchresults')
{
	if (!$_REQUEST['do'])
	{
		$_REQUEST['do'] = $catid;
	}
}
else
{
	$catid = intval($catid);

	$vba_links->_cat =& $vbulletin->adv_links_cats[$catid];
}

// ######################### Links Navbar Width ##########################
$lnavrows = 3;
if ($vba_options['links_newlinklimit'])
{
	$lnavrows++;
}
if ($vba_options['links_poplinklimit'])
{
	$lnavrows++;
}
if ($vba_options['links_linktous'])
{
	$show['link_to_us'] = true;
	$lnavrows++;
}
if ($show['modoptions'])
{
	$lnavrows++;
}
if ($vba_links->check_perms('cancreatecats') AND $vba_options['links_allow_user_cats'])
{
	$show['managecats'] = true;
}

if ($show['favorites'] OR $show['subscribe'] OR $show['managecats'])
{
	$show['mystuff'] = true;
	$lnavrows++;
}

$lnavbarwidth = intval(100 / $lnavrows) . '%';

if ($vba_options['links_newlinklimit'])
{
	foreach (explode(',', $vba_options['links_newlinklimit']) AS $ndatecut)
	{
		$show['newlinknav'] = true;
		$dayphrase = construct_phrase($vbphrase['last_x_days'], $ndatecut);
		eval('$newlinknavbits .= "' . fetch_template('adv_links_navbar_newestbits') . '";');
		$show['newlinknav'] = false;
		eval('$newpostnavbits .= "' . fetch_template('adv_links_navbar_newestbits') . '";');
	}
}

eval('$linksnav = "' . fetch_template('adv_links_navbar') . '";');

define('IS_VB_37', (substr($vbulletin->options['templateversion'], 0, 3) == 3.7) ? true : false);
?>