<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'links_search');

$globaltemplates = array();
$specialtemplates = array();

$actiontemplates = array(
	'search' => array(
		'ADV_LINKS_SEARCH',
		'adv_links_search_custombits',
		'humanverify',
		'imagereg'
	)
);

$actiontemplates['none'] =& $actiontemplates['search'];

$phrasegroups = array('search');

require_once('./links_global.php');

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'search';
}

// ############################### Search results ###############################
if ($_REQUEST['do'] == 'searchresults')
{
	$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);

	$catids = $vbulletin->input->clean_gpc('r', 'catids', TYPE_ARRAY);
	$fields = $vbulletin->input->clean_gpc('r', 'fields', TYPE_ARRAY);
	$cfields = $vbulletin->input->clean_gpc('r', 'cfields', TYPE_ARRAY);
	$string = $vbulletin->input->clean_gpc('r', 'string', TYPE_NOHTML);
	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$username = $vbulletin->input->clean_gpc('r', 'username', TYPE_NOHTML);
	$subcats = $vbulletin->input->clean_gpc('r', 'subcats', TYPE_INT);
	$quicksearch = $vbulletin->input->clean_gpc('r', 'quicksearch', TYPE_INT);
	$dateline = $vbulletin->input->clean_gpc('r', 'dateline', TYPE_INT);

	$validfields = array(
		'name',
		'description',
		'keywords',
		'pagetext',
		'posts'
	);
	require_once(DIR . '/includes/functions_search.php');
	require_once(DIR . '/includes/functions_misc.php');

	$starttimecounter = microtime();

	// Image verification
	check_human_verify('search');

	// Find last search
	if ($vbulletin->options['searchfloodtime'])
	{
		if ($checksearch = $db->query_first("SELECT dateline FROM " . TABLE_PREFIX . "adv_links_search WHERE userid = '" . $vbulletin->userinfo['userid'] . "' AND dateline > " . (TIMENOW - $vbulletin->options['searchfloodtime']) . ""))
		{
			eval(standard_error(fetch_error(
				'searchfloodcheck',
				$vbulletin->options['searchfloodtime'],
				($vbulletin->options['searchfloodtime'] - (TIMENOW - $checksearch['dateline']))
			)));
		}
	}

	if ($quicksearch)
	{
		$fields = array('name', 'keywords', 'description');
		$subcats = 1;
		$catids = array('0');
	}
	// Clean fields if not from quick search
	else
	{
		$fields = array_intersect($fields, $validfields);
	}

	if (!$string AND !$username)
	{
		eval(standard_error(fetch_error('searchspecifyterms')));
	}

	if (empty($fields) AND empty($cfields))
	{
		eval(standard_error(fetch_error('adv_links_error_no_search_fields')));
	}

	// ##### Custom Fields
	if (!empty($cfields))
	{

		$validcustom = array();
		$getcustom = $db->query_read("SELECT fieldid FROM " . TABLE_PREFIX . "adv_links_cfields");
		while ($custom = $db->fetch_array($getcustom))
		{
			$validcustom[] = 'field' . $custom['fieldid'];
		}

		$cfields = array_intersect($cfields, $validcustom);

		if (!empty($cfields))
		{
			$fields = array_merge($fields, $cfields);
			$cfjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'adv_links_cfields_entries AS customfields ON (links.linkid = customfields.lid)';
		}
	}

	// ##### Search string
	if ($string)
	{
		$condition = '(';

		$strcount = false;
		foreach (explode(' ', $string) AS $sstring)
		{
			$concount = false;

			if ($strcount)
			{
				$condition .= '(';
			}
			foreach ($fields AS $fieldname)
			{
				switch ($fieldname)
				{
					case 'pagetext':
						$fieldname = 'posts.pagetext';
						$postjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'adv_links_posts AS posts ON (posts.linkid = links.linkid)';
					break;

					case 'name':
						$fieldname = 'links.' . $fieldname;
					break;
				}

				if ($concount)
				{
					$condition .= ' OR ';
				}

				if ($_REQUEST['matchwholeword'])
				{
					$condition .= "$fieldname LIKE '% " . sanitize_word_for_sql($sstring) . " %'";
				}
				else
				{
					$condition .= "$fieldname LIKE '%" . sanitize_word_for_sql($sstring) . "%'";
				}

				$concount = true;
			}
			$condition .= ') AND ';

			$strcount = true;
		}
	}

	// ##### Search Username
	if ($username)
	{
		$username = sanitize_word_for_sql($username);

		if (!$exactname AND strlen($username) < 3)
		{
			eval(standard_error(fetch_error('searchnametooshort')));
		}

		$getuserids = $db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username " . iif($exactname, '= ' . $username, 'LIKE \'%' . $username . '%\''));
		if ($db->num_rows($getuserids))
		{
			$searchusers = array();
			while ($userinfo = $db->fetch_array($getuserids))
			{
				$searchusers["$userinfo[userid]"] = $userinfo['username'];
			}
		}
		else
		{
			eval(standard_error(fetch_error('invalidid', $vbphrase['user'])));
		}
		$userids = implode(',', array_keys($searchusers));
		$condition .= ' (links.userid IN(' . $userids . ')' . iif (in_array('pagetext', $fields), ' OR posts.userid IN(' . $userids . ')') . ') AND';

	}

	// Date limits
	if ($dateline)
	{
		$dateline = ($dateline == 'lastvisit') ? $vbulletin->userinfo['lastvisit'] : (TIMENOW - ($dateline * 86400));

		$condition .= ' links.dateline ' . iif($_POST['new_old'] == 'older', '<=', '>=') . $dateline . ' AND';
	}

	// Replycount
	if ($_POST['replycount'] OR $_POST['leastmost'] == 'most')
	{
		$condition .= ' posts ' . iif($_POST['leastmost'] == 'least', '>=', '=<') . ' ' . intval($_POST['replycount']) . ' AND';
	}

	if (empty($catids) AND $catids != 0)
	{
		eval(standard_error(fetch_error('adv_links_search_nocat')));
	}

	require_once(DIR . '/includes/functions_vba_links_cats.php');

	if (!empty($catids) AND in_array('favorites', $catids))
	{
		$searchquery = "
			SELECT favorites.linkid
			FROM " . TABLE_PREFIX . "adv_links_favorites AS favorites
			LEFT JOIN " . TABLE_PREFIX . "adv_links AS links ON (favorites.linkid = links.linkid)
			$postjoin
			$cfjoin
			WHERE suspended = 0 AND $condition valid = 1
		";
	}
	else
	{
		$catids = array_map('intval', $catids);

		$privcats = fetch_private_categories(false, 'cansearch');

		if (empty($catids) OR $catids == array(0))
		{
			if (!empty($privcats))
			{
				$condition .= ' links.catid NOT IN(' . implode(', ', $privcats) . ') AND ';
			}
		}
		else
		{
			if ($subcats)
			{
				foreach ($catids AS $scats)
				{
					$catids = array_merge($catids, fetch_category_children($scats));
				}
			}

			$catids = array_diff($catids, $privcats);

			if (empty($catids))
			{
				eval(standard_error(fetch_error('adv_links_search_nocat')));
			}

			$condition .= ' links.catid IN(' . implode(',', $catids) . ') AND ';
		}

		$searchquery = "
			SELECT links.linkid
			FROM " . TABLE_PREFIX . "adv_links AS links
			$postjoin
			$cfjoin
			WHERE suspended = 0 AND $condition valid = 1
		";
	}

	if ($vbulletin->options['maxresults'])
	{
		$searchquery .= 'LIMIT ' . $vbulletin->options['maxresults'];
	}

	// Get Link ids
	$linkidarray = array();
	$getlinks = $db->query_read($searchquery);
	while ($links = $db->fetch_array($getlinks))
	{
		$linkidarray[] = $links['linkid'];
	}
	$db->free_result($getlinks);
	unset($links);

	$linkcount = sizeof($linkidarray);
	if (!$linkcount)
	{
		eval(standard_error(fetch_error('searchnoresults', '')));
	}

	if (!empty($searchusers))
	{
		$usernames = serialize($searchusers);
	}

	// #### Insert it into the table
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_links_search
			(string, username, sfields, catids, dateline, userid, linkids, orderby, direction, wholeword, numresults, searchtime)
		VALUES (
			'" . $db->escape_string($string) . "',
			'" . iif(!empty($searchusers), $db->escape_string(serialize($searchusers))) . "',
			'" . $db->escape_string(implode(',', $fields)) . "',
			'" . $db->escape_string(implode(',', $catids)) . "',
			" . TIMENOW . ",
			" . $vbulletin->userinfo['userid'] . ",
			'" . $db->escape_string(implode(', ', $linkidarray)) . "',
			'" . $db->escape_string($orderby) . "',
			'" . $db->escape_string($direction) . "',
			" . intval($_REQUEST['matchwholeword']) . ",
			$linkcount,
			'" . number_format(fetch_microtime_difference($starttimecounter), 3) . "')
	");

	$searchid = $db->insert_id();

	$vbulletin->url = 'browselinks.php?do=searchresults&amp;searchid=' . $searchid;
	eval(print_standard_redirect('search'));

}


// ############################### Main search page ###############################
if ($_REQUEST['do'] == 'search')
{
	if (!$catid)
	{
		$selected[0] = 'selected="selected"';
	}

	$fieldcount = iif($vba_options['links_allowreplies'], 1, 0);

	$customfields = $db->query("
			SELECT fieldid, title
			FROM " . TABLE_PREFIX . "adv_links_cfields
			WHERE searchable = 1
			ORDER BY displayorder
	");
	while ($field = $db->fetch_array($customfields))
	{
		$fieldcount++;
		if ($fieldcount == 2)
		{
			$customfieldboxes .= '</tr><tr>';
			$fieldcount = 0;
		}
		eval('$customfieldboxes .= "' . fetch_template('adv_links_search_custombits') . '";');
	}

	$categorylist = print_cat_select($catid, 'search');

	if (empty($categorylist))
	{
		print_no_permission();
	}

	// Image Verification
	$imagereg = fetch_human_verify('search');

	$navbits[''] = $vbphrase['search'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('ADV_LINKS_SEARCH') . '");');
}

?>