<?php
// ++=========================================================================++
// || vBadvanced Links Directory v2.0.1 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'links_showlink');

$specialtemplates = array(
	'bbcodecache',
	'iconcache',
	'smiliecache'
);

$globaltemplates = array();

$actiontemplates = array(
	'showdetails' => array(
		'ADV_LINKS_SHOWLINK',
		'adv_links_ratingbit',
		'adv_links_showlink_custombits',
		'adv_links_showlink_keywordbit',
		'bbcode_code',
		'bbcode_html',
		'bbcode_php',
		'bbcode_quote',
		'editor_clientscript',
		'editor_jsoptions_font',
		'editor_jsoptions_size',
		'im_aim',
		'im_icq',
		'im_msn',
		'im_skype',
		'im_yahoo',
		'postbit',
		'postbit_ip',
		'postbit_onlinestatus',
		'postbit_reputation',
		'postbit_wrapper',
		'showthread_quickreply'
	)
);

$phrasegroups = array(
	'postbit',
	'showthread',
	'posting'
);

require_once('./links_global.php');

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'showlink';
}

// ############################### Go to URL ###############################
if ($_REQUEST['do'] == 'showlink')
{
	$vba_links->load_link();

	$db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "adv_links SET views = views+1 WHERE linkid = $linkid");

	$vbulletin->url = $vba_links->_link['linkurl'];

	eval(print_standard_redirect('adv_links_transferring'));
}

// ##### View link details ####################################################
if ($_REQUEST['do'] == 'showdetails')
{
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);
	$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_INT);
	$p = $vbulletin->input->clean_gpc('r', 'p', TYPE_INT);
	$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
	$goto = $vbulletin->input->clean_gpc('r', 'goto', TYPE_NOHTML);
	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);
	$linkuserid = $vbulletin->input->clean_gpc('r', 'linkuserid', TYPE_INT);

	// lastpostid stuff added in 2.0.1 - leave this here for a bit incase of old templates/links
	if ($postid AND !$linkid)
	{
		$getlink = $db->query_first("SELECT linkid FROM " . TABLE_PREFIX . "adv_links_posts WHERE postid = $postid");
		exec_header_redirect('showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&l=' . $getlink['linkid'] . '&p=' . $postid . '#post' . $postid);
	}

	// ##### Go to next / previous link
	if ($goto == 'next' OR $goto == 'previous')
	{
		if (($orderby == 'name' OR empty($orderby)) AND !$direction)
		{
			$direction = 'ASC';
		}

		// Search results
		if ($catid == 'searchresults')
		{
			$search = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_links_search WHERE searchid = $searchid");

			if (!$search['searchid'])
			{
				eval(standard_error(fetch_error('searchnoresults')));
			}

			$orderby = $search['orderby'];
			$direction = $search['direction'];
		}

		if ($direction != 'ASC')
		{
			$direction = 'DESC';
		}

		if (!$orderby)
		{
			$orderby = $vba_options['links_deforder'];
		}

		$doorderby = construct_orderby();

		if ($orderby == 'rating')
		{
			$condition['votequery'] = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
		}

		$linkquery = '';
		$joinquery = '';

		// Figure out which category we're dealing with
		switch ($catid)
		{
			// User Favorites
			case 'favorites':

				$joinquery = ' LEFT JOIN ' . TABLE_PREFIX . 'adv_links_favorites AS favorites ON (links.linkid = favorites.linkid)';
				$linkquery = ' AND favorites.userid = ' . $vbulletin->userinfo['userid'];
			break;

			// User Subscriptions
			case 'subscriptions':

				$joinquery = ' LEFT JOIN ' . TABLE_PREFIX . 'adv_links_subscribelink AS subscribe USING (linkid)';
				$linkquery = ' AND subscribe.userid = ' . $vbulletin->userinfo['userid'];
			break;

			// Popular Links
			case 'poplinks':
				if ($doorderby == 'name')
				{
					$doorderby = 'views';
				}

				$direction = 'DESC';
				$limit = $vba_options['links_poplinklimit'];

			break;

			// New Links
			case 'newlinks':
				$doorderby = 'dateline';
				$direction = 'DESC';
			break;

			// New Links
			case 'newposts':
				$doorderby = 'lastpostdateline';
				$direction = 'DESC';
			break;

			// Member Search
			case 'member':
			$linkquery = ' AND userid = ' . $linkuserid;
			break;

			// Search Results
			case 'searchresults':
				$linkquery = ' AND linkid IN (' . $search['linkids'] . ')';
			break;


			// Category ID
			default:

				// In case of a reply, there won't be a catid... Assume we're in browselinks
				if (!$catid)
				{
					$checkcat = $db->query_first("SELECT catid FROM " . TABLE_PREFIX . "adv_links WHERE linkid = $linkid");
					$catid = $checkcat['catid'];
				}

				$linkquery = 'AND catid = ' . $catid;

				if ($linkuserid)
				{
					$linkquery .= ' AND links.userid = ' . $linkuserid;
				}
		}

		if ($orderby == 'category')
		{
			$joinquery .= ' LEFT JOIN ' . TABLE_PREFIX . 'adv_links_categories AS categories ON (links.catid = categories.catid)';
		}

		$linkarray = array();
		$getids = $db->query("
			SELECT $condition[votequery] links.linkid
			FROM " . TABLE_PREFIX . "adv_links AS links
			$joinquery
			WHERE links.valid = 1
				AND links.suspended = 0
				$linkquery
			ORDER BY $doorderby $direction
			" . iif($limit, ' LIMIT ' . $limit)
		);
		while ($prevnext = $db->fetch_array($getids))
		{
			$linkarray[] = $prevnext['linkid'];
		}

		$db->free_result($getids);
		unset($prevnext);

		$prevnextcount = sizeof($linkarray);

		$linkkey = array_search($linkid, $linkarray);

		if ($goto == 'next')
		{
			$linkid = (isset($linkarray[$linkkey+1])) ? $linkarray[$linkkey+1] : $linkarray[0];
		}
		else
		{
			$linkid = (isset($linkarray[$linkkey-1])) ? $linkarray[$linkkey-1] : $linkarray[$prevnextcount-1];
		}

		unset($linkarray);
	} // End Next / Previous link


	if ($p)
	{
		$postid = $p;
	}

	// Per page stuff
	if ($vbulletin->userinfo['maxposts'] != -1)
	{
		$perpage = $vbulletin->userinfo['maxposts'];
	}

	if (!intval($perpage))
	{
		$perpage = $vba_options['links_repliesperpage'];
	}

	$perpage = intval($perpage);

	$query = array();
	if ($vbulletin->userinfo['userid'] AND $vba_options['links_allowfav'])
	{
		$query['favfields'] = ',NOT ISNULL(adv_links_favorites.linkid) AS favid';
		$query['favjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'adv_links_favorites AS adv_links_favorites ON (adv_links_favorites.linkid = links.linkid AND adv_links_favorites.userid = ' . $vbulletin->userinfo['userid'] . ')';
	}

	if ($show['subscribe'])
	{
		$query['subfields'] = ',NOT ISNULL(subscribelink.linkid) AS issubscribed';
		$query['subjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'adv_links_subscribelink AS subscribelink ON (subscribelink.linkid = links.linkid AND subscribelink.userid = ' . $vbulletin->userinfo['userid'] . ')';
	}

	$adv_sorturl = construct_adv_sort_url();

	// Load the BBcode parser
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	// Get the link info
	$link = $db->query_first("
		SELECT links.*, customfields.*, title, parentlist, options $query[favfields] $query[subfields]
		FROM " . TABLE_PREFIX . "adv_links AS links
		$query[favjoin]
		$query[subjoin]
		LEFT JOIN " . TABLE_PREFIX . "adv_links_cfields_entries AS customfields ON (links.linkid = customfields.lid)
		LEFT JOIN " . TABLE_PREFIX . "adv_links_categories AS links_categories ON (links.catid = links_categories.catid)
		WHERE links.linkid = '$linkid'
	");

	unset($query);

	$catid = $link['catid'];

	$vba_links->check_link($link);

	$show['modopts'] = is_category_mod($catid);

	$link['category'] = $vba_links->_cat['title'];
	$link['views'] = vb_number_format($link['views']);
	$link['posts'] = vb_number_format($link['posts']);
	$link['dateadded'] = vbdate($vbulletin->options['dateformat'], $link['dateline']);
	$link['timeadded'] = vbdate($vbulletin->options['timeformat'], $link['dateline']);
	$link['statusicon'] = iif($link['dateline'] > $vbulletin->userinfo['lastvisit'], 'new', 'old');

	$link['meta_description'] = fetch_trimmed_title(str_replace("\r\n", ' ', strip_tags($link['description'])), 150);

	$link['description'] = $bbcode_parser->do_parse($link['description'], cat_opt('allow_desc_html'), cat_opt('allow_desc_smilies'), cat_opt('allow_desc_bbcode'), cat_opt('allow_desc_bbimgcode'));

	$show['nofollow'] = false;
	if (cat_opt('nofollow', $link['catid']))
	{
		$show['nofollow'] = true;
	}

	$link['linkurl_display'] = $link['linkurl'];
	if ($vba_options['links_urlcutoff'] AND strlen($link['linkurl']) > $vba_options['links_urlcutoff'])
	{
		$link['linkurl_display'] = substr($link['linkurl'], 0, $vba_options['links_urlcutoff']) . '...';
	}

	// Highlight stuff for search results
	if ($searchid)
	{
		$search = $db->query_first("SELECT string, sfields, wholeword FROM " . TABLE_PREFIX . "adv_links_search WHERE searchid = '$searchid'");

		$sfields = explode(',', $search['sfields']);

		if (in_array('description', $sfields))
		{
			$link['description'] = highlight_keywords($link['description'], $search['string'], $search['wholeword']);
		}
	}

	if ($vba_options['links_allowreplies'] AND $vba_links->check_cat_perms('canviewreplies'))
	{
		$show['replies'] = true;
		exec_switch_bg();
	}

	// Custom fields
	$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_links_cfields ORDER BY displayorder");
	if ($db->num_rows($customfields))
	{
		while ($field = $db->fetch_array($customfields))
		{
			$thisfield = 'field' . $field['fieldid'];
			if (!trim($link["$thisfield"]))
			{
				continue;
			}

			$bgclass = exec_switch_bg();

			$field['value'] = $bbcode_parser->do_parse(unhtmlspecialchars($link["$thisfield"]), cat_opt('allow_custom_html'), cat_opt('allow_custom_smilies'), cat_opt('allow_custom_bbcode'), cat_opt('allow_custom_bbimgcode'));
			if ($searchid)
			{
				if (in_array($thisfield, $sfields))
				{
					$field['value'] = highlight_keywords($link["$thisfield"], $search['string'], $search['wholeword']);
				}
			}
			eval('$customfieldbits .= "' . fetch_template('adv_links_showlink_custombits') . '";');
		}
	}
	$db->free_result($customfields);
	unset($field);

	// Keywords
	if ($link['keywords'])
	{
		$kwords = explode(' ', trim($link['keywords']));

		if ($vba_options['links_convertkeywords'] AND !empty($kwords))
		{
			$link['keywords'] = '';
			foreach ($kwords AS $keyword)
			{
				if ($keywords)
				{
					$comma = ',';
				}

				if ($searchid)
				{
					if (in_array('keywords', $sfields))
					{
						$link['keyword'] = highlight_keywords($keyword, $search['string'], $search['wholeword']);
					}
				}

				eval('$link[\'keywords\'] .= "$comma ' . fetch_template('adv_links_showlink_keywordbit') . '";');
			}
		}

		if (!empty($kwords))
		{
			$link['meta_keywords'] = implode(', ', array_slice($kwords, 0, 8));
		}
	}
	else
	{
		$link['keywords'] = $vbphrase['none'];
	}

	// Form keywords from the description
	if (!$link['meta_keywords'] OR sizeof($kwords) < 8)
	{
		$meta_keywords = preg_replace('/[^A-Za-z0-9 ]/', '', strip_bbcode($link['description']));
		$meta_keywords = explode(' ', $meta_keywords);

		if (!empty($meta_keywords))
		{
			function check_len($word)
			{
				return (strlen($word) > 4 AND strlen($word) < 15) ? $word : false;
			}

			$meta_keywords = array_filter($meta_keywords, 'check_len');
			$meta_keywords = array_count_values($meta_keywords);
			array_multisort($meta_keywords, SORT_DESC, SORT_NUMERIC);
			$meta_keywords = array_slice(array_keys($meta_keywords), 0, (8 - sizeof($kwords)));

			$link['meta_keywords'] .= implode(', ', $meta_keywords);
		}
	}

	$headinclude = str_replace(
		array(
			'<meta name="keywords" content="' . $vbulletin->options['keywords'] . '" />',
			'<meta name="description" content="' . $vbulletin->options['description'] . '" />'
		),
		array(
			'<meta name="keywords" content="' . $link['meta_keywords'] . '" />',
			'<meta name="description" content="' . $link['meta_description'] . '" />'
		),
		$headinclude
	);

	// Plural username
	if (substr($link['username'], -1) != 's')
	{
		$plurals = $vbphrase['plural_s'];
	}

	// Rating
	if ($link['votetotal'])
	{
		$show['whoratedlink'] = $vba_links->check_cat_perms('canseewhorated');
		$link['truerating'] = vb_number_format($link['votetotal'] / $link['votenum'], 2);
		$link['roundrating'] = round($link['truerating']);
		$link['voteavg'] = vb_number_format($link['votetotal'] / $link['votenum'], 2);
	}
	else
	{
		$link['truerating'] = 0;
	}

	if (!$link['open'])
	{
		$show['closedbutton'] = true;
	}

	// Show variables
	if ($vba_options['links_allowreplies'] AND $vba_links->check_cat_perms('canreply') AND cat_user_opt('allow_reply'))
	{
		$show['replylink'] = true;
	}

	if ($vba_options['links_allowrating'] AND $vba_links->check_cat_perms('canrate', $link) AND cat_user_opt('allow_rating') AND cat_opt('allow_ratings', $link['catid']))
	{
		$show['ratelink'] = true;
	}

	if ($vba_links->check_cat_perms('cansendtofriend'))
	{
		$show['sendtofriend'] = true;
	}

	if ($vba_links->check_cat_perms('canreport'))
	{
		$show['report_link'] = true;
	}

	if ($vbulletin->userinfo['userid'] AND (($link['userid'] == $vbulletin->userinfo['userid'] AND $vba_links->check_cat_perms('canedit')) OR $vba_links->check_cat_perms('caneditothers')) OR $show['modopts'])
	{
		$show['editlink'] = true;
	}

	// ######################### Replies to Link #############################
	if ($vba_options['links_allowreplies'] AND $vba_links->check_cat_perms('canviewreplies'))
	{
		if ($postid AND !$pagenumber)
		{
			$getpost = $db->query_first("SELECT dateline FROM " . TABLE_PREFIX . "adv_links_posts WHERE postid = $postid");
			$olderposts = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_links_posts WHERE " . iif($getpost['dateline'], "dateline < $getpost[dateline] AND") . " linkid = $linkid");
			$_REQUEST['page'] = ceil(($olderposts['count'] + 1) / $perpage);
		}

		$condition['fromtable'] = 'adv_links_posts AS posts';
		$wherequery = array("linkid = $link[linkid] AND visible = 1");
		$replypagedata = fetch_page_data($perpage);


		if ($replypagedata['count'])
		{
			$show['postheader'] = true;
			$show['reputationlink'] = false;

			$counter = 0;
			$postcount = ($pagenumber - 1 ) * $perpage;

			if ($vba_options['links_showquickreply'] AND $show['replylink'] AND $link['open'])
			{
				$SHOWQUICKREPLY = true;
			}

			$pagenav = construct_page_nav($replypagedata['pagenumber'], $perpage, $replypagedata['count'], 'showlink.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showdetails&amp;l=' . $link['linkid'] . $adv_sorturl);

			require_once(DIR . '/includes/functions_bigthree.php');
			require_once(DIR . '/includes/class_postbit.php');

			// Highlight postbits
			if ($searchid)
			{
				if (in_array('pagetext', $sfields))
				{
					$highlightposts = true;
				}
			}

			$postcount = ($replypagedata['pagenumber'] - 1) * $perpage;
			$show['postcount'] = true;

			// Replace links in templates
			$vbulletin->templatecache['postbit_ip'] = str_replace('"postings.php', '"moderate.php', $vbulletin->templatecache['postbit_ip']);

			$postbittemp = ($vbulletin->options['legacypostbit']) ? 'postbit_legacy' : 'postbit';

			$vbulletin->templatecache[$postbittemp] = str_replace(
				array(
					'"editpost.php',
					'"image.php',
					'imwindow',
					'"member.php',
					'"postings.php',
					'"private.php',
					'"profile.php',
					'"sendmessage.php',
					'"report.php?',
					'"search.php',
					'"showpost.php?',
					'p=$post[postid]&amp;postcount=$post[postcount]'
				),
				array(
					'"reply.php',
					'"' . $vbulletin->options['bburl'] . '/image.php',
					'openimwindow',
					'"' . $vbulletin->options['bburl'] . '/member.php',
					'"moderate.php',
					'"' . $vbulletin->options['bburl'] . '/private.php',
					'"' . $vbulletin->options['bburl'] . '/profile.php',
					'"' . $vbulletin->options['bburl'] . '/sendmessage.php',
					'"misc.php?do=report&amp;type=post&amp;',
					'"' . $vbulletin->options['bburl'] . '/search.php',
					'"showlink.php?do=showdetails&amp;',
					'l=$link[linkid]&amp;p=$post[postid]#post$post[postid]'
				),
				$vbulletin->templatecache[$postbittemp]
			);

			$queryfields = '';
			$queryjoin = '';

			// Icons
			if ($vba_options['links_allowicons'])
			{
				$queryfields = ', posts.iconid, icon.title as icontitle, icon.iconpath';
				$queryjoin = ' LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (posts.iconid = icon.iconid) ';
			}

			// Avatars
			if ($vbulletin->options['avatarenabled'])
			{
				$queryfields .= ', avatar.avatarpath, NOT ISNULL(customavatar.filedata) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision';
				$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'avatar AS avatar ON (avatar.avatarid = user.avatarid)
					LEFT JOIN ' . TABLE_PREFIX . 'customavatar AS customavatar ON (customavatar.userid = user.userid)';
			}

			// Smilies
			if (cat_opt('allow_post_smilies'))
			{
				$queryfields .= ', posts.allowsmilie';
			}

			$postperms = array(
				'canreply' => $vba_links->check_cat_perms('canreply'),
				'caneditposts' => $vba_links->check_cat_perms('caneditposts'),
				'caneditothersposts' => $vba_links->check_cat_perms('caneditothersposts')
			);

			$posts = $db->query("
					SELECT posts.postid, posts.pagetext, posts.title, posts.userid, posts.username AS postusername, posts.dateline, posts.ipaddress AS ip, posts.showsignature, user.*, userfield.*, usertextfield.signature $queryfields
					FROM " . TABLE_PREFIX . "adv_links_posts AS posts
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON (posts.userid = user.userid)
					LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (posts.userid = userfield.userid)
					LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = posts.userid)
					$queryjoin
					WHERE linkid = '$link[linkid]' AND posts.visible = 1
					ORDER BY posts.dateline
					LIMIT " . ($replypagedata['minlimit'] - 1) . ", $replypagedata[perpage]
			");
			while ($post = $db->fetch_array($posts))
			{
				$post['message'] = $bbcode_parser->do_parse(
					$post['pagetext'],
					cat_opt('allow_post_html'),
					iif(cat_opt('allow_post_smilies'), $post['allowsmilie'], 0),
					cat_opt('allow_post_bbcode'),
					cat_opt('allow_post_bbimgcode')
				);

				$post['postdate'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
				$post['posttime'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);

				if (empty($checkperms[$post['userid']]))
				{
					$checkperms[$post['userid']] = cache_permissions($post, false);
				}

				if ($highlightposts)
				{
					$post['message'] = highlight_keywords($post['message'], $search['string'], $search['wholeword']);
				}

				$postcount++;
				$post['postcount'] = $postcount;

				// Icons
				$post['statusicon'] = ($post['dateline'] > $vbulletin->userinfo['lastvisit']) ? 'new' : 'old';

				$show['messageicon'] = ($post['iconid'] OR $vbulletin->options['showdeficon']) ? true : false;

				if ($vbulletin->options['showdeficon'] AND !$post['iconid'])
				{
					$post['iconpath'] = $vbulletin->options['showdeficon'];
					$post['icontitle'] = $vbphrase['default'];
				}

				// Set default $show variables
				$show['profile'] = false;
				$show['avatar'] = false;
				$show['buddy'] = false;
				$show['search'] = false;
				$show['emaillink'] = false;
				$show['pmlink'] = false;
				$show['homepage'] = false;
				$show['reputation'] = false;

				// Show IP address
				$post['iplogged'] = '';
				if ($post['ip'])
				{
					if ($vbulletin->options['logip'] == 2)
					{
						$show['ip'] = true;
					}
					else if ($vbulletin->options['logip'] == 1 AND $show['modopts'])
					{
						$show['ip'] = false;
						eval('$post[\'iplogged\'] .= "' . fetch_template('postbit_ip') . '";');
					}
				}

				// Reply Link
				if ($postperms['canreply'])
				{
					$post['replylink'] = 'newreply.php?' . $vbulletin->session->vars['sessionurl'] . 'p=' . $post['postid'];
				}

				// Edit link
				if (($postperms['caneditposts'] AND $post['userid'] == $vbulletin->userinfo['userid']) OR $postperms['caneditothersposts'] OR $show['modopts'])
				{
					$post['editlink'] = 'newreply.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editpost&amp;p=' . $post['postid'];
				}

				// Report link
				$show['reportlink'] = false;
				if ($vbulletin->userinfo['userid'] != $post['userid'] AND $show['report_link'])
				{
					$show['reportlink'] = true;
				}

				// ##### Post by a registered member
				if ($post['userid'])
				{
					// Post was by a user
					$post = array_merge($post, convert_bits_to_array($post['options'], $vbulletin->bf_misc_useroptions));

					$post['musername'] = fetch_musername($post);

					$show['profile'] = true;
					$show['buddy'] = true;
					$show['search'] = true;

					// Email, homepage, & PM links
					if ($post['showemail'] AND $vbulletin->options['displayemails'])
					{
						$show['emaillink'] = true;
					}
					if ($post['homepage'] AND $post['homepage'] != 'http://')
					{
						$show['homepage'] = true;
					}
					if ($vbulletin->options['enablepms'] AND $post['receivepm'])
					{
						$show['pmlink'] = true;
					}

					// User stats
					$post['joindate'] = vbdate($vbulletin->options['registereddateformat'], $post['joindate']);
					$post['posts'] = number_format($post['posts']);

					// Online Status
					fetch_online_status($post, true);

					// Reputation
					if ($vbulletin->options['reputationenable'])
					{
						fetch_reputation_image($post, $checkperms);
						$show['reputation'] = true;
					}

					// Im Icons
					construct_im_icons($post);

					// User Title
					if ($post['customtitle'] == 2)
					{
						$post['usertitle'] = htmlspecialchars_uni($post['usertitle']);
					}

					// Signature
					if ($vbulletin->options['allowsignatures'] AND $post['showsignature'] AND $post['signature'] AND ($vbulletin->userinfo['showsignatures'] OR !$vbulletin->userinfo['userid']))
					{
						$post['signature'] = $bbcode_parser->parse($post['signature'], 0, $vbulletin->options['allowsmilies']);
					}
					else
					{
						$post['signature'] = '';
					}

					// Get Avatar
					$show['avatar'] = false;
					$post['avatarurl'] = '';
					if ($vbulletin->userinfo['showavatars'] OR !$vbulletin->userinfo['userid'])
					{
						if ($post['avatarpath'])
						{
							$post['avatarurl'] = $vbulletin->options['bburl'] . '/' . $post['avatarpath'];
						}
						else if ($post['hascustom'])
						{
							if ($vbulletin->options['usefileavatar'])
							{
								$post['avatarurl'] = $vbulletin->options['bburl'] . '/' . $vbulletin->options['avatarurl'] . '/avatar' . $post['userid'] . '_' . $post['avatarrevision'] . '.gif';
							}
							else
							{
								$post['avatarurl'] = $vbulletin->options['bburl'] . '/image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $post['userid'] .'&amp;dateline=' . $post['avatardateline'];
							}
						}
						if ($post['avatarurl'])
						{
							$show['avatar'] = true;
						}
					}
				}
				// ##### Guest Post
				else
				{
					$post['posts'] = $vbphrase['n_a'];
					$post['joindate'] = $vbphrase['n_a'];
					$post['username'] = $post['postusername'];
					$post['musername'] = fetch_musername($post);
					$post['usertitle'] = $vbphrase['guest'];
				}

				// Print the postbit
				eval('$postbit = "' . fetch_template('postbit') . '";');

				eval('$postbits .= "' . fetch_template('postbit_wrapper') . '";');

			}
		}
	}

	$db->free_result($posts);
	unset($query, $post);

	$postbit =& $postbits;

	if ($vba_options['links_showquickreply'] AND $show['replylink'] AND $link['open'] AND $vbulletin->userinfo['userid'])
	{
		require_once(DIR . '/includes/functions_editor.php');

		$vbulletin->options['allowbbimagecode'] = (cat_opt('allow_post_bbimgcode') ? 1 : 0);

		$show['quickreply'] = true;
		$show['wysiwyg'] = (cat_opt('allow_post_bbcode') ? is_wysiwyg_compatible() : 0);
		$istyles_js = construct_editor_styles_js();
		$editorid = construct_edit_toolbar('', false, 0, (cat_opt('allow_post_bbcode') ? 1 : 0), 1, false, 'qr');
		$threadedmode = 0;
		$qrpostid = 'who cares';
		$QRrequireclick = 0;

		$vbulletin->templatecache['editor_clientscript'] = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['editor_clientscript']);

		// Fake IE6 to so it won't try to use the IE7 popups
		$vbulletin->templatecache['editor_clientscript'] .= '<script type=\"text/javascript\">
	    <!--
	        var is_ie7 = false;
	    -->
	    </script>';

		$vBeditJs = construct_editor_js_arrays();
		eval('$vBeditTemplate[\'clientscript\'] = "' . fetch_template('editor_clientscript') . '";');

		$headinclude .= '
			<!-- set up CSS for the editor -->
			<link rel="stylesheet" type="text/css" href="' . $vbulletin->options['bburl'] . '/clientscript/vbulletin_editor.css" />
			<style type="text/css">
			<!--
			#vBulletin_editor {
				background: ' . $istyles['pi_button_normal'][0] . ';
				padding: ' . $stylevar['cellpadding'] . 'px;
			}
			#controlbar, .controlbar {
				background: ' . $istyles['pi_button_normal'][0] . ';
			}
			.imagebutton {
				background: ' . $istyles['pi_button_normal'][0] . ';
				color: ' . $istyles['pi_button_normal'][1] . ';
				padding: ' . $istyles['pi_button_normal'][2] . ';
				border: ' . $istyles['pi_button_normal'][3] . ';
			}
			-->
			</style>
		';

		unset($threadid);

		eval('$quickreply = "' . fetch_template('showthread_quickreply') . '";');

		$messagearea = "
			<script type=\"text/javascript\">
			<!--
				var threaded_mode = $threadedmode;
				var require_click = 0;
				var is_last_page = " . iif(ceil($replypagedata['count'] / $perpage) == $pagenumber, 1, 0) . ";
				var allow_ajax_qr = 0;
				var ajax_last_post = '';
			// -->
			</script>
			$messagearea
		";

	}
	$categoryjump = print_category_jump($link['catid']);

	$browseurl = 'browselinks.php?' . $vbulletin->session->vars['sessionurl'] . 'do=';

	switch($catid)
	{
		case 'favorites':
			$navbits[$browseurl . 'favorites'] = $vbphrase['my_favorites'];
			break;

		case 'subscriptions':
			$navbits[$browseurl . 'subscriptions'] = $vbphrase['my_subscriptions'];
			break;

		case 'newlinks':
			$navbits[$browseurl . 'newlinks'] = $vbphrase['whats_new'];
			break;

		case 'poplinks':
			$navbits[$browseurl . 'poplinks'] = $vbphrase['whats_popular'];
			break;

		default:
			$navbits = fetch_cat_navbits($link['catid']);
	}

	$navbits[''] = $link['name'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('ADV_LINKS_SHOWLINK') . '");');
}

?>