<?php

/* Unserialize the user chatbox params and add it to the userinfo global var table */
function mgc_cb_evo_unserialize_user_params() {
    global $vbulletin;

    /* If the table is empty -> set default values */
    if (!empty($vbulletin->userinfo['mgc_cb_evo_params'])) {
        $unserialized_params = unserialize($vbulletin->userinfo['mgc_cb_evo_params']);

        /* Add the new variables to the userinfo table of the vbulletin object */
        if (!empty($unserialized_params)) {
            foreach ($unserialized_params as $key => $val) {
                $vbulletin->userinfo["$key"] = $val;
            }
        }
    } else {
        $vbulletin->userinfo['mgc_cb_evo_show'] = 1;
    }
}

/* Construct the chatbox allowed bbcode tags list */
function construct_bbcode_tag_list($with_color) {
    global $vbulletin;

    $bbcode_list = array();

    if ($vbulletin->options['mgc_cb_evo_bbcode']) {
        $bbcode_list['no_option']['b'] = array('html' => '<b>%1$s</b>', 'strip_empty' => true);

        $bbcode_list['no_option']['i'] = array('html' => '<i>%1$s</i>', 'strip_empty' => true);

        $bbcode_list['no_option']['u'] = array('html' => '<u>%1$s</u>', 'strip_empty' => true);

        if ($with_color) {
            $bbcode_list['option']['color'] = array('html' =>
                                                    '<font color="%2$s">%1$s</font>', 'option_regex' => '#^\#?\w+$#', 'strip_empty' => true);
        }

        $bbcode_list['option']['size'] = array('html' => '<font size="%2$s">%1$s</font>',
                                               'option_regex' => '#^[0-9\+\-]+$#', 'strip_empty' => true);

        $bbcode_list['option']['font'] = array('html' => '<font face="%2$s">%1$s</font>',
                                               'option_regex' => '#^[^["`\':]+$#', 'strip_empty' => true);
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_url']) {
        $bbcode_list['no_option']['url'] = array('callback' => 'handle_bbcode_url',
                                                 'strip_empty' => true);

        $bbcode_list['option']['url'] = array('callback' => 'handle_bbcode_url',
                                              'strip_empty' => true);
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_email']) {
        $bbcode_list['no_option']['email'] = array('callback' => 'handle_bbcode_email',
                                                   'strip_empty' => true);

        $bbcode_list['option']['email'] = array('callback' => 'handle_bbcode_email',
                                                'strip_empty' => true);
    }

    return $bbcode_list;
}

/* User can see chatbox even if he has not reached number of posts */
function can_see_if_not_enough_posts() {
    global $vbulletin, $permissions;
    
    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->
            bf_ugp_mgc_cb_evo_permissions['canseeifnotenoughposts']);   
}

/* User can view the chatbox permission check */
function can_view_mgc_cb_evo() {
    global $vbulletin, $permissions;
    
    /* Chatbox deactivated */
    if (!$vbulletin->options['mgc_cb_evo_active']) {
        return 0;
    }
    
    /* Chatbox shall be idle in this style ? */
    if (!empty($vbulletin->options['mgc_cb_evo_styleids_hide']))
    {
    	$styleids_array = explode(',',$vbulletin->options['mgc_cb_evo_styleids_hide']);
    	
    	if (in_array($vbulletin->userinfo['styleid'],$styleids_array))
    	{
    		return 0;
    	}
    }
    
    /* Check number of posts per 24H ? */
    if ($permissions['mgc_cb_evo_nbmsg_perday_show'] > 0) {
        $getnbmsg = $vbulletin->db->query_first("SELECT COUNT(postid) AS nbposts FROM " . TABLE_PREFIX . "post WHERE dateline>='" . (TIMENOW - 86400) . "' AND userid='" . $vbulletin->userinfo['userid'] . "'");
        
        if (($getnbmsg['nbposts'] < $permissions['mgc_cb_evo_nbmsg_perday_show']) && !can_see_if_not_enough_posts()) {
            return false;
        }
    }
    
    /* Check number of posts ? */
    if ($permissions['mgc_cb_evo_nbmsg_show'] > 0) {      
        if (($vbulletin->userinfo['posts'] <= $permissions['mgc_cb_evo_nbmsg_show']) && !can_see_if_not_enough_posts()) {
              return false;
    	}
    }
    
    /* Check user ban status */
    if ($vbulletin->userinfo['mgc_cb_evo_banned']) {
        return;
    }	    
    
    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canview']);
}


/* User can use the chatbox permission check */
function can_use_mgc_cb_evo() {
    global $vbulletin, $permissions;

    /* Check number of posts per 24H ? */
    if ($permissions['mgc_cb_evo_nbmsg_perday_show'] > 0) {
        $getnbmsg = $vbulletin->db->query_first("SELECT COUNT(postid) AS nbposts FROM " . TABLE_PREFIX . "post WHERE dateline>='" . (TIMENOW - 86400) . "' AND userid='" . $vbulletin->userinfo['userid'] . "'");
        
        if ($getnbmsg['nbposts'] < $permissions['mgc_cb_evo_nbmsg_perday_show']) {
            return false;
        }
    }
    
    /* Check number of posts ? */
    if ($permissions['mgc_cb_evo_nbmsg_show'] > 0) {      
        if ($vbulletin->userinfo['posts'] <= $permissions['mgc_cb_evo_nbmsg_show']) {
            return false;
        }
    }
    
    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canuse']);
}

/* User can manage the chatbox permission check */
function can_manage_mgc_cb_evo() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canmanage']);
}

/* User can view the IPs in the chatbox permission check */
function can_viewips_in_chatbox() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canviewip']);
}


/* User can manage own chats permission check */
function can_manage_own_chats() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canmanageownchats']);
}

/* User can see the archives permission check */
function can_view_mgc_cb_evo_archives() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canviewarchives']);
}

/* User can download the archives permission check */
function can_download_mgc_cb_evo_archives() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['candownloadarchives']);
}

/* User can see prompt message in chatbox input field */
function can_see_promptmsg() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['showpromptmsg']);
}

/* User can sticky a chat */
function can_sticky()
{
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->
            bf_ugp_mgc_cb_evo_permissions['cansticky']);
}

/* Retrieves the chatbit display*/
function fetch_chat_info($chat, $parsebbcode, $commands_status, $channel_id,$alt,$inarchives = 0) {
    global $vbulletin, $vbphrase, $vbcollapse, $permissions, $stylevar, $mgc_cb_evo_floc;

    /** Username management **/
    
    if ($chat['touserid'] == 0) { /* Normal command */
        $username_prefix = "";

        /* Anonymous user */
        if (!$chat['fromuserid']) {
            $anonymous 	            = 1;
            /* Display entered name if option active, otherwise default anonymous name */
            if ($vbulletin->options['mgc_cb_evo_ask_anonymous_name'] && !empty($chat['name'])) {
            	$user['username']	= htmlspecialchars_uni($chat['name']);
            } else {
	            $user['username']   = $vbulletin->options['mgc_cb_evo_anonymous_uname'];
	        }
        } else {
            $anonymous		        = 0;
            $user 					= array();
            $user['userid'] 		= $chat['fromuserid'];
            $user['usergroupid']    = $chat['fromusergroupid'];
            $user['displaygroupid'] = $chat['fromdisplaygroupid'];
            $user['username'] 		= $user['raw_username'] = $chat['fromusername'];
            $user['username'] 		= fetch_musername($user, 'displaygroupid');
        }                    
    } else { /* Command from user to user */
        
        /* Message sent by the user */
        if ($chat['fromuserid'] == $vbulletin->userinfo['userid']) {
            $username_prefix 		= $vbphrase['mgc_cb_evo_to'] . " ";
            $anonymous 		        = 0;
            $user 					= array();
            $user['userid'] 		= $chat['touserid'];
            $user['usergroupid'] 	= $chat['tousergroupid'];
            $user['displaygroupid'] = $chat['todisplaygroupid'];
            $user['username'] 	    = $user['raw_username'] = $chat['tousername'];
            $user['username'] 	    = fetch_musername($user, 'displaygroupid');
        } else {
            $username_prefix 		= $vbphrase['mgc_cb_evo_from'] . " ";
            $anonymous				= 0;
            $user 					= array();
            $user['userid'] 		= $chat['fromuserid'];
            $user['usergroupid'] 	= $chat['fromusergroupid'];
            $user['displaygroupid'] = $chat['fromdisplaygroupid'];
            $user['username'] 		= $user['raw_username'] = $chat['fromusername'];
            $user['username'] 		= fetch_musername($user, 'displaygroupid');
        }
    }
        
    /* Username display applies for all chats except the one with the me or slap command */
    if ($chat['coidentifier'] != 'me' && $chat['coidentifier'] != 'slap') {
        $user['username'] = str_replace("{1}",$user['username'],$vbulletin->options['mgc_cb_evo_username_html']);
    }
    
    /** Date and time **/

    /* Display date */
    if ($inarchives) {
        $date = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'],false,false);
    } else {
        if ($vbulletin->options['mgc_cb_evo_show_date']) {
            $date = vbdate($vbulletin->options['mgc_cb_evo_format_date'], $chat['dateline'],false,false);
        } else {
            $date = "";
        }      
    }

    /* Display time */
    if ($vbulletin->options['mgc_cb_evo_show_time']) {
        $time = vbdate($vbulletin->options['mgc_cb_evo_format_time'], $chat['dateline'],false,false);
    } else {
        $time = "";
    }

    /** Chats management (Edit ) **/

    /* Chatbox not collapsed */
    if ($vbcollapse['collapseobj_mgc_chatbox'] == '') {
        $show['mgc_cb_evo_mngt'] = can_manage_mgc_cb_evo() || (($vbulletin->userinfo['userid'] == $chat['fromuserid']) && can_manage_own_chats());
    } else {
        $show['mgc_cb_evo_mngt'] = 0;
    }

    if ($show['mgc_cb_evo_mngt']) {
        $chat_ondblclick = "ondblclick='mgc_cb_evo_inline_edit(this,$chat[chatid])' style='cursor: pointer'";
    } else {
        $chat_ondblclick = "";
    }
    
    /** Chats management in archives (Delete) **/
    if ($inarchives && can_manage_mgc_cb_evo()) {
        $show['delete_column'] = true;
    }

    /** Chat display formatting **/

    /* Bbcode parsing if bbcodes are active and the command is not the me command */
    if ($parsebbcode) {
        $parser = &new vB_BbCodeParser($vbulletin, construct_bbcode_tag_list(true));
        $chat['text'] = $parser->do_parse($chat['ctext'], false, $vbulletin->options['mgc_cb_evo_smileys'], true,$vbulletin->options['mgc_cb_evo_bbcode_img'], false, false);
    } else {
        /* Fetch censored text */
        $chat['text'] = fetch_censored_text($chat['ctext']);
        $chat['text'] = htmlspecialchars($chat['ctext']);
    }

    /* Specific display management for the me and slap commands */
    if ($chat['coidentifier'] == 'me') {
        $show['mgc_cb_evo_username_column'] = 0;
        $chat['text'] = '<font color="#' . $vbulletin->options['mgc_cb_evo_cmd_me_color'] . '"><b>* ' . $user['username'] . ' ' . $chat['text'] . '</b></font>';
    } else if ($chat['coidentifier'] == 'slap') {
        $show['mgc_cb_evo_username_column'] = 0;
        $text = str_replace("{1}",$user['username'],$vbulletin->options['mgc_cb_evo_cmd_slap_phrase']);
        $text = str_replace("{2}",$chat['text'],$text);       
        $chat['text'] = '<font color="#' . $vbulletin->options['mgc_cb_evo_cmd_slap_color'] . '"><b>* ' . $text . '</b></font>';
    } else {          
        $show['mgc_cb_evo_username_column'] = 1;
    }
    
    /* Font class */
    if ($vbulletin->options['mgc_cb_evo_chat_fontclass']) {
        $fontclass= "smallfont";
    } else {          
        $fontclass = "normalfont";
    }
    
    /* Authorization to display sticky chat in the chatbox menu */
    $show['stickychat'] = can_sticky();
    
    /* Authorization to display user IP in the chatbox menu */
    $show['userip'] = can_viewips_in_chatbox();
    
    /* Manage avatar if option is active */
    if ($vbulletin->options['mgc_cb_evo_avatar_on']) {
    	/* Show no avatar for anonymous users */
    	if ($anonymous) {
    		$avatarurl = $stylevar['imgdir_misc'] . '/mgc_cb_evo/noavatar.jpg'; 	
    	} else {
    		$chat['userid'] = $chat['fromuserid'];
    		$avatarurl 		= get_avatar_chatbox($chat);
    	}    
    }
    
    /* Let's build the commands chatbit menu bit if user is not anonymous */
    if (!$anonymous) {
        eval('$chatbit_menu .= "' . fetch_template('mgc_cb_evo_chatbit_menu') . '";');
    }
    
    if ($inarchives) {
        eval('$chat_txt .= "' . fetch_template('mgc_cb_evo_archives_chatbit') . '";');       
    } else {
        eval('$chat_txt .= "' . fetch_template('mgc_cb_evo_chatbit') . '";');
    }

    return $chat_txt;
}


function build_smileys_selector_display() {
    global $vbulletin, $vbphrase;

    /* The number of smileys defined for the editor is equal to 0 ? */

    /* Nombre de smileys dans l'éditeur différent de 0 */
    if ($vbulletin->options['mgc_cb_evo_editor_nbsmileys']) {          
        if ($vbulletin->options['mgc_cb_evo_editor_smileys_acporder']) { /* Acp order smilies */
            $smilies = $vbulletin->db->query_read("
			  SELECT smilieid, smilietext, smiliepath, title
			  FROM " . TABLE_PREFIX . "smilie
			  ORDER BY displayorder LIMIT " . $vbulletin->options['mgc_cb_evo_editor_nbsmileys']
                                                  );      	
        } else if ($vbulletin->options['mgc_cb_evo_editor_smileys_random']) { /* Random smilies */
            $smilies = $vbulletin->db->query_read("
			  SELECT smilieid, smilietext, smiliepath, title
			  FROM " . TABLE_PREFIX . "smilie
			  ORDER BY RAND() LIMIT " . $vbulletin->options['mgc_cb_evo_editor_nbsmileys']
                                                  );
        } else {
            $smilies = $vbulletin->db->query_read("
			  SELECT smilieid, smilietext, smiliepath, title
			  FROM " . TABLE_PREFIX . "smilie
			  LIMIT " . $vbulletin->options['mgc_cb_evo_editor_nbsmileys']
                                                  );
        }

        $cb_smilies = '';
        $cnt_smilies = 0;

        /* Any smilies ? */
        if ($vbulletin->db->num_rows($smilies)) {
            while (($smiley = $vbulletin->db->fetch_array($smilies))) {
                $textsmiley = str_replace("'", "\'", $smiley['smilietext']);
                $textsmiley = str_replace("\\", "\\\\", $textsmiley);
                $cb_smilies .= '<a href="#chatbox" onclick="return add_smiley_to_input(\'' . $textsmiley . '\');" alt="' . $smiley['title'] . '"><img src="' . $smiley['smiliepath'] . '" border="0" /></a> ';
            }
            return $cb_smilies;
        } else {              
            return $vbphrase['mgc_cb_no_smileys'];
        }
    } else {        
        return $vbphrase['mgc_cb_no_smileys'];
    }
}

function build_fonts_selector($fonts_list, $inprofile = false) {
    global $vbulletin, $vbphrase;

    $userpref_val = $vbulletin->userinfo['mgc_cb_evo_font'];

    /* Building a selector for the user cp */
    if ($inprofile) {
        $fonts_select = '<select name="mgc_cb_evo_font" id="mgc_cb_evo_font">';
        $fonts_select .= '<option value="0" ' . (($userpref_val == 0) ? "selected='selected'" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
    } else {
        $fonts_select = '<select name="mgc_cb_evo_font" id="mgc_cb_evo_font" onchange="return insert_enhanced_bbcode(this,\'font\');">';
        $fonts_select .= '<option value="-1" ' . (($userpref_val == 0) ? "selected='selected'" : "") . ' style="font-weight: bold">[' . $vbphrase['mgc_cb_evo_fonts'] . ']</option>';
    }

    foreach ($fonts_list as $id => $font) {
        if ($font == $userpref_val) {
            $fonts_select .= '<option style="font: 10px ' . strtolower($font) . ';" value="' . $font . '" selected="selected">' . $font . '</option>';
        } else {
            $fonts_select .= '<option style="font: 10px ' . strtolower($font) . ';" value="' . $font . '">' . $font . '</option>';
        }
    }

    $fonts_select .= '</select>';

    return $fonts_select;
}

function build_size_selector($sizes_list, $inprofile = false) {
    global $vbulletin, $vbphrase;

    $userpref_val = $vbulletin->userinfo['mgc_cb_evo_size'];

    foreach ($sizes_list as $id => $size) {
        if ($size <= $vbulletin->options['mgc_cb_evo_max_bbcode_size']) {
            if ($size == $userpref_val) {
                $sizes_selectbit .= '<option value="' . $size . '" selected="selected">' . $size . '</option>';
            } else {
                $sizes_selectbit .= '<option value="' . $size . '">' . $size . '</option>';
            }
        }
    }
    
    /* Building a selector for the user cp */  
    if ($inprofile) {
        $sizes_select  = '<select name="mgc_cb_evo_size" id="mgc_cb_evo_size">';
        $sizes_select .= '<option value="0" ' . (($userpref_val == 0) ?"selected=selected" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';     
    } else {
        $sizes_select  = '<select name="mgc_cb_evo_size" id="mgc_cb_evo_size" onchange="return insert_enhanced_bbcode(this,\'size\');">';
        $sizes_select .= '<option value="-1" ' . ( ($select_val == 0) ? "selected=selected" : "" ) . ' style="font-weight: bold">[' . $vbphrase['mgc_cb_evo_size'] . ']</option>';         
    }  
    
    $sizes_select .= $sizes_selectbit;
    $sizes_select .= '</select>';

    return $sizes_select;   
}

function build_color_selector($inprofile = false) {
    global $vbphrase, $vbulletin;

    if (!empty($vbulletin->userinfo['mgc_cb_evo_color'])) {
        /* User default */
        $select_val = $vbulletin->userinfo['mgc_cb_evo_color'];
    } else if (!$inprofile && $vbulletin->userinfo['mgc_cb_evo_default_color']) {
        /* Usergroup default if different from 000000 */
        $select_val = $vbulletin->userinfo['mgc_cb_evo_default_color'];
    }

    $colors_list = array('#000000', '#A0522D', '#556B2F', '#006400', '#483D8B',
                         '#000080', '#4B0082', '#2F4F4F', '#8B0000', '#FF8C00', '#808000', '#008000',
                         '#008080', '#0000FF', '#708090', '#696969', '#FF0000', '#F4A460', '#9ACD32',
                         '#2E8B57', '#48D1CC', '#4169E1', '#800080', '#808080', '#FF00FF', '#FFFF00',
                         '#00FF00', '#00FFFF', '#00BFFF', '#9932CC', '#C0C0C0', '#FFC0CB', '#F5DEB3',
                         '#FFFACD', '#98FB98', '#AFEEEE', '#ADD8E6', '#DDA0DD', '#FFFFFF');

    if ($inprofile) {
        $colors_select = '<select name="mgc_cb_evo_color" id="mgc_cb_evo_color">';
        $colors_select .= '<option value="0" ' . (empty($select_val) ?  "selected=selected" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
    } else {       
        $colors_select = '<select name="mgc_cb_evo_color" id="mgc_cb_evo_color" onchange="return insert_enhanced_bbcode(this,\'color\');">';
        $colors_select .= '<option value="-1" ' . (empty($select_val) ? "selected=selected" : "") . ' style="font-weight: bold">[' . $vbphrase['mgc_cb_evo_colors'] . ']</option>';
    }

    foreach ($colors_list as $name => $val) {
        if ($val == '#' . $select_val) {
            $colors_select .= '<option value="' . $val . '" style="background-color: ' . $val . '; color: ' . $val . '" selected="selected">' . $val . '</option>';
        } else {
            $colors_select .= '<option value="' . $val . '" style="background-color: ' . $val . '; color: ' . $val . '">' . $val . '</option>';
        }
    }

    $colors_select .= '</select>';

    return $colors_select;
}

function build_bbcode_selector_display() {
    global $vbulletin, $vbphrase, $stylevar;

    $bbcodes = '';

    /* Simple bbcode active */
    if ($vbulletin->options['mgc_cb_evo_bbcode']) {
        /* Get necessary templates */
        foreach (array('editor_jsoptions_font', 'editor_jsoptions_size') as $template) {
            $string = fetch_template($template, 1, 0);
            $$template = preg_split('#\r?\n#s', $string, -1, PREG_SPLIT_NO_EMPTY);
        }

        /* Font list */
        $fonts  = $editor_jsoptions_font;
        $bbcodes .= build_fonts_selector($fonts);

        /* Sizes list */
        $sizes = $editor_jsoptions_size;
        $bbcodes .= '&nbsp;&nbsp;' . build_size_selector($sizes);

        /* Colors selector */
        $bbcodes .= '&nbsp;&nbsp;' . build_color_selector();

        /* B / I / U buttons */
        $bbcodes .= '&nbsp;<input type="image" name="bold" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_b.gif"  value="b" onclick="return text_insert(\'[b]\',\'[/b]\');" />';
        $bbcodes .= '&nbsp;<input type="image" name="italic" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_i.gif" value="i" onclick="return text_insert(\'[i]\',\'[/i]\');" />';
        $bbcodes .= '&nbsp;<input type="image" name="underlined" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_u.gif"  value="u" onclick="return text_insert(\'[u]\',\'[/u]\');" />';
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_url']) {
        $bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
        $bbcodes .= '<input type="image" name="url" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_url.gif"  value="URL" onclick="return insert_bbcode_url();" />';
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_email']) {
        $bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
        $bbcodes .= '<input type="image" name="url" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_email.gif"  value="EMAIL" onclick="return insert_bbcode_email();" />';
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_img']) {
        $bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
        $bbcodes .= '<input type="image" name="image" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_img.gif" value="IMG" onclick="return insert_bbcode_img();" />';
    }

    $bbcodes .= '&nbsp;<input type="image" name"clear" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_clear.gif" value="' . $vbphrase['mgc_cb_evo_clear_bbcode'] . '" onclick="return remove_bbcodes();" />';

    return $bbcodes;
}

/* Returns all the chatbox for display */
function build_mgc_cb_evo_display($chatbox_height) {
    global $vbulletin, $vbphrase, $show, $stylevar, $vbcollapse, $vboptions;
    global $mgc_cb_evo_floc;

    /* First load and inactive mode not activated by default => Update session table */
    if ((!$vbulletin->options['mgc_cb_evo_inactive_mode'] || ($vbulletin->options['mgc_cb_evo_inactive_mode'] && !$vbulletin->options['mgc_cb_evo_inactive_mode_onload'])) && $vbulletin->options['mgc_cb_evo_whoisonline_active']) {
        $vbulletin->db->query_write("REPLACE INTO " . TABLE_PREFIX . "mgc_cb_evo_session SET userid='" . $vbulletin->userinfo['userid'] . "',dateline='" . TIMENOW . "'");
    }


    /* Retrieving of commands permissions to activate the autocompletion */
    $autocompletion_js_array = array();

    if ($vbulletin->options['mgc_cb_evo_act_autocompletion']) {
        $commands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE active='1'");
        
        while ($command = $vbulletin->db->fetch_array($commands)) {
            if (mgc_cb_evo_can_use_command($command)) {
                $show['mgc_cb_evo_command_' . $command['identifier']] = true;

                /* If autocompletion is active, add commands tips to autocompletion array */
                if ($vbulletin->options['mgc_cb_evo_act_autocompletion']) {
                    $append_array = get_command_autocompletion_array($command['identifier']);
                    $autocompletion_js_array = array_merge($autocompletion_js_array,$append_array);
                }
            } else {            
                $show['mgc_cb_evo_command_' . $command['identifier']] = false;
            }
        }
        
        if (sizeof($autocompletion_js_array)) {
            /* Order table alphabetically */
            sort($autocompletion_js_array);
            
            /* Implode array */
            $autocompletion_js = implode(',',$autocompletion_js_array);
        }
    }       

    $show['mgc_cb_evo_smilies'] = 0;
    $show['mgc_cb_evo_bbcodes'] = 0;
    $show['mgc_cb_evo_promptmsg'] = (can_see_promptmsg() && $vbulletin->options['mgc_cb_evo_input_prompt']) ? 1 : 0;

    /* Smileys display if activated */
    if ($vbulletin->options['mgc_cb_evo_smileys']) {
        $smilies = build_smileys_selector_display();
        /* Only show smilies if any */
        if (!empty($smilies)) {
            $show['mgc_cb_evo_smilies'] = 1;
        }
    }

    /* BBCODE display if activated */
    if ($vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_email'] || $vbulletin->options['mgc_cb_evo_bbcode_img']) {
        $bbcodes = build_bbcode_selector_display();
        $show['mgc_cb_evo_bbcodes'] = 1;
    }

    /* Retrieving of the channels */
    $sql_condition = "usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";           

    if (!empty($vbulletin->userinfo['membergroupids'])) {
        $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

        foreach ($ugipds_array as $index => $ugpid) {
            $sql_condition .= " OR usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
        }
    }

    $sql_condition .= " OR userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";

    $channels_bit = '';
    $getchannels = $vbulletin->db->query_read("
      SELECT chanid,title,img_name
      FROM " . TABLE_PREFIX . "mgc_cb_evo_channel
      WHERE active='1' AND $sql_condition      
      ORDER BY chanorder ASC
   ");
    
    if ($vbulletin->db->num_rows($getchannels)) {
        $show['genchan'] = 1;
        while($channel = $vbulletin->db->fetch_array($getchannels)) {
            $channel_ids[] = $channel['chanid'];
            $channel['title'] = htmlspecialchars_uni($channel['title']);
            eval('$channels_bit .= "' . fetch_template('mgc_cb_evo_channel_button') . '";');
        }
        
        $js_channels_ids_array = 'var channels_ids = new Array("' . implode('","',$channel_ids) . '")';
    }
    
    /* Chatbox announcement parsing */
    if ($vbulletin->options['mgc_cb_evo_bbcode_in_chatbox_announcement']) {
        require_once(DIR . '/includes/class_bbcode.php'); 
        $parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list()); 
        $vbulletin->options['mgc_cb_evo_announcement'] = $parser->do_parse($vbulletin->options['mgc_cb_evo_announcement'], true, true, true, true, false, false);   
    }
    
    /* Who is online in the chatbox display */
    if ($vbulletin->options['mgc_cb_evo_whoisonline_active']) {
        $show['mgc_cb_evo_whoisonline'] = true;
        
        /* Get whosonline only if not in a tab mode */
        if (!$vbulletin->options['mgc_cb_evo_whoisonline_showintab']) {
            /* Inactive mode active and delay < session delay => inactive mode delay taken */
            if ($vbulletin->options['mgc_cb_evo_inactive_mode'] && $vbulletin->options['mgc_cb_evo_inactive_mode_delay'] < $vbulletin->options['mgc_cb_evo_whoisonline_delay']) {
                $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_inactive_mode_delay'] * 60);
            } else {
                $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_whoisonline_delay'] * 60);
            }
            
            $getusers = $vbulletin->db->query_read("
			  SELECT u.username,u.displaygroupid,u.userid,
				 (u.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible
			  FROM " . TABLE_PREFIX . "mgc_cb_evo_session AS cbs
			  LEFT JOIN " . TABLE_PREFIX . "user AS u ON (cbs.userid=u.userid)
			  WHERE cbs.dateline>='$dateline' AND cbs.userid!=0    
			");
            
            if ($vbulletin->db->num_rows($getusers)) {
                $show['mgc_cb_evo_nouser_online'] = false;
                $users_online['nb'] = 0;
                
                $first = 1;
                while ($user = $vbulletin->db->fetch_array($getusers)) {
                    if ($user['invisible']) {
                        if (($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden']) OR $user['userid'] == $vbulletin->userinfo['userid']) {
                            if ($user['userid']) {
                                $users_online['nb']++;
                                
                                if (!$first) {
                                    $users_online['list'] .= ', ';
                                } else {
                                    $first = 0;
                                }
                                
                                $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>*';
                            }
                        }
                    } else {
                        if ($user['userid']) {
                            $users_online['nb']++;
                            
                            if (!$first) {
                                $users_online['list'] .= ', ';
                            } else {
                                $first = 0;
                            }
                            
                            $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>';
                        }
                    }                  
                }
            }
        } else {
            $show['mgc_cb_evo_nouser_online'] = true;
        }
    }
    
    /** Management of the chatbox editors state **/
    
    /* Collapse reset for buttons if not keeped */
    if (!$vbulletin->options['mgc_cb_evo_keep_editor_state']) {
    	/* Do not collapse if bbcode editor shall be displayed by default */
    	if (!$vbulletin->options['mgc_cb_evo_bbcode_editor_default']) {
    	    $vbcollapse['collapseimg_mgc_cb_evo_bbcodes'] = "_collapsed";
    		$vbcollapse['collapseobj_mgc_cb_evo_bbcodes'] = "display: none";
    	}
    	/* Do not collapse if smilies editor shall be displayed by default */
    	if (!$vbulletin->options['mgc_cb_evo_smilies_editor_default']) {
        	$vbcollapse['collapseimg_mgc_cb_evo_smilies'] = "_collapsed";
       		$vbcollapse['collapseobj_mgc_cb_evo_smilies'] = "display: none";
    	}    	
        $vbcollapse['collapseimg_mgc_cb_evo_help'] = "_collapsed";
        $vbcollapse['collapseobj_mgc_cb_evo_help'] = "display: none";
    }
    
    $vbcollapse['collapseimg_mgc_cb_evo_online'] = "_collapsed";
    $vbcollapse['collapseobj_mgc_cb_evo_online'] = "display: none";

	/** Management of the chatbox state **/
	
	/* Chatbox forced as collapsed by default ? */
	if ($vbulletin->options['mgc_cb_evo_force_default_collapsed'])
	{
		$vbcollapse['collapseimg_mgc_cb_evo'] = "_collapsed";
		$vbcollapse['collapseobj_mgc_cb_evo'] = "display: none";
	}

    $show['mgc_cb_evo_editor'] = can_use_mgc_cb_evo();
    
    eval('$mgc_cb_evo_editor = "' . fetch_template('mgc_cb_evo_editor') . '";');
    
    eval('$mgc_cb_evo = "' . fetch_template('mgc_cb_evo') . '";');

    return $mgc_cb_evo;
}

function construct_mgc_cb_evo_table_col($td_content,$td_width,$td_class = 'alt1',$tr_start = false, $tr_end = false, $td_align = 'left', $td_colspan = '0') {
    global $vbulletin,$stylevar;
    
    eval('$table_col = "' . fetch_template('mgc_cb_evo_table_bit') . '";');
    return $table_col;
}

function construct_mgc_cb_evo_table($table_content) {
    global $vbulletin,$stylevar;
    
    eval('$table = "' . fetch_template('mgc_cb_evo_table') . '";');
    return $table;  
}

function consruct_mgc_cb_evo_table_row_close_popup($colspan = 2) {
    global $vbphrase;
    return '<tr><td class="tfoot" align="center" ' . ($colspan ? 'colspan="' . $colspan . '"' : '') . '><input type="button" onclick=" return window.close();" class="button" tabindex="1" value="' . $vbphrase['mgc_cb_evo_close_popup'] . '" accesskey="s" /></td></tr>';
}

function mgc_cb_evo_can_use_command($command) {
    global $vbulletin;
    
    /* Chatbox is not active or user can't access and use the chatbox => Error */
    if (! ($vbulletin->options['mgc_cb_evo_active'] &&  can_view_mgc_cb_evo() && can_use_mgc_cb_evo()) ) {
        return 0;
    }
    
    if (!empty($command['usergroupids'])) {
        $usergroupids = explode(',',$command['usergroupids']);
        
        if (in_array($vbulletin->userinfo['usergroupid'],$usergroupids)) {
            return 1;
        }
        
        if (!empty($vbulletin->userinfo['membergroupids'])) {
            $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);
            
            foreach ($ugipds_array as $index => $ugpid) {
                if (in_array($ugpid,$usergroupids)) {
                    return 1;
                }            
            }
        }
    }
    
    if (!empty($command['userids'])) {
        $userids = explode(',',$command['userids']);
        
        if (in_array($vbulletin->userinfo['userid'],$userids)) {
            return 1;
        }
    }
    
    return 0;
}

function get_user_number_of_chats() {
    global $vbulletin;
    
    $getnbchats = $vbulletin->db->query_first("
      SELECT COUNT(chatid) AS nbchats
      FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
      WHERE (fromuid='" . $vbulletin->userinfo['userid'] . "') 
   ");
    
    return $getnbchats['nbchats'];
}

function get_number_of_chats($last24h = false) {
    global $vbulletin;
    
    /* Constructing the REGEXP for the commands and channels */
    $sql_condition_co = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
    $sql_condition_ch = "ch.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";   

    if (!empty($vbulletin->userinfo['membergroupids'])) {
        $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

        foreach ($ugipds_array as $index => $ugpid) {
            $sql_condition_co .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
            $sql_condition_ch .= " OR ch.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";         
        }
    }
    
    $sql_condition_co .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";   
    $sql_condition_ch .= " OR ch.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";

    $sql_condition_co = "(co.active='1' AND $sql_condition_co)";
    $sql_condition_ch = "((c.chanid='0') OR (ch.active='1' AND ($sql_condition_ch)))";

    $getnbchats = $vbulletin->db->query_first("
		SELECT COUNT(chatid) AS nbchats
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
                LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.coidentifier=co.identifier)
                LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (c.chanid=ch.chanid)
		WHERE 
		  ((c.coidentifier='0' AND $sql_condition_ch) OR ($sql_condition_co AND $sql_condition_ch))
		  " . ($last24h ? "AND dateline>'" . (TIMENOW - (24 * 60 * 60)) . "'" : "") . "
		  AND (fromuid<>'0' AND (c.coidentifier<>'pm' OR (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "')))
	");   
    
    return $getnbchats['nbchats'];
}

function get_top_x($dotable = false) {
    global $vbulletin,$vbphrase,$session;

    require_once(DIR . '/includes/class_bbcode.php');

    /* Constructing the REGEXP for the commands and channels */
    $sql_condition_co = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
    $sql_condition_ch = "ch.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";   

    if (!empty($vbulletin->userinfo['membergroupids'])) {
        $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

        foreach ($ugipds_array as $index => $ugpid) {
            $sql_condition_co .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
            $sql_condition_ch .= " OR ch.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";         
        }
    }
    
    $sql_condition_co .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";   
    $sql_condition_ch .= " OR ch.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";

    $sql_condition_co = "(co.active='1' AND $sql_condition_co)";
    $sql_condition_ch = "((c.chanid='0') OR (ch.active='1' AND ($sql_condition_ch)))";

    $get_top_x = $vbulletin->db->query_read("
	     SELECT COUNT(chatid) AS nbchats,u.userid,u.username,u.displaygroupid,u.usergroupid
	     FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
             LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.coidentifier=co.identifier)
             LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (c.chanid=ch.chanid)
	     LEFT JOIN " . TABLE_PREFIX ."user AS u ON (c.fromuid=u.userid)
	     WHERE 
	       ((c.coidentifier='0' AND $sql_condition_ch) OR ($sql_condition_co AND $sql_condition_ch))
	       " . ($last24h ? "AND dateline>'" . (TIMENOW - (24 * 60 * 60)) . "'" : "") . "
	       AND (fromuid<>'0' AND (c.coidentifier<>'pm' OR (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "')))
	     GROUP BY c.fromuid
	     ORDER BY nbchats DESC
	     LIMIT 0 , " . $vbulletin->options['mgc_cb_evo_archives_stats_nbtopshouters'] . "
   ");   
    
    $top_x = '';

    /* Do table in archives */
    if($dotable) {
        if($vbulletin->db->num_rows($get_top_x)) {
            while($shouter = $vbulletin->db->fetch_array($get_top_x)) {
                $top_x .= '<tr><td class="alt2" width="100%" align="left">';
                $top_x .= '<a style="text-decoration: none"  href="member.php?' . $session['sessionurl'] .'u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
                $top_x .= '</td>';
                $top_x .= '<td class="alt1" align="center">' . $shouter['nbchats'] . '</td></tr>';
            }
        } else {
            $top_x = "<tr><td align='center' colspan='2'>" . $vbphrase['mgc_cb_evo_no_shouters'] . "</td></tr>";
        }
    } else {        
        if($vbulletin->db->num_rows($get_top_x)) {
            while($shouter = $vbulletin->db->fetch_array($get_top_x)) {
                $top_x .= '<a style="text-decoration: none"  href="member.php?' . $session['sessionurl'] .'u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
                $top_x .= '&nbsp;(' . $shouter['nbchats'] . ')&nbsp;';
            }
        } else {
            $top_x = $vbphrase['mgc_cb_evo_no_shouters'];
        }
    }

    return $top_x;
}

function construct_mgc_cb_evo_forumhome_stats() {
    global $vbulletin,$vbphrase,$session;

    return construct_phrase($vbphrase['mgc_cb_evo_stats_forumhome'],$vbulletin->options['mgc_cb_stats_nbtopshouters'],get_top_x(), get_number_of_chats(), get_number_of_chats(true), get_user_number_of_chats());
}

function get_command_autocompletion_array($command_identifier) {
    global $vbphrase;
    
    $autocompletion_js_array = array();
    
    switch ($command_identifier) {
      case "announcement" :
        $autocompletion_js_array[] = "\"/announcement " . $vbphrase['mgc_cb_evo_your_announcement'] . "\"";
        $autocompletion_js_array[] = "\"/announcement remove\"";
        break;
      case "ban" :
        $autocompletion_js_array[] = "\"/ban on uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/ban on uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban h " . $vbphrase['mgc_cb_evo_number_of_hours'] . " uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban h " . $vbphrase['mgc_cb_evo_number_of_hours'] . " uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";                  
        $autocompletion_js_array[] = "\"/ban d " . $vbphrase['mgc_cb_evo_number_of_days'] . " uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban d " . $vbphrase['mgc_cb_evo_number_of_days'] . " uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";       
        $autocompletion_js_array[] = "\"/ban off uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/ban off uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/ban show\"";	
        break;
      case "del" :
        $autocompletion_js_array[] = "\"/del all\"";
        $autocompletion_js_array[] = "\"/del chan\"";
        $autocompletion_js_array[] = "\"/del days " . $vbphrase['mgc_cb_evo_number_of_days'] . "\"";	
        $autocompletion_js_array[] = "\"/del uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/del uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        break;
      case "ignore" :
        $autocompletion_js_array[] = "\"/ignore on uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/ignore on uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ignore off uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/ignore off uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/ignore show\"";		
        break;
      case "me" :
        $autocompletion_js_array[] = "\"/me " . $vbphrase['mgc_cb_evo_your_message'] . "\"";		
        break;
      case "pm" :
        $autocompletion_js_array[] = "\"/pm uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . " " . $vbphrase['mgc_cb_evo_your_message'] . "\"";	
        $autocompletion_js_array[] = "\"/pm uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . " " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
        $autocompletion_js_array[] = "\"/pm " . $vbphrase['mgc_cb_evo_your_message'] . "\"";		
        break;
      case "slap" :        
        $autocompletion_js_array[] = "\"/slap uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";	
        $autocompletion_js_array[] = "\"/slap uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        break;
    }
    
    return $autocompletion_js_array;
}

function identifier_can_use_command($command_identifier) {
    global $vbulletin;
    
    /* Get pm command permissions */
    $getpmpermissions = $vbulletin->db->query_first("
		SELECT usergroupids,userids
		FROM " . TABLE_PREFIX . "mgc_cb_evo_command
		WHERE identifier='$command_identifier'
     ");

    /** It's time to check if the user has access to the command */
    $authorized = 0;

    /* Usergroupids */
    if (!empty($getpmpermissions['usergroupids'])) {
        $ugipds_array = explode(',',$getpmpermissions['usergroupids']);
        
        if (in_array($vbulletin->userinfo['usergroupid'],$ugipds_array)) {
            $authorized = 1;
        }
        
        if (!empty($vbulletin->userinfo['membergroupids'])) {
            $mgids_array = explode(',', $vbulletin->userinfo['membergroupids']);

            foreach ($mgids_array as $index => $mgpid) {
                if (in_array($mgpid,$ugipds_array)) {
                    $authorized = 1;
                }
            }
        }      
    }
    
    /* Userids if not already authorized */
    if (!$authorized && !empty($getpmpermissions['userids'])) {
        $uids_array = explode(',',$getpmpermissions['userids']);
        
        if (in_array($vbulletin->userinfo['userid'],$uids_array)) {
            $authorized = 1;
        }
    }
    
    return $authorized;
}

function get_avatar_chatbox($userinfo) {
	global $vbulletin, $stylevar;

	if (!empty($userinfo['avatarpath'])) {
		/* Non custom avatar */
		if ($thumb) {
			if (@file_exists(DIR . '/images/avatars/thumbs/' . $userinfo['avatarid'] . '.gif')) {
				$avatarurl = 'images/avatars/thumbs/' . $userinfo['avatarid'] . '.gif';
			} else {
				$avatarurl = $userinfo['avatarpath'];
			}
		} else {
			$avatarurl = $userinfo['avatarpath'];
		}
	} else if ($userinfo['hascustom'] OR $userinfo['hascustomavatar']) {
		/* User custom avatar */
		if ($vbulletin->options['usefileavatar']) {
			if ($thumb AND @file_exists($vbulletin->options['avatarpath'] . "/thumbs/avatar$userinfo[userid]_$userinfo[avatarrevision].gif")) {
				$avatarurl = $vbulletin->options['avatarurl'] . "/thumbs/avatar$userinfo[userid]_$userinfo[avatarrevision].gif";
			} else {
				$avatarurl =  $vbulletin->options['avatarurl'] . "/avatar$userinfo[userid]_$userinfo[avatarrevision].gif";
			}
		} else {
			if ($thumb AND $userinfo['filedata_thumb'])	{
				$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userinfo['userid'] . "&amp;dateline=$userinfo[avatardateline]&amp;type=thumb";
			} else {
				$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userinfo['userid'] . "&amp;dateline=$userinfo[avatardateline]";
			}
		}
	}

	/* No avatar => show no avatar image */
	if (empty($avatarurl)) {
		$avatarurl = $stylevar['imgdir_misc'] . '/mgc_cb_evo/noavatar.jpg';
	}
	
	return $avatarurl;
}

?>