<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~ E_NOTICE);

@header('Content-type: text/html; charset=windows-1252');

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'mgc_cb_evo'); // change this depending on your filename
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('pm', 'banning');

// get special data templates from the datastore
$specialtemplates = array('bbcodecache','smiliecache');

// pre-cache templates used by all actions
$globaltemplates = array(
   'GENERIC_SHELL',
   'mgc_cb_evo_archives',
   'mgc_cb_evo_archives_chatbit',
   'mgc_chatbox_archives_nobit',
   'mgc_cb_evo_channel_button',
   'mgc_cb_evo',
   'mgc_cb_evo_editor',
   'mgc_cb_evo_chatbit',
   'mgc_cb_evo_chatbit_menu',
   'editor_jsoptions_font',
   'editor_jsoptions_size',
   'mgc_cb_evo_help',
   'mgc_cb_evo_help_bit',
   'mgc_cb_evo_smilies',
   'mgc_cb_evo_rules',
   'mgc_cb_evo_table',
   'mgc_cb_evo_table_bit'
);

// ######################### REQUIRE BACK-END ############################
require_once ('./global.php');
require_once (DIR . '/includes/functions_mgc_cb_evo.php');
require_once (DIR . '/includes/class_bbcode.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

/* Chatbox active ?? */
if (!$vbulletin->options['mgc_cb_evo_active'])
{
   exit;
}

if (empty($_REQUEST['do']))
{
   if ($vbulletin->options['mgc_cb_evo_fullmode_active'])
   {
      $_REQUEST['do'] = "view_chatbox";
   }
   else
   {
      $_REQUEST['do'] = "view_archives";
   }
}

if ($_REQUEST['do'] == "view_archives")
{
   /* Can access to chatbox and archives and is not banned */
   if (!(can_view_mgc_cb_evo() && can_view_mgc_cb_evo_archives()))
   {
      print_no_permission();
   }

   $channel_id = $vbulletin->input->clean_gpc('r', 'channel_id', TYPE_UINT);

   if (empty($channel_id))
   {
      $channel_id = 0;
   }
   else
   {
      /* Let's check if the channel exists */
      $checkchannel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='$channel_id'");
      
      if (!$checkchannel)
      {
         eval(standard_error(fetch_error('mgc_cb_evo_archives_channel_error')));
      }
   }
   
	/** Retrieving of the commands permissions and status **/
	$getcommands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command");
	
	$ugipds_array = array($vbulletin->userinfo['usergroupid']);
	if (!empty($vbulletin->userinfo['membergroupids']))
	{
		$ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);
	}	

	$identifier_array = array('\'0\'');
	
	while($command = $vbulletin->db->fetch_array($getcommands))
	{
		if ($command['active'])
		{
			$hasaccess = 0;
		
			if (!empty($command['usergroupids']))
			{
				$command_ugpids_array = explode(',',$command['usergroupids']);
				
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$command_ugpids_array))
					{
						$hasaccess = 1;
					}
				}
			}
			
			if (!empty($command['userids']))
			{
				$command_uids_array = explode(',',$command['userids']);
				
				if (in_array($vbulletin->userinfo['userid'],$command_uids_array))
				{
					$hasaccess = 1;
				}
			}
			
			if ($hasaccess)
			{
				$identifier_array[] = "'" . $command['identifier'] . "'";
				$commands_status["$command[identifier]"] = '1';								
			}
			else
			{
				$commands_status["$command[identifier]"] = '0';		
			}
		}
		else
		{
			$commands_status["$command[identifier]"] = '0';		
		}
	}      
	
	unset($getcommands);

	/** Building the chats retrieving query **/
			
	/* Not private chats where clause */      
	$where_clause = "chanid='$channel_id' AND coidentifier IN (" . implode(',',$identifier_array) . ") AND (touid='0' OR fromuid='" . $vbulletin->userinfo['userid'] . "'OR touid='" . $vbulletin->userinfo['userid'] . "')";      

	/* Ignore command where clause */      
	if ($commands_status['ignore'] && !empty($vbulletin->userinfo['mgc_cb_evo_ignored']))
	{
		$where_clause .= " AND fromuid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
		$where_clause .= " AND touid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
	}

   $perpage = $vbulletin->options['mgc_cb_evo_archives_nbchats_per_page'];
   $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

   /* Count of the chats */
   $getnbchats = $vbulletin->db->query_first("
		SELECT COUNT(chatid) AS nbchats
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
		WHERE $where_clause
		ORDER BY c.dateline DESC
  ");     
  
   sanitize_pageresults($getnbchats['nbchats'], $pagenumber, $perpage, 100, 25);

   /* page min / page max */
   $limitlower = ($pagenumber - 1) * $perpage + 1;
   $limitupper = $pagenumber * $perpage;
   if ($limitupper > $getnbchats['nbchats'])
   {
      $limitupper = $getnbchats['nbchats'];
      if ($limitlower > $getnbchats['nbchats'])
      {
         $limitlower = $getnbchats['nbchats'] - $perpage;
      }
   }
   if ($limitlower <= 0)
   {
      $limitlower = 1;
   }

   $pagenav = construct_page_nav($pagenumber, $perpage, $getnbchats['nbchats'], $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=view_archives&channel_id=' . $channel_id);  
  
   /* Retrieving of the chats */
   $chats = $vbulletin->db->query_read("
		SELECT c.*,fromu.userid AS fromuserid,fromu.username AS fromusername,fromu.usergroupid AS fromusergroupid,fromu.displaygroupid AS fromdisplaygroupid,tou.userid AS touserid,tou.username AS tousername,tou.usergroupid AS tousergroupid,tou.displaygroupid AS todisplaygroupid,
		avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb,fromu.avatarid,fromu.avatarrevision
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = fromu.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = fromu.userid)
		WHERE $where_clause
		ORDER BY c.dateline DESC
      	LIMIT " . ($limitlower - 1) . ", $perpage
  	");

   if ($vbulletin->db->num_rows($chats))
   {
      $parsebbcode = $vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_img'];
      
      $alt = 2;
      
      /* Ascending */
      if ($vbulletin->options['mgc_cb_evo_archives_chats_order'])
      {
         $cpt = $nbchats - 1;
         while ($chat = $vbulletin->db->fetch_array($chats))
         {                           
            $chats_table["$cpt"] = fetch_chat_info($chat, $parsebbcode, $commands_status, $channel_id,$alt,1);
            $chats_menu_register .= "vbmenu_register('test_+ $chat[chatid]');";
            $cpt--;
            
            if ($vbulletin->options['mgc_cb_evo_alt_colors'])
            {
               if ($alt == 2)
               {
                  $alt = 1;
               }
               else
               {
                  $alt = 2;
               }
            }               
         }
         ksort($chats_table);
      }
      else
      {
         $cpt = 0;
         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $chats_table["$cpt"] = fetch_chat_info($chat, $parsebbcode, $commands_status, $channel_id,$alt,1);
            $cpt++;
            
            if ($vbulletin->options['mgc_cb_evo_alt_colors'])
            {
               if ($alt == 2)
               {
                  $alt = 1;
               }
               else
               {
                  $alt = 2;
               }
            }                 
         }                                    
      }
      
      foreach($chats_table AS $id => $chat)
      {
         $chatbit .= $chat;
      }
   }
   
   /* Stats */
   $mgc_cb_evo_stats['top_x']       = get_top_x(true);
   $mgc_cb_evo_stats['chats']       = get_number_of_chats();
   $mgc_cb_evo_stats['your_chats']  = get_user_number_of_chats();
   $mgc_cb_evo_stats['chats_24h']   = get_number_of_chats(true);

   /* Archive Type Select */
   /* Constructing the usergroupids REGEXP */
   $sql_condition = "( usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

   if (!empty($vbulletin->userinfo['membergroupids']))
   {
      $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

      foreach ($ugipds_array as $index => $ugpid)
      {
         $sql_condition .= " OR usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
      }
   }
   
   $sql_condition .= " OR userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$') )";
   
   $getchannels = $vbulletin->db->query_read("
      SELECT ch.chanid,ch.title,ch.img_name
      FROM " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch
      WHERE ch.active=1 AND $sql_condition      
   ");
   
   $show['mgc_cb_evo_archive_type_select'] = false;
      
   if ($vbulletin->db->num_rows($getchannels))
   {
      $show['mgc_cb_evo_archive_type_select'] = true; 
         
      if ($channel_id == -1)
      {  
         $navtext = $vbphrase['mgc_cb_evo_archives_main_channel'];
         $archive_selectbit = "<option value=\"0\" selected=\"selected\">$vbphrase[mgc_cb_evo_archives_main_channel]</option>";
      }
      else
      {
         $archive_selectbit = "<option value=\"0\">$vbphrase[mgc_cb_evo_archives_main_channel]</option>";
      }    
      while($channel = $vbulletin->db->fetch_array($getchannels))
      {
         if ($channel_id == $channel['chanid'])
         {       
            $navtext = construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']);  
            $archive_selectbit .= "<option value=\"" . $channel['chanid'] . "\" selected=\"selected\">" . construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']) . "</option>";
         }
         else
         {
            $archive_selectbit .= "<option value=\"" . $channel['chanid'] . "\">" . construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']) . "</option>";
         }
      }
   }   

   /* Can download shouts permission */
   $show['archives_download'] = can_download_mgc_cb_evo_archives() && !empty($chatbit);
   
   /* Can manage chatbox permission */
   $show['delete_column'] = can_manage_mgc_cb_evo();

   eval('$HTML = "' . fetch_template('mgc_cb_evo_archives') . '";');

   $navbits = array();
   // change the line below to contain whatever you want to show in the navbar (title of your custom page)
   $navbits[$parent] = $vbulletin->options['mgc_cb_evo_title'] . (!empty($navtext) ? ' : ' . $navtext : '');

   $navbits = construct_navbits($navbits);
   eval('$navbar = "' . fetch_template('navbar') . '";');

   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

if ($_REQUEST['do'] == 'save_archives')
{
   if (!can_download_mgc_cb_evo_archives())
   {
      print_no_permission();
   }

   require_once (DIR . '/includes/functions_file.php');

   $format     = $vbulletin->input->clean_gpc('r', 'format', TYPE_NOHTML);   
   $channel_id = $vbulletin->input->clean_gpc('r', 'channel_id', TYPE_UINT);

   if (empty($channel_id))
   {
      $channel_id = 0;
   }

   if ($channel_id)
   {
      $sql_condition = "( usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
   
      if (!empty($vbulletin->userinfo['membergroupids']))
      {
         $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);
   
         foreach ($ugipds_array as $index => $ugpid)
         {
            $sql_condition .= " OR usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
         }
      }
      
      $sql_condition .= " OR userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$') )";
      
      $getchannel = $vbulletin->db->query_first("
         SELECT ch.*
         FROM " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch
         WHERE ch.active=1 AND $sql_condition      
      ");
      
      if (!$getchannel)
      {
         print_no_permission();
      }
      
   }

	/** Retrieving of the commands permissions and status **/
	$getcommands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command");
	
	$ugipds_array = array($vbulletin->userinfo['usergroupid']);
	if (!empty($vbulletin->userinfo['membergroupids']))
	{
		$ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);
	}	

	$identifier_array = array('\'0\'');
	
	while($command = $vbulletin->db->fetch_array($getcommands))
	{
		if ($command['active'])
		{
			$hasaccess = 0;
		
			if (!empty($command['usergroupids']))
			{
				$command_ugpids_array = explode(',',$command['usergroupids']);
				
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$command_ugpids_array))
					{
						$hasaccess = 1;
					}
				}
			}
			
			if (!empty($command['userids']))
			{
				$command_uids_array = explode(',',$command['userids']);
				
				if (in_array($vbulletin->userinfo['userid'],$command_uids_array))
				{
					$hasaccess = 1;
				}
			}
			
			if ($hasaccess)
			{
				$identifier_array[] = "'" . $command['identifier'] . "'";
				$commands_status["$command[identifier]"] = '1';								
			}
			else
			{
				$commands_status["$command[identifier]"] = '0';		
			}
		}
		else
		{
			$commands_status["$command[identifier]"] = '0';		
		}
	}      
	
	unset($getcommands);

	/** Building the chats retrieving query **/
			
	/* Not private chats where clause */      
	$where_clause = "chanid='$channel_id' AND coidentifier IN (" . implode(',',$identifier_array) . ") AND (touid='0' OR fromuid='" . $vbulletin->userinfo['userid'] . "'OR touid='" . $vbulletin->userinfo['userid'] . "')";  

   /* Retrieving of the chats */
   $chats = $vbulletin->db->query_read("
		SELECT c.ctext,c.dateline,fromu.userid AS fromuserid,fromu.username AS fromusername,tou.userid AS touserid,tou.username AS tousername
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
      LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
      LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.coidentifier=co.identifier)
		WHERE $where_clause
		ORDER BY c.dateline DESC
  ");

   /* Error : no chats to download */
   if (!$db->num_rows($chats))
   {
      eval(standard_error(fetch_error('mgc_cb_evo_nochats_to_download')));
   }
   
   if ($channel_id)
   {
      $channel_name = $getchannel['title'];
   }
   else
   {
      $channel_name = $vbphrase['mgc_cb_evo_archives_main_channel'];
   }

   switch ($vbulletin->GPC['format'])
   {
      case 'txt':
         $txt = "################################################################################\r\n";
         $txt .= "MGC Chatbox EVO DUMP - $channel_name\r\n";
         $txt .= $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] . "\r\n";
         $txt .= vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'],
            TIMENOW) . "\r\n";
         $txt .= "################################################################################\r\n\r\n";

         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $chat['ctext'] = fetch_censored_text($chat['ctext']);
            $txt .= "==========================================================\r\n";
            $txt .= vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false) . " - $chat[fromusername] : ";            
            $txt .= "$chat[ctext]\r\n";               
         }
         $txt .= "==========================================================\r\n";

         unset($chat);
         $vbulletin->db->free_result($getchats);

         // download the file
         file_download($txt, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" .
            $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'],
            TIMENOW) . '.txt'), 'text/plain');
         break;

      case 'csv':
         // column headers
         $csv = "$vbphrase[date],$vbphrase[username],$vbphrase[mgc_cb_evo_chats]\r\n";

         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $csv_chat['dateline'] = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false);
            $csv_chat['username'] = $chat['fromusername'];                
            $csv_chat['ctext'] = fetch_censored_text($chat['ctext']);

            foreach ($csv_chat as $key => $val)
            {
               if (preg_match('/\,|"/siU', $val))
               {
                  $csv_chat["$key"] = '"' . str_replace('"', '""', $val) . '"';
               }
            }

            // output the message row
            $csv .= implode(',', $csv_chat) . "\r\n";
         }
         unset($chat);
         $vbulletin->db->free_result($getchats);

         // download the file
         file_download($csv, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" .
            $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'],
            TIMENOW) . '.csv'), 'text/x-csv');

         break;

      case 'xml':
         require_once (DIR . '/includes/class_xml.php');
         $xml = new vB_XML_Builder($vbulletin);

         $xml->add_group('mgc_cb_evo_chats');

         while ($chat = $vbulletin->db->fetch_array($chats))
         {
            $xml_chat['dateline'] = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false);
            $xml_chat['user'] = $chat['fromusername'];
            $xml_chat['ctext'] = fetch_censored_text($chat['ctext']);

            $xml->add_group('mgc_chatbox_chat');
            foreach ($xml_chat as $key => $val)
            {
               $xml->add_tag($key, $val);
            }
            $xml->close_group();
         }

         unset($chat);
         $vbulletin->db->free_result($getchats);

         $xml->close_group();

         $doc = "<?xml version=\"1.0\" encoding=\"$stylevar[charset]\"?>\r\n\r\n";
         $doc .= "<!-- MGC CHATBOX EVO XML DUMP - $channel_name -->";
         $doc .= "<!-- " . $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] .
            " -->\r\n";
         $doc .= '<!-- ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->
            options['timeformat'], TIMENOW) . " -->\r\n\r\n";

         $doc .= $xml->output();
         $xml = null;

         // download the file
         file_download($doc, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" .
            $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'],
            TIMENOW) . '.xml'), 'text/xml');

         break;

         // *****************************
         // unknown download format
      default:
         eval(standard_error(fetch_error('invalidid', $vbphrase['file_type'], $vbulletin->
            options['contactuslink'])));

   }

}

/* Chatbox display in full mode */
if ($_REQUEST['do'] == "view_chatbox")
{
   /* The user can't view the chatbox or full mode is not yet enabled ? */
   if (!can_view_mgc_cb_evo() || !$vbulletin->options['mgc_cb_evo_fullmode_active'])
   {
      print_no_permission();
   }

   $HTML = build_mgc_cb_evo_display($vbulletin->options['mgc_cb_evo_fullmode_height']);

   $navbits = array();
   // change the line below to contain whatever you want to show in the navbar (title of your custom page)
   $navbits[$parent] = $vbulletin->options['mgc_cb_evo_title'];

   $navbits = construct_navbits($navbits);
   eval('$navbar = "' . fetch_template('navbar') . '";');

   // change the line below to contain the name of the actual main output template used in your script
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

/* Help popup display */
if ($_REQUEST['do'] == "showhelp")
{
   if (!can_view_mgc_cb_evo() && !can_use_mgc_cb_evo())
   {
      print_no_permission();
   }
   
   /** Retrieving of the commands help phrases **/

   /* Constructing the usergroupids REGEXP */
   $sql_condition = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

   if (!empty($vbulletin->userinfo['membergroupids']))
   {
      $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

      foreach ($ugipds_array as $index => $ugpid)
      {
         $sql_condition .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
      }
   }
   
   $sql_condition .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";


   /* Retrieving the commands in the database */
   $getcommands = $vbulletin->db->query_read("
		SELECT identifier
		FROM " . TABLE_PREFIX . "mgc_cb_evo_command AS co
		WHERE co.active='1' AND ($sql_condition)
		ORDER BY identifier ASC
	");

   while ($command = $vbulletin->db->fetch_array($getcommands))
   {
   	$helpphrase = $vbphrase["mgc_cb_evo_cmd_$command[identifier]_helptxt"];
      eval('$customhelp .= "' . fetch_template('mgc_cb_evo_help_bit') . '";');
   }
   
   
   eval('$HTML = "' . fetch_template('mgc_cb_evo_help') . '";');

   $header = '';
   $footer = '';
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

if ($_POST['do'] == 'inline_remove_chats')
{
   if (!can_manage_mgc_cb_evo())
   {
      print_no_permission();
   }
   
   $vbulletin->input->clean_array_gpc('p', array('delchat' => TYPE_ARRAY_STR));
   
   /* No chats to remove */
   if (!$vbulletin->GPC['delchat'])
   {
      eval(standard_error(fetch_error('mgc_cb_evo_archives_no_chat_to_del')));      
   }
   
   $chatids = implode(',',array_keys($vbulletin->GPC['delchat']));
   
   $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid IN($chatids)");
   
   $vbulletin->url = 'mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . "do=view_archives";
	eval(print_standard_redirect('redirect_mgc_cb_evo_archives_chat_removed_successfully'));
}

/* All smilies window */
if ($_REQUEST['do'] == "showsmilies")
{
   if ((!can_view_mgc_cb_evo() && !can_use_mgc_cb_evo()) || !$vbulletin->options['mgc_cb_evo_smileys'])
   {
      print_no_permission();
   }   

   /* Retrieving smilies */
   $getsmilies = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "smilie ORDER BY displayorder ASC");
   
   if (!$vbulletin->db->num_rows($getsmilies))
   {
      print_no_permission();
   }
   
   $i = 0;
   
	while($smilie = $db->fetch_array($getsmilies))
   {
      if ($i == 0)
      {
         $smiliesbit .= "<tr>";
      }
      
      $smiliesbit .= "<td class=\"alt1\" align=\"center\"><a href=\"javascript:insert_smilie_from_window('$smilie[smilietext]')\"><img src=\"$smilie[smiliepath]\" alt=\"\" border=\"0\"></a></td>";
      
		$i++;
		
		if ($i == ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
      {
         $smiliesbit .= "</tr>";
			$i = 0;
		}
	}
	
	if ($i < ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
	{
      while($i < ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
      {
         $smiliesbit .= "<td class=\"alt1\"></td>";
         $i++;
      }
      $smiliesbit .= "</tr>";
   }
   
   eval('print_output("' . fetch_template('mgc_cb_evo_smilies') . '");');
}

/* Rules popup display */
if ($_REQUEST['do'] == "showrules")
{
   if ((!can_view_mgc_cb_evo() && !can_use_mgc_cb_evo()) || empty($vbulletin->options['mgc_cb_evo_rules']))
   {
      print_no_permission();
   } 
   
   eval('$HTML = "' . fetch_template('mgc_cb_evo_rules') . '";');

   $header = '';
   $footer = '';
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

/* Ignored users popup display */
if ($_REQUEST['do'] == "showignore")
{
	if (!identifier_can_use_command('ignore'))
	{
		print_no_permission();
	}
	
   if (empty($vbulletin->userinfo['mgc_cb_evo_ignored']))
   {
      $content = construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_ignored_list'],'100%','tcat',true, true, 'center');
      $content .= construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_no_ignored_user'],'100%','alt1',true, true, 'center');
      $content .= consruct_mgc_cb_evo_table_row_close_popup(0);      
      $HTML = "<br />" . construct_mgc_cb_evo_table($content);
   }
   else
   {
      /* Retrieving of the users */
      $ignored_users = $vbulletin->db->query_read("
         SELECT username,userid,usergroupid,displaygroupid
         FROM " . TABLE_PREFIX . "user
         WHERE userid IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")
         ORDER BY username ASC
      ");
      
      if (!$vbulletin->db->num_rows($ignored_users))
      {
         $content = construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_ignored_list'],'100%','tcat',true, true, 'center');
         $content .= construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_no_ignored_user'],'100%','alt1',true, true, 'center');
         $content .= consruct_mgc_cb_evo_table_row_close_popup(0);
         $HTML = "<br />" . construct_mgc_cb_evo_table($content);
      }
      
      $table_content = "";
      
      while($ignored_user = $vbulletin->db->fetch_array($ignored_users))
      {
         $table_content .= construct_mgc_cb_evo_table_col("<a href='memberlist.php?$session[sessionurl]u=$ignored_user[userid]'>" .
               fetch_musername($ignored_user,'displaygroupid') . "</a>",'75%','alt1',true);
        
         $table_content .= construct_mgc_cb_evo_table_col("<a href='" . $vbulletin->
               options['bburl'] . "/mgc_cb_evo.php?" . $vbulletin->session->vars['sessionurl'] .
               "do=unignore&uid=" . $ignored_user['userid'] . "' nofollow border='0'>[" . $vbphrase['mgc_cb_evo_unignore'] .
               "]</a>", '25%','alt2', false, true, 'center');
        
      }
      
      /* Table header */
      $table_header = construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_ignored_list'],'100%','tcat',true, true, 'center',2);
      $table_header .= construct_mgc_cb_evo_table_col($vbphrase['username'],'75%','thead',true);
      $table_header .= construct_mgc_cb_evo_table_col($vbphrase['action'],'25%','thead',false,true,'center');
      
      $table_footer =  consruct_mgc_cb_evo_table_row_close_popup(2);
      $HTML = "<br />" . construct_mgc_cb_evo_table($table_header . $table_content . $table_footer);
   }
   
   $header = '';
   $footer = '';
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

/* Unignore user */
if ($_REQUEST['do'] == 'unignore')
{
	if (!identifier_can_use_command('ignore'))
	{
		print_no_permission();
	}
	
   $userid = $vbulletin->input->clean_gpc('r', 'uid', TYPE_UINT);
   
   /* Lets check if the user exists */
   $getuser = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid='$userid'");
   
   if (!isset($getuser['userid']))
   {
      eval(standard_error(fetch_error('mgc_cb_evo_cmd_ignore_user_dont_exist')));
   }
   
   /* Verify if the user is in the ignored list */
   if (empty($vbulletin->userinfo['mgc_cb_evo_ignored']))
   {
      eval(standard_error(fetch_error('mgc_cb_evo_cmd_ignore_user_not_ignored')));      
   }
   
   $ignored_users = explode(',',$vbulletin->userinfo['mgc_cb_evo_ignored']);
   
   if (!in_array($userid,$ignored_users))
   {
      eval(standard_error(fetch_error('mgc_cb_evo_cmd_ignore_user_not_ignored')));      
   }
   /* Let's remove the user from the ignored list */
   foreach ($ignored_users as $index => $userid)
   {
	  if ($userid == $getuser['userid'])
      {
		 unset($ignored_users["$index"]);
	  }
   }
   
   $vbulletin->db->query_write("
      UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_ignored='" . implode(',',$ignored_users) . "' WHERE userid='" . $vbulletin->userinfo['userid'] . "'
   ");

   $vbulletin->url = $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showignore';
   eval(print_standard_redirect('mgc_cb_evo_cmd_ignore_user_successfully_unignored'));   
}

/* Show ban popup */
if ($_REQUEST['do'] == "showban")
{
	if (!identifier_can_use_command('ban'))
	{
		print_no_permission();
	}
	   
   /* Retrieving of the users */
   $banned_users = $vbulletin->db->query_read("
      SELECT username,userid,usergroupid,displaygroupid
      FROM " . TABLE_PREFIX . "user
      WHERE mgc_cb_evo_banned='1'
      ORDER BY username ASC
   ");   
   
   
   if (!$vbulletin->db->num_rows($banned_users))
   {
      $content = construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_bannedlist'],'100%','tcat',true, true, 'center');
      $content .= construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_no_banned_user'],'100%','alt1',true, true, 'center');
      $content .= consruct_mgc_cb_evo_table_row_close_popup(0);      
      $HTML = "<br />" . construct_mgc_cb_evo_table($content);
   }
   else
   {
      $table_content = "";
      
      while($banned_user = $vbulletin->db->fetch_array($banned_users))
      {
         $table_content .= construct_mgc_cb_evo_table_col("<a href='memberlist.php?$session[sessionurl]u=$banned_user[userid]'>" .
               fetch_musername($banned_user,'displaygroupid') . "</a>",'75%','alt1',true);
        
         $table_content .= construct_mgc_cb_evo_table_col("<a href='" . $vbulletin->
               options['bburl'] . "/mgc_cb_evo.php?" . $vbulletin->session->vars['sessionurl'] .
               "do=unban&uid=" . $banned_user['userid'] . "' nofollow border='0'>[" . $vbphrase['mgc_cb_evo_unban'] .
               "]</a>", '25%','alt2', false, true, 'center');
        
      }
      
      /* Table header */
      $table_header = construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_bannedlist'],'100%','tcat',true, true, 'center',2);
      $table_header .= construct_mgc_cb_evo_table_col($vbphrase['username'],'75%','thead',true);
      $table_header .= construct_mgc_cb_evo_table_col($vbphrase['action'],'25%','thead',false,true,'center');
      
      $table_footer =  consruct_mgc_cb_evo_table_row_close_popup(2);
      $HTML = "<br />" . construct_mgc_cb_evo_table($table_header . $table_content . $table_footer);
   }
   
   $header = '';
   $footer = '';
   eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
}

/* Unban user */
if ($_REQUEST['do'] == 'unban')
{
	if (!identifier_can_use_command('ban'))
	{
		print_no_permission();
	}

   $userid = $vbulletin->input->clean_gpc('r', 'uid', TYPE_UINT);
   
   /* Lets check if the user exists */
   $getuser = $vbulletin->db->query_first("SELECT userid,mgc_cb_evo_banned FROM " . TABLE_PREFIX . "user WHERE userid='$userid'");
   
   if (!isset($getuser['userid']))
   {
      eval(standard_error(fetch_error('mgc_cb_evo_cmd_ban_user_dont_exist')));
   }
      
   if (!$getuser['mgc_cb_evo_banned'])
   {
      eval(standard_error(fetch_error('mgc_cb_evo_cmd_ban_not_banned')));      
   }

   
   $vbulletin->db->query_write("
      UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_banned='0' WHERE userid='" . $getuser['userid'] . "'
   ");

   $vbulletin->url = $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showban';
   eval(print_standard_redirect('mgc_cb_evo_cmd_ignore_user_successfully_unbanned'));   
}

?>