<?php

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage_commands';
}

if ($_REQUEST['do'] == "manage_commands")
{
	print_cp_header($vbphrase['mgc_cb_evo_commands_mngt']);

	?>
	<script type="text/javascript">
	function js_page_jump(i, sid)
	{
		var sel = fetch_object("commandsel" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'command_disable': page = "mgc_cb_evo.php?do=command_enable&what=0&cid="; break;
				case 'command_enable': page = "mgc_cb_evo.php?do=command_enable&what=1&cid="; break;
				case 'command_ugp_perms': page = "mgc_cb_evo.php?do=command_manage_perms&cid="; break;
				default: return;
			}
			jumptopage = page + sid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	</script>
	<?php
	
	/** Command list **/
	
	/* Retrieving of the commands */
	print_form_header('mgc_cb_evo', 'command_mngt');
	construct_hidden_code('commandid', '');
	
	print_table_header($vbphrase['mgc_cb_evo_commands_list'], 4);
	print_cells_row(array($vbphrase['mgc_cb_evo_command_identifier'], $vbphrase['description'], $vbphrase['controls']), 1);
	
	// used for <select> id attribute
	$i = 0;

	$getcommands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command");
	
	while ($command = $vbulletin->db->fetch_array($getcommands))
	{
		$options = array();
		
		$options['command_ugp_perms'] = $vbphrase['mgc_cb_evo_command_edit_permissions'];
		
		if ($command['active'])
		{
			$options['command_disable'] = $vbphrase['disable'];
			$title =  $command['identifier'];
		}
		else
		{
			$options['command_enable'] = $vbphrase['enable'];
			$title = "<strike>" . $command['identifier'] . "</strike>";			
		}
		
		$i++;
		
		print_cells_row(array(
			$title,
			"<div align=\"center\">" . $vbphrase['mgc_cb_evo_command_desc_' . $command['identifier']] . "</div>",
			"<div align=\"$stylevar[right]\">
				<select name=\"s$command[cid]\" id=\"commandsel$i\" onchange=\"js_page_jump($i, '$command[cid]')\" class=\"bginput\">
					" . construct_select_options($options) . "
				</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump($i, '$command[cid]');\" />
			</div>"
		), false, '', -2);
	}
	
	print_table_footer();	
}

if ($_REQUEST['do'] == "command_enable")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT,
		'what'	=> TYPE_UINT
	));
	
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');
	
	/* Disabling of the command */
	if (!$vbulletin->GPC['what'])
	{		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command SET active='0' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		print_stop_message('mgc_cb_evo_command_successfully_disabled');	
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command SET active='1' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		print_stop_message('mgc_cb_evo_command_successfully_enabled');
	}
}

if ($_REQUEST['do'] == 'command_manage_perms')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT
	));   
	
	/* Check if the command exist and fetch it */
	$command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");
			
	print_cp_header($vbphrase['mgc_cb_evo_command_permissions']);
	
	print_form_header('mgc_cb_evo','command_do_manage_perms');
	construct_hidden_code('cid', $vbulletin->GPC['cid']);

	print_table_header(construct_phrase($vbphrase['mgc_cb_evo_permissions_command_x'],$command['identifier']));
	
	$aux_array = array();
	$aux_array['membergroupids'] = $command['usergroupids'];
	print_membergroup_row($vbphrase['mgc_cb_evo_command_usergroupids'], 'usergroupids', 2, $aux_array);
	print_input_row($vbphrase['mgc_cb_evo_command_userids'], 'userids', $command['userids'], true, 35, 1000);
	
	/** The end **/
	print_hidden_fields();
	print_submit_row();	
}

if ($_POST['do'] == 'command_do_manage_perms')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'cid' 			=> TYPE_UINT,
		'usergroupids'	=> TYPE_ARRAY_UINT,
		'userids'		=> TYPE_STR
	));	

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');	
		
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command
		SET
			usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
			userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "'
		WHERE cid='" . $vbulletin->GPC['cid'] . "'
	");
		
	print_stop_message('mgc_cb_evo_command_permissions_edited_successfully');
}

if ($_REQUEST['do'] == 'manage_channels')
{
	print_cp_header($vbphrase['mgc_cb_evo_channels_mngt']);
	
	?>
	<script type="text/javascript">
	function js_page_jump(i, chanid)
	{
		var sel = fetch_object("channelsel" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'channel_disable': page = "mgc_cb_evo.php?do=channel_enable&what=0&chanid="; break;
				case 'channel_enable': page = "mgc_cb_evo.php?do=channel_enable&what=1&chanid="; break;
				case 'channel_edit': page = "mgc_cb_evo.php?do=channel_update&what=edit&chanid="; break;
				case 'channel_delete':
					if(confirm("<? echo $vbphrase['mgc_cb_evo_are_you_sure_to_delete']; ?>"))
						page = "mgc_cb_evo.php?do=channel_delete&chanid=";
					else
						return;
					break;
				default: return;
			}
			jumptopage = page + chanid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	</script>
	<?php
		
	print_form_header('mgc_cb_evo', 'channel_order_save');
	construct_hidden_code('channelid', '');

	print_table_header($vbphrase['mgc_cb_evo_channels'], 6);
	print_cells_row(array($vbphrase['title'], $vbphrase['mgc_cb_evo_order'], $vbphrase['description'], $vbphrase['mgc_cb_evo_warn_user'], $vbphrase['controls']), 1);
	
	/* Retrieving of the channels */
	$getchannels = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "mgc_cb_evo_channel
		ORDER BY chanorder ASC
	");
	
	print_cells_row(array(
		$vbphrase['mgc_cb_evo_general_channel'],
		"<div align=\"center\">0</div>",
		"<div align=\"center\">" . $vbphrase['mgc_cb_evo_general_channel_desc'] . "</div>",
		$vbphrase['yes'],
		$vbphrase['default']
	), false, '', -2);		
	
	while($channel = $vbulletin->db->fetch_array($getchannels))
	{
		$options = array('channel_edit' => $vbphrase['edit']);
		
		if ($channel['active'])
		{
			$options['channel_disable'] = $vbphrase['disable'];
			$title =  htmlspecialchars_uni($channel['title']);
		}
		else
		{
			$options['channel_enable'] = $vbphrase['enable'];
			$title = "<strike>" . htmlspecialchars_uni($channel['title']) . "</strike>";			
		}

		$options['channel_delete'] = $vbphrase['delete'];
		
		$i++;
		
		print_cells_row(array(
			$title,
			"<div align='center'><input type='input' class='input' size='5' name='chan_order[" . $channel['chanid'] . "]' value='" . $channel['chanorder'] . "' /></div>",
			htmlspecialchars_uni($channel['description']),
			($channel['warnon'] ? $vbphrase['yes'] : $vbphrase['no']),
			"<div align=\"$stylevar[right]\">
				<select name=\"s$channel[chanid]\" id=\"channelsel$i\" onchange=\"js_page_jump($i, '$channel[chanid]')\" class=\"bginput\">
					" . construct_select_options($options) . "
				</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump($i, '$channel[chanid]');\" />
			</div>"
		), false, '', -2);		
	}
	
	
	print_description_row('<div align="center"><input type="submit" value="' . $vbphrase['mgc_cb_evo_save'] . '" />&nbsp;&nbsp;<input type="button" onclick="window.location=\'mgc_cb_evo.php?do=channel_update&what=add&s=' . $vbulletin->session->vars['sessionhash'] . '\'" value="' . stripslashes($vbphrase['mgc_cb_evo_add_channel']) . '"></div>',false,6,'tfoot');	
	
	print_table_footer();
}

if ($_REQUEST['do'] == 'channel_update')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT,
		'what'	=> TYPE_STR
	));

	if ($vbulletin->GPC['what'] == "add")
	{	
		print_cp_header($vbphrase['mgc_cb_evo_add_channel']);
		$channel['chanorder'] = 1;
	}
	else
	{
		/* Check if the channel exist and fetch it */
		$channel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
	
		if (!$channel)
		{
			print_stop_message('mgc_cb_evo_nonexisting_channel');
		}
		
		print_cp_header($vbphrase['mgc_cb_evo_edit_channel']);
	}
	
	print_form_header('mgc_cb_evo','channel_do_update');
	construct_hidden_code('what', $vbulletin->GPC['what']);
	construct_hidden_code('chanid', $vbulletin->GPC['chanid']);
	
	print_table_header($vbphrase['mgc_cb_evo_channel_information']);
	
	print_input_row($vbphrase['title'], 'title', $channel['title'], true, 35, 50);
	print_input_row($vbphrase['description'], 'description', $channel['description'], true, 35, 250);
	print_input_row($vbphrase['mgc_cb_evo_channel_image_name'], 'img_name', $channel['img_name'], true, 35, 50);
	
	print_input_row($vbphrase['mgc_cb_evo_order'], 'chanorder', $channel['chanorder'], true, 35, 100);
	print_yes_no_row($vbphrase['mgc_cb_evo_channel_warnon_new_message'], 'warnon', $channel['warnon'], 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_channel_activate'], 'activate', $channel['active'], 0);

	print_table_break();

	print_table_header($vbphrase['mgc_cb_evo_channel_command_info']);
	
 	$aux_array = array();
		
	if (!empty($channel['usergroupids']))
	{
		$aux_array['membergroupids'] = $channel['usergroupids'];
	}
		
	print_membergroup_row($vbphrase['mgc_cb_evo_channel_usergroupids'], 'usergroupids', 2, $aux_array);
	print_input_row($vbphrase['mgc_cb_evo_channel_userids'], 'userids', $channel['userids'], true, 35, 1000);
	
	/** The end **/
	print_hidden_fields();
	print_submit_row();
}

if ($_POST['do'] == 'channel_do_update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'chanid' 		=> TYPE_UINT,
		'what'			=> TYPE_STR,
		'title'			=> TYPE_STR,
		'description'	=> TYPE_STR,
		'img_name'		=> TYPE_STR,
		'chanorder'		=> TYPE_UINT,
		'syntax'      	=> TYPE_STR,
		'warnon'		=> TYPE_UINT,
		'usergroupids' 	=> TYPE_ARRAY_UINT,
		'userids'      	=> TYPE_STR,
		'activate'		=> TYPE_UINT
	));
	
	/* In case of edit, let's check if the chan exists */
	if ($vbulletin->GPC['what'] == 'edit')
	{
		$channel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
	
		if (!$channel)
		{
			print_stop_message('mgc_cb_evo_nonexisting_channel');
		}		
	}
	
	/* Some checks */
	if (empty($vbulletin->GPC['title']) || empty($vbulletin->GPC['img_name']))
	{
		print_stop_message('mgc_cb_evo_missing_title_or_img_name');
	}
	
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');
	
	/* Ready to add in the database */
	if ($vbulletin->GPC['what'] == 'add')
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_channel
			SET
				title='" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description='" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				chanorder='" . $vbulletin->GPC['chanorder'] . "',
				img_name='" . $vbulletin->db->escape_string($vbulletin->GPC['img_name']) . "',
				warnon='" . $vbulletin->GPC['warnon'] . "',
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "',	
				active='" . $vbulletin->GPC['activate'] . "'
		");
		
		print_stop_message('mgc_cb_evo_channel_added_successfully');
	}
	else
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel
			SET
				title='" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description='" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				chanorder='" . $vbulletin->GPC['chanorder'] . "',
				img_name='" . $vbulletin->db->escape_string($vbulletin->GPC['img_name']) . "',
				warnon='" . $vbulletin->GPC['warnon'] . "',
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "',
				active='" . $vbulletin->GPC['activate'] . "'
			WHERE chanid='" . $vbulletin->GPC['chanid'] . "'
		");		
		
		print_stop_message('mgc_cb_evo_channel_edited_successfully');
	}
}

if ($_POST['do'] == 'channel_order_save')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'chan_order' 		=> TYPE_ARRAY_UINT
	));
	
	foreach($vbulletin->GPC['chan_order'] AS $channel_id => $order)
	{
		if (empty($order))
		{
			$order = 1;
		}
		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET chanorder='$order' WHERE chanid='$channel_id'");
	}
	
	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');
	print_stop_message('mgc_cb_evo_channel_order_saved_successfully');
}

if ($_REQUEST['do'] == "channel_enable")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT,
		'what'		=> TYPE_UINT
	));
	
	/* Check if the chahnel exist */
	$check_channel = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

	if (!$vbulletin->db->num_rows($check_channel))
	{
		print_stop_message('mgc_cb_evo_nonexisting_channel');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');
	
	/* Disabling of the channel */
	if (!$vbulletin->GPC['what'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='0' WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
		print_stop_message('mgc_cb_evo_channel_successfully_disabled');	
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='1' WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
		print_stop_message('mgc_cb_evo_channel_successfully_enabled');
	}
}

if ($_REQUEST['do'] == "channel_delete")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT
	));
	/* Check if the chahnel exist */
	$check_channel = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

	if (!$vbulletin->db->num_rows($check_channel))
	{
		print_stop_message('mgc_cb_evo_nonexisting_channel');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');

	/* Removing of the chats */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
	
	print_stop_message('mgc_cb_evo_channel_successfully_deleted');
}

if ($_REQUEST['do'] == "view_log")
{
	print_cp_header($vbphrase['mgc_cb_evo_view_log']);
	
	?>
	<script type="text/javascript">
	function confirm_delete(logid)
	{
		if(confirm("<? echo $vbphrase['mgc_cb_evo_are_you_sure_to_delete']; ?>"))
			page = "mgc_cb_evo.php?do=log_delete&logid=";
		else
			return;
		jumptopage = page + logid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
		window.location = jumptopage;
	}
	</script>
	<?php
		
		
	print_table_start();
	print_table_header($vbphrase['mgc_cb_evo_logs'], 4);
	print_cells_row(array($vbphrase['date'], $vbphrase['username'], $vbphrase['text'], $vbphrase['delete']), 1);
	
	/* Retrieving of the logs */
	$getlogs = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "mgc_cb_evo_log
		ORDER BY dateline DESC
	");
		
	while($log = $vbulletin->db->fetch_array($getlogs))
	{
		print_cells_row(array(
			vbdate($vbulletin->options['dateformat'], $log['dateline'],false,false) . " " . vbdate($vbulletin->options['timeformat'], $log['dateline'],false,false),
			"<div align='center'>" . htmlspecialchars_uni($log['username']) . "</div>",
			$log['ltext'],
			"<div align=\"$stylevar[right]\">
				<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"confirm_delete('$log[logid]');\" />
			</div>"
		), false, '', -2);		
	}
	
	print_table_footer();
}

if ($_REQUEST['do'] == "log_delete")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'logid' 	=> TYPE_UINT
	));
	
	/* Check if the log exists */
	$check_log = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_log WHERE logid='" . $vbulletin->GPC['logid'] . "'");

	if (!$vbulletin->db->num_rows($check_log))
	{
		print_stop_message('mgc_cb_evo_nonexisting_log');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=view_log');

	/* Removing of the chats */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_log WHERE logid='" . $vbulletin->GPC['logid'] . "'");
	
	print_stop_message('mgc_cb_evo_log_successfully_deleted');
}

print_cp_footer();

?>