<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'dyna_browsecategory');

$specialtemplates = array(
	'adv_dyna_modpos',
	'adv_dyna_module',
	'bbcodecache',
	'smiliecache'
);

$globaltemplates = array(
	'ADV_DYNA_BROWSECATEGORY',
	'adv_dyna_browsecategory_nodisplay',
	'adv_dyna_entrybit_custombits',
	'adv_dyna_entrybit_deleted',
	'adv_dyna_entrybit_simple',
	'adv_dyna_entrybit_expanded',
	'adv_dyna_entrybit_expanded_dropdowns',
	'adv_dyna_letter',
	'adv_dyna_letter_selected',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
	'forumdisplay_sortarrow',
	'im_aim',
	'im_icq',
	'im_msn',
	'im_skype',
	'im_yahoo',
	'postbit_onlinestatus'
);

$actiontemplates = array(
	'browsecategory' => array(
		'adv_dyna_categorybit_level1',
		'adv_dyna_categorybit_level2',
		'adv_dyna_categorybit_main',
		'forumhome_moderator'
	),
	'subscriptions' => array(
		'adv_dyna_categorybit_level1',
		'adv_dyna_categorybit_level2',
		'forumhome_moderator'
	),
	'member' => array(
		'adv_dyna_categorybit_level1',
		'forumhome_moderator'
	)
);

$actiontemplates['none'] = $actiontemplates['browsecategory'];

$phrasegroups = array(
	'adv_dyna_browsecat',
	'adv_dyna_moderate',
	'cprofilefield',
	'forumdisplay',
	'postbit'
);

if ($_REQUEST['editmods'])
{
	$phrasegroups[] = 'adv_dyna_modules';
}

if ($_REQUEST['do'] == 'searchresults' OR $_REQUEST['catid'] == 'searchresults')
{
	$phrasegroups[] = 'search';
}

if ($_REQUEST['catid'] AND $_REQUEST['do'] == 'jump')
{
	switch ($_REQUEST['catid'])
	{
		case 'home':
			$redirect = 'index.php' . $vbulletin->session->vars['sessionurl_q'];
		break;

		case 'search':
			$redirect = 'search.php' . $vbulletin->session->vars['sessionurl_q'];
		break;

		case 'drafts':
		case 'favorites':
		case 'subscriptions':
		case 'newentries':
		case 'popentries':
			$redirect = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . $_REQUEST['catid'];
		break;
	}
}

require_once('./dyna_global.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/vba_dyna_functions_cats.php');

if (!$_REQUEST['do'] OR $_REQUEST['do'] == 'jump')
{
	$_REQUEST['do'] = 'browsecategory';
}

($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_start')) ? eval($hook) : false;

// Enter password for category
$passwordentered = false;
if ($_POST['do'] == 'enterpassword')
{
	$catpassword = $vbulletin->input->clean_gpc('p', 'catpassword', TYPE_NOHTML);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);

	$catinfo = $vbulletin->adv_dyna_cats[$catid];

	if (!$catinfo['password'] AND $catinfo['parentpass'] AND $catinfo['parent'])
	{
		$checkpass = $vbulletin->adv_dyna_cats[$vba_dyna->_cat['parent']]['password'];
		$setcatid = $catinfo['parent'];
	}
	else
	{
		$checkpass = $catinfo['password'];
		$setcatid = $catid;
	}

	if (cat_opt('canhavepassword') AND $checkpass AND $checkpass == $catpassword)
	{
		set_bbarray_cookie('catpassword', $setcatid, md5($vbulletin->userinfo['userid'] . $catpassword), 1);
		$_REQUEST['do'] = 'browsecategory';
	}
	else
	{
		$passwordentered = true;
	}
}

$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
$ltr = $vbulletin->input->clean_gpc('r', 'ltr', TYPE_NOHTML);
$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_INT);
$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);
$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
$eventdate = $vbulletin->input->clean_gpc('r', 'eventdate', TYPE_NOHTML);
$week = $vbulletin->input->clean_gpc('r', 'week', TYPE_INT);
$month = $vbulletin->input->clean_gpc('r', 'month', TYPE_INT);

$vbulletin->input->clean_array_gpc('r', array(
	'showall' => TYPE_INT,
	'catorder' => TYPE_STR,
	'catdir' => TYPE_STR
));

$catorder =& $vbulletin->GPC['catorder'];
$showall =& $vbulletin->GPC['showall'];

if ($cutoffdate != 'lastvisit')
{
	$cutoffdate = intval($cutoffdate);
}

$parentlink = '';
$querydeleted = false;
$condition = array();
$wherequery = array();

if ($_REQUEST['do'] == 'member' AND $vbulletin->userinfo['userid'] == $entryuserid)
{
	$wherequery[] = 'entries.valid IN(0, 1)';
}
else if (is_category_mod($catid) OR $vba_dyna->check_cat_perms('canviewdeleted', $vbulletin->GPC))
{
	$querydeleted = true;
	$wherequery[] = 'entries.valid IN(1, 2)';
}
else if ($_REQUEST['do'] != 'drafts')
{
	$wherequery[] = 'entries.valid = 1';
}

if ($_REQUEST['do'] != 'drafts')
{
	$wherequery[] = 'draft = 0';
}

if ($_REQUEST['do'] != 'browsecategory')
{
	if ($privatecatids = fetch_private_categories())
	{
		$wherequery[] = 'entries.catid NOT IN(' . $privatecatids . ')';
	}
}

$ignusers = fetch_ignored_users(intval($catid));
if ($ignusers)
{
	$wherequery[] = 'entries.userid NOT IN(' . $ignusers . ')';
}

$show['categoryhead'] = true;
$show['category_tools'] = false;
$show['cat_tools'] = true;
$show['categorylink'] = ($vba_options['dyna_disablecats']) ? false : true;

$datequery = '';
// Calendar link
if ($eventdate)
{
	$expdate = array_map('intval', explode('-', $eventdate));
	$vbulletin->GPC['month'] = $expdate[0];
	$vbulletin->GPC['year'] = $expdate[2];

	$eventdate = gmmktime(0, 0, 0, $expdate[0], $expdate[1], $expdate[2]) - ($vbulletin->userinfo['timezoneoffset'] * 3600);
	$datedisplay = vbdate($vbulletin->options['dateformat'], $eventdate);

	$datequery = 'dateline >= ' . $eventdate . ' AND dateline <= ' . ($eventdate + 86400);
}
else if ($week)
{
	$datequery = 'dateline >= ' . $week . ' AND dateline <= ' . ($week + 604800);
	$datedisplay = vbdate($vbulletin->options['dateformat'], $week) . ' - ' . vbdate($vbulletin->options['dateformat'], ($week + 604800));
}

$navname = '';

// Entry sorting options and links
$sortoptions = array(
	'rating' => 'DESC',
	'title' => 'ASC',
	'dateline' => 'ASC',
	'lastpostdateline' => 'ASC',
	'posts' => 'ASC',
	'views' => 'ASC',
	'category' => 'ASC'
);

$memorder = 'username';
if ($vbulletin->GPC['catorder'])
{
	if (in_array($vbulletin->GPC['catorder'], array_keys($vba_dyna->_catsortoptions)))
	{
		$memorder = $vbulletin->GPC['catorder'];
	}
}

// Let's figure out what we're doing here...
switch ($_REQUEST['do'])
{
	// ##### New Entries
	case 'newentries':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_newentries')) ? eval($hook) : false;

		if (!$vba_options['dyna_newentrylimit'])
		{
			print_no_permission();
		}

		if (!$cutoffdate)
		{
			$cutoffdate = 'lastvisit';
		}

		$categorytitle = construct_phrase($vbphrase['new_x'], $vbphrase['entries']) . ': ' .
			iif($cutoffdate == 'lastvisit',
				$vbphrase['since_your_last_visit'],
				construct_phrase($vbphrase['last_x_days'], $cutoffdate)
			);

		$condition['doorderby'] = 'dateline';
		$condition['direction'] = 'DESC';

		$navname = $vbphrase['whats_new'];
		$show['cat_tools'] = false;

	break;

	// ##### New Posts
	case 'newposts':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_newposts')) ? eval($hook) : false;

		if (!$vba_options['dyna_newentrylimit'])
		{
			print_no_permission();
		}

		if (!$cutoffdate)
		{
			$cutoffdate = 'lastvisit';
		}

		$categorytitle = $vbphrase['new_posts'] . ': ' . iif($cutoffdate == 'lastvisit',
			$vbphrase['since_your_last_visit'],
			construct_phrase($vbphrase['last_x_days'], $cutoffdate
		));
		$navname = $vbphrase['whats_new'];
		$show['newposts'] = true;
		$show['cat_tools'] = false;

		// Check view replies permission
		$noreplies = array();
		if (!empty($vbulletin->adv_dyna_cats))
		{
			foreach ($vbulletin->adv_dyna_cats AS $catid => $cats)
			{
				if (!$vba_dyna->check_cat_perms('canviewreplies', $cats))
				{
					$noreplies[] = $catid;
				}
			}
		}

		$wherequery[] = 'entries.posts != 0';

		if (!empty($noreplies))
		{
			$wherequery[] = 'entries.catid NOT IN(' . implode(',', $noreplies) . ')';
		}

	break;

	// ##### Popular Entries
	case 'popentries':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_popentries')) ? eval($hook) : false;

		switch ($orderby)
		{
			case 'posts':
				$titlephrase = 'top_x_replied_to_y';
				$condition['doorderby'] = 'entries.posts';
			break;

			case 'rating':
				$titlephrase = 'top_x_rated_y';
				$wherequery[] = 'votenum >= ' . intval($vba_options['dyna_popentries_votelimit']);
				$condition['votequery'] = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
				$condition['doorderby'] = 'voteavg DESC, votenum';
			break;

			default:
				$titlephrase = 'top_x_visited_y';
				$condition['doorderby'] = 'views';
				$orderby = 'views';
		}

		$categorytitle = construct_phrase($vbphrase[$titlephrase], $vba_options['dyna_popentrylimit'], $vbphrase['entries']);

		$show['cat_tools'] = false;

		$orderbysel[$orderby] = 'selected="selected"';

		$condition['limit'] = $vba_options['dyna_popentrylimit'];
		$condition['direction'] = 'DESC';
		$navname = $vbphrase['whats_popular'];
		$show['popentries'] = true;
	break;

	// ##### Favorites
	case 'favorites':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_favorites')) ? eval($hook) : false;

		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
		$categorytitle = $vbphrase['my_favorites'];
		$show['cat_search'] = true;
		$condition['fromtable'] = ADV_DYNA_PREFIX . '_favorites AS favorites';
		$condition['join'] = ADV_DYNA_PREFIX . '_entries AS entries ON (favorites.entryid = entries.entryid)';
		$wherequery[] = 'favorites.userid = ' . $vbulletin->userinfo['userid'];
		$condition['doorderby'] = 'favorites.dateline';
	break;

	// ##### Specific Date
	case 'finddate':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_finddate')) ? eval($hook) : false;

		$categorytitle = construct_phrase($vbphrase['x_submitted_on_y'], $vbphrase['entries'], $datedisplay);
		$condition['fromtable'] = ADV_DYNA_PREFIX . '_entries AS entries';
	break;

	// ##### Subscriptions
	case 'subscriptions':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_subscriptions')) ? eval($hook) : false;

		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
		$categorytitle = $vbphrase['my_subscriptions'];
		$condition['fromtable'] = ADV_DYNA_PREFIX . '_subscribeentry AS subscribeentry';
		$condition['join'] = ADV_DYNA_PREFIX . '_entries AS entries ON (subscribeentry.entryid = entries.entryid)';
		$wherequery[] = 'subscribeentry.userid = ' . $vbulletin->userinfo['userid'];

		// Subscribed Categories
		if ($page == 1 OR !$page)
		{
			$subcatbits = print_categories(0, 'subscriptions');

			if ($show['subcats'] OR $show['submembercats'])
			{
				$show['subscribe_options'] = true;
			}
		}
	break;

	// ##### Drafts
	case 'drafts':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_drafts')) ? eval($hook) : false;

		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
		$categorytitle = $vbphrase['my_drafts'];
		$show['cat_search'] = true;
		$wherequery[] = 'draft = 1 AND entries.userid = ' . $vbulletin->userinfo['userid'];

	break;

	// ##### Member search
	case 'member':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_member')) ? eval($hook) : false;

		if (!$entryuserid)
		{
			eval(standard_error(fetch_error('noid', $vbphrase['user'])));
		}

		$wherequery[] = 'entries.userid = ' . $entryuserid;
		$show['category_tools'] = true;
		$show['cat_search'] = true;
		$condition['stickyorder'] = 'sticky DESC,';

		$catsinfo = array();
		$getsubcats = $db->query_read("
			SELECT categories.*, user.username
			FROM " . ADV_DYNA_TABLE_PREFIX . "categories AS categories
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
			WHERE catuserid = $entryuserid
		");
		while ($cats = $vbulletin->db->fetch_array($getsubcats))
		{
			$catsinfo[$cats['catid']] = $cats;
			$catsinfo[$cats['catid']]['level'] = 1;
		}

		$db->free_result($getsubcats);
		unset($cats);

		if (!$vbulletin->GPC['showall'] AND !empty($catsinfo))
		{
			$wherequery[] = 'entries.catid NOT IN(' . implode(',', array_keys($catsinfo)) . ')';

			if ($page == 1 OR !$page)
			{
				$subcatbits = print_categories(0, 'usercats');

				if ($subcatbits)
				{
					$show['subcats'] = true;
				}
			}
		}

	break;

	// ##### Search Results
	case 'searchresults':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_searchresults')) ? eval($hook) : false;

		$search = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "search WHERE searchid = $searchid");
		if (!$search['searchid'])
		{
			eval(standard_error(fetch_error('searchnoresults', '')));
		}

		$condition['orderby'] = $search['orderby'];
		$categorytitle = $vbphrase['search_results'];
		$wherequery[] = 'entries.entryid IN(' . $search['entryids'] . ')';

		$search['keywords'] = explode(' ', $search['string']);
		foreach ($search['keywords'] AS $key => $keyword)
		{
			if ($key > 0)
			{
				$comma = ',';
			}
			$keywords .= $comma . '<b><u>' . $keyword . '</u></b>';
		}

		if ($search['username'])
		{
			$search['username'] = unserialize($search['username']);
			foreach ($search['username'] AS $userid => $username)
			{
				$search['usernames']["$userid"] = '<a href="' . $vbulletin->options['bburl'] . '/member.php?u=' . $userid . '"><b><u>' . $username . '</b></u></a>';
			}
			$search['usernames'] = implode(' ' . $vbphrase['or'] . ' ', $search['usernames']);
		}

		$highlight['string'] = $search['string'];
		$search['sfields'] = explode(',', $search['sfields']);

		foreach ($search['sfields'] AS $sfield)
		{
			$show['highlight_' . $sfield] = true;
		}

		$highlight['wholeword'] = $search['wholeword'];

	break;

	// ##### View Inline Moderation Selected Entries
	case 'viewmodselected':

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_viewmodselected')) ? eval($hook) : false;

		require_once(DIR . '/includes/vba_dyna_functions_moderate.php');

		// Run this just to make sure they're a moderator
		fetch_moderator_cats();

		$cookielist = $vbulletin->input->clean_gpc('c', 'vbulletin_inline' . ($vba_options['dyna_entrybitexpanded'] ? 'post' : 'thread'), TYPE_STR);

		$vbulletin->GPC['tlist'] = array();
		$entryids = process_cookie_list();

		$categorytitle = $vbphrase['moderation'];
		$show['cat_search'] = false;

		$wherequery[] = 'entryid IN(' . implode(',', $entryids) . ')';
	break;

	// ##### Browse Entries
	default:

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_default')) ? eval($hook) : false;

		// Set $do just incase someone inserts something other than what's expected
		$_REQUEST['do'] = 'browsecategory';
		$catid = intval($catid);

		if ($catid)
		{
			$catinfo =& $vbulletin->adv_dyna_cats[$catid];

			if ($catinfo['catuserid'])
			{
				$entryuserid = $catinfo['catuserid'];
			}

			$categorytitle = $catinfo['title'];

			// Error checks
			if (!$catinfo['catid'] AND !$eventdate)
			{
				eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['webmasteremail'])));
			}

			$vba_dyna->check_cat_perms('canviewentries', $catinfo, true);

			check_category_password($catinfo['catid'], true, $passwordentered);

			// Parent link
			if ($catinfo['memberscat'] AND $entryuserid)
			{
				$parentlink = fetch_cat_url($catid);
			}
			else if ($catinfo['parent'])
			{
				$parentlink = fetch_cat_url($catinfo['parent']);
			}

			if (!$catinfo['hasentries'] OR !$vba_dyna->check_cat_perms('canviewentries', $catinfo))
			{
				if (!$catinfo['hasentries'])
				{
					$show['cat_tools'] = false;
				}

				$noentryquery = true;
			}

			if ($vbulletin->GPC['showall'])
			{
				$show['categorylink'] = true;

				$allcatids = array_keys(construct_categories($vbulletin->adv_dyna_cats, $catid));

				$allcatids[] = $catid;

				$wherequery[] = 'entries.catid IN(' . implode(',', $allcatids) . ')';
			}
			else
			{
				$wherequery[] = 'entries.catid = ' . $catid;
				$show['categorylink'] = false;
			}

			$condition['stickyorder'] = 'sticky DESC,';

			$show['categoryhead'] = false;
			$show['category_tools'] = true;
			$show['cat_search'] = $vba_dyna->check_cat_perms('cansearch', $catinfo);
		}

		if (!$eventdate AND (($catinfo['memberscat'] AND !$entryuserid) OR !$catinfo['hasentries']) AND !$vbulletin->GPC['showall'])
		{
			$noentryquery = true;
			$show['headercat'] = true;
		}

		// Check for subcats
		if (!$eventdate AND !$vbulletin->GPC['showall'] AND (!$entryuserid OR ($entryuserid AND $catid)))
		{
			if ($subcatbits = print_categories($catid, 'normal'))
			{
				$show['subcats'] = true;
			}
		}

		if ($show['headercat'])
		{
			$show['cat_tools'] = false;
		}

} // End switch($_REQUEST['do'])

// Get subscribed info
if (($_REQUEST['do'] == 'browsecategory' OR $_REQUEST['do'] == 'member')
	AND $vba_options['dyna_allowsubscribe']
	AND $vbulletin->userinfo['userid']
)
{
	// Get category info
	$subscribecat = $db->query_first("
		SELECT NOT ISNULL(catid) AS subcatid
		FROM " . ADV_DYNA_TABLE_PREFIX . "subscribecat
		WHERE catid = " . intval($catid) . "
			AND userid = " . $vbulletin->userinfo['userid'] . "
			AND entryuserid = $entryuserid
	");

	$catinfo['subcatid'] = $subscribecat['subcatid'];

	if ($catinfo['subcatid'])
	{
		$show['unsubscribe_cat'] = true;
	}
}

if (!isset($condition['fromtable']))
{
	$condition['fromtable'] = ADV_DYNA_PREFIX . '_entries AS entries';
}

if (!$catinfo['catid'])
{
	$catinfo['catid'] =& $_REQUEST['do'];
}

if (!intval($catinfo['catid']))
{
	$returnto = $catinfo['catid'];
}

$adv_sorturl = construct_adv_sort_url(array('page'));

if (in_array($_REQUEST['do'], array('browsecategory', 'drafts', 'favorites', 'subscriptions', 'finddate', 'member', 'newentries', 'newposts', 'searchresults', 'viewmodselected')) AND !$show['headercat'])
{
	// Direction
	$direction = strtoupper($direction);
	if ($direction == 'DESC' OR $direction == 'ASC')
	{
		$condition['direction'] = $direction;
	}
	else if (!$condition['direction'])
	{
		$condition['direction'] = $vba_options['dyna_defdirection'];
		$direction = $vba_options['dyna_defdirection'];
	}

	// Order by
	if (!$orderby AND !$condition['doorderby'])
	{
		$orderby = $vba_options['dyna_deforder'];
		$condition['doorderby'] = construct_orderby();
	}
	else if (!$condition['doorderby'])
	{
		$condition['doorderby'] = construct_orderby();
	}

	if ($orderby == 'rating')
	{
		$condition['votequery'] = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
	}

	$oppositesort = iif($condition['direction'] == 'ASC', 'desc', 'asc');

	$catsel[$condition['direction']] = 'selected="selected"';

	// Cutoff date
	if ($cutoffdate AND $cutoffdate != -1)
	{
		$wherequery[] = 'entries.' . iif($_REQUEST['do'] == 'newposts', 'lastpost') . 'dateline > ' . iif($cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (TIMENOW - ($cutoffdate * 86400)));
	}

	if (!$cutoffdate OR $cutoffdate == -1)
	{
		$cutoffdate = 'all';
	}

	$datecutsel = array();
	$datecutsel["$cutoffdate"] = 'selected="selected"';

	$ordersel = array();
	$ordersel["$orderby"] = 'selected="selected"';

	// Letterbits
	if (($vba_options['dyna_showalpha'] AND !$show['headercat'] AND !$catinfo['memberscat']) OR ($vba_options['dyna_showalphacats'] AND $catinfo['memberscat']))
	{
		$item = $vbphrase['entries_lwr'];

		$alphabet = array_merge(array($vbphrase['all'], '#'), range('A', 'Z'));
		$adv_sorturl_ltr = construct_adv_sort_url(array('ltr', 'catid'), true);
		$letterurl_start = fetch_cat_url($catid);

		foreach($alphabet as $lkey => $letter)
		{
			if ($lkey == 0)
			{
				$entryletter = '';
			}
			else if ($lkey == 1)
			{
				$entryletter = 'nonalpha';
			}
			else
			{
				$entryletter = $letter;
			}

			$letterselected = ($ltr == $entryletter) ? true : false;

			$letterurl = $letterurl_start . iif($vba_options['dyna_spiderurls'], '?', '&amp;') . 'ltr=' . $entryletter . $adv_sorturl_ltr;

			if ($catinfo['memberscat'])
			{
				eval('$catletterbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_letter') . '";');
			}
			else
			{
				eval('$letterbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_letter') . '";');
			}
		}
	}

	// Searching for a letter
	if ($ltr AND ($ltr == 'nonalpha' OR in_array($ltr, $alphabet)))
	{
		$wherequery[] = iif($ltr == 'nonalpha', 'title NOT REGEXP("^[a-zA-Z]")', 'title LIKE(\'' . $ltr . '%\')');
	}

	// Members' cat, specific user
	if ($vba_dyna->_cat['memberscat'] AND $entryuserid)
	{
		$wherequery[] = 'entries.userid = ' . $entryuserid;
	}

	// Set here to keep day/week out
	$calendarquery = $wherequery;

	if ($eventdate OR $week)
	{
		$wherequery[] = $datequery;
	}

	if (!$noentryquery)
	{
		// Get the private entryids
		fetch_private_entryids();

		$pagedata = fetch_page_data(
			$condition['fromtable'],
			$wherequery,
			array($condition['join']),
			'',
			iif($_REQUEST['do'] == 'searchresults' AND sizeof($wherequery), $search['numresults'], false)
		);
		$perpage = $pagedata['perpage'];
		$pagenumber = $pagedata['pagenumber'];
		$condition['limit'] = ($pagedata['minlimit'] - 1) . ',' . $pagedata['perpage'];

		if (!$pagedata['count'])
		{
			$noentryquery = true;
		}
	}
}

// Join the category table if ordering by title
if ($orderby == 'category')
{
	// adding the LEFT JOIN will cause problems with the calendar if other tables are already joined
	$condition['catjoin'] .= 'LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'categories AS categories ON (entries.catid = categories.catid)';
}

$dyna_page = THIS_SCRIPT;

require_once(DIR . '/includes/vba_dyna_include_modules.php');

if (!$noentryquery)
{
	fetch_entrybit_fields(array(), false, true);

	$show['entrybit_dropdowns'] = '';
	// Get entryid's
	$entryids = array();
	$entrycats = array();
	$fetchentryids = $db->query_read("
		SELECT $condition[votequery] entries.entryid, entries.catid
		FROM " . TABLE_PREFIX . $condition['fromtable'] . "
		" . iif($condition['join'], ' LEFT JOIN ' . TABLE_PREFIX . $condition['join']) . "
		$condition[catjoin]
		" . iif(!empty($wherequery), 'WHERE ' . implode(' AND ', $wherequery)) . "
		ORDER BY $condition[stickyorder] $condition[doorderby] $condition[direction]
		LIMIT $condition[limit]
	");
	while ($returnids = $db->fetch_array($fetchentryids))
	{
		$entryids[] = $returnids['entryid'];
		$entrycats[] = $returnids['catid'];
	}

	$db->free_result($fetchentryids);
	unset($returnids);

	// ##### Inline Moderation
	$show['inlinemod'] = false;

	if ($_REQUEST['do'] == 'browsecategory' AND $catid)
	{
		if (is_category_mod($catid))
		{
			$show['inlinemod'] = true;
			$show['feature_entry'] = ($vba_dyna->check_cat_perms('cansetfeatured')) ? true : false;
		}
	}
	else if ($show['modoptions'])
	{
		$show['inlinemod'] = true;
		$show['feature_entry'] = ($vba_dyna->_permissions['cansetfeatured']) ? true : false;
	}

	if (!empty($entryids))
	{
		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		$entryids = implode(',', $entryids);

		// Subscribed entries
		$queryfields = '';
		$queryjoin = '';
		if ($vba_options['dyna_allowsubscribe'] AND $vbulletin->userinfo['userid'] AND $_REQUEST['do'] != 'subscriptions')
		{
			$queryfields .= ', NOT ISNULL(subscribeentry.entryid) AS issubscribed';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'subscribeentry AS subscribeentry ON (entries.entryid = subscribeentry.entryid AND ' . $vbulletin->userinfo['userid'] . ' = subscribeentry.userid) ';
		}

		// Get post info if user has permission
		if ($vba_options['dyna_allowreplies'] AND $vba_dyna->check_cat_perms('canviewreplies', $catinfo))
		{
			$queryfields .= ', entries.posts, entries.lastpostdateline, entries.lastpostuserid, entries.lastpostusername, entries.lastpostid';
		}

		// Join favorites if userid
		if ($vbulletin->userinfo['userid'] AND $vba_options['dyna_allowfav'])
		{
			$queryfields .= ', NOT ISNULL(favorites.entryid) AS isfavorite';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'favorites AS favorites ON (favorites.entryid = entries.entryid AND favorites.userid = ' . $vbulletin->userinfo['userid'] . ') ';
		}

		// Icons
		if ($_REQUEST['do'] != 'browseimages' OR cat_opt('allow_entry_icon'))
		{
			$queryfields .= ', entries.iconid, icon.title as icontitle, icon.iconpath';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (entries.iconid = icon.iconid) ';
		}

		// Preview
		if ($show['entrybit_preview'] AND $vba_options['dyna_desclength_browse'])
		{
			$queryfields .= ', pagetext, allowsmilie';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entries_pages AS entries_pages ON (entries.entryid = entries_pages.entryid AND entries_pages.pagenumber = 1)';
			// Entry cache
			if ($vba_options['dyna_cachedlife'])
			{
				$queryfields .= ', pagetext_parsed, hasimages';
				$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entryparsed AS entryparsed ON (entries.entryid = entryparsed.entryid AND entryparsed.pagenumber = 1 AND entryparsed.languageid = ' . $vbulletin->userinfo['languageid'] . ' AND entryparsed.styleid = ' . $vbulletin->userinfo['styleid'] . ')';
			}
		}

		// First Attachment
		if ($show['entrybit_attach'])
		{
			$vba_dyna->fetch_attachment_perms();

			$queryfields  .= ', attachment.attachmentid, attachment.hasthumb, attachment.filename, attachment.dateline AS attachdateline, extension, attachment.userid AS attachuserid';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'attachments AS attachment ON (entries.attachid = attachment.attachmentid AND attachment.valid = 1)';
		}

		// User Rank
		if ($show['entrybit_user_rank'])
		{
			$queryfields .= ', rank';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'usertextfield AS usertextfield ON (user.userid = usertextfield.userid)';
		}

		// Deletion Log
		if ($querydeleted)
		{
			$queryfields .= ', dellog.dateline AS del_dateline, dellog.userid AS del_userid, dellog.username AS del_username, reason';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog AS dellog ON (entries.entryid = dellog.deletedid AND type = \'entry\')';
		}

		// Publish dates if viewing drafts
		if ($_REQUEST['do'] == 'drafts')
		{
			$queryfields .= ', pubdateline';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entrypublish AS entrypublish ON (entries.entryid = entrypublish.entryid)';
		}

		$templatename = ($vba_options['dyna_entrybitexpanded'] ? 'expanded' : 'simple');

		($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_queryentries')) ? eval($hook) : false;

		// ##### Get the entries
		$getentries = $db->query("
			SELECT $condition[votequery] user.*, entries.entryid, entries.title, entries.catid, entries.userid, entries.username, entries.views, entries.dateline, hasattach, entries.valid, draft, private, sticky, open, votenum, votetotal, IF(user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ", 1, 0) AS invisible, entries.posts AS posts, avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision, caticon, customfields.* $queryfields
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "categories AS categories ON (entries.catid = categories.catid)
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "cfields_entries AS customfields ON (entries.entryid = customfields.eid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (entries.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "avatar as avatar ON (avatar.avatarid = user.avatarid)
			LEFT JOIN " . TABLE_PREFIX . "customavatar as customavatar ON (customavatar.userid = user.userid)
			$queryjoin
			WHERE entries.entryid IN($entryids)
			ORDER BY $condition[stickyorder] $condition[doorderby] $condition[direction]
		");
		while ($entries = $db->fetch_array($getentries))
		{
			if ($_REQUEST['do'] == 'favorites')
			{
				$entries['isfavorite'] = 1;
			}

			if ($_REQUEST['do'] == 'subscriptions')
			{
				$entries['subid'] = 1;
			}

			$entryusername = $entries['username'];

			$entrybits .= construct_entrybits($entries, $templatename);
		}

		// Moderator bits
		if ($_REQUEST['do'] == 'browsecategory')
		{
			$vbulletin->templatecache['forumhome_moderator'] = str_replace(
				'"member.php',
				'"' . $vbulletin->options['bburl'] . '/member.php',
				$vbulletin->templatecache['forumhome_moderator']
			);

			// Moderators
			$categorymods = fetch_cat_moderators($catid);
			$modcount = sizeof($vbulletin->adv_dyna_mods[$catid]);
		}

		if ($_REQUEST['do'] == 'member')
		{
			$entryusername_poss = fetch_possessive($entryusername);
			$categorytitle = $entryusername_poss . ' ' . $vbphrase['entries'];
		}
		else if ($catinfo['memberscat'] AND $entryuserid)
		{
			$entryusername_poss = fetch_possessive($entryusername);
			$categorytitle .= ' - ' . $entryusername_poss . ' ' . $vbphrase['entries'];
		}

		$db->free_result($getentries);
		unset($entries);
	}
	else
	{
		eval('$entrybits = "' . fetch_template(ADV_DYNA_PREFIX . '_browsecategory_nodisplay') . '";');
	}
}
// ##### No Entries
else
{
	if ($_REQUEST['do'] == 'member' OR $entryuserid)
	{
		$user = $db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = '$entryuserid'");
		$entryusername = $user['username'];
		$categorytitle = fetch_possessive($user['username']) . ' ' . $vbphrase['entries'];
	}

	eval('$entrybits = "' . fetch_template(ADV_DYNA_PREFIX . '_browsecategory_nodisplay') . '";');
}

$cattype = '';
$catuserinfo = array();
// Set for the fetch_cat_url() function
if ($_REQUEST['do'] == 'member' OR $catinfo['memberscat'])
{
	$cattype = 'member';
	$catinfo['userid'] = $entryuserid;
	$catuserinfo = $catinfo;
}
// Category URL
if ($vba_options['dyna_spiderurls'])
{
	switch ($_REQUEST['do'])
	{
		case 'newentries':
			$categorylink = 'whatsnew/entries/' . $cutoffdate . '/';
		break;

		case 'newposts':
			$categorylink = 'whatsnew/posts/' . $cutoffdate . '/';
		break;

		default:

			if ($eventdate OR $week)
			{
				$categorylink = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'do=finddate&amp;eventdate=' . $vbulletin->GPC['eventdate'];
			}
			else
			{
				$categorylink = fetch_cat_url(
					$catid,
					iif($_REQUEST['do'] == 'member' OR ($catinfo['memberscat'] AND $entryuserid), array('title' => $entryusername, 'userid' => $entryuserid), array()),
					iif($_REQUEST['do'] == 'member', 'member')
				);
			}
	}
}
else
{
	$categorylink = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'catid='  . $catid;
	if ($entryuserid)
	{
		if ($_REQUEST['do'] == 'member')
		{
			$categorylink .= '&amp;do=member';
		}
		$categorylink .= '&amp;entryuserid=' . $entryuserid;
	}
}

// For inline moderation & the inactive module submit form
$dyna_pageurl = fetch_cat_url(
	$catid,
	$catuserinfo,
	$cattype
) . construct_adv_sort_url(array('catid', 'entryuserid'));

if (!$noentryquery)
{
	if (!$eventdate AND !$week AND $_REQUEST['do'] != 'searchresults')
	{
		replace_page_nav_links();
	}

	$pagenav = construct_page_nav(
		$pagenumber,
		$perpage,
		$pagedata['count'],
		iif($_REQUEST['do'] == 'searchresults',
			'browsecategory.php?',
			$categorylink . iif($_REQUEST['do'] == 'finddate', '&amp;do=finddate')
		),
		construct_adv_sort_url(
			array('page'),
			iif($_REQUEST['do'] == 'searchresults', true)
		)
	);

}

$sort_adv_url = construct_adv_sort_url(array('catid', 'orderby', 'direction', 'page'));

// Entry sorting links
$entrysortlink = $categorylink;
if ($vba_options['dyna_spiderurls'])
{
	$entrysortlink .= '?' . $sort_adv_url;
}
else
{
	$entrysortlink .= $sort_adv_url . '&amp;';
}

foreach ($sortoptions AS $sortkey => $sortdir)
{
	$sorturls[$sortkey] = $entrysortlink . 'orderby=' . $sortkey . '&amp;direction=' . $sortdir;
}

if ($oppositesort)
{
	$sorturl = $entrysortlink . iif($sort_adv_url, '&amp;') . 'orderby=' . $orderby . '&amp;direction=' . $oppositesort;
	eval('$arrow[$orderby] = "' . fetch_template('forumdisplay_sortarrow') . '";');
}

// Category sorting links
$catsortlink = $categorylink;
if ($vba_options['dyna_spiderurls'])
{
	$catsortlink .= '?' . $sort_adv_url;
}
else
{
	$catsortlink .= $sort_adv_url . '&amp;';
}

foreach ($vba_dyna->_catsortoptions AS $sortkey => $sortdir)
{
	$catsorturls[$sortkey] = $catsortlink . 'catorder=' . $sortkey . '&amp;catdir=' . $sortdir;
}

$oppositesort = iif($vbulletin->GPC['catdir'] == 'ASC', 'DESC', 'ASC');
$sorturl = $catsortlink . iif($sort_adv_url, '&amp;') . 'catorder=' . $catorder . '&amp;catdir=' . $oppositesort;
$oppositesort = strtolower($oppositesort);
eval('$catarrow[$memorder] = "' . fetch_template('forumdisplay_sortarrow') . '";');


// Show all
$showall_adv_url = construct_adv_sort_url(array('catid', 'showall'));
$allsubcatslink = $categorylink . $showall_adv_url;

if ($show['subcats'] OR $vbulletin->GPC['showall'])
{
	if ($vbulletin->GPC['showall'])
	{
		$show['hidesubcats'] = true;
	}
	else
	{
		$show['allsubcats'] = true;
	}

	if ($vba_options['dyna_spiderurls'])
	{
		$allsubcatslink .= $sort_adv_url . ($showall_adv_url) ? '&amp;' : '?';
	}
	else
	{
		$allsubcatslink .= $sort_adv_url . ($showall_adv_url) ? '&amp;' : '?';
	}

	if (!$show['hidesubcats'])
	{
		$allsubcatslink .= 'showall=1';
	}
}

$categoryjump = print_category_jump($catid);

if (($eventdate OR $week) AND $_REQUEST['do'] != 'finddate')
{
	$categorytitle .= ' ' . construct_phrase($vbphrase['from_x'], $datedisplay);
}

if (!$navname)
{
	$navname = $categorytitle;
}

if ($_REQUEST['do'] == 'browsecategory')
{
	$navbits = fetch_cat_navbits($catid);
}
else
{
	$navbits[''] = $navname;
}

$show['editmodslink'] = false;
if ($vbulletin->userinfo['userid']
	AND $vba_options['dyna_enablemodules']
	AND $vba_dyna->_permissions['canmodule']
	AND ($entryuserid == $vbulletin->userinfo['userid']
		OR $vbulletin->adv_dyna_cats[$catid]['catuserid'] == $vbulletin->userinfo['userid']
	)
)
{
	$show['editmodslink'] = true;
}

($hook = vBulletinHook::fetch_hook('vba_dyna_browsecategory_end')) ? eval($hook) : false;

$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');

$pagedata['minlimit'] = vb_number_format(iif($pagedata['count'], $pagedata['minlimit'], 0));
$pagedata['maxlimit'] = vb_number_format($pagedata['maxlimit']);
$pagedata['count'] = vb_number_format($pagedata['count']);

$vba_dyna->save_parsed_entries();

eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_BROWSECATEGORY') . '");');

?>