// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

function rebuild_cfields(formobj)
{
	xml_sender = new vB_AJAX_Handler(true);
	xml_sender.init();

	if (is_vb_37)
	{
		if(!is_ajax_compatible())
		{
			return true;
		}
	}
	else
	{
		if (!xml_sender.is_compatible())
		{
			return true;
		}
	}

	var catid = document.getElementById('catid').value;
	var oldcatid = document.getElementById('oldcatid').value;
	var cfieldinput = document.getElementById('cfieldids').value;

	var cfieldids = cfieldinput.split(',');

	var cfieldstring = '';

	for (i in cfieldids)
	{
		var fieldid = 'field' + cfieldids[i];
		var fieldvar = document.getElementById(fieldid);
		var fieldvalue = '';

		if (fieldvar == null || fieldvar.type == 'radio')
		{
			var fieldchoices = document.vbform[fieldid];

			// Radio
			if (fieldchoices != undefined)
			{
				for (var i = 0; i < fieldchoices.length; i++)
				{
					if (fieldchoices[i].checked)
					{
						cfieldstring = cfieldstring + '&' + fieldid + '=' + PHP.urlencode(fieldchoices[i].value);
					}
				}
			}
			else
			{
				// Checkbox
				var fieldchoices = document.vbform[fieldid + "[]"];

				if (fieldchoices != undefined)
				{
					for (var i = 0; i < fieldchoices.length; i++)
					{
						if (fieldchoices[i].checked)
						{
							cfieldstring = cfieldstring + '&' + fieldid + '[]=' + PHP.urlencode(fieldchoices[i].value);
						}
					}
				}
			}
		}
		else if (fieldvar.value)
		{
			// Multiple select
			if (fieldvar.multiple)
			{
				var fieldchoices = document.vbform[fieldid];

				for (var i = 0; i < fieldchoices.length; i++)
				{
					if (fieldchoices[i].selected)
					{
						cfieldstring = cfieldstring + '&' + fieldid + '[]=' + PHP.urlencode(fieldchoices[i].value);
					}
				}
			}
			// All others
			else
			{
				cfieldstring = cfieldstring + '&' + fieldid + '=' + PHP.urlencode(fieldvar.value);
			}
		}
	}

	xml_sender.onreadystatechange(fetch_custom_output);
	xml_sender.send('ajax.php', "do=updatecustom&catid=" + PHP.urlencode(catid) + "&oldcatid=" + PHP.urlencode(oldcatid) + "&cfieldids=" + cfieldids + cfieldstring);
	return false;
}

function fetch_custom_output()
{
	if (xml_sender.handler.readyState == 4 && xml_sender.handler.status == 200)
	{
		if (xml_sender.handler.responseXML)
		{
			// Old catid
			if (fetch_tags(xml_sender.handler.responseXML, 'oldcatid')[0])
			{
				document.getElementById('oldcatid').value = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'oldcatid')[0]);
			}
			// Hidden custom fields array
			if (fetch_tags(xml_sender.handler.responseXML, 'newcfields')[0])
			{
				document.getElementById('cfieldids').value = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'newcfields')[0]);
			}

			// ##### Custom Fields
			// Above message
			if (fetch_tags(xml_sender.handler.responseXML, 'cfields_above')[0])
			{
				document.getElementById('cfields_above').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'cfields_above')[0]);
			}
			// Below message
			if (fetch_tags(xml_sender.handler.responseXML, 'cfields_below')[0])
			{
				document.getElementById('cfields_below').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'cfields_below')[0]);
			}

			// Attachment
			if (fetch_tags(xml_sender.handler.responseXML, 'dyna_attach')[0])
			{
				document.getElementById('dyna_attach').style.display = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'dyna_attach')[0]);
				document.getElementById('vB_Editor_001_popup_attach').style.display = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'dyna_attach')[0]);
			}

			// Icons
			if (fetch_tags(xml_sender.handler.responseXML, 'dyna_icons')[0])
			{
				document.getElementById('dyna_icons').style.display = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'dyna_icons')[0]);
			}

			// Smilies
			if (fetch_tags(xml_sender.handler.responseXML, 'dyna_smilies')[0])
			{
				document.getElementById('vB_Editor_001_smiliebox').style.display = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'dyna_smilies')[0]);
				document.getElementById('vB_Editor_001_popup_smilie').style.display = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'dyna_smilies')[0]);
			}

			// [img] button
			if (fetch_tags(xml_sender.handler.responseXML, 'dyna_img')[0])
			{
				document.getElementById('vB_Editor_001_cmd_insertimage').style.display = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'dyna_img')[0]);
			}

		}
	}
}