// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

function stretch_inactive_area()
{
	inactsize += 75;

	set_cookie('inactivesize', inactsize);
	document.getElementById('inactivemodbits').style.height = inactsize + 'px';
	return false;
}

function shrink_inactive_area()
{
	inactsize -= 75;

	if (inactsize < 75)
	{
		inactsize = 75;
	}

	set_cookie('inactivesize', inactsize);

	document.getElementById('inactivemodbits').style.height = inactsize + 'px';
	return false;
}

// ##### Move Module ##########################################################
function dyna_move_mod(modid, modlinkid, column, dyna_page, dir)
{
	xml_sender = new vB_AJAX_Handler(true);
	xml_sender.init();

	if (is_vb_37)
	{
		if(!is_ajax_compatible())
		{
			return true;
		}
	}
	else
	{
		if (!xml_sender.is_compatible())
		{
			return true;
		}
	}

	xml_sender.onreadystatechange(move_module);
	xml_sender.send('module.php', "do=movemod&ajax=1&editmods=1&modid=" + PHP.urlencode(modid) + "&modlinkid=" + PHP.urlencode(modlinkid) + "&col=" + PHP.urlencode(column) + "&dyna_page=" + PHP.urlencode(dyna_page) + "&dir=" + PHP.urlencode(dir));

	return false;
}

function move_module()
{
	if (xml_sender.handler.readyState == 4 && xml_sender.handler.status == 200)
	{
		if (xml_sender.handler.responseXML)
		{
			// Error
			if (fetch_tags(xml_sender.handler.responseXML, 'error')[0])
			{
				alert(xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'error')[0]));
			}

			// Update left column
			if (fetch_tags(xml_sender.handler.responseXML, 'column_1')[0])
			{
				document.getElementById('column_1').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'column_1')[0]);
			}

			// Update center-top column
			if (fetch_tags(xml_sender.handler.responseXML, 'column_2')[0])
			{
				document.getElementById('column_2').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'column_2')[0]);
			}

			// Update center-bottom column
			if (fetch_tags(xml_sender.handler.responseXML, 'column_3')[0])
			{
				document.getElementById('column_3').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'column_3')[0]);
			}

			// Update right column
			if (fetch_tags(xml_sender.handler.responseXML, 'column_4')[0])
			{
				document.getElementById('column_4').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'column_4')[0]);
			}

			// Reveal column
			if (fetch_tags(xml_sender.handler.responseXML, 'revealcol')[0])
			{
				document.getElementById('column_' + xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'revealcol')[0])).style.display = '';
			}

			// Hide column
			if (fetch_tags(xml_sender.handler.responseXML, 'hidecol')[0])
			{
				document.getElementById('column_' + xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'hidecol')[0])).style.display = 'none';
			}
		}
	}
}


// ##### Disable Module #######################################################
function dyna_disable_mod(modid, modlinkid, column, dyna_page)
{
	xml_sender = new vB_AJAX_Handler(true);
	xml_sender.init();

	if (is_vb_37)
	{
		if(!is_ajax_compatible())
		{
			return true;
		}
	}
	else
	{
		if (!xml_sender.is_compatible())
		{
			return true;
		}
	}

	xml_sender.onreadystatechange(hide_module);
	xml_sender.send('module.php', "do=disable&modid=" + PHP.urlencode(modid) + "&modlinkid=" + PHP.urlencode(modlinkid) + "&col=" + PHP.urlencode(column) + "&dyna_page=" + PHP.urlencode(dyna_page) + "&ajax=1");

	return false;
}

function hide_module()
{
	if (xml_sender.handler.readyState == 4 && xml_sender.handler.status == 200)
	{
		if (xml_sender.handler.responseXML)
		{
			// Error
			if (fetch_tags(xml_sender.handler.responseXML, 'error')[0])
			{
				alert(xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'error')[0]));
			}

			var modid = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'disablemod')[0]);

			// Hide it
			if (modid)
			{
				document.getElementById('dyna_mod_' + modid + '_content').style.display = 'none';
				document.getElementById('dyna_mod_' + modid + '_controls').style.display = 'none';

				// Update inactive modules
				if (fetch_tags(xml_sender.handler.responseXML, 'inactive')[0])
				{
					document.getElementById('inactivemodbits').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'inactive')[0]);
				}

				// Hide column
				if (fetch_tags(xml_sender.handler.responseXML, 'hidecol')[0])
				{
					document.getElementById('column_' + xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'hidecol')[0])).style.display = 'none';
				}

			}
		}
	}
}

