// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

// ##### Open Rating Window ###################################################
function open_rating_window(entryid)
{
	window.open(DYNA_HOMEURL + "/misc.php?do=viewratings&entryid=" + entryid, "rating", "toolbar=no, scrollbars=yes, resizable=yes, width=240, height=320");
}

// ##### Favorites ############################################################
function vba_add_fav(entryid, modid)
{
	xml_sender = new vB_AJAX_Handler(true);
	xml_sender.init();

	if (is_vb_37)
	{
		if(!is_ajax_compatible())
		{
			return true;
		}
	}
	else
	{
		if (!xml_sender.is_compatible())
		{
			return true;
		}
	}

	if (modid == undefined)
	{
		modid = 0;
	}

	xml_sender.onreadystatechange(fetch_vba_add_fav);
	xml_sender.send('ajax.php', "do=favorite&entryid=" + PHP.urlencode(entryid) + "&modid=" + PHP.urlencode(modid));
	return false;
}

function fetch_vba_add_fav()
{
	if (xml_sender.handler.readyState == 4 && xml_sender.handler.status == 200)
	{
		if (xml_sender.handler.responseXML)
		{
			var phrase = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'phrase')[0]);

			if (phrase)
			{
				var entryid = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'entryid')[0]);
				var modid = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'modid')[0]);

				if (modid)
				{
					modid = '_m' + modid;
				}

				document.getElementById('fav_' + entryid + modid).innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'newphrase')[0]);

				alert(phrase);
			}
		}
	}
}

// ##### Subscriptions ############################################################
function vba_add_subscr(entryid, modid)
{
	xml_sender = new vB_AJAX_Handler(true);
	xml_sender.init();

	if (is_vb_37)
	{
		if(!is_ajax_compatible())
		{
			return true;
		}
	}
	else
	{
		if (!xml_sender.is_compatible())
		{
			return true;
		}
	}

	if (modid == undefined)
	{
		modid = 0;
	}

	xml_sender.onreadystatechange(fetch_vba_add_subscr);
	xml_sender.send('ajax.php', "do=subscribe&entryid=" + PHP.urlencode(entryid) + "&modid=" + PHP.urlencode(modid));
	return false;
}

// ##### Subscriptions ############################################################
function vba_add_subscr_cat(catid, entryuserid)
{
	xml_sender = new vB_AJAX_Handler(true);
	xml_sender.init();

	if (is_vb_37)
	{
		if(!is_ajax_compatible())
		{
			return true;
		}
	}
	else
	{
		if (!xml_sender.is_compatible())
		{
			return true;
		}
	}

	if (entryuserid == undefined)
	{
		entryuserid = 0;
	}

	xml_sender.onreadystatechange(fetch_vba_add_subscr);
	xml_sender.send('ajax.php', "do=subscribe&type=cat&catid=" + PHP.urlencode(catid) + "&entryuserid=" + PHP.urlencode(entryuserid));
	return false;
}

function fetch_vba_add_subscr()
{
	if (xml_sender.handler.readyState == 4 && xml_sender.handler.status == 200)
	{
		if (xml_sender.handler.responseXML)
		{
			var phrase = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'phrase')[0]);

			if (phrase)
			{
				var subtype = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'type')[0]);

				if (subtype == 'cat')
				{
					document.getElementById('subscr_cat').innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'newphrase')[0]);
				}
				else
				{
					var entryid = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'entryid')[0]);
					var modid = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'modid')[0]);

					if (modid)
					{
						modid = '_m' + modid;
					}

					document.getElementById('subscr_' + entryid + modid).innerHTML = xml_sender.fetch_data(fetch_tags(xml_sender.handler.responseXML, 'newphrase')[0]);
				}

				alert(phrase);
			}
		}
	}
}


// ##### Ratings ##############################################################
function vba_rating_click(entryid, formobj, modid)
{
	var vBa_Rate = new vBa_Rate_Entry(entryid, formobj, modid);
	vBa_Rate.init();
	return false;
}

function vBa_Rate_Entry(entryid, formobj, modid)
{
	this.entryid = entryid;
	this.formobj = formobj;
	this.modid = modid;

	var me = this;

	if (me.modid == undefined)
	{
		me.modid = '';
	}

	if (me.modid)
	{
		me.modid = '_m' + me.modid;
	}

	this.fetch_rating_result = function()
	{
		if (me.xml_sender.handler.readyState == 4 && me.xml_sender.handler.status == 200)
		{
			if (me.xml_sender.handler.responseXML)
			{
				vBmenu.hide();

				if (fetch_tags(me.xml_sender.handler.responseXML, 'error').length)
				{
					alert(me.xml_sender.fetch_data(fetch_tags(me.xml_sender.handler.responseXML, 'error')[0]));
				}
				else
				{
					if (fetch_tags(me.xml_sender.handler.responseXML, 'rating_box')[0])
					{
						document.getElementById("entryrating_" + me.entryid + me.modid).innerHTML = me.xml_sender.fetch_data(fetch_tags(me.xml_sender.handler.responseXML, 'rating_box')[0]);
					}

					if (fetch_tags(me.xml_sender.handler.responseXML, 'message')[0])
					{
						alert(me.xml_sender.fetch_data(fetch_tags(me.xml_sender.handler.responseXML, 'message')[0]));
					}
				}
			}
		}
	}
}

vBa_Rate_Entry.prototype.init = function()
{
	var voteopts = this.formobj.vote;

	for (var i = 0; i < voteopts.length; i++)
	{
		if (voteopts[i].checked)
		{
			this.vote = voteopts[i].value;
		}
	}

	this.xml_sender = new vB_AJAX_Handler(true);
	this.xml_sender.init();

	if (is_vb_37)
	{
		if(!is_ajax_compatible())
		{
			return true;
		}
	}
	else
	{
		if (!xml_sender.is_compatible())
		{
			return true;
		}
	}

	this.xml_sender.onreadystatechange(this.fetch_rating_result);
	this.xml_sender.send('ajax.php', "do=rateentry&entryid=" + PHP.urlencode(this.entryid) + "&vote=" + PHP.urlencode(this.vote));
	return false;
}