<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('VBA_SCRIPT', 'dynamics');

require_once('./dyna_config.php');

$specialtemplates = array_merge(
	array(
		'adv_dyna_attach',
		'adv_dyna_autpub',
		'adv_dyna_cats',
		'adv_dyna_cfield',
		'adv_dyna_featur',
		'adv_dyna_mods',
		'adv_dyna_opts',
		'adv_dyna_perms',
		'adv_dyna_rand'
	),
	$specialtemplates
);

$globaltemplates = array_merge(
	array(
		'adv_dyna_module_quicknav_newestbits',
		'adv_dyna_navbar',
		'adv_dyna_navbar_newestbits',
		'adv_dyna_categoryjump',
		'adv_dyna_footer'
	),
	$globaltemplates
);

$phrasegroups = array_merge(
	array(
		'adv_dyna'
	),
	$phrasegroups
);

chdir($forumpath);

require_once('./includes/vba_dyna_include_prefix.php');
require_once('./global.php');

($hook = vBulletinHook::fetch_hook('vba_dyna_global_start')) ? eval($hook) : false;

// ##### Auto Publishing ######################################################
$autopub = $vbulletin->adv_dyna_autpub;

if ($autopub['mindate'] AND $autopub['mindate'] <= TIMENOW)
{
	$newpublish = array(
		'entries' => array(),
		'mindate' => 0
	);
	$publishnow = array();

	foreach ($autopub['entries'] AS $pubid => $pubdate)
	{
		if ($pubdate <= TIMENOW)
		{
			$publishnow[] = $pubid;
		}
		else
		{
			$newpublish['entries'][$pubid] = $pubdate;
		}
	}

	if (!empty($publishnow))
	{
		$entryids_str = implode(',', $publishnow);
		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
				draft = 0
			WHERE entryid IN($entryids_str)
		");

		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entrypublish
			WHERE entryid IN($entryids_str)
		");

		$publishedcats = array();

		$getpubcats = $db->query_read("
			SELECT catid
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries
			WHERE entryid IN($entryids_str)
		");
		while ($pubcats = $db->fetch_array($getpubcats))
		{
			$publishedcats[] = $pubcats['catid'];
		}

		$publishedcats = array_unique($publishedcats);

		if (!empty($publishedcats))
		{
			require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

			foreach ($publishedcats AS $pubcatid)
			{
				update_count($pubcatid);
			}
		}
	}

	if (!empty($newpublish['entries']))
	{
		$newpublish['mindate'] = min(array_values($newpublish['entries']));
	}

	build_datastore(ADV_DYNA_PREFIX . '_autpub', serialize($newpublish), 1);
}

// ##### Inactive message
if (!$vba_options['dyna_active'])
{
	if (($permissions['adminpermissions'] & CANCONTROLPANEL) OR ($permissions['adminpermissions'] AND ISMODERATOR))
	{
		eval('$warning = "' . fetch_template('adv_dyna_inactive_warning') . '";');
		$header = $warning . $header;
		$footer .= $warning;
	}
	else
	{
		eval(standard_error($vba_options['dyna_closedmessage']));
	}
}

if (!$vba_dyna->check_perms('canviewdyna'))
{
	print_no_permission();
}

// Redirect if using cat jump (have to have it here to include the session)
if ($redirect)
{
	header("Location: $redirect");
	exit;
}

// Create some phrases from the dyna_phrase settings
fetch_option_phrases();

// Print errors from stylefetch plugin
if (defined('SF_ERROR'))
{
	switch (SF_ERROR)
	{
		case 'nopermission':
			print_no_permission();
		break;

		case 'noentryid':
			eval(standard_error(fetch_error('noid', $vbphrase['entry_lwr'])));
		break;

		default:
			eval(standard_error(fetch_error(SF_ERROR)));
	}
}

$vba_dyna->fetch_category_perms();

// First element of navbar
if (THIS_SCRIPT != 'dyna_index' AND $vba_options['dyna_navbarhomelink'])
{
	$navbits["$vba_options[dyna_homeurl]/index.php"] = $vba_options['dyna_title'];
}

$lnavrows = 3;
// ##### Show Variables & Navbar Width ########################################
if ($vba_dyna->check_perms('cansearch'))
{
	$show['searchentries'] = true;
}
if ($vba_options['dyna_showmodcolumn'])
{
	$show['modcolumn'] = true;
}

if ($vbulletin->userinfo['userid'])
{
	if ($vba_options['dyna_allowsubscribe'])
	{
		$show['subscribe'] = true;
	}
	if ($vba_options['dyna_allowfav'] AND $vbulletin->userinfo['userid'])
	{
		$show['favorites'] = true;
	}

	if ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
	{
		$show['modoptions'] = true;
	}
	else if (!empty($vbulletin->adv_dyna_mods))
	{
		foreach ($vbulletin->adv_dyna_mods AS $modcatid => $moderator)
		{
			if ($moderator[$vbulletin->userinfo['userid']])
			{
				$show['modoptions'] = true;
			}
		}
	}

	if ($vba_dyna->check_perms('canattach'))
	{
		$show['attachment_manager'] = true;
	}

	if ($vba_dyna->check_perms('cancreatecats') AND $vba_options['dyna_allow_user_cats'])
	{
		$show['managecats'] = true;
	}

	if ($show['favorites'] OR $show['subscribe'] OR $vba_options['dyna_allowdrafts'] OR $show['managecats'])
	{
		$show['my_stuff'] = true;
		$lnavrows++;
	}

	$myentrieslink = fetch_cat_url(0, array('userid' => $vbulletin->userinfo['userid'], 'title' => $vbulletin->userinfo['username']), 'member');
}

// Navbar Width
if ($vba_options['dyna_newentrylimit'])
{
	$lnavrows++;
}
if ($vba_options['dyna_popentrylimit'])
{
	if ($vba_options['dyna_allowreplies'] OR $vba_options['dyna_allowrating'])
	{
		$show['pop_popup'] = true;
	}

	$lnavrows++;
}
if ($show['modoptions'])
{
	$lnavrows++;
}

$lnavbarwidth = intval(100 / $lnavrows) . '%';

// New / popular entry links
if ($vba_options['dyna_spiderurls'])
{
	$newentrylink = 'whatsnew/entries/';
	$newpostlink = 'whatsnew/posts/';

	$popentrylinks = array(
		'views' => 'whatspopular/views/',
		'rating' => 'whatspopular/rating/',
		'posts' => 'whatspopular/posts/'
	);
}
else
{
	$poplink = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'do=popentries&amp;orderby=';
	$newentrylink = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newentries';
	$newpostlink = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newposts';

	$popentrylinks = array(
		'views' => $poplink . 'views',
		'rating' => $poplink . 'rating',
		'posts' => $poplink . 'posts'
	);
}

if ($vba_options['dyna_newentrylimit'])
{
	$newlimits = explode(',', $vba_options['dyna_newentrylimit']);

	$newlimitmax = max($newlimits);

	foreach ($newlimits AS $ndatecut)
	{
		if ($vba_options['dyna_spiderurls'])
		{
			$whatsnewlink = $newentrylink . $ndatecut;
		}
		else
		{
			$whatsnewlink = $newentrylink . '&amp;cutoffdate=' . $ndatecut;
		}

		$show['newentrynav'] = true;
		$dayphrase = construct_phrase($vbphrase['last_x_days'], $ndatecut);
		eval('$newentrynavbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_navbar_newestbits') . '";');
		eval('$newentryqlbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_module_quicknav_newestbits') . '";');

		if ($vba_options['dyna_spiderurls'])
		{
			$whatsnewlink = $newpostlink . $ndatecut;
		}
		else
		{
			$whatsnewlink = $newpostlink . '&amp;cutoffdate=' . $ndatecut;
		}

		$show['newentrynav'] = false;
		eval('$newpostnavbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_navbar_newestbits') . '";');
		eval('$newpostqlbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_module_quicknav_newestbits') . '";');
	}
}

// For the newentry.php link
$catid_int = intval($catid);

eval('$dynanav = "' . fetch_template(ADV_DYNA_PREFIX . '_navbar') . '";');

if ($vba_options['dyna_spiderurls'])
{
	$headinclude .= '<base href="' . $vba_options['dyna_homeurl'] . '/" />';
}

// Used other places, so just to be sure it's not set
$ignusers = '';

// Set here instead of checking for <= 1 every time
if ($vba_options['dyna_multipage_limit'] <= 1)
{
	$vba_options['dyna_multipage_limit'] = 0;
}

if (!is_array($vbulletin->adv_dyna_featur))
{
	$vbulletin->adv_dyna_featur = array();
}

($hook = vBulletinHook::fetch_hook('vba_dyna_global_end')) ? eval($hook) : false;

?>