<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'dyna_guestbook');

$specialtemplates = array(
	'adv_dyna_module',
	'smiliecache',
	'bbcodecache',
	'iconcache'
);

$globaltemplates = array(
	'ADV_DYNA_REPLY',
	'newreply_reviewbit',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
	'imagereg',
	'im_aim',
	'im_icq',
	'im_msn',
	'im_skype',
	'im_yahoo',
	'postbit',
	'postbit_buttons',
	'postbit_ip',
	'postbit_onlinestatus',
	'postbit_reputation',
	'postbit_wrapper'
);

$actiontemplates = array(
	'viewbook' => array(
		'ADV_DYNA_GUESTBOOK',
		'adv_dyna_postbit_deleted',
		'adv_dyna_guestbook_noreplies'
	),
	'showpost' => array(
		'ADV_DYNA_SHOWPOST'
	),
	'newreply' => array(
		'ADV_DYNA_GUESTBOOK_REPLY'
	),
	'editpost' => array(
		'ADV_DYNA_GUESTBOOK_REPLY'
	)
);

$actiontemplates['none'] =& $actiontemplates['viewbook'];

$phrasegroups = array(
	'adv_dyna_add_entpost',
	'postbit',
	'posting',
	'threadmanage'
);

if ($_REQUEST['do'] == 'showpost')
{
	$phrasegroups[] = 'showthread';
}

require_once('./dyna_global.php');
require_once(DIR . '/includes/functions_newpost.php');

($hook = vBulletinHook::fetch_hook('vba_dyna_guestbook_start')) ? eval($hook) : false;

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'viewbook';
}

$modid = $vbulletin->input->clean_gpc('r', 'modid', TYPE_INT);
$gbookmod =& $vbulletin->adv_dyna_module[$modid];

if ($gbookmod['filename'] != 'dyna_guestbook.php')
{
	eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_guest_book_disabled')));
}

if (!$vba_dyna->_permissions['gb_canview'])
{
	print_no_permission();
}

$mod_options = $gbookmod['settings'];

$show['modopts'] = (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])) ? true : false;

$haderrors = false;

$catid = intval($catid);

$catidcond = '';
if ($catid AND $mod_options['dyna_gbook_catlimit_viewmore'])
{
	$show['cats'] = true;
	$catidcond = ' AND catid = ' . $catid;
	$catinfo =& $vbulletin->adv_dyna_cats[$catid];

	if (!$vba_dyna->check_cat_perms('canviewentries'))
	{
		print_no_permission();
	}
}

// ##### View Guest Book Comments #############################################
if ($_REQUEST['do'] == 'viewbook')
{
	$masteruserid = $vbulletin->input->clean_gpc('r', 'masteruserid', TYPE_INT);

	if (!$vba_dyna->_permissions['gb_canview'])
	{
		print_no_permission();
	}

	$gbuser = $db->query_first("
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user
		WHERE userid = $masteruserid
	");

	// Kill the spacing for the postbits
	if ($show['dyna_columns'])
	{
		$spacer_open = '';
		$spacer_close = '';
	}

	$querydeleted = ($show['modopts'] OR $masteruserid == $vbulletin->userinfo['userid']) ? true : false;

	$visiblecond = ($querydeleted) ? '1,2' : 1;

	$perpage = $mod_options['dyna_gbook_viewmore_limit'];

	if ($epostid AND !$pagenumber)
	{
		$getpost = $db->query_first("SELECT dateline FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook WHERE postid = $epostid $catidcond");

		$olderposts = $db->query_first("
			SELECT COUNT(*) AS count
			FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook
			WHERE masteruserid = $masteruserid
				AND visible IN($visiblecond)
				$catidcond
				" . iif($getpost['dateline'], "AND dateline > $getpost[dateline]")
		);
		$_REQUEST['page'] = ceil(($olderposts['count'] + 1) / $perpage);
	}

	$replypagedata = fetch_page_data(
		ADV_DYNA_PREFIX . '_guestbook',
		array("masteruserid = $masteruserid AND visible IN($visiblecond) $catidcond"),
		'',
		$perpage
	);

	// We have replies
	if ($replypagedata['count'])
	{
		require_once(DIR . '/includes/vba_dyna_functions_posting.php');

		replace_page_nav_links();

		$pagenav = construct_page_nav(
			$replypagedata['pagenumber'],
			$mod_options['dyna_gbook_viewmore_limit'],
			$replypagedata['count'],
			'guestbook.php?' . $vbulletin->session->vars['sessionurl'] . 'masteruserid=' . $masteruserid . '&amp;modid=' . $modid
		);

		postbit_template_replace('gbook');

		$queryfields = '';
		$queryjoin = '';

		$queryfields = 'posts.postid, posts.masteruserid, posts.pagetext, posts.title, posts.username AS postusername, posts.dateline, posts.ipaddress AS ip, posts.showsignature, posts.visible, user.*, userfield.*, usertextfield.signature';

		$queryjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'user AS user ON (posts.userid = user.userid)
			LEFT JOIN ' . TABLE_PREFIX . 'userfield AS userfield ON (posts.userid = userfield.userid)
			LEFT JOIN ' . TABLE_PREFIX . 'usertextfield AS usertextfield ON (usertextfield.userid = posts.userid)';

		// Icons
		if ($mod_options['dyna_gbook_icons'])
		{
			$queryfields .= ', posts.iconid, icon.title as icontitle, icon.iconpath';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (posts.iconid = icon.iconid)';
		}

		// Avatars
		if ($vbulletin->options['avatarenabled'])
		{
			$queryfields .= ', avatar.avatarpath, NOT ISNULL(customavatar.filedata) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision';
			$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'avatar AS avatar ON (avatar.avatarid = user.avatarid)
				LEFT JOIN ' . TABLE_PREFIX . 'customavatar AS customavatar ON (customavatar.userid = user.userid)';
		}

		// Smilies
		if ($mod_options['dyna_gbook_smilies'])
		{
			$queryfields .= ', posts.allowsmilie';
		}

		// Deleted posts
		if ($querydeleted)
		{
			$queryfields .= ', dellog.dateline AS del_dateline, dellog.userid AS del_userid, dellog.username AS del_username, reason';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog AS dellog ON (posts.postid = dellog.deletedid AND dellog.type = \'gbook\')';
		}

		require_once(DIR . '/includes/functions_bigthree.php');
		require_once(DIR . '/includes/class_postbit.php');

		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		// kill postid here since it's used in the postbit template
		unset($postid);

		($hook = vBulletinHook::fetch_hook('vba_dyna_guestbook_view_query')) ? eval($hook) : false;


		$postbits = '';
		$gb_postcount = 0;
		$posts = $db->query("
			SELECT $queryfields, posts.userid AS userid
			FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook AS posts
			$queryjoin
			WHERE posts.masteruserid = $masteruserid AND posts.visible IN($visiblecond) $catidcond
			ORDER BY posts.dateline DESC
			LIMIT " . ($replypagedata['minlimit'] - 1) . ", $replypagedata[perpage]
		");
		while ($post = $db->fetch_array($posts))
		{
			$gb_postcount++;

			$postbits .= fetch_dyna_postbit($post, 'gbook');
		}

		$db->free_result($posts);
	}
	else
	{
		eval('$postbits = "' . fetch_template(ADV_DYNA_PREFIX . '_guestbook_noreplies') . '";');
	}

	$titlephrase = fetch_possessive($gbuser['username']) . ' ' . $vbphrase['guest_book'];

	$navbits[''] = $titlephrase;

	if ($show['cats'])
	{
		$navbits = fetch_cat_navbits($catid);
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_GUESTBOOK') . '");');
}

// ##### View Single Guest Book Comment #######################################
if ($_REQUEST['do'] == 'showpost')
{
	$masteruserid = $vbulletin->input->clean_gpc('r', 'masteruserid', TYPE_INT);

	if (!$vba_dyna->_permissions['gb_canview'])
	{
		print_no_permission();
	}

	require_once(DIR . '/includes/vba_dyna_functions_posting.php');

	postbit_template_replace('gbook');

	$queryfields = '';
	$queryjoin = '';

	$queryfields = 'posts.postid, posts.masteruserid, posts.pagetext, posts.title, posts.userid, posts.username AS postusername, posts.dateline, posts.ipaddress AS ip, posts.showsignature, posts.visible, user.*, userfield.*, usertextfield.signature';

	$queryjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'user AS user ON (posts.userid = user.userid)
		LEFT JOIN ' . TABLE_PREFIX . 'userfield AS userfield ON (posts.userid = userfield.userid)
		LEFT JOIN ' . TABLE_PREFIX . 'usertextfield AS usertextfield ON (usertextfield.userid = posts.userid)';

	// Icons
	if ($mod_options['dyna_gbook_icons'])
	{
		$queryfields .= ', posts.iconid, icon.title as icontitle, icon.iconpath';
		$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (posts.iconid = icon.iconid)';
	}

	// Avatars
	if ($vbulletin->options['avatarenabled'])
	{
		$queryfields .= ', avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision';
		$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'avatar AS avatar ON (avatar.avatarid = user.avatarid)
			LEFT JOIN ' . TABLE_PREFIX . 'customavatar AS customavatar ON (customavatar.userid = user.userid)';
	}

	// Smilies
	if ($mod_options['dyna_gbook_smilies'])
	{
		$queryfields .= ', posts.allowsmilie';
	}

	// Deleted posts
	if ($querydeleted)
	{
		$queryfields .= ', dellog.dateline AS del_dateline, dellog.userid AS del_userid, dellog.username AS del_username, reason';
		$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog AS dellog ON (posts.postid = dellog.deletedid AND dellog.type = \'gbook\')';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_guestbook_showpost_query')) ? eval($hook) : false;

	require_once(DIR . '/includes/functions_bigthree.php');
	require_once(DIR . '/includes/class_postbit.php');

	// Load BBcode parser
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	// kill postid here since it's used in the postbit template
	unset($postid);

	$postbits = '';
	$post = $db->query_first("
		SELECT $queryfields
		FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook AS posts
		$queryjoin
		WHERE posts.postid = $epostid
	");

	if (!$show['modopts'] AND (!$post['visible'] OR !$vba_options['dyna_allowreplies'] OR !$vba_dyna->check_cat_perms('canviewreplies', $post)))
	{
		print_no_permission();
	}

	$gbuser = $db->query_first("
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user
		WHERE userid = $post[masteruserid]
	");

	if ($show['modopts'] AND $post['visible'] == 2)
	{
		$show['deletedpost'] = true;
		$post['visible'] = 1;
	}

	$show['spacer'] = false;

	$postbit = fetch_dyna_postbit($post, 'gbook');

	$titlephrase = fetch_possessive($gbuser['username']) . ' ' . $vbphrase['guest_book'];
	$masteruserid = $gbuser['userid'];

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_SHOWPOST') . '");');
}

// ########################## Do Reply to Entry #############################
if ($_POST['do'] == 'postreply' OR $_POST['do'] == 'doedit')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'customdate' => TYPE_ARRAY,
		'iconid' => TYPE_INT,
		'imagehash' => TYPE_STR,
		'imagestamp' => TYPE_STR,
		'masteruserid' => TYPE_INT,
		'message' => TYPE_STR,
		'signature' => TYPE_INT,
		'title' => TYPE_NOHTML,
		'username' => TYPE_NOHTML,
		'wysiwyg' => TYPE_BOOL
	));

	require_once(DIR . '/includes/vba_dyna_functions_posting.php');
	require_once(DIR . '/includes/functions_misc.php');

	($hook = vBulletinHook::fetch_hook('vba_dyna_guestbook_doreply')) ? eval($hook) : false;

	// Edit post permissions
	if ($_POST['do'] == 'doedit')
	{
		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}

		$oldpost = $db->query_first("SELECT userid, masteruserid, dateline FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook WHERE postid = $epostid");

		if (!$show['modopts'])
		{
			if (
				($vbulletin->userinfo['userid'] != $oldpost['userid'] AND !$vba_dyna->_permissions['gb_caneditothersinown'])
				OR ($vbulletin->userinfo['userid'] == $oldpost['userid']
					AND !$vba_dyna->_permissions['gb_caneditown']
					AND $vbulletin->userinfo['userid'] != $oldpost['masteruserid']
				)
			)
			{
				print_no_permission();
			}

			// Check time limit
			if (!$show['modopts']
				AND $vba_options['dyna_editpost_timelimit']
				AND (TIMENOW - ($vba_options['dyna_editpost_timelimit'] * 60)) > $oldpost['dateline']
			)
			{
				eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editpost_timelimit'], $vbulletin->options['contactuslink'])));
			}
		}
	}
	// New reply permissions
	else
	{
		if ($vbulletin->GPC['masteruserid'] != $vbulletin->userinfo['userid'] AND !$vba_dyna->_permissions['gb_canreply'])
		{
			print_no_permission();
		}
	}

	$post['title'] = fetch_censored_text($vbulletin->GPC['title']);
	$post['username'] = $vbulletin->GPC['username'];

	// WYSIWYG
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$post['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	// Normal editor
	else
	{
		$post['message'] = $vbulletin->GPC['message'];
	}

	// Smilies
	$post['disablesmilies'] = $_POST['disablesmilies'];

	$post['enablesmilies'] = 0;
	if (!$post['disablesmilies'])
	{
		$post['enablesmilies'] = 1;
	}

	// ##### Check for errors
	$errors = array();

	// Image verification
	$imagereg = '';
	if ($vbulletin->options['regimagetype'] AND in_array('reply', $vba_options['dyna_imageverify']) AND !$vbulletin->userinfo['userid'])
	{
		require_once(DIR . '/includes/functions_regimage.php');
		if (!verify_regimage_hash($vbulletin->GPC['imagehash'], $vbulletin->GPC['imagestamp']))
		{
			eval('$errors[] = "' . fetch_error('register_imagecheck') . '";');
  	}
	}

	// Check message length
	$postlength = strlen($post['message']);

	if (!$post['message'] AND $vbulletin->options['postminchars'])
	{
		eval('$errors[] = "' . fetch_error('nosubject') . '";');
	}

	// too short
	if ($vbulletin->options['postminchars'] AND $postlength < $vbulletin->options['postminchars'])
	{
		eval('$errors[] = "' . fetch_error('tooshort', vb_number_format($postlength), vb_number_format($vbulletin->options['postminchars'])) . '";');
	}
	// too long
	else if ($mod_options['dyna_gbook_reply_length'] AND $postlength > $mod_options['dyna_gbook_reply_length'])
	{
		eval('$errors[] = "' . fetch_error('toolong', vb_number_format($postlength), vb_number_format($mod_options['dyna_gbook_reply_length'])) . '";');
	}

	// Guest username check
	if (!$vbulletin->userinfo['userid'])
	{
		if (!$post['username'])
		{
			eval('$errors[] = "' . fetch_error('nousername') . '";');
		}
		else if (strlen($post['username']) < $vbulletin->options['minuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametooshort', $vbulletin->options['minuserlength']) . '";');
		}
		else if (strlen($post['username']) > $vbulletin->options['maxuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametoolong', $vbulletin->options['maxuserlength']) . '";');
		}
		else if ($dupecheck = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string(htmlspecialchars($post['username'])) . "'"))
		{
			eval('$errors[] = "' . fetch_error('usernametaken', addslashes(htmlspecialchars($post['username'])), $vbulletin->session->vars['sessionurl']) . '";');
		}
	}

	$post['message'] = fetch_censored_text($post['message']);

	if ($_POST['parseurl'])
	{
		$post['message'] = convert_url_to_bbcode($post['message']);
	}

	// Duplicate post / flood check
	if ($_REQUEST['do'] == 'postreply' AND $vbulletin->userinfo['userid'] AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND !can_moderate())
	{
		$lpost = $db->query_first("
			SELECT postid, title, pagetext, dateline
			FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
				AND masteruserid = " . $vbulletin->GPC['masteruserid'] . "
			ORDER BY dateline DESC
		");

		// Have the same post, so just redirect the user
		if ($post['message'] == $lpost['pagetext'] AND $post['title'] == $lpost['title'])
		{
			$vbulletin->url = 'guestbook.php?' . $vbulletin->session->vars['sessionurl'] . 'masteruserid=' . $vbulletin->GPC['masteruserid'] . '&modid=' . $modid . '&epostid=' . $lpost['postid'] . '#post' . $lpost['postid'];
			eval(print_standard_redirect('redirect_postthanks'));
		}

		// Have flooding, so display error
		if ($vbulletin->options['floodchecktime'] AND !$_POST['preview'] AND (TIMENOW - $lpost['dateline']) <= $vbulletin->options['floodchecktime'])
		{
			eval('$errors[] = "' . fetch_error('postfloodcheck', $vbulletin->options['floodchecktime'], ($vbulletin->options['floodchecktime'] - (TIMENOW - $lpost['dateline']))) . '";');
		}
	}

	// Max images
	if ($vbulletin->options['maximages'])
	{
		require_once(DIR . '/includes/class_bbcode_alt.php');
		$bbcode_parser_img =& new vB_BbCodeParser_ImgCheck($vbulletin, fetch_tag_list());

		$imagecount = fetch_character_count($bbcode_parser_img->parse($post['message'], 'nonforum', $post['enablesmilies'], true), '<img');
		if ($imagecount > $vbulletin->options['maximages'])
		{
			eval('$errors[] = "' . fetch_error('toomanyimages', $imagecount, $vbulletin->options['maximages']) . '";');
		}
	}

	// Errors!
	if (!empty($errors))
	{
		$postpreview = construct_errors($errors);
		construct_checkboxes($_POST);
		$newpost['message'] = htmlspecialchars($post['message']);

		$haderrors = true;
		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'newreply';
		}
	}

	// Just previewing
	else if ($_POST['preview'])
	{
		if (!$mod_options['dyna_gbook_smilies'])
		{
			$post['disablesmilies'] = 1;
		}

		$postpreview = process_post_preview($post);
		$newpost['message'] = $post['message'];
		construct_checkboxes($_POST);

		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['epostid'] = $epostid;
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'newreply';
		}
	}
	else
	{
		// Everything's good, so get ready to insert or update

		// New reply
		if ($_REQUEST['do'] == 'postreply')
		{
			// Insert the post
			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "guestbook
					(masteruserid, title, pagetext, userid, username, dateline, catid, ipaddress, iconid, allowsmilie, showsignature, visible)
				VALUES (
					" . $vbulletin->GPC['masteruserid'] . ",
					'" . $db->escape_string($post['title']) . "',
					'" . $db->escape_string($post['message']) . "',
					" . $vbulletin->userinfo['userid'] . ",
					'" . $db->escape_string($vbulletin->userinfo['username']) . "',
					" . TIMENOW . ",
					" . $catid . ",
					'" . $db->escape_string(IPADDRESS) . "',
					" . $vbulletin->GPC['iconid'] . ",
					$post[enablesmilies],
					" . $vbulletin->GPC['signature'] . ",
					1
			)");

			$newpostid = $db->insert_id();
		}

		// Editing a post
		else
		{
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "guestbook SET
					title = '" . $db->escape_string($post['title']) . "',
					pagetext = '" . $db->escape_string($post['message']) . "',
					iconid = " . $vbulletin->GPC['iconid'] . ",
					allowsmilie = $post[enablesmilies],
					showsignature = " . $vbulletin->GPC['signature'] . "
				WHERE postid = $epostid
			");
			$newpostid = $epostid;
		}

		$vbulletin->url = 'guestbook.php?' . $vbulletin->session->vars['sessionurl'] . 'masteruserid=' . $vbulletin->GPC['masteruserid'] . '&modid=' . $modid . '&catid=' . $catid . '&epostid=' . $newpostid . '#post' . $newpostid;

		if ($_POST['do'] == 'postreply')
		{
			eval(print_standard_redirect('redirect_postthanks'));
		}
		else
		{
			eval(print_standard_redirect('redirect_editthanks'));
		}
	}
}

// ########################## Reply to Entry #############################
if ($_REQUEST['do'] == 'newreply' OR $_REQUEST['do'] == 'editpost')
{
	$masteruserid = $vbulletin->input->clean_gpc('r', 'masteruserid', TYPE_INT);

	$gbuser = $db->query_first("
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user
		WHERE userid = $masteruserid
	");

	if (!$gbuser['userid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['user'])));
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_guestbook_reply')) ? eval($hook) : false;

	// Get post info for quoting or editing
	if ($epostid)
	{
		$post = $db->query_first("
			SELECT posts.postid, masteruserid, title, pagetext, posts.dateline, posts.username, posts.userid, showsignature, allowsmilie, iconid
			" . iif($show['modopts'], ', dellog.dateline AS del_dateline, dellog.userid AS del_userid, dellog.username AS del_username, reason') . "
			FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook AS posts
			" . iif($show['modopts'], ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog AS dellog ON (posts.postid = dellog.deletedid AND type = \'gbook\')') . "
			WHERE postid = $epostid
		");
	}

	$usersbook_phrase = fetch_possessive($gbuser['username']) . ' ' . $vbphrase['guest_book'];

	// Check permissions
	if ($_REQUEST['do'] == 'newreply')
	{
		if ($masteruserid != $vbulletin->userinfo['userid'] AND !$vba_dyna->_permissions['gb_canreply'])
		{
			print_no_permission();
		}

		$titlephrase = $vbphrase['post_reply'];
	}
	else
	{
		$show['editpost'] = true;

		if (!$show['modopts'])
		{
			if (!$vbulletin->userinfo['userid']
				OR ($vbulletin->userinfo['userid'] != $post['userid'] AND !$vba_dyna->_permissions['gb_caneditothers'])
				OR ($vbulletin->userinfo['userid'] == $post['userid']
					AND !$vba_dyna->_permissions['gb_caneditown']
					AND $vbulletin->userinfo['userid'] != $post['masteruserid']
				)
			)
			{
				print_no_permission();
			}

			// Check time limit
			if ($vba_options['dyna_editpost_timelimit'] AND (TIMENOW - ($vba_options['dyna_editpost_timelimit'] * 60)) > $post['dateline'])
			{
				eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editpost_timelimit'], $vbulletin->options['contactuslink'])));
			}
		}

		// Delete options
		if (($vba_dyna->_permissions['gb_candeleteown'] AND $vbulletin->userinfo['userid'] == $post['userid']) OR $vba_dyna->_permissions['gb_candeleteothers'] OR $show['modopts'])
		{
			$show['deleteopt'] = true;
			$show['reason'] = true;
			$show['physremove'] = $vba_dyna->_permissions['gb_canphysremove'];
		}

		$titlephrase = $vbphrase['edit_post'];
	}

	// Have a post with no errors, so start processing
	if (!empty($post) AND !$haderrors)
	{
		if ($_REQUEST['do'] == 'editpost' AND !$_REQUEST['preview'])
		{
			$newpost['message'] = $post['pagetext'];
			if (!$post['allowsmilie'])
			{
				$checked['disablesmilies'] = 'checked="checked"';
			}
			if ($post['showsignature'])
			{
				$checked['signature'] = 'checked="checked"';
			}
			else
			{
				$checked['signature'] = '';
			}
		}
		// Go Advanced
		else if ($_REQUEST['preview'])
		{
			$pagetext = $post['pagetext'];
		}
		// Quoting post
		else if (!$_REQUEST['quickreply'])
		{
			$originalposter = fetch_quote_username($post['username']);
			$pagetext = trim(htmlspecialchars(strip_quotes($post['pagetext'])));
			eval('$newpost[\'message\'] = "' . fetch_template('newpost_quote', 1, 0) . '";');
		}
	}

	if ($_REQUEST['do'] == 'editpost')
	{
		if (!isset($checked['parseurl']))
		{
			$checked['parseurl'] = 'checked="checked"';
		}

		if ($post['showsignature'])
		{
			$checked['signature'] = 'checked="checked"';
		}

		if (!$post['allowsmilie'])
		{
			$checked['disablesmilies'] = 'checked="checked"';
		}
	}
	else
	{
		// Check URL box if isn't set
		if (!isset($checked['parseurl']))
		{
			$checked['parseurl'] = 'checked="checked"';
		}

		// Signature check box
		if (trim($vbulletin->userinfo['signature']) AND !$preview AND !isset($checked['signature']))
		{
			$checked['signature'] = 'checked="checked"';
		}

		// Get replies for topic review
		if ($vba_dyna->_permissions['gb_canview'])
		{
			$countposts = $db->query_first("
				SELECT COUNT(*) AS count
				FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook
				WHERE masteruserid = $masteruserid $catidcond
			");
		}

		if ($countposts['count'])
		{
			$getposts = $db->query("
				SELECT pagetext, username, dateline " . iif($mod_options['dyna_gbook_smilies'], ', allowsmilie') . "
				FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook
				WHERE masteruserid = $masteruserid $catidcond
				ORDER BY dateline DESC
				LIMIT " . $vbulletin->options['maxposts']
			);
			if ($db->num_rows($getposts))
			{
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
				$show['reviewbits'] = true;

				while ($posts = $db->fetch_array($getposts))
				{
					$posttime = vbdate($vbulletin->options['timeformat'], $posts['dateline']);
					$postdate = vbdate($vbulletin->options['dateformat'], $posts['dateline']);
					$username = $posts['username'];

					$reviewmessage = $bbcode_parser->do_parse(
						$posts['pagetext'],
						$mod_options['dyna_gbook_html'],
						$posts['allowsmilie'],
						$mod_options['dyna_gbook_bbcode'],
						$mod_options['dyna_gbook_bbimgcode']
					);
					eval('$reviewbits .= "' . fetch_template('newreply_reviewbit') . '";');
				}
			}
			if ($countposts['count'] > $vbulletin->options['maxposts'])
			{
				$show['reviewmore'] = true;
			}
			$db->free_result($getposts);
			unset($posts);
		}
	}

	require_once(DIR . '/includes/functions_editor.php');
	$textareacols = fetch_textarea_width();

	$vbulletin->templatecache['posticons'] = str_replace(
		'$GLOBALS[\'vbulletin\']->options[\'cleargifurl\']',
		'$GLOBALS[\'vbulletin\']->options[\'bburl\'] . "/" . $GLOBALS[\'vbulletin\']->options[\'cleargifurl\']',
		$vbulletin->templatecache['posticons']
	);

	$iconbits = construct_icons($iconid, iif($mod_options['dyna_gbook_icons'], 1, 0));

	$selectedicon['src'] = str_replace(
		$vbulletin->options['cleargifurl'],
		$vbulletin->options['bburl'] . '/' . $vbulletin->options['cleargifurl'],
		$selectedicon['src']
	);

	$editsmilie = $mod_options['dyna_gbook_smilies'];

	if (!empty($post) AND !$post['enablesmilies'] AND !$post['allowsmilie'])
	{
		$editsmilie = 0;
	}

	// Replace custom BB code images
	if (!empty($vbulletin->bbcodecache))
	{
		foreach ($vbulletin->bbcodecache AS $bbcodeid => $bbcodeinfo)
		{
			if ($bbcodeinfo['buttonimage'])
			{
				$vbulletin->bbcodecache[$bbcodeid]['buttonimage'] = $vbulletin->options['bburl'] . '/' . $bbcodeinfo['buttonimage'];
			}
		}
	}

	$vbulletin->options['allowbbimagecode'] = ($mod_options['dyna_gbook_bbimgcode']) ? 1 : 0;

	// Fake IE6 to so it won't try to use the IE7 popups
	$vbulletin->templatecache['editor_clientscript'] .= '<script type=\"text/javascript\">
    <!--
        var is_ie7 = false;
    -->
    </script>';

	// Editor & message area
	$editorid = construct_edit_toolbar($newpost['message'], false, 0, $mod_options['dyna_gbook_smilies'], $editsmilie, 0);

	$messagearea = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $messagearea);

	eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

	if ($vbulletin->options['regimagetype'] AND in_array('reply', $vba_options['dyna_imageverify']) AND !$vbulletin->userinfo['userid'])
	{
		require_once(DIR . '/includes/functions_regimage.php');
		$imagehash = fetch_regimage_hash();

		$vbulletin->templatecache['imagereg'] = str_replace('"image.php', '"' . $vbulletin->options['bburl'] . '/image.php', $vbulletin->templatecache['imagereg']);

		eval('$imagereg = "' . fetch_template('imagereg') . '";');
	}

	if ($show['cats'])
	{
		$navbits = fetch_cat_navbits($catid);
	}

	$navbits['guestbook.php?' . $vbulletin->session->vars['sessionurl'] . 'masteruserid=' . $vbulletin->GPC['masteruserid'] . '&amp;modid=' . $vbulletin->GPC['modid']] = $usersbook_phrase;
	$navbits[''] = $titlephrase;

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_GUESTBOOK_REPLY') . '");');
}

// ##### Delete Post ##########################################################
if ($_POST['do'] == 'dodeletepost')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'confirmaction' => TYPE_INT,
		'epostid' => TYPE_INT,
		'modid' => TYPE_INT,
		'reason' => TYPE_NOHTML
	));

	$post = $db->query_first("
		SELECT postid, posts.userid, posts.masteruserid, posts.visible
		FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook AS posts
		WHERE postid = " . $vbulletin->GPC['epostid']
	);

	if (!$post['postid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['post'])));
	}

	if (!$show['modopts']
		AND (!$vbulletin->userinfo['userid']
			OR ($post['userid'] != $vbulletin->userinfo['userid'] AND !$vba_dyna->_permissions['gb_caneditothers'])
			OR (!$vba_dyna->_permissions['gb_candeleteown'])
		)
	)
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_guestbook_dodelete')) ? eval($hook) : false;

	$updatereason = 'update';

	switch ($vbulletin->GPC['confirmaction'])
	{
		// Restore
		case 3:

			if ($post['visible'] == 2)
			{
				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "guestbook SET
						visible = 1
					WHERE postid = $post[postid]
				");

				$updatereason = 'delete';
			}

		break;

		// Physically remove
		case 2:

			if ($vba_dyna->_permissions['gb_canphysremove'])
			{
				$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook WHERE postid = $post[postid]");
				$updatereason = 'delete';
			}

		break;

		// Soft Delete
		case 1:

			if ($post['visible'] != 2)
			{
				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "guestbook SET visible = 2 WHERE postid = $post[postid]");
			}

		break;

		default:

			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_nodelete', $vbphrase['message'])));
	}

	// ##### Reason
	if ($updatereason == 'delete')
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "deletionlog
			WHERE deletedid = $post[postid]
				AND type = 'post'
		");
	}
	else
	{
		$db->query_write("
			REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "deletionlog
				(deletedid, type, userid, username, dateline, reason)
			VALUES (
				$post[postid],
				'gbook',
				" . $vbulletin->userinfo['userid'] . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->GPC['reason']) . "'
			)
		");
	}

	$vbulletin->url = 'guestbook.php?' . $vbulletin->session->vars['sessionurl'] . 'modid=' . $vbulletin->GPC['modid'] . '&masteruserid=' . $post['masteruserid'];

	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_posts_deleted'));
}

?>