<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'dyna_modules');

$globaltemplates = array();

$phrasegroups = array('adv_dyna_modules');

switch ($_REQUEST['do'])
{
	case 'addmodule':
	case 'editmodule':
	case 'doaddmodule':
	case 'doeditmodule':
		$phrasegroups[] = 'posting';
		define('GET_EDIT_TEMPLATES', true);

		$globaltemplates = array(
			'ADV_DYNA_ADD_EDIT_MODULE',
			'newreply_reviewbit',
			'bbcode_code',
			'bbcode_html',
			'bbcode_php',
			'bbcode_quote',
		);
	break;

	case 'movemod':

		// Needed for moving the about me module
		$phrasegroups[] = 'cprofilefield';
	break;
}

$specialtemplates = array(
	'adv_dyna_modpos',
	'adv_dyna_module',
	'bbcodecache'
);

$actiontemplates = array(
	'deletemodule' => array(
		'ADV_DYNA_CONFORMATION'
	)
);

require_once('./dyna_global.php');
require_once(DIR . '/includes/vba_dyna_functions_modules.php');

($hook = vBulletinHook::fetch_hook('vba_dyna_module_start')) ? eval($hook) : false;

// Main permissions
if (!$vba_dyna->_permissions['canmodule'])
{
	print_no_permission();
}

// ##### Save Layout ##########################################################
if ($_POST['do'] == 'savelayout')
{
	$dyna_page = $vbulletin->input->clean_gpc('r', 'dyna_page', TYPE_NOHTML);

	$vbulletin->input->clean_array_gpc('p', array(
		'mods' => TYPE_ARRAY,
		'url' => TYPE_STR
	));

	if (!in_array($dyna_page, $vba_dyna->_dyna_pages))
	{
		eval(standard_error(fetch_error('invalid_page_specified')));
	}

	$oldlayout = fetch_user_layout($dyna_page);

	// Cache the modules to get the user's modids
	cache_modules();

	// Get them sorted into active and inactive so we can make sure we're only
	// processing inactive modules and there's not a chance for duplication
	$activemods = array();
	if (!empty($oldlayout))
	{
		foreach ($oldlayout AS $ocolumn => $omods)
		{
			if (!empty($omods))
			{
				$activemods = array_merge($activemods, array_keys($omods));
			}
		}
	}

	// Compare to cache to make sure we're only dealing with valid modules
	$inactivemods = array_diff(array_keys($vbulletin->adv_dyna_module), $activemods);

	$layout = array();
	$colnames = array();
	foreach ($vba_dyna->_colnames AS $colno => $colname)
	{
		$columnids[] = $colno;
		$layout[$colno] = array();
	}

	// Sort modules being added into some better arrays to work with
	$addlayout = array();
	$newmodsorder = array();
	if (!empty($inactivemods))
	{
		foreach ($inactivemods AS $imodid)
		{
			$modsubmit =& $vbulletin->GPC['mods'][$imodid];

			if ($modsubmit['position'] AND
				($vba_dyna->module_perms($imodid, 'canenable') OR $vbulletin->adv_dyna_module[$imodid]['custom'])
			)
			{
				$posarray = explode('-', $modsubmit['position']);

				$tocolumn = intval($posarray[0]);
				$aftermodid = intval($posarray[1]);

				if (!in_array($tocolumn, $columnids))
				{
					trigger_error('invalid location', E_USER_ERROR);
				}

				if ($aftermodid AND !isset($oldlayout[$tocolumn][$aftermodid]))
				{
					$aftermodid = 0;
				}

				$addlayout[$tocolumn][$aftermodid][$imodid] = intval($modsubmit['order']);
			}
		}
	}

	// sort modules with uasort()
	function dyna_sort_mods($a, $b)
	{
		if ($a == $b)
		{
			return 0;
		}

		return ($a < $b) ? -1 : 1;
	}

	// Now sort the new layout
	foreach ($layout AS $colid => $colarray)
	{
		$orderplus = 0;

		if (is_array($addlayout[$colid]))
		{
			if (is_array($addlayout[$colid]['0']))
			{
				uasort($addlayout[$colid]['0'], 'dyna_sort_mods');

				foreach ($addlayout[$colid]['0'] AS $topmodid => $topmodorder)
				{
					$orderplus++;
					$layout[$colid][$topmodid] = $orderplus;
				}

				unset($addlayout[$colid]['0']);
			}

			if (!empty($oldlayout[$colid]))
			{
				foreach ($oldlayout[$colid] AS $oldmodid => $oldorder)
				{
					$lastorder = $oldorder + $orderplus;
					$layout[$colid][$oldmodid] = $lastorder;

					if (is_array($addlayout[$colid][$oldmodid]))
					{
						uasort($addlayout[$colid][$oldmodid], 'dyna_sort_mods');

						foreach ($addlayout[$colid][$oldmodid] AS $newmodid => $newmodorder)
						{
							$orderplus++;
							$layout[$colid][$newmodid] = $lastorder + $orderplus;
						}
					}
				}
			}
		}
		else if (!empty($oldlayout[$colid]))
		{
			$layout[$colid] = $oldlayout[$colid];
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_module_savelayout')) ? eval($hook) : false;

	$db->query_write("
		REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "layout
			(userid, page, layout)
		VALUES (
			" . $vbulletin->userinfo['userid'] . ",
			'" . $db->escape_string($dyna_page) . "',
			'" . $db->escape_string(serialize($layout)) . "'
		)
	");

	$vbulletin->url = fetch_layout_redirect(false);
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_layoutsaved'));
}

// ##### Move Module ##########################################################
if ($_REQUEST['do'] == 'movemod')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'ajax' => TYPE_BOOL,
		'col' => TYPE_INT,
		'dir' => TYPE_STR,
		'dyna_page' => TYPE_STR,
		'modid' => TYPE_INT,
		'modlinkid' => TYPE_INT
	));

	$modid = ($vbulletin->GPC['modlinkid']) ? 'u' . $vbulletin->GPC['modlinkid'] : $vbulletin->GPC['modid'];
	$column = $vbulletin->GPC['col'];
	$dyna_page = $vbulletin->GPC['dyna_page'];
	$movetocol = 0;
	$revealcol = 0;

	if (!in_array($dyna_page, $vba_dyna->_dyna_pages))
	{
		eval(standard_error(fetch_error('invalid_page_specified')));
	}

	if (!in_array($column, array_keys($vba_dyna->_colnames)))
	{
		eval(standard_error(fetch_error('noid', $vbphrase['column'])));
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_module_move_start')) ? eval($hook) : false;

	$layout = fetch_user_layout($dyna_page);

	$colcheck = false;
	if (isset($layout[$column][$modid]))
	{
		$colmods = array_keys($layout[$column]);
		$modpos = array_search($modid, $colmods);

		$colcheck = true;
		unset($layout[$column][$modid]);
		unset($colmods[$modpos]);

		switch ($vbulletin->GPC['dir'])
		{
			// Currently in center-top and moving down to center-bottom
			case 'down-center':

				$movetocol = 3;
				$centermods = array_merge(array($modid), array_keys($layout['3']));

				if (empty($layout[$movetocol]))
				{
					$revealcol = $movetocol;
				}

				$layout['3'] = array_combine($centermods, range(1, sizeof($centermods)));
			break;

			// Currently in center-bottom and moving up to center-top
			case 'up-center':

				$movetocol = 2;

				if (empty($layout[$movetocol]))
				{
					$revealcol = $movetocol;
				}

				$centermods = array_merge(array_keys($layout['2']), array($modid));

				$layout['2'] = array_combine($centermods, range(1, sizeof($centermods)));

			break;

			case 'up':
			case 'down':

				$newpos = $modpos + ($vbulletin->GPC['dir'] == 'down' ? 1 : -1);

				array_splice($colmods, $newpos, 0, $modid);

				$layout[$column] = array_combine($colmods, range(1, sizeof($colmods)));

			break;

			case 'left':
			case 'right':

				if ($vbulletin->GPC['dir'] == 'right')
				{
					$movetocol = ($column == 1) ? 2 : 4;
				}
				else
				{
					$movetocol = ($column == 4) ? 2 : 1;
				}

				if (empty($layout[$movetocol]))
				{
					$revealcol = $movetocol;
				}

				$newcolmods = array_keys($layout[$movetocol]);

				array_splice($newcolmods, min(sizeof($layout[$movetocol]), $modpos), 0, $modid);

				$layout[$movetocol] = array_combine($newcolmods, range(1, sizeof($newcolmods)));

			break;

			default:

				trigger_error('invalid location', E_USER_ERROR);
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_module_move_end')) ? eval($hook) : false;

	$db->query_write("
		REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "layout
			(userid, page, layout)
		VALUES (
			" . $vbulletin->userinfo['userid'] . ",
			'" . $db->escape_string($dyna_page) . "',
			'" . $db->escape_string(serialize($layout)) . "'
		)
	");

	// AJAX
	if ($_REQUEST['ajax'])
	{
		// Init XML Builder
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('data');

		$updatearray = array($column);

		if ($movetocol)
		{
			$updatearray[] = $movetocol;
		}

		foreach ($updatearray AS $upcolid)
		{
			$dyna_module_layout[$upcolid] = $layout[$upcolid];
		}

		require_once(DIR . '/includes/vba_dyna_include_modules.php');

		// Update old
		if ($column)
		{
			$xml->add_tag('column_' . $column, $home['dyna_' . $vba_dyna->_colnames[$column] . 'blocks'], array(), true);
		}

		// Update new
		if ($movetocol)
		{
			$xml->add_tag('column_' . $movetocol, $home['dyna_' . $vba_dyna->_colnames[$movetocol] . 'blocks'], array(), true);
		}

		// Need to hide the column
		if (empty($layout[$column]))
		{
			$xml->add_tag('hidecol', $column, array(), true);
		}

		// Need to reveal the column
		if ($revealcol)
		{
			$xml->add_tag('revealcol', $revealcol, array(), true);
		}

		$xml->close_group();
		$xml->print_xml();
	}
	// Normal request
	else
	{
		exec_header_redirect(fetch_layout_redirect());
	}
}

// ##### Disable Module #######################################################
if ($_REQUEST['do'] == 'disable')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'ajax' => TYPE_BOOL,
		'dyna_page' => TYPE_STR,
		'modid' => TYPE_INT,
		'modlinkid' => TYPE_INT,
		'col' => TYPE_INT
	));

	$modid = ($vbulletin->GPC['modlinkid']) ? 'u' . $vbulletin->GPC['modlinkid'] : $vbulletin->GPC['modid'];
	$column = $vbulletin->GPC['col'];
	$dyna_page = $vbulletin->GPC['dyna_page'];

	// Init XML Builder
	if ($vbulletin->GPC['ajax'])
	{
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('data');
	}

	// Invalid dynamics page
	if (!in_array($dyna_page, $vba_dyna->_dyna_pages))
	{
		$errorphrase = fetch_error('invalid_page_specified');

		if ($vbulletin->GPC['ajax'])
		{
			$xml->add_tag('error', $errorphrase);
		}
		else
		{
			eval(standard_error($errorphrase));
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_module_disable')) ? eval($hook) : false;

	// Can't disable this one
	if (!$vba_dyna->module_perms($modid, 'candisable') AND $vbulletin->adv_dyna_module[$modid])
	{
		$errorphrase = fetch_error(
			ADV_DYNA_PREFIX . '_cannot_disable_x',
			$vbphrase['module'],
			$module['title']
		);

		if ($vbulletin->GPC['ajax'])
		{
			$xml->add_tag('error', $errorphrase);
		}
		else
		{
			eval(standard_error($errorphrase));
		}
	}

	$layout = fetch_user_layout($dyna_page);

	// Exists in the column that was submitted
	if (isset($layout[$column][$modid]))
	{
		unset($layout[$column][$modid]);
	}
	// Fall back, just incase
	else
	{
		if (!empty($layout))
		{
			foreach ($layout AS $oldcol => $oldmods)
			{
				if (in_array($modid, $oldmods))
				{
					unset($layout[$oldcol][$modid]);
				}
			}
		}
	}

	$db->query_write("
		REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "layout
			(userid, page, layout)
		VALUES (
			" . $vbulletin->userinfo['userid'] . ",
			'" . $db->escape_string($dyna_page) . "',
			'" . $db->escape_string(serialize($layout)) . "'
		)
	");

	// AJAX request
	if ($vbulletin->GPC['ajax'])
	{
		$xml->add_tag('disablemod', $modid, array(), true);

		$dyna_module_layout = $layout;

		cache_modules();

		// Need a list of active modules for the fetch_inactive function
		$activemodules = array();

		if (!empty($layout))
		{
			foreach ($layout AS $acol => $amods)
			{
				$activemodules = array_merge($activemodules, array_keys($amods));
			}
		}

		$inactivemodbits = fetch_inactive_modulebits();

		$xml->add_tag('inactive', $inactivemodbits, array(), true);

		// Need to hide the column
		if (empty($layout[$column]))
		{
			$xml->add_tag('hidecol', $column, array(), true);
		}

		$xml->close_group();
		$xml->print_xml();
	}
	// No AJAX
	else
	{
		$vbulletin->url = fetch_layout_redirect();

		eval(print_standard_redirect(ADV_DYNA_PREFIX . '_layoutsaved'));
	}
}

// ##### Reset Layout #########################################################
if ($_REQUEST['do'] == 'resetlayout')
{
	$db->query_write("
		DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "layout
		WHERE userid = " . $vbulletin->userinfo['userid'] . "
			AND page = 'dyna_" . ($entryid ? 'showentry' : 'browsecategory') . "'
	");

	$vbulletin->url = fetch_layout_redirect();

	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_layoutsaved'));
}

// ##### Do add/edit module ###################################################
if ($_POST['do'] == 'doaddmodule' OR $_POST['do'] == 'doeditmodule')
{
	if ($_POST['do'] == 'doaddmodule' AND !$vba_dyna->check_perms('canaddmodule'))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'wysiwyg' => TYPE_BOOL,
		'message' => TYPE_STR,
		'title' => TYPE_NOHTML,
		'preview' => TYPE_NOHTML,
		'parseurl' => TYPE_INT,
		'modlinkid' => TYPE_INT,
		'modid' => TYPE_INT,
		'disablesmilies' => TYPE_INT
	));

	$vbulletin->GPC['preview'] = (trim($vbulletin->GPC['preview'])) ? true : false;

	if ($_POST['do'] == 'doeditmodule')
	{
		$curmodule = load_user_module();
	}

	$modulecode = '';
	$module_parsed = '';
	$allowsmilie = 0;

	require_once(DIR . '/includes/functions_newpost.php');

	// PHP File Module
	if ($vbulletin->GPC['modid'])
	{
		$mod_options = $vbulletin->adv_dyna_module[$vbulletin->GPC['modid']]['options'];

		($hook = vBulletinHook::fetch_hook('vba_dyna_module_doedit_php')) ? eval($hook) : false;

		require(DIR . '/vba_dyna_modules/edit_' . $curmodule['filename']);
	}
	// BB code module
	else
	{
		require_once(DIR . '/includes/functions_misc.php');

		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		($hook = vBulletinHook::fetch_hook('vba_dyna_module_doedit_bbcode')) ? eval($hook) : false;

		$vbulletin->GPC['message'] = fetch_censored_text($vbulletin->GPC['message']);

		$disablesmilies = (!$vba_options['dyna_allow_module_smilie']) ? 1 : $vbulletin->GPC['disablesmilies'];
		$allowsmilie = ($disablesmilies) ? 0 : 1;

		$module['title'] =& $vbulletin->GPC['title'];
		$module['message'] =& $vbulletin->GPC['message'];

		// WYSIWYG
		if ($vbulletin->GPC['wysiwyg'])
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
		}

		if ($vbulletin->GPC['parseurl'])
		{
			$vbulletin->GPC['message'] = convert_url_to_bbcode($vbulletin->GPC['message']);
		}
	}

	// ##### Errors or previewing, send 'em back
	if ($errors OR $vbulletin->GPC['preview'])
	{
		$title = $vbulletin->GPC['title'];

		if (!$vbulletin->GPC['modid'])
		{
			$message = htmlspecialchars($vbulletin->GPC['message']);
		}

		if ($_POST['do'] == 'doeditmodule')
		{
			$_REQUEST['do'] = 'editmodule';
		}
		else
		{
			$_REQUEST['do'] = 'addmodule';
		}

		// Kill this for modules that use if($_POST['do'] == 'doeditmodule')
		$_POST['do'] = '';

		// Errors
		if ($errors)
		{
			construct_checkboxes($_POST);

			$modulepreview = construct_errors($errors);
			$haderrors = true;
		}
		// Previewing
		else
		{
			$module['parseurl'] = $vbulletin->GPC['parseurl'];
			$module['disablesmilies'] = $vbulletin->GPC['disablesmilies'];
			construct_checkboxes($_POST);

			if ($vbulletin->GPC['modid'])
			{
				$module['code'] = $module_parsed;
				$mods =& $module;

				require(DIR . '/vba_dyna_modules/' . $vbulletin->adv_dyna_module[$vbulletin->GPC['modid']]['filename']);

				$previewmessage = $home[$mods['modid']]['content'];
			}
			else
			{
				$previewmessage = $bbcode_parser->do_parse(
					$vbulletin->GPC['message'],
					0,
					$allowsmilie,
					$vba_options['dyna_allow_module_bbcode'],
					$vba_options['dyna_allow_module_img']
				);
			}

			eval('$modulepreview = "' . fetch_template('newpost_preview')."\";");
		}
	}
	// ##### Everything's good, so get ready to insert or update
	else
	{
		if (!$vbulletin->GPC['modid'])
		{
			// Parse pagetext
			$module_parsed = $bbcode_parser->do_parse(
				$vbulletin->GPC['message'],
				0,
				$allowsmilie,
				$vba_options['dyna_allow_module_bbcode'],
				$vba_options['dyna_allow_module_img']
			);

			$modulecode =& $vbulletin->GPC['message'];
		}

		// ##### Editing a module
		if ($_REQUEST['do'] == 'doeditmodule' AND $curmodule['modlinkid'])
		{
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "modules_user SET
					title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
					code = '" . $db->escape_string($modulecode) . "',
					code_parsed = '" . $db->escape_string($module_parsed) . "',
					allowsmilie = $allowsmilie
				WHERE modlinkid = " . $curmodule['modlinkid']
			);

			$modid = ($vbulletin->GPC['modid']) ? $vbulletin->GPC['modid'] : 'u' . $vbulletin->GPC['modlinkid'];

			$vbulletin->url = fetch_layout_redirect();
			eval(print_standard_redirect(ADV_DYNA_PREFIX . '_module_saved', $vbphrase['module']));
		}
		// ##### New Module
		else
		{
			// Insert the module
			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "modules_user
					(userid, modid, title, code, code_parsed, allowsmilie)
				VALUES (
					" . $vbulletin->userinfo['userid'] . ",
					" . $vbulletin->GPC['modid'] . ",
					'" . $db->escape_string($vbulletin->GPC['title']) . "',
					'" . $db->escape_string($modulecode) . "',
					'" . $db->escape_string($module_parsed) . "',
					$allowsmilie
			)");

			$newmoduleid = $db->insert_id();

			$modid = ($vbulletin->GPC['modid']) ? $vbulletin->GPC['modid'] : 'u' . $newmoduleid;

			$vbulletin->url = fetch_layout_redirect();
			eval(print_standard_redirect(ADV_DYNA_PREFIX . '_addedmodule'));
		}
	}
}

// ##### Main Edit Modules Page ###############################################
if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'editmodule')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'modlinkid' => TYPE_INT,
		'modid' => TYPE_INT,
		'preview' => TYPE_INT
	));

	$modlinkid = $vbulletin->GPC['modlinkid'];
	$modid = $vbulletin->GPC['modid'];

	if (!$vba_dyna->check_perms('canaddmodule'))
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_module_edit')) ? eval($hook) : false;

	// ##### Edit Module
	if ($_REQUEST['do'] == 'editmodule')
	{
		$show['editmodule'] = true;

		$module = load_user_module();

		if (!$vbulletin->GPC['preview'] AND !$haderrors)
		{
			$title = $module['title'];
		}

		$show['phpmodule'] = false;

		// PHP File Module
		if ($module['modid'])
		{
			$show['phpmodule'] = true;
			$mod_options = $vbulletin->adv_dyna_module[$module['modid']]['settings'];

			if ($vbulletin->GPC['preview'] OR $haderrors)
			{
				$module['code'] = $modulecode;
			}

			require(DIR . '/vba_dyna_modules/edit_' . $module['filename']);
		}
		// BB Code Module
		else
		{
			if (!$vbulletin->GPC['preview'] AND !$haderrors)
			{
				$checked['parseurl'] = 'checked="checked"';
				$message = $module['code'];
				$allowsmilie = $module['allowsmilie'];

				if (!$allowsmilie)
				{
					$checked['disablesmilies'] = 'checked="checked"';
				}
			}
		}

		if (!$vbulletin->GPC['preview'] AND !$errors)
		{
			$show['deleteopt'] = true;
		}

		$navbits[''] = construct_phrase($vbphrase['edit_x'], $vbphrase['module']) . ': ' . $module['title'];
	}
	// ##### Add Module
	else
	{
		$checked['parseurl'] = 'checked="checked"';
		$allowsmilie = $vba_options['dyna_allow_module_smilie'];
		$navbits[''] = construct_phrase($vbphrase['create_new_x'], $vbphrase['module']);
	}

	$show['phpmodule'] = false;
	if ($module['inctype'] == 'php_file')
	{
		$show['phpmodule'] = true;
	}
	else
	{
		// ##### Editor
		format_vb_text_editor();

		$vbulletin->options['allowbbimagecode'] = $vba_options['dyna_allow_module_img'];

		// Editor & message area
		$editorid = construct_edit_toolbar(
			$message,
			0,
			0,
			$vba_options['dyna_allow_module_smilie'],
			$allowsmilie
		);

		$selectedicon['src'] = str_replace(
			$vbulletin->options['cleargifurl'],
			$vbulletin->options['bburl'] . '/' . $vbulletin->options['cleargifurl'],
			$selectedicon['src']
		);

	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_ADD_EDIT_MODULE') . '");');
}

// ############################# Delete Entry ##########################
if ($_REQUEST['do'] == 'deletemodule')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'modlinkid' => TYPE_INT
	));

	if (!$vba_dyna->check_perms('canaddmodule'))
	{
		print_no_permission();
	}

	$module = load_user_module();

	$formaction = 'module';
	$dovalue = 'dodeletemodule';
	$itemname = 'modlinkid';
	$itemid =& $vbulletin->GPC['modlinkid'];
	$itemtitle =& $module['title'];
	$titlephrase = construct_phrase($vbphrase['delete_this_x'], $vbphrase['module']);
	$buttonphrase = $vbphrase['delete'];
	$confirmphrase = construct_phrase($vbphrase['delete_x_message'], $vbphrase['module_lwr']);
	$show['check_confirm'] = true;

	$additionalhidden = '';
	if ($entryid)
	{
		$additionalhidden = '<input type="hidden" name="entryid" value="' . $entryid . '" />';
	}
	if ($catid)
	{
		$additionalhidden = '<input type="hidden" name="catid" value="' . $catid . '" />';
	}
	if ($entryuserid)
	{
		$additionalhidden = '<input type="hidden" name="entryuserid" value="' . $entryuserid . '" />';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_module_delete')) ? eval($hook) : false;

	$navbits[''] = $titlephrase;
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');
}

// ##### Do Delete Module #####################################################
if ($_POST['do'] == 'dodeletemodule')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'modlinkid' => TYPE_INT
	));

	if (!$vba_dyna->check_perms('canaddmodule'))
	{
		print_no_permission();
	}

	$module = load_user_module();

	($hook = vBulletinHook::fetch_hook('vba_dyna_module_dodelete')) ? eval($hook) : false;

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user WHERE modlinkid = " . $vbulletin->GPC['modlinkid']);

	$vbulletin->url = fetch_layout_redirect(false);
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_module_deleted'));
}

?>