<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'dyna_showentry');

$specialtemplates = array(
	'adv_dyna_attach',
	'adv_dyna_cfield',
	'adv_dyna_modpos',
	'adv_dyna_module',
	'bbcodecache',
	'iconcache',
	'smiliecache'
);

$globaltemplates = array(
	'ADV_DYNA_SHOWENTRY',
	'adv_dyna_postbit_deleted',
	'adv_dyna_ratingbit',
	'adv_dyna_showentry_attachmentbox',
	'adv_dyna_showentry_attachments',
	'adv_dyna_showentry_custombits',
	'adv_dyna_showentry_keywordbit',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
	'editor_clientscript',
	'editor_jsoptions_font',
	'editor_jsoptions_size',
	'im_aim',
	'im_icq',
	'im_msn',
	'im_skype',
	'im_yahoo',
	'postbit',
	'postbit_ip',
	'postbit_onlinestatus',
	'postbit_reputation',
	'postbit_wrapper',
	'showthread_quickreply'
);

$phrasegroups = array(
	'adv_dyna_moderate',
	'cprofilefield',
	'postbit',
	'posting',
	'showthread'
);

if ($_REQUEST['editmods'])
{
	$phrasegroups[] = 'adv_dyna_modules';
}

require_once('./dyna_global.php');
require_once(DIR . '/includes/functions_bigthree.php');

($hook = vBulletinHook::fetch_hook('vba_dyna_showentry_start')) ? eval($hook) : false;

if (!$vba_options['dyna_buddyentries'])
{
	$entry['private'] = 0;
}

$vba_dyna->check_entry($entry);

$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);

// Per page stuff
if ($vbulletin->userinfo['maxposts'] != -1)
{
	$perpage = $vbulletin->userinfo['maxposts'];
}

if (!intval($perpage))
{
	$perpage = $vba_options['dyna_repliesperpage'];
}

$perpage = intval($perpage);

$show['modopts'] = is_category_mod($entry['catid']);

// Load BBcode parser
require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
$bbcode_parser->unsetattach = true;
$vbulletin->db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET views = views+1 WHERE entryid = $entry[entryid]");

$entry['membercatlink'] = fetch_cat_url(0, array('title' => $entry['username'], 'userid' => $entry['userid']), 'member');

$calendarwhere = 'entry.userid = ' . $entry['userid'];

// ##### Attachments
$attachments = '';
$show['attachments'] = false;
$show['thumbs'] = false;

if ($vba_dyna->check_cat_perms('canviewthumb') AND $entry['hasattach'])
{
	$attachpath = fetch_attach_folder($entry['userid']);

	if ($vba_dyna->check_cat_perms('canviewthumb', $entry))
	{
		$canviewthumbs = true;
	}

	$getattach = $db->query_read("
		SELECT attach.*, attachtype.newwin
		FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attach
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "attachmenttype AS attachtype ON(attach.extension = attachtype.extension)
		WHERE entryid = $entryid
			AND valid = 1
		ORDER BY attachtype.displayorder ASC, attach.dateline ASC
	");
	while ($attach = $db->fetch_array($getattach))
	{
		$attach['shortfilename'] = $attach['filename'];
		$attach['filename'] = $attach['filename'] . '.' . $attach['extension'];
		$attach['hasthumbnail'] = $attach['hasthumb'];
		
		$bbcode_parser->attachments[$attach['attachmentid']] = $attach;
	}

	$db->free_result($getattach);
	unset($attach);

}

// For inline moderation & moving modules without ajax
$dyna_pageurl = $entry['url'];
$dyna_page = THIS_SCRIPT;

$adv_sorturl = construct_adv_sort_url();
$adv_sorturl_nospider = construct_adv_sort_url(array(), true);

// Additional Pages
$epage = $vbulletin->GPC['epage'];
$show['nextpagelink'] = false;
$show['prevpagelink'] = false;

if ($vba_options['dyna_multipage_limit'])
{
	$multipage = array();
	$multipagekeys = array();
	$getmultipages = $db->query_read("
		SELECT title, pagenumber
		FROM " . ADV_DYNA_TABLE_PREFIX . "entries_pages
		WHERE entryid = " . $entryid
	);
	while ($mpages = $db->fetch_array($getmultipages))
	{
		$multipage[$mpages['pagenumber']] = $mpages['title'];
		$multipagekeys[] = $mpages['pagenumber'];
	}

	if ($multipage[$epage])
	{
		$entry['pagetitle'] = $multipage[$epage];
	}

	if (sizeof($multipagekeys) > 1)
	{
		if ($vba_options['dyna_showentry_pagebox'])
		{
			$show['pagesbox'] = true;

			foreach ($multipage AS $mpageid => $mpagetitle)
			{
				if (!$mpagetitle)
				{
					$mpagetitle = construct_phrase($vbphrase['page_x'], $mpageid);
				}

				$mpagelink = $entry['url'];

				if ($vba_options['dyna_spiderurls'])
				{
					$mpagelink .= 'epage' . $mpageid . '.html' . $adv_sorturl;
				}
				else
				{
					$mpagelink .= '&amp;epage=' . $mpageid;
				}

				eval('$pagelinkbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_showentry_pagelinkbits') . '";');
			}
		}

		$epagemax = max($multipagekeys);
		// Next page
		if ($epagemax > $epage)
		{
			$show['nextpagelink'] = true;
			$nextpageid = $epage + 1;
			$nextpagetitle = $multipage[$nextpageid];

			$nextpagelink = $entry['url'];
			if ($vba_options['dyna_spiderurls'])
			{
				$nextpagelink .= 'epage' . $nextpageid . '.html' . $adv_sorturl;
			}
			else
			{
				$nextpagelink .= '&amp;epage=' . $nextpageid;
			}
		}

		// Previous page
		if (min($multipagekeys) < $epage)
		{
			$show['prevpagelink'] = true;
			$prevpageid = $epage - 1;
			$prevpagetitle = $multipage[$prevpageid];

			$prevpagelink = $entry['url'];

			if ($prevpageid != 1)
			{
				if ($vba_options['dyna_spiderurls'])
				{
					$prevpagelink .= 'epage' . $prevpageid . '.html' . $adv_sorturl;
				}
				else
				{
					$prevpagelink .= '&amp;epage=' . $prevpageid;
				}
			}
		}
	}
}

if ($vba_dyna->check_cat_perms('canreport', $entry))
{
	$show['report_button'] = true;
}

// Highlight stuff for search results
if ($searchid)
{
	if (!empty($search))
	{
		$highlight =& $search;
	}
	else
	{
		$highlight = $db->query_first("SELECT string, sfields, wholeword FROM " . ADV_DYNA_TABLE_PREFIX . "search WHERE searchid = '$searchid'");
	}
	$highlight['fields'] = explode(',', $highlight['sfields']);
}

$templatename = 'SHOWENTRY';
$vba_dyna->process_entry_array($entry);

// Process Attachments
if (!empty($bbcode_parser->attachments))
{
	foreach ($bbcode_parser->attachments AS $attachid => $attach)
	{
		$show['attachments'] = true;

		$attach['filename'] = $attach['shortfilename'];
		$attach['convertedfilesize'] = fetch_rfilesize($attach['filesize']);

		if ($attach['userid'] == $entry['userid'])
		{
			$attach['path'] = $attachpath;
		}
		else
		{
			$attach['path'] = fetch_attach_folder($attach['userid']);
		}

		$show['thumbs'] = false;
		if ($canviewthumbs AND $vbulletin->adv_dyna_attach[$attach['extension']]['thumbnail'])
		{
			$show['thumbs'] = true;
		}

		$attach['thumburl'] = fetch_attach_thumb_url($attach);

		$target_blank = $attach['newwin'] ? ' target="_blank"' : '';

		$attach['attachmentextension'] = $attach['extension'];

		($hook = vBulletinHook::fetch_hook('vba_dyna_showentry_attachmentloop')) ? eval($hook) : false;

		eval('$attachments .= "' . fetch_template(ADV_DYNA_PREFIX . '_showentry_attachments') . '";');
	}
}

if ($show['attachments'] AND $vba_options['dyna_attachpos'])
{
	$attachcollapse = $vbcollapse['collapseobj_entry_attachments'];
	$attachimgcollapse = $vbcollapse['collapseimg_entry_attachments'];

	$show['dyna_columns'] = true;
	$show['dyna_' . $vba_options['dyna_attachpos'] . '_column'] = true;
	eval('$home[\'dyna_' . $vba_options['dyna_attachpos'] . 'blocks\'] = "' . fetch_template(ADV_DYNA_PREFIX . '_showentry_attachmentbox') . '";');
}

// Call modules after attachments incase attachments are to be displayed in a column
require_once(DIR . '/includes/vba_dyna_include_modules.php');

if ($vba_options['dyna_allowreplies'] AND $vba_dyna->check_cat_perms('canviewreplies'))
{
	$show['replies'] = true;
}

// IM Icons
if ($vba_options['dyna_showentry_imicons'])
{
	require_once(DIR . '/includes/class_postbit.php');
	construct_im_icons($entry, true);
}

$messageclass = '';
$altmessageclass = exec_switch_bg();

// Custom fields
if (!empty($vbulletin->adv_dyna_cfield))
{
	foreach ($vbulletin->adv_dyna_cfield AS $cfieldid => $field)
	{
		$thisfield = 'field' . $field['fieldid'];
		if (!trim($entry[$thisfield]) OR (!$show['modopts'] AND $field['private']))
		{
			continue;
		}

		if (!check_custom_field_cats($field, $entry))
		{
			continue;
		}

		if ($field['position_display'] == 'below_message' AND !$messageclass)
		{
			$messageclass = exec_switch_bg();
		}

		if (!$field['position_display'])
		{
			$field['position_display'] = 'below_message';
		}

		$field['value'] =& $entry[$thisfield];
		if ($field['type'] == 'multiple_select' OR $field['type'] == 'checkbox')
		{
			$field['value'] = unserialize($field['value']);

			if (empty($field['value']))
			{
				continue;
			}

			if (is_array($field['value']))
			{
				$field['value'] = implode(', ', $field['value']);
			}
		}
		else
		{
			$field['value'] = $bbcode_parser->do_parse(
				unhtmlspecialchars($field['value']),
				cat_opt('allow_custom_html'),
				cat_opt('allow_custom_smilies'),
				cat_opt('allow_custom_bbcode'),
				cat_opt('allow_custom_bbimgcode')
			);
		}

		if ($searchid)
		{
			if (in_array($thisfield, $highlight['fields']))
			{
				$field['value'] = highlight_keywords($entry[$thisfield], $highlight['string'], $highlight['wholeword']);
			}
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_showentry_cfieldloop')) ? eval($hook) : false;

		exec_switch_bg();

		eval('$customfieldbits[$field[\'position_display\']] .= "' . fetch_template(ADV_DYNA_PREFIX . '_showentry_custombits') . '";');

	}
}
$db->free_result($customfields);
unset($field);

// Set for rows below custom fields
if (!$messageclass)
{
	$messageclass = exec_switch_bg();
}

if ($vba_options['dyna_formatmeta_showentry'])
{
	$entry['meta_description'] = fetch_trimmed_title(str_replace("\r\n", ' ', strip_bbcode($entry['pagetext'])), 150);
}

// Keywords
if ($entry['keywords'])
{
	$kwords = explode(',', $entry['keywords']);

	if ($vba_options['dyna_convertkeywords'] AND !empty($kwords))
	{
		$entry['keywords'] = '';
		if (!empty($highlight))
		{
			if (in_array('keywords', $highlight['fields']))
			{
				$highlightkeywords = true;
			}
		}
		foreach ($kwords AS $keyword_nohighlight)
		{
			if ($keywords)
			{
				$comma = ',';
			}

			$keyword = $keyword_nohighlight;

			if ($highlightkeywords)
			{
				$keyword = highlight_keywords($keyword, $highlight['string'], $highlight['wholeword']);
			}

			$keyword_nohighlight = str_replace(' ', '_', $keyword_nohighlight);

			($hook = vBulletinHook::fetch_hook('vba_dyna_showentry_keywordloop')) ? eval($hook) : false;

			eval('$entry[\'keywords\'] .= "$comma ' . fetch_template(ADV_DYNA_PREFIX . '_showentry_keywordbit') . '";');
		}
	}

	if ($vba_options['dyna_formatmeta_showentry'] AND !empty($kwords))
	{
		$entry['meta_keywords'] = implode(', ', array_slice($kwords, 0, 8));
	}
}
else
{
	$entry['keywords'] = $vbphrase['none'];
}

// ##### Meta Tags
if ($vba_options['dyna_formatmeta_showentry'] AND (!$entry['meta_keywords'] OR sizeof($kwords) < 8))
{
	$meta_keywords = preg_replace('/[^A-Za-z0-9 ]/', '', strip_bbcode($entry['pagetext']));
	$meta_keywords = explode(' ', $meta_keywords);

	if (!empty($meta_keywords))
	{
		function check_len($word)
		{
			return (strlen($word) > 4 AND strlen($word) < 15) ? $word : false;
		}

		$meta_keywords = array_filter($meta_keywords, 'check_len');
		$meta_keywords = array_count_values($meta_keywords);
		array_multisort($meta_keywords, SORT_DESC, SORT_NUMERIC);
		$meta_keywords = array_slice(array_keys($meta_keywords), 0, (8 - sizeof($kwords)));

		if (!empty($meta_keywords))
		{
			$entry['meta_keywords'] .= iif($entry['meta_keywords'], ', ') . implode(', ', $meta_keywords);
		}
	}
}

if ($vba_options['dyna_formatmeta_showentry'])
{
	$headinclude = str_replace(
		array(
			'<meta name="keywords" content="' . $vbulletin->options['keywords'] . '" />',
			'<meta name="description" content="' . $vbulletin->options['description'] . '" />'
		),
		array(
			'<meta name="keywords" content="' . $entry['meta_keywords'] . '" />',
			'<meta name="description" content="' . $entry['meta_description'] . '" />'
		),
		$headinclude
	);
}

// Rating
if ($entry['votetotal'])
{
	$show['whoratedentry'] = $vba_dyna->check_cat_perms('canseewhorated');
	$entry['truerating'] = vb_number_format($entry['votetotal'] / $entry['votenum'], 2);
	$entry['roundrating'] = round($entry['truerating']);
	$entry['voteavg'] = vb_number_format($entry['votetotal'] / $entry['votenum'], 2);
}
else
{
	$entry['truerating'] = 0;
}

if (!$entry['open'])
{
	$show['closedbutton'] = true;
}

// Show variables
if ($vba_options['dyna_allowreplies'] AND $vba_dyna->check_cat_perms('canreply') AND cat_user_opt('allow_reply'))
{
	$show['replylink'] = true;
}

if ($vba_options['dyna_allowrating'] AND $vba_dyna->check_cat_perms('canrate', $entry) AND cat_user_opt('allow_rating') AND cat_opt('allow_ratings', $entry['catid']))
{
	$show['rateentry'] = true;
}

if ($vba_dyna->check_cat_perms('cansendtofriend'))
{
	$show['sendtofriend'] = true;
}

if ($vbulletin->userinfo['userid'] AND (($entry['userid'] == $vbulletin->userinfo['userid'] AND $vba_dyna->check_cat_perms('caneditentries')) OR $vba_dyna->check_cat_perms('caneditothers') OR $show['modopts']))
{
	$show['editentry'] = true;
}

if ($vba_dyna->check_cat_perms('cansetfeatured'))
{
	$show['feature_entry'] = true;

	if (in_array($entryid, $vbulletin->adv_dyna_featur))
	{
		$entry['featured'] = 1;
	}
}

// Signature
if ($entry['signature'])
{
	if ($entry['signatureparsed'])
	{
		$entry['signature'] = $entry['signatureparsed'];
	}
	else
	{
		$entry['signature'] = $bbcode_parser->parse($entry['signature'], 0, $vbulletin->options['allowsmilies']);
	}
}

// ######################### Replies to Entry #############################
$ajax_lastpostdate = 0;
if ($vba_options['dyna_allowreplies'] AND $vba_dyna->check_cat_perms('canviewreplies'))
{
	// Kill the spacing for the postbits
	if ($show['dyna_columns'])
	{
		$spacer_open = '';
		$spacer_close = '';
	}

	$querydeleted = ($show['modopts'] OR $vba_dyna->check_cat_perms('canviewdeleted')) ? true : false;

	$visiblecond = ($querydeleted) ? '1,2' : 1;

	// Setup hooks to allow for vB thread integration
	$posttable = ADV_DYNA_PREFIX . '_posts AS posts';
	$postwhere = 'entryid = ' . $entryid . ' AND posts.visible IN(' . $visiblecond . ')';

	($hook = vBulletinHook::fetch_hook('vba_dyna_showentry_repliesstart')) ? eval($hook) : false;

	if ($epostid AND !$pagenumber)
	{
		$getpost = $db->query_first("SELECT dateline FROM " . TABLE_PREFIX . $posttable . " WHERE postid = $epostid");

		$olderposts = $db->query_first("
			SELECT COUNT(*) AS count
			FROM " . TABLE_PREFIX . $posttable . "
			WHERE $postwhere
				" . iif($getpost['dateline'], "AND dateline < $getpost[dateline]")
		);
		$_REQUEST['page'] = ceil(($olderposts['count'] + 1) / $perpage);
	}

	$replypagedata = fetch_page_data(
		$posttable,
		array($postwhere),
		'',
		$perpage
	);

	// We have replies
	if ($replypagedata['count'])
	{
		$show['postheader'] = true;
		$show['reputationlink'] = false;

		if ($vba_options['dyna_showquickreply'] AND $show['replylink'] AND $entry['open'])
		{
			$SHOWQUICKREPLY = true;
		}

		$show['inlinemod'] = ($show['modopts'] ? true : false);

		replace_page_nav_links();

		$pagenav = construct_page_nav(
			$replypagedata['pagenumber'],
			$perpage,
			$replypagedata['count'],
			$entry['url'],
			construct_adv_sort_url(array('page'))
		);

		require_once(DIR . '/includes/vba_dyna_functions_posting.php');

		postbit_template_replace();

		$queryfields = '';
		$queryjoin = '';

		fetch_post_query_fields();

		// Deleted posts
		if ($querydeleted)
		{
			$queryfields .= ', dellog.dateline AS del_dateline, dellog.userid AS del_userid, dellog.username AS del_username, reason';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog AS dellog ON (posts.postid = dellog.deletedid AND dellog.type = \'post\')';
		}

		$postcount = ($replypagedata['pagenumber'] - 1) * $perpage;
		$show['postcount'] = true;

		require_once(DIR . '/includes/class_postbit.php');

		// kill postid here since it's used in the postbit template
		unset($postid);

		$highlightposts = false;
		if ($searchid)
		{
			if (in_array('pagetext', $highlight['fields']))
			{
				$highlightposts = true;
			}
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_showentry_repliesquery')) ? eval($hook) : false;

		$ranks_replaced = array();
		$sig_cache = array();

		$posts = $db->query("
			SELECT $queryfields
			FROM " . TABLE_PREFIX . $posttable . "
			$queryjoin
			WHERE $postwhere
			ORDER BY posts.dateline " . ($vba_options['dyna_reply_orderby'] ? 'DESC' : 'ASC') . "
			LIMIT " . ($replypagedata['minlimit'] - 1) . ", $replypagedata[perpage]
		");
		while ($post = $db->fetch_array($posts))
		{
			$postbit .= fetch_dyna_postbit($post);

			$ajax_lastpostdate = $post['dateline'];
		}

		$db->free_result($posts);
	}
}

unset($post);

if ($vba_options['dyna_showquickreply'] AND $show['replylink'] AND $entry['open'] AND $vbulletin->userinfo['userid'])
{
	require_once(DIR . '/includes/functions_editor.php');

	$vbulletin->options['allowbbimagecode'] = (cat_opt('allow_post_bbimgcode') ? 1 : 0);

	if ($vba_options['dyna_quickreply_width'])
	{
		$stylevar['messagewidth'] = $vba_options['dyna_quickreply_width'];
	}

	$show['quickreply'] = true;
	$show['wysiwyg'] = (cat_opt('allow_post_bbcode') ? is_wysiwyg_compatible() : 0);
	$istyles_js = construct_editor_styles_js();
	$editorid = construct_edit_toolbar('', false, 0, (cat_opt('allow_post_bbcode') ? 1 : 0), 1, false, 'qr');
	$threadedmode = 0;
	$qrpostid = 'who cares';
	$QRrequireclick = 0;

	$vbulletin->templatecache['editor_clientscript'] = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['editor_clientscript']);

	$vBeditJs = construct_editor_js_arrays();
	eval('$vBeditTemplate[\'clientscript\'] = "' . fetch_template('editor_clientscript') . '";');

	$headinclude .= '
		<!-- set up CSS for the editor -->
		<link rel="stylesheet" type="text/css" href="' . $vbulletin->options['bburl'] . '/clientscript/vbulletin_editor.css" />
		<style type="text/css">
		<!--
		#vBulletin_editor {
			background: ' . $istyles['pi_button_normal'][0] . ';
			padding: ' . $stylevar['cellpadding'] . 'px;
		}
		#controlbar, .controlbar {
			background: ' . $istyles['pi_button_normal'][0] . ';
		}
		.imagebutton {
			background: ' . $istyles['pi_button_normal'][0] . ';
			color: ' . $istyles['pi_button_normal'][1] . ';
			padding: ' . $istyles['pi_button_normal'][2] . ';
			border: ' . $istyles['pi_button_normal'][3] . ';
		}
		-->
		</style>
	';

	unset($threadid);

	($hook = vBulletinHook::fetch_hook('vba_dyna_showentry_quickreply')) ? eval($hook) : false;

	eval('$quickreply = "' . fetch_template('showthread_quickreply') . '";');

	$showajax = 0;
	if ($replypagedata['pagecount'] == $replypagedata['pagenumber'])
	{
		$showajax = 1;
	}

	$messagearea = "
		<script type=\"text/javascript\">
		<!--
			var threaded_mode = $threadedmode;
			var require_click = 0;
			var is_last_page = $showajax;
			var allow_ajax_qr = $showajax;
			var ajax_last_post = $ajax_lastpostdate;
		// -->
		</script>
		$messagearea
	";

}
$categoryjump = print_category_jump($entry['catid']);

$browseurl = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'do=';

switch($catid)
{
	case 'favorites':
		$navbits[$browseurl . 'favorites'] = $vbphrase['my_favorites'];
	break;

	case 'subscriptions':
		$navbits[$browseurl . 'subscriptions'] = $vbphrase['my_subscriptions'];
	break;

	case 'newentries':
		$navbits[$browseurl . 'newentries'] = $vbphrase['whats_new'];
	break;

	case 'popentries':
		$navbits[$browseurl . 'popentries'] = $vbphrase['whats_popular'];
	break;

	default:
		$entryusername = $entry['username'];
		$navbits = fetch_cat_navbits($entry['catid']);
}

$navbits[''] = $entry['title'];

$entry['title_nohighlight'] = $entry['title'];

// Highlight title / pagetext (keep this at the end so no unnecessary parts are highlighted
if (!empty($highlight))
{
	if (in_array('title', $highlight['fields']))
	{
		$entry['title'] = highlight_keywords($entry['title'], $highlight['string'], $highlight['wholeword']);
	}

	if (in_array('pagetext', $highlight['fields']))
	{
		$entry['pagetext_parsed'] = highlight_keywords($entry['pagetext_parsed'], $highlight['string'], $highlight['wholeword']);
	}
}

$show['editmodslink'] = false;
if ($vbulletin->userinfo['userid']
	AND $vba_options['dyna_enablemodules']
	AND $vba_dyna->_permissions['canmodule']
	AND ($entryuserid == $vbulletin->userinfo['userid']
		OR $vbulletin->adv_dyna_cats[$catid]['catuserid'] == $vbulletin->userinfo['userid']
	)
)
{
	$show['editmodslink'] = true;
}

$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');

eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_SHOWENTRY') . '");');

?>