<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$specialtemplates = array(
	'adv_dyna_cats',
	'adv_dyna_mods'
);

$phrasegroups = array(
	'adv_dyna_cp_cats',
	'adv_dyna_managecats'
);

require_once('./vba_dyna_admin_global.php');

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'managecats';
}

($hook = vBulletinHook::fetch_hook('vba_dyna_cp_categories_start')) ? eval($hook) : false;

// ############################# Manage Categories #########################
if ($_REQUEST['do'] == 'managecats')
{
	$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_INT);

	?>
	<script type="text/javascript">
	function js_dir_jump(catid)
	{
		action = eval("document.cpform.c" + catid + ".options[document.cpform.c" + catid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				page = 'vba_dyna_admin_categories.php?do=editcat&catid=';
			break;
			case 'remove':
				page = 'vba_dyna_admin_categories.php?do=deletecat&catid=';
			break;
			case 'addsub':
				page = 'vba_dyna_admin_categories.php?do=addcat&parentid=';
			break;
			case 'view':
				page = '<?php echo $vba_options['dyna_homeurl']; ?>/browsecategory.php?catid=';
			break;
			case 'empty':
				page = 'vba_dyna_admin_categories.php?do=emptycat&catid=';
			break;
			case 'subcatsetting':
				page = 'vba_dyna_admin_categories.php?do=subcatopts&catid=';
			break;
			case 'addmod':
				page = 'vba_dyna_admin_categories.php?do=addmoderator&catid=';
			break;
		}
		document.cpform.reset();

		window.location = page + catid + "&s=<?php echo $vbulletin->session->vars['sessionhash'] . ADV_URL_PREFIX_HR; ?>";
	}

	function js_mod_jump(catid)
	{
		modid = eval("document.cpform.m" + catid + ".options[document.cpform.m" + catid + ".selectedIndex].value");
		document.cpform.reset();
		switch (modid)
		{
			case 'addmod':
				window.location = "vba_dyna_admin_categories.php?s=<?php echo $vbulletin->session->vars['sessionhash'] . ADV_URL_PREFIX_HR ?>&do=addmoderator&catid=" + catid;
			break;
			default:

				window.location = "vba_dyna_admin_categories.php?s=<?php echo $vbulletin->session->vars['sessionhash'] . ADV_URL_PREFIX_HR ?>&do=editmoderator&modid=" + modid + "&catid=" + catid;
			break;
		}
	}

	</script>

	<?php

	$diroptions = array(
		'edit' => construct_phrase($vbphrase['edit_x'], $vbphrase['category']),
		'view' => construct_phrase($vbphrase['view_x'], $vbphrase['category']),
		'empty' => construct_phrase($vbphrase['empty_x'], $vbphrase['category']),
		'remove' => construct_phrase($vbphrase['delete_x'], $vbphrase['category']),
		'addsub' => construct_phrase($vbphrase['add_sub_x'], $vbphrase['category']),
		'subcatsetting' => $vbphrase['member_sub_cat_settings'],
		'addmod' => $vbphrase['add_moderator']
	);

	print_dyna_form_header('vba_dyna_admin_categories', 'doorder');
	print_table_header(construct_phrase($vbphrase['modify_x_y'], $vbphrase['entries'], $vbphrase['categories']), 4);

	if ($vba_options['dyna_catsorder'] == 'title')
	{
		print_description_row($vbphrase['please_note_categories_ordered_by_title'], '', 4);
	}

	print_cells_row(array($vbphrase['title'], $vbphrase['controls'], $vbphrase['display_order'], $vbphrase['moderator']), 1, 'tcat');

	$catinfo = array();
	$hassubs = array();
	$getcats = $db->query_read("
		SELECT catid, title, parent, parentlist, catuserid, hasentries, displayorder, active, valid, username
		FROM " . ADV_DYNA_TABLE_PREFIX . "categories AS categories
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
		ORDER BY $vba_options[dyna_catsorder] $vba_options[dyna_catsdir], hasentries
	");
	while ($categories = $db->fetch_array($getcats))
	{
		$catinfo[$categories['catid']] = $categories;
		$hassubs[$categories['parent']] = true;
	}

	$db->free_result($getcats);
	unset($categories);

	// Get Moderator Info
	$catmods = array();
	$mods = $db->query("
		SELECT user.userid, user.username, moderator.catid
		FROM " . ADV_DYNA_TABLE_PREFIX . "moderator AS moderator
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (moderator.userid = user.userid)
	");
	while ($lmods = $db->fetch_array($mods))
	{
		$lmods['musername'] = fetch_musername($lmods);
		$catmods[$lmods['catid']][$lmods['userid']] = $lmods;
	}

	$db->free_result($mods);
	unset($lmods);

	// Construct the categories
	$catinfo = construct_categories($catinfo, 0, -1);
	if (!empty($catinfo))
	{

		if ($catid)
		{
			$maxlevel = $catinfo[$catid]['level'] + 1;
			$parentcheck = explode(',', $catinfo[$catid]['parentlist']);
			$parentid = $catinfo[$catid]['parent'];
			$childcats = fetch_category_children($catid);
		}

		foreach ($catinfo as $cats)
		{
			if ($catid AND $cats['catid'] == $catid)
			{
				$currentparent = true;
			}
			if ($currentparent AND $cats['level'] >= ($maxlevel - 1))
			{
				$currentparent = false;
			}

			// Expand options
			if ($vba_options['dyna_admincatcollapse'] AND $cats['level'] > 1)
			{
				// Just check catid/level first to avoid explode() and in_array()
				if (!$catid OR $cats['level'] > $maxlevel)
				{
					continue;
				}
				else if (!in_array($cats['catid'], $childcats) AND $cats['level'] >= ($maxlevel - 1) AND !$currentparent AND !in_array($cats['parent'], $parentcheck))
				{
					continue;
				}
			}

			// +/- links
			if ($catid)
			{
				if (in_array($cats['catid'], $parentcheck))
				{
					$cats['isparent'] = true;
				}
			}

			// ##### Moderators
			if ($catmods[$cats['catid']])
			{
				$modcounts = 0;
				foreach($catmods[$cats['catid']] AS $moderator)
				{
					$modcounts++;
					$modopts[$cats['catid']] .= '<option value="' . $moderator['userid'] . '"> &nbsp; ' . $moderator['username'] . '</option>';
					$modcount[$cats['catid']] = $modcounts;
				}
			}

			$expandit = '';

			if ($vba_options['dyna_admincatcollapse'])
			{
				if ($catid == $cats['catid'] OR $cats['isparent'])
				{
					$expandit = '[-]';
				}
				else if ($hassubs[$cats['catid']])
				{
					$expandit = '[<a href="vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . 'catid=' . $cats['catid'] . ADV_URL_PREFIX . '">+</a>]';
				}
				else
				{
					$expandit = '&nbsp;&nbsp;&nbsp;&nbsp;';
				}
			}

			$catuser = '';
			if($cats['catuserid'])
			{
				$catuser = '<div>' . str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;', ($cats['level'] - 1)) . '&nbsp;' . iif($expandit, '&nbsp;&nbsp;&nbsp;&nbsp;') . '(<a href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $cats['catuserid'] . '" class="smallfont">' . $cats['username'] . '</a>)</div>';
			}

			$cell = array();

			$cell[] = $expandit . '<strong>' . str_repeat('- - ', ($cats['level'] - 1)) . ' <a href="vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editcat&amp;catid=' . $cats['catid'] . ADV_URL_PREFIX . '">' . $cats['title'] . '</a></strong>'
				. iif(!$cats['valid'], ' <span class="smallfont" style="color: yellow">(' . $vbphrase['awaiting_moderation'] . ')</span>')
				. iif(!$cats['active'], ' <span class="smallfont" style="color: yellow">(' . $vbphrase['inactive'] . ')</span> ')
				. $catuser;

			$cell[] = '<select name="c' . $cats['catid'] . '" onchange="js_dir_jump(' . $cats['catid'] . ');" class="bginput" tabindex="1" >' . construct_select_options($diroptions) . '</select><input class="button" type="button" value="' . $vbphrase['go'] . '" onclick="js_dir_jump(' . $cats['catid'] . ');" />';

			$cell[] = '<input type="text" class="bginput" name="order[' . $cats['catid'] . ']" size="3" title="' . $vbphrase['edit_display_order'] . '" value="' . $cats['displayorder'] . '" tabindex="1" />';

			$cell[] = '<select class="bginput" name="m' . $cats['catid'] . '" onchange="js_mod_jump(' . $cats['catid']  . ');" tabindex="1"><option value="0">' . $vbphrase['moderators'] . ' (' . vb_number_format($modcount[$cats['catid']]) . ')</option>' . $modopts[$cats['catid']] . '<option value="addmod">' . $vbphrase['add_moderator'] . '</option></select><input class="button" onclick="js_mod_jump(' . $cats['catid'] . ');" type="button" value="' . $vbphrase['go'] . '" />';

			print_cells_row($cell);

		}
		unset($catinfo, $moderator, $catmods);
	}
	print_submit_row($vbphrase['update_order'], $vbphrase['reset'], 4);
}

// ####################### Re-Order Categories #########################
if ($_POST['do'] == 'doorder')
{
  foreach ($_POST['order'] AS $catid => $disorder)
  {
  	$catid = intval($catid);
  	$disorder = intval($disorder);

		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET displayorder = $disorder WHERE catid = $catid");
  }

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
	update_category_cache();

	define('CP_REDIRECT', 'vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_Q);
	print_stop_message('saved_display_order_successfully');
}

// ############################# Add / Edit Category #########################
if ($_REQUEST['do'] == 'addcat' OR $_REQUEST['do'] == 'editcat' OR $_REQUEST['do'] == 'copycat')
{
	$catid = intval($_REQUEST['catid']);
	$parentid = intval($_REQUEST['parentid']);

	// Create category based on
	if ($_REQUEST['do'] != 'editcat')
	{
		print_dyna_form_header('vba_dyna_admin_categories', 'copycat');
		print_description_row('<strong>' . construct_phrase($vbphrase['create_x_based_off_of_x'] . ': </strong>', $vbphrase['category']) .
			'<select name="catid" tabindex="99">
				<option value="0">' . $vbphrase['none'] . '</option>
				<option value="0">--------------------</option>' .
				print_cat_select($catid, 'admin') .
			'</select> <input class="button" type="submit" value="' . $vbphrase['go'] . '" />',
			0, 2, 'tfoot', 'center'
		);
		print_table_footer();
	}

	print_dyna_form_header('vba_dyna_admin_categories', 'do' . iif($_REQUEST['do'] == 'editcat', 'editcat', 'addcat'), true);

	// Grab the cat info if editing or copying
	if ($_REQUEST['do'] == 'editcat' OR $_REQUEST['do'] == 'copycat')
	{
		$cat = $db->query_first("
			SELECT categories.*, user.username
			FROM " . ADV_DYNA_TABLE_PREFIX . "categories AS categories
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
			WHERE catid = '$catid'
		");

		$options = convert_bits_to_array($cat['options'], $vba_dyna->_categoryopts);
		$useropts = convert_bits_to_array($cat['useroptions'], $vba_dyna->_catuseropts);
	}

	// Edit category
	if ($_REQUEST['do'] == 'editcat')
	{
		$headertitle = construct_phrase($vbphrase['edit_x'], $vbphrase['category']) . ' - ' . $cat['title'] . ' (' . $vbphrase['id'] . ': ' . $cat['catid'] . ')';

		construct_hidden_code('catinfo[catid]', $cat['catid']);
	}
	// Adding (or copying)
	else
	{
		$headertitle = construct_phrase($vbphrase['add_x'], $vbphrase['category']);

		// Default settings
		if ($_REQUEST['do'] != 'copycat')
		{
			$cat['parent'] = $parentid;
			$cat['hasentries'] = 1;
			$cat['active'] = 1;
			$cat['valid'] = 1;
			$options = array(
				'open_for_entries' => 1,
				'open_for_posts' => 1,
				'allow_entry_html' => 0,
				'allow_entry_bbcode' => 1,
				'allow_entry_bbimgcode' => 0,
				'allow_entry_smilies' => 1,
				'allow_entry_icons' => 1,
				'allow_custom_html' => 0,
				'allow_custom_bbcode' => 1,
				'allow_custom_bbimgcode' => 1,
				'allow_custom_smilies' => 1,
				'allow_post_html' => 0,
				'allow_post_bbcode' => 1,
				'allow_post_bbimgcode' => 1,
				'allow_post_smilies' => 1,
				'allow_post_icons' => 1,
				'allow_replies' => 1,
				'allow_ratings' => 1,
				'allow_custom_entries' => 1,
				'canhavepassword' => 1
			);
		}
	}

	if ($cat['catuserid'])
	{
		$cat['title'] = unhtmlspecialchars($cat['title']);
		$cat['description'] = unhtmlspecialchars($cat['description']);
	}

	print_category_options();
}

// ############################# Do Add / Edit Cat #########################
if ($_POST['do'] == 'doeditcat' OR $_POST['do'] == 'doaddcat')
{
	$catinfo = $vbulletin->input->clean_gpc('p', 'catinfo', TYPE_ARRAY);
	$options = $vbulletin->input->clean_gpc('p', 'options', TYPE_ARRAY);
	$useropts = $vbulletin->input->clean_gpc('p', 'useropts', TYPE_ARRAY);
	$oldparentid = $vbulletin->input->clean_gpc('p', 'oldparentid', TYPE_INT);
	$caticon = $vbulletin->input->clean_gpc('f', 'caticon_upload', TYPE_FILE);
	$delcaticon = $vbulletin->input->clean_gpc('p', 'delcaticon', TYPE_INT);

	$catinfo['title'] = trim($catinfo['title']);

	if (!$catinfo['title'])
	{
		print_stop_message(ADV_DYNA_PREFIX . '_cant_have_category_without_title');
	}

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	$catinfo['catuserid'] = '';

	// Category has an owner
	if ($catinfo['catusername'])
	{
		$catuser = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($catinfo['catusername']) . "'");
		$catinfo['catuserid'] = $catuser['userid'];
		if (!$catuser['userid'])
		{
			print_stop_message('invalid_user_specified');
		}
	}
	unset($catinfo['catusername']);

	// Run htmlspecialchars() if it's a user owned category,
	// since HTML is not allowed in these
	if ($catinfo['catuserid'])
	{
		$catinfo['title'] = htmlspecialchars($catinfo['title']);
		$catinfo['description'] = htmlspecialchars($catinfo['description']);
	}

	// Options
	require_once(DIR . '/includes/functions_misc.php');

	$catinfo['options'] = convert_array_to_bits($options, $vba_dyna->_categoryopts);
	$catinfo['useroptions'] = convert_array_to_bits($useropts, $vba_dyna->_catuseropts);

	// Delete cat icon
	if ($delcaticon)
	{
		$iconname = $vbulletin->adv_dyna_cats[$catinfo['catid']]['caticon'];
		if ($iconname)
		{
			@unlink($vba_options['dyna_caticon_path'] . '/' . $iconname);

			if ($iconname == $catinfo['caticon'])
			{
				$catinfo['caticon'] = '';
			}
		}
	}

	// Uploading new cat icon
	if ($caticon['tmp_name'])
	{
		if (!is_writable($vba_options['dyna_caticon_path']))
		{
			print_stop_message(ADV_DYNA_PREFIX . '_caticon_dir_notwritable');
		}

		@move_uploaded_file($caticon['tmp_name'], $vba_options['dyna_caticon_path'] . '/' . $caticon['name']);

		$catinfo['caticon'] = $caticon['name'];
	}

	// ##### Add category
	if ($_POST['do'] == 'doaddcat')
	{
		$db->query_write(fetch_query_sql($catinfo, ADV_DYNA_PREFIX . '_categories'));

		$newcatid = $db->insert_id();

		insert_category_parentlist($catinfo['parent']);

		// Update the custom fields cache to add this category
		build_dyna_cfield_datastore();
	}
	// ###### Edit category
	else
	{
		if ($catinfo['parent'] == $catinfo['catid'])
		{
			print_stop_message(ADV_DYNA_PREFIX . '_cant_parent_category_to_self');
		}

		$oldcat = $db->query_first("SELECT catuserid, parent FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = $catinfo[catid]");

		$db->query_write(fetch_query_sql($catinfo, ADV_DYNA_PREFIX . '_categories', 'WHERE catid = ' . $catinfo['catid']));

		if ($catinfo['catuserid'] != $oldcat['catuserid'])
		{
			if ($oldcat['catuserid'])
			{
				$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "moderator WHERE catid = $catinfo[catid] AND userid = $oldcat[catuserid]");
			}
			if ($catinfo['catuserid'])
			{
				$vba_dyna->default_permissions(explode(',', $catinfo['usergroups']));

				if ($vba_dyna->check_perms('cancatmoderate'))
				{
					$db->query_write("
						INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "moderator
							(userid, catid)
						VALUES (
							" . $vbulletin->userinfo['userid'] . ",
							$newcatid)
					");
				}
			}

			update_dyna_moderator_cache();
		}

		if ($oldcat['parent'] != $catinfo['parent'])
		{
			rebuild_parents($catinfo['catid']);

			// Changing the parent could affect the custom fields cache
			build_dyna_cfield_datastore();
		}
	}

	update_category_cache();

	print_cp_redirect('vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_Q, 0);
}

// ##### User Sub-Category Options ############################################
if ($_REQUEST['do'] == 'subcatopts')
{
	$catid = intval($_REQUEST['catid']);

	?>
	<script type="text/javascript">
	<!--
	function js_set_custom()
	{
		if (document.cpform.usecustom[1].checked == false)
		{
			if (confirm("<?php echo $vbphrase['for_setting_to_have_effect_custom_settings_must_be_enabled']; ?>"))
			{
				document.cpform.usecustom[1].checked = true;
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return true;
		}
	}
	// -->
	</script>
	<?php

	print_dyna_form_header('vba_dyna_admin_categories', 'savesubcatopts');

	// Grab the cat info
	$cat = $db->query_first("
		SELECT categories.*, user.username
		FROM " . ADV_DYNA_TABLE_PREFIX . "categories AS categories
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
		WHERE catid = '$catid'
	");

	$cat['subcatopts'] = unserialize($cat['subcatopts']);

	// Cat has specific settings
	if (!empty($cat['subcatopts']))
	{
		$hassubopts = true;

		$cat['options'] =& $cat['subcatopts']['options'];
		$cat = array_merge($cat, $cat['subcatopts']['catinfo']);
	}

	$options = convert_bits_to_array($cat['options'], $vba_dyna->_categoryopts);
	$useropts = convert_bits_to_array($cat['useroptions'], $vba_dyna->_catuseropts);

	construct_hidden_code('catid', $cat['catid']);
	construct_hidden_code('closewin', intval($_REQUEST['cw']));

	print_table_header($vbphrase['edit_default_settings_for_sub_cats'] . ': ' . $cat['title']);
	print_description_row('
		<input ' . iif(!$hassubopts, ' checked="checked"') . ' id="usecustom_0" name="usecustom" onclick="this.form.reset(); this.checked=true;" type="radio" value="0" /><label for="usecustom_0">' . $vbphrase['use_default_settings_note_delete_previous_settings_set'] . '</label>
		<br />
		<input id="usecustom_1" ' . iif($hassubopts, ' checked="checked"') . ' name="usecustom" type="radio" value="1" /><label for="usecustom_1">' . $vbphrase['use_custom_settings'] . '</label>
	', 0, 2, 'tfoot', '' , 'mode');
	print_table_break();
	print_table_break();

	print_table_header($vbphrase['subcat_default_settings']);
	print_category_options(true);
}

// ##### Save User Sub-Category Options #######################################
if ($_POST['do'] == 'savesubcatopts')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'catinfo' => TYPE_ARRAY,
		'options' => TYPE_ARRAY,
		'usecustom' => TYPE_INT
	));

	if ($vbulletin->GPC['usecustom'])
	{
		require_once(DIR . '/includes/functions_misc.php');

		$options['catinfo'] =& $vbulletin->GPC['catinfo'];
		$options['options'] =& $vbulletin->GPC['options'];

		$options['options'] = convert_array_to_bits($options['options'], $vba_dyna->_categoryopts);
	}
	else
	{
		$options = array();
	}

	$db->query_write("
		UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
			subcatopts = '" . $db->escape_string(serialize($options)) . "'
		WHERE catid = " . $vbulletin->GPC['catid']
	);

	if ($_POST['closewin'])
	{
		print_cp_redirect('vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . 'do=closewin' . ADV_URL_PREFIX, 0);
	}
	else
	{
		print_cp_redirect('vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_Q, 0);
	}
}

// ############################# Delete Category #########################
if ($_REQUEST['do'] == 'deletecat')
{
	$catid = intval($_REQUEST['catid']);

	print_dyna_form_header('vba_dyna_admin_categories', 'dodeletecat');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_category'], $vbphrase['entries_lwr']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Category #########################
if ($_POST['do'] == 'dodeletecat')
{
	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	$catids = fetch_category_children(intval($_POST['catid']));

	$catids = implode(',', $catids);

	remove_entries_in_cat($catids);

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid IN ($catids)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats WHERE catid IN ($catids)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "subscribecat WHERE catid IN ($catids)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "moderator WHERE catid IN ($catids)");

	update_category_cache();

	// Update the custom fields cache to remove this category
	build_dyna_cfield_datastore();

	print_cp_redirect('vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_Q, 0);

}

// ############################# Empty Category #########################
if ($_REQUEST['do'] == 'emptycat')
{
	$catid = intval($_REQUEST['catid']);

	print_dyna_form_header('vba_dyna_admin_categories', 'doemptycat');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion'] . ': <strong>' . $vbulletin->adv_dyna_cats[$catid]['title'] . '</strong>');

	$subcatbits = '';

	$catarray = fetch_category_children($catid);

	if (sizeof($catarray) > 1)
	{
		$subcatbits .= '<div><input type="checkbox" name="subcats" id="subcats" value="1" /><label for="subcats">' . $vbphrase['also_empty_sub_cats'] . '</div>';
		foreach ($catarray AS $subcat)
		{
			$subcatbits .= '<div>' . construct_depth_mark($vbulletin->adv_dyna_cats[$subcat]['level'], '--') . $vbulletin->adv_dyna_cats[$subcat]['title'] . '</div>';
		}
	}

	print_description_row(construct_phrase($vbphrase['are_you_sure_empty_category'] . $subcatbits, $vbphrase['entries_lwr']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Empty Category #########################
if ($_POST['do'] == 'doemptycat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'subcats' => TYPE_INT
	));

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	$catids = array();
	if ($vbulletin->GPC['subcats'])
	{
		$catids = fetch_category_children($vbulletin->GPC['catid']);

		foreach ($catids AS $cat)
		{
			remove_entries_in_cat($cat);
		}

		$catids_str = implode(', ', $catids);
	}
	else
	{
		$catids_str = $vbulletin->GPC['catid'];
		remove_entries_in_cat($vbulletin->GPC['catid']);
	}

	$db->query_write("
		UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
			entrycount = 0,
			postcount = 0,
			lastentryid = 0,
			lastentrytitle = '',
			lastentryusername = '',
			lastentryuserid = 0,
			lastentrydateline = 0,
			lastpostid = 0,
			lastpostentrytitle = '',
			lastpostusername = '',
			lastpostuserid = 0,
			lastpostdateline = 0
		WHERE catid IN($catids_str)
	");

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats WHERE catid IN($catids_str)");

	print_cp_redirect('vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_Q, 0);
}

// ############################# Add Moderator #########################
if ($_REQUEST['do'] == 'addmoderator')
{
	$catid = intval($_REQUEST['catid']);

	$cat = $db->query_first("SELECT catid, title FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = $catid");
	print_dyna_form_header('vba_dyna_admin_categories', 'doaddmod');
	print_table_header($vbphrase['add_moderator'] . ': ' . $cat['title']);
	construct_hidden_code('catid', $cat['catid']);
	construct_hidden_code('cattitle', $cat['title']);
	print_description_row(construct_phrase($vbphrase['add_moderator_note_permissions'], $vbphrase['entries_lwr']));
	print_input_row($vbphrase['username']. ':', 'username');
	print_submit_row();
}

// ############################# Do Add Moderator #########################
if ($_POST['do'] == 'doaddmod')
{
	$catid = intval($_POST['catid']);
	$username = htmlspecialchars($_POST['username']);

	$user = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($username) . "'");

	if (!$user['userid'])
	{
		print_stop_message('invalid_username_specified');
	}

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	$ismod = $db->query_first("SELECT userid FROM " . ADV_DYNA_TABLE_PREFIX . "moderator WHERE userid = $user[userid] AND catid = $catid");

	if ($ismod['userid'])
	{
		print_stop_message('user_is_already_mod');
	}

	$db->query_write("
		INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "moderator
			(userid, catid)
		VALUES (
			$user[userid],
			$catid
	)");

	update_dyna_moderator_cache();

	print_cp_redirect('vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_Q, 0);

}

// ############################ Edit Moderator ###########################
if ($_REQUEST['do'] == 'editmoderator')
{
	$catid = intval($_REQUEST['catid']);
	$modid = intval($_REQUEST['modid']);

	$moderator = $db->query_first("
		SELECT moderator.userid, user.username, moderator.catid, categories.title
		FROM " . ADV_DYNA_TABLE_PREFIX . "moderator AS moderator
		INNER JOIN " . ADV_DYNA_TABLE_PREFIX . "categories AS categories ON (moderator.catid = categories.catid)
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (moderator.userid = user.userid)
		WHERE moderator.userid = $modid AND moderator.catid = $catid
	");

	if (!$moderator['userid'])
	{
		print_stop_message('invalid_user_specified');
	}

	print_dyna_form_header('vba_dyna_admin_categories', 'deletemod');
	construct_hidden_code('userid', $moderator['userid']);
	construct_hidden_code('catid', $moderator['catid']);
	print_table_header(construct_phrase($vbphrase['remove_x_from_moderating_y'], $moderator['username'], $moderator['title']));
	print_description_row(construct_phrase($vbphrase['do_you_wish_to_remove_x_from_moderating_y'], $moderator['username'], $moderator['title']));

	print_submit_row();
}

// ##### Do Edit Moderator ####################################################
if ($_POST['do'] == 'deletemod')
{
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "moderator WHERE userid = " . intval($_POST['userid']) . " AND catid = " . intval($_POST['catid']));

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	update_dyna_moderator_cache();

	print_cp_redirect('vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_Q, 0);
}

// ##### JavaScript Close #####################################################
if ($_REQUEST['do'] == 'closewin')
{
	?>
	<html>
	<head>
	</head>
	<body>
	<script type="text/javascript">
	  window.close();
	</script>
	</body>
	</html>
	<?php
}

print_cp_footer();

?>