<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('VBA_INSTALL_VERSION', '1.0.0');

$phrasegroups = array('style');

if ($_REQUEST['do'] == 'mainsettings')
{
	$phrasegroups[] = 'adv_dyna_cp';
}

$scriptname = 'Dynamics';
$scriptfile = 'vbadyna_install';

require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_language.php');
require_once(DIR . '/includes/vba_dyna_adminfunctions.php');
require_once(DIR . '/includes/vba_dyna_functions.php');
require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

print_cp_header('Welcome to vBadvanced ' . $scriptname, '', '<style type="text/css">
<!--
.redalert
{
	background: #FF0000;
	color: #000000;
}
-->
</style>');

?>

<script type="text/javascript">
<!--

function safeSubmit(formobj)
{
	if (document.all || document.getElementById)
	{
		for (i = 0; i < formobj.length; i++)
		{
			var tempobj = formobj.elements[i];
			if (tempobj.type == 'submit')
			{
				tempobj.disabled = true;
			}
		}
	}
}
-->
</script>

<?php

if (empty($_REQUEST['do']))
{
 $_REQUEST['do'] = 'install';
}

// ##### Check version
if (!in_array(substr($vbulletin->options['templateversion'], 0, 3), array(3.6, 3.7)))
{
	echo 'It appears that you are trying to install the vBulletin 3.6 version of vBadvanced ' . $scriptname . ' on an older version of vBulletin.<br />You must upgrade to vBulletin 3.6.0 or higher before proceeding.';
	exit;
}

$adv_dyna_prefix = htmlspecialchars($_REQUEST['adv_dyna_prefix']);
if ($adv_dyna_prefix AND $adv_dyna_prefix != 'adv_dyna')
{
	if (strlen($adv_dyna_prefix) > 8)
	{
		$preerror = '<div>Your prefix may not be more than 8 characters long. Please go back and select a different prefix.</div>';
	}

	if (preg_replace("/[^a-z_0-9-]/i", '', strtolower($adv_dyna_prefix)) !== $adv_dyna_prefix)
	{
		$preerror .= '<div>Only alpha-numeric characters may be used in prefixes.</div>';
	}

	if ($preerror)
	{
		print_form_header('', '');
		print_table_header('vBadvanced Error');
		print_description_row($preerror, false);
		print_table_footer();
		print_cp_footer();
	}

	define('ADV_DYNA_PREFIX', $adv_dyna_prefix);

}
else
{
	define('ADV_DYNA_PREFIX', 'adv_dyna');
}

require_once(DIR . '/includes/vba_dyna_include_prefix.php');

define('ADV_DYNA_TABLE_PREFIX', TABLE_PREFIX . ADV_DYNA_PREFIX . '_');
define('ADV_DYNA_PREFIX_UPPER', strtoupper(ADV_DYNA_PREFIX));

// ##################### Delete Template Function #####################
function kill_templates($titles)
{
	global $db;

	$killtemp = array();
	foreach ($titles AS $title)
	{
		$title = check_prefix($title);
		$killtemp[] = $title;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "template
		WHERE title IN('" . implode("', '", $killtemp) . "')
			AND styleid = '-1'
	");
}

// ##### Insert all templates #################################################
function insert_all_templates()
{
	global $vbulletin, $maintemplates;

	if (ADV_DYNA_PREFIX != 'adv_dyna')
	{
		$newtemps = array();
		foreach ($maintemplates AS $tempname => $template)
		{
			$tempname = check_prefix($tempname);
			$newtemps[] = $tempname;
		}
	}
	else
	{
		$newtemps = array_keys($maintemplates);
	}

	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("', '", $newtemps) . "') AND styleid = '-1'");

	foreach ($maintemplates AS $name => $content)
	{
		$name = check_prefix($name);

		$tempinsert .= "(
 		'$name',
 		'" . $vbulletin->db->escape_string(compile_template($content)) . "',
 		'" . $vbulletin->db->escape_string($content) ."',
 		'-1',
 		'template',
 		" . TIMENOW . ",
 		'vBadvanced',
 		'$version',
 		'" . ADV_DYNA_PREFIX . "'
		),";
	}

 $vbulletin->db->query_write("
 	INSERT INTO " . TABLE_PREFIX . "template
 		(title, template, template_un, styleid, templatetype, dateline, username, version, product)
 	VALUES
 		" . substr($tempinsert, 0, strlen($tempinsert) - 1)
 );
}


// ##################### Insert Settings Function #####################
function insert_setting()
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$grouptitle = check_prefix($grouptitle);

	$checksetting = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	if ($checksetting['varname'])
	{
		return false;
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES (
			'$varname',
			'" . $grouptitle . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['defaultvalue']) . "',
			'" . $db->escape_string($setting['optioncode']) . "',
			" . $setting['displayorder'] . ",
			'" . $setting['serialize'] . "'
	)");

	$phrasetypeid = 'vbsettings';

	// Title phrase
	insert_phrase('setting_' . $varname . '_title', $setting['title']);

	// Description phrase
	insert_phrase('setting_' . $varname . '_desc', $setting['description']);

	return '<div class="smallfont">Added Setting - ' . $title . '</div>';

}

// ##################### Update Settings Function #####################
function update_setting($phraseonly = false)
{
 global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$oldvarname = $varname;

	$phrasetypeid = 'vbsettings';

	// Title phrase
	update_phrase('setting_' . $varname . '_title', $setting['title']);

	// Description phrase
	update_phrase('setting_' . $varname . '_desc', $setting['description']);

	if ($phraseonly)
	{
		return false;
	}

	$varname = $oldvarname;

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET
			defaultvalue = '" . $db->escape_string($setting['defaultvalue']) . "',
			optioncode = '" . $db->escape_string($setting['optioncode']) . "',
			displayorder = $setting[displayorder],
			grouptitle = '$grouptitle',
			serialize = '$setting[serialize]'
		WHERE varname = '$varname' AND grouptitle = '$grouptitle'
	");

	return '<div>Updated Setting - ' . $varname . '</div>';
}

// ##################### Delete Setting Function #####################
function kill_setting($title, $printphrase = 0)
{
 global $db, $grouptitle;

	if ($varname == 'adv_global')
	{
		return;
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$title' AND grouptitle = '$grouptitle'");

	$checkremaining = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$title'");

	if (!$checkremaining['varname'])
	{
		kill_phrase('setting_" . $title . "_title');
		kill_phrase('setting_" . $title . "_desc');
	}

	return '<div class="smallfont">Removed Setting - ' . $title . '</div>';
}

// ##### Insert Phrase Function ###############################################
function insert_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $phrasetypeid, $varname, $text, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	$phrasetypeid = check_prefix($phrasetypeid);

	kill_phrase();

	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . ADV_DYNA_PREFIX . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	return '<div class="smallfont">Added Phrase - ' . $varname . '</div>';
}

// ##### Update Phrase Function ###############################################
function update_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $varname, $text, $phrasetypeid, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	$phrasetypeid = check_prefix($phrasetypeid);

	// Insert first, just to make sure it's really there
	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . ADV_DYNA_PREFIX . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($text) ."',
			dateline = " . TIMENOW . ",
			version = '$version',
			username = 'vBadvanced'
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . ADV_DYNA_PREFIX . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Updated Phrase - ' . $varname . '</div>';
}

// ##################### Delete Phrase Function #####################
function kill_phrase($forcevarname = '')
{
	global $db, $varname, $phrasetypeid;

	if ($forcevarname)
	{
		$varname = $forcevarname;
	}

	$phrasetypeid = check_prefix($phrasetypeid);

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "phrase
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . ADV_DYNA_PREFIX . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Removed phrase ' . $varname . '</div>';
}

// ##### Complete Phrase Insert/Delete ########################################
function insert_all_phrases()
{
	global $vbulletin, $mainphrases, $mainsettings, $version;

	// Settings phrases
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		foreach ($settings AS $varname => $setting)
		{
			$mainphrases['vbsettings']['setting_' . $varname . '_title'] = $setting['title'];
			$mainphrases['vbsettings']['setting_' . $varname . '_desc'] = $setting['description'];
		}
	}

	// Main phrases
	foreach ($mainphrases AS $fieldname => $phrases)
	{
		$fieldname = check_prefix($fieldname);

		$insertquery = '';
		$phraseprocessed = array();

		foreach ($phrases AS $varname => $text)
		{
			if ($fieldname == 'vbsettings' OR $fieldname == 'cron' OR $fieldname == 'style')
			{
				if (ADV_DYNA_PREFIX != 'adv_dyna')
				{
					$varname = str_replace('adv_dyna', ADV_DYNA_PREFIX, $varname);
				}
			}
			else
			{
				$varname = check_prefix($varname);
			}

			$phraseprocessed[] = $varname;

			$insertquery .= "('-1', '$varname', '" . $vbulletin->db->escape_string($text) . "', '$fieldname', '" . ADV_DYNA_PREFIX . "', 'vBadvanced', " . TIMENOW . ", '$version'),";
		}

		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE fieldname = '$fieldname'
				AND varname IN('" . implode("','", $phraseprocessed) . "')
				AND languageid = '-1'
		");


		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product, username, dateline, version)
			VALUES
				" . substr($insertquery, 0, strlen($insertquery) - 1)
		);
	}

	build_language(-1);

}

// ##### Print Form Header w/ js to disable button ############################
function print_js_form_header($file, $do)
{
	echo '<form action="' . $file . '.php" method="post" onsubmit="return safeSubmit(this)">
		<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';

	if ($do)
	{
		echo '<input type="hidden" name="do" value="' . $do . '" />';
	}

	print_table_start();
}

// ########################### Start Install Table ############################
function print_install_table_start($title = '', $reqdo = '')
{
	global $scriptfile, $scriptname;

	print_js_form_header($scriptfile, $reqdo);

	if (!$title)
	{
		$title = 'vBadvanced ' . $scriptname . ' Install';
	}

	print_table_header($title);
}

// ############################ End Install Table #############################
function print_install_table_end()
{
	global $db, $stepphrase, $scriptfile, $scriptname, $step, $nextstep, $nextdo, $rebuildtemp;

	print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');

	if (!$step AND $_REQUEST['do'] == 'install')
	{
		$steps = array();
		if (!$_REQUEST['adv_dyna_prefix'])
		{
			$steps['install'] = 'Begin the installation process.';
			$steps['enter_prefix'] = 'Install another instance of vBadvanced ' . $scriptname;
		}

		$steps['upgrade'] = 'Upgrade.';
		$steps['install_templates'] = 'Reinstall the templates.';
		$steps['install_phrases'] = 'Reinstall the phrases.';

		if (!$_REQUEST['adv_dyna_prefix'])
		{
			$steps['doimages'] = 'Update your image paths.';
		}

		$steps['uninstall'] = 'Uninstall vBadvanced ' . $scriptname . '.';

		print_radio_row('', 'do', $steps, 'install');
	}

	construct_hidden_code('step', iif($nextstep, $nextstep, $step + 1));

	if ($nextdo)
	{
		construct_hidden_code('do', $nextdo);
	}

	if ($_REQUEST['adv_dyna_prefix'])
	{
		construct_hidden_code('adv_dyna_prefix', $_REQUEST['adv_dyna_prefix']);
	}

	print_table_break();

	if ($rebuildtemp)
	{
		vbflush();

		build_all_styles(0, 0);
	}

	if ($step == 'finished')
	{
		print_table_footer();
	}
	else
	{
		print_submit_row('Continue', '');
	}


	if (!$step AND $_REQUEST['do'] != 'enter_prefix' AND !$_REQUEST['adv_dyna_prefix'])
	{
		$currinstance = array();

		$db->reporterror = 0; // Incase adv_setting doesn't exist yet
		$getprefixes = $db->query_read("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_version' AND grouptitle != 'adv_dyna_main'");
		while ($prefix = $db->fetch_array($getprefixes))
		{
			$prefix['grouptitle'] = substr($prefix['grouptitle'], 0, (strlen($prefix['grouptitle']) - 5));
			$currinstance[$prefix['grouptitle']] = $prefix['grouptitle'];
		}
		$db->reporterror = 1;

		if (!empty($currinstance) AND $_REQUEST['do'] != 'nohooks')
		{
			print_js_form_header($scriptfile, 'install');
			print_table_break();
			print_table_header('Manage Secondary Instances');
			print_description_row('Here you may manage any of your secondary instances of vBadvanced ' . $scriptname . '. Choose an instance prefix below to get started.');
			construct_hidden_code('do', 'install');
			print_radio_row('', 'adv_dyna_prefix', $currinstance);
			print_submit_row('Continue', '');
		}
	}
}

// ##### Insert Plugins #######################################################
function insert_plugins()
{
	global $db, $vba_plugins;

	foreach ($vba_plugins AS $devkey => $plugin)
	{
		$plugin['devkey'] = $devkey;

		if (!$plugin['product'])
		{
			$plugin['product'] = ADV_DYNA_PREFIX;
		}
		$plugin['active'] = 1;

		$plugcheck = $db->query_first("SELECT devkey FROM " . TABLE_PREFIX . "plugin WHERE devkey = '$devkey' AND product = '" . ADV_DYNA_PREFIX . "'");

		$db->query_write(fetch_query_sql($plugin, 'plugin', iif($plugcheck['devkey'], "WHERE devkey = '$devkey' AND product = '" . ADV_DYNA_PREFIX . "'", '')));
	}

	vBulletinHook::build_datastore($db);
}

// ##### Update Admin CP XML File #############################################
function update_instance_admin_xml()
{
	global $scriptname;

	if (ADV_DYNA_PREFIX == 'adv_dyna')
	{
		return '';
	}

	$newfilename = './includes/xml/cpnav_vbadyna_' . ADV_DYNA_PREFIX . '.xml';
	$deffilename = './includes/xml/cpnav_vbadyna.xml';

	if (!is_file($newfilename))
	{
		if (!@copy($deffilename, $newfilename))
		{
			$printfile = true;
		}
	}
	else
	{
		if (!is_writable($newfilename))
		{
			@chmod($newfilename, 0777);
		}
	}

	$xmlhandle = @fopen($newfilename, 'w+');

	if ($xmlhandle)
	{
		$printfile = false;
	}
	else
	{
		$printfile = true;
	}

	$xmlfile = file_get_contents($deffilename);
	$xmlfile = str_replace(
		array(
			'</link>',
			'phrase="vba_dynamics"'
		),
		array(
			'&amp;adv_dyna_prefix=' . ADV_DYNA_PREFIX . '</link>',
			'phrase="vba_dynamics_' . ADV_DYNA_PREFIX . '"',
		),
		$xmlfile
	);

	if (!$printfile)
	{
		fwrite($xmlhandle, $xmlfile, strlen($xmlfile));
		fclose($xmlhandle);
	}

	if ($printfile)
	{
		return '<br /><br /><br />vBadvanced ' . $scriptname . ' was unable to write the XML file to create your Admin CP links for this instance of the program.<br />Please copy the text below, save it as a file named &quot;cpnav_vbadyna_' . ADV_DYNA_PREFIX . '.xml&quot;, and upload it to your {forum}/includes/xml/ folder.<br /><br /><div class="alt2" style="margin:0px; padding:6px; border:1px inset; width:600px; height:350px; overflow:auto"><pre>' . htmlspecialchars($xmlfile) . '</pre></div>';
	}

	return '';
}


// ##### See if plugins are active ############################################
if (!$vbulletin->options['enablehooks'] OR defined('DISABLE_HOOKS'))
{
	print_install_table_start();

	if (defined('DISABLE_HOOKS'))
	{
		$stepphrase = '<b>Notice:</b> Plugins are currently globally disabled in your vBulletin config.php file. In order for plugins and products to function correctly, you must edit your includes/config.php file to remove this line:
		<div class="alt2" style="margin-top:10px; padding:6px; border:1px inset; width:300px; height:25px; overflow:auto">define(\'DISABLE_HOOKS\', true);</div>';
	}
	else
	{
		$stepphrase = '<b>Notice:</b> Plugins are currently globally disabled in your options. In order for plugins and products to function correctly, you must <a href="options.php?do=options&amp;dogroup=plugin" target="_blank">enable the plugin system</a>.';
	}

	$_REQUEST['do'] = 'nohooks';
	$nextdo = 'installstart';

	print_install_table_end();
	exit;
}

require_once(DIR . '/' . $vbulletin->config['Misc']['admincpdir'] . '/vbadyna_install_settings.php');
require_once(DIR . '/' . $vbulletin->config['Misc']['admincpdir'] . '/vbadyna_install_templates.php');
require_once(DIR . '/' . $vbulletin->config['Misc']['admincpdir'] . '/vbadyna_install_phrases.php');

// ##### Version check
if (VBA_INSTALL_VERSION != VBA_TEMPLATE_VERSION OR VBA_INSTALL_VERSION != VBA_PHRASE_VERSION OR VBA_INSTALL_VERSION != VBA_SETTING_VERSION)
{
	print_install_table_start();

	$stepphrase = 'Installation file versions mismatch! Please ensure that you have uploaded the entire contents of the /forum/admincp/ folder from the download package and that any older versions of the files on your server have been overwritten.';

	$_REQUEST['do'] = 'checkversion';
	$nextdo = 'installstart';
	print_install_table_end();
	exit;
}

// ##### Plugins
$vba_plugins = array(
	'adv_dyna_error' => array(
		'title' => 'vBa Dynamics Error Replacements',
		'hookname' => 'error_generic',
		'phpcode' => 'if (defined(\'VBA_SCRIPT\')) { require_once(\'./includes/vba_dyna_error.php\'); }'
	),

	'adv_dyna_template' => array(
		'title' => 'vBa Dynamics Template Group',
		'hookname' => 'template_groups',
		'phpcode' => '$only[\'' . ADV_DYNA_PREFIX . '\'] = $vbphrase[\'group_vba_dynamics' . iif(ADV_DYNA_PREFIX != 'adv_dyna', '_' . ADV_DYNA_PREFIX) . '\'];'
	),

	'adv_dyna_plugin_sf' => array(
		'title' => 'vBa Dynamics Initialization (part 1)',
		'hookname' => 'style_fetch',
		'phpcode' => 'if (VBA_SCRIPT == \'dynamics\') { require_once(\'./includes/vba_dyna_plugin_sf.php\'); }'
	),

	'adv_dyna_plugin_pt' => array(
		'title' => 'vBa Dynamics Initialization (part 2)',
		'hookname' => 'parse_templates',
		'phpcode' => 'if (VBA_SCRIPT == \'dynamics\') { require_once(\'./includes/vba_dyna_plugin_pt.php\'); }'
	),
	'adv_dyna_navlinks' => array(
	'title' => 'vBa Dynamics - Prefix Notifications w/ vBulletin URL',
	'hookname' => 'notifications_list',
	'phpcode' => 'if (VBA_SCRIPT == \'dynamics\' AND !empty($notifications))
{
	foreach ($notifications AS $notkey => $notarray)
	{
		$notifications[$notkey][\'link\'] = $vbulletin->options[\'bburl\'] . \'/\' . $notifications[$notkey][\'link\'];
	}
}')
);

$vba_dyna_modules = array(
	1 => array('title' => 'Calendar', 'description' => 'A small calendar showing links to entries posted on each day of the month.', 'inctype' => 'php_file', 'filename' => 'dyna_calendar.php', 'identifier' => 'calendar', 'active' => '1', 'useshell' => '1', 'colspan' => '8', 'formcode' => '<script type="text/javascript" src="clientscript/vba_dyna_ajax_calendar.js"></script> ', 'templatelist' => 'adv_dyna_module_calendar_day adv_dyna_module_calendar_week adv_dyna_module_calendar_header adv_dyna_module_calendar_wrapper calendar_smallmonth_week calendar_smallmonth_day_other'),

	2 => array('title' => 'Search', 'description' => 'Search by keyword.', 'inctype' => 'php_file', 'filename' => 'dyna_search.php', 'identifier' => 'search', 'active' => '1', 'useshell' => '1', 'formcode' => '<form action="search.php" method="post" name="dyna_search"> ', 'templatelist' => 'adv_dyna_module_search adv_dyna_module_search_custombits adv_dyna_module_search_custombits_selection adv_dyna_module_search_defaultfieldbits', 'link' => 'search.php'),

	3 => array('title' => 'My Favorites', 'description' => 'Displays a public list of your recently added favorites.', 'inctype' => 'php_file', 'filename' => 'dyna_myfavorites.php', 'identifier' => 'myfavorites', 'active' => '1', 'useshell' => '1', 'colspan' => '8', 'templatelist' => 'adv_dyna_entrybit_custombits adv_dyna_entrybit_expanded adv_dyna_entrybit_expanded_dropdowns adv_dyna_entrybit_simple adv_dyna_entrybit_lean adv_dyna_module_newrand_footer adv_dyna_module_newrand_header bbcode_code bbcode_html bbcode_php bbcode_quote postbit_onlinestatus', 'options' => '7'),

	4 => array('title' => 'Random Entries', 'description' => 'A listing of randomly selected entries.', 'inctype' => 'php_file', 'filename' => 'dyna_newrand.php', 'identifier' => 'randomentries', 'active' => '1', 'useshell' => '1', 'colspan' => '8', 'templatelist' => 'adv_dyna_entrybit_custombits adv_dyna_entrybit_expanded adv_dyna_entrybit_expanded_dropdowns adv_dyna_entrybit_simple adv_dyna_entrybit_lean adv_dyna_module_newrand_footer adv_dyna_module_newrand_header bbcode_code bbcode_html bbcode_php bbcode_quote postbit_onlinestatus', 'options' => '7'),

	5 => array('title' => 'Generic List', 'description' => 'This module can be used for just about any type of list. ', 'inctype' => 'php_file', 'filename' => 'dyna_list.php', 'identifier' => 'generic_list', 'active' => '1', 'useshell' => '1', 'useredit' => '1'),

	6 => array('title' => 'Quick Moderation', 'description' => 'A list of anything that is awaiting moderation.', 'inctype' => 'php_file', 'filename' => 'dyna_moderation.php', 'identifier' => 'moderation', 'active' => '1', 'useshell' => '1', 'templatelist' => 'adv_dyna_module_moderation'),

	7 => array('title' => 'About Me', 'description' => 'This will show a block containing information about you.', 'inctype' => 'php_file', 'filename' => 'dyna_aboutme.php', 'identifier' => 'aboutme', 'active' => '1', 'useshell' => '1', 'colspan' => '2', 'templatelist' => 'adv_dyna_module_aboutme adv_dyna_module_aboutme_profilefieldbits postbit_onlinestatus postbit_reputation'),

	8 => array('title' => 'My Buddies', 'description' => 'This will display the users on your buddy list to other members, along with some info about each of your buddies.', 'inctype' => 'php_file', 'filename' => 'dyna_mybuddies.php', 'identifier' => 'mybuddies', 'active' => '1', 'useshell' => '1', 'templatelist' => 'adv_dyna_module_mybuddybits'),

	9 => array('title' => 'Quick Navigation', 'description' => 'This will show a list of useful links.', 'inctype' => 'php_file', 'filename' => 'dyna_navigation.php', 'identifier' => 'quicknav', 'active' => '1', 'useshell' => '1', 'templatelist' => 'adv_dyna_module_quicknav adv_dyna_module_quicknav_customlinks adv_dyna_module_quicknav_newestbits adv_dyna_module_quicknav_linkbits'),

	10 => array('title' => 'My Links', 'description' => 'Here you may enter a list of links to your favorite web sites.', 'inctype' => 'php_file', 'filename' => 'dyna_mylinks.php', 'identifier' => 'mylinks', 'active' => '1', 'useshell' => '1', 'useredit' => '1'),

	11 => array('title' => 'What\'s New', 'description' => 'A listing of newly submitted entries.', 'inctype' => 'php_file', 'filename' => 'dyna_newrand.php', 'identifier' => 'whatsnew', 'active' => '1', 'useshell' => '1', 'colspan' => '8', 'templatelist' => 'adv_dyna_entrybit_custombits adv_dyna_entrybit_expanded adv_dyna_entrybit_expanded_dropdowns adv_dyna_entrybit_simple adv_dyna_entrybit_lean adv_dyna_module_newrand_footer adv_dyna_module_newrand_header bbcode_code bbcode_html bbcode_php bbcode_quote postbit_onlinestatus', 'options' => '7'),

	12 => array('title' => 'My Categories', 'description' => 'Displays a list of all custom categories you have created.', 'inctype' => 'php_file', 'filename' => 'dyna_mycats.php', 'identifier' => 'dyna_mycats', 'active' => '1', 'useshell' => '1', 'templatelist' => 'adv_dyna_module_mycatbits'),

	13 => array('title' => 'Category Listing', 'description' => 'This will show a condensed list of categories.', 'inctype' => 'php_file', 'filename' => 'dyna_categories.php', 'identifier' => 'catlist', 'active' => '1', 'useshell' => '1', 'templatelist' => 'adv_dyna_module_categorylistbits', 'options' => '6'),

	14 => array('title' => 'Featured', 'description' => 'A listing of featured entries.', 'inctype' => 'php_file', 'filename' => 'dyna_featured.php', 'identifier' => 'featured', 'active' => '1', 'useshell' => '1', 'colspan' => '8', 'templatelist' => 'adv_dyna_entrybit_custombits adv_dyna_entrybit_expanded adv_dyna_entrybit_expanded_dropdowns adv_dyna_entrybit_simple adv_dyna_entrybit_lean adv_dyna_module_newrand_footer adv_dyna_module_newrand_header bbcode_code bbcode_html bbcode_php bbcode_quote postbit_onlinestatus', 'options' => '7'),

	15 => array('title' => 'Guest Book', 'description' => 'A guest book allowing other members to leave you a quick message.', 'inctype' => 'php_file', 'filename' => 'dyna_guestbook.php', 'identifier' => 'dyna_gbook', 'active' => '1', 'useshell' => '1', 'templatelist' => 'adv_dyna_module_guestbook_footer adv_dyna_module_guestbookbits bbcode_code bbcode_html bbcode_php bbcode_quote postbit_onlinestatus', 'link' => 'guestbook.php?{$vbulletin->session->vars[sessionurl]}modid=$dyna_modid&amp;masteruserid=$entryuserid', 'options' => '5'),

	16 => array('title' => 'Recent Comments', 'description' => 'A preview of the most recent comments that have been made.', 'inctype' => 'php_file', 'filename' => 'dyna_newposts.php', 'identifier' => 'newposts', 'active' => '1', 'useshell' => '1', 'templatelist' => 'adv_dyna_module_newpostbit', 'options' => '6'),
	
	17 => array('title' => 'Stats', 'description' => 'Displays stats such as the total number of categories, entries, posts, and views.', 'inctype' => 'php_file', 'filename' => 'dyna_stats.php', 'identifier' => 'dyna_stats', 'active' => '1', 'useshell' => '1', 'colspan' => '2', 'templatelist' => 'adv_dyna_module_stats', 'options' => '2')

);

// Easy way to update the template lists
foreach ($vba_dyna_modules AS $modkey => $mod)
{
	$vba_dyna_modules[$modkey]['templatelist'] = str_replace(' ', "\r\n", $mod['templatelist']);
}


// ##### Version Number
$version = $mainsettings['adv_dyna_main']['dyna_version']['value'];

// ##### Multiple Instances ###################################################
if ($_REQUEST['do'] == 'enter_prefix')
{
	print_install_table_start();

	print_input_row(
		'<strong>vBadvanced ' . $scriptname . ' Instance Prefix</strong><br />
			Please choose an instance prefix for this instance. Only letters and numbers may be used, and instance prefixes may not be more than 8 characters long. All tables, templates, settings, phrases, and etc will have their normal prefix of \'adv_dyna\' changed to the instance prefix specified here. Because of this, every aspect of your secondary instance can still be customized without affecting any other instances of the program. Though the actual prefix is not that important, you should note that it will affect some minor things such as the order that the templates for this instance will appear in.',
		'adv_dyna_prefix'
	);

	print_input_row(
		'<strong>vBadvanced ' . $scriptname . ' Admin CP Title</strong><br />Please enter the title that you would like to appear in your Admin CP for this instance of vBadvanced ' . $scriptname . '. This title will only appear in the Admin CP and is intended to help distinguish between this and other instances of vBadvanced ' . $scriptname . '.',
		'adv_dyna_instance_title'
	);
	print_install_table_end();

}

// ##### Multiple Instances ###################################################
if ($_REQUEST['do'] == 'codechanges')
{
	print_install_table_start();

	$stepphrase = 'If you have not already, you should upload all of the files/folders in the &quot;dynamics&quot; folder of the download package to a new folder on your server. You will also need to open the dyna_config.php file in this new folder and add the following code just above the closing ?&gt; tag at the end of the file.<br /><br />
		<div class="alt2" style="margin:0px; padding:6px; border:1px inset; width:300px; height:35px; overflow:auto">define(\'ADV_DYNA_PREFIX\', \'' . ADV_DYNA_PREFIX . '\');</div>
	';

	$stepphrase .= update_instance_admin_xml();

	$nextdo = 'finished';

	print_install_table_end();
}

// ############################### Install ####################################
if (substr($_REQUEST['do'], '', 7) == 'install')
{
	$step = htmlspecialchars($_REQUEST['step']);

	print_install_table_start();

	$only = substr($_REQUEST['do'], 8);

	if ($only)
	{
		$step = $only;
	}

	switch ($step)
	{
		case 1:

			$db->reporterror = 0;
			$check = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_version' AND grouptitle = '" . ADV_DYNA_PREFIX . "_main'");
			if ($check['varname'])
			{
				$stepphrase = 'vBadvanced ' . $scriptname . ' is already installed! If you have a multiple instance license and would like to install a 2nd instance of vBadvanced ' . $scriptname . ', please go back and choose the option to install another instance.';
				print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
				print_table_footer();
				exit;
			}

			$db->reporterror = 1;

			$enginevar = 'ENGINE';
			if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
			{
				$enginevar = 'TYPE';
			}

			// ##### Insert Tables
			$db->query_write("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_setting (
					varname varchar(100) NOT NULL default '',
					grouptitle varchar(50) NOT NULL default '',
					value mediumtext NOT NULL,
					defaultvalue varchar(250) NOT NULL default '',
					optioncode mediumtext NOT NULL,
					displayorder smallint(3) unsigned NOT NULL default '0',
					serialize smallint(3) unsigned NOT NULL default '0'
				) $enginevar=MyISAM"
			);

			// Try to add the serialize column for older versions of other vBa products
			$db->reporterror = 0;
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
			$db->reporterror = 1;

			$db->query_write("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_settinggroup (
					grouptitle varchar(50) NOT NULL default '',
					displayorder smallint(3) unsigned NOT NULL default '0',
					PRIMARY KEY (grouptitle)
				) $enginevar=MyISAM
			");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmentperms (
				permissionid int(10) unsigned NOT NULL auto_increment,
				extension varchar(20) NOT NULL,
				usergroupid int(10) unsigned NOT NULL default '0',
				permissions text NOT NULL,
				PRIMARY KEY (permissionid),
				UNIQUE KEY extension (extension,usergroupid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachments (
				attachmentid int(10) unsigned NOT NULL auto_increment,
				entryid int(10) unsigned NOT NULL default '0',
				title varchar(100) NOT NULL,
				description text NOT NULL,
				filename varchar(255) NOT NULL,
				userid int(10) unsigned NOT NULL default '0',
				dateline int(10) unsigned NOT NULL default '0',
				views int(10) unsigned NOT NULL default '0',
				filesize int(10) unsigned NOT NULL default '0',
				hasthumb smallint(3) unsigned default '0',
				valid smallint(3) unsigned NOT NULL default '0',
				extension varchar(10) default NULL,
				posthash varchar(32) default NULL,
				PRIMARY KEY (attachmentid),
				KEY entryid (entryid),
				KEY userid (userid),
				KEY extension (extension)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmenttype (
				extension varchar(20) NOT NULL,
				size int(10) unsigned NOT NULL default '0',
				width smallint(5) unsigned NOT NULL default '0',
				height smallint(5) unsigned NOT NULL default '0',
				enabled smallint(3) unsigned NOT NULL default '0',
				thumbnail smallint(3) unsigned NOT NULL default '0',
				displayorder smallint(4) unsigned NOT NULL,
				newwin smallint(3) unsigned NOT NULL default '0',
				PRIMARY KEY (extension)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categories (
				catid smallint(5) NOT NULL auto_increment,
				title varchar(255) NOT NULL default '',
				description text NOT NULL,
				parent smallint(5) default NULL,
				hasentries smallint(3) unsigned NOT NULL default '0',
				styleid smallint(5) unsigned NOT NULL default '0',
				valid smallint(3) unsigned NOT NULL default '0',
				active smallint(3) unsigned NOT NULL default '0',
				catuserid int(10) unsigned NOT NULL default '0',
				allowusercats smallint(3) unsigned NOT NULL default '0',
				memberscat smallint(3) unsigned NOT NULL default '0',
				postcount int(10) unsigned NOT NULL default '0',
				entrycount int(10) unsigned NOT NULL default '0',
				parentlist varchar(250) NOT NULL default '0',
				`password` varchar(100) NOT NULL default '',
				displayorder int(10) unsigned NOT NULL default '0',
				caticon varchar(255) NOT NULL,
				lastentryid int(10) unsigned NOT NULL default '0',
				lastentrytitle varchar(255) default NULL,
				lastentryusername varchar(50) NOT NULL default '',
				lastentryuserid int(10) unsigned NOT NULL default '0',
				lastentrydateline int(10) unsigned NOT NULL default '0',
				lastpostid int(10) unsigned NOT NULL default '0',
				lastpostentryid int(10) unsigned NOT NULL default '0',
				lastpostentrytitle varchar(255) NOT NULL default '',
				lastpostuserid int(10) unsigned NOT NULL default '0',
				lastpostusername varchar(100) NOT NULL default '',
				lastpostdateline int(10) unsigned NOT NULL default '0',
				options int(10) unsigned NOT NULL default '0',
				useroptions int(10) unsigned NOT NULL default '0',
				newentryemail varchar(255) NOT NULL default '',
				newpostemail varchar(255) NOT NULL default '',
				subcatopts text NOT NULL,
				PRIMARY KEY (catid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categoryperms (
				permissionid int(10) unsigned NOT NULL auto_increment,
				catid int(10) unsigned NOT NULL default '0',
				usergroupid int(10) unsigned NOT NULL default '0',
				permissions text NOT NULL,
				PRIMARY KEY (permissionid),
				UNIQUE KEY catid (catid,usergroupid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields (
				fieldid smallint(3) unsigned NOT NULL auto_increment,
				title varchar(250) NOT NULL default '',
				description varchar(250) NOT NULL default '',
				`type` varchar(20) NOT NULL default '',
				required smallint(3) unsigned NOT NULL default '0',
				position_submit varchar(50) NOT NULL,
				position_display varchar(50) default NULL,
				displayorder smallint(3) unsigned NOT NULL default '0',
				searchable smallint(3) unsigned NOT NULL default '0',
				private smallint(3) unsigned NOT NULL default '0',
				maxchoices smallint(5) unsigned default '0',
				size smallint(5) unsigned default '0',
				height smallint(5) unsigned default '0',
				maxlength smallint(6) unsigned default '0',
				options text NOT NULL,
				catids varchar(255) NOT NULL default '',
				incsubs smallint(3) unsigned NOT NULL default '0',
				PRIMARY KEY (fieldid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields_entries (
				eid int(10) unsigned NOT NULL default '0',
				PRIMARY KEY (eid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_deletionlog (
				deletedid int(10) unsigned NOT NULL default '0',
				`type` char(20) NOT NULL,
				userid int(10) unsigned NOT NULL default '0',
				username varchar(255) NOT NULL,
				dateline int(10) unsigned NOT NULL default '0',
				reason varchar(255) NOT NULL,
				UNIQUE KEY deletedid (deletedid,`type`)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries (
				entryid int(11) NOT NULL auto_increment,
				title varchar(255) NOT NULL default '',
				catid smallint(5) unsigned NOT NULL default '0',
				keywords varchar(255) default NULL,
				userid int(10) unsigned NOT NULL default '0',
				username varchar(50) default NULL,
				dateline int(10) unsigned NOT NULL default '0',
				lastupdated int(10) unsigned NOT NULL default '0',
				views int(10) NOT NULL default '0',
				posts int(10) unsigned NOT NULL default '0',
				iconid smallint(3) unsigned NOT NULL default '0',
				attachid int(10) unsigned NOT NULL default '0',
				valid smallint(5) NOT NULL default '0',
				`open` smallint(3) unsigned NOT NULL default '0',
				sticky smallint(3) unsigned NOT NULL default '0',
				draft smallint(3) default '0',
				private smallint(3) unsigned NOT NULL default '0',
				hasattach smallint(3) unsigned NOT NULL default '0',
				showsignature smallint(3) unsigned NOT NULL default '0',
				notes varchar(255) NOT NULL default '',
				votenum smallint(5) unsigned NOT NULL default '0',
				votetotal smallint(5) unsigned NOT NULL default '0',
				ipaddress varchar(15) NOT NULL default '',
				lastpostid int(10) unsigned NOT NULL default '0',
				lastpostdateline int(10) unsigned NOT NULL default '0',
				lastpostuserid int(10) unsigned NOT NULL default '0',
				lastpostusername varchar(255) default NULL,
				PRIMARY KEY (entryid),
				KEY entryid (catid,draft,valid,dateline,sticky),
				KEY userid (userid),
				FULLTEXT KEY `name` (title),
				FULLTEXT KEY keywords (keywords)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries_pages (
				entryid int(10) unsigned NOT NULL,
				title varchar(255) NOT NULL,
				pagetext text NOT NULL,
				pagenumber smallint(4) unsigned NOT NULL default '0',
				allowsmilie smallint(3) unsigned NOT NULL default '0',
				UNIQUE KEY entryid (entryid,pagenumber)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entryparsed (
				entryid int(10) unsigned NOT NULL default '0',
				pagenumber smallint(4) unsigned NOT NULL default '0',
				pagetext_parsed mediumtext NOT NULL,
				dateline int(10) unsigned NOT NULL default '0',
				styleid int(10) unsigned NOT NULL default '0',
				languageid int(10) unsigned NOT NULL default '0',
				hasimages smallint(3) unsigned NOT NULL default '0',
				PRIMARY KEY (entryid,pagenumber,styleid,languageid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entrypublish (
				entryid int(10) unsigned NOT NULL default '0',
				pubdateline int(10) unsigned NOT NULL default '0',
				PRIMARY KEY (entryid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_extcache (
				exthash VARCHAR(32) NOT NULL,
				output MEDIUMTEXT NOT NULL,
				dateline INT(10) unsigned NOT NULL default '0',
				PRIMARY KEY (exthash)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_favorites (
				entryid int(10) unsigned NOT NULL default '0',
				userid int(10) unsigned NOT NULL default '0',
				dateline int(10) unsigned default '0',
				UNIQUE KEY entryid (entryid,userid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_guestbook (
				postid int(10) unsigned NOT NULL auto_increment,
				masteruserid int(10) unsigned NOT NULL default '0',
				title varchar(255) NOT NULL default '',
				pagetext text NOT NULL,
				userid int(10) unsigned NOT NULL default '0',
				username varchar(50) NOT NULL default '',
				dateline int(10) unsigned NOT NULL default '0',
				catid INT(10) UNSIGNED NOT NULL DEFAULT '0',
				ipaddress varchar(15) NOT NULL default '',
				iconid smallint(3) unsigned NOT NULL default '0',
				allowsmilie smallint(3) unsigned NOT NULL default '0',
				showsignature smallint(3) unsigned NOT NULL default '0',
				visible smallint(3) unsigned NOT NULL default '0',
				PRIMARY KEY (postid),
				KEY masteruserid (masteruserid),
				KEY userid (userid),
				KEY iconid (iconid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_layout (
				userid int(10) unsigned NOT NULL default '0',
				page varchar(30) NOT NULL default '',
				layout text NOT NULL,
				PRIMARY KEY (userid,page)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_memberscats (
				catid int(10) NOT NULL,
				userid int(10) NOT NULL,
				postcount int(10) unsigned NOT NULL default '0',
				entrycount int(10) unsigned NOT NULL default '0',
				lastentryid int(10) unsigned NOT NULL default '0',
				lastentrytitle varchar(255) default NULL,
				lastentryusername varchar(50) NOT NULL default '',
				lastentryuserid int(10) unsigned NOT NULL default '0',
				lastentrydateline int(10) unsigned NOT NULL default '0',
				lastpostentryid int(10) unsigned default '0',
				lastpostid int(10) unsigned NOT NULL default '0',
				lastpostentrytitle varchar(255) NOT NULL default '',
				lastpostuserid int(10) unsigned NOT NULL default '0',
				lastpostusername varchar(100) NOT NULL default '',
				lastpostdateline int(10) unsigned NOT NULL default '0',
				PRIMARY KEY (catid,userid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_moderator (
				userid int(10) unsigned NOT NULL default '0',
				catid smallint(5) unsigned NOT NULL default '0',
				PRIMARY KEY (userid,catid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules (
				modid smallint(5) unsigned NOT NULL auto_increment,
				title varchar(100) NOT NULL default '',
				description text NOT NULL,
				inctype varchar(20) NOT NULL default '',
				filename text NOT NULL,
				identifier varchar(100) NOT NULL default '',
				parent smallint(5) NOT NULL default '0',
				active smallint(3) unsigned NOT NULL default '1',
				useshell smallint(3) unsigned NOT NULL default '0',
				altshell VARCHAR(255) NOT NULL,
				colspan smallint(3) unsigned NOT NULL default '0',
				useredit smallint(3) NOT NULL default '0',
				formcode text NOT NULL,
				userperms text,
				templatelist text NOT NULL,
				link varchar(255) NOT NULL default '',
				options smallint(3) unsigned NOT NULL default '0',
				code_parsed text NOT NULL,
				PRIMARY KEY (modid),
				KEY identifier (identifier)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules_user (
				modlinkid int(10) unsigned NOT NULL auto_increment,
				title varchar(255) NOT NULL,
				userid int(10) unsigned NOT NULL default '0',
				modid int(10) unsigned NOT NULL default '0',
				`code` text,
				code_parsed text,
				allowsmilie smallint(3) unsigned default '0',
				PRIMARY KEY (modlinkid),
				KEY userid (userid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_posts (
				postid int(10) unsigned NOT NULL auto_increment,
				entryid int(10) unsigned NOT NULL default '0',
				title varchar(255) NOT NULL default '',
				pagetext text NOT NULL,
				userid int(10) unsigned NOT NULL default '0',
				username varchar(50) NOT NULL default '',
				dateline int(10) unsigned NOT NULL default '0',
				ipaddress varchar(15) NOT NULL default '',
				iconid smallint(3) unsigned NOT NULL default '0',
				allowsmilie smallint(3) unsigned NOT NULL default '0',
				showsignature smallint(3) unsigned NOT NULL default '0',
				visible smallint(3) NOT NULL default '0',
				PRIMARY KEY (postid),
				KEY entryid (entryid),
				KEY userid (userid),
				KEY iconid (iconid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_rate (
				rateid int(10) unsigned NOT NULL auto_increment,
				entryid int(10) unsigned NOT NULL default '0',
				userid int(10) unsigned NOT NULL default '0',
				rating smallint(3) unsigned NOT NULL default '0',
				ipaddress varchar(15) NOT NULL default '',
				PRIMARY KEY (rateid),
				KEY entryid (entryid,userid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_search (
				searchid int(10) unsigned NOT NULL auto_increment,
				`string` varchar(100) NOT NULL default '',
				username text NOT NULL,
				sfields varchar(50) NOT NULL default '',
				catids text NOT NULL,
				dateline int(10) unsigned NOT NULL default '0',
				userid int(10) unsigned NOT NULL default '0',
				entryids text NOT NULL,
				orderby varchar(20) NOT NULL default '',
				direction varchar(4) NOT NULL default '',
				numresults smallint(5) unsigned NOT NULL default '0',
				wholeword smallint(3) unsigned NOT NULL default '0',
				searchtime tinytext NOT NULL,
				PRIMARY KEY (searchid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_subscribecat (
				userid int(10) unsigned NOT NULL default '0',
				catid int(10) unsigned NOT NULL default '0',
				entryuserid int(10) unsigned NOT NULL default '0',
				KEY userid (userid),
				KEY catid (catid),
				KEY entryuserid (entryuserid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_subscribeentry (
				userid int(10) unsigned NOT NULL default '0',
				entryid int(10) unsigned NOT NULL default '0',
				KEY entryid (entryid),
				KEY userid (userid)
			) $enginevar=MyISAM");


			if (ADV_DYNA_PREFIX != 'adv_dyna')
			{
				$instance_title = $vbulletin->input->clean_gpc('p', 'adv_dyna_instance_title', TYPE_NOHTML);

				$phrasetypeid = 'cphome';
				$varname = 'vba_dynamics_' . ADV_DYNA_PREFIX;
				$text = $instance_title;
				insert_phrase();

				$phrasetypeid = 'style';
				$varname = 'group_vba_dynamics_' . ADV_DYNA_PREFIX;
				$text = $instance_title;
				insert_phrase();

				$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . $db->escape_string($instancetitle) . "' WHERE varname = 'vbadvanced_dynamics' AND fieldname = '" . $db->escape_string(ADV_DYNA_PREFIX . '_cp') . "'");
			}
			else
			{
				$instance_title = 'vBadvanced Dynamics';
			}

			// #### Insert Product
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "product
					(productid, title, description, version, active)
				VALUES (
					'" . ADV_DYNA_PREFIX . "',
					'$instance_title',
					'vBadvanced Dynamics" . iif(ADV_DYNA_PREFIX != 'adv_dyna', ' - Secondary Instance (' . ADV_DYNA_PREFIX . ')') . "',
					'" . $version . "',
					1
			)");

			// ##### Plugins
			insert_plugins();

			// ##### Phrasegroups
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language
				ADD phrasegroup_" . ADV_DYNA_PREFIX . " MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_cats MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_mainten MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_modules MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_perms MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_editentry MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_add_entpost MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_browsecat MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_moderate MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_search MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_modules MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_managecats MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_attach MEDIUMTEXT NOT NULL
			");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrasetype
					(fieldname, title, editrows, product)
				VALUES (
					'" . ADV_DYNA_PREFIX . "',
					'$instance_title',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp',
					'$instance_title Admin CP',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp_cats',
					'$instance_title Admin CP Categories',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp_mainten',
					'$instance_title Admin CP Maintenance',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp_modules',
					'$instance_title Admin CP Modules',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp_perms',
					'$instance_title Admin CP Permissions',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_attach',
					'$instance_title Attachments',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_add_entpost',
					'$instance_title Add Entry/Reply',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_browsecat',
					'$instance_title Browse Category',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_moderate',
					'$instance_title Moderation',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_search',
					'$instance_title Search',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_editentry',
					'$instance_title Edit Entry',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_managecats',
					'$instance_title Manage Categories',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_modules',
					'$instance_title Modules',
					3,
					'" . ADV_DYNA_PREFIX . "'
				)
			");

			insert_all_phrases();

			$stepphrase .= 'Added phrases.<br /><br />';
			vbflush();

			// Datastore
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "datastore
					(title, data, unserialize)
				VALUES
					('" . ADV_DYNA_PREFIX . "_attach', '', 1),
					('" . ADV_DYNA_PREFIX . "_cats', '', 1),
					('" . ADV_DYNA_PREFIX . "_cfield', '', 1),
					('" . ADV_DYNA_PREFIX . "_featur', '', 1),
					('" . ADV_DYNA_PREFIX . "_mods', '', 1),
					('" . ADV_DYNA_PREFIX . "_modpos', 'a:1:{s:10:\"dyna_index\";a:4:{i:1;a:0:{}i:2;a:0:{}i:3;a:3:{i:17;i:1;i:11;i:2;i:4;i:3;}i:4;a:0:{}}}', 1),
					('" . ADV_DYNA_PREFIX . "_module', '', 1),
					('" . ADV_DYNA_PREFIX . "_opts', '', 1),
					('" . ADV_DYNA_PREFIX . "_perms', '', 1),
					('" . ADV_DYNA_PREFIX . "_rand', '', 1)
			");

			$stepphrase .= 'Inserted dyna fields to the datastore table.<br /><br />';

			// ##### Permissions for datastore
			$entriesperms = array();
			$ugroups = $db->query_read("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
			while ($ugroup = $db->fetch_array($ugroups))
			{
				$entriesperms[$ugroup['usergroupid']] = array(
					'dyna_perms' => array(
						'main' => 111,
						'entry' => 7,
						'attach' => 27,
						'category' => 30,
						'posting' => 139,
						'module' => 0,
						'guestbook' => 1
					),
					'limit' => array('attachspace' => 0, 'maxcats' => 0)
				);
			}

			// Admin
			$entriesperms['6'] = array(
				'dyna_perms' => array(
					'main' => 255,
					'entry' => 1021,
					'attach' => 23,
					'category' => 255,
					'posting' => 1019,
					'module' => 3,
					'guestbook' => 247
				),
				'limit' => array('attachspace' => 0, 'maxcats' => 0)
			);

			$guetperms = array(
				'dyna_perms' => array(
					'main' => 7,
					'entry' => 2,
					'attach' => 24,
					'category' => 0,
					'posting' => 5,
					'module' => 0,
					'guestbook' => 1
				)
			);

			// Guests
			$entriesperms['1'] = $guetperms;
			$entriesperms['3'] = $guetperms;
			$entriesperms['4'] = $guetperms;

			build_datastore(ADV_DYNA_PREFIX . '_perms', serialize($entriesperms), 1);

			$stepphrase .= 'Inserted vBadvanced Dynamics permissions.<br /><br />';
			vbflush();

			// ##### Insert templates
			insert_all_templates();

			$stepphrase .= 'Added templates.<br /><br />';
			vbflush();

			// Cron jobs are only needed once, so make sure we're on a default install
			if (ADV_DYNA_PREFIX == 'adv_dyna')
			{
				// ##### Cron jobs
				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "cron
						(nextrun, weekday, day, hour, minute, filename, loglevel, varname, product)
					VALUES
						(" . TIMENOW . ", -1, -1, 1, 0, './includes/cron/vba_dyna_search.php', 1, '" . ADV_DYNA_PREFIX . "_search', '" . ADV_DYNA_PREFIX . "'),
						(" . TIMENOW . ", -1, -1, 1, 0, './includes/cron/vba_dyna_ecache.php', 1, '" . ADV_DYNA_PREFIX . "_entrycache', '" . ADV_DYNA_PREFIX . "'),
						(" . TIMENOW . ", -1, -1, 0, 0, './includes/cron/vba_dyna_subscr.php', 1, '" . ADV_DYNA_PREFIX . "_subscriptions', '" . ADV_DYNA_PREFIX . "'),
						(" . TIMENOW . ", -1, -1, -1, 0, './includes/cron/vba_dyna_rand.php', 1, '" . ADV_DYNA_PREFIX . "_rand', '" . ADV_DYNA_PREFIX . "')
				");

				$stepphrase .= 'Inserted vBadvanced Dynamics fields to the cron table.<br /><br />';
			}

			// ##### Settings
			$vba_globalcheck = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

			if ($vba_globalcheck['grouptitle'])
			{
				unset($adv_settinggroups['adv_global']);
			}

			foreach ($adv_settinggroups AS $groupkey => $groupname)
			{
				$groupname = check_prefix($groupname);

				$db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('$groupname', " . ($groupkey + 1) . ")");
			}

			// ###### Insert Settings
			$setttinginsert = '';
			foreach ($mainsettings AS $grouptitle => $settings)
			{
				$grouptitle = check_prefix($grouptitle);

				if ($vba_globalcheck['grouptitle'] AND $grouptitle == 'adv_global')
				{
					continue;
				}

				foreach ($settings AS $varname => $setting)
				{
					$setttinginsert .= "(
						'$varname',
						'" . $grouptitle . "',
						'" . $db->escape_string($setting['value']) . "',
						'" . $db->escape_string($setting['defaultvalue']) . "',
						'" . $db->escape_string($setting['optioncode']) . "',
						" . $setting['displayorder'] . ",
						'" . $setting['serialize'] . "'
					),";
				}
			}

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "adv_setting
					(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
				VALUES
					" . substr($setttinginsert, 0, strlen($setttinginsert) - 1)
			);

			// Settings Cache
			$adv_options = array();
			$settings = $db->query_read("SELECT varname, value, serialize FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE '" . ADV_DYNA_PREFIX . "_%' OR grouptitle = 'adv_global'");
			while ($setting = $db->fetch_array($settings))
			{
				$adv_options["$setting[varname]"] = iif($setting['serialize'], unserialize($setting['value']), $setting['value']);
			}
			$db->free_result($settings);

			$vba_options =& $adv_options;

			build_datastore(ADV_DYNA_PREFIX . '_opts', serialize($adv_options), 1);

			$stepphrase .= 'Inserted settings.<br /><br />';

			// Insert modules
			foreach ($vba_dyna_modules AS $modid => $module)
			{
				$module['modid'] = $modid;
				$db->query_read(fetch_query_sql($module, ADV_DYNA_PREFIX . '_modules'));
			}

			$userperms = array();
			$modperms = array();
			foreach ($vbulletin->usergroupcache AS $groupid => $groupinfo)
			{
				$userperms[$groupid] = 7;

				if ($groupid == 5 OR $groupid == 6)
				{
					$modperms[$groupid] = 7;
				}
				else
				{
					$modperms[$groupid] = 0;
				}
			}

			$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules SET userperms = '" . serialize($userperms) . "'");

			$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules SET userperms = '" . serialize($modperms) . "' WHERE identifier = 'dyna_moderation'");


			build_dyna_module_datastore();

			$stepphrase .= 'Added modules.<br /><br />';

			// Attachment types
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmenttype
					(extension, size, width, height, enabled, thumbnail)
				VALUES
					('bmp', 1048576, 800, 800, 1, 1),
					('jpg', 1048576, 800, 800, 1, 1),
					('gif', 1048576, 800, 800, 1, 1),
					('jpeg', 1048576, 800, 800, 1, 1),
					('png', 1048576, 800, 800, 1, 1),
					('doc', 1048576, 0, 0, 1, 0),
					('pdf', 1048576, 0, 0, 1, 0),
					('txt', 1048576, 0, 0, 1, 0),
					('zip', 1048576, 0, 0, 1, 0)
			");

			// ##### Default categories
			$db->query_write("INSERT INTO " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categories (catid, title, description, active, valid, parent, hasentries, postcount, entrycount, parentlist, displayorder, options) VALUES (1, 'Header Category', 'Header Category Description', 1, 1, 0, 0, 0, 0, 1, 1, 4096)");

			$db->query_write("INSERT INTO " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categories (catid, title, description, active, valid, parent, hasentries, postcount, entrycount, parentlist, displayorder, options) VALUES (2, 'Main Category', 'Main Category Description', 1, 1, 1, 1, 0, 0, '2,1', 1, 1005275)");

			$stepphrase .= 'Inserted Header Category & Main Category.<br /><br />';
			vbflush();

			build_dyna_cfield_datastore();
			build_dyna_attach_datastore();
			update_category_cache();

			$rebuildtemp = true;

			if (ADV_DYNA_PREFIX == 'adv_dyna')
			{
				$nextdo = 'preset';
			}
			else
			{
				$nextdo = 'codechanges';
			}

		break;

		// Install templates
		case 'templates':

			insert_all_templates();

			$stepphrase = 'Templates updated.';
			$nextdo = 'finished';
			$rebuildtemp = true;

		break;

		// Install phrases
		case 'phrases':

			insert_all_phrases();

			$stepphrase = 'Phrases updated.';
			$nextdo = 'finished';

		break;

		// Main page
		default:

			// Make sure adv_global setting group has the correct phrase
			$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET text = 'vBadvanced Global Options' WHERE varname = 'settinggroup_adv_global'");

			if ($_REQUEST['adv_dyna_prefix'])
			{
				$stepphrase = 'Managing secondary instance of vBadvanced ' . $scriptname . ': <strong>' . ADV_DYNA_PREFIX . '</strong>';
			}
			else
			{
				$stepphrase = '<strong>Welcome to vBadvanced ' . $scriptname . ' version ' . $version . '.</strong>';
			}

			$stepphrase .= '<br />Please select an action and click the \'Continue\' button.';

	}

	print_install_table_end();
}

// ##### Pre-set settings #####################################################
if ($_REQUEST['do'] == 'preset')
{
	$vbulletin->input->clean_gpc('r', 'skipfilecheck', TYPE_INT);

	$nextdo = 'mainsettings';
	$step = 1;

	print_install_table_start('Pre-set Configurations');
	construct_hidden_code('skipfilecheck', $vbulletin->GPC['skipfilecheck']);

	print_description_row(
		'Please select the choice that best describes your intended usage for vBadvanced Dynamics. This will help to pre-configure the settings for your use in the next step.<br /><br />' . 
		construct_radio_options('usetype', array(
			'articles' => 'Articles',
			'blog' => 'Blog',
			'files' => 'File Sharing'
		), 'articles')
	);

	print_install_table_end();	
}

// ##### Main Settings ########################################################
if ($_REQUEST['do'] == 'mainsettings')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'usetype' => TYPE_STR,
		'skipfilecheck' => TYPE_INT
	));
	
	$defvalues = array(
		'articles' => array(
			'dyna_phrase_entry' => 'Article',
			'dyna_phrase_entry_plural' => 'Articles',
			'dyna_home_memberscats' => 0,
			'dyna_home_disablecats' => 0,
			'dyna_entrybitexpanded' => 1,
			'dyna_multipage_limit' => 5,
			'dyna_allowdrafts' => 1,
			'dyna_buddyentries' => 0,
			'dyna_attachlocation' => 'showentry_belowmessage',
			'dyna_require_attach' => 0,
			'dyna_allowreplies' => 1
		),
		'blog' => array(
			'dyna_phrase_entry' => 'Entry',
			'dyna_phrase_entry_plural' => 'Entries',
			'dyna_home_memberscats' => 1,
			'dyna_home_disablecats' => 1,
			'dyna_entrybitexpanded' => 1,
			'dyna_multipage_limit' => 0,
			'dyna_allowdrafts' => 1,
			'dyna_buddyentries' => 1,
			'dyna_attachlocation' => 'showentry_belowmessage',
			'dyna_require_attach' => 0,
			'dyna_allowreplies' => 1
		),
		'files' => array(
			'dyna_phrase_entry' => 'File',
			'dyna_phrase_entry_plural' => 'Files',
			'dyna_home_memberscats' => 0,
			'dyna_home_disablecats' => 0,
			'dyna_entrybitexpanded' => 0,
			'dyna_multipage_limit' => 0,
			'dyna_allowdrafts' => 0,
			'dyna_buddyentries' => 0,
			'dyna_attachlocation' => 'showentry_belowmessage',
			'dyna_require_attach' => 1,
			'dyna_allowreplies' => 1
		)
	);

	$settingphrase = array();
	$getphrases = $db->query_read("
		SELECT varname, text
		FROM " . TABLE_PREFIX . "phrase
		WHERE fieldname = 'vbsettings'
			AND product = '" . ADV_DYNA_PREFIX . "'
		ORDER BY languageid ASC
	");
	while($phrases = $db->fetch_array($getphrases))
	{
		$settingphrase[$phrases['varname']] = $phrases['text'];
	}

	require_once('./includes/adminfunctions_options.php');

	$settingscache = array();
	$grouptitlecache = array();
	$settings = $db->query_read("
		SELECT adv_setting.*
		FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
		LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup USING (grouptitle)
		WHERE varname IN('dyna_title', 'dyna_homeurl', 'dyna_attachpath', 'dyna_attachurl', 'dyna_phrase_entry', 'dyna_phrase_entry_plural', 'dyna_home_memberscats', 'dyna_home_disablecats', 'dyna_entrybitexpanded', 'dyna_entrybitfields', 'dyna_multipage_limit', 'dyna_allowdrafts', 'dyna_buddyentries', 'dyna_attachlocation', 'dyna_require_attach', 'dyna_allowreplies')
			AND adv_setting.grouptitle LIKE '" . ADV_DYNA_PREFIX . "_%'
		ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $db->fetch_array($settings))
	{
		if ($setting['serialize'])
		{
			$setting['value'] = unserialize($setting['value']);
		}

		if ($vbulletin->GPC['usetype'] AND isset($defvalues[$vbulletin->GPC['usetype']][$setting['varname']]))
		{
			$setting['value'] = $defvalues[$vbulletin->GPC['usetype']][$setting['varname']];
		}


		$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
		$grouptitlecache[$setting['grouptitle']] = $setting['grouptitle'];
	}

	if (!$vbulletin->GPC['skipfilecheck'])
	{
		$homeurl = $vbulletin->options['homeurl'] . '/dynamics';
		if (@file_get_contents($homeurl . '/index.php'))
		{
			$settingscache[ADV_DYNA_PREFIX . '_title_paths']['dyna_homeurl']['value'] = $homeurl;
		}
	
		$uploaddir = $_SERVER['DOCUMENT_ROOT'] . '/dynamics/attach';
		if (is_dir($uploaddir))
		{
			$settingscache[ADV_DYNA_PREFIX . '_title_paths']['dyna_attachpath']['value'] = $uploaddir;
		}
	
		$uploadurl = $vbulletin->options['homeurl'] . '/dynamics/attach';
		if (@file_get_contents($uploadurl))
		{
			$settingscache[ADV_DYNA_PREFIX . '_title_paths']['dyna_attachurl']['value'] = $uploadurl;
		}
	}

	$db->free_result($settings);
	unset($setting);

	print_form_header($scriptfile, 'saveopts');
	construct_hidden_code('adv_dyna_prefix', ADV_DYNA_PREFIX);

	print_table_header('Main Settings Pre-Set Configuration');
	print_description_row('Below you will find the main and most important settings that can be used to configure vBadvanced Dynamics for different purposes. These settings have already been pre-set to the value that is most likely what should be used, depending on what type of intended use you selected on the previous page. Note that all of these settings may be changed at anytime via the \'Default Settings\' link under your \'vBadvanced Dynamics\' setting group that has been added to the left frame of your Admin CP.');
	print_table_break();
	print_table_break();
	

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_adv_setting_group($grouptitle);
		print_table_break();
	}
	print_submit_row();
}

// ##### Save Settings ########################################################
if ($_REQUEST['do'] == 'saveopts')
{
	$adv_options = array();
	$serialize_settings = array();
	$settings = $db->query_read("SELECT varname, value, serialize FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE '" . ADV_DYNA_PREFIX . "_%' OR grouptitle = 'adv_global'");
	while ($setting = $db->fetch_array($settings))
	{
		if ($setting['serialize'])
		{
			$serialize_settings[] = $setting['varname'];
			$setting['value'] = unserialize($setting['value']);
			if (!is_array($setting['value']))
			{
				$setting['value'] = array();
			}
		}

		$adv_options[$setting['varname']] = $setting['value'];
	}

	$db->free_result($settings);
	unset($setting);

	foreach ($_POST['setting'] AS $settinggroup => $settings)
	{
		foreach ($settings AS $varname => $value)
		{
			if (in_array($varname, $serialize_settings))
			{
				$value = serialize($value);
			}
			
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting SET
					value = '" . $db->escape_string($value) . "'
				WHERE varname = '$varname'
					AND grouptitle = '$settinggroup'
			");
		}
	}

	build_datastore(ADV_DYNA_PREFIX . '_opts', serialize($adv_options), 1);

	if (ADV_DYNA_PREFIX == 'adv_dyna')
	{
		print_cp_redirect($scriptfile . '.php?do=doimages');
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished&adv_dyna_prefix=' . ADV_DYNA_PREFIX);
	}
}

// ##### Update Image Paths ###################################################
if ($_REQUEST['do'] == 'doimages')
{
	// ##### Do Path Check
	function do_path_check($imageurl, $makeclass = true)
	{
		global $vbulletin;

		if ($makeclass)
		{
			$class = exec_switch_bg();
		}

		$returnurl = $imageurl;
		if (substr($imageurl, 0, 1) == '/')
		{
			$returnurl = substr($imageurl, 1);
		}

		if (is_file('./' . $imageurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize($vbulletin->options['bburl'] . '/' . $returnurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize('../' . $returnurl))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else if (@fopen($returnurl, "r"))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else
		{
			return array(
				'checked' => false,
				'class' => 'redalert',
				'newpath' => $imageurl
			);
		}
	}

	// ##### Preg match for CSS Images
	function fetch_image_replaced_string($estring)
	{
		preg_match_all("#url\(([^\"]+?)\)#i", $estring, $checkimages);

		$checked = false;
		$class = exec_switch_bg();
		if (empty($checkimages[1]))
		{
			$newstring = $estring;
		}
		else
		{
			foreach ($checkimages[1] AS $imgpath)
			{
				$paths = do_path_check($imgpath . $imgcheck, false);

				$urlpos = strpos($estring, $imgpath);
				$newstring .= substr($estring, 0, $urlpos) . $paths['newpath'];

				if ($paths['checked'])
				{
					$checked = true;
				}
				if ($paths['class'] == 'redalert')
				{
					$class = 'redalert';
				}

				$estring = substr($estring, ($urlpos + strlen($imgpath)));
			}
			$newstring .= $estring;
		}

		return array(
			'class' => $class,
			'checked' => $checked,
			'newstring' => $newstring,
			'newpath' => $paths['newpath']
		);
	}

	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber');
	$type = $vbulletin->input->clean_gpc('r', 'type');

	$perpage = ($type == 'styleimages') ? 5 : 50;

	if (!$type)
	{
		$type = 'icons';
	}

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	print_js_form_header($scriptfile, 'updateimages');
	print_table_header('Image Paths', 5);
	print_description_row('For this part of the installation process, we will attempt to update all of your images for use with vBadvanced. Please check each image here to make sure that it is displayed properly!<br /><br />
	In most cases, it should not be necessary to make any changes here. If the current image already has the correct path then the "Update" box beside it will not be checked since no changes are necessary. If the current image does not have the correct path, but this script is able to determine the correct path, then the "Update" box will be checked and the correct URL entered into the text box. If neither of the above applies, then you will see the entire box outlined in <font color="red">red</font> and it will be necessary to modify the path yourself.', 0, 5);
	print_table_break();

	$countquery = '';
	switch ($type)
	{
		case 'icons':

			if ($vbulletin->options['showdeficon'] AND $pagenumber == 1)
			{
				print_table_break();

				print_table_header('Default Post Icon', 5);

				print_cells_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$paths = do_path_check($vbulletin->options['showdeficon']);

				echo '<tr class="' . $paths['class'] . '"><td align="center"><input type="checkbox" name="updatedicon" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td><td>deficon</td><td align="center"><input name="deficon" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $vbulletin->options['showdeficon'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				print_table_break();
			}

			print_table_header('Update Icon Paths', 5);
			$countquery = "icon WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'smilies':
			print_table_header('Update Smilie Paths', 5);
			$countquery = "smilie WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'styleimages':
			print_table_header('Update Style Paths', 5);
			$countquery = 'style';
		break;
	}

	$itemcount = $db->query_first('SELECT COUNT(*) AS count FROM ' . TABLE_PREFIX . $countquery);

	if (!$itemcount['count'])
	{
		$nextpage = 1;
		construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
		print_description_row('No ' . $type . ' need updating. Please click &quot;Save&quot; to continue', '', 5);
	}
	else
	{
		$nextpage = $pagenumber + 1;

		if ($maxlimit >= $itemcount['count'])
		{
			if ($type == 'styleimages')
			{
				$nextpage = 0;
			}
			else
			{
				$maxlimit = $itemcount['count'];
				$nextpage = 1;
				construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
			}
		}
		else
		{
			construct_hidden_code('type', $type);
		}
		if ($minlimit > $itemcount['count'])
		{
			$minlimit = $itemcount['count'] - $perpage;
		}

		if ($minlimit < 1)
		{
			$minlimit = 1;
		}

		switch ($type)
		{
			// ##### Icons
			case 'icons':

				print_cells_row(array('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$icons = $db->query("
					SELECT *
					FROM " . TABLE_PREFIX . "icon
					WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
					ORDER BY iconid
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($icon = $db->fetch_array($icons))
				{
					construct_hidden_code('title[' . $icon['iconid'] . ']', $icon['title']);

					$paths = do_path_check($icon['iconpath']);

					echo '<tr class="' . $paths['class'] . '">
						<td align="left"><input type="checkbox" name="updateicon[' . $icon['iconid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
						<td>' . $icon['title'] . '</td>
						<td align="center"><input name="iconpath[' . $icon['iconid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td>
						<td align="center"><img src="' . $icon['iconpath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td>
					</tr>';
				}

				print_table_break();

			break;

			// ##### Smilies
			case 'smilies':

				print_cells_row(array('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$smilies = $db->query("
						SELECT * FROM " . TABLE_PREFIX . "smilie
						WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
						ORDER BY smilieid
						LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($smilie = $db->fetch_array($smilies))
				{
					construct_hidden_code('title[' . $smilie['smilieid'] . ']', $smilie['title']);

					$paths = do_path_check($smilie['smiliepath']);

					echo '<tr class="' . $paths['class'] . '"><td align="left"><input type="checkbox" name="updatesmilie[' . $smilie['smilieid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . 'value="1" /></td><td>' . $smilie['title'] . '</td><td align="center"><input name="smiliepath[' . $smilie['smilieid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $smilie['smiliepath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				}

			break;

			// ##### Style Images
			case 'styleimages':

				print_cells_row(array('<span style="white-space: nowrap"><input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?</span>', 'Style CSS Selector', 'New URL', 'Image Verification'), 'thead');

				// Get image titles & paths
				$scache = array();
				$styleimages = $db->query("
					SELECT * FROM " . TABLE_PREFIX . "template
					WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%' AND title != 'EXTRA')
				");
				while ($simage = $db->fetch_array($styleimages))
				{
					$scache["$simage[styleid]"]["$simage[title]"] = $simage['template'];
				}

				// Images to check for
				$stylechecks = array(
					'imgdir_attach' => '/attach.gif',
					'imgdir_button' => '/reply_small.gif',
					'imgdir_editor' => '/quote.gif',
					'imgdir_misc' => '/stats.gif',
					'imgdir_poll' => '/bar6-l.gif',
					'imgdir_rating' => '/rating_5.gif',
					'imgdir_reputation' => '/reputation_pos.gif',
					'imgdir_statusicon' => '/forum_new.gif'
				);

				// Get styles
				$styles = $db->query("
					SELECT styleid, title
					FROM " . TABLE_PREFIX . "style
					WHERE styleid != '-1'
					ORDER BY styleid, title
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($style = $db->fetch_array($styles))
				{
					print_table_header($style['title'], 4, 0, '', $stylevar['left']);

					if (empty($scache[$style['styleid']]))
					{
						$scache[$style['styleid']] = $scache['-1'];
					}

					$defstyle = array_diff(array_keys($stylechecks), array_keys($scache[$style['styleid']]));

					if (!empty($defstyle))
					{
						foreach ($defstyle AS $varname)
						{
							$scache[$style['styleid']][$varname] = $scache['-1'][$varname];
						}
					}

					foreach ($scache[$style['styleid']] AS $varname => $imgpath)
					{
						$imagesample = '';
						if ($varname == 'EXTRA2')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['all']);

							$classinput = '<textarea name="stylepath[' . $style['styleid'] . '][' . $varname . ']" rows="8" cols="45">' . htmlspecialchars($paths['newstring']) . '</textarea>';
						}

						else if (substr($varname, 0, 1) == '.' OR $varname == 'body')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['background']);

							$classinput = '<input size="50" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" value="' . htmlspecialchars($paths['newstring']) . '" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';

						}
						else
						{
							$imgcheck = $stylechecks["$varname"];

							$paths = do_path_check($imgpath . $imgcheck);

							if (substr($varname, 0, 1) == '.')
							{
								$newpath = $paths['newpath'];
							}
							else
							{
								$newpath = substr($paths['newpath'], 0, intval(strlen($paths['newpath']) - strlen($imgcheck)));
							}

							$classinput = '<input name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $newpath . '" size="50" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';
						}

						echo '<tr class="' . $paths['class'] . '">
								<td align="left"><input type="checkbox" name="updatepath[' . $style['styleid'] . '][' . $varname . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
								<td>' . $varname . '</td>
								<td align="center">' . $classinput . '</td>
							<td align="center"><div style="overflow: auto; width: 300px; max-height: 120px;">' . $imagesample . '</div></td>
						</tr>';
					}

				}
			break;

			print_table_break();
			break;
		}
	}

	construct_hidden_code('nextpage', $nextpage);
	print_submit_row('Save', 'Reset', 5);
}

// ##### Do Update Image Paths ################################################
if ($_POST['do'] == 'updateimages')
{
	$vbulletin->input->clean_array_gpc('p', array('updateicon', 'iconpath', 'updatesmilie', 'smiliepath', 'updatepath', 'stylepath', 'type' => TYPE_STR, 'nextpage' => TYPE_INT));

	$updateicon = $vbulletin->input->clean_gpc('p', 'updateicon');
	$iconpath = $vbulletin->input->clean_gpc('p', 'iconpath');
	$updatesmilie = $vbulletin->input->clean_gpc('p', 'updatesmilie');
	$smiliepath = $vbulletin->input->clean_gpc('p', 'smiliepath');
	$updatepath = $vbulletin->input->clean_gpc('p', 'updatepath');
	$stylepath = $vbulletin->input->clean_gpc('p', 'stylepath');
	$type = $vbulletin->input->clean_gpc('p', 'type');
	$nextpage = $vbulletin->input->clean_gpc('p', 'nextpage', TYPE_INT);
	$deficon = $vbulletin->input->clean_gpc('p', 'deficon', TYPE_NOHTML);

	// ##### Update Style Images
	if (is_array($updatepath))
	{
		// Get image titles & paths
		$defstyle = array();
		$styleimages = $db->query("
			SELECT title, template FROM " . TABLE_PREFIX . "template
			WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%') AND styleid = '-1'
		");
		while ($simage = $db->fetch_array($styleimages))
		{
			$defstyle["$simage[title]"] = $simage['template'];
		}

		foreach ($updatepath AS $sid => $values)
		{
			$sid = intval($sid);

			$tempcache = array();
			$gettemps = $db->query_read("
				SELECT title, template
				FROM " . TABLE_PREFIX . "template
				WHERE title IN('" . implode("', '", array_keys($values)) . "')
					AND styleid = $sid
			");
			while ($temps = $db->fetch_array($gettemps))
			{
				$tempcache[$temps['title']] = $temps['template'];
			}

			foreach ($values AS $var => $update)
			{
				if ($update)
				{
					$insert = false;
					$newtemp = $stylepath[$sid][$var];

					if (!isset($tempcache[$var]))
					{
						$insert = true;
						$tempcache[$var] = $defstyle[$var];
					}

					// EXTRA
					if ($var == 'EXTRA2')
					{
						$template = unserialize($tempcache[$var]);
						$template['all'] = $newtemp;
						$newtemp = serialize($template);
					}
					// CSS Class
					else if (substr($var, 0, 1) == '.' OR $var == 'body')
					{
						$template = unserialize($tempcache[$var]);

						$template['background'] = $newtemp;

						$newtemp = serialize($template);
					}

					if ($insert)
					{
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "template
								(styleid, title, template, template_un, templatetype, dateline, username, product)
							VALUES (
								'$sid',
								'$var',
								'" . $db->escape_string($newtemp) . "',
								'',
								'" . iif(substr($var, 0, 1) == '.', 'css', 'stylevar') . "',
								" . TIMENOW . ",
								'" . $db->escape_string($vbulletin->userinfo['username']) . "',
								'vbulletin'
						)");
					}
					else
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "template SET template = '" . $db->escape_string($newtemp) . "' WHERE title = '$var' AND styleid = '$sid'");
					}
				}
			}
		}
		build_all_styles(0, 0, $scriptfile . '.php?do=finished');
	}

	// ##### Update Icons
	else if (is_array($updateicon))
	{
		foreach ($iconpath AS $key => $val)
		{
			if ($updateicon[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "icon SET
						iconpath = '" . $db->escape_string($val) . "'
					WHERE iconid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('icon');
	}

	// ##### Update Smilies
	else if (is_array($updatesmilie))
	{
		foreach ($smiliepath AS $key => $val)
		{
			if ($updatesmilie[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "smilie SET
						smiliepath = '" . $db->escape_string($val) . "'
					WHERE smilieid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('smilie');
	}

	// ##### Default Icon URL
	if ($_POST['updatedicon'])
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '$deficon' WHERE varname = 'showdeficon'");
		echo '<br />showdeficon updated.<br />';
		build_options();
	}

	if ($nextpage)
	{
		print_cp_redirect($scriptfile . '.php?do=doimages&type=' . $type . '&pagenumber=' . $nextpage);
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished');
	}
}

// ############################ Last Step #############################
if ($_REQUEST['do'] == 'finished')
{
	print_install_table_start();

	$stepphrase = 'vBadvanced ' . $scriptname . ' installation complete!
		<div style="padding-top: 10px; padding-bottom: 10px; color:#D00000"><strong>You should now delete the ' . $scriptfile . '.php file from your admincp directory.<br />Leaving this file here could be a security risk!</strong></div>
		<div><a href="index.php"><strong>Log Into Admin CP --&gt;</strong></a></div>
		<div style="padding-top:12px"><a href="' . $scriptfile . '.php">Click here</a> to go back to the main install page.</div>
		';
	$step = 'finished';

	print_install_table_end();
}

// ############################## Upgrade ###############################
if ($_REQUEST['do'] == 'upgrade')
{
	print_install_table_start('vBadvanced ' . $scriptname . ' Upgrade', 'upgrade');

	// Just update any old values from beta 2 for simplicities sake
	$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET varname = 'dyna_version' WHERE varname = 'blog_version'");

	$checkver = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_version' AND grouptitle LIKE '" . iif(VBA_INSTALL_VERSION == '1.0 Beta 3' AND ADV_DYNA_PREFIX == 'adv_dyna', 'adv_blog', ADV_DYNA_PREFIX) . "%'");

	$enginevar = 'ENGINE';
	if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
	{
		$enginevar = 'TYPE';
	}

	// Rename the tables first incase we are upgrading from Beta 1
	if (($checkver['value'] == '1.0 Beta 1' OR $checkver['value'] == '1.0 Beta 2') AND ADV_DYNA_PREFIX == 'adv_dyna')
	{
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_attachments RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachments");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_attachmenttype RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmenttype");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_categories RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categories");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_cfields RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_cfields_entries RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields_entries");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_entries RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_entryparsed RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entryparsed");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_extcache RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_extcache");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_favorites RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_favorites");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_layout RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_layout");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_memberscats RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_memberscats");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_moderator RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_moderator");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_modules RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_modules_user RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules_user");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_permissions RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_permissions");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_posts RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_posts");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_rate RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_rate");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_search RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_search");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_subscribecat RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_subscribecat");
		$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_blog_subscribeentry RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_subscribeentry");

		$db->query_write("UPDATE " . TABLE_PREFIX . "plugin SET product = '" . ADV_DYNA_PREFIX . "' WHERE product = 'adv_blog'");
	}

	switch ($checkver['value'])
	{
		// #####
		case $version:

			$stepphrase .= '<strong>You are already running vBadvanced ' . $scriptname . ' ' . $version . '!</strong>';
		break;

		// ##### 1.0 Beta 1
		case '1.0 Beta 1':

			// ##### Load the $vba_dyna class for the new permissions, and check that we're using the new version
			require_once('./includes/vba_dyna_class.php');
			$vba_dyna =& new vba_dyna();
			$vba_dyna->vbulletin =& $vbulletin;

			if (empty($vba_dyna->_permbits['main']))
			{
				echo 'It appears that you are still using an old version of of the includes/vba_dyna_class.php file. Please upload this file and try again.';
				exit;
			}

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = '" . ADV_DYNA_PREFIX . "' AND languageid = '-1'");

			kill_templates(array(
				'ADV_DYNA_MODERATE_MOVE_ENTRIES',
				'ADV_DYNA_MODERATE_MOVE_POSTS',
				'adv_dyna_newentry_custombits'
			));

			// ##### New phrase groups
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_attach MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_cats MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_modules MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_perms MEDIUMTEXT NOT NULL
			");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrasetype
					(fieldname, title, editrows, product)
				VALUES (
					'" . ADV_DYNA_PREFIX . "_cp_cats',
					'$instance_title Admin CP Categories',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp_modules',
					'$instance_title Admin CP Modules',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp_perms',
					'$instance_title Admin CP Permissions',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_attach',
					'$instance_title Attachments',
					3,
					'" . ADV_DYNA_PREFIX . "'
				)
			");

			$stepphrase .= 'Added new phrase groups.<br /><br />';

			// ##### Custom fields
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields
				ADD private SMALLINT(3) UNSIGNED DEFAULT 0 NOT NULL AFTER searchable,
				ADD maxchoices SMALLINT(3) UNSIGNED DEFAULT 0 NOT NULL AFTER private,
				ADD size SMALLINT(5) UNSIGNED DEFAULT 0 NOT NULL AFTER maxchoices,
				ADD height SMALLINT(5) UNSIGNED DEFAULT 0 NOT NULL AFTER size,
				ADD position_submit VARCHAR(50) NOT NULL AFTER required,
				ADD position_display VARCHAR(50) NOT NULL AFTER position_submit,
				CHANGE maxlength maxlength SMALLINT(6) UNSIGNED DEFAULT 0,
				CHANGE displayorder displayorder SMALLINT(6) UNSIGNED DEFAULT 0
			");

			$db->query_write("
				UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields SET
					position_submit = 'below_message',
					position_display = 'below_message'
			");

			$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields SET size = 35 WHERE type = 'text'");

			$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields SET height = 6, size = 40 WHERE type = 'textarea'");

			$stepphrase .= 'Altered custom fields table.<br /><br />';

			$cfieldids = array();
			$getcustom = $db->query_read("SELECT fieldid FROM " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields WHERE type = 'checkbox'");
			while ($custom = $db->fetch_array($getcustom))
			{
				$cfieldids[] = 'field' . $custom['fieldid'];
			}

			if (!empty($cfieldids))
			{
				$getcustom = $db->query_read("SELECT * FROM " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields_entries");
				while ($custom = $db->fetch_array($getcustom))
				{
					foreach ($cfieldids AS $fieldname)
					{
						$custom[$fieldname] = explode(',', $custom[$fieldname]);
						$custom[$fieldname] = serialize($custom[$fieldname]);
					}

					$db->query_write(fetch_query_sql(
						$custom,
						TABLE_PREFIX . ADV_DYNA_PREFIX . '_cfields_entries',
						'WHERE eid = ' . $custom['eid']
					));
				}
			}

			$stepphrase .= 'Updated checkbox custom fields to use new formatting.<br /><br />';

			// Categories table
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categories
				ADD caticon VARCHAR(255) NOT NULL AFTER displayorder,
				ADD subcatopts TEXT NOT NULL
			");
			$stepphrase .= 'Added caticon and subcatopts fields to categories table.<br /><br />';

			// Update keywords for new format
			$getentries = $db->query_read("SELECT entryid, keywords FROM " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries WHERE keywords != ''");
			while ($entry = $db->fetch_array($getentries))
			{
				$entry['old_keywords'] = $entry['keywords'];

				$entry['keywords'] = implode(',', explode(' ', $entry['keywords']));

				if ($entry['keywords'] != $entry['old_keywords'])
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries SET keywords = '" . $db->escape_string($entry['keywords']) . "' WHERE entryid = $entry[entryid]");
				}
			}

			$stepphrase .= 'Updated tags for new formatting options.<br /><br />';

			// ##### Permissions
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_permissions CHANGE permissions permissions TEXT NOT NULL");


			$old_permbits = array('canviewdyna' => 1, 'canviewentries' => 2, 'canaddentries' => 4, 'moderateentries' => 8, 'caneditentries' => 16, 'caneditothers' => 32, 'candelete' => 64, 'catdeleteothers' => 128, 'canviewreplies' => 256, 'canreply' => 512, 'moderateposts' => 1024, 'caneditposts' => 2048, 'caneditothersposts' => 4096, 'candeleteposts' => 8192, 'candeleteothersposts' => 16384, 'cansearch' => 32768, 'canrate' => 65536, 'canseewhorated' => 131072, 'cansendtofriend' => 262144, 'canreport' => 524288, 'canviewattach' => 1048576, 'cancreatecats' => 2097152, 'moderatecats' => 4194304, 'caneditcats' => 8388608, 'candeletecats' => 16777216, 'canemptycats' => 33554432, 'canpasswordcats' => 67108864, 'cancatmoderate' => 134217728, 'canattach' => 268435456, 'canmodule' => 536870912, 'canaddmodule' => 1073741824);

			$oldperms = $db->query_first("SELECT data FROM " . TABLE_PREFIX . "datastore WHERE title = '" . ADV_DYNA_PREFIX . "_perms'");
			$oldperms['data'] = unserialize($oldperms['data']);

			$newperms = array();
			foreach ($oldperms['data'] AS $groupid => $groupperms)
			{
				$oldgroupperms = convert_bits_to_array($groupperms['dyna_perms'], $old_permbits);

				$newperms[$groupid]['maxcats'] = $oldperms['data']['dyna_maxcats'];

				foreach ($vba_dyna->_permbits AS $permgroup => $permarray)
				{
					if ($permgroup == 'limit')
					{
						$newperms[$groupid]['limit'] = array('maxcats' => $oldperms['dyna_maxcats']);
					}
					else
					{
						foreach ($permarray AS $permvar => $permbit)
						{
							if ($oldgroupperms[$permvar])
							{
								$newperms[$groupid]['dyna_perms'][$permgroup] += $vba_dyna->_permbits[$permgroup][$permvar];
							}
						}
					}
				}

				if ($newperms[$groupid]['dyna_perms']['posting'] & $vba_dyna->_permbits['posting']['canreply'])
				{
					$newperms[$groupid]['dyna_perms']['posting'] += $vba_dyna->_permbits['posting']['canreplyothers'];
				}
			}

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "datastore SET
					data = '" . $db->escape_string(serialize($newperms)) . "'
				WHERE title = '" . ADV_DYNA_PREFIX . "_perms'
			");

			// Category perms
			$getcatperms = $db->query_read("SELECT * FROM " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_permissions");
			while ($catperms = $db->fetch_array($getcatperms))
			{
				$oldgroupperms = convert_bits_to_array($catperms['permissions'], $old_permbits);

				foreach ($vba_dyna->_permbits AS $permgroup => $permarray)
				{
					foreach ($permarray AS $permvar => $permbit)
					{
						if ($oldgroupperms[$permvar])
						{
							$newcatperms[$permgroup] += $vba_dyna->_permbits[$permgroup][$permvar];
						}
					}
				}

				if ($newcatperms['posting'] & $vba_dyna->_permbits['posting']['canreply'])
				{
					$newcatperms['posting'] += $vba_dyna->_permbits['posting']['canreplyothers'];
				}

				$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_permissions SET permissions = '" . $db->escape_string(serialize($newcatperms)) . "' WHERE permissionid = $catperms[permissionid]");
			}

			// Entries table
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries ADD attachid INT(10) UNSIGNED DEFAULT '0' NOT NULL AFTER iconid");


			// Remove modcp plugin
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE devkey = 'adv_dyna_modcp'");
			$stepphrase .= 'Removed modcp plugin.<br /><br />';

			// extcache table
			$db->query_write("CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_extcache (
				exthash varchar(32) NOT NULL,
				output text NOT NULL,
				dateline int(10) unsigned NOT NULL default '0',
				PRIMARY KEY (exthash)
			) $enginevar=MyISAM");

			// Insert modules
			$db->query_write(fetch_query_sql($vba_dyna_modules['12'], ADV_DYNA_PREFIX . '_modules')); // Add My Categories

			$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules SET colspan = colspan+1 WHERE identifier IN('randomentries', 'whatsnew')");
			$stepphrase .= 'Updated/Added new modules.<br /><br />';

		// ##### 1.0 Beta 2
		case '1.0 Beta 2':

			// For the settings update below
			$groupcheck = ADV_DYNA_PREFIX;

			// Update blog => dyna for 1st instance
			if (ADV_DYNA_PREFIX == 'adv_dyna')
			{
				$groupcheck = 'adv_blog';
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "product SET
						productid = 'adv_dyna',
						title = 'vBadvanced Dynamics',
						description = 'vBadvanced Dynamics'
					WHERE productid = 'adv_blog'
				");

				// Kill all templates
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title LIKE 'adv_blog%' AND styleid = '-1'");

				// Kill all phrases
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = 'adv_blog' AND languageid = '-1'");

				// Kill old settinggroups
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle IN('adv_blog_title_paths', 'adv_blog_main', 'adv_blog_index', 'adv_blog_categorybit', 'adv_blog_browsecategory', 'adv_blog_showentry', 'adv_blog_newentry', 'adv_blog_attach', 'adv_blog_posting', 'adv_blog_usercats', 'adv_blog_moduleopts', 'adv_blog_external')");

				// ##### Update language table
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language
					CHANGE phrasegroup_adv_blog phrasegroup_" . ADV_DYNA_PREFIX . " MEDIUMTEXT NOT NULL,
					CHANGE phrasegroup_adv_blog_cp phrasegroup_" . ADV_DYNA_PREFIX . "_cp MEDIUMTEXT NOT NULL,
					CHANGE phrasegroup_adv_blog_cp_cats phrasegroup_" . ADV_DYNA_PREFIX . "_cp_cats MEDIUMTEXT NOT NULL,
					CHANGE phrasegroup_adv_blog_cp_modules phrasegroup_" . ADV_DYNA_PREFIX . "_cp_modules MEDIUMTEXT NOT NULL,
					CHANGE phrasegroup_adv_blog_cp_perms phrasegroup_" . ADV_DYNA_PREFIX . "_cp_perms MEDIUMTEXT NOT NULL,
					CHANGE phrasegroup_adv_blog_modules phrasegroup_" . ADV_DYNA_PREFIX . "_modules MEDIUMTEXT NOT NULL,
					CHANGE phrasegroup_adv_blog_managecats phrasegroup_" . ADV_DYNA_PREFIX . "_managecats MEDIUMTEXT NOT NULL,
					CHANGE phrasegroup_adv_blog_attach phrasegroup_" . ADV_DYNA_PREFIX . "_attach MEDIUMTEXT NOT NULL
				");

				// ##### Update phrase types
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna',
						title = 'vBa Dynamics Global',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna_cp',
						title = 'vBa Dynamics Admin CP',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog_cp'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna_cp_cats',
						title = 'vBa Dynamics CP Categories',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog_cp_cats'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna_cp_modules',
						title = 'vBa Dynamics CP Modules',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog_cp_modules'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna_cp_perms',
						title = 'vBa Dynamics CP Permissions',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog_cp_perms'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna_attach',
						title = 'vBa Dynamics Attachments',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog_attach'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna_managecats',
						title = 'vBa Dynamics Manage Categories',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog_managecats'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "phrasetype SET
						fieldname = 'adv_dyna_modules',
						title = 'vBa Dynamics Modules',
						product = 'adv_dyna'
					WHERE fieldname = 'adv_blog_modules'
				");

				$stepphrase .= 'Altered language and phrasetype tables to change phrasegroup titles.<br /><br />';

				// ##### Datastore
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "datastore SET
						title = 'adv_dyna_cats'
					WHERE title = 'adv_blog_cats'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "datastore SET
						title = 'adv_dyna_mods'
					WHERE title = 'adv_blog_mods'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "datastore SET
						title = 'adv_dyna_modpos'
					WHERE title = 'adv_blog_modpos'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "datastore SET
						title = 'adv_dyna_module'
					WHERE title = 'adv_blog_module'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "datastore SET
						title = 'adv_dyna_opts'
					WHERE title = 'adv_blog_opts'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "datastore SET
						title = 'adv_dyna_perms'
					WHERE title = 'adv_blog_perms'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "datastore SET
						title = 'adv_dyna_rand'
					WHERE title = 'adv_blog_rand'
				");

				$stepphrase .= 'Updated datastore entries.<br /><br />';

				// ##### Cron jobs
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "cron SET
						filename = './includes/cron/vba_dyna_search.php',
						varname = 'adv_dyna_search',
						product = 'adv_dyna'
					WHERE varname = 'adv_blog_search'
				");

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "cron SET
						filename = './includes/cron/vba_dyna_ecache.php',
						varname = 'adv_dyna_entrycache',
						product = 'adv_dyna'
					WHERE varname = 'adv_blog_entrycache'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "cron SET
						filename = './includes/cron/vba_dyna_subscr.php',
						varname = 'adv_dyna_subscriptions',
						product = 'adv_dyna'
					WHERE varname = 'adv_blog_subscriptions'
				");
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "cron SET
						filename = './includes/cron/vba_dyna_rand.php',
						varname = 'adv_dyna_rand',
						product = 'adv_dyna'
					WHERE varname = 'adv_blog_rand'
				");

				$stepphrase .= 'Updated cron jobs.<br /><br />';

			} // End - Update blog => dyna for 1st instance

			// Update the admin cp navigation phrase
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "phrase SET
					varname = 'vba_dynamics_" . ADV_DYNA_PREFIX . "'
				WHERE varname = 'vba_blogicles_" . ADV_DYNA_PREFIX . "'
			");

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "phrase SET
					varname = 'group_vba_dynamics_" . ADV_DYNA_PREFIX . "'
				WHERE varname = 'group_vba_blogicles_" . ADV_DYNA_PREFIX . "'
			");

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "phrase SET
					varname = 'vbadvanced_dynamics'
				WHERE varname = 'vbadvanced_blogicles'
			");


			// ##### Settings
			$getsettings = $db->query_read("
				SELECT varname, grouptitle
				FROM " . TABLE_PREFIX . "adv_setting
				WHERE grouptitle LIKE '$groupcheck%'
			");
			while ($setting = $db->fetch_array($getsettings))
			{
				$newvarname = $setting['varname'];
				if (substr($setting['varname'], 0, 4) == 'blog')
				{
					$newvarname = 'dyna' . substr($setting['varname'], 4, strlen($setting['varname']));
				}

				$newgrouptitle = $setting['grouptitle'];
				if (substr($setting['grouptitle'], 0, 8) == 'adv_blog')
				{
					$newgrouptitle = 'adv_dyna' . substr($setting['grouptitle'], 8, strlen($setting['grouptitle']));
				}

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_setting SET
						varname = '$newvarname',
						grouptitle = '$newgrouptitle'
					WHERE varname = '$setting[varname]'
						AND grouptitle = '$setting[grouptitle]'
				");
			}

			$stepphrase .= 'Updated settings.<br /><br />';

			// Now that the settings are updated, check for the preview
			$previewsetting = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_desclength_browse'");

			if ($previewsetting['value'])
			{
				$getfsettings = $db->query_read("
					SELECT varname, grouptitle, value
					FROM " . TABLE_PREFIX . "adv_setting
					WHERE varname IN('dyna_entrybitfields', 'dyna_newrand_entrybitfields')
				");
				while ($fsetting = $db->fetch_array($getfsettings))
				{
					$fsetting['value'] = unserialize($fsetting['value']);

					$fsetting['value'][] = 'preview';

					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_setting SET
							value = '" . $db->escape_string(serialize($fsetting['value'])) . "'
						WHERE varname = '$fsetting[varname]'
							AND grouptitle = '$fsetting[grouptitle]'
					");
				}
			}

			// Get datastore values that need updating
			$ds_values = array();
			$getds = $db->query_read("
				SELECT title, data
				FROM " . TABLE_PREFIX . "datastore
				WHERE title IN('" . ADV_DYNA_PREFIX . "_perms', '" . ADV_DYNA_PREFIX . "_modpos')
			");
			while ($ds = $db->fetch_array($getds))
			{
				$ds_values[$ds['title']] = unserialize($ds['data']);
			}

			// Change 'blog_perms' to 'dyna_perms' in permissions datastore
			$newperms = array();
			foreach ($ds_values[ADV_DYNA_PREFIX . '_perms'] AS $ugid => $groupperms)
			{
				$groupperms['dyna_perms'] = $groupperms['blog_perms'];
				unset($groupperms['blog_perms']);

				if ($groupperms['dyna_perms']['attach'] & 1)
				{
					$groupperms['dyna_perms']['attach'] += 16;
				}

				$newperms[$ugid] = $groupperms;
			}

			build_datastore(ADV_DYNA_PREFIX . '_perms', serialize($newperms), 1);

			$stepphrase .= 'Updated permissions to support new format.<br /><br />';


			// Update module positions
			$newmodpos = array();
			if (!empty($ds_values[ADV_DYNA_PREFIX . '_modpos']))
			{
				foreach ($ds_values[ADV_DYNA_PREFIX . '_modpos'] AS $dpage => $dmods)
				{
					if (substr($dpage, 0, 4) == 'blog')
					{
						$dpage = 'dyna' . substr($dpage, 4, strlen($dpage));
					}

					$newmodpos[$dpage] = $dmods;
				}
			}

			build_datastore(ADV_DYNA_PREFIX . '_modpos', serialize($newmodpos), 1);

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_permissions RENAME " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categoryperms");

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entryparsed
					DROP pagetext_preview,
					ADD hasimages SMALLINT(3) UNSIGNED NOT NULL DEFAULT '0',
					ADD pagenumber SMALLINT(4) UNSIGNED NOT NULL DEFAULT '0' AFTER entryid,
					DROP PRIMARY KEY,
					ADD PRIMARY KEY
						(entryid, pagenumber, styleid, languageid)
			");

			$stepphrase .= 'Altered \'entryparsed\' table.<br /><br />';

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmenttype
					ADD displayorder SMALLINT(4) UNSIGNED NOT NULL,
					ADD newwin SMALLINT(3) UNSIGNED NOT NULL DEFAULT '0'
			");

			$stepphrase .= 'Altered \'attachmenttype\' table.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachments ADD INDEX (extension)");

			$stepphrase .= 'Altered \'attachments\' table.<br /><br />';

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "datastore
					(title, data, unserialize)
				VALUES
					('" . ADV_DYNA_PREFIX . "_attach', '', 1),
					('" . ADV_DYNA_PREFIX . "_cfield', '', 1),
					('" . ADV_DYNA_PREFIX . "_featur', '', 1)
			");

			$stepphrase .= 'Inserted new datastore values.<br /><br />';

			// New tables
			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmentperms (
				permissionid int(10) unsigned NOT NULL auto_increment,
				extension varchar(20) NOT NULL,
				usergroupid int(10) unsigned NOT NULL default '0',
				permissions text NOT NULL,
				PRIMARY KEY (permissionid),
				UNIQUE KEY extension (extension,usergroupid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_deletionlog (
				deletedid int(10) unsigned NOT NULL default '0',
				`type` char(20) NOT NULL,
				userid int(10) unsigned NOT NULL default '0',
				username varchar(255) NOT NULL,
				dateline int(10) unsigned NOT NULL default '0',
				reason varchar(255) NOT NULL,
				UNIQUE KEY deletedid (deletedid,`type`)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries_pages (
				entryid int(10) unsigned NOT NULL,
				title varchar(255) NOT NULL,
				pagetext text NOT NULL,
				pagenumber smallint(4) unsigned NOT NULL default '0',
				allowsmilie smallint(3) unsigned NOT NULL default '0',
				UNIQUE KEY entryid (entryid,pagenumber)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entrypublish (
				entryid int(10) unsigned NOT NULL default '0',
				pubdateline int(10) unsigned NOT NULL default '0',
				PRIMARY KEY (entryid)
			) $enginevar=MyISAM");

			$db->query_write("
				CREATE TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_guestbook (
				postid int(10) unsigned NOT NULL auto_increment,
				masteruserid int(10) unsigned NOT NULL default '0',
				title varchar(255) NOT NULL default '',
				pagetext text NOT NULL,
				userid int(10) unsigned NOT NULL default '0',
				username varchar(50) NOT NULL default '',
				dateline int(10) unsigned NOT NULL default '0',
				ipaddress varchar(15) NOT NULL default '',
				iconid smallint(3) unsigned NOT NULL default '0',
				allowsmilie smallint(3) unsigned NOT NULL default '0',
				showsignature smallint(3) unsigned NOT NULL default '0',
				visible smallint(3) unsigned NOT NULL default '0',
				PRIMARY KEY (postid),
				KEY masteruserid (masteruserid),
				KEY userid (userid),
				KEY iconid (iconid)
			) $enginevar=MyISAM");

			$stepphrase .= 'Added new tables.<br /><br />';

			// Alter unnecessary mediumtext columns
			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields
				CHANGE options options text NOT NULL
			");

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_search
				CHANGE catids catids text NOT NULL,
				CHANGE entryids entryids text NOT NULL
			");

			$stepphrase .= 'Altered \'cfields\' and \'search\' tables to change mediumtext fields to text.<br /><br />';

			// Insert the pagetext into the entries_pages table
			$ecount = 0;
			$getentries = $db->query_read("
				SELECT entryid, pagetext
				FROM " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries
			");
			while ($entries = $db->fetch_array($getentries))
			{
				$ecount++;

				if ($ecount == 1)
				{
					$entryinsert = 'INSERT INTO ' . TABLE_PREFIX . ADV_DYNA_PREFIX . '_entries_pages (entryid, pagetext, pagenumber) VALUES ';
				}

				$entryinsert .= "(
					$entries[entryid],
					'" . $db->escape_string($entries['pagetext']) . "',
					1
				), ";

				// Make sure we're not inserting more than 200 at one time
				if ($ecount == 200)
				{
					$db->query_write(substr($entryinsert, 0, (strlen($entryinsert) - 2)));
					$ecount = 0;
				}
			}

			if ($ecount)
			{
				$ecount = 0;
				$db->query_write(substr($entryinsert, 0, (strlen($entryinsert) - 2)));
			}

			$stepphrase .= 'Moved entries pagetext into the \'entries_pages\' table.<br /><br />';

			// Kill the pagetext column
			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries
				DROP pagetext,
				DROP allowsmilie,
				ADD INDEX (userid)
			");

			// Clear the entryparsed table and let it be rebuilt "naturally"
			$db->query_write("DELETE FROM " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entryparsed");

			// ##### New phrase groups
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_add_entpost MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_browsecat MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_cp_mainten MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_editentry MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_moderate MEDIUMTEXT NOT NULL,
				ADD phrasegroup_" . ADV_DYNA_PREFIX . "_search MEDIUMTEXT NOT NULL
			");

			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "phrasetype
					(fieldname, title, editrows, product)
				VALUES (
					'" . ADV_DYNA_PREFIX . "_editentry',
					'$instance_title Edit Entry',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_add_entpost',
					'$instance_title Add Entry/Reply',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_browsecat',
					'$instance_title Browse Category',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_cp_mainten',
					'$instance_title CP Maintenance',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_moderate',
					'$instance_title Moderation',
					3,
					'" . ADV_DYNA_PREFIX . "'
				), (
					'" . ADV_DYNA_PREFIX . "_search',
					'$instance_title Search',
					3,
					'" . ADV_DYNA_PREFIX . "'
				)
			");

			$stepphrase .= 'Added new phrasegroups.<br /><br />';

			kill_templates(array(
				'ADV_DYNA_EDITMODULES',
				'adv_dyna_editmodules_custombits',
				'ADV_DYNA_EDIT_LAYOUT',
				'adv_dyna_edit_layout_columns',
				'adv_dyna_edit_layout_active',
				'adv_dyna_edit_layout_inactive'
			));

			$db->query_write("
				UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_layout SET
					page = 'dyna_browsecategory'
				WHERE page = 'blog_browsecategory'
			");

			$db->query_write("
				UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_layout SET
					page = 'dyna_showentry'
				WHERE page = 'blog_showentry'
			");

			// Cache the modules and update it all below
			$modcache = array();
			$getmods = $db->query_read("
				SELECT *
				FROM " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules
			");
			while ($mod = $db->fetch_array($getmods))
			{
				$modcache[$mod['modid']] = $mod;
			}

			foreach ($modcache AS $modid => $modinfo)
			{
				if (substr($modinfo['filename'], 0, 4) == 'blog')
				{
					$modinfo['filename'] = 'dyna' . substr($modinfo['filename'], 4, strlen($modinfo['filename']));
				}

				if (substr($modinfo['filename'], 0, 9) == 'edit_blog')
				{
					$modinfo['filename'] = 'edit_dyna' . substr($modinfo['filename'], 9, strlen($modinfo['filename']));
				}

				$checktemps = true;

				switch($modinfo['filename'])
				{
					case 'dyna_newrand.php':
					case 'dyna_myfavorites.php':
						$modinfo['colspan'] = 8;
						$modinfo['options'] = 7;
					break;

					case 'dyna_calendar.php':
						$checktemps = false;
						$modinfo['formcode'] = '<script type="text/javascript" src="clientscript/vba_dyna_ajax_calendar.js"></script>';
						$modinfo['templatelist'] = ADV_DYNA_PREFIX . '_module_calendar_day
' . ADV_DYNA_PREFIX . '_module_calendar_week
' . ADV_DYNA_PREFIX . '_module_calendar_header
' . ADV_DYNA_PREFIX . '_module_calendar_wrapper
calendar_smallmonth_week
calendar_smallmonth_day_other';
					break;

					case 'module_search':
						$modinfo['identifier'] = 'search';
						$modinfo['description'] = 'Search by keyword.';
						$modinfo['formcode'] = '<form action="search.php" method="post" name="dyna_search">';
						$modinfo['inctype'] = 'php_file';
						$modinfo['filename'] = 'dyna_search.php';
						$modinfo['templatelist'] = ADV_DYNA_PREFIX . '_module_search
' . ADV_DYNA_PREFIX . '_module_search_custombits
' . ADV_DYNA_PREFIX . '_module_search_custombits_selection
' . ADV_DYNA_PREFIX . '_module_search_defaultfieldbits';
				}

				// Update templatelist's to use new format
				if ($checktemps AND trim($modinfo['templatelist']))
				{
					$tlist = array_map('trim', explode(',', $modinfo['templatelist']));

					$newlist = array();
					foreach ($tlist AS $tempname)
					{
						if (substr($tempname, 0, 8) == 'adv_blog')
						{
							$tempname = 'adv_dyna' . substr($tempname, 8, strlen($tempname));
						}
						$newlist[] = $tempname;
					}

						// Add new templates
						switch ($modinfo['filename'])
						{
							case 'dyna_newrand.php':
							case 'dyna_myfavorites.php':
								$newlist[] = ADV_DYNA_PREFIX . '_entrybit_custombits';
							break;

							case 'dyna_aboutme.php':
								$newlist[] = 'postbit_reputation';
						}

					$newlist = implode("\r\n", $newlist);

					$modinfo['templatelist'] = $newlist;
				}

				$db->query_write(fetch_query_sql(
					$modinfo,
					ADV_DYNA_PREFIX . '_modules',
					'WHERE modid = ' . $modid
				));
			}

			$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules SET options = 8 WHERE cleanoutput = 1");

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules
					DROP cleanoutput,
					CHANGE options options SMALLINT(3) NOT NULL
			");

			$stepphrase .= 'Updated default modules.<br /><br />';

			// Insert modules
			$db->query_write(fetch_query_sql($vba_dyna_modules['13'], ADV_DYNA_PREFIX . '_modules')); // Add Category Listing
			$db->query_write(fetch_query_sql($vba_dyna_modules['14'], ADV_DYNA_PREFIX . '_modules')); // Add Featured
			$db->query_write(fetch_query_sql($vba_dyna_modules['15'], ADV_DYNA_PREFIX . '_modules')); // Add Guestbook

			$stepphrase .= 'Inserted new modules.<br /><br />';

			// Just delete the old plugins and let them be rebuilt below
			$db->query_write("
				DELETE
				FROM " . TABLE_PREFIX . "plugin
				WHERE product = '" . ADV_DYNA_PREFIX . "'
					AND devkey IN('adv_blog_template', 'adv_blog_modulesf')
			");

			build_dyna_cfield_datastore();
			build_dyna_attach_datastore();

			$deletebetafiles = true;

		// ##### Beta 3
		case '1.0 Beta 3':

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules ADD altshell VARCHAR(255) NOT NULL AFTER useshell");

			$stepphrase .= 'Altered modules table to add \'altshell\' column.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_guestbook ADD catid INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER dateline");

			$stepphrase .= 'Altered guestbook table to add \'catid\' column.<br /><br />';

		case '1.0 RC1':

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_extcache CHANGE output output MEDIUMTEXT NOT NULL");
			$stepphrase .= 'Altered extcache table to increase the allowed storage size for RSS feeds.<br /><br />';

			$db->query_write("UPDATE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules SET identifier = 'featured' WHERE identifier = 'whatsnew2'");
			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = '" . ADV_DYNA_PREFIX . "_modules_featured' WHERE grouptitle = '" . ADV_DYNA_PREFIX . "_modules_whatsnew2'");
			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_settinggroup SET grouptitle = '" . ADV_DYNA_PREFIX . "_modules_featured' WHERE grouptitle = '" . ADV_DYNA_PREFIX . "_modules_whatsnew2'");

		case '1.0 RC2':

			kill_templates(array('ADV_DYNA_CATMANAGER_EMPTYDELETE', 'adv_dyna_moderate_actionrows'));

			// plugin devkey changed to adv_dyna_plugin_sf
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE devkey = 'adv_dyna_modulesf'");

			// Alter memberscats table
			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_memberscats
					ADD title VARCHAR(255) NOT NULL AFTER userid,
					ADD description TEXT NOT NULL AFTER title
			");

			// Insert modules
			$db->query_write(fetch_query_sql($vba_dyna_modules['16'], ADV_DYNA_PREFIX . '_modules')); // Add Recent Comments
			$db->query_write(fetch_query_sql($vba_dyna_modules['17'], ADV_DYNA_PREFIX . '_modules')); // Add Stats
			
			$statsmodid = $db->insert_id();

			// Add the stats module to the homepage
			$checksetting = $db->query_first("
				SELECT value FROM " . TABLE_PREFIX . "adv_setting
				WHERE varname = 'dyna_showstats'
					AND grouptitle = '" . ADV_DYNA_PREFIX . "_index'
			");
			
			if ($checksetting['value'])
			{
				$dlayout = $db->query_first("SELECT data FROM " . TABLE_PREFIX . "datastore WHERE title = '" . ADV_DYNA_PREFIX . "_modpos'");
				$dlayout['data'] = unserialize($dlayout['data']);
				$ilayout = $dlayout['data']['dyna_index']['3'];
			
				$plus1 = 0;

				if (!empty($ilayout))
				{
					if (min(array_values($ilayout)) <= 1)
					{
						$plus1 = 1;
					}
				}
				
				$newlayout = array($statsmodid => 1);
				foreach ($ilayout AS $imodid => $imodorder)
				{
					$newlayout[$imodid] = $imodorder + $plus1;
				}
				
				$dlayout['data']['dyna_index']['3'] = $newlayout;
		
				build_datastore(ADV_DYNA_PREFIX . '_modpos', serialize($dlayout['data']), 1);
			}

			$grouptitle = ADV_DYNA_PREFIX . '_index';

			kill_setting('dyna_showstats');

		// #####
		default:

			// Update Phrases
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = '" . ADV_DYNA_PREFIX . "' AND languageid = '-1' AND varname NOT IN('vba_dynamics_" . ADV_DYNA_PREFIX . "', 'vbadvanced_dynamics', 'group_vba_dynamics_" . ADV_DYNA_PREFIX . "')");
			insert_all_phrases();

			$stepphrase .= 'Added / updated phrases.<br /><br />';

			// Templates
			insert_all_templates();

			$stepphrase .= 'Updated templates.<br /><br />';
			vbflush();

			// Settings
			foreach ($mainsettings AS $grouptitle => $settings)
			{
				foreach ($settings AS $varname => $setting)
				{
					if (!insert_setting())
					{
						update_setting();
					}
				}
			}

			$sgroups = array();
			$sgroupcheck = $db->query_read("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle LIKE '" . ADV_DYNA_PREFIX . "%' OR grouptitle = 'adv_global'");
			while ($sgroup = $db->fetch_array($sgroupcheck))
			{
				$sgroups[] = $sgroup['grouptitle'];
			}

			// Update settinggroups
			foreach ($adv_settinggroups AS $displayorder => $grouptitle)
			{
				$grouptitle = check_prefix($grouptitle);

				$displayorder = $displayorder + 1;

				if (in_array($grouptitle, $sgroups))
				{
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_settinggroup SET
							displayorder = $displayorder
						WHERE grouptitle = '$grouptitle'
					");
				}
				else
				{
					$db->query_write("
						INSERT INTO " . TABLE_PREFIX . "adv_settinggroup
							(grouptitle, displayorder)
						VALUES (
							'$grouptitle',
							$displayorder
					)");
				}
			}

			$stepphrase .= 'Updated settinggroups.<br /><br />';
			vbflush();

			// Plugins
			insert_plugins();
			$stepphrase .= 'Updated plugins.<br /><br />';

			// Version Number
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting SET
					value = '" . $version . "'
				WHERE varname = 'dyna_version'
					AND grouptitle LIKE '" . ADV_DYNA_PREFIX . "%'
			");
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "product SET
					version = '" . $version . "'
				WHERE productid = '" . ADV_DYNA_PREFIX . "'
			");

			// Settings Cache
			$adv_options = build_dyna_settings_datastore();

			$stepphrase .= 'Updated version number.<br /><br />';

			$vba_options =& $adv_options;

			// Update the category cache to include any new values
			update_category_cache();

			// Build the module cache for any new modules or new module settings
			build_dyna_module_datastore();

			$step = 1;
			$rebuildtemp = 1;

			if (ADV_DYNA_PREFIX != 'adv_dyna')
			{
				$stepphrase .= update_instance_admin_xml();
			}

			if (!$nextdo)
			{
				$currinstance = array();

				$getprefixes = $db->query_read("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_version' AND value != '$version'");
				while ($prefix = $db->fetch_array($getprefixes))
				{
					$prefix['grouptitle'] = substr($prefix['grouptitle'], 0, (strlen($prefix['grouptitle']) - 5));
					$currinstance[$prefix['grouptitle']] = $prefix['grouptitle'];
				}

				if (empty($currinstance))
				{
					$nextdo = ($deletebetafiles) ? 'deletebetafiles' : 'finished';
				}
				else
				{
					$step = 'finished';
				}
			}
	}

	print_install_table_end();

	if (!empty($currinstance))
	{
		print_js_form_header($scriptfile, 'install');
		print_table_break();
		print_table_header('Upgrade Secondary Instances');
		print_description_row('Continue and upgrade your secondary instances of vBadvanced ' . $scriptname . '. Choose an instance prefix below to get started.');
		construct_hidden_code('do', 'upgrade');
		print_radio_row('', 'adv_dyna_prefix', $currinstance, current($currinstance));
		print_submit_row('Continue', '');
	}
}

// ######################### Uninstall #########################
if ($_REQUEST['do'] == 'uninstall')
{
	$step = $_POST['step'];


	print_js_form_header($scriptfile, 'uninstall');
	print_table_header('Uninstall vBadvanced ' . $scriptname);

	$db->reporterror = 0;

	switch ($step)
	{
		// ##### Conformation
		case 1:
			$stepphrase = 'We\'re sorry you didn\'t like vBadvanced ' . $scriptname . '. Running this script will remove all changes that were made for vBadvanced ' . $scriptname . '.';
		break;

		// ##### Remove everything
		case 2:

			// ##### Drop tables
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmentperms");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachments");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_attachmenttype");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categories");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_cfields_entries");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_deletionlog");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entries_pages");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entryparsed");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_entrypublish");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_extcache");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_favorites");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_guestbook");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_layout");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_memberscats");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_moderator");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_modules_user");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_categoryperms");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_posts");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_rate");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_search");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_subscribecat");
			$db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . ADV_DYNA_PREFIX . "_subscribeentry");

			$stepphrase = '<div>Removed tables.</div>';

			// Phrases
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE fieldname IN (
				'" . ADV_DYNA_PREFIX . "',
				'" . ADV_DYNA_PREFIX . "_add_entpost',
				'" . ADV_DYNA_PREFIX . "_attach',
				'" . ADV_DYNA_PREFIX . "_browsecat',
				'" . ADV_DYNA_PREFIX . "_cp',
				'" . ADV_DYNA_PREFIX . "_cp_cats',
				'" . ADV_DYNA_PREFIX . "_cp_mainten',
				'" . ADV_DYNA_PREFIX . "_cp_modules',
				'" . ADV_DYNA_PREFIX . "_cp_perms',
				'" . ADV_DYNA_PREFIX . "_editentry',
				'" . ADV_DYNA_PREFIX . "_managecats',
				'" . ADV_DYNA_PREFIX . "_moderate',
				'" . ADV_DYNA_PREFIX . "_modules',
				'" . ADV_DYNA_PREFIX . "_search'
			)");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = '" . ADV_DYNA_PREFIX . "'");

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . "language
					DROP phrasegroup_" . ADV_DYNA_PREFIX . ",
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_attach,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_add_entpost,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_browsecat,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_cp,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_cp_cats,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_cp_mainten,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_cp_modules,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_cp_perms,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_editentry,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_moderate,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_modules,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_managecats,
					DROP phrasegroup_" . ADV_DYNA_PREFIX . "_search
			");

			$stepphrase .= '<div style="padding-top: 6px">Removed phrases.</div>';

			// Plugins
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = '" . ADV_DYNA_PREFIX . "'");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE product = '" . ADV_DYNA_PREFIX . "'");

			$stepphrase .= '<div style="padding-top: 6px">Removed product and plugins.</div>';

			// Templates
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = '" . ADV_DYNA_PREFIX . "'");

			$stepphrase .= '<div style="padding-top: 6px">Removed templates.</div>';

			unset($mainsettings['adv_global']);
			unset($adv_settinggroups['adv_global']);

			// Settings
			foreach ($mainsettings AS $grouptitle => $settings)
			{
				$grouptitle = check_prefix($grouptitle);

				foreach ($settings AS $varname => $setting)
				{
					kill_setting($varname);
				}
			}

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle IN('" . implode("','", array_keys($adv_settinggroups)) . "')");

			$stepphrase .= '<div style="padding-top: 6px">Removed settings.</div>';

			// Datastore entries
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "datastore WHERE title IN (
				'" . ADV_DYNA_PREFIX . "_attach',
				'" . ADV_DYNA_PREFIX . "_cats',
				'" . ADV_DYNA_PREFIX . "_cfield',
				'" . ADV_DYNA_PREFIX . "_featur',
				'" . ADV_DYNA_PREFIX . "_mods',
				'" . ADV_DYNA_PREFIX . "_modpos',
				'" . ADV_DYNA_PREFIX . "_module',
				'" . ADV_DYNA_PREFIX . "_opts',
				'" . ADV_DYNA_PREFIX . "_perms',
				'" . ADV_DYNA_PREFIX . "_rand')
			");

			$stepphrase .= '<div style="padding-top: 6px">Removed fields from the datastore table.</div>';


			$db->query_write("DELETE FROM " . TABLE_PREFIX . "cron WHERE product = '" . ADV_DYNA_PREFIX . "'");

			$stepphrase .= '<div style="padding-top: 6px">Removed scheduled tasks.</div>';

			$stepphrase .= '<div style="padding-top: 16px"><strong>vBadvanced ' . $scriptname . ' Successfully Uninstalled.</strong></div>';
			$stepphrase .= '<div style="padding-top: 16px"><a href="index.php"><strong>Log Into Admin CP --&gt;</strong></a></div>';
			$stepphrase .= '<div style="padding-top: 6px"><a href="' . $scriptfile . '.php"><strong>Click here to re-install --&gt;</strong></a></div>';

			$step = 'finished';
		break;
	}
	print_install_table_end();
}

// ##### Rebuild settings #####################################################
if ($_REQUEST['do'] == 'rebuildsettings')
{
	foreach ($adv_settinggroups AS $groupkey => $groupname)
	{
		$groupname = check_prefix($groupname);

		$db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('$groupname', " . ($groupkey + 1) . ")");
	}

	foreach ($mainsettings AS $grouptitle => $settings)
	{
		foreach ($settings AS $varname => $setting)
		{
			if (!insert_setting())
			{
				update_setting();
			}
		}
	}

	echo 'Settings Rebuilt.';
}

// ##### Kill Delete Files ####################################################
if ($_REQUEST['do'] == 'deletebetafiles')
{
	$filenames = array(
		'./admincp/vba_blog_admin_categories.php',
		'./admincp/vba_blog_admin_global.php',
		'./admincp/vba_blog_admin_main.php',
		'./admincp/vba_blog_admin_maintenance.php',
		'./admincp/vba_blog_admin_modules.php',
		'./admincp/vba_blog_admin_permissions.php',
		'./admincp/vbablog_install.php',
		'./admincp/vbablog_install_phrases.php',
		'./admincp/vbablog_install_settings.php',
		'./admincp/vbablog_install_templates.php',
		'./includes/vba_blog_adminfunctions.php',
		'./includes/vba_blog_class.php',
		'./includes/vba_blog_class_image.php',
		'./includes/vba_blog_functions.php',
		'./includes/vba_blog_functions_cats.php',
		'./includes/vba_blog_functions_moderate.php',
		'./includes/vba_blog_functions_modules.php',
		'./includes/vba_blog_functions_posting.php',
		'./includes/vba_blog_functions_saveentry.php',
		'./includes/vba_blog_include_modules.php',
		'./includes/vba_blog_include_prefix.php',
		'./includes/vba_blog_plugin_sf.php',
		'./includes/cron/vba_blog_ecache.php',
		'./includes/cron/vba_blog_rand.php',
		'./includes/cron/vba_blog_search.php',
		'./includes/cron/vba_blog_subscr.php',
		'./includes/xml/cpnav_vbablog.xml',
		'./includes/vba_blog_modules/blog_aboutme.php',
		'./includes/vba_blog_modules/blog_calendar.php',
		'./includes/vba_blog_modules/blog_list.php',
		'./includes/vba_blog_modules/blog_moderation.php',
		'./includes/vba_blog_modules/blog_mybuddies.php',
		'./includes/vba_blog_modules/blog_mycats.php',
		'./includes/vba_blog_modules/blog_myfavorites.php',
		'./includes/vba_blog_modules/blog_mylinks.php',
		'./includes/vba_blog_modules/blog_navigation.php',
		'./includes/vba_blog_modules/blog_newrand.php',
		'./includes/vba_blog_modules/edit_blog_list.php',
		'./includes/vba_blog_modules/edit_blog_mylinks.php'
	);

	$instances = array();
	$dynafolders = array();
	$getprefixes = $db->query_read("SELECT grouptitle, value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_homeurl'");
	while ($prefix = $db->fetch_array($getprefixes))
	{
		$dynafolders[] = strrchr($prefix['value'], '/');
		$instances[] = substr($prefix['grouptitle'], 0, (strlen($prefix['grouptitle']) - 12));
	}

	// Get admin XML files
	foreach ($instances AS $instance)
	{
		$filenames[] = './includes/xml/cpnav_vbablog_' . $instance . '.xml';
	}

	print_install_table_start();

	print_description_row('The following files were found that are no longer necessary after this update. If you would like this script to attempt to delete these files for you, leave the boxes below checked and click \'Continue\'. Otherwise, un-check any files that you wish to keep before continuing.');
	print_description_row('<input type="checkbox" name="allbox" title="Check All" onclick="js_check_all(this.form);" id="allbox" checked="checked" /> <label for="allbox">Check/Un-check All</label>', false, 2, 'thead');

	$foundfiles = false;
	foreach ($filenames AS $file)
	{
		if (is_file($file))
		{
			$foundfiles = true;
			print_description_row('<input type="checkbox" name="filenames[]" value="' . $file . '" id="' . $file . '" checked="checked" /> <label for="' . $file . '">' . $file . '</label>');
		}
	}

	$blogfiles = array(
		'blog_global.php',
		'blog_config.php',
		'blog_config.php.new'
	);

	foreach ($dynafolders AS $folder)
	{
		$foundfolder = false;
		if (is_dir('..' . $folder))
		{
			$foundfolder = true;
			$folder = '..' . $folder;
		}
		else if (is_dir('.' . $folder))
		{
			$foundfolder = true;
			$folder = '.' . $folder;
		}
		else if (is_dir('...' . $folder))
		{
			$foundfolder = true;
			$folder = '...' . $folder;
		}

		if ($foundfolder)
		{
			foreach ($blogfiles AS $bfile)
			{
				$file = $folder . '/' . $bfile;
				if (is_file($file))
				{
					$foundfiles = true;
					print_description_row('<input type="checkbox" name="filenames[]" value="' . $file . '" id="' . $file . '" checked="checked" /> <label for="' . $file . '">' . $file . '</label>');
				}
			}
		}
	}

	if ($foundfiles)
	{
		$nextdo = 'dodeletebetafiles';
	}
	else
	{
		$stepphrase .= 'No files found.';
		$nextdo = 'finished';
	}

	$step = 1;
	print_install_table_end();
}

// ##### Do Delete Beta Files #################################################
if ($_POST['do'] == 'dodeletebetafiles')
{
	$vbulletin->input->clean_gpc('p', 'filenames', TYPE_ARRAY);

	print_install_table_start();

	$problemfiles = array();
	foreach ($vbulletin->GPC['filenames'] AS $filename)
	{
		if (!@unlink($filename))
		{
			$problemfiles[] = $filename;
		}
	}

	if (!empty($problemfiles))
	{
		$stepphrase = 'We were not able to delete the following files from your server, most likely due to your server\'s permission settings. It is recommended that you delete the following files manually from your server.<br /><br />';
		foreach ($problemfiles AS $filename)
		{
			$stepphrase .= $filename . '<br />';
		}
	}
	else
	{
		$stepphrase = 'All files removed successfully.';
	}

	$nextdo = 'finished';
	$step = 1;
	print_install_table_end();
}

// ##### Update plugins #######################################################
if ($_REQUEST['do'] == 'updateplugins')
{
	insert_plugins();

	echo 'Plugins Updated.';
}

if ($_REQUEST['do'] == 'makeadminfile')
{
	echo update_instance_admin_xml();
}

print_cp_footer();

?>