<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$timecut = (mktime(0, 0) - 3186400);

require_once('./includes/vba_dyna_functions.php');

// ##### Fetch new post text
function fetch_newpost_text()
{
	global $vbulletin, $vba_options, $newpost, $post, $postmessage, $subcatid, $subuser, $postcount;

	$post['dateline'] = vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $post['dateline']);

	fetch_entry_url($post);

	$post['url'] .= iif($vba_options['dyna_spiderurls'], '?', '&amp;') .
		'epostid=' . $post['postid'] . '#post' . $post['postid'];

	eval($postmessage);
	$postcount++;
	$newpost[$subcatid][$subuser] .= $message;
}

// ##### Fetch new entry text
function fetch_newentry_text()
{
	global $vba_options, $entry, $newentry, $entrycount, $subcatid, $subuser, $catmessage;
	$entrycount++;
	eval($catmessage);
	$newentry[$subcatid][$subuser] .= $message;
}

$getinstances = $vbulletin->db->query_read("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_version'");
while ($instance = $vbulletin->db->fetch_array($getinstances))
{
	$dyna_prefix = substr($instance['grouptitle'], 0, (strlen($instance['grouptitle']) - 5));

	// Get necessary settings
	$vba_options = array();
	$vba_opts = $vbulletin->db->query_read("
		SELECT varname, value
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE varname IN('dyna_homeurl', 'dyna_spiderurls', 'dyna_phrase_entry_plural')
	");
	while ($vba_opt = $vbulletin->db->fetch_array($vba_opts))
	{
		$vba_options[$vba_opt['varname']] = $vba_opt['value'];
	}

	// Category cache
	$getdatastore = $vbulletin->db->query_first("SELECT data FROM " . TABLE_PREFIX . "datastore WHERE title = '" . $dyna_prefix . "_cats'");

	$getdatastore['data'] = unserialize($getdatastore['data']);

	$vbulletin->adv_dyna_cats =& $getdatastore['data'];

	// New Entries
	$entries = array();
	$getentries = $vbulletin->db->query_read("
		SELECT entryid, entries.title, entries.catid, userid, username, dateline, entries.lastpostdateline, categories.title AS cattitle
		FROM " . TABLE_PREFIX . $dyna_prefix . "_entries AS entries
		LEFT JOIN " . TABLE_PREFIX . $dyna_prefix . "_categories AS categories ON (entries.catid = categories.catid)
		WHERE entries.dateline > $timecut
			AND draft = 0
			AND private = 0
			AND entries.valid = 1
			AND categories.valid = 1
		ORDER BY entries.dateline
	");
	while ($entry = $vbulletin->db->fetch_array($getentries))
	{
		if ($entry['lastpostdateline'])
		{
			$entry['lastpost'] = vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $entry['lastpostdateline']);
		}
		else
		{
			$entry['lastpost'] = $vbphrase['never'];
		}

		fetch_entry_url($entry);

		$entries[$entry['catid']][$entry['userid']][$entry['entryid']] = $entry;
	}

	$vbulletin->db->free_result($getentries);
	unset($entry);

	// New Posts
	$posts = array();
	$getposts = $vbulletin->db->query_read("
		SELECT DISTINCT posts.entryid, postid, posts.userid, posts.dateline, posts.username,
		entries.title, catid, entries.userid AS entryuserid, entries.username AS entryusername
		FROM " . TABLE_PREFIX . $dyna_prefix . "_posts AS posts
		INNER JOIN " . TABLE_PREFIX . $dyna_prefix . "_entries AS entries ON (posts.entryid = entries.entryid)
		WHERE posts.dateline > $timecut
			AND visible = 1
			AND valid = 1
			AND draft = 0
			AND private = 0
		ORDER BY dateline ASC
	");
	while ($post = $vbulletin->db->fetch_array($getposts))
	{
		$posts[$post['catid']][$post['entryuserid']][$post['entryid']] = $post;
	}

	$vbulletin->db->free_result($getposts);
	unset($post);

	$catmessage = fetch_email_phrases($dyna_prefix . '_subscribecatbit');
	$postmessage = fetch_email_phrases($dyna_prefix . '_subscribecat_postbit');

	// Subscriptions
	$newentry = array();
	$newpost = array();
	$subscriptions = $vbulletin->db->query_read("
		SELECT catid, subscriptions.userid, entryuserid, user.email, user.username
		FROM " . TABLE_PREFIX . $dyna_prefix . "_subscribecat AS subscriptions
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (subscriptions.userid = user.userid)
	");
	while ($subdata = $vbulletin->db->fetch_array($subscriptions))
	{
		$entrycount = 0;
		$postcount = 0;

		$subcatid = $subdata['catid'];
		$subuser = $subdata['entryuserid'];

		// Make a cache of the new entry/post text
		if (!isset($newentry[$subcatid][$subuser]))
		{
			$newentry[$subcatid][$subuser] = '';
			$newpost[$subcatid][$subuser] = '';

			// ##### Specific user and category
			if ($subuser AND $subcatid)
			{
				// Entries
				if (!empty($entries[$subcatid][$subuser]))
				{
					foreach ($entries[$subcatid][$subuser] AS $userkey => $entry)
					{
						if ($entry['userid'] != $subdata['userid'])
						{
							$cattitle = $vbulletin->adv_dyna_cats[$entry['catid']]['title'] . ' - ' . fetch_possessive($entry['username']) . ' ' . $vba_options['dyna_phrase_entry_plural'];
							fetch_newentry_text();
						}
					}
				}

				// Posts
				if (!empty($posts[$subcatid][$subuser]))
				{
					foreach ($posts[$subcatid][$subuser] AS $key => $post)
					{
						if ($post['userid'] != $subdata['userid'])
						{
							$cattitle = $vbulletin->adv_dyna_cats[$post['catid']]['title'] . ' - ' . fetch_possessive($post['entryusername']) . ' ' . $vba_options['dyna_phrase_entry_plural'];
							fetch_newpost_text();
						}
					}
				}

			}
			// ##### Specific user, all categories
			else if ($subuser)
			{
				// Entries
				if (!empty($entries))
				{
					foreach ($entries AS $catkey => $catusers)
					{
						foreach ($catusers AS $userkey => $userentries)
						{
							foreach ($userentries AS $entrykey => $entry)
							{
								if ($entry['userid'] != $subdata['userid'] AND $subuser == $entry['userid'])
								{
									$cattitle = fetch_possessive($entry['username']) . ' ' . $vba_options['dyna_phrase_entry_plural'];
									fetch_newentry_text();
								}
							}
						}
					}
				}

				// Posts
				if (!empty($posts))
				{
					foreach ($posts AS $postcatkey => $postcatusers)
					{
						foreach ($postcatusers AS $postuserkey => $userposts)
						{
							foreach ($userposts AS $postkey => $post)
							{
								if ($post['userid'] != $subdata['userid'] AND $subuser == $post['entryuserid'])
								{
									$cattitle = fetch_possessive($post['entryusername']) . ' ' . $vba_options['dyna_phrase_entry_plural'];
									fetch_newpost_text();
								}
							}
						}
					}
				}
			}
			// ##### Specific category, all users
			else
			{
				$cattitle = $vbulletin->adv_dyna_cats[$subcatid]['title'];

				if (!empty($entries[$subcatid]))
				{
					foreach ($entries[$subcatid] AS $catkey => $userentries)
					{
						foreach ($userentries AS $userkey => $entry)
						{
							if ($entry['userid'] != $subdata['userid'] AND $entry['catid'] == $subcatid)
							{
								fetch_newentry_text();
							}
						}
					}
				}

				// Posts
				if (!empty($posts[$subcatid]))
				{
					foreach ($posts[$subcatid] AS $catkey => $userposts)
					{
						foreach ($userposts AS $postkey => $post)
						{
							if ($post['userid'] != $subdata['userid'])
							{
								fetch_newpost_text();
							}
						}
					}
				}

			}
		}

		// Send the email out
		if ($entrycount OR $postcount)
		{
			$newentrybits = ($newentry[$subcatid][$subuser]) ? $newentry[$subcatid][$subuser] : $vbphrase['none'];

			$newpostbits = ($newpost[$subcatid][$subuser]) ? $newpost[$subcatid][$subuser] : $vbphrase['none'];

			$categorylink = fetch_cat_url($entry['catid']);

			eval(fetch_email_phrases($dyna_prefix . '_subscribecat'));
			vbmail($subdata['email'], $subject, $message);
		}
		unset($message, $subject, $newentrybits, $newpostbits, $doneentryids);
	}
}

log_cron_action('', $nextitem, 1);

?>