<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### stripos function for PHP4- ###########################################
if (!function_exists('stripos'))
{
	function stripos($haystack, $needle, $offset = 0)
	{
		return(strpos(strtolower($haystack), strtolower($needle), $offset));
	}
}

// ##### strripos function for PHP4- ##########################################
if (!function_exists('strripos'))
{
	function strripos($string, $needle)
	{
		$string = strtolower($string);
		$needle = strtolower($needle);

		$pos = strlen($string) - strpos(strrev($string), strrev($needle));

		if ($pos == strlen($string))
		{
			$pos = 0;
		}

		return $pos;
	}
}

// ##### array_combine() for PHP 4- ###########################################
if (!function_exists('array_combine'))
{
	function array_combine($keys, $values)
	{
		if (sizeof($keys) != sizeof($values))
		{
			return false;
		}

		$array = array();
		$key = 0;

		foreach ($keys AS $keyvalue)
		{
			$array[$keyvalue] = $values[$key];
			$key++;
		}

		return $array;
	}
}

// ##### array_fill_keys function for PHP4- ###################################
if (!function_exists('array_fill_keys'))
{
	function array_fill_keys($keys, $value)
	{
		return array_combine($keys, array_fill(0, sizeof($keys), $value));
	}
}

// ##### Template replacements function #######################################
if (!function_exists('replace_template_filenames'))
{
	function replace_template_filenames($tempname, $extrafiles = array())
	{
		global $vbulletin, $vba_options;

		global $repfiles;

		$repfiles = array();

		$optreplace = explode("\r\n", $vba_options['global_' . $tempname . '_replace']);
		if (!empty($optreplace))
		{
			foreach ($optreplace AS $filename)
			{
				if (trim($filename))
				{
					$repfiles['find'][] = '"' . $filename;
					$repfiles['replace'][] = '"' . $vbulletin->options['bburl'] . '/' . $filename;
				}
			}
		}

		if (!empty($extrafiles['find']))
		{
			$repfiles['find'] = array_merge($repfiles['find'], $extrafiles['find']);
		}

		if (!empty($extrafiles['replace']))
		{
			$repfiles['replace'] = array_merge($repfiles['replace'], $extrafiles['replace']);
		}

		if (empty($repfiles))
		{
			return;
		}

		$vbulletin->templatecache[$tempname] = str_replace(
			$repfiles['find'],
			$repfiles['replace'],
			$vbulletin->templatecache[$tempname]
		);
	}
}

// ##### Convert datastore prefixes ###########################################
function convert_prefixed_datastore($prefix = false)
{
	global $vbulletin;

	if (ADV_DYNA_PREFIX == 'adv_dyna' AND !$prefix)
	{
		return;
	}

	if (!$prefix)
	{
		$prefix = ADV_DYNA_PREFIX;
	}

	$prefix_opts = $prefix . '_opts';
	$vbulletin->adv_dyna_opts =& $vbulletin->$prefix_opts;

	$prefix_cats = $prefix . '_cats';
	$vbulletin->adv_dyna_cats =& $vbulletin->$prefix_cats;

	$prefix_mods = $prefix . '_mods';
	$vbulletin->adv_dyna_mods =& $vbulletin->$prefix_mods;

	$prefix_perms = $prefix . '_perms';
	$vbulletin->adv_dyna_perms =& $vbulletin->$prefix_perms;

	$prefix_rand = $prefix . '_rand';
	$vbulletin->adv_dyna_rand =& $vbulletin->$prefix_rand;

	$prefix_modpos = $prefix . '_modpos';
	$vbulletin->adv_dyna_modpos =& $vbulletin->$prefix_modpos;

	$prefix_module = $prefix . '_module';
	$vbulletin->adv_dyna_module =& $vbulletin->$prefix_module;

	$prefix_attach = $prefix . '_attach';
	$vbulletin->adv_dyna_attach =& $vbulletin->$prefix_attach;

	$prefix_cfield = $prefix . '_cfield';
	$vbulletin->adv_dyna_cfield =& $vbulletin->$prefix_cfield;

	$prefix_featur = $prefix . '_featur';
	$vbulletin->adv_dyna_featur =& $vbulletin->$prefix_featur;

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_prefixed_datastore')) ? eval($hook) : false;
}

// ##### Construct Orderby ####################################################
function construct_orderby()
{
	global $orderby, $vba_options, $direction;

	switch ($orderby)
	{
		case 'title':
		case 'views':
		case 'dateline':
		case 'lastpostdateline':
		case 'entryid':
		case 'posts':
			return 'entries.' . $orderby;
		break;

		case 'category':
			return 'categories.title';
		break;

		case 'rating':
			return 'voteavg ' . $direction . ', votenum';
		break;

		default:
			return 'entries.' . $vba_options['dyna_deforder'];
	}
}

// ##### Find Category Mods #####################################################
function is_category_mod($catid)
{
	global $vbulletin, $vba_dyna, $permissions, $vba_options;

	if (!$vbulletin->userinfo['userid'])
	{
		return false;
	}

	// Admin
	if (($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
	{
		return true;
	}
	// Dyna Moderator
	if (isset($vbulletin->adv_dyna_mods[$catid][$vbulletin->userinfo['userid']]))
	{
		return true;
	}
	// User owns the category and can moderate their own
	if ($vbulletin->userinfo['userid'] == $vbulletin->adv_dyna_cats[$catid]['catuserid'] AND $vba_dyna->check_perms('cancatmoderate'))
	{
		return true;
	}

	return false;
}

// ##### Highlight Keywords ###################################################
function highlight_keywords($string, $keywords, $wholeword)
{
	$keywords = explode(' ', $keywords);

	if (empty($keywords))
	{
		return $string;
	}

	foreach ($keywords AS $word)
	{
		$string = preg_replace("/($word)([^>]*<)/i", "<span class=\"highlight\">$1</span>$2", $string);
	}

	return $string;
}

// ##### Fetch Private Categories #############################################
function fetch_private_categories($implode = true, $permvar = 'canviewentries')
{
	global $vbulletin, $vba_dyna;

	$privcatids = array();
	foreach ($vbulletin->adv_dyna_cats AS $catid => $cats)
	{
		if (!$vba_dyna->check_cat_perms($permvar, $cats) OR !check_category_password($catid, false) OR (!is_category_mod($catid) AND !$cats['valid'] AND $cats['catuserid'] != $vbulletin->userinfo['userid']) OR !$cats['valid'])
		{
			$privcatids[] = $catid;
		}
	}

	if ($implode)
	{
		$privcatids = implode(',', array_unique($privcatids));
	}

	return $privcatids;
}

// ##### Print Category Select Field ##########################################
function print_cat_select($selectedid = 0, $type)
{
	global $vbulletin, $vba_dyna, $allowedparents, $category;

	switch ($type)
	{
		case 'catjump':
			$permvar = 'canviewdyna';
		break;

		case 'submitentry':
			$permvar = 'canaddentries';
		break;

		case 'search':
			$permvar = 'cansearch';
		break;

		case 'managecats':
			$permvar = 'cancreatecats';
		break;

		case 'admin':
		break;
	}

	if (!is_array($allowedparents))
	{
		$allowedparents = array();
	}

	if (!empty($vbulletin->adv_dyna_cats))
	{
		foreach ($vbulletin->adv_dyna_cats AS $catid => $cats)
		{
			$iscatmod = is_category_mod($cats['catid']);

			if ($type != 'admin' AND VB_AREA != 'AdminCP')
			{
				if (!in_array($cats['catid'], $allowedparents) AND (
					($type == 'managecats' AND (!$cats['allowusercats'] OR $cats['catid'] == $category['catid']))
						OR
					($type == 'submitentry' AND !$iscatmod AND ((!cat_opt('open_for_entries', $cats['catid']) AND $vba_dyna->_entry['catid'] != $cats['catid']) OR (!cat_user_opt('allow_newentries', $cats['catid']) AND $vba_dyna->_entry['catid'] != $cats['catid'])))
						OR
					(!$cats['valid'] AND ($cats['catuserid'] != $vbulletin->userinfo['userid'] OR !$cats['catuserid']))
						OR
					(($type == 'managecats' AND !$vba_dyna->_permissions['cancreatecats']) OR ($type != 'managecats' AND $permvar AND !$vba_dyna->check_cat_perms($permvar, $cats)) OR !check_category_password($cats['catid'], false))
						OR
					($type == 'moderation' AND !$iscatmod)
						OR
					(!$cats['active'] AND $selectedid != $cats['catid'])
				))
				{
					continue;
				}

				if ($cats['parent'] != 0 AND !$vbulletin->adv_dyna_cats["$cats[parent]"]['active'] AND (!$cats['catuserid'] OR $cats['catuserid'] != $vbulletin->userinfo['userid']))
				{
					$cats['active'] = 0;
					$vbulletin->adv_dyna_cats[$cats['catid']]['active'] = 0;
				}

				// Does the user own the category?
				if (!$iscatmod AND $cats['catuserid'] != $vbulletin->userinfo['userid'])
				{
					if (!cat_user_opt('allow_view', $cats['catid']) OR !$cats['valid'] OR (!$cats['active'] AND $selectedid != $cats['catid']))
					{
						continue;
					}
				}
			} // End if($type != 'admin')

			$dashes = '';
			if ($cats['level'] > 1)
			{
		    $dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
			}

			$selected = '';
			if ($selectedid == $cats['catid'])
			{
				$selected = 'selected="selected"';
				$class = 'fjsel';
			}
			else if ($cats['level'] <= 4)
			{
				$class = 'fjdpth' . $cats['level'];
			}
			else
			{
				$class = 'fjdpth';
			}

			if (
				($type == 'submitentry' AND (!$cats['hasentries'] OR !cat_opt('open_for_entries', $cats['catid'])))
				 OR ($type == 'managecats' AND !$cats['allowusercats']))
			{
				if ($options)
				{
					$endgroup = true;
					$options .= '</optgroup>';
				}
				$options .= '<optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $dashes . '' . $cats['title'] . '">';
			}
			else
			{
				$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . $cats['title'] . '</option>';
			}
		}
		if ($endgroup)
		{
			$options .= '</optgroup>';
		}
		unset($cats);
	}
	return $options;
}

// ############################ Category Jump #################################
function print_category_jump($dcatid = 0)
{
	global $catid, $vba_options, $_REQUEST, $vbphrase, $stylevar, $gobutton;

	if (!$vba_options['dyna_enable_dirjump'])
	{
		return;
	}

	$action = $_REQUEST['do'];

	if ($_REQUEST['do'] == 'searchresults')
	{
		$action = 'search';
	}

	$doselect[$action] = 'class="fjsel" selected="selected"';

	$options = print_cat_select($dcatid, 'catjump');

	eval('$categoryjump = "' . fetch_template(ADV_DYNA_PREFIX . '_categoryjump') . '";');

	return $categoryjump;
}

// ################# Construct the navbits for browsecategory ######################
function fetch_cat_navbits($catid)
{
	global $vbulletin, $vba_dyna, $vba_options, $vbphrase, $entryuserid, $entryusername, $navbits;

	if (!$vba_options['dyna_disablecats'] AND $catid)
	{
		$cat =& $vbulletin->adv_dyna_cats[$catid];

		foreach (array_reverse(explode(',', $cat['parentlist'])) AS $key => $parent)
		{
			$catlink = fetch_cat_url($parent);
			$navbits[$catlink] = $vbulletin->adv_dyna_cats[$parent]['title'];
		}
	}

	if ($cat['memberscat'] AND ($entryuserid OR THIS_SCRIPT != 'dyna_browsecategory'))
	{
		if (THIS_SCRIPT != 'dyna_browsecategory')
		{
			$entryusername = $vba_dyna->_entry['username'];
			$entryuserid = $vba_dyna->_entry['userid'];
		}

		$catlink = fetch_cat_url($catid, array('userid' => $entryuserid, 'title' => $entryusername));
		$navbits[$catlink] = fetch_possessive($entryusername) . ' ' . $vbphrase['entries'];
	}

	return $navbits;
}

// ########## Adv Sorting URL (used for sorting on showentry.php ###############
function construct_adv_sort_url($exclude = array(), $nospider = false)
{
	global $vbulletin, $vba_options, $_REQUEST, $catid;

	if ($_REQUEST['c'])
	{
		$_REQUEST['catid'] = $_REQUEST['c'];
	}

	if (!$nospider AND $vba_options['dyna_spiderurls'])
	{
		$exclude[] = 'entryuserid';
	}

	if (!in_array('catid', $exclude))
	{
		if ($_REQUEST['do'] == 'favorites'
			OR $_REQUEST['do'] == 'popentries'
			OR $_REQUEST['do'] == 'newentries'
			OR $_REQUEST['do'] == 'subscriptions'
			OR ($_REQUEST['do'] == 'member' AND ($nospider OR !$vba_options['dyna_spiderurls']))
			OR $_REQUEST['do'] == 'searchresults'
		)
		{
			$url = '&amp;catid=' . $_REQUEST['do'];
		}
		else if ((intval($catid)
				OR $catid == 'favorites'
				OR $catid == 'popentries'
				OR $catid == 'newentries'
				OR $catid == 'subscriptions'
				OR ($catid == 'member' AND ($nospider OR !$vba_options['dyna_spiderurls']))
				OR $catid == 'searchresults'
			) AND (!$vba_options['dyna_spiderurls'] OR $nospider)
		)
		{
			$url = '&amp;catid=' . $catid;
		}
	}

	$actions = array(
		'day' =>					TYPE_INT,
		'week' => 				TYPE_INT,
		'eventdate' =>		TYPE_INT,
		'entryuserid' => 	TYPE_INT,
		'cutoffdate' => 	TYPE_INT,
		'entryuserid' => 	TYPE_INT,
		'page' => 				TYPE_INT,
		'searchid' => 		TYPE_INT,
		'direction' => 		TYPE_NOHTML,
		'ltr' => 					TYPE_NOHTML,
		'orderby' => 			TYPE_NOHTML
	);

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_adv_sort_url')) ? eval($hook) : false;

	if (!empty($exclude))
	{
		foreach ($exclude AS $exaction)
		{
			unset($actions[$exaction]);
		}
	}

	foreach ($actions AS $action => $type)
	{
		if ($_REQUEST[$action])
		{
			$url .= '&amp;' . $action . '=' . $vbulletin->input->clean_gpc('r', $action, $type);
		}
	}

	if ($vba_options['dyna_spiderurls'] AND !$nospider)
	{
		if (substr($url, 0, 5) == '&amp;')
		{
			$url = substr($url, 5, strlen($url));
		}

		if ($url)
		{
			$url = '?' . $url;
		}
	}

	return $url;
}

// ##### Fetch Spider Friendly URL ############################################
function fetch_spider_url($text, $id)
{
	return str_replace(' ', '-', preg_replace("/[^a-z_0-9 -]/i", '', strtolower(html_entity_decode($text)))) . '-' . $id;
}

// ##### Fetch Category URL ###################################################
function fetch_cat_url($catid, $user = array(), $type = '', $attributes = '')
{
	global $vbulletin, $vba_options;

	$cats = $vbulletin->adv_dyna_cats[$catid];

	if ($vba_options['dyna_spiderurls'])
	{
		if ($type == 'memberpagenav')
		{
			return 'members/' . $vbulletin->session->vars['sessionurl_q'];
		}

		if ($type != 'member')
		{
			if ($vba_options['dyna_spider_cattext'])
			{
				$link .= $vba_options['dyna_spider_cattext'] . '-' . $cats['catid'] . '/';
			}
			else
			{
				$link .= $cats['surl'] . '/';
			}
		}

		if (($cats['memberscat'] OR $type == 'member') AND !empty($user))
		{
			$link .= 'members/';
			if ($vba_options['dyna_spider_memberscattext'])
			{
				$link .= $vba_options['dyna_spider_memberscattext'] . '-' . $user['userid'];
			}
			else
			{
				$link .= fetch_spider_url($user['title'], $user['userid']);
			}
			$link .= '/';
		}

		$link .= $vbulletin->session->vars['sessionurl_q'];

		if ($attributes)
		{
			if (!$vbulletin->session->vars['sessionurl_q'])
			{
				$link .= '?';
			}

			$link .= $attributes;
		}

	}
	else
	{
		if ($type == 'memberpagenav')
		{
			return 'index.php?' . $vbulletin->session->vars['sessionurl'];
		}

		$link = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'];

		if ($type == 'member')
		{
			$link .= 'do=member&amp;';
		}
		else
		{
			$link .= 'c=' . $cats['catid'];

			// $user[] could be set from the print_categories() function
			if (($user['memberscat'] OR $cats['memberscat'] OR $type == 'member') AND $user['userid'])
			{
				$link .= '&amp;';
			}
		}

		if (($user['memberscat'] OR $cats['memberscat'] OR $type == 'member') AND $user['userid'])
		{
			$link .= 'entryuserid=' . $user['userid'];
		}

		if ($attributes)
		{
			$link .= '&amp;' . $attributes;
		}
	}

	return $link;
}

// ##### Fetch Entry URL ######################################################
function fetch_entry_url(&$entry, $parameters = '')
{
	global $vbulletin, $vba_options;

	if ($vba_options['dyna_spiderurls'])
	{
		if (!$entry['caturl'])
		{
			$entry['caturl'] = fetch_cat_url($entry['catid']);
		}

		$cats = $vbulletin->adv_dyna_cats[$entry['catid']];

		$entry['url'] = iif($vba_options['dyna_spider_cattext'], $vba_options['dyna_spider_cattext'] . '-' . $cats['catid'], $cats['surl']) . '/';

		if ($vba_options['dyna_spider_entrytext'])
		{
		 	$entry['url'] .= $vba_options['dyna_spider_entrytext'] . '-' . $entry['entryid'] . '/' . $vbulletin->session->vars['sessionurl_q'];
		}
		else
		{
		 	$entry['url'] .= fetch_spider_url($entry['title'], $entry['entryid']) . '/' . $vbulletin->session->vars['sessionurl_q'];
		}

		if ($parameters)
		{
			$entry['url'] .= iif(!$vbulletin->session->vars['sessionurl_q'], '?') . $parameters;
		}
	}
	else
	{
		$entry['url'] = 'showentry.php?' . $vbulletin->session->vars['sessionurl'] . 'e=' . $entry['entryid'];

		if ($parameters)
		{
			$entry['url'] .= '&amp;' . $parameters;
		}

		$entry['caturl'] = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $entry['catid'];
	}

	return $entry['url'];
}

// ##### Replace $pagenav Links ###############################################
function replace_page_nav_links()
{
	global $vbulletin, $vba_options;

	if (!$vba_options['dyna_spiderurls'])
	{
		return;
	}

	$vbulletin->templatecache['pagenav_pagelink'] = str_replace(
		array(
			'$address2',
			'&amp;page=$curpage'
		),
		array(
			'',
			'page$curpage.html$address2',
		),
		$vbulletin->templatecache['pagenav_pagelink']
	);

	$vbulletin->templatecache['pagenav_pagelinkrel'] = str_replace(
		'&amp;page=$curpage',
		'page$curpage.html',
		$vbulletin->templatecache['pagenav_pagelinkrel']
	);

	$vbulletin->templatecache['pagenav'] = str_replace(
		array(
			'title=\"$address$address2\"',
			'&amp;page=$prevpage',
			'&amp;page=$nextpage',
			'&amp;page=$totalpages',
		),
		array(
			'title=\"" . (($address2) ? ($address2) : (\'?\')) . "\"',
			'" . "page$prevpage.html',
			'" . "page$nextpage.html',
			'" . "page$totalpages.html',
		),
		$vbulletin->templatecache['pagenav']
	);

}

// ##### Fetch Preview Text ###################################################
function fetch_entry_preview($text, $length = '')
{
	global $vba_options;

	if (!$length)
	{
		$length =& $vba_options['dyna_desclength_browse'];
	}

	if (!$length OR strlen($text) < $length)
	{
		return $text;
	}

	$trimmedlength = strrpos(substr($text, 0, $length), ' ');
	$trimmedtext = substr($text, 0, $trimmedlength);

	// Try to exclude HTML tags from length
	$truematch = false;
	while ($truematch == false)
	{
		preg_match_all("/(<([\w]+)[^>]*>)/", $trimmedtext, $opentags);

		if (empty($opentags[0]))
		{
			$truematch = true;
		}
		else
		{
			$taglen = array_sum(array_map('strlen', array_values($opentags[0])));

			if (($trimmedlength - $taglen) < $length)
			{
				$trimmedlength += ($length - ($trimmedlength - $taglen));
				$trimmedtext = substr($text, 0, $trimmedlength);
			}
			else
			{
				$truematch = true;
			}
		}
	}

	// Make sure we're not cutting off in the middle of tags
	// ##### <img>
	$lastimage = strripos($trimmedtext, '<img');
	if ($lastimage !== false)
	{
		$imagecheck = substr($trimmedtext, $lastimage);

		// Don't have the end, so find it
		if (strpos($imagecheck, ' />') === false)
		{
			$remainstring = substr($text, $trimmedlength);
			$endimgpos = strpos($remainstring, ' />') + 3;

			if ($endimgpos != false)
			{
				$trimmedtext .= substr($remainstring, 0, $endimgpos);
				$trimmedlength += $endimgpos;
			}
		}
	}

	// ##### <a>
	$lasthref = strripos($trimmedtext, '<a');
	if ($lasthref !== false)
	{
		$hrefcheck = substr($trimmedtext, $lasthref);

		// Don't have the end, so strip the tag
		if (strpos($hrefcheck, '>') === false)
		{
			$trimmedtext = substr($trimmedtext, 0, $lasthref);
			$trimmedlength -= $lasthref;
		}
	}

	// ##### <br />
	$lastbr = strripos($trimmedtext, '<br');
	if ($lastbr !== false)
	{
		$brcheck = substr($trimmedtext, $lastbr);

		// Don't have the end, so add it
		if (strpos($brcheck, ' />') === false)
		{
			$trimmedtext .= ' />';
			$trimmedlength += 3;
		}
	}

	// ##### <table>
	$lasttable = strripos($trimmedtext, '<table');
	if ($lasttable !== false)
	{
		$tablecheck = substr($trimmedtext, $lasttable);

		// Don't have the end, so strip the tag
		if (strpos($tablecheck, '>') === false)
		{
			$trimmedtext = substr($trimmedtext, 0, $lasttable);
			$trimmedlength -= $lasttable;
		}
	}

	// ##### <td>
	$lasttd = strripos($trimmedtext, '<td');
	if ($lasttd !== false)
	{
		$tdcheck = substr($trimmedtext, $lasttd);

		// Don't have the end, so find it
		if (strpos($tdcheck, '>') === false)
		{
			$remainstring = substr($text, $trimmedlength);

			$endtdpos = strpos($remainstring, '>') + 1;

			if ($endtdpos != false)
			{
				$trimmedtext .= substr($remainstring, 0, $endtdpos);
				$trimmedlength += $endtdpos;
			}
		}
	}


	// ##### <font>
	$lastfont = strripos($trimmedtext, '<font');
	if ($lastfont !== false)
	{
		$fontcheck = substr($trimmedtext, $lastfont);

		if (strpos($fontcheck, '>') === false)
		{
			$trimmedtext = substr($trimmedtext, 0, $lastfont);
			$trimmedlength -= $lastfont;
		}

	}
	// Start checking normal HTML tags
	preg_match_all("/(<([\w]+)[^>]*>)/", $trimmedtext, $opentags);
	preg_match_all("/(<\/([\w]+)[^>]*>)/", $trimmedtext, $closetags);

	$opentags = array_count_values(array_reverse($opentags[2]));
	$closetags = array_count_values(array_reverse($closetags[2]));

	foreach ($opentags AS $otag => $value)
	{
		$otag = trim($otag);

		switch ($otag)
		{
			case 'br':
			case 'hr':
			case 'img':
				continue;

			default:

			if ($closetags[$otag] != $value)
			{
				for ($i = $closetags[$otag]; $i < $value; $i++)
				{
					$trimmedtext .= '</' . $otag . '>';
				}
			}
		}
	}

	return trim($trimmedtext);
}

// ########################## Construct Categories ############################
function construct_categories($catinfo, $cat = 0)
{
	global $catlevel;

	$catarray = array();

	if (!$catinfo)
	{
		return $catarray;
	}

	foreach ($catinfo AS $cats)
	{
		if ($cats['parent'] == $cat AND $cats['catid'] != $cat)
		{
			$catlevel++;
			$cats['level'] = $catlevel;

			$catarray[$cats['catid']] = $cats;

			if ($subcatinfo = construct_categories($catinfo, $cats['catid']))
			{
				foreach ($subcatinfo AS $subcatid => $subcat)
				{
					$catarray[$subcat['catid']] = $subcat;
				}
			}
			$catlevel--;
		}
	}

	return $catarray;
}

// ########################### Find Category Children #########################
function fetch_category_children($cat = 0)
{
	global $vbulletin;

	$catarray = array($cat);

	$subcatarray = construct_categories($vbulletin->adv_dyna_cats, $cat);

	if (!empty($subcatarray))
	{
		$catarray = array_merge($catarray, array_keys($subcatarray));
	}

	return $catarray;
}

// ###################### Category Options #######################
function cat_opt($var, $chkcatid = '')
{
	global $vba_dyna, $vbulletin, $catid, $entry;

	if (!$chkcatid)
	{
		if (intval($catid))
		{
			$chkcatid = $catid;
		}
		else if ($entry['catid'])
		{
			$chkcatid = $entry['catid'];
		}
	}

	return ($vbulletin->adv_dyna_cats[$chkcatid]['options'] & $vba_dyna->_categoryopts[$var]) ? true : false;
}

// ####################### Construct Category User Options ############################
function cat_user_opt($var, $chkcatid = 0)
{
	global $vba_dyna, $vbulletin, $catid;

	if ($catid AND !$chkcatid)
	{
		$chkcatid = $catid;
	}

	if (!$chkcatid)
	{
		return false;
	}

	$catinfo =& $vbulletin->adv_dyna_cats[$chkcatid];

	if (!$catinfo['catuserid'] OR $catinfo['catuserid'] == $vbulletin->userinfo['userid'])
	{
		return true;
	}

	return ($catinfo['useroptions'] & $vba_dyna->_catuseropts[$var]) ? true : false;
}

// ############################ Fetch Page Data ###############################
function fetch_page_data($fromtable, $wherequery, $jointables = array(), $perpage = 0, $count = false)
{
	global $vbulletin, $vba_options, $_REQUEST, $search;

	if ($count !== false)
	{
		$pagedata['count'] = $count;
	}
	else
	{
		if (!empty($wherequery))
		{
			$querywhere = 'WHERE ' . implode(' AND ', $wherequery);
		}

		if (!empty($jointables))
		{
			foreach ($jointables AS $jointable)
			{
				if ($jointable)
				{
					$leftjoin .= ' LEFT JOIN ' . TABLE_PREFIX . $jointable;
				}
			}
		}

	  $pagedata = $vbulletin->db->query_first("
  		SELECT COUNT(*) AS count
  		FROM " . TABLE_PREFIX . $fromtable . "
  		$leftjoin
			$querywhere
	  ");
	}

	$pagedata['pagenumber'] = intval($_REQUEST['page']);

	// Work out pages & limits
	if (!$pagedata['pagenumber'])
	{
		$pagedata['pagenumber'] = 1;
	}

  $pagedata['perpage'] = ($perpage ? $perpage : $vba_options['dyna_perpage']);

	$pagedata['minlimit'] = intval(($pagedata['pagenumber'] - 1) * $pagedata['perpage'] + 1);
	$pagedata['maxlimit'] = intval($pagedata['pagenumber'] * $pagedata['perpage']);

	if ($pagedata['maxlimit'] > $pagedata['count'])
	{
		$pagedata['maxlimit'] = $pagedata['count'];
		if ($pagedata['minlimit'] > $pagedata['count'])
		{
		  $pagedata['minlimit'] = $pagedata['count'] - $pagedata['perpage'];
		}
	}
	if ($pagedata['minlimit'] <= 0)
	{
	  $pagedata['minlimit'] = 1;
	}

	$pagedata['pagecount'] = ceil($pagedata['count'] / $pagedata['perpage']);

	return $pagedata;
}

// ##### Check Password #######################################################
function check_category_password($catid, $printerror = true, $submitted = false)
{
	global $vbulletin, $vbphrase;

	$catinfo = $vbulletin->adv_dyna_cats[$catid];

	if ((!$catinfo['password'] AND !$catinfo['parentpass']) OR !cat_opt('canhavepassword', $catid))
	{
		return true;
	}

	if ($catinfo['parentpass'] AND !$catinfo['password'])
	{
		$checkpass = $vbulletin->adv_dyna_cats[$catinfo['parentpass']]['password'];
		$checkcatid = $catinfo['parentpass'];
	}
	else
	{
		$checkpass = $catinfo['password'];
		$checkcatid = $catid;
	}

	if (md5($vbulletin->userinfo['userid'] . $checkpass) == fetch_bbarray_cookie('catpassword', $checkcatid))
	{
		return true;
	}

	if ($printerror)
	{
		eval(standard_error(
			fetch_error(ADV_DYNA_PREFIX . '_categorypassword',
				$vbphrase['category'],
				$vbulletin->session->vars['sessionurl'],
				$catinfo['catid'],
				iif($submitted, fetch_error(ADV_DYNA_PREFIX . '_invalid_password'))
			)
		));
	}

	return false;
}

// ## Fetch Ignored Userids ###################################################
function fetch_ignored_users($catid = 0)
{
	global $vbulletin;

	$ignusers = fetch_coventry();

	if ($vbulletin->userinfo['ignorelist'])
	{
		if (!is_array($ignusers))
		{
			$ignusers = array();
		}

		$ignusers = array_merge($ignusers, explode(' ', $vbulletin->userinfo['ignorelist']));
	}

	if (!empty($ignusers))
	{
		return implode(',', $ignusers);
	}

	return false;
}

// ##### Fetch Formated Filesize ##############################################
function fetch_rfilesize($filesize, $dec = 2)
{
	global $vbphrase;

	foreach (array('GB' => 1073741824, 'MB' => 1048576, 'KB' => 1024) AS $ext => $limit)
	{
		if ($filesize >= $limit)
		{
			return vb_number_format($filesize / $limit, $dec) . ' ' . $ext;
		}
	}

	return intval($filesize) . ' ' . $vbphrase['bytes'];
}

// ##### Fetch plural #########################################################
function fetch_possessive($text)
{
	global $vbphrase;

	return $text . '\'' . iif(substr($text, -1) != 's', $vbphrase['possessive_s']);
}

// ##### Option Phrases #######################################################
function fetch_option_phrases()
{
	global $vbphrase, $vba_options;

	$vowels = array('a', 'e', 'i', 'o', 'u');

	$vbphrase['entry'] = $vba_options['dyna_phrase_entry'];
	$vbphrase['entries'] = $vba_options['dyna_phrase_entry_plural'];
	$vbphrase['category'] = $vba_options['dyna_phrase_category'];
	$vbphrase['categories'] = $vba_options['dyna_phrase_category_plural'];
	$vbphrase['module'] = $vba_options['dyna_phrase_module'];
	$vbphrase['modules'] = $vba_options['dyna_phrase_module_plural'];

	$vbphrase['entry_lwr'] = strtolower($vba_options['dyna_phrase_entry']);
	$vbphrase['entries_lwr'] = strtolower($vba_options['dyna_phrase_entry_plural']);
	$vbphrase['category_lwr'] = strtolower($vba_options['dyna_phrase_category']);
	$vbphrase['categories_lwr'] = strtolower($vba_options['dyna_phrase_category_plural']);
	$vbphrase['module_lwr'] = strtolower($vba_options['dyna_phrase_module']);
	$vbphrase['modules_lwr'] = strtolower($vba_options['dyna_phrase_module_plural']);

	$vbphrase['a_entry'] = iif(in_array(substr($vbphrase['entry_lwr'], 0, 1), $vowels), $vbphrase['an'], $vbphrase['a']) . ' ' . $vbphrase['entry'];
	$vbphrase['a_category'] = iif(in_array(substr($vbphrase['category_lwr'], 0, 1), $vowels), $vbphrase['an'], $vbphrase['a']) . ' ' . $vbphrase['entry'];

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_option_phrases')) ? eval($hook) : false;
}

// ##### Fetch Private Entries ################################################
function fetch_private_entryids()
{
	global $vbulletin, $vba_options, $condition, $wherequery;

	// Grab private entries to exclude
	if (!$vba_options['dyna_buddyentries'])
	{
		return;
	}

	$querywhere = '';

	$buddylist = array();
	$excludeentry = array();
	$priventries = $vbulletin->db->query_read("
		SELECT entries.entryid, entries.userid, buddylist
		FROM " . TABLE_PREFIX . $condition['fromtable'] . "
		" . iif($condition['join'], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join']) . "
		LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (entries.userid = usertextfield.userid)
		WHERE private = 1
			AND entries.userid != " . $vbulletin->userinfo['userid'] . "
			$querywhere
	");
	while ($pentry = $vbulletin->db->fetch_array($priventries))
	{
		if (trim($pentry['buddylist']))
		{
			if (!$buddylist[$pentry['userid']])
			{
				$buddylist[$pentry['userid']] = explode(' ', $pentry['buddylist']);
			}

			if (in_array($vbulletin->userinfo['userid'], $buddylist[$pentry['userid']]))
			{
				continue;
			}
		}

		$excludeentry[] = $pentry['entryid'];
	}

	if (!empty($excludeentry))
	{
		$wherequery[] = 'entries.entryid NOT IN(' . implode(',', $excludeentry) . ')';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_private_entryids')) ? eval($hook) : false;

	$vbulletin->db->free_result($priventries);
}

// ##### Fetch Image Path #####################################################
function fetch_upload_path($userid, $implode = true)
{
	$idarray = preg_split('//', $userid, -1, PREG_SPLIT_NO_EMPTY);

	if ($implode)
	{
		return implode('/', $idarray);
	}

	return $idarray;
}

// ##### Fetch Entrybit Fields ################################################
function fetch_entrybit_fields($options = array(), $hasoptions = false, $browseentries = false)
{
	global $vba_options, $show;
	global $entrycount;

	// Set for the construct_entrybits() function
	$entrycount = 0;

	if (empty($options) AND $hasoptions == false)
	{
		$options = $vba_options['dyna_entrybitfields'];
	}

	$fields = array(
		'avatar',
		'category',
		'caticon',
		'edit_button',
		'entry_options',
		'firstattach',
		'folder',
		'icon',
		'last_reply',
		'online_status',
		'preview',
		'rating',
		'replies',
		'reply_button',
		'user_title',
		'user_rank',
		'views'
	);

	foreach ($fields AS $fieldname)
	{
		$show['entrybit_' . $fieldname] = false;
		if (in_array($fieldname, $options))
		{
			$show['entrybit_' . $fieldname] = true;
		}
	}

	$show['entrybit_attach'] = false;
	if ($vba_options['dyna_entrybit_showattach'] AND ($browseentries OR $show['entrybit_firstattach']))
	{
		$show['entrybit_attach'] = true;
	}

	if (!$vba_options['dyna_allowreplies'])
	{
		$show['entrybit_replies'] = false;
		$show['entrybit_last_reply'] = false;
	}

	if (!$vba_options['dyna_entry_icons'])
	{
		$show['entrybit_icon'] = false;
	}

	$show['replyclass'] = '';

	if ($show['entrybit_replies'])
	{
		$show['replyclass'] = 'alt1';
	}

	if ($show['entrybit_views'])
	{
		if ($show['replyclass'] == 'alt2' OR !$show['replyclass'])
		{
			$show['viewsclass'] = 'alt1';
		}
		else
		{
			$show['viewsclass'] = 'alt2';
		}
	}

	if ($show['viewsclass'] == 'alt1')
	{
		$show['categoryclass'] = 'alt2';
	}
	else
	{
		$show['categoryclass'] = 'alt1';
	}

	if ($show['entrybit_views'])
	{
		$show['inlinemodclass'] = ($show['viewsclass'] == 'alt1') ? 'alt2' : 'alt1';
	}
	else if ($show['entrybit_replies'])
	{
		$show['inlinemodclass'] = ($show['replyclass'] == 'alt1') ? 'alt2' : 'alt1';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_entrybit_fields')) ? eval($hook) : false;
}

// ##### Fetch Avatar URL #####################################################
function fetch_full_avatar_url(&$info)
{
	global $vbulletin;

	if (!$vbulletin->userinfo['showavatars'])
	{
		return false;
	}

	if ($info['avatarpath'])
	{
		$info['avatarpath'] = $vbulletin->options['bburl'] . '/' . $info['avatarpath'];
		return true;
	}
	else if ($info['hascustom'])
	{
		if ($vbulletin->options['usefileavatar'])
		{
			$info['avatarpath'] = $vbulletin->options['bburl'] . '/' . $vbulletin->options['avatarurl'] . '/avatar' . $info['userid']. '_' . $info['avatarrevision'] . '.gif';
			return true;
		}
		else
		{
			$info['avatarpath'] = $vbulletin->options['bburl'] . '/image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $info['userid'] . '&amp;dateline=' . $info['avatardateline'];
			return true;
		}
	}

	return false;
}

// ##### Fetch Attachment Folder ##############################################
function fetch_attach_folder($userid)
{
	global $vba_options;

	if ($vba_options['dyna_attachurl'])
	{
		return $vba_options['dyna_attachurl'] . '/' . fetch_upload_path($userid);
	}

	return $attachpath = 'attachment.php?' . $vbulletin->session->vars['sessionurl'] . 'attachmentid=';
}

// ##### Fetch Attachment Thumb ###############################################
function fetch_attach_thumb_url($attach, $path = false)
{
	global $vba_options, $stylevar;

	if (!$attach['hasthumb'])
	{
		return $stylevar['imgdir_attach'] . '/' . $attach['extension'] . '.gif';
	}

	$path = fetch_attach_folder(($attach['attachuserid'] ? $attach['attachuserid'] : $attach['userid']));

	if (isset($attach['attachdateline']))
	{
		$attach['dateline'] = $attach['attachdateline'];
	}

	if ($vba_options['dyna_attachurl'])
	{
		return $path . '/' . $attach['filename'] . '_' . $attach['dateline'] . ($attach['hasthumb'] != 2 ? '_thumb' : '') . '.' . $attach['extension'];
	}

	return $path . $attach['attachmentid'] . '&amp;dateline=' . $attach['dateline'] . ($attach['hasthumb'] != 2 ? '&amp;thumb=1' : '');
}

// ##### Check custom field cats ##############################################
function check_custom_field_cats(&$field, &$entry)
{
	if ($field['catids'] == 'all')
	{
		return true;
	}

	if (in_array($entry['catid'], $field['catids']))
	{
		return true;
	}

	if (!$field['incsubs'])
	{
		return false;
	}

	if (in_array($entry['catid'], $field['subcats']))
	{
		return true;
	}

	return false;
}

// ##### Check Custom Date Value ##############################################
function check_custom_dateline_value($name = 'customdate')
{
	global $vba_dyna, $vbulletin, $errors, $errorhighlight, $vba_options, $vbphrase;

	// Figure out the format we're using
	if ($vba_options['dyna_add_dateformat'] == 'd-m-y')
	{
		$dateformat = 'j-n';
	}
	else
	{
		$dateformat = 'n-j';
	}
	
	$dateformat .= '-Y-G-i-';
	
	if ($vba_options['dyna_add_timeformat'] != '24hour')
	{
		$dateformat .= 'A-';
	}
	
	$dateformat .= 's';

	// Check it
	if (implode('-', array_values($vbulletin->GPC[$name])) != vbdate($dateformat, fetch_custom_datestamp($name), false, false))
	{
		eval('$errors[] = "' . fetch_error(ADV_DYNA_PREFIX . '_invalid_dateline', ($name == 'pubdate' ? $vbphrase['publishing'] : $vbphrase['entry'])) . '";');
		$errorhighlight[$name] = true;
	}
}

// ##### Fetch custom datestamp ###############################################
function fetch_custom_datestamp($name = 'customdate')
{
	global $vbulletin;

	$cdate =& $vbulletin->GPC[$name];

	if (!$cdate['hour'] AND !$cdate['minute'] AND !$cdate['month'] AND !$cdate['day'] AND !$cdate['year'])
	{
		return 0;
	}

	return mktime(
		$cdate['hour'],
		$cdate['minute'],
		$cdate['second'],
		$cdate['month'],
		$cdate['day'],
		$cdate['year']
	) + $vbulletin->options['hourdiff'];
}

// ##### Construct Date Select Menus ##########################################
// @param - name of select fields from form
// @param - selected date - set to boolean false for no selection
function construct_date_select($arrayname, $selecteddate = 0)
{
	global $vbulletin, $vba_options, $vbphrase, $haderrors;

	$curdatearray = explode('-', vbdate('n-j-Y-G-i-s', TIMENOW, false, false));

	if (!$vbulletin->GPC['fromquickreply'] AND ($vbulletin->GPC['preview'] OR $haderrors))
	{
		$dateselected = array(
			0 => intval($vbulletin->GPC[$arrayname]['month']),
			1 => intval($vbulletin->GPC[$arrayname]['day']),
			2 => intval($vbulletin->GPC[$arrayname]['year']),
			3 => intval($vbulletin->GPC[$arrayname]['hour']),
			4 => intval($vbulletin->GPC[$arrayname]['minute']),
			5 => intval($vbulletin->GPC[$arrayname]['second'])
		);
	}
	else if ($selecteddate)
	{
		$dateselected = explode('-', vbdate('n-j-Y-G-i-s', $selecteddate, false, false));
	}
	else if ($selecteddate !== false)
	{
		$dateselected =& $curdatearray;
	}

	if ($dateselected[3] == 0 AND $selecteddate !== false)
	{
		$forceam = true;
		$dateselected[3] = 12;
	}

	$select = array(
		'months' => '',
		'days' => '',
		'years' => '',
		'hours' => '',
		'minutes' => '',
		'seconds' => $dateselected[5]
	);

	$monthphrases = array(
		1 => 'january',
		2 => 'february',
		3 => 'march',
		4 => 'april',
		5 => 'may',
		6 => 'june',
		7 => 'july',
		8 => 'august',
		9 => 'september',
		10 => 'october',
		11 => 'november',
		12 => 'december'
	);

	// Months
	foreach ($monthphrases AS $month => $monphrase)
	{
		$select['months'] .= '<option value="' . $month . '"' . iif($month == $dateselected[0], ' selected="selected"') . '>' . $vbphrase[$monphrase] . '</option>';
	}

	// Days
	foreach (range(1, 31) AS $day)
	{
		$select['days'] .= '<option value="' . $day . '"' . iif($day == $dateselected[1], ' selected="selected"') . '>' . $day . '</option>';
	}

	// Years
	$yearvar = 10;
	if ($arrayname == 'pubdate')
	{
		$curdatearray[2];
		$yearvar = -2;
	}

	foreach (range($curdatearray[2], ($curdatearray[2] - $yearvar)) AS $yearsub)
	{
		$select['years'] .= '<option value="' . $yearsub . '"' . iif($yearsub == $dateselected[2], ' selected="selected"') . '>' . $yearsub . '</option>';
	}

	// Hours
	$select['merid'] = 'AM';
	if ($dateselected[3] >= 12 AND !$forceam AND $vba_options['dyna_add_timeformat'] != '24hour')
	{
		$select['merid'] = 'PM';

		if ($dateselected[3] != 12)
		{
			$dateselected[3] -= 12;
		}
	}


	foreach (range(1, ($vba_options['dyna_add_timeformat'] == '24hour' ? 24 : 12)) AS $hour)
	{
		$select['hours'] .= '<option value="' . $hour . '"' . iif($hour == $dateselected[3], ' selected="selected"') . '>' . $hour . '</option>';
	}

	// Minutes
	foreach (range(0, 59) AS $minute)
	{
		if ($minute < 10)
		{
			$minute = '0' . $minute;
		}
		$select['minutes'] .= '<option value="' . $minute . '"' . iif($minute == $dateselected[4] AND $dateselected[4], ' selected="selected"') . '>' . $minute . '</option>';
	}

	return $select;
}

// ##### Format Text Editor ###################################################
function format_vb_text_editor()
{
	global $vbulletin, $textareacols, $selectedicon;

	require_once(DIR . '/includes/functions_editor.php');
	$textareacols = fetch_textarea_width();

	$vbulletin->templatecache['posticons'] = str_replace(
		'$GLOBALS[\'vbulletin\']->options[\'cleargifurl\']',
		'$GLOBALS[\'vbulletin\']->options[\'bburl\'] . "/" . $GLOBALS[\'vbulletin\']->options[\'cleargifurl\']',
		$vbulletin->templatecache['posticons']
	);

	// Replace custom BB code images
	if (!empty($vbulletin->bbcodecache))
	{
		foreach ($vbulletin->bbcodecache AS $bbcodeid => $bbcodeinfo)
		{
			if ($bbcodeinfo['buttonimage'])
			{
				$vbulletin->bbcodecache[$bbcodeid]['buttonimage'] = $vbulletin->options['bburl'] . '/' . $bbcodeinfo['buttonimage'];
			}
		}
	}

	// Fake IE6 to so it won't try to use the IE7 popups
	$vbulletin->templatecache['editor_clientscript'] = str_replace(
		'"clientscript',
		'"' . $vbulletin->options['bburl'] . '/clientscript',
		$vbulletin->templatecache['editor_clientscript']
	) . '
		<script type=\"text/javascript\">
    <!--
			var is_ie7 = false;
    -->
    </script>';

}

// ##### Fetch module template name #########################################
function fetch_module_template_name()
{
	global $mod_options, $vba_options, $vba_colwidths, $dyna_colname, $show;

	if ($mod_options['dyna_newrand_templatename'])
	{
		$templatename = $mod_options['dyna_newrand_templatename'];
	}
	else
	{
		$templatename = ($vba_options['dyna_entrybitexpanded']) ? 'expanded' : 'simple';
	}

	if (!$mod_options['dyna_newrand_dynatemp'] OR $templatename == 'lean')
	{
		return $templatename;
	}

	if ($templatename == 'expanded')
	{
		return ($vba_colwidths[$dyna_colname] >= 275) ? $templatename : 'lean';
	}
	else
	{
		$minwidth = 140;
		if ($show['entrybit_replies'])
		{
			$minwidth += 25;
		}

		if ($show['entrybit_views'])
		{
			$minwidth += 25;
		}

		if ($show['entrybit_category'])
		{
			$minwidth += 75;
		}

		if ($show['entrybit_folder'])
		{
			$minwidth += 10;
		}

		if ($show['entrybit_caticon'])
		{
			$minwidth += 10;
		}

		if ($show['entrybit_last_reply'])
		{
			$minwidth += 150;
		}

		if ($show['entrybit_icon'])
		{
			$minwidth += 20;
		}

		if ($show['entrybit_firstattach'])
		{
			$minwidth += $vba_options['dyna_thumbsize'];
		}

		return ($vba_colwidths[$dyna_colname] >= $minwidth) ? $templatename : 'lean';
	}
}

// ##### Fetch Human Verification #############################################
function fetch_human_verify($area)
{
	global $vbulletin, $vba_options;

	if (IS_VB_37)
	{
		if ($vbulletin->options['hv_type'] AND in_array($area, $vba_options['dyna_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			if ($vbulletin->options['hv_type'] == 'Image')
			{
				$vbulletin->templatecache['humanverify_image'] = str_replace(
					'"image.php',
					'"' . $vbulletin->options['bburl'] . '/image.php',
					$vbulletin->templatecache['humanverify_image']
				);
			}
			
			require_once(DIR . '/includes/class_humanverify.php');
			$verification =& vB_HumanVerify::fetch_library($vbulletin);
			return $verification->output_token();
		}
	}
	else
	{
		global $vbphrase;

		// Image verification
		if ($vbulletin->options['regimagetype'] AND in_array($area, $vba_options['dyna_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			require_once(DIR . '/includes/functions_regimage.php');
			$imagehash = fetch_regimage_hash();
	
			$vbulletin->templatecache['imagereg'] = str_replace(
				'"image.php',
				'"' . $vbulletin->options['bburl'] . '/image.php',
				$vbulletin->templatecache['imagereg']
			);
	
			eval('$imagereg = "' . fetch_template('imagereg') . '";');
			
			return $imagereg;
		}
	}
}

// ##### Check Human Verification #############################################
function check_human_verify($area, $printerror = true)
{
	global $vbulletin, $vba_options;

	if (IS_VB_37)
	{
		if ($vbulletin->options['hv_type'] AND in_array($area, $vba_options['dyna_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			$vbulletin->input->clean_gpc('p', 'humanverify', TYPE_ARRAY);

			require_once(DIR . '/includes/class_humanverify.php');
			$verify =& vB_HumanVerify::fetch_library($vbulletin);
			if (!$verify->verify_token($vbulletin->GPC['humanverify']))
			{
				if ($printerror)
				{
					eval(standard_error(fetch_error($verify->fetch_error())));
				}
				else
				{
					return fetch_error($verify->fetch_error());
				}
			}
		}
	}
	else
	{
		if ($vbulletin->options['regimagetype'] AND in_array($area, $vba_options['dyna_imageverify']) AND !$vbulletin->userinfo['userid'])
		{
			global $vbphrase;

			$vbulletin->input->clean_array_gpc('p', array(
				'imagehash' => TYPE_STR,
				'imagestamp' => TYPE_STR
			));

			require_once(DIR . '/includes/functions_regimage.php');
			if (!verify_regimage_hash($vbulletin->GPC['imagehash'], $vbulletin->GPC['imagestamp']))
			{
				eval(standard_error(fetch_error('register_imagecheck')));
	  	}
		}
	}
}

?>