<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Fetch Blog Postbit ###################################################
function fetch_dyna_postbit($post, $type = 'normal')
{
	global $vbulletin, $vba_dyna, $vba_options, $vbphrase, $show, $bbcode_parser, $highlightposts, $highlight, $stylevar, $postcount, $spacer_open, $spacer_close, $dyna_modid, $mod_options, $permissions, $modid, $masteruserid, $ranks_replaced, $sig_cache;

	$postid = 'p_' . $post['postid'];

	$post['checkbox_value'] = 0;

	if (!$vba_options['dyna_allow_post_title'])
	{
		$post['title'] = '';
	}

	// Dateline
	$post['postdate'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
	$post['posttime'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);

	// Status Icon
	$post['statusicon'] = ($post['dateline'] > $vbulletin->userinfo['lastvisit']) ? 'new' : 'old';
	$post['statustitle'] = $vbphrase[$post['statusicon']];

	// Show IP address
	$post['iplogged'] = '';
	if ($post['ip'])
	{
		if ($vbulletin->options['logip'] == 2)
		{
			$show['ip'] = true;
		}
		else if ($vbulletin->options['logip'] == 1 AND $show['modopts'])
		{
			$show['ip'] = false;
			eval('$post[\'iplogged\'] .= "' . fetch_template('postbit_ip') . '";');
		}
	}

	// ##### Deleted post
	if ($post['visible'] == 2)
	{
		$post['del_date'] = vbdate($vbulletin->options['dateformat'], $post['del_dateline']);
		$post['del_time'] = vbdate($vbulletin->options['timeformat'], $post['del_dateline']);

		eval('$postbit = "' . fetch_template(ADV_DYNA_PREFIX . '_postbit_deleted') . '";');
		eval('$postbits = "' . fetch_template('postbit_wrapper') . '";');

		return $postbits;
	}

	$postcount++;
	$post['postcount'] = $postcount;

	// Parse the bbcode
	if ($type == 'gbook')
	{
		$post['message'] = $bbcode_parser->do_parse(
			$post['pagetext'],
			$mod_options['dyna_gbook_html'],
			$post['allowsmilie'],
			$mod_options['dyna_gbook_bbcode'],
			$mod_options['dyna_gbook_bbimgcode']
		);
	}
	else
	{
		$post['message'] = $bbcode_parser->do_parse(
			$post['pagetext'],
			cat_opt('allow_post_html'),
			iif(cat_opt('allow_post_smilies'), $post['allowsmilie'], 0),
			cat_opt('allow_post_bbcode'),
			cat_opt('allow_post_bbimgcode')
		);
	}

	if (empty($checkperms[$post['userid']]))
	{
		$checkperms[$post['userid']] = cache_permissions($post, false);
	}

	// Highlight search terms
	if ($highlightposts)
	{
		$post['message'] = highlight_keywords($post['message'], $highlight['string'], $highlight['wholeword']);
	}

	// Icon
	$show['messageicon'] = ($post['iconid'] OR $vbulletin->options['showdeficon']) ? true : false;

	if ($vbulletin->options['showdeficon'] AND !$post['iconid'])
	{
		$post['iconpath'] = $vbulletin->options['showdeficon'];
		$post['icontitle'] = $vbphrase['default'];
	}

	// Ranks
	if ($post['rank'])
	{
		if (isset($ranks_replaced[$post['userid']]))
		{
			$post['rank'] = $ranks_replaced[$post['userid']];
		}
		else
		{
			$post['rank'] = str_replace('src="', 'src="' . $vbulletin->options['bburl'] . '/', $post['rank']);
			$ranks_replaced[$post['userid']] = $post['rank'];
		}
	}

	// Set default $show variables
	$show['profile'] = false;
	$show['avatar'] = false;
	$show['buddy'] = false;
	$show['search'] = false;
	$show['emailentry'] = false;
	$show['pmentry'] = false;
	$show['homepage'] = false;
	$show['reputation'] = false;

	// Report post
	$show['reportlink'] = false;
	if ($vbulletin->userinfo['userid'] != $post['userid'] AND !$show['deletedpost'])
	{
		$show['reportlink'] = true;
	}

	// Edit link
	if ($type == 'gbook')
	{
		if (!$show['deletedpost']
			AND (
				// Admin
				($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
				// Editing own post in own guest book
				OR ($masteruserid == $vbulletin->userinfo['userid']
					AND $post['userid'] == $vbulletin->userinfo['userid']
				)
				// Own post in someone else's guest book
				OR ($post['userid'] == $vbulletin->userinfo['userid'] AND $vba_dyna->_permissions['gb_caneditown'])
				// Someone else's post in own guest book
				OR ($masteruserid == $vbulletin->userinfo['userid'] AND $vba_dyna->_permissions['gb_candeleteothersinown'])
			)
		)
		{
			$post['editlink'] = 'guestbook.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editpost&amp;modid=' . $vbulletin->GPC['modid'] . '&amp;masteruserid=' . $vbulletin->GPC['masteruserid'] . '&amp;epostid=' . $post['postid'];
		}
	}
	else
	{
		if (!$show['deletedpost']
			AND (
				($vba_dyna->check_cat_perms('caneditposts') AND $post['userid'] == $vbulletin->userinfo['userid'])
					OR $vba_dyna->check_cat_perms('caneditothersposts')
					OR $show['modopts']
				)
		)
		{
			$post['editlink'] = 'newreply.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editpost&amp;epostid=' . $post['postid'];
		}
	}

	// Reply link
	if ($type == 'gbook')
	{
		if (!$show['deletedpost']
			AND ($masteruserid == $vbulletin->userinfo['userid']
				OR $vba_dyna->_permissions['gb_canreply']
			)
		)
		{
			$post['replylink'] = 'guestbook.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newreply&amp;modid=' . $vbulletin->GPC['modid'] . '&amp;masteruserid=' . $vbulletin->GPC['masteruserid'] . '&amp;epostid=' . $post['postid'];
		}
	}
	else
	{
		if (!$show['deletedpost']
			AND $vba_options['dyna_allowreplies']
			AND $vba_dyna->check_cat_perms('canreply', $post)
			AND cat_opt('open_for_posts', $post['catid'])
			AND cat_user_opt('allow_reply', $post['catid'])
		)
		{
			$post['replylink'] = 'newreply.php?' . $vbulletin->session->vars['sessionurl'] . 'epostid=' . $post['postid'];
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_dyna_postbit')) ? eval($hook) : false;

	// ##### Post was by a user
	if ($post['userid'])
	{
		$post = array_merge($post, convert_bits_to_array($post['options'], $vbulletin->bf_misc_useroptions));

		$post['musername'] = fetch_musername($post);

		$show['profile'] = true;
		$show['buddy'] = true;
		$show['search'] = true;

		// Email, homepage, & PM entries
		if ($post['showemail'] AND $vbulletin->options['displayemails'])
		{
			$show['emailentry'] = true;
		}
		if ($post['homepage'] AND $post['homepage'] != 'http://')
		{
			$show['homepage'] = true;
		}
		if ($vbulletin->options['enablepms'] AND $post['receivepm'])
		{
			$show['pmentry'] = true;
		}

		// User stats
		$post['joindate'] = vbdate($vbulletin->options['registereddateformat'], $post['joindate']);
		$post['posts'] = number_format($post['posts']);

		// Online Status
		fetch_online_status($post, true);

		// Reputation
		if ($vbulletin->options['reputationenable'])
		{
			fetch_reputation_image($post, $checkperms);
			$show['reputation'] = true;
		}

		// Im Icons
		construct_im_icons($post);

		// User Title
		if ($post['customtitle'] == 2)
		{
			$post['usertitle'] = htmlspecialchars_uni($post['usertitle']);
		}

		// Signature
		if ($post['showsignature'] AND $post['signature'] AND ($vbulletin->userinfo['showsignatures'] OR !$vbulletin->userinfo['userid']))
		{
			if (isset($sig_cache[$post['userid']]))
			{
				$post['signature'] = $sig_cache[$post['userid']];
			}
			else
			{
				$post['signature'] = $bbcode_parser->parse($post['signature'], 0, $vbulletin->options['allowsmilies']);
				$sig_cache[$post['userid']] = $post['signature'];
			}
		}
		else
		{
			$post['signature'] = '';
		}

		// Get Avatar
		$show['avatar'] = false;
		$post['avatarurl'] = '';

		fetch_full_avatar_url($post);

		if ($post['avatarpath'])
		{
			$post['avatarurl'] =& $post['avatarpath'];
			$show['avatar'] = true;
		}

	}
	// ##### Post was by a guest
	else
	{
		$post['posts'] = $vbphrase['n_a'];
		$post['joindate'] = $vbphrase['n_a'];
		$post['username'] = $post['postusername'];
		$post['musername'] = fetch_musername($post);
		$post['usertitle'] = $vbphrase['guest'];
	}

	// Print the postbit
	eval('$postbit = "' . fetch_template('postbit') . '";');

	eval('$postbits = "' . fetch_template('postbit_wrapper') . '";');

	return $postbits;
}

// ##### Fetch Postbit Fields & Tables ########################################
function fetch_post_query_fields()
{
	global $vba_options, $vbulletin, $queryfields, $queryjoin;

	$queryfields = 'posts.postid, posts.entryid, posts.pagetext, posts.title, posts.userid, posts.username AS postusername, posts.dateline, posts.ipaddress AS ip, posts.showsignature, posts.visible, user.*, rank, userfield.*, usertextfield.signature';

	$queryjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'user AS user ON (posts.userid = user.userid)
		LEFT JOIN ' . TABLE_PREFIX . 'userfield AS userfield ON (posts.userid = userfield.userid)
		LEFT JOIN ' . TABLE_PREFIX . 'usertextfield AS usertextfield ON (usertextfield.userid = posts.userid)';

	// Icons
	if ($vba_options['dyna_post_icons'] AND cat_opt('allow_post_icons'))
	{
		$queryfields .= ', posts.iconid, icon.title as icontitle, icon.iconpath';
		$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (posts.iconid = icon.iconid)';
	}

	// Avatars
	if ($vbulletin->options['avatarenabled'])
	{
		$queryfields .= ', avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision';
		$queryjoin .= ' LEFT JOIN ' . TABLE_PREFIX . 'avatar AS avatar ON (avatar.avatarid = user.avatarid)
			LEFT JOIN ' . TABLE_PREFIX . 'customavatar AS customavatar ON (customavatar.userid = user.userid)';
	}

	// Smilies
	if (cat_opt('allow_post_smilies'))
	{
		$queryfields .= ', posts.allowsmilie';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_post_query_fields')) ? eval($hook) : false;

}

// ##### Postbit Template Replacements ########################################
function postbit_template_replace($type = 'post')
{
	global $vbulletin, $vba_dyna;

	$vbulletin->templatecache['postbit_ip'] = str_replace(
		'"postings.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "do=getip&amp;p=',
		'"moderate.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "do=getip&amp;' . iif($type == 'gbook', 'type=gbook&amp;') . 'epostid=',
		$vbulletin->templatecache['postbit_ip']
	);

	$showentryreplace = fetch_entry_url($vba_dyna->_entry, 'epostid=');

	$tempname = ($vbulletin->options['legacypostbit']) ? 'postbit_legacy' : 'postbit';

	$vbulletin->templatecache[$tempname] = str_replace(
		array(
			'"editpost.php',
			'"image.php',
			'imwindow',
			'"member.php',
			'"postings.php',
			'"private.php',
			'"profile.php',
			'"sendmessage.php',
			'"report.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "p=',
			'"search.php',
			'"showpost.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "p=$post[postid]&amp;postcount=$post[postcount]',
			'id=\"post$post[postid]\"'
		),
		array(
			'"newreply.php',
			'"' . $vbulletin->options['bburl'] . '/image.php',
			'openimwindow',
			'"' . $vbulletin->options['bburl'] . '/member.php',
			'"moderate.php',
			'"' . $vbulletin->options['bburl'] . '/private.php',
			'"' . $vbulletin->options['bburl'] . '/profile.php',
			'"' . $vbulletin->options['bburl'] . '/sendmessage.php',
			'"misc.php?" . $GLOBALS[\'vbulletin\']->session->vars[\'sessionurl\'] . "do=report&amp;type=' . iif($type == 'gbook', 'gbook&amp;modid=' . $vbulletin->GPC['modid'], 'post') . '&amp;epostid=',
			'"' . $vbulletin->options['bburl'] . '/search.php',
			'"' . $showentryreplace . '$post[postid]#post$post[postid]',
			'id=\"post$postid\"'
		),
		$vbulletin->templatecache[$tempname]
	);

}

// ############################# Subscribed Posts #########################
function send_subscribed_posts($entryid, $moderation = false, $userid = '', $username = '', $message = '')
{
	global $db, $vba_options, $vbulletin, $post;

	if (!$vba_options['dyna_allowsubscribe'])
	{
		return;
	}

	$entry = $db->query_first("
		SELECT entries.entryid, entries.title, catid, posts.dateline
		FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
		INNER JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (posts.entryid = entries.entryid)
		WHERE entries.entryid = $entryid
		ORDER BY dateline DESC
	");

	if (!$moderation)
	{
		$userid = $vbulletin->userinfo['userid'];
	}
	else
	{
		$post['message'] = $message;
		$vbulletin->userinfo['username'] = $username;
	}

	$categoryname = $vbulletin->adv_dyna_cats[$entry['catid']]['title'];

	fetch_entry_url($entry, 'goto=lastpost&amp;epostid=' . $newpostid . '#post' . $newpostid);

	$subscriptions = $db->query("
		SELECT subscriptions.userid, username, email
		FROM " . ADV_DYNA_TABLE_PREFIX . "subscribeentry AS subscriptions
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (subscriptions.userid = user.userid)
		WHERE entryid = '$entryid' AND user.lastactivity > '$entry[dateline]' AND subscriptions.userid != '$userid'
	");
	while ($subscription = $db->fetch_array($subscriptions))
	{
		$username = $subscription['username'];
		eval(fetch_email_phrases(ADV_DYNA_PREFIX . '_subscribe_entry', 0));
		vbmail($subscription['email'], $subject, $message);
	}

}

?>