<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ###################### Function to Construct Categories #####################
function construct_category_perms($catinfo, $cat = 0, $catpermissions)
{
	global $catperms;

	if ($catinfo)
	{
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$catperms[$cats['catid']] = $catpermissions[$cats['catid']];

				if (!empty($catperms[$cats['parent']]))
				{
					// Nothing set for this category, so just use the parent's
					if (empty($catperms[$cats['catid']]))
					{
						$catperms[$cats['catid']] = $catperms[$cats['parent']];
					}
					// Specific permissions set for this category,
					// so we need to merge with the parent's usergroups
					else
					{
						foreach ($catperms[$cats['parent']] AS $groupid => $groupperms)
						{
							if (!isset($catperms[$cats['catid']][$groupid]))
							{
								$catperms[$cats['catid']][$groupid] = $groupperms;
							}
						}
					}
				}

				construct_category_perms($catinfo, $cats['catid'], $catpermissions);
			}
		}
	}
	return $catperms;
}

// ############################## Update Category Cache #######################
function update_category_cache()
{
	global $db, $vba_options, $vbulletin;

	$catsinfo = array();
	$catpermissions = array();

	$getperms = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms");
	while ($perm = $vbulletin->db->fetch_array($getperms))
	{
		$catpermissions[$perm['catid']][$perm['usergroupid']] = unserialize($perm['permissions']);
	}

	$db->free_result($getperms);
	unset($perm);

	$getcats = $db->query_read("
		SELECT catid, title, allowusercats, catuserid, memberscat, parent, parentlist, hasentries, categories.styleid, categories.password, active, valid, categories.options, useroptions, username, membergroupids, usergroupid, caticon
		FROM " . ADV_DYNA_TABLE_PREFIX . "categories AS categories
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
		ORDER BY $vba_options[dyna_catsorder] $vba_options[dyna_catsdir], hasentries
	");
	while ($cats = $vbulletin->db->fetch_array($getcats))
	{
		$cats['catusergroups'] = $cats['usergroupid'];

		if ($cats['membergroupids'])
		{
			$cats['catusergroups'] .= ',' . $cats['catusergroups'];
		}
		unset($cats['membergroupids'], $cats['usergroupid']);
		
		if ($vba_options['dyna_spiderurls'])
		{
			$cats['surl'] = fetch_spider_url($cats['title'], $cats['catid']);
		}
		
		$catsinfo[$cats['catid']] = $cats;
	}

	$db->free_result($getcats);
	unset($cats);

	$catperms = construct_category_perms($catsinfo, 0, $catpermissions);

	$categoryinfo = array();

	$catcount = 0; // Make sure this is set since it's global within the function
	if ($catinfo = construct_categories($catsinfo, 0, -1))
	{
		foreach ($catinfo AS $cats)
		{
			// Find any parent passwords and add them to save processing later
			if (cat_opt('canhavepassword', $cats['catid']) AND !$cats['password'])
			{
				$parentlist = explode(',', $cats['parentlist']);

				if (!empty($parentlist))
				{
					foreach ($parentlist AS $pcatid)
					{
						if ($catsinfo[$pcatid]['password'] AND cat_opt('childpass', $pcatid))
						{
							$cats['parentpass'] = $pcatid;
						}
					}
				}
			}

			$categoryinfo[$cats['catid']] = $cats;
			if ($catperms[$cats['catid']])
			{
				$categoryinfo[$cats['catid']]['permissions'] = $catperms[$cats['catid']];
			}
		}
	}

	build_datastore(ADV_DYNA_PREFIX . '_cats', serialize($categoryinfo), 1);
}

// ##################### Update Moderator Cache ########################
function update_dyna_moderator_cache()
{
	global $db;

	$mods = array();

	$getmods = $db->query("
		SELECT user.userid, user.username, catid
		FROM " . ADV_DYNA_TABLE_PREFIX . "moderator AS entries_moderator
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (entries_moderator.userid = user.userid)
		ORDER BY catid, username
	");
	while ($mod = $db->fetch_array($getmods))
	{
		$children = fetch_category_children($mod['catid']);

		foreach ($children AS $mcat)
		{
			$mods[$mcat][$mod['userid']] = $mod['username'];
		}

		$mods[$mcat] = array_unique($mods[$mcat]);
	}

	$db->free_result($getmods);

	build_datastore(ADV_DYNA_PREFIX . '_mods', serialize($mods), 1);
}

// ####################### Insert Parentlist ###########################
function insert_category_parentlist($parentid)
{
	global $db, $newcatid, $vbulletin;

	if ($parentid)
	{
		$cat = $db->query_first("SELECT parentlist FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = $parentid");
	}

	$plist = $newcatid;

	if ($cat['parentlist'])
	{
		$plist .= ",$cat[parentlist]";
	}
	else if ($parentid)
	{
		$plist .= ",$parentid";
	}

	$vbulletin->db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET parentlist = '$plist' WHERE catid = $newcatid");
}

// ########################### Find Parent Directories ########################
function construct_parents($catinfo, $catid)
{
	global $parentlist;

	foreach ($catinfo AS $subs)
	{
		if ($subs['catid'] == $catid)
		{
			$parentlist[] = $subs['catid'];
			construct_parents($catinfo, $subs['parent']);
		}
	}
	return $parentlist;

}

// ######################## Rebuild Parents ############
function rebuild_parents($catid = 0, $echooutput = false)
{
	global $db, $parentlist;

	$cats = array();

	$getcats = $db->query_read("SELECT catid, title, parent FROM " . ADV_DYNA_TABLE_PREFIX . "categories ORDER BY parent");
	while ($catinfo = $db->fetch_array($getcats))
	{
		$cats[$catinfo['catid']] = $catinfo;
	}

	$db->free_result($getcats);
	unset($catinfo);

	if ($catid)
	{
		$buildcats = fetch_category_children($catid);
	}
	else
	{
		$buildcats = array_keys($cats);
	}

	foreach ($buildcats AS $catids)
	{
		$cat =& $cats[$catids];

		$parentlist = array();
		$parentlist[] = $cat['catid'];
		construct_parents($cats, $cat['parent']);

		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET parentlist = '" . implode(',', $parentlist) . "' WHERE catid = '$cat[catid]'");

		if ($echooutput)
		{
			echo "Updated $cat[title]<br />";
		}
	}
}

// ##### Fetch Allowed Parents ################################################
/*
 * This function allows us to see which parent categories should be visible
 * since it is possible for a user to own a category which is a sub-cat of
 * a category they do not have permissions for.
*/
function fetch_allowed_parents($type = '')
{
	global $vbulletin;

	if (empty($vbulletin->adv_dyna_cats))
	{
		return array();
	}

	foreach ($vbulletin->adv_dyna_cats AS $cats)
	{
		if ($cats['catuserid'] == $vbulletin->userinfo['userid'] AND $cats['active'])
		{
			$plist = explode(',', $cats['parentlist']);

			foreach ($plist AS $parentid)
			{
				if ($vbulletin->adv_dyna_cats[$parentid]['valid'] AND $vbulletin->adv_dyna_cats[$parentid]['active'] AND $parentid != $cats['catid'] AND ($type != 'submitcat' OR ($type == 'submitcat' AND $cats['allowusercats'])))
				{
					$allowedparents[] = $parentid;
				}
			}
		}
	}

	if (empty($allowedparents))
	{
		return array();
	}

	return array_unique($allowedparents);
}

// ##### Update Category Last Entry/Post Counts ###############################
function update_cat_lasts(&$entry, $addsub = ' - ')
{
	global $vbulletin;

	$lastcounters = fetch_cat_lasts($entry);

	$vbulletin->db->query_write("
		UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
			entrycount = entrycount $addsub 1,
			postcount = postcount $addsub $entry[posts]
			$lastcounters
		WHERE catid = $entry[catid]
	");

	// Make sure we still have some entries, otherwise remove the memberscats entry from the db
	$memberscats = $vbulletin->db->query_first("
		SELECT entryid
		FROM " . ADV_DYNA_TABLE_PREFIX . "entries
		WHERE userid = $entry[userid]
			AND catid = $entry[catid]
			AND valid = 1
			AND draft = 0
			AND private = 0
	");

	if (!$memberscats['entryid'])
	{
		$vbulletin->db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats WHERE userid = $entry[userid] AND catid = $entry[catid]");
	}
	else
	{
		$lastcounters = fetch_cat_lasts($entry, 'members');
		$vbulletin->db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET
				entrycount = entrycount $addsub 1,
				postcount = postcount $addsub $entry[posts]
				$lastcounters
			WHERE catid = $entry[catid]
				AND userid = $entry[userid]
		");
	}
}

// ##### Fetch Category Last Entry / Post Counts ##############################
function fetch_cat_lasts(&$entry, $type = '')
{
	global $vbulletin, $plusminus;

	if ($type == 'members')
	{
		$table = 'memberscats';
		$anduser = 'AND userid = ' . $entry['userid'];
		$andentryuser = 'AND entry.userid = ' . $entry['userid'];
	}
	else
	{
		$table = 'categories';
	}

	$catlast = $vbulletin->db->query_first("
		SELECT lastentryid, lastpostentryid
		FROM " . ADV_DYNA_TABLE_PREFIX . $table . "
		WHERE catid = $entry[catid] $anduser
	");

	// New last entry
	if (
		($plusminus == '-'
			AND $catlast['lastentryid'] == $entry['entryid']
		) OR
		($plusminus == '+'
			AND $catlast['lastentryid'] != $entry['entryid']
		)
	)
	{
		$updatelastentry = true;
		$lastentry = $vbulletin->db->query_first("
			SELECT entryid, title, dateline, userid, username
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries
			WHERE catid = $entry[catid]
				AND valid = 1
				AND draft = 0
				AND private = 0
				$anduser
			ORDER BY dateline DESC
		");
	}

	// New last post
	if (
		($plusminus == '-'
			AND $catlast['lastpostentryid'] == $entry['entryid']
		) OR
		($plusminus == '+'
			AND $catlast['lastpostentryid'] != $entry['entryid']
		)
	)
	{
		$updatelastpost = true;
		$lastpost = $vbulletin->db->query_first("
			SELECT postid, post.entryid, post.dateline, post.userid, post.username, entry.title AS entrytitle
			FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (post.entryid = entry.entryid)
			WHERE catid = $entry[catid]
				AND visible = 1
				AND valid = 1
				AND draft = 0
				AND private = 0
				$andentryuser
			ORDER BY post.dateline DESC
		");
	}

	return
		iif($updatelastentry, ",
			lastentryid = '$lastentry[entryid]',
			lastentrytitle = '" . $vbulletin->db->escape_string($lastentry['title']) . "',
			lastentryuserid = '$lastentry[userid]',
			lastentryusername = '" . $vbulletin->db->escape_string($lastentry['username']) . "',
			lastentrydateline = '$lastentry[dateline]'
		") .
		iif($updatelastpost, ",
			lastpostid = '$lastpost[postid]',
			lastpostentryid = '$lastpost[entryid]',
			lastpostentrytitle = '" . $vbulletin->db->escape_string($lastpost['entrytitle']) . "',
			lastpostuserid = '$lastpost[userid]',
			lastpostusername = '" . $vbulletin->db->escape_string($lastpost['username']) . "',
			lastpostdateline = '$lastpost[dateline]'
	");
}

// ##### Update Counters (moving) #############################################
/*
 * Function to allow entries to be moved and update the category counts
*/
function update_counts_moved($entryid, &$newentry, &$oldentry)
{
	global $vbulletin, $db;

	$upquerynew = '';
	$upqueryold = '';

	$oldcatid = $oldentry['catid'];

	if ($newentry['catid'] == $oldcatid AND $oldentry['draft'] == $newentry['draft'] AND $oldentry['valid'] == $newentry['valid'])
	{
		return;
	}

	$addquery = "entrycount = entrycount+1, postcount = postcount+$oldentry[posts]";
	$substrquery = "entrycount = entrycount-1, postcount = postcount-$oldentry[posts]";

	// draft/valid state changed, so update the cat counters
	if ($oldentry['draft'] != $newentry['draft'] OR $oldentry['valid'] != $newentry['valid'])
	{
		// The entry is now visible, so add to the counters
		if ($newentry['valid'] AND !$newentry['draft'])
		{
			// Same cat
			if ($oldcatid == $newentry['catid'])
			{
				$upquerynew .= $addquery;
			}
			// We've moved categories
			else
			{
				// Remove from old
				$upqueryold .= $substrquery;

				// Add to new
				$upquerynew .= $addquery;
			}
		}
		// The entry is no longer visible, so subtract
		else
		{
			$upqueryold .= $substrquery;
		}

		// the update_counts_moved() function below will update these if moving cats
		if ($oldcatid == $newentry['catid'])
		{
			$lastentry = $db->query_first("
				SELECT entryid, title, dateline, userid, username
				FROM " . ADV_DYNA_TABLE_PREFIX . "entries
				WHERE catid = $newentry[catid]
					AND valid = 1
					AND draft = 0
					AND private = 0
				ORDER BY dateline DESC
			");

			$upquerynew .= iif($upquerynew, ',') . "
				lastentryid = '$lastentry[entryid]',
				lastentrytitle = '" . $db->escape_string($lastentry['title']) . "',
				lastentryuserid = '$lastentry[userid]',
				lastentryusername = '" . $db->escape_string($lastentry['username']) . "',
				lastentrydateline = '$lastentry[dateline]'
			";

			$lastpost = $db->query_first("
				SELECT postid, post.entryid, entries.title, post.userid, post.username, post.dateline
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (post.entryid = entries.entryid)
				WHERE catid = $newentry[catid]
					AND entries.valid = 1
					AND post.visible = 1
					AND draft = 0
					AND private = 0
				ORDER BY post.dateline DESC
			");

			$upquerynew .= iif($upquerynew, ',') . "
				lastpostid = '$lastpost[postid]',
				lastpostentryid = '$lastpost[entryid]',
				lastpostentrytitle = '" . $db->escape_string($lastpost['title']) . "',
				lastpostuserid = '$lastpost[userid]',
				lastpostusername = '" . $db->escape_string($lastpost['username']) . "',
				lastpostdateline = '$lastpost[dateline]'
			";
		}
	}
	// Moving cats, so set the counts here if they haven't been set above
	else if ($oldcatid != $newentry['catid'] AND $oldentry['valid'] AND !$oldentry['draft'])
	{
		$upquerynew = $addquery;
		$upqueryold = $substrquery;
	}

	if ($oldcatid != $newentry['catid'])
	{
		$catcache = array();
		$catcounts = $db->query_read("SELECT catid, lastentryid, lastentrydateline, lastpostid, lastpostdateline FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid IN($newentry[catid], $oldcatid)");
		while ($cats = $db->fetch_array($catcounts))
		{
			$catcache[$cats['catid']] = $cats;
		}

		// Last entry for new cat
		if ($catcache[$newentry['catid']]['lastentrydateline'] < $oldentry['dateline'])
		{
			$upquerynew .= iif($upquerynew, ',') . "
				lastentryid = $entryid,
				lastentrytitle = '" . $db->escape_string($oldentry['title']) . "',
				lastentryuserid = '$oldentry[userid]',
				lastentryusername = '" . $db->escape_string($oldentry['username']) . "',
				lastentrydateline = '$oldentry[dateline]'
			";
		}

		// Last post for new cat
		if ($catcache[$newentry['catid']]['lastpostdateline'] < $oldentry['lastpostdateline'])
		{
			$upquerynew .= iif($upquerynew, ',') . "
				lastpostid = '$oldentry[lastpostid]',
				lastpostentryid = '$oldentry[entryid]',
				lastpostentrytitle = '" . $db->escape_string($oldentry['title']) . "',
				lastpostuserid = '$oldentry[lastpostuserid]',
				lastpostusername = '" . $db->escape_string($oldentry['lastpostusername']) . "',
				lastpostdateline = '$oldentry[lastpostdateline]'
			";
		}

		if ($catcache[$oldcatid]['lastentryid'] == $entryid)
		{
			$lastentry = $db->query_first("
				SELECT entryid, title, dateline, userid, username
				FROM " . ADV_DYNA_TABLE_PREFIX . "entries
				WHERE catid = $newentry[catid]
					AND valid = 1
					AND draft = 0
					AND private = 0
				ORDER BY dateline DESC
			");

			$upqueryold .= iif($upqueryold, ',') . "
				lastentryid = '$lastentry[entryid]',
				lastentrytitle = '" . $db->escape_string($lastentry['title']) . "',
				lastentryuserid = '$lastentry[userid]',
				lastentryusername = '" . $db->escape_string($lastentry['username']) . "',
				lastentrydateline = '$lastentry[dateline]'
			";
		}

		if ($catcache[$oldcatid]['lastpostid'] == $oldentry['lastpostid'])
		{
			$lastpost = $db->query_first("
				SELECT postid, post.entryid, entries.title, post.userid, post.username, post.dateline
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (post.entryid = entries.entryid)
				WHERE catid = $oldcatid
					AND entries.valid = 1
					AND post.visible = 1
					AND draft = 0
					AND private = 0
				ORDER BY post.dateline DESC
			");

			$upqueryold .= iif($upqueryold, ',') . "
				lastpostid = '$lastpost[postid]',
				lastpostentryid = '$lastpost[entryid]',
				lastpostentrytitle = '" . $db->escape_string($lastpost['title']) . "',
				lastpostuserid = '$lastpost[userid]',
				lastpostusername = '" . $db->escape_string($lastpost['username']) . "',
				lastpostdateline = '$lastpost[dateline]'
			";
		}
	}

	if ($upquerynew)
	{
		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET $upquerynew WHERE catid = $newentry[catid]");
		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET $upquerynew WHERE catid = $newentry[catid] AND userid = $oldentry[userid]");
	}

	if ($upqueryold)
	{
		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET $upqueryold WHERE catid = $oldcatid");
		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET $upqueryold WHERE catid = $oldcatid AND userid = $oldentry[userid]");
	}
}

// ###################### Initial Update Counters Function ##################
function update_count($catid = 0, $entrycounters = true, $postcounters = true, $updatelastentry = true, $updatelastpost = true)
{
	global $db;

	if ($catid)
	{
		$catquery = "WHERE catid = '$catid'";
	}

	$getcats = $db->query_read("SELECT catid FROM " . ADV_DYNA_TABLE_PREFIX . "categories " . iif($catid, 'WHERE catid = ' . $catid));
	while ($cats = $db->fetch_array($getcats))
	{
		$entryids = array();
		$getentries = $db->query_read("
			SELECT entryid " . iif($updatelastentry, ', title, dateline, username, userid') . "
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries
			WHERE catid = $cats[catid]
				AND draft = 0
				AND private = 0
				AND valid = 1
			ORDER BY dateline DESC
		");
		$cats['entrycount'] = $db->num_rows($getentries);
		while ($entries = $db->fetch_array($getentries))
		{
			$entryids[] = $entries['entryid'];

			// This should be the first row if $lastentryid isn't set, so set the cat info
			if (!$cats['lastentryid'] AND $updatelastentry)
			{
				$cats['lastentryid'] = $entries['entryid'];
				$cats['lastentrydateline'] = $entries['dateline'];
				$cats['lastentryuser'] = $entries['username'];
				$cats['lastentrytitle'] = $entries['title'];
				$cats['lastentryuserid'] = $entries['userid'];
			}
		}
		$db->free_result($getentries);
		unset($entries);

		$cats['pcount'] = 0;

		if (!empty($entryids) AND $postcounters)
		{
			$postids = array();

			$getposts = $db->query_read("
				SELECT postid, posts.entryid, posts.dateline, posts.userid, posts.username, entries.title AS entrytitle
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (posts.entryid = entries.entryid)
				WHERE posts.entryid IN (" . implode(',', $entryids) . ")
					AND visible = 1
				ORDER BY posts.dateline DESC
			");
			$cats['pcount'] = $db->num_rows($getposts);
			while ($posts = $db->fetch_array($getposts))
			{
				// This should be the first row if $lastentryid isn't set, so set the cat info
				if (!$cats['lastpostid'] AND $updatelastpost)
				{
					$cats['lastpostid'] = $posts['postid'];
					$cats['lastpostentryid'] = $posts['entryid'];
					$cats['lastpostdateline'] = $posts['dateline'];
					$cats['lastpostusername'] = $posts['username'];
					$cats['lastpostuserid'] = $posts['userid'];
					$cats['lastpostentrytitle'] = $posts['entrytitle'];
				}
			}

			unset($entryids);
		}

		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET " .
					iif($entrycounters, "entrycount = '$cats[entrycount]', ") .
					iif($postcounters, "postcount = '$cats[pcount]'") .

					iif($updatelastentry, ",
						lastentryid = '$cats[lastentryid]',
						lastentrydateline = '$cats[lastentrydateline]',
						lastentrytitle = '" . $db->escape_string($cats['lastentrytitle']) . "',
						lastentryusername = '" . $db->escape_string($cats['lastentryuser']) . "',
						lastentryuserid = '$cats[lastentryuserid]'") .
					iif($updatelastpost, ",
						lastpostid = '$cats[lastpostid]',
						lastpostentryid = '$cats[lastpostentryid]',
						lastpostdateline = '$cats[lastpostdateline]',
						lastpostentrytitle = '" . $db->escape_string($cats['lastpostentrytitle']) . "',
						lastpostusername = '" . $db->escape_string($cats['lastpostusername']) . "',
						lastpostuserid = '$cats[lastpostuserid]'") .
			" WHERE catid = '$cats[catid]' AND hasentries = 1
		");
	}
}

// ######################### Remove Entries In Category #########################
function remove_entries_in_cat($catid)
{
	global $db;

	require_once(DIR . '/includes/vba_dyna_functions_moderate.php');

	$entryid = array();

	$entryids = $db->query_read("SELECT entryid FROM " . ADV_DYNA_TABLE_PREFIX . "entries WHERE catid IN ($catid)");
	while ($entries = $db->fetch_array($entryids))
	{
		$entryid[] = $entries['entryid'];
	}

	if (!empty($entryid))
	{
		delete_entries($entryid);
	}
}

?>