<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

require_once(DIR . '/includes/vba_dyna_functions.php');

define('ADV_DYNA_TABLE_PREFIX', TABLE_PREFIX . ADV_DYNA_PREFIX . '_');

convert_prefixed_datastore();

// ##### Set vBa options & merge w/ vBa CMPS if necessary
if (is_array($vba_options))
{
	$vba_options = array_merge($vba_options, $vbulletin->adv_dyna_opts);
}
else
{
	$vba_options =& $vbulletin->adv_dyna_opts;
}

$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

if (empty($vbulletin->userinfo['usergrouparray']))
{
	$vbulletin->userinfo['usergrouparray'] = array(1);
}

// ##### Load the $vba_dyna class
require_once(DIR . '/includes/vba_dyna_class.php');
$vba_dyna =& new vba_dyna();
$vba_dyna->vbulletin =& $vbulletin;

// ##### Entries Permissions
$vba_dyna->default_permissions();

// ##### Common Globals
$vbulletin->input->clean_array_gpc('r', array(
	'entryid' => TYPE_INT,
	'e' => TYPE_INT,
	'epostid' => TYPE_INT,
	'entryrewrite' => TYPE_NOHTML,
	'catid' => TYPE_NOHTML,
	'c' => TYPE_NOHTML,
	'catrewrite' => TYPE_NOHTML,
	'entryuserid' => TYPE_INT,
	'userrewrite' => TYPE_NOHTML,
	'editmods' => TYPE_INT
));

// User re-written URL
if ($vbulletin->GPC['userrewrite'])
{
	$vbulletin->GPC['entryuserid'] = intval(substr(strrchr($vbulletin->GPC['userrewrite'], '-'), 1));
}

// Entry re-written URL
if ($vbulletin->GPC['entryrewrite'])
{
	$vbulletin->GPC['entryid'] = intval(substr(strrchr($vbulletin->GPC['entryrewrite'], '-'), 1));
}
else if ($vbulletin->GPC['e'])
{
	$vbulletin->GPC['entryid'] = $vbulletin->GPC['e'];
}

if ($vbulletin->GPC['c'])
{
	$vbulletin->GPC['catid'] = $vbulletin->GPC['c'];
}
else if ($vbulletin->GPC['catrewrite'])
{
	$rewritecatid = substr(strrchr($vbulletin->GPC['catrewrite'], '-'), 1);

	if (!$vbulletin->GPC['catid'])
	{
		$vbulletin->GPC['catid'] = substr(strrchr($vbulletin->GPC['catrewrite'], '-'), 1);
	}
}

// Make sure the URL matches up
if ($vba_options['dyna_spiderurls'] AND $vbulletin->GPC['catrewrite'])
{
	$caturl = fetch_cat_url($rewritecatid);

	if ($caturl != $vbulletin->GPC['catrewrite'] AND $caturl != $vbulletin->GPC['catrewrite'] . '/')
	{
		exec_header_redirect($vba_options['dyna_homeurl']  . '/' .  $caturl);
	}
}

// Make sure we're using a rewritten URL the option is turned on
if ($vba_options['dyna_spiderurls'] AND THIS_SCRIPT == 'dyna_browsecategory' AND intval($vbulletin->GPC['catid']) AND !$vbulletin->GPC['catrewrite'])
{
	exec_header_redirect($vba_options['dyna_homeurl']  . '/' .  fetch_cat_url($vbulletin->GPC['catid']));
}

$catid = $vbulletin->GPC['catid'];
$entryid = $vbulletin->GPC['entryid'];
$entryuserid = $vbulletin->GPC['entryuserid'];
$epostid = $vbulletin->GPC['epostid'];

if (in_array($catid, array('newentries', 'popentries', 'favorites', 'subscriptions', 'member', 'searchresults')))
{
	if (!$_REQUEST['do'])
	{
		$_REQUEST['do'] = $catid;
	}
}
else if ($catid)
{
	$catid = intval($catid);
}

$vbulletin->input->clean_gpc('r', 'epage', TYPE_INT);

if (!$vbulletin->GPC['epage'])
{
	$vbulletin->GPC['epage'] = 1;
}

($hook = vBulletinHook::fetch_hook('vba_dyna_plugin_sf_start')) ? eval($hook) : false;

// ##### Get entry info (have to do this here to be able to get the correct modules)
if (THIS_SCRIPT == 'dyna_showentry')
{
	$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
	$goto = $vbulletin->input->clean_gpc('r', 'goto', TYPE_NOHTML);
	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);
	$entryuser = $vbulletin->input->clean_gpc('r', 'entryuser', TYPE_INT);

	// ##### Next / Previous Link
	if ($goto == 'next' OR $goto == 'previous')
	{
		if (($orderby == 'title' OR !$orderby) AND !$direction)
		{
			$direction = 'ASC';
		}

		// Search results
		if ($catid == 'searchresults')
		{
			$search = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "search WHERE searchid = $searchid");

			if (!$search['searchid'])
			{
				define('SF_ERROR', 'searchnoresults');
			}

			$orderby = $search['orderby'];
			$direction = $search['direction'];
		}

		if ($direction != 'ASC')
		{
			$direction = 'DESC';
		}

		$doorderby = construct_orderby();

		if ($orderby == 'rating')
		{
			$votequery = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
		}

		// Cutoff date
		if ($catid == 'newentries' OR $catid == 'newposts')
		{
			$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);
			if ($cutoffdate != 'lastvisit')
			{
				$cutoffdate = intval($cutoffdate);
			}
			if (!$cutoffdate)
			{
				$cutoffdate = 'lastvisit';
			}
		}

		// Figure out which category we're dealing with
		switch ($catid)
		{
			// User Favorites
			case 'favorites':

				$joinquery = ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'favorites AS favorites ON (entries.entryid = favorites.entryid)';
				$entryquery = ' AND favorites.userid = ' . $vbulletin->userinfo['userid'];
			break;

			// User Subscriptions
			case 'subscriptions':

				$joinquery = ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'subscribeentry AS subscribe USING (entryid)';
				$entryquery = ' AND subscribe.userid = ' . $vbulletin->userinfo['userid'];
			break;

			// Popular Entries
			case 'popentries':
				if ($doorderby == 'title')
				{
					$doorderby = 'views';
				}
				$direction = 'DESC';
				$limit = $vba_options['dyna_popentrylimit'];

				// Highest rated
				if ($orderby == 'rating')
				{
					$entryquery = 'AND votenum >= ' . intval($vba_options['dyna_popentries_votelimit']);
					$votequery = 'IF(votenum >= ' . $vbulletin->options['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vbulletin->options['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
				}

			break;

			// New Entries
			case 'newentries':
				$doorderby = 'dateline';
				$direction = 'DESC';
				$entryquery = 'AND entries.dateline > ' . iif($cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (TIMENOW - ($cutoffdate * 86400)));

			break;

			// New Posts
			case 'newentries':
				$doorderby = 'dateline';
				$direction = 'DESC';
				$entryquery = 'AND entries.lastpostdateline > ' . iif($cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (TIMENOW - ($cutoffdate * 86400)));
			break;

			// Member Search
			case 'member':
				$entryquery = ' AND userid = ' . $entryuserid;
			break;

			case 'searchresults':
				$entryquery = ' AND entryid IN (' . $search['entryids'] . ')';
			break;


			// Category ID
			default:

				// In case of a reply, there won't be a catid... Assume we're in browsecategory
				if (!$catid)
				{
					$checkcat = $db->query_first("SELECT catid FROM " . ADV_DYNA_TABLE_PREFIX . "entries WHERE entryid = $entryid");
					$catid = $checkcat['catid'];
				}

				$entryquery = 'AND catid = ' . $catid;

				if ($entryuserid)
				{
					$entryquery .= ' AND entries.userid = ' . $entryuserid;
				}
		}

		if ($orderby == 'category')
		{
			$joinquery .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'categories AS categories ON (entries.catid = categories.catid)';
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_plugin_sf_showentry')) ? eval($hook) : false;

		if (!defined('SF_ERROR'))
		{
			$entryarray = array();
			$getids = $db->query("
				SELECT $votequery entries.entryid
				FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
				$joinquery
				WHERE valid = 1
					AND draft = 0
					$entryquery
				ORDER BY $doorderby $direction
				" . iif($limit, ' LIMIT ' . $limit)
			);
			while($prevnext = $db->fetch_array($getids))
			{
				$entryarray[] = $prevnext['entryid'];
			}

			$prevnextcount = sizeof($entryarray);

			$entrykey = array_search($entryid, $entryarray);

			if ($goto == 'next')
			{
				$entryid = (isset($entryarray[$entrykey+1])) ? $entryarray[$entrykey+1] : $entryarray[0];
			}
			else
			{
				$entryid = (isset($entryarray[$entrykey-1])) ? $entryarray[$entrykey-1] : $entryarray[$prevnextcount-1];
			}

			if (!$entryid)
			{
				define('SF_ERROR', 'noentryid');
			}

			unset($entryarray);
		}
	} // End previous / next entry

	if (!defined('SF_ERROR'))
	{
		// Get the entry info
		$vba_dyna->load_entry('', true, true, true, true, true);
		$entry =& $vba_dyna->_entry;

		// Redirect them if the URL doesn't match up
		if ($vba_options['dyna_spiderurls'] AND $vbulletin->GPC['entryrewrite'] AND $entry['url'] != $vbulletin->GPC['catrewrite'] . '/' . $vbulletin->GPC['entryrewrite'] . '/')
		{
			exec_header_redirect($vba_options['dyna_homeurl']  . '/' .  $entry['url']);
		}
		else if ($vba_options['dyna_spiderurls'] AND !$vbulletin->GPC['entryrewrite'])
		{
			exec_header_redirect($vba_options['dyna_homeurl']  . '/' .  $entry['url']);
		}

		unset($query);

		if (!$catid)
		{
			$catid = $entry['catid'];
		}

		$entryuserid = $entry['userid'];
	}
}

// ##### Process modules
$show['dyna_columns'] = false;

if ($vba_options['dyna_enablemodules']
	AND (THIS_SCRIPT == 'dyna_index'
		OR THIS_SCRIPT == 'dyna_browsecategory'
		OR THIS_SCRIPT == 'dyna_showentry'
		OR THIS_SCRIPT == 'dyna_newentry'
		OR THIS_SCRIPT == 'dyna_search'
		OR (THIS_SCRIPT == 'dyna_ajax' AND $_REQUEST['do'] == 'calendar')
		OR (THIS_SCRIPT == 'dyna_modules' AND $_REQUEST['do'] == 'movemod' AND $_REQUEST['ajax'])
	)
)
{
	$globaltemplates[] = ADV_DYNA_PREFIX . '_module_wrapper';
	$globaltemplates[] = ADV_DYNA_PREFIX . '_module_controls';
	$globaltemplates[] = ADV_DYNA_PREFIX . '_columns_end';
	$globaltemplates[] = ADV_DYNA_PREFIX . '_columns_start';

	if ($vbulletin->GPC['editmods'])
	{
		$globaltemplates[] = ADV_DYNA_PREFIX . '_editmodules_inactive';
		$globaltemplates[] = ADV_DYNA_PREFIX . '_editmodules_inactivebits';
	}

	// ##### Construct Global Templates Function ##################################
	if (!function_exists('construct_global_templates'))
	{
		function construct_global_templates(&$mod)
		{
			global $globaltemplates;

			if ($mod['inctype'] == 'php_file' AND !empty($mod['templatelist']))
			{
				$globaltemplates = array_merge($globaltemplates, $mod['templatelist']);
			}
			else if ($mod['inctype'] == 'template' AND $mod['filename'])
			{
				$globaltemplates[] = ADV_DYNA_PREFIX . '_' . $mod['filename'];
			}

			if ($mod['altshell'])
			{
				$globaltemplates[] = $mod['altshell'];
			}
		}
	}

	// ##### Work out the layout
	$dyna_module_layout = '';
	$getlayout = false;
	$getcustommods = false;

	switch (THIS_SCRIPT)
	{
		// ##### Ajax
		case 'dyna_ajax':
			if ($_REQUEST['do'] == 'calendar')
			{

				foreach ($vbulletin->adv_dyna_module AS $modid => $module)
				{
					if ($module['identifier'] == 'calendar')
					{
						$calmodid = $modid;
					}
				}

				if (!$calmodid)
				{
					exit;
				}

				$mods =& $vbulletin->adv_dyna_module[$calmodid];

				$vba_options['dyna_enablemodules'] = 1;
				$dyna_module_layout = array(1 => array($calmodid => 1));
			}
		break;

		// ###### Browseentries / Move
		case 'dyna_modules':

			$entryuserid = $vbulletin->userinfo['userid'];
		case 'dyna_browsecategory':

			switch ($_REQUEST['do'])
			{
				case 'favorites':
				case 'subscriptions':
				case 'popentries':
				case 'newentries':

					$dyna_module_layout =& $vbulletin->adv_dyna_modpos['dyna_browsecategory_' . $_REQUEST['do']];
				break;

				default:

				$catid = intval($catid);

				$vba_dyna->_cat =& $vbulletin->adv_dyna_cats[$catid];
				if ($entryuserid OR $vba_dyna->_cat['catuserid'])
				{
					$catuser = $db->query_first("
						SELECT user.*, buddylist, layout
						FROM " . TABLE_PREFIX . "user AS user
						LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (user.userid = usertextfield.userid)
						LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "layout AS layout ON (user.userid = layout.userid AND layout.page = 'dyna_browsecategory')
						WHERE user.userid = " . iif($entryuserid, $entryuserid, $vba_dyna->_cat['catuserid'])
					);
				}

				$catuser['layout'] = unserialize($catuser['layout']);

				// Sort through and see what we have permission for
				if (!empty($catuser['layout']))
				{
					$catuser['usergrouparray'] = fetch_membergroupids_array($catuser);

					foreach ($catuser['usergrouparray'] AS $catusergroup)
					{
						if ($vbulletin->adv_dyna_perms[$catusergroup]['dyna_perms']['module'] & $vba_dyna->_permbits['module']['canmodule'])
						{
							$getlayout = true;
						}
						if ($vbulletin->adv_dyna_perms[$catusergroup]['dyna_perms']['module'] & $vba_dyna->_permbits['module']['canaddmodule'])
						{
							$getcustommods = true;
						}
					}
				}

				if ($getlayout)
				{
					$dyna_module_layout =& $catuser['layout'];
				}
				else
				{
					$dyna_module_layout =& $vbulletin->adv_dyna_modpos[THIS_SCRIPT];
				}
			}

			$moduleuserid = ($vba_dyna->_cat['catuserid']) ? $vba_dyna->_cat['catuserid'] : $entryuserid;

		break;

		// ##### Show Entry
		case 'dyna_showentry':

			$moduleuserid =& $entry['userid'];

			if ($entry['layout'])
			{
				$entry['usergrouparray'] = fetch_membergroupids_array($entry);

				foreach ($entry['usergrouparray'] AS $entryusergroup)
				{
					if ($vbulletin->adv_dyna_perms[$entryusergroup]['dyna_perms']['module'] & $vba_dyna->_permbits['module']['canmodule'])
					{
						$getlayout = true;
					}
					if ($vbulletin->adv_dyna_perms[$entryusergroup]['dyna_perms']['module'] & $vba_dyna->_permbits['module']['canaddmodule'])
					{
						$getcustommods = true;
					}
				}
			}

			if ($getlayout)
			{
				$entry['layout'] = unserialize($entry['layout']);

				if (!empty($entry['layout']))
				{

					$dyna_module_layout =& $entry['layout'];
				}
			}
			else
			{
				$dyna_module_layout =& $vbulletin->adv_dyna_modpos[THIS_SCRIPT];
			}

		break;

		default:
			$dyna_module_layout =& $vbulletin->adv_dyna_modpos[THIS_SCRIPT];
	}

	$activemodules = array();

	if (empty($dyna_module_layout) AND THIS_SCRIPT != 'dyna_modules')
	{
		define('NO_MODULES', true);
	}
	else
	{
		// ##### Custom user modules
		if ($getcustommods)
		{
			$custommods = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user WHERE userid = " . $moduleuserid);
			while ($cmod = $db->fetch_array($custommods))
			{
				if ($cmod['modid'])
				{
					$vbulletin->adv_dyna_module[$cmod['modid']]['title'] = $cmod['title'];
					$vbulletin->adv_dyna_module[$cmod['modid']]['code'] = $cmod['code_parsed'];
				}
				else
				{
					$cmod['usermodid'] = 'u' . $cmod['modlinkid'];
					$cmod['custom'] = 1;
					$cmod['inctype'] = 'bb_code';
					$cmod['useshell'] = 1;
					$cmod['useredit'] = 1;
					$vbulletin->adv_dyna_module[$cmod['usermodid']] = $cmod;
				}
			}
		}

		$pagemodules = array();

		foreach ($dyna_module_layout AS $dyna_column => $colum_modids)
		{
			foreach ($colum_modids AS $advmodid => $advmod_order)
			{
				$vba_mod =& $vbulletin->adv_dyna_module[$advmodid];

				if ($vba_dyna->module_perms($advmodid, 'canview') OR $vba_mod['custom'])
				{
					$show['dyna_columns'] = true;
					$show[$vba_dyna->_colnames[$dyna_column] . '_column'] = true;

					construct_global_templates($vba_mod);

					$activemodules[] = $advmodid;

					// Load BB code parser
					if ($vba_mod['options'] & $vba_dyna->_php_modint['load_bbcode_parser'])
					{
						$vba_dyna->_initload['bbparser'] = true;
					}

					// Fetch category permissions
					if ($vba_mod['options'] & $vba_dyna->_php_modint['load_cat_perms'])
					{
						$vba_dyna->_initload['cat_perms'] = true;
					}

					// Load ignored users
					if ($vba_mod['options'] & $vba_dyna->_php_modint['load_ignusers'])
					{
						$vba_dyna->_initload['ignusers'] = true;
					}

					// ##### CMPS module compatibility
					// Fetch forum permissions
					if ($vba_mod['options'] & $vba_dyna->_php_modint['load_forumperms'])
					{
						$vba_dyna->_initload['forumperms'] = true;
					}


					($hook = vBulletinHook::fetch_hook('vba_dyna_include_preprocess_modules')) ? eval($hook) : false;
				}
				else
				{
					unset($dyna_module_layout[$dyna_column][$advmodid]);
				}
			}
		}
	}
}

// Category has a styleid set
if ($vba_dyna->_cat['styleid'])
{
	$styleid = $vba_dyna->_cat['styleid'];
	$userselect = true;
}
else if ($vba_options['dyna_styleid'] AND $vba_options['dyna_styleid'] != '-1' AND (!$vbulletin->userinfo['styleid'] OR $vba_options['dyna_forcestyle']))
{
	$styleid = $vba_options['dyna_styleid'];
	$userselect = true;
}

// Make sure the user URL matches up
if (($vba_options['dyna_spiderurls'] AND $vbulletin->GPC['userrewrite'])
	OR ($vba_options['dyna_spiderurls'] AND !$vbulletin->GPC['userrewrite'] AND $vbulletin->GPC['entryuserid'] AND !$_REQUEST['eventdate'])
)
{
	if (empty($catuser))
	{
		$catuser = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid = $entryuserid");
	}

	if ($vba_options['dyna_spider_memberscattext'])
	{
		$usercheck = $vba_options['dyna_spider_memberscattext'] . '-' . $catuser['userid'];
	}
	else
	{
		$usercheck = fetch_spider_url($catuser['username'], $catuser['userid']);
	}

	if (THIS_SCRIPT == 'dyna_browsecategory' AND $vbulletin->GPC['userrewrite'] != $usercheck AND $vbulletin->GPC['userrewrite'] != $usercheck . '/')
	{
		exec_header_redirect($vba_options['dyna_homeurl']  . '/' .  fetch_cat_url($catid, array('userid' => $catuser['userid'], 'title' => $catuser['username']), iif(!$catid, 'member', '')));
	}
}

// Meta Stuff
if (trim($vba_options['dyna_meta_desc']))
{
	$vbulletin->options['description'] = $vba_options['dyna_meta_desc'];
}

if (trim($vba_options['dyna_meta_keywords']))
{
	$vbulletin->options['keywords'] = $vba_options['dyna_meta_keywords'];
}

// Replace template names
if (ADV_DYNA_PREFIX != 'adv_dyna')
{
	// Global Templates
	if (!empty($globaltemplates))
	{
		$newglobal = array();

		foreach ($globaltemplates AS $tempname)
		{
			$newglobal[] = check_prefix($tempname);
		}

		$globaltemplates =& $newglobal;
	}

	// Action Templates
	if (!empty($actiontemplates))
	{
		$newaction = array();

		foreach ($actiontemplates AS $tempaction => $actiontemp)
		{
			if (!empty($actiontemp))
			{
				$newaction[$tempaction] = array_map('check_prefix', $actiontemp);
			}
		}

		$actiontemplates = $newaction;
	}
}

($hook = vBulletinHook::fetch_hook('vba_dyna_plugin_sf_end')) ? eval($hook) : false;

?>