<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'dyna_attachment');
define('VBA_SCRIPT', 'dynamics');

$specialtemplates = array(
	'adv_dyna_attach',
	'adv_dyna_cats',
	'adv_dyna_opts',
	'adv_dyna_perms'
);

require_once('./dyna_config.php');

chdir($forumpath);

require_once('./includes/vba_dyna_include_prefix.php');

require_once('./global.php');
require_once(DIR . '/includes/vba_dyna_functions.php');
require_once(DIR . '/includes/vba_dyna_class.php');

convert_prefixed_datastore();

define('ADV_DYNA_TABLE_PREFIX', TABLE_PREFIX . ADV_DYNA_PREFIX . '_');

($hook = vBulletinHook::fetch_hook('vba_dyna_attachment_start')) ? eval($hook) : false;

$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

if (empty($vbulletin->userinfo['usergrouparray']))
{
	$vbulletin->userinfo['usergrouparray'] = array(1);
}

$vba_dyna =& new vba_dyna();
$vba_dyna->vbulletin =& $vbulletin;

$vba_dyna->default_permissions();

// Load the $vba_image class
require_once(DIR . '/includes/vba_dyna_class_image.php');

$vba_image =& new vba_dyna_image();
$vba_image->_vb =& $vbulletin;

$vba_image->load_extensions();

$vba_dyna->fetch_attachment_perms();

$vbulletin->input->clean_array_gpc('r', array(
	'attachmentid' => TYPE_INT,
	'thumb' => TYPE_INT
));

$attachment = $db->query_first("
	SELECT attachments.*, entries.catid
	FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attachments
	LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (attachments.entryid = entries.entryid)
	WHERE attachmentid = " . $vbulletin->GPC['attachmentid']
);

if (!$attachment['attachmentid'])
{
	eval(standard_error(fetch_error('noid', $vbphrase['attachment'])));
}

($hook = vBulletinHook::fetch_hook('vba_dyna_attachment_process')) ? eval($hook) : false;

$attachperms =& $vba_dyna->_attachperms[$attachment['extension']];

// Don't apply these checks for the owner of the attachment
if ($attachment['userid'] != $vbulletin->userinfo['userid'] AND !is_category_mod($attachment['catid']))
{

	// Awaiting moderation
	if (!$attachment['valid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['attachment'])));
	}

	// Max download size
	if (!$vbulletin->GPC['thumb'] AND $attachperms['maxdownloadsize'] AND $attachperms['maxdownloadsize'] < $attachment['filesize'])
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_attach_x_too_large_max_size_y', fetch_rfilesize($attachment['filesize']), fetch_rfilesize($attachperms['maxdownloadsize']))));
	}
}

// Permissions
if ((!$vba_dyna->check_cat_perms('canviewattach', $attachment) AND !$vbulletin->GPC['thumb'] AND !$attachperms['canviewattach'])
	OR (!$vba_dyna->check_cat_perms('canviewthumb', $attachment) AND $vbulletin->GPC['thumb'] AND !$attachperms['canviewthumb'])
)
{
	print_no_permission();
}

if (!$vbulletin->GPC['thumb'])
{
	$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "attachments SET views = views+1 WHERE attachmentid = $attachment[attachmentid]");
}

$attachment['fullfilename'] = $attachment['filename'] . '_' . $attachment['dateline'] .
	iif($attachment['hasthumb'] AND $attachment['hasthumb'] != 2 AND $vbulletin->GPC['thumb'],
		'_thumb'
	) . '.' . $attachment['extension'];

// Set the time limit so large images can fully load on dialup... I hope
@set_time_limit(90);

header('Pragma: public');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Cache-Control: private', false);
header('Content-Disposition: attachment; filename="' . $attachment['fullfilename'] . '"');

($hook = vBulletinHook::fetch_hook('vba_dyna_attachment_end')) ? eval($hook) : false;

if ($attachment['extension'] == 'txt')
{
	header('Content-type: plain/text');
}
else
{
	// Image
	if (in_array($attachment['extension'], array_values($vba_image->_imagetypes)))
	{
		$imagetype = true;
	}

	if ($imagetype)
	{
		$applicationtype = 'image/' . iif($attachment['extension'] == 'jpg', 'jpeg', $attachment['extension']);
	}
	else
	{
		switch ($attachment['extension'])
		{
			case 'zip':
				$applicationtype = 'application/zip';
			break;
			case 'exe':
				$applicationtype = 'application/octet-stream';
			break;
		  case 'doc':
		  	$applicationtype = 'application/msword';
		  break;
  		case 'xls':
  			$applicationtype = 'application/vnd.ms-excel';
  		break;

			default:
				$applicationtype = 'application/force-download';
		}
	}

	header('Content-Disposition: ' . iif($imagetype, 'inline;', 'attachment; filename=') . basename($attachment['fullfilename']));
	header('Content-Transfer-Encoding: binary');
	header('Content-type: ' . $applicationtype);
}

if (!$vbulletin->GPC['thumb'])
{
	header('Content-Length: ' . $attachment['filesize']);
}

echo @readfile($vbulletin->adv_dyna_opts['dyna_attachpath'] . '/' . fetch_upload_path($attachment['userid']) . '/' . $attachment['fullfilename']);

?>