<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'dyna_newattachment');
define('VB_ERROR_LITE', true);

$specialtemplates = array();

$phrasegroups = array(
	'adv_dyna_attach',
	'posting'
);

$globaltemplates = array(
	'adv_dyna_newattachment_ftpbit',
	'adv_dyna_newattachment_inputbit',
	'adv_dyna_newattachment_set_as_row',
	'adv_dyna_newattachmentbit',
	'newattachment',
	'newattachment_errormessage',
	'newattachment_keybit',
);

$actiontemplates = array(
	'manageattach' => array(
		'STANDARD_ERROR_LITE'
	)
);

require_once('./dyna_global.php');

$catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_INT);
$posthash = $vbulletin->input->clean_gpc('r', 'posthash', TYPE_NOHTML);

if ($entryid)
{
	$vba_dyna->load_entry();
}
else
{
	$vba_dyna->_entry['catid'] = $catid;
}

if (!$vba_dyna->check_cat_perms('canattach') OR ($entryid AND $vba_dyna->_entry['userid'] != $vbulletin->userinfo['userid'] AND !is_category_mod($vba_dyna->_entry['catid'])))
{
	print_no_permission();
}

// Load the $vba_image class
require_once(DIR . '/includes/vba_dyna_class_image.php');

$vba_image =& new vba_dyna_image();
$vba_image->_vb =& $vbulletin;

$vba_image->load_extensions();

$vba_dyna->fetch_attachment_perms();

$vbulletin->templatecache['newattachmentbit'] = $vbulletin->templatecache[ADV_DYNA_PREFIX . '_newattachmentbit'];

// Fetch space used
if ($vba_dyna->_permissions['attachspace'])
{
	$userspace = $db->query_first("SELECT SUM(filesize) AS used FROM " . ADV_DYNA_TABLE_PREFIX . "attachments WHERE userid = " . $vbulletin->userinfo['userid']);
}

($hook = vBulletinHook::fetch_hook('vba_dyna_newattachment_start')) ? eval($hook) : false;

// ##### Uploading ############################################################
if ($_POST['do'] == 'manageattach')
{
	if ($vbulletin->debug)
	{
		$starttime = explode(' ', microtime());
		$starttime = $starttime[0] + $starttime[1] - $scriptstarted;
	}

	$attachfiles = $vbulletin->input->clean_gpc('f', 'attachment', TYPE_FILE);

	$vbulletin->input->clean_array_gpc('p', array(
		'delete' => TYPE_ARRAY,
		'attachurl' => TYPE_ARRAY,
		'ftpupload' => TYPE_INT,
		'entryattach' => TYPE_INT
	));

	if (sizeof($attachfiles['tmp_name']) > $vba_options['dyna_attachinputs'])
	{
		trigger_error('Maximum number of attachment inputs exceeded.', E_USER_ERROR);
	}

	if (sizeof($vbulletin->GPC['attachurl']) > $vba_options['dyna_attachinputs_url'])
	{
		trigger_error('Maximum number of attachment inputs exceeded.', E_USER_ERROR);
	}

	if (!is_dir($vba_options['dyna_attachpath']))
	{
		eval(standard_error(fetch_error(
			ADV_DYNA_PREFIX . '_attach_folder_invalid_user',
			$vbulletin->options['contactuslink']
		)));
	}

	$folderpath = $vba_options['dyna_attachpath'] . '/' . $vba_image->fetch_upload_folders($vbulletin->userinfo['userid']) . '/';

	if (!is_writable($folderpath))
	{
		eval(standard_error(fetch_error(
			ADV_DYNA_PREFIX . '_attach_folder_not_writable_user',
			$vbulletin->options['contactuslink']
		)));
	}

	// php.ini settings
	if ($vba_options['dyna_attach_maxexectime'])
	{
		ini_set('max_execution_time', $vba_options['dyna_attach_maxexectime']);
	}

	if ($vba_options['dyna_attach_maxfilesize'])
	{
		ini_set('upload_max_filesize', $vba_options['dyna_attach_maxfilesize'] . 'M');
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_newattachment_saveattach')) ? eval($hook) : false;

	// ##### Files being deleted
	if (!empty($vbulletin->GPC['delete']))
	{
		list($attachmentid, $attachkey) = each($vbulletin->GPC['delete']);

		$attachmentid = intval($attachmentid);
		$delattach = $db->query_first("
			SELECT attach.*, entry.catid
			FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attach
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (attach.entryid = entry.entryid)
			WHERE attachmentid = $attachmentid
		");

		// Make sure it's the users or a moderator
		if ($delattach['userid'] != $vbulletin->userinfo['userid'] AND !is_category_mod($delattach['catid']))
		{
			print_no_permission();
		}

		// See if it still has the required number of attachments
		if ($entryid AND $vba_options['dyna_require_attach'] AND $vba_dyna->_entry['hasattach'] <= $vba_options['dyna_require_attach'])
		{
			eval(standard_error(fetch_error(
				ADV_DYNA_PREFIX . '_not_enough_attach_after_delete',
				$vbphrase['entry_lwr'],
				$vba_options['dyna_require_attach']
			)));
		}

		// Everything's good, so get rid of it
		$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "attachments WHERE attachmentid = $attachmentid");

		$deletepath = ($vbulletin->userinfo['userid'] == $delattach['userid']) ? $folderpath : $vba_options['dyna_attachpath'] . '/' . $vba_image->fetch_upload_folders($delattach['userid']) . '/';

		@unlink($deletepath . $delattach['filename'] . '_' . $delattach['dateline'] . '.' . $delattach['extension']);

		if ($delattach['hasthumb'])
		{
			@unlink($deletepath . $delattach['filename'] . '_' . $delattach['dateline'] . '_thumb.' . $delattach['extension']);
		}

		// Need a new attachid if it's the one being removed
		if ($vba_dyna->_entry['attachid'] == $attachmentid)
		{
			$vba_dyna->_entry['attachid'] = 0;
		}
	}

	$attachments = array();
	$attachorigin = array();
	$attachkey = $vba_options['dyna_attachinputs'];

	// ##### FTP Upload - Format them into the $attachfiles array
	if ($vba_dyna->check_perms('canftpattach') AND $vbulletin->GPC['ftpupload'])
	{
		$ftppath = $vba_options['dyna_attach_ftppath'] . '/' . $vbulletin->userinfo['userid'];

		$folderempty = true;
		$diropen = opendir($ftppath);
		while (($file = readdir($diropen)) !== false)
		{
			if ($file != '.' AND $file != '..' AND $file != 'Thumbs.db' /* for localhost testing */)
			{
				$attachkey++;
				$attachorigin[$attachkey] = 'ftp';

				$attachfiles['name'][$attachkey] = $file;
				$attachfiles['location'][$attachkey] = $ftppath . '/' . $file;
				$attachfiles['tmp_name'][$attachkey] = $ftppath . '/' . $file;

				$folderempty = false;
			}
		}

		if ($folderempty)
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_no_files_found', $ftppath)));
		}
	}

	// ##### URL Attachments
	if ($vba_options['dyna_attachinputs_url'] AND !empty($vbulletin->GPC['attachurl']))
	{
		foreach ($vbulletin->GPC['attachurl'] AS $attachurl)
		{
			$attachkey++;
			$attachorigin[$attachkey] = 'url';

			$attachfiles['name'][$attachkey] = substr($attachurl, (strripos($attachurl, '/') + 1), strlen($attachurl));
			$attachfiles['location'][$attachkey] = $attachurl;
			$attachfiles['tmp_name'][$attachkey] = $attachurl;
		}
	}

	// ##### Sort through uploaded files
	if (!empty($attachfiles['tmp_name']))
	{
		// Count user's attachments
		$attachcount = 0;
		if ($vba_options['dyna_attachmax'])
		{
			$usercount = $db->query_first("
				SELECT COUNT(*) AS attach
				FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
				WHERE	" . iif($entryid,
					'entryid = ' . $entryid,
					"(posthash = '" . $db->escape_string($posthash) . "' AND userid = " . $vbulletin->userinfo['userid'] . ")"
			));
			$attachcount = $usercount['attach'];
		}

		foreach ($attachfiles['tmp_name'] AS $filekey => $tmp_name)
		{
			if (!trim($tmp_name))
			{
				continue;
			}

			$vba_image->_info = array(
				'filename' => $attachfiles['name'][$filekey],
				'type' => $attachfiles['type'][$filekey],
				'location' => $tmp_name,
				'origin' => $attachorigin[$filekey]
			);

			$vba_image->fetch_upload_info();

			$vba_image->check_errors($filekey);

			if (empty($vba_image->_errors[$filekey]))
			{
				$vba_image->_info['name'] = substr($vba_image->_info['name'], 0, $vba_options['dyna_attach_filenamelength']);
				
				$filesavepath = $folderpath . $vba_image->_info['name'] . '_' . TIMENOW . '.' . $vba_image->_info['extension'];

				// URL Attachment
				if ($vba_image->_info['origin'] == 'url')
				{
					$fp = @fopen($filesavepath, 'w+');
					if (function_exists('curl_init'))
					{
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, $vba_image->_info['location']);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
						curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
						curl_setopt($ch, CURLOPT_HEADER, false);
						curl_setopt($ch, CURLOPT_TIMEOUT, $vba_options['dyna_attach_maxexectime']);

						$content = curl_exec($ch);
						curl_close($ch);
					}
					else
					{
						$content = file_get_contents($vba_image->_info['location']);
					}

					fwrite($fp, $content);
					fclose($fp);

					$vba_image->_info['location'] = $filesavepath;
					$vba_image->_info['filesize'] = filesize($filesavepath);

					// Check the size again now that it's on the server
					$maxsize = $vba_image->_extcache[$vba_image->_info['extension']]['size'];
					if ($vba_image->_info['filesize'] > $maxsize)
					{
						$vba_image->_errors[$filekey][] = array(
							'filename' => $vba_image->_info['filename'],
							'error' => fetch_error(
								'upload_file_exceeds_forum_limit',
								fetch_rfilesize($vba_image->_info['filesize']),
								fetch_rfilesize($maxsize)
							)
						);
					}
				}
			}

			// Thumbs
			if (empty($vba_image->_errors[$filekey]))
			{
				$thumblocation = $folderpath . $vba_image->_info['name'] . '_' . TIMENOW . '_thumb.' . $vba_image->_info['extension'];
				$vba_image->resize('thumb', $filekey, $thumblocation);
			}

			/* Recheck the errors incase any were set while resizing */
			if (empty($vba_image->_errors[$filekey]))
			{
				$vba_image->resize('original', $filekey);
			}

			// Move it & insert
			if (empty($vba_image->_errors[$filekey]))
			{
				$attachcount++;

				switch ($vba_image->_info['origin'])
				{
					// From FTP
					case 'ftp':
						@copy($vba_image->_info['location'], $filesavepath);
						@unlink($vba_image->_info['location']);
					break;

					// URL is handled above to double check filesize
					case 'url':
					break;

					// Upload
					default:
						@move_uploaded_file($vba_image->_info['location'], $filesavepath);
						@chmod($filesavepath, 0777);
				}

				$db->query_write("
					INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "attachments
						(entryid, filename, userid, dateline, filesize, hasthumb, valid, extension, posthash)
					VALUES (
						$entryid,
						'" . $db->escape_string($vba_image->_info['name']) . "',
						'" . $vbulletin->userinfo['userid'] . "',
						" . TIMENOW . ",
						" . intval($vba_image->_info['filesize']) . ",
						" . intval($vba_image->_info['hasthumb']) . ",
						" . iif($vba_dyna->check_cat_perms('moderateattach'), 0, 1) . ",
						'" . $db->escape_string($vba_image->_info['extension']) . "',
						'" . $db->escape_string($posthash) . "'
					)
				");

			}
			// Had errors, so remove uploaded files
			else if ($vba_image->_info['origin'] != 'ftp')
			{
				@unlink($vba_image->_info['location']);
			}
		}
	}

	// Update hasattach field
	if ($entryid)
	{
		$curattach = $db->query_first("
			SELECT COUNT(*) AS count " . iif($vba_options['dyna_entrybit_showattach'] != 2, ', MIN(attachmentid) AS attachmentid') . "
			FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
			WHERE entryid = $entryid
				AND valid = 1
		");

		$entryattachid = 0;
		// Entry attachment id
		if ($vbulletin->GPC['entryattach'])
		{
			$entryattach = $db->query_first("
				SELECT attachmentid FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
				WHERE attachmentid = " . $vbulletin->GPC['entryattach'] . "
					AND userid = " . $vbulletin->userinfo['userid']
			);
			$entryattachid = intval($entryattach['attachmentid']);
		}
		if (!$entryattachid)
		{
			if ($curattach['count'] AND !$vba_dyna->_entry['attachid'])
			{
				// The count query won't always grab the right id if we only allow thumbs
				if ($vba_options['dyna_entrybit_showattach'] == 2)
				{
					$attachthumb = $db->query_first("
						SELECT MIN(attachmentid)
						FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
							WHERE entryid = $entryid
							AND hasthumb = 1
					");
					$entryattachid = intval($attachthumb['attachmentid']);
				}
				else
				{
					$entryattachid = $curattach['attachmentid'];
				}
			}
			else if ($vba_dyna->_entry['attachid'])
			{
				$entryattachid = $vba_dyna->_entry['attachid'];
			}
			else
			{
				$entryattachid = 0;
			}
		}

		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
				hasattach = $curattach[count],
				attachid = $entryattachid
			WHERE entryid = $entryid
		");

		$vba_dyna->_entry['attachid'] = $entryattachid;
	}

	// ##### Errors
	$errorlist = '';
	if (!empty($vba_image->_errors))
	{
		$show['errors'] = true;
		foreach ($vba_image->_errors AS $filekey => $fileerrors)
		{
			$errormessage = '';
			foreach ($fileerrors AS $errorkey => $error)
			{
				$filename =& $error['filename'];
				$errormessage .= '<div>' . $error['error'] . '</div>';
			}
			eval('$errorlist .= "' . fetch_template('newattachment_errormessage') . '";');
		}
	}

	if ($vbulletin->debug)
	{
		$finishtime = explode(' ', microtime());
		$finishtime = $finishtime[0] + $finishtime[1] - $scriptstarted;
		$timetaken = $finishtime - $starttime;

		// Replace template
		$vbulletin->templatecache['newattachment'] = str_replace(
			'</body>',
			'<div align=\"center\">Time Taken For Upload: ' . vb_number_format($timetaken, 5) . '</div></body>',
			$vbulletin->templatecache['newattachment']
		);

	}
}
// End $_POST['do'] == 'manageattach'

$show['attachfile'] = false;
$show['attachmentlist'] = false;

$totallimit = 0;
$attachments = '';
$new_attachlist_js = '';

$entry =& $vba_dyna->_entry;

// Set this so the stats bar has a username to use
if (!$entryid)
{
	$entry['username'] = $vbulletin->userinfo['username'];
}

// ##### Current Attachments
$haveselected = false;
$curattach = $db->query_read("
	SELECT attachmentid, filename, dateline, hasthumb, filesize, valid, attach.extension
	FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attach
	LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "attachmenttype AS attachtype ON(attach.extension = attachtype.extension)
	WHERE	" . iif($entryid,
		'entryid = ' . $entryid,
		"(posthash = '" . $db->escape_string($posthash) . "' AND userid = " . $vbulletin->userinfo['userid'] . ")"
	) . "
	ORDER BY attachtype.displayorder ASC, attach.dateline ASC
");
$totallimit += $db->num_rows($curattach);
while ($attach = $db->fetch_array($curattach))
{
	$attach['filesize'] = fetch_rfilesize($attach['filesize']);

	$new_attachlist_js .= "window.opener.vB_Attachments.add($attach[attachmentid], '$attach[filename]', '$attach[filesize]', '$stylevar[imgdir_attach]/$attach[extension].gif');";

	$selected = '';
	if ($attach['attachmentid'] == $entry['attachid'])
	{
		$haveselected = true;
		$selected = ' checked="checked"';
	}
	else if (!$entry['attachid'] AND !$haveselected AND (($totallimit == 1 AND ($vba_options['dyna_entrybit_showattach'] == 1 OR $attach['hasthumb']))
		OR (!$entry['attachmentid'] AND !$haveselected))
	)
	{
		$haveselected = true;
		$selected = ' checked="checked"';
	}

	eval('$attachments .= "' . fetch_template('newattachmentbit') . '";');

	// Set this after the template so we can tell if it's the first row in the template
	$show['attachmentlist'] = true;
}

if ($vba_options['dyna_entrybit_showattach'])
{
	eval('$attachments .= "' . fetch_template(ADV_DYNA_PREFIX . '_newattachment_set_as_row') . '";');
}

// Limit
$maxattachspace = $vba_dyna->check_perms('attachspace');
if ($maxattachspace AND (!$entryid OR ($entryid AND $vba_dyna->_entry['userid'] == $vbulletin->userinfo['userid'])))
{
	$attach_username = $entry['username'];
	$show['attachmentlimits'] = true;

	$show['totalsize'] = true;

	$attachlimit = fetch_rfilesize($maxattachspace);

	if ($userspace['used'])
	{
		$attachsize = round(($userspace['used'] / $maxattachspace) * 100);

		$totalsize = (100 - $attachsize) . '%';
		$attachsize = $attachsize . '%';

		$attachsum = fetch_rfilesize($userspace['used']);
		$show['currentsize'] = true;
	}
	else
	{
		$totalsize = '100%';

	}
}

// ##### Inputs

// Normal
$attachinput = '';
$vba_options['dyna_attachinputs'] = intval($vba_options['dyna_attachinputs']);

if ($vba_options['dyna_attachinputs'])
{
	$inputlimit = min($vba_options['dyna_attachmax'] - $totallimit, $vba_options['dyna_attachinputs']);
	for ($boxcount = 0; $boxcount < $inputlimit; $boxcount++)
	{
		$show['attachfile'] = true;
		$show['attachoption'] = true;
		eval('$attachinput .= "' . fetch_template(ADV_DYNA_PREFIX . '_newattachment_inputbit') . '";');
	}
}

// URL
$attachurlinput = '';
$vba_options['dyna_attachinputs_url'] = intval($vba_options['dyna_attachinputs_url']);

if ($vba_options['dyna_attachinputs_url'] AND ini_get('allow_url_fopen'))
{
	$urllimit = min($vba_options['dyna_attachmax'] - $totallimit, $vba_options['dyna_attachinputs_url']);

	for ($boxcount = 0; $boxcount < $urllimit; $boxcount++)
	{
		$show['attachoption'] = true;
		$show['attachurl'] = true;
		$attachurlinput .= '<input type="text" name="attachurl[' . $boxcount . ']" size="25" class="bginput" value="" /><br />';
	}
}

// FTP
if ((defined('CAN_FTP_ATTACH') OR $vba_dyna->check_cat_perms('canftpattach')) AND $vba_options['dyna_attachmax'] > $totallimit)
{
	$ftppath = $vba_options['dyna_attach_ftppath'] . '/' . $vbulletin->userinfo['userid'];

	$vbulletin->templatecache['newattachment'] = str_replace(
		'".(($show[\'attachmentlist\'])',
		$vbulletin->templatecache[ADV_DYNA_PREFIX . '_newattachment_ftpbit'] . '".(($show[\'attachmentlist\'])',
		$vbulletin->templatecache['newattachment']
	);
}

// ##### Attachment types
if (!empty($vba_image->_extcache))
{
	foreach ($vba_image->_extcache AS $ext => $extension)
	{
		exec_switch_bg();

		$extension['size'] = ($extension['size']) ? fetch_rfilesize($extension['size']) : '-';
		$extension['width'] = ($extension['width']) ? vb_number_format($extension['width']) : '-';
		$extension['height'] = ($extension['height']) ? vb_number_format($extension['height']) : '-';

		eval('$attachkeybits .= "' . fetch_template('newattachment_keybit') . '";');
	}
}

// Replace template
$vbulletin->templatecache['newattachment'] = str_replace(
	array(
		'<input type=\"hidden\" name=\"t\" value=\"$threadid\" />',
		'if (haveupload)'
	),
	array(
		'<input type=\"hidden\" name=\"entryid\" value=\"$entryid\" />',
		"if (formobj.ftpupload.checked)\r\n{\r\n haveupload = true;\r\n}\r\n if (haveupload)"
	),
	$vbulletin->templatecache['newattachment']
);

($hook = vBulletinHook::fetch_hook('vba_dyna_newattachment_manageattach')) ? eval($hook) : false;

$show['updateparent'] = true;

eval('print_output("' . fetch_template('newattachment') . '");');

?>